/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = VVXGAP.H
 *
 * DESCRIPTIVE NAME = Virtual Video Private Definitions for the XGA
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION  VXGA.SYS private constants, types, and function prototypes
 *
 * FUNCTIONS    None
 *
 * NOTES
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/


#define PROPERTIES                      /* include properties support         */

#include <int2f.h>                      /* Also                               */
#define INT2F_SYSBGND   0x4001          /*     defined                        */
#define INT2F_SYSFGND   0x4002          /*            in VVDP.H               */
#define ADAPTER_XGA      9              /*                                    */

#define MAX_HRES        1024
#define MAX_VRES        1024

#define MAX_VDM_WAIT    15000           /* max screen-switch delay (ms)              */

#define NVRAMPAGES      1024            /* 1024 page table entries(4M/4K)     */

#define ROMADDRSTART    0xC0000         /* start @ for ROM w/mem mapped regs  */

#define XGA_INSTANCES    8

#define VGA_VRAM_START     EGAVGAMEM_START                             /*            */
#define VGA_VRAM_LEN       EGAVGAMEM_LEN/2                             /*            */

#define POS_BASE_ADDRESS   0x0100
#define PORT_POS_ID        0x0100
#define PORT_POS_102       0x0102
#define PORT_PLANAR        0x0094
#define PORT_SLOT          0x0096

#define PORT_SETUP_MODE    0x00DF

#define BASE_IO_ADDR       0x210A
#define MONITOR_ID_ADDR    0x0052

#define VIDEO_ON           0x20
#define VIDEO_OFF          0x0

#define PLANAR             7
#define MAX_SLOT           16

#define XGA_ID_UPPER       0x8fdb
#define XGA_ID_LOWER       0x8fd8
#define INDEX_SELECT       0x0a
#define INDEX_DATA         0x0b

 /*
 ** Global VDM constants (see glVDMXGA)
 */

#define VDM_RESTORE        0x00000001

#ifdef SETMODE_SUPPORT

 /*
 ** Internally defined modes
 */

#define MODE_1024x768   0
#define MODE_640x480x4  1
#define MODE_640x480x8  2

#define MAX_MODES       3
#define MAX_INITREGS    10

#endif

#define VDHMM_INVALID

 /* Per-VDM Video VDD flags (see flVDMXGA)
 **
 ** The DEVOWNER bit is set as long as the VDD owns the device (ie,
 ** is responsible for I/O trapping, buffer save/restore, etc).  It can be
 ** cleared if another VDD requests the adapter from us, and set when the
 ** adapter is given back.  This is to allow other VDDs to extend the
 ** functionality of our VDD if they have extended modes that they need to
 ** manage themselves.
 */

#define VDM_RESTORE           0x00000001   /* restore in progress             */
#define VDM_DEVOWNER          0x00000002   /* VDD owns device for this VDM    */
#define VDM_FGND              0x00000008   /* VDM foreground (owns screen)    */
#define VDM_LOCKED            0x00000010   /* entire VDM memory space locked down         */
#define VDM_HOOKED            0x00000020   /* mem mapped pg faults were installed         */
#define VDM_MMIOINIT          0x00000040   /* mem mapped IO initialization is done        */
#define VDM_IOINIT            0x00000080   /* VDM I/O initialization is done  */
#define VDM_IOOWNED           0x00000800   /* I/O ownership flag              */
#define VDM_IOWAKEME          0x00001000   /* I/O ownership notify flag       */
#define VDM_PMXGA             0x00002000   /* PM in XGA mode                              */
#define VDM_GOINGDOWN         0x00004000   /* VDM terminating                 */
#define VDM_NOTDONE           0x00008000   /* create setup not ready for map/unmap        */
#define VDM_640KMAPPED        0x00010000   /* all 640K are accounted for                  */
#define VDM_FROZEN            0x00020000   /* We have suspended VDM           */
#define VDM_BLOCKED           0x00040000   /* We have blocked VDM I/O         */
#define VDM_OPMODEXGA         0x00080000   /* first hit on adapter to set XGA             */
#define VDM_FG_CONTEXTHOOK    0x00400000   /* VDMFGContext hook is armed      */
#define VDM_INT4B             0x02000000   /* Int4B notification received                 */
#define VDM_BG_CONTEXTHOOK    0x04000000   /* VDMBGContext hook is armed      */
#define VDM_INT2F_CONTEXTHOOK 0x08000000   /* VDMInt2FContext hook is armed               */
#define VDM_GETLIMMEM         0x10000000   /* looking for LIM memory          */
#define VDM_INT2FWAKEME       0x20000000   /* Int 2F/10 completion flag       */
#define VDM_INT2F             0x40000000   /* Enable Int 2Fh notification     */
#define VDM_IOTRAPPED         0x80000000   /* trapping enabled at all times   */

#define INVALID_HVDM    ((HVDM)-2)

typedef LONG (PRIVENTRY *PSYSFUN)(HVDM, ULONG, PVOID, ULONG, PVOID);
typedef LONG (PRIVENTRY *PDEVFUN)(HVDM);

typedef HVDHSEM HEVSEM;
typedef HVDHSEM HMXSEM;

//c-begin
#define CreateEventSem(phev) \
            VDHCreateSem(phev, VDH_EVENTSEM)
#define DestroyEventSem(hev) \
            VDHDestroySem(hev)
#define ResetEventSem(hev) \
            VDHResetEventSem(hev)
#define PostEventSem(hev) \
            VDHPostEventSem(hev)
#define WaitEventSem(hev) \
            VDHWaitEventSem(hev, SEM_INDEFINITE_WAIT)
#define CreateMutexSem(phmx) \
            VDHCreateSem(phmx, VDH_MUTEXSEM)
#define DestroyMutexSem(hmx) \
            VDHDestroySem(hmx)
#define RequestMutexSem(hmx) \
            VDHRequestMutexSem(hmx, SEM_INDEFINITE_WAIT)
#define ReleaseMutexSem(hmx) \
            VDHReleaseMutexSem(hmx)

/* macro to lock down memory */
#define LOCKMEM(laddr, cpages) VDHLockMem(laddr, (cpages*4096), \
                                          VDHLM_16M, \
                                          (struct pagelist_s *)-1, \
                                          (ULONG *)-1)

/* ** macro to copy 8 4K pages of memory **                                   */
/* #define  MEMCOPY(pSrc, pDst) memcpy(pSrc, pDst, 32768)                     */

 /*
 ** macro to issue popup when out of memory
 */

#define POPUP(resp_val) \
                     VDHPopup(                                              \
                              (PSZZ)NULL,                                   \
                              (ULONG)NULL,                                  \
                              (ULONG)ERROR_XGA_OUT_MEMORY,                  \
                              (PULONG)&resp_val,                            \
                              (ULONG)VDHP_TERMINATE_SESSION,                \
                              (PSZ)NULL);
//c-     end


 /*
 ** LIM Page Table structure
 **
 ** This structure contains the format of an entry in the table as it is
 ** added on a map notification.
 */

typedef struct tlbmaps {        /* map/unmap LIM table                        */

    PBYTE  MapAddr;             /* address to map                             */
    ULONG  MapPages;            /* #pages to map                              */
    HLOCK  MapHandle;           /* locked handle of mapped area               */
} TBLMAP_S;


 /*
 ** Coprocessor structure
 **
 ** This structure defines fields for each instance of XGA coprocessor
 */

typedef struct cop_s {           /* for each XGA instance                     */

    ULONG  PageDirBaseAddr;      /* Page Directory Base Address               */
    ULONG  CurVirtAddr;          /* Current Vitual Address                    */
                                 /*   valid only if a page fault is           */
                                 /*   by the coprocessor accessing            */
                                 /*   SYSTEM or VRAM                          */
    ULONG  NotUsedA;
    UCHAR  StateLenA;            /* Coprocessor State Length A (# of DWORDs)  */
    UCHAR  StateLenB;            /* Coprocessor State Length B (# of DWORDs)  */
    USHORT NotUsedB;
    UCHAR  NotUsedC;
    UCHAR  CopCntrl;             /* Coprocessor Control (SAVE/RESTORE state)  */
    UCHAR  PixMapIndex;          /* Pixel Map Index                           */
    UCHAR  NotUsedD;
    ULONG  PixMapBase;           /* Pixel Map Base Pointer                    */
    USHORT PixMapWidth;          /* Pixel Map Width                           */
    USHORT PixMapHeight;         /* Pixel Map Height                          */
    UCHAR  PixMapFormat;         /* Pixel Map Format                          */
    UCHAR  NotUsedE;
    USHORT NotUsedF;
    USHORT ErrorTerm;            /* Bresenham Error Term                      */
    USHORT NotUsedG;
    USHORT K1;                   /* Bresenham K1                              */
    USHORT NotUsedH;
    USHORT K2;                   /* Bresenham K2                              */
    USHORT NotUsedI;
    ULONG  DirectionSteps;       /* Direction Steps for line draw             */
    ULONG  NotUsedJ;
    ULONG  NotUsedK;
    ULONG  NotUsedL;
    ULONG  NotUsedM;
    ULONG  NotUsedN;
    ULONG  NotUsedO;
    UCHAR  FgndMix;              /* Foreground Mix                            */
    UCHAR  BgndMix;              /* Background Mix                            */
    UCHAR  DestColorCompCond;    /* Destination Color Compare Condition       */
    UCHAR  NotUsedP;
    ULONG  DestColorCompValue;   /* Destination Color Compare Value           */
    ULONG  PixBitMask;           /* Pixel Bit Mask                            */
    ULONG  CarryChainMask;       /* Carry Chain Mask                          */
    ULONG  FgndColor;            /* Foreground Color                          */
    ULONG  BgndColor;            /* Background Color                          */
    USHORT OpDimWidth;           /* Operation Dimension 1                     */
    USHORT OpDimHeigth;          /* Operation Dimension 2                     */
    ULONG  NotUsedQ;
    ULONG  NotUsedR;
    USHORT MaskMapOriginX;       /* Mask Map Origin X Offset                  */
    USHORT MaskMapOriginY;       /* Mask Map Origin Y Offset                  */
    USHORT SourceMapX;           /* Source Map X Address                      */
    USHORT SourceMapY;           /* Source Map Y Address                      */
    USHORT PatternMapX;          /* Pattern Map X Address                     */
    USHORT PatternMapY;          /* Pattern Map Y Address                     */
    USHORT DestMapX;             /* Destination Map X Address                 */
    USHORT DestMapY;             /* Destination Map Y Address                 */
    USHORT PixOpLo;              /* Pixel Operation                           */
    USHORT PixOpHi;

}COP_S;


 /*
 ** XGA structure
 **
 ** This structure defines fields for each instance of XGA.
 */

typedef struct xgaenv_s {        /* for each XGA instance                     */

    ULONG  OneMegAperture;       /* 1M aperture                               */
    ULONG  VRAMAddr;             /* video memory base address                 */
    PBYTE  pVRAMAddr;            /* Linear addr to the XGA's VRAM             */
    PBYTE  VRAMPTAddr;           /* VRAM Page Table linear address            */
    HLOCK  VRAMPTHandle;         /* VRAM Page Table lock handle               */
    ULONG  ROMAddr;              /* start of ROM address range (ROS + $K)     */
    ULONG  COPAddr;              /* Coprocessor base address                  */
    ULONG  pCOPAllocAddr;        /* Allocated addr to the Coprocessor's MMIO regs     */
    COP_S* pCOPAddr;             /* Linear addr to the Coprocessor's MMIO regs        */
    USHORT DupROMAddr;           /* indicates commonly shared ROM address     */
    USHORT IORegBase;            /* IO register base address                  */
    CHAR   flVRAM_1Meg;          /* flag TRUE=1Mb, FALSE=0.5Mb                */
    BYTE   Auto_Config;          /* R/O Index Register                        */
    BYTE   Monitor_ID_DAC_Comp;  /* R/O Index Register                        */
    BYTE   Mystery_Reg;          /* R/O Index Register query by AFI           */
    BYTE   Display_Control1;     /* MOD 90 BIOS workaround                            */
    BYTE   External_Clock_Select;/* MOD 90 BIOS workaround                            */
    BYTE   Misc_Control1;        /* XGA-2 uses this                           */
    USHORT Monitor_type;         /* monitor attached to this XGA              */

    struct VDHMapSource_s MapSource;  /* physical mem mapped regs           */
/*    ULONG  vdhms_laddr;           linear address of source memory object  */
/*    ULONG  vdhms_hobj;            memory object handle                    */

    struct VDHMapTarget_s MapTarget;  /* target linear addr in VDM          */
/*    ULONG  vdhmt_laddr;           Target address in V86-space (0 <=       */
/*                                  vdhmt_laddr < 1M+64K)  to be mapped.    */
/*    ULONG  vdhmt_cpg;               count of pages to map                 */
/*    ULONG  vdhmt_hmap;            handle of mapping.  Must be zero on     */
/*                                    first call to VDHMapPages for region. */

}XGAENV_S;

#define XGAENVSIZE   sizeof(XGAENV_S)  /* XGAENV structure size               */


typedef struct vvxgareg_s {     /* for interim settings (for byte I/O)        */
    BYTE    abregXGAIRData[IRINDX_INDXTOTAL];
    BYTE    abregXGAIOReg[AXGA_TOTAL];
} VVXGAREGS;

 /*
 ** Per-VDM data
 */

typedef struct vdmdata_s {       /* beginning of PERVDMDATA structure         */

 /*
 ** The following block of variables must be kept contiguous and in sync
 ** with how VVXGA.C initializes them when this structure is declared.
 */

BOOL    flVDMXGA;                /* per-VDM flags (see VDM_* constants)       */
SHORT   nSaveRestoreConfig;      /* Save/Restore configuration for the VDM    */
TBLMAP_S *TblMap;                /* table containing list of areas to map     */
ULONG   TblPages;                /* size of map table                         */
INT     TblEntriesPresent;       /* #entries currently in map table           */
PBYTE   pBuffer;                 /* pointer to pixel save/restore buffer      */
PBYTE   Palette_Buf;             /* address of palette save/restore buffer    */
SHORT   nXGAin132ColConfig;      /* current 132 column mode configuration     */
SHORT   nXGAinVGAConfig;         /* XGA configuration currently setup as VGA  */
PLONG   DOSPTLinAddr;            /* DOS page table linear address             */
HLOCK   hlockDOSPT;              /* 640K DOS Page Table                               */
INT     nApertureEnabled;        /* # of 64K Aperture enabled (1 per XGA)     */
DMAREQINFO dmaReqInfo;           /* structure to register int4b@ with vdma           */
struct  VDHMapSource_s ApertSource[XGA_INSTANCES];  /* Aperture source        */
struct  VDHMapTarget_s ApertTarget[XGA_INSTANCES];  /* Aperture target        */
VVXGAREGS vXGARegs[XGA_INSTANCES];  /* XGA I/O Register shadow                */

 /*
 ** end of per VDM initialized variables
 */


PBYTE   Sprite_Buf;              /* address of sprite save/restore buffer     */
PBYTE   State_Buf;               /* address of co-proc state save/restore buffer      */

HVDM    hvdmXGA;                 /* handle for this VDM                       */
ULONG   sgIDXGA;                 /* screen group # for this VDM               */

HMXSEM  hmxXGAState;             /* semaphore for internal state              */
HMXSEM  hmxXGAMapSem;            /* semaphore to serialize map/unmap notification     */
HEVSEM  hevXGAWakeUp;            /* semaphore for bgnd sleeping/fgnd wakeup   */
HEVSEM  hevXGALIMMem;            /* wake-up event to continue processing LIM request  */
HEVSEM  hevXGAFGevent;           /* tell FG to go on after trying to get storage      */
HHOOK   hhookVDMFGContext;       /* hook handle for VXGAVDMFGContext          */
HHOOK   hhookVDMBGContext;       /* hook handle for VXGAVDMBGContext          */
HHOOK   hhookInt10Context;       /* hook handle for VXGAInt10Context          */
HHOOK   hhookInt10Ret;           /* hook handle for VXGAInt10Return           */
INT     npgBuffer;               /* current size of the save/restore buffer   */
INT     npgBufferReq;            /* required size of the save/restore buffer  */
INT     TblEntries;              /* #entries in map table                     */
/*HLOCK   hlockDOSPT;               640K DOS Page Table                               */
USHORT  DCMode;                  /* Direct Color Mode save/restore indicator  */
USHORT  nNumPending;             /* # Interrupts pending                      */

VVMODE  vvmXGA;                  /* mode data for XGA                         */
ULONG   mmr_hmap[XGA_INSTANCES]; /* VDHMapPages handles for mem map regs              */

} PERVDMDATA;                    /* end of PERVDMDATA structure               */

typedef PERVDMDATA *PVDMDATA;

#define TBLENTRYSIZE  sizeof(TBLMAP_S)   /* LIM map entry size                */

//masm-begin
//DefData IMPORT,INSTANCE,C
//PERVDMDATA VXGAData
//VDMData catstr VXGAData
//EndData
//masm-end

//c-begin
#pragma BEGIN_SWAP_INSTANCE
extern  PERVDMDATA VXGAData;
#define VDMData VXGAData
#pragma END_SWAP_INSTANCE
//c-end


 /*
 ** Private function prototypes
 */

 /*
 ** vvXGA.c
 */

BOOL    EXPENTRY  VDDInit(PSZ);
BOOL    EXPENTRY  VXGACreate(HVDM);
VOID    EXPENTRY  VXGACreateDone(HVDM);
VOID    PRIVENTRY VXGAInitRegs(VOID);
BOOL    EXPENTRY  VXGASetFgnd(HVDM);
VOID    EXPENTRY  VXGASetBgnd(HVDM);
VOID    EXPENTRY  VXGADestroy(HVDM);
VOID    HOOKENTRY VXGAVDMFGContext(PVOID, PCRF);
VOID    HOOKENTRY VXGAVDMBGContext(PVOID, PCRF);
#ifdef OLD_PROPERTIES
ULONG   EXPENTRY  VXGASetIOTrapping(ULONG, HVDM, ULONG, PSZ);
#endif
BOOL    PRIVENTRY vXGALockVDM(HVDM, BOOL);
BOOL    PRIVENTRY vXGAPDFixUp(HVDM, XGAENV_S*);
VOID    PRIVENTRY vXGASetIOHooks(VOID);
VOID    PRIVENTRY vXGAAddEvent(HVDM, INT, PVOID, FLAGS);
VOID    PRIVENTRY vXGADeleteEvent(HVDM, INT);
VOID    PRIVENTRY vXGARestoreIOState(HVDM);
BOOL    PRIVENTRY vXGATransferBuffer(HVDM, XGAENV_S*, BOOL);
BOOL    PRIVENTRY vXGACheckVRAM(PBYTE);
BOOL    PRIVENTRY vXGA64KcheckVRAM(USHORT);                     /*            */
VOID    PRIVENTRY vXGADisableDisplay(HVDM);
VOID    PRIVENTRY vXGAEnableDisplay(HVDM);
VOID    PRIVENTRY vXGAEnableVGA(HVDM);
BOOL    PRIVENTRY vXGAGrowBuffer(HVDM);
VOID    PRIVENTRY vXGAShrinkBuffer(HVDM);
PBYTE   PRIVENTRY vXGAAllocTbl(HVDM);
VOID    PRIVENTRY vXGAFree(VOID);
VOID    PRIVENTRY vXGAInitPaging(XGAENV_S*);
BOOL    PRIVENTRY vXGAInitMap(HVDM);
VOID    HOOKENTRY VXGAMapHndlr(HVDM, ULONG, ULONG, ULONG);
VOID    HOOKENTRY VXGAUnMapHndlr(HVDM, ULONG, ULONG, ULONG);
VOID    PRIVENTRY vXGAGetLIMMem(HVDM, TBLMAP_S*);
VOID    HOOKENTRY VXGAPgFaultHndlr(PVDM);
VOID    HOOKENTRY vXGAPopupErr(VOID);
VOID    PRIVENTRY vXGAUpdateShieldState(HVDM);
VOID    PRIVENTRY vXGALockIO(HVDM);
VOID    PRIVENTRY vXGASaveRestoreIOReg(HVDM, XGAENV_S*);
VOID    PRIVENTRY vXGASaveRestore132(HVDM);
VOID    PRIVENTRY vXGAVideoState(HVDM, XGAENV_S*);
VOID    PRIVENTRY vXGAVideoEnable(HVDM, XGAENV_S*, BOOL);
VOID    PRIVENTRY vXGAWaitForCoProReady(COP_S*);
VOID    PRIVENTRY vXGAInitHog(HVDM, ULONG, XGAENV_S*);
VOID    PRIVENTRY vXGAHogSuspend(HVDM);
VOID    PRIVENTRY vXGAHogTerminate();
VOID    PRIVENTRY vXGAGetPalette(HVDM);

LONG    EXPENTRY  VXGASysReqProc(SGID, ULONG, ULONG, PVOID, ULONG, PVOID);
LONG    PRIVENTRY vXGASysQueryMode(HVDM, ULONG, PVOID, ULONG, PVVMODE);
LONG    PRIVENTRY vXGASysQueryCursor(HVDM, ULONG, PVOID, ULONG, PVVCURSOR);
LONG    PRIVENTRY vXGASysQueryPalette(HVDM, ULONG, PVOID, ULONG, PRGB);
LONG    PRIVENTRY vXGASysCopyLVB(HVDM, ULONG, PRECTL, ULONG, PBYTE);
LONG    PRIVENTRY vXGASysCopyBitmap(HVDM, ULONG, PVVRECT, ULONG, PBYTE);
LONG    EXPENTRY  VXGADevReqProc(HVDM, ULONG, PVOID, PVOID);
LONG    PRIVENTRY vXGADevWindowsDeskTop(HVDM, BOOL);            /*            */
VOID    PRIVENTRY vXGAUnlockIO(HVDM);
BOOL    PRIVENTRY vXGAEnterIO(ULONG, ULONG);
VOID    PRIVENTRY vXGAExitIO(VOID);

BOOL    PRIVENTRY vXGALockVDM(HVDM, BOOL);

BYTE    HOOKENTRY VXGAReadOpMode(ULONG, PCRF);
VOID    HOOKENTRY VXGAWriteOpMode(BYTE, ULONG, PCRF);

BYTE    HOOKENTRY VXGAReadApertureCntl(ULONG, PCRF);
VOID    HOOKENTRY VXGAWriteApertureCntl(BYTE, ULONG, PCRF);

BYTE    HOOKENTRY VXGAReadReserved(ULONG, PCRF);
VOID    HOOKENTRY VXGAWriteReserved(BYTE, ULONG, PCRF);

BYTE    HOOKENTRY VXGAReadIntEnable(ULONG, PCRF);
VOID    HOOKENTRY VXGAWriteIntEnable(BYTE, ULONG, PCRF);

BYTE    HOOKENTRY VXGAReadIntStatus(ULONG, PCRF);
VOID    HOOKENTRY VXGAWriteIntStatus(BYTE, ULONG, PCRF);

BYTE    HOOKENTRY VXGAReadVirtMemCntlr(ULONG, PCRF);
VOID    HOOKENTRY VXGAWriteVirtMemCntlr(BYTE, ULONG, PCRF);

BYTE    HOOKENTRY VXGAReadVirtMemIntStatus(ULONG, PCRF);
VOID    HOOKENTRY VXGAWriteVirtMemIntStatus(BYTE, ULONG, PCRF);

BYTE    HOOKENTRY VXGAReadApertureIndex(ULONG, PCRF);
VOID    HOOKENTRY VXGAWriteApertureIndex(BYTE, ULONG, PCRF);

BYTE    HOOKENTRY VXGAReadMemAccess(ULONG, PCRF);
VOID    HOOKENTRY VXGAWriteMemAccess(BYTE, ULONG, PCRF);

BYTE    HOOKENTRY VXGAReadIndex(ULONG, PCRF);
VOID    HOOKENTRY VXGAWriteIndex(BYTE, ULONG, PCRF);
VOID    HOOKENTRY VXGAWriteIndexWord(WORD, ULONG, PCRF);

BYTE    HOOKENTRY VXGAReadIndexDataByte(ULONG, PCRF);
VOID    HOOKENTRY VXGAWriteIndexDataByte(BYTE, ULONG, PCRF);
WORD    HOOKENTRY VXGAReadIndexDataWord(ULONG, PCRF);
VOID    HOOKENTRY VXGAWriteIndexDataWord(WORD, ULONG, PCRF);

ULONG   HOOKENTRY VXGARWIndexDataDWord(ULONG, PBYTE, ULONG, ULONG, PCRF);

VOID    EXPENTRY  VXGAInt2FHandler(HVDM, ULONG, PCRF);          /*            */
LONG    EXPENTRY  VXGAInt4BHandler(HVDM, ULONG, PVOID, PVOID);  /*            */
VOID    HOOKENTRY VXGAInt10Context(PVOID, PCRF);
VOID    HOOKENTRY VXGAInt10Return(PVOID, PCRF);

 /* Random macro support
 **
 **  If VDDSTRICT is defined, the Assert macros generate appropriate code.
 **
 **  If VDDSTRICT is not defined, the Assert macros are NO-OPs (with the
 **  exception of AssertRC, in which case the function is still called, but
 **  the return code is not checked).
 **
 *(  If VDDDEBUG is defined, debug printfs (PRINTDEBUGs) are generated, and
 **  failed assertions (assuming VDDSTRICT is defined) break at the assertion
 **  rather than in the kernel's "panic" service.  VDDDEBUG requires the
 **  kernel debugger, in other words.
 **
 **  If VDDDEBUG is not defined, debug printfs (PRINTDEBUGs) are NOT
 **  generated, and failed assertions (assuming VDDSTRICT is defined) simply
 **  panics.
 */

//masm-begin
//dword_s struc
//  lo dw ?
//  hi dw ?
//dword_s ends
//masm-end


#ifdef VDDSTRICT

//c-begin
extern CHAR szAssertMsg[];
#define MODNAME static CHAR szFile[]

#ifdef VDDDEBUG
#define Assert(t) { \
                    if (!(t)) { \
                      PRINTDEBUG(szAssertMsg, szFile, __LINE__); \
                      INT3(); \
                    } \
                  }
#else
#define Assert(t) { \
                    if (!(t)) { \
                      PANIC(szAssertMsg, szFile, __LINE__); \
                    } \
                  }
#endif

#define AssertTRUE(t)   Assert(t)
#define AssertFALSE(t)  Assert(!(t))
#define AssertZERO(t)   Assert(!(t))
#define AssertNONZERO(t)Assert(t)
#define AssertERROR()   Assert(FALSE)
#define AssertRC(t)     Assert(t)       /* verify function return code good   */
//c-end

//masm-begin
//?ASSERT macro   cond,msg,args
//        local   l1
//        ifnb    <cond>
//        j&cond  short l1
//        endif
//        ifdef   VDDDEBUG
//        DBPRINT <msg>,<args>
//        int 3
//        else
//        PANIC   <msg>,<args>
//        endif
//        ifnb    <cond>
//l1:
//        endif
//        endm
//masm-end

#else

//c-begin
#define Assert(t)
#define AssertTRUE(t)
#define AssertFALSE(t)
#define AssertZERO(t)
#define AssertNONZERO(t)
#define AssertERROR()
#define AssertRC(t)     (t)             /* perform function, but don't verify */
//c-end

//masm-begin
//?ASSERT macro cond,msg,args
//        endm
//masm-end
#endif

//masm-begin
//ASSERT   equ   <?ASSERT ,>
//ASSERTC  equ   <?ASSERT c,>
//ASSERTNC equ   <?ASSERT nc,>
//ASSERTZ  equ   <?ASSERT z,>
//ASSERTNZ equ   <?ASSERT nz,>
//ASSERTE  equ   <?ASSERT e,>
//ASSERTNE equ   <?ASSERT ne,>
//ASSERTB  equ   <?ASSERT b,>
//ASSERTBE equ   <?ASSERT be,>
//ASSERTA  equ   <?ASSERT a,>
//ASSERTAE equ   <?ASSERT ae,>
//masm-end


 /*
 ** Random debugging support
 */

#ifdef VDDDEBUG

//c-begin
extern CHAR szModule[];
extern CHAR *apszPageStates[];

#undef  PRINTDEBUG

#define PRINTDEBUG   printf(szModule); printf
#define PRINTDEBUGa  printf(szModule); printf  /* PRINTDEBUG with argument    */
#define PRINTDEBUGc  printf             /* Continued PRINTDEBUG with argument */

/* Maybe someday...                                                           */
/* #undef  INB                                                                */
/* #define INB(p)      vvINB(p)                                               */
/* #undef  OUTB                                                               */
/* #define OUTB(p,b)   vvOUTB(p,b,NULL)                                       */
/* #undef  OUTW                                                               */
/* #define OUTW(p,w)   vvOUTW(p,w,NULL,NULL)                                  */
//c-end

//masm-begin
//DefData IMPORT,INSTANCE,C
//SZ szModule
//EndData
//
//DBPRINT macro msg,args
//        PRINTDEBUG <szModule>
//        PRINTDEBUG <msg>,<args>
//        endm
//masm-end

#else

//c-begin

#undef  PRINTDEBUG

#define PRINTDEBUG(x)
#define PRINTDEBUGa(x,a)                /* PRINTDEBUG with argument           */
#define PRINTDEBUGc(x,c)                /* Continued PRINTDEBUG with argument */

//c-end

//masm-begin
//DBPRINT macro msg,args
//        endm
//masm-end

#endif
