/**********************************************************************
 *
 * SOURCE FILE NAME = VVDP.H
 *
 * DESCRIPTIVE NAME = Virtual Video Private Definitions
 *
 * Copyright : COPYRIGHT IBM CORPORATION, 1991, 1992
 *             LICENSED MATERIAL - PROGRAM PROPERTY OF IBM
 *             REFER TO COPYRIGHT INSTRUCTION FORM#G120-2083
 *             RESTRICTED MATERIALS OF IBM
 *             IBM CONFIDENTIAL
 *
 * VERSION = V2.0
 *
 * DATE      11/10/88
 *
 * DESCRIPTION  VVD private constants, types, and function prototypes
 *
 * FUNCTIONS    None
 *
 * NOTES
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
 * CHANGE ACTIVITY =
 *   DATE      FLAG        APAR   CHANGE DESCRIPTION
 *   --------  ----------  -----  --------------------------------------
 *   04/22/91  @V2.0TPL01         XGA enhancements to control whether
 *                                VGA should save/restore the video
 *                                state on a single XGA configuration
 *                                system (i.e.  P75 or PS/2 with monitor
 *                                attached only to the XGA) where the
 *                                XGA boots up in VGA mode.
 *   05/09/91  @V2.0TPL02         fix PM video corruption when session
 *                                switch back to PM while the VDM in a
 *                                multi-plane graphics mode.  (B790553,
 *                                B722596)
 *   05/23/91  @V2.0TPL03         Reenable video on destruction of a
 *                                VDM not successfully created.
 *                                (B714830)
 *   06/13/91  @V2.0TPL04         B723811 - Avoid arming the TimerEvent
 *                                          hook routine more than once.
 *   06/20/91  @V2.0TPL05         Fix video corruption problem when
 *                                session switch away from PM while
 *                                window VDMs are in the mist of
 *                                updating the off-screen VRAM through
 *                                the PMVDMP thread.
 *   07/18/91  @V2.0TPL06         B767777 On a MPA, save/restore 4K of
 *                                VRAM not the 16k required for EGA/VGA
 *                                MONO emulation.
 *   09/14/91  @V2.0WKB01         Delete window syncronization references
 *                                (tag B726840)
 *   12/19/91  @V2.0WKB02         B731047 - Changed Int 2f code for DPMI
 *                                applications
 *   02/04/92  @V2.0TPL07         B731109 - Use LVB size for validation
 *   02/15/92  @V2.0TPL08         B733006 - Performance enhancement to
 *                                copy routines
 *   02/20/92  @V2.0DRW01         SVGA additions
 *   03/17/92  @V2.0TPL09         B728098 - Complete VDM codepage support
 *   03/27/92  @V2.0TPL10         B735007 - avoid screen corruption on
 *                                          Starlight
 *   05/15/92  @V2.0TPL11         SM11856 - changes for 32-bit DISPLAY
 *                                          driver
 *   05/18/92  @V2.0TPL12         Add event for DDE support
 *   07/09/92  @V2.0TPL13         IBM SVGA enhancements
 *   07/14/92  @V2.0DRW02         xxxxxxx - Edit video tables prototype
 *             @V2.0XXX01         Unknown
 *             @V2.0XXX02         Unknown
 *             @V2.0XXX03         Unknown
 *   09/25/92  @V2.0WKB03  53355  Search through install drives for
 *                                svgadata.pmi
 *   09/18/92  @V2.0TPL14  24801  Track recursive INT 10 calls
 *   09/28/92  @V2.0SEN01  53954  Number of lock commands increased
 *   10/16/92  @V2.0DRW03         Background virtualisation support.
 *   10/29/92  @V2.0SEN02  53954  Save/restore lock state changes.
 *   11/06/92  @V2.0DRW04  55199  Add HVDM to GetLockState().
 *   11/10/92  @V2.0DRW05         Keep track of linear buffer growth
 *   11/11/92  @V2.0DRW06         Shadow state of Orchid Clock select reg 3DD
 *   11/17/92  @V2.0SEN03  57000  Logical line length added to instance data and VRAMSize to global data.
 *   12/04/92  @V2.0WKB01  56883  Don't disable 8514 if not present
 *   12/18/92  @V2.0SEN04         Cirrus Logic support.
 *   12/28/92  @V2.0SEN05         Use chip detection logic in SCREENDD.
 *   12/29/92  @V2.0SEN06         SVGA common definitions moved to SVGADEFS.C.
 *   02/08/93  @V2.0WKB04         Diamond SpeedStar modifications
 *   02/08/93  @V2.0SEN07         New function in vvpage.c
 *   02/15/93  @V2.0SEN08         SVGA INT 2F processing.
 *   02/25/93  @V2.0SEN09  62876  Added another instance flag flVDMX2Video.
 *   03/02/93  @V2.0SEN10  62837  New vvSVGASetBgnd function.
 *   03/08/93  @V2.0SEN11  56402  Don't allow overindexing into ATC on SVGA's.
 *   03/08/93  @V2.0YEE01  63354  Let VVGA know that VXGA is also installed
 *   03/09/93  @V2.0YEE02         Unmap VRAM for VXGA
 *   03/11/93  @V2.0DRW10         Allow IO trapping off in full-screen VDM.
 *   03/30/93  @V2.1SEN12  65283  Let VVGA know that v8514 is also present.
 *   03/31/93  @V2.1SEN13  64902  SVGA port trap list constant.
 *   04/02/93  @V2.1SEN14  65532  PrepareForTransfer.
 *   04/26/93  @V2.0JWK61  62914  Invalid Hook Handle
 *   06/04/93  @V2.1SEN15 F69306  Add support for S3
 *   06/17/93  @V2.1YEE03  70710  Hi-color support for S3
 *   06/24/93  @V2.1TPL15  70168  Add vvDisableVRAM routine
 *   10/06/93  @V2.1YEE04  72687  Support Number Nine adapters with S3
 *   10/22/93  @V2.1YEE05  73003  Save/Restore DAC for hi-color modes on S3
 *   11/02/93  @V2.1RSM01  75458  S3 Merge
 *   12/22/93  Changeteam  75466  Added debug routine prototype vvDebugSaveInfo
 *                                (to fix build break defect #76938).
 *   03/15/94  @V2.1MNH03 D80820  Trap WD accelerator registers
 *   04/14/94  @V2.1MNH05 D81883  Use vvCrtcPort instead of PORT_COLR*
 *   04/14/94  @V2.1MNH06 D82048  WD90C24 lock regs so BIOS works correctly!
 *   04/14/94  @V2.1MNH08 D       Arrange to be more object oriented
 *   05/12/94  @V2.1MNH12 D83005  WD90C24 Windows FS black scrn when switching
 *   05/12/94  @V2.1MNH13 F74819  ATIMach32 declare accelerator types globally
 *   06/22/94  @V2.1JWK01  87031  Tseng W32 support/merge
 *   07/01/94  @V2.1MNH18  88650  Update shadow register for determining packed mode
 *   08/18/94  @V2.1MNH36 D92377  Fix C&T/IsWindow to require enable
 *   08/31/94  @V2.1MNH39 D95540  Fix vvFindMono to work when BIOS vars not set
 *   09/17/94  @V2.2SEN01 D93589  Int 10 restore support + fixes
 *   09/26/94  @V2.2SEN05 D99674  Save/Restore VDM's AX/BX for injected int 10.
 *   09/28/94  @V2.1MNH51 D100507 Add WAITW and increase MAX_CLEANDATA
 *   10/05/94  @V2.2SEN08 D97868  Fixing port and rle flag usage
 *   03/08/95  @V3.0MNH03 D114844 Fix trashing C24 WINDOWS palette storage
 ***********************************************************************/


#define COMPAQ          /* provide built-in Compaq support             */
#define TSENG           /* provide built-in Tseng Labs support         */
#define ATI             /* provide built-in ATI EGA/VGA Wonder support */

#ifdef SVGA
  #define VGA
  #define TSENGW32      /* provide built-in Tseng Accellerator support */ /* V2.1JWK01 */
#include <svgadefs.h>                   /* @V2.0SEN06 */
#endif

#ifdef CGA
  #define CGAEGA        /* define CGAEGA to mean "CGA or EGA"          */
  #define ADAPTER_TYPE  ADAPTER_CGA
#else
  #ifdef EGA
    #define CGAEGA
  #endif
#endif

#ifdef EGA
  #define EGAVGA        /* define EGAVGA to mean "EGA or VGA"          */
  #define ADAPTER_TYPE  ADAPTER_EGA
#else
  #ifdef VGA
    #define EGAVGA
  #endif
#endif

#ifdef VGA
  #define ADAPTER_TYPE  ADAPTER_VGA
#endif

#ifdef MONO
  #define MONOCGA       /* define MONOCGA to mean "MONO or CGA"        */
  #define ADAPTER_TYPE  ADAPTER_MONO
#else
  #ifdef CGA
    #define MONOCGA
  #endif
#endif

#ifndef MONO
#define PROPERTIES      /* include properties support                  */
#endif

//c-begin
#ifdef SVGA                                             /* @V2.2SEN08 */
#undef MAX_CLEANDATA
#define MAX_CLEANDATA    150
#endif                                                  /* @V2.2SEN08 */
//c-end
 /*
 ** Physical constants (non-configurable)
 */

#define BELL    0x07
#define BS      0x08
#define CR      0x0D
#define LF      0x0A
#define ESCAPE  0x1B

/*
** @IBM FLAG: 01-Aug-90  Move video-related INT2F equates to INT2F.H
*/

#include <int2f.h>
#define INT2F_VDMENABLESR       0x4000
#define INT2F_SYSBGND           0x4001
#define INT2F_SYSFGND           0x4002
#define INT2F_VDMENTERCRITSEC   0x4003
#define INT2F_VDMEXITCRITSEC    0x4004
#define INT2F_SYSSAVEREGS       0x4005
#define INT2F_SYSRESTOREREGS    0x4006
#define INT2F_VDMDISABLESR      0x4007


#ifdef MONO
#define VRAM_START      MONOMEM_START
#define VRAM_LEN        (4*1024)    /* true MPA has 4K of VRAM         @V2.0TPL06 */
#define MAX_PLANES      1
#define MAX_PLANESIZE   VRAM_LEN                                     /* @V2.0TPL06 */
#endif

#ifdef CGA
#define VRAM_START      CGAMEM_START
#define VRAM_LEN        CGAMEM_LEN
#define MAX_PLANES      1
#define MAX_PLANESIZE   CGAMEM_LEN
#endif

#ifdef EGAVGA
#define VRAM_START      EGAVGAMEM_START
#define VRAM_LEN        EGAVGAMEM_LEN
#define MAX_PLANES      4
#define MAX_PLANESIZE   (64*1024)
#endif

#ifdef SVGA                     /* This allows us up to 1Meg Video Memory */
/*
** Planar modes are virtualized using page states. We need only up to 1MB
** for planar modes <1280x1024.
** Linear modes are virtualized using bank states. We allow upto 4MB of linear
** shadow.                                      @V2.2SEN01
*/
#define MAX_BANKS               4       /* with 4 planes and 4 banks of 64k each. */
#define MAX_LINEAR_BANKS       64       /* 64 banks of 64k each. allows 4Meg */
#else
#define MAX_BANKS       1
#endif

#define BANK0           0
#define MAX_VGA_BANK    1               /* @V2.2SEN01 */
#define BANKSIZE        (64*1024)       /* banks are 64k bytes @V2.0DRW03 */


//c-begin

#ifdef MAX_PLANESIZE
#define MAX_PAGESPERPLANE PAGESFROMBYTES(MAX_PLANESIZE)
#endif

//c-end


//masm-begin

//MAX_PAGESPERPLANE equ ((MAX_PLANESIZE+PAGESIZE-1)/PAGESIZE)

//masm-end


//c-begin

#define VRAM_PAGES PAGESFROMBYTES(VRAM_LEN)

//c-end


//masm-begin

//VRAM_PAGES equ ((VRAM_LEN+PAGESIZE-1)/PAGESIZE)

//masm-end


 /*
 ** Configurable constants
 */

#define BELL_FREQ       896     /* (hz)                                */
#define BELL_DURATION   125     /* (ms)                                */

#define TICKS_DIRTY     1       /* check for dirt every n ticks (default) */
#define PEEKS_CHECK     10      /* check for events every n peeks      */
#define TIMER_CHECK     125     /* wait 1/8 sec between event checks   */
#define TIMER_DELAY     3000    /* 3000ms (3 sec) maximum update delay */

#define MAX_RTRCLOOP    0x4000  /* maximum # iterations to wait for retrace */

#define MAX_ALTSTACK    256     /* 256 bytes should be sufficient      */

#define MAX_TITLESIZE   13      /* enough space for 8.3 filename + NULL */

#ifdef VGA                                                      /*@V2.1MNH14*/
#define CRTOVFL_VERTDSPEND2 0x40        /* Vert Dsp End bit 9 *//*@V2.1MNH14*/
#define CRTMAXSCAN_LINECMP  0x40                                /*@V2.1MNH14*/
#endif /* VGA */                                                /*@V2.1MNH14*/

#ifdef SVGA
#define MAX_VDM_INT10_WAIT     1500   /* max int 10 restore screen-switch delay (ms) @senja */
#define MAX_VDM_WAIT    10000   /* max screen-switch delay (ms) @V2.0SEN08 @senja */
#define MAX_ENGINE_WAIT  1000   /* wait for engine (ms)         @V2.1SEN15 */
#define MASK_ALL_LOCKED 0xFFFFFFFF                              /*@V2.1MNH06*/

#define DEFAULT_VRAM_SIZE  1024*1024            /* @V2.0SEN03 */

                                /* @V2.1SEN15 S3 support start */
#define A8514_PIXELTRANSFER_EXT 0xE2EA                          /*@V2.1MNH13*/

#define MFINDX_MISCCTRL    0xE000
#define MFINDX_READSEL     0xF000                               /*@V2.1MNH03*/
#define MFREG_INDXODD      0x0008                               /*@V2.1MNH03*/

#define MFREG_MINORAXISCNT   (MFINDX_MINORAXISCNT   >> MFINDX_INDXSHIFT)
#define MFREG_TOPSCISSORS    (MFINDX_TOPSCISSORS    >> MFINDX_INDXSHIFT)
#define MFREG_LEFTSCISSORS   (MFINDX_LEFTSCISSORS   >> MFINDX_INDXSHIFT)
#define MFREG_BOTTOMSCISSORS (MFINDX_BOTTOMSCISSORS >> MFINDX_INDXSHIFT)
#define MFREG_RIGHTSCISSORS  (MFINDX_RIGHTSCISSORS  >> MFINDX_INDXSHIFT)
#define MFREG_PIXELCTRL      (MFINDX_PIXELCTRL      >> MFINDX_INDXSHIFT)
#define MFREG_MISCCTRL       (MFINDX_MISCCTRL       >> MFINDX_INDXSHIFT)
#define MFREG_READSEL        (MFINDX_READSEL        >> MFINDX_INDXSHIFT) /*@V2.1MNH03*/
                                        /* @V2.1SEN15 S3 support end */

#define WD_INDEXPORT             0x23c0                         /*@V2.1MNH03*/
#define WD_DATAPORT              0x23c2                         /*@V2.1MNH03*/
#define WD_BITBLTPORT            0x23c4                         /*@V2.1MNH03*/
#define WD_K1PORT                0x23c8                         /*@V2.1MNH03*/
#define WD_K2PORT                0x23ca                         /*@V2.1MNH03*/
#define WD_ETPORT                0x23cc                         /*@V2.1MNH03*/
#define WD_ENGINEPORT            0x23ce                         /*@V2.1MNH03*/

#define WD_WREGS_INDEX  ((WD_INDEXPORT  & 0x0e) >> 1)
#define WD_WREGS_DATA   ((WD_DATAPORT   & 0x0e) >> 1)
#define WD_WREGS_BITBLT ((WD_BITBLTPORT & 0x0e) >> 1)
#define WD_WREGS_K1     ((WD_K1PORT     & 0x0e) >> 1)
#define WD_WREGS_K2     ((WD_K2PORT     & 0x0e) >> 1)
#define WD_WREGS_ET     ((WD_ETPORT     & 0x0e) >> 1)
#define WD_WREGS_ENGINE ((WD_ENGINEPORT & 0x0e) >> 1)
#define WD_WREGS_BASE   0x10                                    /*@V2.1MNH03*/
#define WD_WREGS_TOTAL  0x50                                    /*@V2.1MNH03*/

#define WD_INDX_NOAUTO           0x1000                         /*@V2.1MNH03*/
#define WD_INDX_BLKINVALID       0x2000                         /*@V2.1MNH03*/
#define WD_INDX_ODD              0x8000 /* Internal use! */     /*@V2.1MNH03*/

#define WD_INDX_INDX             0x0f                           /*@V3.0MNH03*/
#define WD_INDX_MASK             0xf000                         /*@V2.1MNH03*/
#define WD_INDX_SHIFT            4                              /*@V3.0MNH03*/
#define WD_BLK_SHIFT             4                              /*@V2.1MNH03*/

/* MAX_CLEANDATA is too short by about 30 */                    /*@V2.1MNH51*/
#define AHWCMDSVGASIZE ((MAX_LOCKUNLOCKCMD * 2) + MAX_CLEANDATA + 30 + MAX_SETBANK_CMD + MAX_GETBANK_CMD + 1) /*@V2.1MNH51*/

#endif /* SVGA */


 /* Adapter types
 **
 **  For the most part, we'd prefer to always implement a single solution
 **  for any given problem for all existing adapters, but inevitably
 **  certain adapters need something a little different.  Where possible,
 **  we will try to determine the adapter-type automatically.  Where
 **  impossible, we may provide a switch to specify the adapter type on
 **  the DEVICE= line in CONFIG.SYS.  The following is a list of
 **  supported adapter types; it is recorded in ulAdapter (which starts
 **  out as ADAPTER_IBM until we discover otherwise).
 **
 ** Note that the adapter categories are fairly broad at this
 **     point.  There's no reason for it to remain that way however
 **     (ie, we may well want to add different adapter codes for
 **     different adapters from a single manufacturer).
 */

#define ADAPTER_IBM     1       /* IBM adapter                         */
#define ADAPTER_COMPAQ  2       /* Compaq adapter                      */
#define ADAPTER_TSENG   3       /* Tseng Labs adapter                  */
#define ADAPTER_VIDEO7  4       /* Video Seven adapter                 */
#define ADAPTER_ATI     5       /* ATI Wonder adapter                  */

#define PORT_HERC_COMPATIBILITY 0x3bf

#ifdef SVGA                             /* @V2.0DRW01                  */

#define SVGA_PMIFILENAME        "c:\\os2\\svgadata.pmi"         /*@V2.0WKB03*/
#define SVGA_RESTORE_FIRST_PASS  0x1                            /* @V2.2SEN01 */
#define SVGA_RESTORE_SECOND_PASS 0x2
#define SVGA_RESTORE_FULL_PASS   0x3
#define MAX_MMIO                0x100              /*for TSENGW32 JWK01 */

#define ATI_START_EXTREGS       0x80                            /*@V2.1MNH25*/
#define ATI_END_EXTREGS         0xc0
#define ATI_TOTAL_INITREGS      (ATI_END_EXTREGS - ATI_START_EXTREGS)

#define PORT_ORCHID_CLKSELECT   0x3dd

#define PORT_TSENG_SEGSELECT    0x3cd
#define PORT_TSENG_SEGSELECT2   0x3cb
#define PORT_TSENG_CRTCB_DATA   0x217b     /*0x21Xb edittables must fix */
#define PORT_TSENG_CRTCB_INDEX  0x217a
#define TSENG_CRTCB_START       0xe0
#define TSENG_CRTCB_END         0xff       /* includes IMA indexes */
#define TSENG_HWCURSOR_START    0xe0
#define TSENG_HWCURSOR_END      0xef
#define PORT_HERC_COMPATIBILITY 0x3bf
#define TSENG_IMA_INDEX_IMAGE_PORT_CONTROL  0xf7
#define TSENG_IMA_INDEX_SPRITE_CONTROL      0xef
#define TSENG_CRTCB_INDEX_COLOR_DEPTH 0xee

#define TOTAL_TSENG_CRTCBREGS   0x100

#define INDX_TRIDENT_REGDEF     0x0b    /* sequencer indexed port      */
#define INDX_TRIDENT_MODECTRL   0x0d    /*      "       "              */

#endif /* SVGA */

#ifdef SVGA                             /* @V2.0DRW01                  */

#define MAX_ATCREGS             0x20    /* @V2.0SEN11 do not allow overindexing */
                                        /* index 20-3F writes to 0-1F with PAL enable */
#define MAX_SEQREGS             0x100
#define MAX_GDCREGS             0x100
#define MAX_CRTREGS             0x100
#define MAX_DACREGS             0x100
#define MAX_ATIREGS             0x100
#define MAX_CRTCBREGS           0x100   /* for TSENGW32 */      /*@V2.1JWK01*/
#define MAX_HICOLORDACREGS      0x008                           /*@V2.1MNH25*/

#else /* SVGA */

//c-begin
/*
** Rounding using EXP2 and LOG2 is so that we can use MAX_XXX-1
** as a index mask when the actual index used by a background task
** exceeds the MAX_XXX.
** This usually succeeds in emulating the index "wrap" of most VGAs.
*/

#ifndef TSENG
#define TOTAL_IBM_CRTREGS   0x19
#define MAX_ATCREGS     (EXP2(LOG2(TOTAL_IBM_ATCREGS)))
#define MAX_SEQREGS     (EXP2(LOG2(TOTAL_IBM_SEQREGS)))
#define MAX_GDCREGS     (EXP2(LOG2(TOTAL_IBM_GDCREGS)))
#define MAX_CRTREGS     (EXP2(LOG2(TOTAL_IBM_CRTREGS)))
#else
#define MAX_ATCREGS     (EXP2(LOG2(TOTAL_TSENG_ATCREGS)))
#define MAX_SEQREGS     (EXP2(LOG2(TOTAL_TSENG_SEQREGS)))
#define MAX_GDCREGS     (EXP2(LOG2(TOTAL_TSENG_GDCREGS)))
#define MAX_CRTREGS     (EXP2(LOG2(TOTAL_TSENG_CRTREGS)))
#endif
#define MAX_DACREGS     (EXP2(LOG2(TOTAL_DACREGS)))

//c-end

/*
** @IBM
**
** This whole section is one gigantic FLAG: that would be deleted if
** H2INC and MASM could handle the macros above.  Handle with care!
*/

//masm-begin

//MAX_ATCREGS equ 20h
//MAX_SEQREGS equ 08h
//MAX_GDCREGS equ 10h
//ifndef TSENG
//MAX_CRTREGS equ 20h
//else
//MAX_CRTREGS equ 40h
//endif
//MAX_DACREGS equ 100h

//masm-end


//c-begin

//#if MAX_ATCREGS!=0x20||MAX_SEQREGS!=0x08||MAX_GDCREGS!=0x10||MAX_CRTREGS!=0x40
//#error Mismatch in C/MASM constants
//#endif

//c-end

/* @IBM End of gigantic FLAG: */

#endif /* SVGA */

 /*
 ** Global Video Flags
 */

#define VVD_PRIMARY       0x00000001 /* Display is primary display     */
#define VVD_MONOPRESENT   0x00000002 /* MONO adapter is present in system */
#define VVD_8514PRESENT   0x00000004 /* 8514 adapter is present in system @V2.0WKB01 */
#define VVD_CTLLOCKED     0x00000010 /* Video controller locked by VDD */
#define VVD_CTLWAITING    0x00000020 /* Video controller is being requested */
#define VVD_VRAMISTOAST   0x00000040 /* VRAM has been trashed by VDD   */
#define VVD_THREADEXIT    0x00000080 /* Event thread must exit         */
#define VVD_REPAINT       0x00000100 /* Reset VRAMISTOAST bit             @V2.0TPL01 */
#define VVD_PMBGND        0x00000200 /* PM is currently background     */
#define VVD_NOPHYSPAGES   0x00000400 /* Inhibit PhysPage allocation    */
#define VVD_TIMERARMED    0x00000800 /* Timerhook armed                   @V2.0TPL04 */
#define VVD_GRFXALLOWED   0x80000000 /* Windowed graphics allowed for all VDMs */


 /*
 ** Per-VDM Video Flags
 */

#define VDM_WINDOWED      0x00000001 /* VDM is windowed                */
#define VDM_PMWINDOWED    0x00000002 /* VDM is windowed by PM          */
#define VDM_MINIMIZED     0x00000004 /* VDM is minimized, inhibit events */
#define VDM_FGND          0x00000008 /* VDM is foreground              */
#define VDM_FGNDREADY     0x00000010 /* VDM foreground I/O hooks installed */
#define VDM_BGNDREADY     0x00000020 /* VDM background I/O hooks installed */
#define VDM_FOCUS         0x00000040 /* VDM has focus                  */
#define VDM_IOINIT        0x00000080 /* VDM I/O initialization is done */
#define VDM_STATEINIT     0x00000100 /* Internal state initialization done */
#define VDM_IOUPDATED     0x00000200 /* Complete I/O state known       */
#define VDM_UNKNOWNFAULT  0x00000400 /* Unknown page fault occurred    */
#define VDM_MOTIONTRAP    0x00000800 /* VRAM motion trapping is in effect */
#define VDM_SPECIALTRAP   0x00001000 /* GDC/SEQ trapping is in effect  */
#define VDM_UNMAPPED      0x00002000 /* All linear mappings currently disabled */
#define VDM_IGNOREFAULT   0x00004000 /* Page faults to be ignored      */
#define VDM_MODECHANGED   0x00008000 /* Mode-change posted but not processed */
#define VDM_MODECHANGING  0x00010000 /* Video mode-change in progress  */
#define VDM_FROZEN        0x00020000 /* We have suspended VDM          */
#define VDM_KEYREAD       0x00040000 /* Key read recently              */
#define VDM_KEYPASTED     0x00080000 /* Key pasted recently            */
#define VDM_INPUTPOSTED   0x00100000 /* No event has been posted since INPUT */
#define VDM_DYING         0x00200000 /* VDM is dying                   */
#define VDM_FGNDHOOK      0x00400000 /* FgndContext hook armed         */
#define VDM_BGNDHOOK      0x00800000 /* BgndContext hook armed         */
#define VDM_UPDATEHOOK    0x01000000 /* UpdateContext hook armed       */
#define VDM_PHYSHOOK      0x02000000 /* UpdatePhysContext hook armed   */
#define VDM_SHADOWINVALID 0x04000000 /* Shadow buffer is invalid       */
#define VDM_DIRTYPALETTE  0x08000000 /* Virtual palette has been changed */
#define VDM_PHYSPAGE      0x10000000 /* VDM owns 1 or more PAGE_PHYSICAL pages */
#define VDM_PHYSPAGECHK   0x20000000 /* Toggled with each dirty PHYSPAGE check */
#define VDM_UPDATING      0x40000000 /* VDM window is being updated    */
#define VDM_GRFXALLOWED   0x80000000 /* Windowed graphics is allowed   */

#define VDMX_ACTIVE       0x00000001 /* Display active (primary or secondary) */
#define VDMX_DEVOWNER     0x00000002 /* VDD owns device for this VDM   */
#define VDMX_DSPOWNER     0x00000004 /* VDD owns display for this VDM  */
#define VDMX_INITHOOK     0x00000008 /* InitContext hook armed         */
#define VDMX_PTRHOOK      0x00000010 /* UpdatePtrContext hook armed    */
#define VDMX_DEVREQUEST   0x00000020 /* DEVREQUEST from this VDD in progress */
#define VDMX_DSPREQUEST   0x00000040 /* DSPREQUEST from this VDD in progress */
#define VDMX_INT10INIT    0x00000080 /* INT 10h initialization in progress */
#define VDMX_VDDFAULT     0x00000100 /* VDD may cause VDM page fault   */
#define VDMX_INT10EMULATE 0x00000200 /* INT 10h emulation in effect    */
#define VDMX_RTRCEMULATE  0x00000400 /* horz/vert retrace emulation in effect */
#define VDMX_RTRCOVERRIDE 0x00000800 /* retrace emulation setting being overridden */
#define VDMX_CGARESTRICT  0x00001000 /* CGA restriction in effect      */
#define VDMX_MONORESTRICT 0x00002000 /* MONO restriction in effect     */
#define VDMX_RTRCTRAP     0x00004000 /* retrace port trapped           */
#define VDMX_SYNCOUTPUT   0x00008000 /* synchronous window output      */
#define VDMX_WDWSEMREQ    0x00010000 /* INT 10h emulation code has taken sem. */
#define VDMX_CREATEDONE   0x00020000 /* VDM creation complete             @V2.0TPL03 */
#define VDMX_INT2FPENDING 0x00040000 /* Issue 2F int in SVGA BgndContext @V2.0SEN08  */
#define VDMX_INT2FREGIST  0x00080000 /* Another device registered with us for 2F int @V2.0SEN08  */
#define VDMX_SAVERESTORE  0x00100000 /* Save/Restore VGA                  @V2.0TPL01 */
#define VDMX_ENHANCEDMODE 0x01000000 /* VDM is in enhanced mode           @V2.0DRW03 */
#define VDMX_NOIOTRAPPING 0x02000000 /* don't trap foreground IO accesses @V2.1DRW10 */
#define VDMX_UNMAPHOOK    0x04000000 /* VVUnMapPhysContext hook armed     @V2.0JWK61 */
#define VDMX_SEAMLESS     0x08000000 /* Seamless Windows session          @V2.0XXX02 */
#define VDMX_32DSP        0x10000000 /* 32-bit DISPLAY Driver call        @V2.0TPL11 */
#define VDMX_ONDEMAND     0x20000000 /* Enable on-demand memory allocation */
#define VDMX_INT2F        0x40000000 /* Enable INT 2Fh notifications   */
#define VDMX_INT10RESTORE 0x80000000 /* Enable INT 10h restore          */
#define VDMX_INTRESTOREFGND 0xc0000000 /* VDMX_INT2F | VDMX_INT10RESTORE don't restore in SetFgnd @V2.2SEN01*/


#define VDMX2_FIRSTFGND    0x00000001 /* First set foreground @V2.0SEN09 */
#define VDMX2_8514IOINIT   0x00000002 /* I/O initialization is done @V2.1SEN15 */
#define VDMX2_8514BLOCKED  0x00000004 /* We have blocked VDM I/O @V2.1SEN15 */
#define VDMX2_8514IOOWNED  0x00000008 /* I/O ownership flag                 */
#define VDMX2_8514IOWAKEME 0x00000010 /* I/O ownership notify flag          */
#define VDMX2_8514ENGBUSY  0x00000020 /* engine busy flag                   */
#define VDMX2_LOCKSPUSHED  0x00000040 /* SVGA locks pushed */   /*@V2.1MNH06*/
#define VDMX2_V86MACHINE   0x00000080 /* running as a virtual 8086 machine  @V2.2SEN01 */
#define VDMX2_IGNOREINT10  0x00000100 /* an int10 is being injected, special case @V2.2SEN01*/

 /*
 ** Session states
 **
 **  These indicate the state of a VDM session as dictated by foreground
 **  and background notifications.
 */

#define SESSION_NONE    0       /* undefined (only during creation)    */
#define SESSION_FGND    1       /* last screen-switch event was SetFgnd */
#define SESSION_BGND    2       /* last screen-switch event was SetBgnd */


 /*
 ** Frozen states
 **
 **  A VDM can be frozen by the video VDD whenever it is background
 **  and tries to access memory in a graphics mode.
 */

#define FROZEN_NONE     0       /* VDM not frozen (by us anyway)       */
#define FROZEN_BGND     1       /* frozen due to unsupported memory access */


 /*
 ** Memory states
 **
 **  These indicate the overall state of a VDM's virtual or physical
 **  memory.  Determination is based on registers/bits that define current
 **  addressibility (see vvUpdateVideoState).  For the states of individual
 **  pages of virtual or physical memory, see the PAGE_* constants.
 */

#define MEMORY_LATCH   -1       /* private memory state (all planes enabled) */
#define MEMORY_NONE     0       /* no state (only during creation)     */
#define MEMORY_TEXT     1       /* single-plane TEXT memory in use     */
#define MEMORY_FONT     2       /* plane 2 GRAPHICS memory in use      */
#define MEMORY_CGAX     3       /* single-plane GRAPHICS memory in use */
#define MEMORY_GRFX     4       /* multiple-plane GRAPHICS memory in use */
#define MEMORY_GRFX2    5       /* 2-color single-plane GRAPHICS memory in use */
#define MEMORY_GRFX256  6       /* 256-color single-plane GRAPHICS memory in use */

#define MEMMODE_TEXT    0       /* these are the memory modes described */
#define MEMMODE_FONT    1       /* in each of the RLE entries          */
#define MEMMODE_GRFX    2
#define MEMMODE_GRFX256 3
#define MEMMODE_STATES  4       /* total unique memory modes */   /*@V2.1MNH23*/


 /*
 ** Page states
 **
 **  These specify the state of individual pages which comprise a VDM's
 **  virtual memory.  For every plane of virtual video memory, there is an
 **  entry in an array (aapstate) containing one of these state values.
 **  Normally, the values found in that array will be consistent with the
 **  VDM's memory state (mstate), except for brief periods when the virtual
 **  buffer has not yet been converted (see vvUpdatePageStates for details).
 */

#define PAGE_NONE          0x00 /* page unaccessed -- no type          */
#define PAGE_TEXT          0x01 /* page contains text info             */
#define PAGE_FONT          0x02 /* page contains font info             */
#define PAGE_CGAX          0x03 /* page contains single-plane graphics info */
#define PAGE_GRFX          0x04 /* page contains graphics info         */
#define PAGE_MMIO          0x05 /* page maps to physical memory mapped IO (do NOT virtualize )*/
#define PAGE_GRFX256       0x06 /* page contains 256-color graphics info */
#define PAGE_TYPE          0x07 /* mask for data type bits             */
#define PAGE_PHYSICAL      0x08 /* page being emulated using physical VRAM */

#define PAGE_BLANK         0x10 /* page is blank (1st of the type modifiers) */
#define PAGE_INVRAM        0x20 /* page is currently in physical VRAM  */
#define PAGE_VIRTUAL       0x40 /* page is mapped to "virtual" VRAM memory */
#define PAGE_SHADOWINVALID 0x80 /* page shadow data is not valid       */

#define PAGE_VALID   (PAGE_TYPE|PAGE_PHYSICAL|PAGE_BLANK)

#define ALL_GRFX     (PAGE_GRFX    |PAGE_GRFX<<8    |PAGE_GRFX<<16    |PAGE_GRFX<<24)
#define ALL_GRFX256  (PAGE_GRFX256 |PAGE_GRFX256<<8 |PAGE_GRFX256<<16 |PAGE_GRFX256<<24)
#define ALL_BLANK    (PAGE_BLANK   |PAGE_BLANK<<8   |PAGE_BLANK<<16   |PAGE_BLANK<<24)
#define ALL_INVRAM   (PAGE_INVRAM  |PAGE_INVRAM<<8  |PAGE_INVRAM<<16  |PAGE_INVRAM<<24)
#define ALL_VIRTUAL  (PAGE_VIRTUAL |PAGE_VIRTUAL<<8 |PAGE_VIRTUAL<<16 |PAGE_VIRTUAL<<24)
#define ALL_VALID    (PAGE_VALID   |PAGE_VALID<<8   |PAGE_VALID<<16   |PAGE_VALID<<24)
#define ALL_PHYSICAL (PAGE_PHYSICAL|PAGE_PHYSICAL<<8|PAGE_PHYSICAL<<16|PAGE_PHYSICAL<<24)

#define PHYSPAGE_RESERVED  ((ULONG)-1)
#define PHYSPAGE_AVAILABLE 0
#define PHYSPAGE_ALLOCATED PAGESIZE


//c-begin

#define VDMOWNSPHYSPAGE(i) (ahPhysPage[i] > PHYSPAGE_ALLOCATED && ahPhysPage[i] != PHYSPAGE_RESERVED)
#define THISVDMOWNSPHYSPAGE(hvdm,i) (ahPhysPage[i] == (ULONG)(pVDMData(hvdm)->hvdmVideo))

//c-end


 /* Bank states
 **
 **  @V2.0DRW03
 **
 **  These specify the state of banks which comprise a VDM's virtual memory
 **  when in linear graphics modes.
 */

#define BANK_NONE       0x00    // bank unaccessed
#define BANK_BLANK      0x01    // bank is blank
#define BANK_INVRAM     0x02    // bank is currently in physical VRAM
#define BANK_VIRTUAL    0x04    // bank is mapped to "virtual" VRAM memory
#define BANK_INVALID    0x08    // bank shadow data is not valid


 /*
 ** Controller owner definitions
 */

#define NO_OWNER           ((HVDM)0)
#define DISPLAY_OWNER      ((HVDM)1)
#define MISC_OWNER         ((HVDM)2)
#define MAXNONVDM_OWNER    MISC_OWNER

#define LOCKBUTDONOTBLOCK  2 /* don't block when controller is not locked  @V2.0TPL05 */

 /*
 ** Misc. definitions
 */

#define GROW_MAXIMUM    -1
#define ALL_PLANES      -1
#define INVALID_HVDM    ((HVDM)-2)


 /*
 ** ATC (Attribute Controller) states
 **
 **  These are the states that the ATC on an EGA/VGA can be in.  They have
 **  been selected not only because they are complementary, but also because
 **  they can be OR'ed with a index into the virtual ATC data (aregATCData),
 **  to produce a properly adjusted index (I rely on the fact that regATCIndx
 **  precedes aregATCData by 1 byte).
 */

#define ATC_DATA        0       /* ready for data byte                 */
#define ATC_INDEX       -1      /* ready for index byte                */


 /*
 ** DAC (Digital-to-Analog Color-lookup) states
 **
 **  These are the states that the DAC hardware on a VGA can be in.
 */

#define DAC_DATA0       0x0000  /* ready first 1st byte of data        */
#define DAC_DATA1       0x0001  /* ready first 2nd byte of data        */
#define DAC_DATA2       0x0002  /* ready first 3rd byte of data        */
#define DAC_DATAMASK    0x0003
#define DAC_READ        0x0300  /* read mode (high byte simulates state reg.) */
#define DAC_WRITE       0x0000  /* write mode (high byte simulates state reg.) */
#define DAC_RWMASK      0x0300


 /*
 ** Port flags (for use in xxx_port fields)
 */

#define PORT_MASK       0x0000FFFF
//@V2.2SEN08 not used anymore #define PORTF_NOTRAP    0x00010000/* no trapping for this port           */
#define PORTF_CHOOK     0x00020000/* I/O hook is C-based                 */
#define PORTF_INDEXDATA 0x00040000/* this port is both an index and data port */
#define PORTF_AUTOINC   0x00080000/* this port's index register auto-increments */
#define PORTF_COLRMONO  0x00100000/* the actual port address varies (see MISCOUT) */
#define PORTF_CRTCTRL   0x00200000/* CRT controller port, may be write-protected */
#define PORTF_REQUIRED  0x00400000/* port is required for MEMMODE reprogramming */
//@V2.2SEN08 not used anymore #define PORTF_SVGA      0x00800000/* port is defined only on some SVGA adapters @V2.1SEN13*/
#define PORTF_NOTVALIDSVGAPORT      0x00800000/* port is defined only on some SVGA adapters @V2.2SEN08*/
#define PORTF_SPECIAL   0x01000000/* special case I/O (GED/SEQ) *//*@V2.1MNH17*/
#define PORTF_TSENG     0x02000000/* special case for TSENG adapters  /* JWK01 */

 /*
 ** Port-list flags (for use in the ple_flxxx fields)
 */

#define PLE_RESETSEQ 0x00000001 /* sequencer must be reset before writing */
#define PLE_WAITVERT 0x00000001 /* wait for vertical retrace before writing */
#define PLE_WAITHORZ 0x00000001 /* wait for horizontal retrace before writing */


 /*
 ** Register-list flags (for use in the rle_fbCond field)
 */

#define REGCOND_RESETSEQ  0x01  /* sequencer must be reset before writing */
#define REGCOND_WAITVERT  0x02  /* wait for vertical retrace before writing */
#define REGCOND_WAITHORZ  0x04  /* wait for horizontal retrace before writing */

 /*
 ** Register-list index values (for mode-specific pointer support)
 */

#define PTRMODE_NOPLANE -1      /* no reprogramming needed             */
#define PTRMODE_4PLANE   0      /* all planes enabled                  */
#define PTRMODE_1PLANE   1      /* only first plane enabled            */
#define PTRMODE_ODDPLANE 2      /* chained-plane mode                  */


 /*
 ** Pointer flags
 */

#define PTR_ACTIVE      0x0001  /* set if pointer drawing active       */
#define PTR_DRAWN       0x0002  /* set if pointer image currently on-screen */
#define PTR_INVERSE     0x0004  /* set if inverse image (use slow update code) */
#define PTR_HARDWARE    0x0008  /* set if hardware pointer enabled     */
#define PTR_PTRSAVE     0x0010  /* set if pointer save-area is valid   */
#define PTR_ODDEVEN     0x0020  /* set if 64k EGA mode in effect       */
#define PTR_BYTEPIXEL   0x0040  /* set if byte-pixel mode (mode 13h)   */
#define PTR_SUPPORTED   0x0080  /* set if video mode supported, clear if not */
#define PTR_LPENEM      0x1000  /* set if light-pen emulation enabled  */
#define PTR_HWDIRTY     0x2000  /* set if hardware cursor moved by app */
#define PTR_INTERNAL    0x8000  /* set if internal hide/show call in progress */
#define PTR_RESETMASK   (PTR_ACTIVE|PTR_INVERSE|PTR_HARDWARE|PTR_LPENEM|PTR_INTERNAL)


 /*
 ** Event flags (see VVD.H for the public POSTEVENT_* flags subset)
 **
 **  Note:  There is no internal equivalent to POSTEVENT_ADD because if
 **  we want to add an event, we simply call vvAddEvent;  otherwise,
 **  we call vvFlushEvent.
 **
 **  Also note:  The EVENT_OWNER flag could be removed now that we have new
 **  semaphore services that can nest requests, but I leave it in as an
 **  optimization.
 */

#define EVENT_FLUSH     POSTEVENT_FLUSH /* flush event immediately     */
#define EVENT_ASYNC     0x0008          /* asynchronous event          */
#define EVENT_OWNER     0x1000          /* caller owns EventUpdate semaphore */


 /*
 ** INT 10 Return Hook storage structure
 */

typedef struct int10_s {        /* INT 10 return hook storage       */  /* @V2.0TPL09 */
    ULONG  reg_eax;             /* saved EAX or VVSTRING row        */  /* @V2.0TPL09 */
    ULONG  reg_ebx;             /* saved EBX or VVSTRING col        */  /* @V2.0TPL09 */
    ULONG  func_type;           /* function type or VVSTRING nChars */  /* @V2.0TPL09 */
    ULONG  reg_saved;           /* 0 - didn't save regs below       */  /* @V2.0TPL09 */
    ULONG  reg_ecx;             /* saved ECX                        */  /* @V2.0TPL09 */
    ULONG  reg_edx;             /* saved EDX                        */  /* @V2.0TPL09 */
    ULONG  reg_ebp;             /* saved EBP                        */  /* @V2.0TPL09 */
    USHORT reg_es;              /* saved ES                         */  /* @V2.0TPL09 */
    USHORT reg_ds;              /* saved DS                         */  /* @V2.0TPL09 */
} VVINT10S;                                                             /* @V2.0TPL09 */
typedef VVINT10S *NPVVINT10S;                                           /* @V2.0TPL09 */
typedef VVINT10S FAR *PVVINT10S;                                        /* @V2.0TPL09 */


 /*
 ** Private types
 **
 **  These state-types refer to sets of ordinal values representing
 **  various states.
 */

typedef INT   MSTATE;           /* for memory-state values   */
typedef BYTE  PSTATE;           /* for page-state values     */
typedef BYTE  BSTATE;           /* for bank-state values     */         /* @V2.0DRW03 */

typedef LONG (PRIVENTRY *PSYSFUN)(HVDM, ULONG, PVOID, ULONG, PVOID);
typedef LONG (PRIVENTRY *PDEVFUN)(HVDM, BOOL);


 /*
 ** Hook-list entry
 **
 **  This is the header for hook-list entries, which list a port to trap (or
 **  not to trap, as the case may be) and associated I/O hooks to be installed,
 **  if any.
 */

typedef struct hle_s {          /* hle                                 */
    PORT  hle_port;             /* port # (and optional port flags)    */
    PFN   hle_pfn[1];           /* address of I/O trap handler, NULL if none */
} HLE;
typedef HLE *PHLE;              /* phle                                */

/*
** Write many registers are ones which writing many times with the
** same value generally has the same result as writing them only once.
**
** Write once registers are ones which usually expect a stream of
** values where each value is used only once, perhaps deposited or XORed
** somewhere in VRAM, such as pixel bytes and stroke drawing regs.
**
** Read once registers are similar to write once registers.
** They usually are a stream of values extracted from VRAM.
**
** Read many registers are simliar to write many registers.
** These are the ones which reading many times usually gets the same value
** as the first (unless some asynchronous status changes).
*/

#define NONE               0x00                                 /*@V2.1MNH13*/
#define WRITE_REG          0x01                                 /*@V2.1MNH13*/
#define WRITE_NONE         (NONE)                               /*@V2.1MNH13*/
#define WRITE_ONCE         (NONE | WRITE_REG)                   /*@V2.1MNH13*/
#define WRITE_MANY         (0x02 | WRITE_REG)                   /*@V2.1MNH13*/
#define WRITE_INDX_FLAG    0x04                                 /*@V2.1MNH14*/
#define WRITE_INDX         (WRITE_INDX_FLAG | WRITE_MANY)       /*@V2.1MNH14*/
#define WRITE_ALL          (WRITE_REG | WRITE_MANY | WRITE_INDX)/*@V2.1MNH13*/
#define READ_REG           0x10                                 /*@V2.1MNH13*/
#define READ_NONE          (NONE)                               /*@V2.1MNH13*/
#define READ_ONCE          (NONE | READ_REG)                    /*@V2.1MNH13*/
#define READ_MANY          (0x20 | READ_REG)                    /*@V2.1MNH13*/
#define READ_INDX_FLAG     0x40                                 /*@V2.1MNH14*/
#define READ_INDX          (READ_INDX_FLAG | READ_MANY)         /*@V2.1MNH14*/
#define READ_ALL           (READ_REG | READ_MANY | READ_INDX)   /*@V2.1MNH13*/
#define R_EQ_W             NONE                                 /*@V2.1MNH13*/
#define R_NE_W             0x80  /* Redundant! */               /*@V2.1MNH13*/
#define PORT_STAYS_HOOKED 0x100                                 /*@V2.2SEN01 */

typedef struct sTrapRegInfo_s {                                 /*@V2.1MNH13*/
  PORT  portTrap;                                               /*@V2.1MNH13*/
  PVOID pvTrapWriteShadow;                                      /*@V2.1MNH13*/
  PVOID pvTrapReadShadow;                                       /*@V2.1MNH13*/
  FLAGS fTrapType;                                              /*@V2.1MNH13*/
  PIOH  piohTrap;                                               /*@V2.1MNH14*/
} STRAPREGINFO;                                                 /*@V2.1MNH13*/
typedef STRAPREGINFO *PSTRAPREGINFO;                            /*@V2.1MNH13*/

 /*
 ** Port-list entry
 **
 **  This is the structure for port-list entries, which list a port, a
 **  range of indexed registers accessible through the port (or in the case
 **  of 0 in ple_nRegs, a single non-indexed register), the address of the
 **  associated virtual register storage, and several flag words to specify
 **  any special conditions for the port/registers.
 **
 **  Note:
 **         The 'flBRegResetSeq' flags are not large enough to handle
 **         extended sequencers, such as used by Video7 chips, which
 **         set clock-specific registers. These registers have indices
 **         up to 0xff. The current fix is to check for them during
 **         vvRestoreIOState() and set the flag, not so pretty.
 */

typedef struct ple_s {          /* ple                                 */
    STRAPREGINFO sTrapBRegInfo; /* port # (and optional port flags)    */
    ULONG ulBRegCount;          /* number of registers (0 if non-indexed) */
    struct ple_s *ppleBRegIndx; /* description of index reg   *//*@V2.1MNH14*/
#ifdef SVGA                                                     /*@V2.1MNH14*/
    PBYTE pbBRegMask;           /* location of mask array     *//*@V2.1MNH14*/
    PBYTE pbBRegReadMask;       /* location of readable mask array   *//*@V2.2SEN01*/
#endif /* SVGA */                                               /*@V2.1MNH14*/
    FLAGS flBRegResetSeq;       /* bits 0-31                           */
    FLAGS flBRegWaitVert;       /*   correspond to                     */
    FLAGS flBRegWaitHorz;       /*     registers 0-31 (see PLE_* constants) */
} PLE;
typedef PLE *PPLE;              /* pple                                */


 /*
 ** Register-list entry
 **
 **  This is the structure for register-list entries, which list a port, a
 **  register index, the address of the associated virtual register storage,
 **  values used to reprogram the register for standard memory access, and
 **  a flag byte to specify any special conditions for the register.
 */

 /*
 ** Options for vvSetIOState()
 */

#define SETIO_SHADOWED       -1 /* set registers to shadowed values    */
#define SETIO_LIMIT_SHADOWED -2 /* set selected bits in regs to shadowed values */

typedef struct rle_s {          /* rle                                 */
    PPLE  rle_pple;             /* port description for register       */
    FLAGS rle_flags;
    BYTE  rle_indx;             /* starting reg index (ignored if non-indexed) */
    BYTE  rle_pad;
    BYTE  rle_fbCond;           /* (see REGCOND_* constants)           */
    BYTE  rle_fbMask;           /* contains bits that can be modified  */
    BYTE  rle_bMode [MEMMODE_STATES];
    PBYTE rle_pbExtShadowIndx;  /* pointer to external shadow indx, NULL if none */
    PBYTE rle_pbExtShadowData;  /* pointer to external shadow data, NULL if none */
} RLE;
typedef RLE *PRLE;              /* prle                                */
typedef PRLE *PPRLE;            /* pprle                               */


 /*
 ** DAC color register structure
 **
 **  This structure contains the 3x6 bits (total of 18 bits) that make up
 **  the DAC information for one color register.
 */

typedef struct dac_s {          /* dac                                 */
    BYTE  dac_bRed;
    BYTE  dac_bGreen;
    BYTE  dac_bBlue;
} DACREG;
typedef DACREG *PDACREG;        /* pdac                                */

#ifdef SVGA                                                     /*@V2.1MNH14*/
/*
**      REGDATA Command values
**
** PMICMD_NONE being 0 serves as the end of list marker.
*/

#define PMICMD_NONE             0
/*
** Format for byte IO Port commands:
** (command,indexport,dataport,startindex,numentries,flags,ptrdata)
** Format for word IO port commands:
** (command,indexport,[dataport|0],0,value,flags,ptrdata)
*/
#define PMICMD_INB              1
#define PMICMD_OUTB             2
#define PMICMD_INW              3
#define PMICMD_OUTW             4
#define PMICMD_BINB             5
#define PMICMD_BOUTB            6
/*
** Format for read-modify-write Port commands:
** (command,indexport,dataport,index,andmask,ormask,0)
*/
#define PMICMD_RMWBI            7 /*BYTE INDEXED*/
#define PMICMD_RMWBN            8 /*BYTE NO INDX*/  /*Was RMWW*//*@V2.1MNH13*/
#define PMICMD_RMWWN            9 /*WORD NO INDX*/
/*
** Format for register command:
** (command,0,0,0,register_index,flag,ptrdata)
*/
#define PMICMD_REGOP_ASSIGN     10               /* Rxxx  = <value> */
#define PMICMD_REGOP_AND        11               /* Rxxx &= <value> */
#define PMICMD_REGOP_OR         12               /* Rxxx |= <value> */
#define PMICMD_REGOP_XOR        13               /* Rxxx ^= <value> */
#define PMICMD_REGOP_SHL        14               /* Rxxx <= <value> */
#define PMICMD_REGOP_SHR        15               /* Rxxx >= <value> */
/*
** wait command: Format is
** (command,port,mask,count,value,0)
*/
#define PMICMD_WAIT             16
#define PMICMD_WAITW            17                              /*@V2.1MNH51*/
/*
** Format for memory commands:
** (command,source,destination,flag,ptrdata)
**             *See note on initialization below _REGDATA declaration.
*/
#define PMICMD_READB            18                              /*@V2.1MNH51*/
#define PMICMD_READW            19                              /*@V2.1MNH51*/
#define PMICMD_READDW           20                              /*@V2.1MNH51*/
#define PMICMD_WRITEB           21                              /*@V2.1MNH51*/
#define PMICMD_WRITEW           22                              /*@V2.1MNH51*/
#define PMICMD_WRITEDW          23                              /*@V2.1MNH51*/
/*
** Format for for command:
** (command,0,maxvalue,0,counterindex,0)
*/
#define PMICMD_FOR              24                              /*@V2.1MNH51*/
#define PMICMD_FOREND           25                              /*@V2.1MNH51*/

#define PMICMD_MAX              PMICMD_FOREND   /* equals last entry for range checks */

#define PMIFLAG_NONE       0x0000               /* Note: these are bits fields        */
#define PMIFLAG_NOOP       0x0001               /* turn this command into a no-op     */
#define PMIFLAG_ATC        0x0002               /* port is ATC, needs special case    */
#define PMIFLAG_REGISTER   0x0004               /* OUT data is register not immediate */
#define PMIFLAG_UPDATELIST 0x0008               /* must update list-data after command*/


#define PMI_WAIT_CLEAR 0        /* Wait for CLEAR condition */  /*@V2.1MNH01*/
#define PMI_WAIT_SET   1        /* Wait for SET condition */    /*@V2.1MNH01*/

/*
**      REGDATA Flags
*/

#define  READWRITE_DATA         0x0001  /* read this data from registers   */
#define  WRITEONLY_DATA         0x0002  /* write to file, don't read regs  */
#define  DONTWRITE_DATA         0x0004  /* don't generate register assigns */
#define  WRITEREG_DATA          0x0008  /* write register data  @V2.0SEN16 */
/*
** Take care when initializing the PMICMD_ regdata. Union fields can be
** initialized only following the format of its first definition (in this
** case _PORTIO. This means that PMICMD_READx and PMICMD_WRITEx which are
** using _MMIO format have to be initialized in (lowerword source, upperword
** source, lowerword destination, upperword destination) pairs rather than
** (doubleword source, doubleword destination).       @V2.2SEN01
*/
//c-begin
typedef union _HWCMDOPERAND {                                   /*@V2.1MNH14*/
  PSTRAPREGINFO psTrapRegOperand;                               /*@V2.1MNH14*/
  ULONG ulOperand;
} HWCMDOPERAND, *PHWCMDOPERAND;
//c-end
//masm-begin
//DefStruc ,_HWCMDOPERAND                                        ;@V2.1MNH14
//  ULONG ulOperand                                              ;@V2.1MNH14
//EndStruc HWCMDOPERAND                                          ;@V2.1MNH14
//masm-end

typedef struct _HWCMD {
  USHORT       usCommand;                                       /*@V2.1MNH14*/
  USHORT       usFlags;                                         /*@V2.1MNH14*/
  HWCMDOPERAND hwTarget;
  HWCMDOPERAND hwSource;
  HWCMDOPERAND hwIndex;
  HWCMDOPERAND hwModify;                /* ppleIndex or modify value/reg */
  HWCMDOPERAND hwCount;
} HWCMD;
typedef HWCMD *PHWCMD;                                          /*@V2.1MNH14*/
#endif /* SVGA */                                               /*@V2.1MNH14*/

 /*
 ** List entry structure
 **
 **  There is one such entry for each VDM (in the instance data structure),
 **  and a top-of-list pointer in the global data.  A VDM's list entry will
 **  be initialized and added to the list at VDM creation time, and will be
 **  pulled out of the list and inserted at the head whenever a synchronous
 **  video event has been posted for it.
 */

typedef struct lse_s {          /* lse                                 */
    HVDM   lse_hvdm;
    struct lse_s *lse_plseNext;
    struct lse_s *lse_plsePrevious;
} LSENTRY;
typedef LSENTRY *PLSENTRY;      /* plse                                */

 /*
 ** To add an entry at the HEAD of the
 ** list, use ADD/INSERTENTRY(hvdm, &lseHeadActive);
 */


//c-begin

#define ADDENTRY(hvdm,list) \
    pVDMData(hvdm)->lse##list.lse_hvdm = pVDMData(hvdm)->hvdmVideo; \
    INSERTENTRY(hvdm,list);

#define INSERTENTRY(hvdm,list) \
    if (!pVDMData(hvdm)->lse##list.lse_plsePrevious) { \
        pVDMData(hvdm)->lse##list.lse_plsePrevious = &lseHead##list; \
        pVDMData(hvdm)->lse##list.lse_plseNext = lseHead##list.lse_plseNext; \
        if (lseHead##list.lse_plseNext) \
            lseHead##list.lse_plseNext->lse_plsePrevious = \
                &pVDMData(pVDMData(hvdm)->hvdmVideo)->lse##list; \
        lseHead##list.lse_plseNext = &pVDMData(pVDMData(hvdm)->hvdmVideo)->lse##list; \
    }

#define REMOVEENTRY(hvdm,list) \
    if (pVDMData(hvdm)->lse##list.lse_plsePrevious) { \
        pVDMData(hvdm)->lse##list.lse_plsePrevious->lse_plseNext = \
            pVDMData(hvdm)->lse##list.lse_plseNext; \
        if (pVDMData(hvdm)->lse##list.lse_plseNext) \
            pVDMData(hvdm)->lse##list.lse_plseNext->lse_plsePrevious = \
            pVDMData(hvdm)->lse##list.lse_plsePrevious; \
        pVDMData(hvdm)->lse##list.lse_plsePrevious = NULL; \
    }

#define FIRSTENTRY(hvdm,list) \
    (pVDMData(hvdm)->lse##list.lse_plsePrevious == &lseHead##list)

//c-end


//c-begin

 /*
 **   The following macros allow me to dynamically allocate/free context
 **   hooks easily, with an arbitrary amount of storage.  It does so by
 **   redefining the hhook variable as a pointer to the reference data, and
 **   stuffing what the kernel considers the hook handle into the first dword
 **   of the reference data.  Since HHOOK is the same as PVOID, the context
 **   hook itself can also be written as if it received a hook handle.
 **
 **    fnRandom()
 **    {
 **      if (ALLOCHOOK(pfnContext, 2, hhook, t)) {
 **          HOOKDATA(hhook, 0) = TRUE;          ** set first ULONG     **
 **          HOOKDATA(hhook, 1) = FALSE;         ** set second ULONG    **
 **      }
 **    }
 **
 **    fnContext(hhook, pcrf)
 **    {
 **      if (HOOKDATA(hhook, 0) == TRUE)
 **         ...
 **      FREEHOOK(hhook);
 **    }
 */

#define ALLOCHOOK(pfn,nul,hh,t) ( \
          (hh = VDHAllocHook(VDH_CONTEXT_HOOK, \
                             pfn, sizeof(HHOOK)+nul*sizeof(ULONG))) \
         && \
          ((PVOID)t = VDHQueryHookData(hh)) \
         && \
          (*(HHOOK *)t = hh) \
         && \
          (hh = (HHOOK)t) )

#define ARMHOOK(hh,hvdm) VDHArmContextHook(*(HHOOK *)hh, hvdm)

#define HOOKDATA(hh,i)  *(PULONG)((ULONG)hh+sizeof(HHOOK)+i*sizeof(ULONG))

#define FREEHOOK(hh)    VDHFreeHook(*(HHOOK *)hh)

//c-end


 /*
 **    Values for VVCheckForEvents flag
 */

#define PERIODIC_TIMER      1   /* indicates periodic call from timer hook    */
#define PERIODIC_KBDPEEK    2   /* indicates periodic call from kbd peek hook */
#define PERIODIC_KBDREAD    3   /* indicates periodic call from kbd read hook */

 /*
 ** Semaphore prototype macros
 */

typedef HVDHSEM HEVSEM;
typedef HVDHSEM HMXSEM;

//c-begin

#define CreateEventSem(phev) \
            VDHCreateSem(phev, VDH_EVENTSEM)
#define DestroyEventSem(hev) \
            VDHDestroySem(hev)
#define ResetEventSem(hev) \
            VDHResetEventSem(hev)
#define PostEventSem(hev) \
            VDHPostEventSem(hev)
#define WaitEventSem(hev) \
            VDHWaitEventSem(hev, SEM_INDEFINITE_WAIT)
#define CreateMutexSem(phmx) \
            VDHCreateSem(phmx, VDH_MUTEXSEM)
#define DestroyMutexSem(hmx) \
            VDHDestroySem(hmx)
#define RequestMutexSem(hmx) \
            VDHRequestMutexSem(hmx, SEM_INDEFINITE_WAIT)
#define ReleaseMutexSem(hmx) \
            VDHReleaseMutexSem(hmx)

//c-end


 /*
 ** Pointer support
 **
 **  When we remove or redraw the pointer ourselves, as part of switching
 **  background/foreground, we inc/dec fPtrFrozen to disable/enable pointer
 **  drawing at interrupt-time.
 **
 **  vmssVideo is updated by vvUpdateScreenState, if so requested.  The mouse
 **  driver is notified once the update is complete.
 **
 **  xPtr and yPtr contain the coordinates of the current pointer image;  the
 **  units are mode-dependent (ie, cells or pixels) to facilitate checks for
 **  pointer image motion.
 **
 **  ausGraphMasks records the last pointer shape received by VVDefinePtr
 **  via VMD.  See VVPTR.C for a description of the how ausPtrShape is defined.
 */

typedef struct ptrdata_s {      /* beginning of PTRDATA structure      */

FLAGS   flPtrVideo;             /* pointer flags                       */

BOOL    fPtrFrozenVideo;        /* TRUE to disable show/hide (internal */
                                /* draw/erase interfaces are still functional) */

VMSSIZE vmssVideo;              /* current display mode data (for mouse) */

VMSTAT  vmstatVideo;            /* last queried mouse status           */

ULONG   xPtrVideo;              /* current pointer position            */
ULONG   yPtrVideo;              /* (updated with new pos. by vvPtrDraw) */

ULONG   xCell;                  /* converted current pointer position  */
ULONG   yCell;                  /* (ie, mode-dependent units)          */

ULONG   ulPtrPage;              /* video page # to contain pointer     */

INT     iPtrMode;               /* ptr mode index (for arlePtrState), -1 if none */

PFN     pfnPutImage;            /* offsets of                          */
PFN     pfnMoveMasks;           /*  appropriate transfer routines      */

ULONG   nBitsRotate;            /* bits of rotation                    */

ULONG   xCorner;                /* upper-left corner of position       */
ULONG   yCorner;                /*  to mask in pointer (ie, hot-spot adjusted) */

ULONG   xCornerPrev;            /* upper-left corner of previous       */
ULONG   yCornerPrev;            /*  pointer location                   */

ULONG   offScrBuff;             /* screen offset of (xScrBuff, yScrBuff) */

ULONG   xScrBuff;               /* screen coords of                    */
ULONG   yScrBuff;               /*  upper-left of screen-save buffer   */

ULONG   htScrBuff;              /* current height, changes each redraw */

ULONG   offPtrSave;             /* offset of pointer-save buffer       */
ULONG   offScrSave;             /* offset of screen-save buffer        */

ULONG   ulTextScrSave;          /* save area for screen data under text image */

ULONG   ulTextANDMaskVideo;     /* also called the screen mask         */
ULONG   ulTextXORMaskVideo;     /* also called the pointer mask        */

ULONG   xHotVideo;              /* graphics pointer hot-spot           */
ULONG   yHotVideo;

BYTE    abANDMask[PTRSAVSIZE];
BYTE    abXORMask[PTRSAVSIZE];

BYTE    abPtrSave1[PTRSAVSIZE];
BYTE    abPtrSave2[PTRSAVSIZE];

BYTE    abScrSave1[SCRSAVSIZE];
BYTE    abScrSave2[SCRSAVSIZE];

} PTRDATA;                      /* end of PTRDATA structure            */

/* JWK01 begin */

#ifdef TSENGW32


/* accelerator operation constants */

/* status register */
#define  TSENG_ACL_WRST                  0x01     /* ACL queue empty bit set=full*/
#define  TSENG_ACL_RDST                  0x02     /* ACL status busy bit set=busy */
#define  TSENG_ACL_SSO                   0x08     /* ACL screen to screen */

/* operation state register */
#define  TSENG_ACL_RSO                   0x01     /* ACL restore Op State */
#define  TSENG_ACL_RMO                   0x08     /* ACL Resume Operation */
#define  TSENG_ACL_ASEN                  0x10     /* ACL address start enable */

/* terminate/suspend register */
#define  TSENG_ACL_TO                    0x10     /* terminate operation */
#define  TSENG_ACL_HWE                   0x08     /* host write enable */
#define  TSENG_ACL_HRE                   0x04     /* host read enable */
#define  TSENG_ACL_FLO                   0x02     /* Flush ScrnToScrn */
#define  TSENG_ACL_SO                    0x01     /* Suspend Operation */

/* other constants */
#define  TSENG_DAC_PIXELMPORT         0x3c6
#define  TSENG_DAC_WRITEPORT          0x3c7
#define  TSENG_DAC_READPORT           0x3c8
#define  TSENG_DAC_DATAPORT           0x3c9
#define  TSENG_BASE_INDEX       0x210A         /* for W32 crtcb and mmu */
#define  TSENG_BASE_DATA        0x210B         /* for W32 crtcb and mmu */

/* CRTCB (IMA and ACL) structure */
/* may need adjustment for rev I vs rev P */
typedef struct TSENGMMIO_s{
ULONG  MMUBasePointer0;
ULONG  MMUBasePointer1;
ULONG  MMUBasePointer2;
BYTE   Reserved1[7];
BYTE   MMUControl;
BYTE   Reserved2[0x1c];
BYTE   ACLSuspendTerminate;
BYTE   ACLOperationState;
BYTE   ACLSyncEnable;
BYTE   ACLWriteInterfaceValid;
BYTE   ACLInterruptMask;
BYTE   ACLInterruptStatus;
BYTE   ACLAcceleratorStatus;
BYTE   Reserved3;
USHORT ACLXPosition;
USHORT ACLYPosition;
BYTE   Reserved4[0x44];
ULONG  ACLPatternAddress;
ULONG  ACLSourceAddress;
USHORT ACLPatternYOffset;
USHORT ACLSourceYOffset;
USHORT ACLDestinationYOffset;
BYTE   ACLPixelDepth;
BYTE   ACLXYDirection;
BYTE   ACLPatternWrap;
BYTE   Reserved5;
BYTE   ACLSourceWrap;
BYTE   Reserved6[0x05];
USHORT ACLXCount;
USHORT ACLYCount;
BYTE   Reserved7;
BYTE   ACLRoutingControl;
BYTE   Reserved8;
BYTE   ACLBackgroundROP;
BYTE   ACLForegroundROP;
ULONG  ACLDestinationAddress;
ULONG  ACLMixAddress;
BYTE   ACLMixYOffset;
BYTE   Reserved9;
BYTE   ACLErrorTerm;
BYTE   Reserveda;
BYTE   ACLDeltaMinor;
BYTE   Reservedb;
BYTE   ACLDeltaMajor;
} TSENGMMIO;
typedef TSENGMMIO *PTSENGMMIO ;

typedef struct TSENGW32INFO_s {
BOOL    flW32AcceleratorOn;
BOOL    flW32HardwareCursorEnabled;
BOOL    flW32ACLMapped;
HMXSEM  hmxMMIO;                /* @V2.2SEN01 */
ULONG   VGABase;
ULONG   VGARange;
ULONG   MMUBase;
ULONG   MMURange;
ULONG   MMUApertureSize;
ULONG   MMRBase;
ULONG   MMRRange;
ULONG   EMRBase;
ULONG   EMRRange;
USHORT  uMMIOIndex;
BYTE    regTsengSegSelect;                 /* Tseng Seg Select register  */
BYTE    regTsengSegSelect2;                /* w32 Extended Tseng Seg Select register  */
BYTE    aregCRTCBData[MAX_CRTCBREGS];      /* w32 CRTCB data */
BYTE    regCRTCBIndex;                     /* w32 CRTCB index */
BYTE    aregHWCursorData[MAX_CRTCBREGS];
TSENGMMIO MMIOSave1;                  /* ACL save data 1 */
TSENGMMIO MMIOSave2;                  /* ACL save data 2 */
PTSENGMMIO pW32MMIO;                  /* flat offset to MemoryMappedIO */
} TSENGW32INFO;

#endif /* TSENGW32 */

/* JWK01 end */



#ifdef SVGA                                       /*@V2.0DRW01*//*@V2.1MNH14*/
typedef struct vdmSVGAdatax_s{  /* PERVDMDATA extension       *//*@V2.1YEE05*/
USHORT  usCurrentBank;                                  /* @V2.2SEN01 */
USHORT  usMaxBanks;                                     /* @V2.2SEN01 */
PBVDM   pvdmMMIOActive;         /* address of VDM's active MMIO, which is @V2.2SEN01*/
                                /* a subset of physical VRAM (exclusive of pvdmPhysVRAM) */
ULONG   npgMMIOActive;          /* # of pages in active MMIO, an MMIO page is considered linear */
                                /* its page state will be marked as GRFX256   */
HEVSEM  hevDelaySwitch;         /* set on vvBgndContext to delay BGND switch for 2F processing */
HEVSEM  hev8514WakeUp;          /* 8514 IO semaphore          *//*@V2.1SEN15*/
HEVSEM  hev8514Busy;            /* 8514 engine busy sem       *//*@V2.1SEN15*/
BOOL    flBgndExecEnabled;                                      /*@V2.0DRW03*/
ULONG   ulLogicalBytes;                                         /*@V2.0SEN03*/
BYTE    aregXGAData[AXGA_TOTAL];/* XGA Compatible registers   *//*@V2.0TPL13*/
BYTE    regOrchidClockSelect;                                   /*@V2.0DRW06*/
BYTE    stateTridentRegDef;     /* Trident register definition register state */
BYTE    regTridentModeCtrl2;    /* non-zero (TRUE) => 'new' definition */
USHORT  regAXSave;              /* saved AX for VDM while injecting the restore mode @V2.2SEN05 */
USHORT  regBXSave;              /* saved BX for VDM while injecting the restore mode @V2.2SEN05 */
#ifdef ATI
BYTE    regATIIndx;             /* shadows PORT_ATIVGA_INDX            */
BYTE   aregATIData[MAX_ATIREGS];/* shadows PORT_ATIVGA_DATA[MAX_ATIREGS] */
#endif /* ATI */

#ifdef TSENGW32                                                 /* JWK01 */
TSENGW32INFO VdmTSENG;           /* TSENGINFO extension */      /* JWK01 */
#endif /* TSENGW32 */                                           /* JWK01 */

WORD    wreg8514MFIndx;         /* for interim settings (for byte I/O) */
WORD    awreg8514MFData[MFINDX_INDXTOTAL];
WORD    wRegShadow [0x100];             /*Accelerator regs */   /*@V2.1MNH08*/
ULONG   aulReLockRegs [MAX_LOCKUNLOCKCMD];                      /*@V2.1MNH06*/
ULONG   aulScratchRegs [0x100];                                 /*@V2.1MNH14*/
BYTE    abregHiColorDac [MAX_HICOLORDACREGS];                   /*@V2.1MNH25*/
BYTE    abBiosData_1[30];                                       /* @V2.2SEN01 */
BYTE    abBiosData_2[7];                                        /* @V2.2SEN01 */
} VDMSVGADATAX;                 /* end PERVDMDATA extension   *//*@V2.1YEE05*/
#endif /* SVGA */                                               /*@V2.1MNH14*/

typedef struct vdmdata_s { /* beginning of PERVDMDATA structure        */

 /*
 ** Per-VDM data
 **
 **  In flVDM, the OWNER bit indicates whether or not this VVD is actively
 **  responsible for the associated display.  If another VVD "requests" control
 **  away from us, the OWNER bit is cleared until we are "requested" to regain
 **  control.  For the interim, all I/O and page-fault hooks are undone, as are
 **  all VRAM mappings.
 **
 **  ioh is simply some scratch storage that we use to install/deinstall all
 **  our I/O hooks;  for security, the VDH services require that the caller
 **  supply the same address to VDHSetIOHookState and VDHDeInstallIOHook that
 **  it supplied to VDHInstallIOHook.
 **
 **  mstateCopy records the last state selected by vvSetCopyState, and is an
 **  optimization;  it allows vvSetCopyState to ignore a request for a state
 **  already in effect, and it is cleared by vvRestoreCopyState.
 */

FLAGS   flVDMVideo;             /* per-VDM flags                       */
FLAGS   flVDMXVideo;            /* extended per-VDM flags              */
FLAGS   flVDMX2Video;           /* extended per-VDM flags @V2.0SEN09   */

HVDM    hvdmVideo;              /* handle for this VDM                 */

ULONG   sgIDVideo;              /* screen group # for this VDM         */

MSTATE  mstateCopy;             /* currently selected copy-state       */

ULONG   ulBIOSMode;             /* last BIOS mode # set                */

HMXSEM  hmxVideoState;          /* semaphore for internal state protection */
HMXSEM  hmxWindowedState;
HEVSEM  hevFreezeThaw;          /* set on freeze, cleared on thaw      */
HHOOK   hhookFgndContext;       /* hook handle for VVFgndContext       */
HHOOK   hhookBgndContext;       /* hook handle for VVBgndContext       */
HHOOK   hhookInitContext;       /* hook handle for VVInitContext       */
HHOOK   hhookUpdatePtrContext;  /* hook handle for VVUpdatePtrContext  */
#ifdef EGAVGA
HHOOK   hhookUpdateContext;     /* hook handle for VVUpdateContext     */
HHOOK   hhookUpdatePhysContext; /* hook handle for VVUpdatePhysContext */
HHOOK   hhookUnMapPhysContext;  /* hook handle for VVUnMapPhysContext  @V2.0JWK61 */
#endif
HHOOK   hhookInt10SetModeReturn;/* hook handle for VVInt10SetModeReturn */
HHOOK   hhookInt10Return;       /* hook handle for VVInt10Return       */
HHOOK   hhookInt2FReturn;       /* hook handle for VVInt2FReturn       */
#ifdef SVGA                     /* @V2.2SEN01 */
HHOOK   hhookRestoreModeReturn; /* hook handle for VVSVGARestoreModeReturn  */
HHOOK   hhookFgndRestoreContext;/* hook handle for vvSVGARestoreFgndContext */
#endif
PVOID   pInt10ReturnData;
BOOL    flV86mode;              /* VPM mode flag @V2.0WKB02            */
ULONG   nInt10Setmode;/* # of recursive int 10 setmode calls @V2.0TPL14 */
PTRDATA PtrData;                /* pointer data                        */


 /*
 ** Virtual/shadow hardware information (modified)
 **
 **  pvdmPhysVRAMActive is starting address of active VRAM.  On an EGA/VGA,
 **  active VRAM is the region of physical addresses that VRAM is/should be
 **  currently responding to.  This region always lies somewhere within
 **  the pvdmPhysVRAM region, and is controlled by REG_GDCMISC.
 **
 **  npgPhysVRAMActive is the length (in pages) of the active VRAM region.
 **  On supported adapters, the active region can only be at one of a handful
 **  of locations (A0000, B0000 or B8000), and is always a whole number of
 **  pages.
 **
 **  pvdmPhysVRAMVisible is the area WITHIN pvdmPhysVRAMActive that's currently
 **  visible.  This is important for clipboard requests, pointer support, etc.
 **
 **  nbPhysVRAMVisible is the length of the visible active VRAM region, in
 **  bytes.  nbVRAMRow is the length of a row (cells or pixels, depending on
 **  the video mode), also in bytes.  offVRAMOddEven is the offset between
 **  even and odd scan lines;  normally, they are sequential and so this value
 **  is zero, but for CGA graphics modes, it will be 8192 (8kb).  Finally,
 **  nBitsPerPlane is the number bits in a single plane that encode the color
 **  of one pixel on the screen; it is only a count of bits within a plane, not
 **  across planes, and the total number of bits per pixel should be
 **  calculated as (nBitsPerPixel * nPlanes) -- although in every CGA/EGA/VGA
 **  mode, one of those values is always 1.
 **
 **  mstate is the VDM's current memory state.  It may not match the true
 **  hardware state at any instant for a foreground VDM undergoing limited
 **  trapping, but in those cases we use vvUpdateVideoState to "refresh" our
 **  understanding of the current state.
 */

VVMODE  vvMode;                 /* current mode information            */
VVCURSOR vvCursor;              /* current cursor information          */

ULONG   nbVRAMRow;              /* width of a scan line, in bytes      */
ULONG   offOddBank;             /* offset between odd/even rows, in bytes */
ULONG   nBitsPixel;             /* bits per pixel (within each plane)  */
ULONG   nPixelsByte;            /* pixels ber byte (within each plane) */
ULONG   nPlanes;                /* number of active planes             */

PBVDM   pvdmPhysVRAMActive;     /* address of VDM's active VRAM, which is */
                                /* a subset of physical VRAM (pvdmPhysVRAM) */

ULONG   offPhysVRAMActive;      /* offset of active VRAM, relative to both */
                                /* pvdmPhysVRAM & pPhysVRAM            */

ULONG   npgPhysVRAMActive;      /* # of pages in active VRAM           */
                                /* this is a subset of pvdmPhysVRAM    */

PBVDM   pvdmPhysVRAMVisible;    /* address of VDM's active/visible VRAM */
                                /* this is a subset of pvdmPhysVRAMActive */

ULONG   offPhysVRAMVisible;     /* offset of visible VRAM, relative to */
                                /* pvdmPhysVRAMActive                  */

ULONG   nbPhysVRAMVisible;      /* # of bytes in active/visible VRAM   */
                                /* this is a subset of pvdmPhysVRAMActive */

MSTATE  mstateVideo;            /* VDM memory state (TEXT, FONT, GRFX, ...) */


 /*
 ** Virtual buffer management
 **
 **  What is referred throughout the VVD as the "virtual buffer" is
 **  actually 1 or more "plane" buffers.
 **
 **  If a VDM is MEMORY_TEXT, apPlane[0] will point to a plane buffer
 **  containing the VDM's text information, and appropriate entries in
 **  aapstate[0..m][0] will be set to PAGE_TEXT;  apPlane[2] will point to
 **  a buffer containing the VDM's font information, and entries in
 **  aapstate[0..n][2] will be set to PAGE_FONT;  apPlane[1] and
 **  apPlane[3] will generally either point to buffers whose individual page
 **  states are NONE, or point to nothing (ie, not even allocated).
 **
 **  When a VDM is MEMORY_FONT, the same basic set of assumptions
 **  applies (ie, we treat this like a text-mode configuration to avoid
 **  freezing VDMs when they are loading fonts).
 **
 **  Finally, when a VDM is MEMORY_GRFX, each plane buffer simply contains the
 **  contents for the associated plane and aapstate[0..n][x] will be set to
 **  PAGE_GRFX.  When a VDM switches from a MEMORY_TEXT mode to a MEMORY_GRFX
 **  mode, the virtual buffer format is converted:  all pages containing
 **  PAGE_TEXT information are converted to appropriate pages of PAGE_GRFX
 **  information, since character data is really only the even bytes in plane
 **  0 and attributes all the even bytes in plane 1, meaning that for pages in
 **  the TEXT state, we only have partial graphics information for planes 0 and
 **  1 (ie, the EVEN bytes), none at all for plane 3, and some limited amount
 **  for plane 2 (this is where the VDM's font(s) are stored).  The conversion
 **  step rounds out this limited information, promoting the appropriate pages
 **  to GRFX status.
 **
 **  When a foreground VDM is created, a virtual buffer of size (nPlanes *
 **  npgPlane * PAGESIZE) is allocated.  After the first SetFgnd call, the
 **  VDM's entire VRAM address range becomes invalidated, since we have
 **  no valid data at this time.  The screen may have already been cleared by
 **  the Session Manager, but only insofar as the video signal is concerned;
 **  underneath, the contents of the last foreground screen group remain in
 **  place.  As soon as the VDM begins running, it will perform an Int 10h
 **  that we initiated (see VVCreate), which in turn will initialize all of the
 **  VDM's active VRAM (generally the 32kb from B8000h-BFFFFh).  We trap that
 **  initialization page-by-page, first verifying that a virtual page is
 **  available (which it must be for a foreground VDM), and then exchanging
 **  the page with physical memory;  the state for a such a page becomes
 **  PAGE_TEXT.  When it touches a page in the A0000h-AFFFFh range and the
 **  range is active and the mode is MEMORY_FONT, we follow a similar validation
 **  process, but for the plane 2 portion of the virtual buffer;  the state of
 **  the associated page becomes PAGE_FONT.  And so on....
 **
 **  Later, when the foreground VDM is switched into background, we update
 **  the VDM's state, exchange all valid pages, thereby restoring the previous
 **  screen group's contents, and then map all valid virtual pages into the
 **  VDM's VRAM address space.  A context hook is also established to shrink the
 **  virtual buffer down to some smaller size.
 **
 **  @V2.0DRW01 SVGA: Added an extra array dimension to apPlane, anpgPlane and
 **                   aapstate to allow more virtual memory to be handled.
 **                   Using up to 4 banks together with the current
 **                   structures, up to 1Meg of memory is kept track of.  Note
 **                   that putting the new BANK index first allows the
 **                   structure to be consistent with its old definition when
 **                   setting an index of zero (this courtesy of the way 'C'
 **                   stores arrays).  In linear modes, banks together with
 **                   planes give up to 16 pieces of 64k memory (16 pages).
 **                   The concept of planes then falls away and the
 **                   combination keeps track of all the memory.
 **
 **  @V2.0DRW03 SVGA: Change linear-mode virtual buffer management to 64k (bank)
 **                   granular. Now keep a single pointer to a buffer for linear
 **                   modes and a state array (as per aapstate) on a bank basis.
 **                   This allows simpler virtualisation, more efficient save
 **                   and restore of physical VRAM and bitmap copying.
 **
 */

ULONG   ulLinearPages;          /* no of pages                     @V2.0DRW05 */
PBYTE   pLinearBuffer;          /* virtual buffer for linear modes @V2.0DRW03 */
ULONG   nModeBytes;             /* @V2.2SEN01 */
PBYTE   apPlane[MAX_BANKS][MAX_PLANES];    /* pointer(s) to virtual memory buffers */
ULONG   anpgPlane[MAX_BANKS][MAX_PLANES];  /* size(s) for each of the above buffers */

PBYTE   pShadowPlane;           /* shadow buffer (for single-plane graphics) */
ULONG   npgShadowPlane;

PBYTE   pBonusBuffer;           /* buffer for CGA/MONO restriction     */
ULONG   npgBonusBuffer;         /* NOTE: unlike apPlane and pShadowPlane, */
                                /* this is per-VDM memory (freed automatically) */

VPVOID  vpOldStack;             /* original VDM stack (if we had to switch) */
PBVDM   pvdmAltStack;           /* alternate stack we can switch to, if needed */

                                /* page states (NONE, TEXT, FONT, etc) */
                                /* SVGA add 3rd dimension              @V2.0DRW01 */

//c-begin

PSTATE  aapstate[MAX_BANKS][MAX_PAGESPERPLANE][MAX_PLANES];

//c-end


//masm-begin

//PSTATE        aapstate,,MAX_BANKS*MAX_PAGESPERPLANE*MAX_PLANES

//masm-end
#ifdef SVGA                             /* @V2.2SEN01 */
                                /* bank-based states (64k granular aapstate[])*/
BSTATE  abstate[MAX_LINEAR_BANKS];                          /* @V2.2SEN01 */
#endif

 /*
 ** for a given PAGE_PHYSICAL video page index,
 ** the corresponding entry in aiVirtToPhys
 ** contains an index into ahPhysPage
 */

ULONG   aiVirtToPhys[MAX_PAGESPERPLANE];

ULONG   aoffPhysDiff[MAX_PAGESPERPLANE];
ULONG   anbPhysDiff[MAX_PAGESPERPLANE];

MSTATE  mstateBuffer;           /* memory state of buffer (not the VDM!) */

FLAGS   flDirtyPages;           /* dirty page info accumulator         */

ULONG   ulDirtyBankEvent;       /* dirty bank number for 256-colour mode @V2.0DRW03 */

 /*
 ** VDHMapPages data structures
 */

ULONG   ulMapCur[VRAM_PAGES];   /* Current VRAM contents               */
VDHMAPTARGET avdhmt[VRAM_PAGES];/* VRAM map targets                    */
VDHMAPSOURCE vdhms;             /* VDH map source descriptor           */
#ifdef VGA
VDHMAPTARGET vdhmt;                                                     /* @V2.0XXX01 */
#endif


 /*
 ** Window support data
 */

ULONG   pidVideo;               /* PID of exclusive access owner, if any */

LSENTRY lseActive;              /* Active list entry for this VDM      */

FLAGS   flEventsPending;        /* event ordinals 1 through n are      */
FLAGS   flEventsHolding;        /* represented by bits 0 through n-1   */
FLAGS   flEventsFlushing;

ULONG   nPeriodic;              /* periodic counter                    */
ULONG   nPeriodicLimit;         /* threshold required                  */
ULONG   nPeeks;                 /* peek counter                        */

HEVSEM  hevShieldSynced;        /* synchronizes windowed VDM with Shield */

VVMODE   vvModeEvent;           /* next mode event to process          */
VVSCROLL vvScrollEvent;         /* next scroll event to process        */
VVSTRING vvStringEvent;         /* next string event to process        */
VVCURSOR vvCursorEvent;         /* next cursor event to process        */
VVCURSOR vvInputEvent;          /* location where next input request made */
FLAGS    flDirtyPageEvent;      /* last dirty pages reported           */

ULONG   nPhysPages;             /* # of PHYSPAGES owned by this VDM    */
ULONG   nDiffPrev;              /* # of differences reported last LVB event */

RECTL   rclDiffPrev;            /* if nDiffPrev == 1, rclDiffPrev == difference */

CHAR    szVDMTitle[MAX_TITLESIZE];
USHORT  fDDEflag;               /* Set/Clear DDE flag                     @V2.0TPL12 */


 /*
 ** Virtual/shadow hardware information
 **
 **  This storage is dedicated to saving I/O state information.  This is
 **  put at the end of the instance data structure because much of it is byte-
 **  oriented, and would tend to screw up the dword-alignment of everything
 **  above without explicit padding.
 */

BYTE    regMode;                /* shadows PORT_MONOMODE/CGAMODE       */
BYTE    regCRTIndx;             /* shadows PORT_MONOCRTINDX/COLRCRTINDX */
BYTE   aregCRTData[MAX_CRTREGS];/* shadows PORT_MONOCTRDATA/COLRCRTDATA[] */
BYTE    regStatus0;             /* shadows PORT_STATUS0                */
BYTE    regStatus1;             /* shadows PORT_MONOSTATUS1/COLRSTATUS1 */
INT     stateStatus1;           /* state of STATUS1 register           */
                                /* (see abNextStatusState)             */
#ifndef CGA                                                     /*@V2.1MNH15*/
BYTE    regHercCompatibility;   /* PORT_HERC_COMPATIBILITY */   /*@V2.1MNH06*/
#endif /* CGA */                                                /*@V2.1MNH15*/

#ifndef MONO                                                    /*@V2.1MNH15*/
BYTE    regColor;               /* shadows PORT_CGACOLOR               */
#endif /* MONO */                                               /*@V2.1MNH15*/

BYTE    regFeature;             /* shadows PORT_MONOFEATURE/COLRFEATURE */

#ifdef EGAVGA
BYTE    regMiscOut;             /* shadows PORT_MISCOUT                */
BYTE    regATCIndx;             /* shadows PORT_ATC0                   */
BYTE   aregATCData[MAX_ATCREGS];/* shadows PORT_ATC1[MAX_ATCREGS]      */
BYTE    regSEQIndx;             /* shadows PORT_SEQINDX                */
BYTE   aregSEQData[MAX_SEQREGS];/* shadows PORT_SEQDATA[MAX_SEQREGS]   */
BYTE    regGDCPos1;             /* shadows PORT_GDCPOS1                */
BYTE    regGDCPos2;             /* shadows PORT_GDCPOS2                */
BYTE    regGDCIndx;             /* shadows PORT_GDCINDX                */
BYTE   aregGDCData[MAX_GDCREGS];/* shadows PORT_GDCDATA[MAX_GDCREGS]   */
INT     stateATC;               /* state of ATC controller             */
#endif

#ifdef VGA
BYTE    regVVReserved;          /* Reserved IsWindow port     *//*@V2.1MNH34*/
BYTE    regDACMask;             /* shadows PORT_VGADACMASK             */
BYTE    regDACIndx;             /* shadows PORT_VGADACREAD/VGADACWRITE */
DACREG adacDACData[MAX_DACREGS];/* shadows PORT_VGADACDATA[MAX_DACREGS] */
DACREG  dacDACDataCur;          /* current DAC data register           */
INT     stateDAC;               /* state of VGA's DAC                  */
BYTE    regVSE;                 /* video subsystem enable     *//*@V2.1MNH20*/
BYTE    regVSEAlternate;        /* video subsystem enable alt *//*@V2.1MNH20*/
#endif

#ifdef COMPAQ
BYTE    regCompaqCtrl;          /* Compaq Control Mode register        */
#endif

#ifdef EGAVGA
BYTE    bLatches[MAX_PLANES];   /* storage for latches                 */
PBVDM   pCPBuff;                /* codepage buffer                      @V2.0TPL09 */
USHORT  ROMint1fSeg;            /* Graphics Character Table Segment     @V2.0TPL09 */
#endif

#ifdef SVGA                                                     /*@V2.1MNH14*/
VDMSVGADATAX VdmSVGA;           /* VDMDATA extension */         /*@V2.1YEE05*/
#endif /* SVGA */                                               /*@V2.1MNH14*/

} PERVDMDATA;                   /* end of PERVDMDATA structure         */

typedef PERVDMDATA *PVDMDATA;

//masm-begin

//DefData IMPORT,INSTANCE,C
//PERVDMDATA VVData
//VDMData catstr VVData
//EndData

//masm-end

//c-begin

#pragma BEGIN_SWAP_INSTANCE
extern  PERVDMDATA VVData;
#define VDMData VVData
#pragma END_SWAP_INSTANCE

//c-end

 /*
 ** Adapter class (struct) definition
 ** This is a structure containing all adapter specific data and routines
 */

typedef PORT PRIVENTRY PORTFNCGAADJUSTEDPORT( HVDM );           /*@V2.1MNH14*/
typedef ULONG PRIVENTRY ULFNCGASTARTADDR( HVDM );               /*@V2.1MNH14*/
typedef BOOL PRIVENTRY BFNCGAODDEVENMODE( HVDM );               /*@V2.1MNH14*/
typedef BOOL PRIVENTRY BFNCGAHIGHRESMODE( HVDM );               /*@V2.1MNH16*/
typedef USHORT PRIVENTRY USFNCGAHORZDSPEND( HVDM );             /*@V2.1MNH14*/
typedef USHORT PRIVENTRY USFNCGAHORZLOGEND( HVDM );             /*@V2.1MNH14*/
typedef USHORT PRIVENTRY USFNCGAVERTDSPEND( HVDM );             /*@V2.1MNH14*/
typedef USHORT PRIVENTRY USFNCGABITSPERPIXEL( HVDM );           /*@V2.1MNH14*/
typedef USHORT PRIVENTRY USFNCGAPREPARESETMODE( HVDM, PCRF );   /*@V2.1MNH20*/

typedef PORTFNCGAADJUSTEDPORT *PPORTFNCGAADJUSTEDPORT;          /*@V2.1MNH14*/
typedef ULFNCGASTARTADDR      *PULFNCGASTARTADDR;               /*@V2.1MNH14*/
typedef BFNCGAODDEVENMODE     *PBFNCGAODDEVENMODE;              /*@V2.1MNH14*/
typedef BFNCGAHIGHRESMODE     *PBFNCGAHIGHRESMODE;              /*@V2.1MNH16*/
typedef USFNCGAHORZDSPEND     *PUSFNCGAHORZDSPEND;              /*@V2.1MNH14*/
typedef USFNCGAHORZLOGEND     *PUSFNCGAHORZLOGEND;              /*@V2.1MNH14*/
typedef USFNCGAVERTDSPEND     *PUSFNCGAVERTDSPEND;              /*@V2.1MNH14*/
typedef USFNCGABITSPERPIXEL   *PUSFNCGABITSPERPIXEL;            /*@V2.1MNH14*/
typedef USFNCGAPREPARESETMODE *PUSFNCGAPREPARESETMODE;          /*@V2.1MNH20*/

typedef struct sCGAInfo_s {                                     /*@V2.1MNH14*/
  PPORTFNCGAADJUSTEDPORT pportfnCGAAdjustedPort;                /*@V2.1MNH14*/
  PULFNCGASTARTADDR pulfnCGAStartAddr;                          /*@V2.1MNH14*/
  PBFNCGAODDEVENMODE pbfnCGAOddEvenMode;                        /*@V2.1MNH14*/
  PBFNCGAHIGHRESMODE pbfnCGAHighResMode;                        /*@V2.1MNH16*/
  PUSFNCGAHORZDSPEND pusfnCGAHorzDspEnd;                        /*@V2.1MNH14*/
  PUSFNCGAHORZLOGEND pusfnCGAHorzLogEnd;                        /*@V2.1MNH14*/
  PUSFNCGAVERTDSPEND pusfnCGAVertDspEnd;                        /*@V2.1MNH14*/
  PUSFNCGABITSPERPIXEL pusfnCGABitsPerPixel;                    /*@V2.1MNH14*/
  PUSFNCGAPREPARESETMODE pusfnCGAPrepareSetMode;                /*@V2.1MNH20*/
} SCGAINFO;                                                     /*@V2.1MNH14*/
typedef SCGAINFO *PSCGAINFO;                                    /*@V2.1MNH14*/

#ifdef MONOCGA                                                  /*@V2.1MNH14*/
typedef SCGAINFO SADAPTERINFO;                                  /*@V2.1MNH14*/
#endif /* MONOCGA */                                            /*@V2.1MNH14*/

#ifdef EGAVGA                                                   /*@V2.1MNH14*/

typedef BOOL PRIVENTRY BFNEGAPACKEDMODE( HVDM );                /*@V2.1MNH14*/
typedef USHORT PRIVENTRY USFNEGAVERTLINECMP( HVDM );            /*@V2.1MNH14*/

typedef BFNEGAPACKEDMODE      *PBFNEGAPACKEDMODE;               /*@V2.1MNH14*/
typedef USFNEGAVERTLINECMP    *PUSFNEGAVERTLINECMP;             /*@V2.1MNH14*/

typedef struct sEGAInfo_s {                                     /*@V2.1MNH14*/
  SCGAINFO sCGAInfo;                                            /*@V2.1MNH14*/
  PBFNEGAPACKEDMODE pbfnEGAPackedMode;                          /*@V2.1MNH14*/
  PUSFNEGAVERTLINECMP pusfnEGAVertLineCmp;                      /*@V2.1MNH14*/
} SEGAINFO;                                                     /*@V2.1MNH14*/
typedef SEGAINFO *PSEGAINFO;                                    /*@V2.1MNH14*/

#ifndef VGA                                                     /*@V2.1MNH14*/
typedef SEGAINFO SADAPTERINFO;                                  /*@V2.1MNH14*/
#endif /* VGA */                                                /*@V2.1MNH14*/

#endif /* EGAVGA */                                             /*@V2.1MNH14*/

#ifdef VGA                                                      /*@V2.1MNH14*/

typedef VOID PRIVENTRY FNDACIPFCLEAR( HVDM );                   /*@V2.1MNH25*/
typedef VOID PRIVENTRY FNDACIPFSET( HVDM );                     /*@V2.1MNH25*/
typedef VOID PRIVENTRY FNDACSAVE( HVDM );                       /*@V2.1MNH20*/
typedef VOID PRIVENTRY FNDACRESTORE( HVDM );                    /*@V2.1MNH20*/

typedef FNDACIPFCLEAR  *PFNDACIPFCLEAR;                         /*@V2.1MNH25*/
typedef FNDACIPFSET    *PFNDACIPFSET;                           /*@V2.1MNH25*/
typedef FNDACSAVE      *PFNDACSAVE;                             /*@V2.1MNH20*/
typedef FNDACRESTORE   *PFNDACRESTORE;                          /*@V2.1MNH20*/

typedef struct sDacInfo_s {                                     /*@V2.1MNH25*/
  PCHAR pszDacName;                                             /*@V2.1MNH25*/
  PFNDACIPFCLEAR pfnDacIPFClear;                                /*@V2.1MNH25*/
  PFNDACIPFSET pfnDacIPFSet;                                    /*@V2.1MNH25*/
  PFNDACSAVE pfnDacSave;                                        /*@V2.1MNH25*/
  PFNDACRESTORE pfnDacRestore;                                  /*@V2.1MNH25*/
} SDACINFO;                                                     /*@V2.1MNH14*/
typedef SDACINFO *PSDACINFO;                                    /*@V2.1MNH14*/

typedef VOID PRIVENTRY FNVGADACSAVE( HVDM );                    /*@V2.1MNH20*/
typedef VOID PRIVENTRY FNVGADACRESTORE( HVDM );                 /*@V2.1MNH20*/

typedef FNVGADACSAVE          *PFNVGADACSAVE;                   /*@V2.1MNH20*/
typedef FNVGADACRESTORE       *PFNVGADACRESTORE;                /*@V2.1MNH20*/

typedef struct sVGAInfo_s {                                     /*@V2.1MNH20*/
  SEGAINFO sEGAInfo;                                            /*@V2.1MNH20*/
  PFNVGADACSAVE pfnVGADACSave;                                  /*@V2.1MNH20*/
  PFNVGADACRESTORE pfnVGADACRestore;                            /*@V2.1MNH20*/
} SVGAINFO;                                                     /*@V2.1MNH20*/
typedef SVGAINFO *PSVGAINFO;                                    /*@V2.1MNH20*/

#ifndef SVGA                                                     /*@V2.1MNH14*/
typedef SVGAINFO SADAPTERINFO;                                  /*@V2.1MNH14*/
#endif /* SVGA */                                               /*@V2.1MNH14*/

#endif /* VGA */                                                /*@V2.1MNH14*/

#ifdef SVGA                                                     /*@V2.1MNH14*/

typedef VOID PRIVENTRY FNTRAPSHADOWUPDATE( PSTRAPREGINFO, PVOID );/*@V2.1MNH14*/
typedef VOID PRIVENTRY FNTRAPSHADOWREAD( PSTRAPREGINFO, PVOID );/*@V2.1MNH14*/
typedef VOID PRIVENTRY FNTRAPSHADOWWRITE( PSTRAPREGINFO, PVOID );/*@V2.1MNH14*/
typedef VOID PRIVENTRY FNTRAPREALREAD( PSTRAPREGINFO, PVOID );  /*@V2.1MNH14*/
typedef VOID PRIVENTRY FNTRAPREALWRITE( PSTRAPREGINFO, PVOID ); /*@V2.1MNH14*/
typedef VOID PRIVENTRY FNTRAPUNHOOK( PSTRAPREGINFO );           /*@V2.1MNH14*/
typedef FNTRAPSHADOWUPDATE *PFNTRAPSHADOWUPDATE;                /*@V2.1MNH13*/
typedef FNTRAPSHADOWREAD   *PFNTRAPSHADOWREAD;                  /*@V2.1MNH13*/
typedef FNTRAPSHADOWWRITE  *PFNTRAPSHADOWWRITE;                 /*@V2.1MNH13*/
typedef FNTRAPREALREAD     *PFNTRAPREALREAD;                    /*@V2.1MNH13*/
typedef FNTRAPREALWRITE    *PFNTRAPREALWRITE;                   /*@V2.1MNH13*/
typedef FNTRAPUNHOOK       *PFNTRAPUNHOOK;                      /*@V2.1MNH13*/

typedef struct sTrapRegPartInfo_s {                             /*@V2.1MNH13*/
  PFNTRAPSHADOWUPDATE pfnTrapShadowUpdate;                      /*@V2.1MNH13*/
  PFNTRAPSHADOWREAD pfnTrapShadowRead;                          /*@V2.1MNH13*/
  PFNTRAPSHADOWWRITE pfnTrapShadowWrite;                        /*@V2.1MNH13*/
  PFNTRAPREALREAD pfnTrapRealRead;                              /*@V2.1MNH13*/
  PFNTRAPREALWRITE pfnTrapRealWrite;                            /*@V2.1MNH13*/
  PFNTRAPUNHOOK pfnTrapUnhook;                                  /*@V2.1MNH13*/
} STRAPREGPARTINFO;                                             /*@V2.1MNH13*/
typedef STRAPREGPARTINFO *PSTRAPREGPARTINFO;                    /*@V2.1MNH13*/

typedef UINT PRIVENTRY UIFNACCELERATORPORTINDEX( PORT );        /*@V2.1MNH14*/
typedef BOOL PRIVENTRY BFNACCELERATORCHIP( VOID );              /*@V2.1MNH14*/
typedef BOOL PRIVENTRY BFNACCELERATORISON( HVDM );              /*@V2.1MNH14*/
typedef BOOL PRIVENTRY BFNACCELERATORCREATE( HVDM );            /*@V2.2SEN01*/
typedef BOOL PRIVENTRY BFNACCELERATORTERMINATE( HVDM );         /*@V2.2SEN01*/
typedef BOOL PRIVENTRY BFNACCELERATORBUSY( HVDM );              /*@V2.1MNH14*/
typedef VOID PRIVENTRY FNACCELERATORRESET(  HVDM );             /*@V2.1MNH14*/
typedef VOID PRIVENTRY FNACCELERATORINSTALLIOHOOKS( VOID );     /*@V2.1MNH14*/
typedef VOID PRIVENTRY FNACCELERATORSETIOHOOKS( FLAGS );        /*@V2.1MNH14*/
typedef VOID PRIVENTRY FNACCELERATORSETBGNDONLYHOOKS( FLAGS );  /*@V2.1MNH14*/
typedef VOID PRIVENTRY FNACCELERATORUPDATESCRNSTATE( HVDM );    /*@V2.1MNH14*/
typedef VOID PRIVENTRY FNUPDATEMODEDATA( HVDM );                /*@V2.2SEN01*/
typedef VOID PRIVENTRY FNACCELERATORUPDATEIOSTATE( HVDM );      /*@V2.1MNH14*/
typedef VOID PRIVENTRY FNACCELERATORRESTOREIOSTATE( HVDM );     /*@V2.1MNH14*/
typedef VOID PRIVENTRY FNACCELERATORINIT( HVDM );               /*@V2.1MNH14*/
typedef VOID PRIVENTRY FNACTIVEVRAM(HVDM );                    /* @V2.2SEN01 */
typedef BOOL PRIVENTRY FNUPDATEMEMORYMAP(HVDM,PVDM,PULONG );                    /* @V2.2SEN01 */
typedef UIFNACCELERATORPORTINDEX      *PUIFNACCELERATORPORTINDEX;      /*@V2.1MNH14*/
typedef BFNACCELERATORCHIP            *PBFNACCELERATORCHIP;            /*@V2.1MNH14*/
typedef BFNACCELERATORISON            *PBFNACCELERATORISON;            /*@V2.1MNH14*/
typedef BFNACCELERATORCREATE         *PBFNACCELERATORCREATE;            /*@V2.2SEN01*/
typedef BFNACCELERATORTERMINATE      *PBFNACCELERATORTERMINATE;         /*@V2.2SEN01*/
typedef BFNACCELERATORBUSY            *PBFNACCELERATORBUSY;            /*@V2.1MNH14*/
typedef FNACCELERATORRESET            *PFNACCELERATORRESET;            /*@V2.1MNH14*/
typedef FNACCELERATORINSTALLIOHOOKS   *PFNACCELERATORINSTALLIOHOOKS;   /*@V2.1MNH14*/
typedef FNACCELERATORSETIOHOOKS       *PFNACCELERATORSETIOHOOKS;       /*@V2.1MNH14*/
typedef FNACCELERATORSETBGNDONLYHOOKS *PFNACCELERATORSETBGNDONLYHOOKS; /*@V2.1MNH14*/
typedef FNACCELERATORUPDATESCRNSTATE  *PFNACCELERATORUPDATESCRNSTATE;  /*@V2.1MNH14*/
typedef FNUPDATEMODEDATA              *PFNUPDATEMODEDATA;       /*@V2.1MNH14, @V2.2SEN01*/
typedef FNACCELERATORUPDATEIOSTATE    *PFNACCELERATORUPDATEIOSTATE;    /*@V2.1MNH14*/
typedef FNACCELERATORRESTOREIOSTATE   *PFNACCELERATORRESTOREIOSTATE;   /*@V2.1MNH14*/
typedef FNACCELERATORINIT             *PFNACCELERATORINIT;             /*@V2.1MNH14*/
typedef FNACTIVEVRAM                  *PFNACTIVEVRAM;                  /* @V2.2SEN01 */
typedef FNUPDATEMEMORYMAP             *PFNUPDATEMEMORYMAP;              /* @V2.2SEN01 */
typedef struct sAcceleratorInfo_s {                             /*@V2.1MNH13*/
  PSTRAPREGINFO psAcceleratorTrapRegInfo;                       /*@V2.1MNH13*/
  UINT uiAcceleratorTrapWRegSize;                               /*@V2.1MNH13*/
  PUIFNACCELERATORPORTINDEX      puifnAcceleratorPortIndex;     /*@V2.1MNH13*/
  PBFNACCELERATORCHIP            pbfnAcceleratorChip;           /*@V2.1MNH13*/
  PBFNACCELERATORISON            pbfnAcceleratorIsOn;           /*@V2.1MNH13*/
  PBFNACCELERATORCREATE          pbfnAcceleratorCreate;         /* @V2.2SEN01 */
  PBFNACCELERATORTERMINATE       pbfnAcceleratorDestroy;       /* @V2.2SEN01 */
  PBFNACCELERATORBUSY            pbfnAcceleratorBusy;           /*@V2.1MNH13*/
  PFNACCELERATORRESET            pfnAcceleratorReset;           /*@V2.1MNH13*/
  PFNACCELERATORINSTALLIOHOOKS   pfnAcceleratorInstallIoHooks;  /*@V2.1MNH13*/
  PFNACCELERATORSETIOHOOKS       pfnAcceleratorSetIoHooks;      /*@V2.1MNH13*/
  PFNACCELERATORSETBGNDONLYHOOKS pfnAcceleratorSetBgndOnlyHooks;/*@V2.1MNH13*/
  PFNACCELERATORUPDATESCRNSTATE  pfnAcceleratorUpdateScrnState; /*@V2.1MNH13*/
  PFNACCELERATORUPDATEIOSTATE    pfnAcceleratorUpdateIoState;   /*@V2.1MNH13*/
  PFNACCELERATORRESTOREIOSTATE   pfnAcceleratorRestoreIoState;  /*@V2.1MNH13*/
  PFNACCELERATORINIT             pfnAcceleratorInit;            /*@V2.1MNH13*/
  PFNACTIVEVRAM                  pfnActiveMemoryMap;            /*@V2.2SEN01*/
  PFNUPDATEMEMORYMAP             pfnUpdateMemoryMapState;       /* @V2.2SEN01 */
} SACCELERATORINFO;                                             /*@V2.1MNH13*/
typedef SACCELERATORINFO *PSACCELERATORINFO;                    /*@V2.1MNH13*/

typedef PWORD PRIVENTRY PWFNA8514READMFREGSHADOW( VOID );       /*@V2.1MNH14*/
typedef PWFNA8514READMFREGSHADOW *PPWFNA8514READMFREGSHADOW;    /*@V2.1MNH14*/

typedef struct sA8514Info_s {                                   /*@V2.1MNH13*/
  SACCELERATORINFO sAcceleratorInfo;                            /*@V2.1MNH13*/
  PPWFNA8514READMFREGSHADOW ppwfnA8514ReadMFRegShadow;          /*@V2.1MNH13*/
} SA8514INFO;                                                   /*@V2.1MNH13*/
typedef SA8514INFO *PSA8514INFO;                                /*@V2.1MNH13*/

typedef VOID PRIVENTRY FNSVGAEDITTABLES( VOID );                /*@V2.1MNH14*/
typedef BOOL PRIVENTRY BFNSVGAINTERLACED( HVDM );               /*@V2.1MNH14*/
typedef VOID PRIVENTRY FNSVGAUPDATEIOSTATE( HVDM );             /*@V2.1MNH14*/
typedef VOID PRIVENTRY FNSVGARESTOREIOSTATE( HVDM );            /*@V2.1MNH14*/
typedef VOID PRIVENTRY FNSVGASETBANK( HVDM, ULONG, BOOL );      /*@V2.1MNH14*/
typedef ULONG PRIVENTRY ULFNSVGAGETBANK( HVDM, BOOL );          /*@V2.1MNH14*/
typedef VOID PRIVENTRY FNSVGAFIXSETMODE( HVDM, ULONG );         /*@V2.1MNH13*/
typedef VOID PRIVENTRY FNSVGAFIXSETBGND( HVDM );                /*@V2.1MNH13*/
typedef VOID PRIVENTRY FNSVGAWRITEGDCDATAFGND( BYTE );          /*@V2.1MNH13*/
typedef BYTE PRIVENTRY BFNSVGAREADSEQDATABGND( VOID );          /*@V2.1MNH13*/
typedef VOID PRIVENTRY FNSVGAWRITESEQDATABGND( BYTE );          /*@V2.1MNH13*/
typedef VOID PRIVENTRY FNSVGADACRS2CLEAR( HVDM );               /*@V2.1MNH25*/
typedef VOID PRIVENTRY FNSVGADACRS2SET( HVDM );                 /*@V2.1MNH20*/
typedef VOID PRIVENTRY FNSVGADACRS3( HVDM, BOOL );              /*@V2.1MNH20*/

typedef FNSVGAEDITTABLES       *PFNSVGAEDITTABLES;              /*@V2.1MNH14*/
typedef BFNSVGAINTERLACED      *PBFNSVGAINTERLACED;             /*@V2.1MNH14*/
typedef FNSVGAUPDATEIOSTATE    *PFNSVGAUPDATEIOSTATE;           /*@V2.1MNH14*/
typedef FNSVGARESTOREIOSTATE   *PFNSVGARESTOREIOSTATE;          /*@V2.1MNH14*/
typedef FNSVGASETBANK          *PFNSVGASETBANK;                 /*@V2.1MNH14*/
typedef ULFNSVGAGETBANK        *PULFNSVGAGETBANK;               /*@V2.1MNH14*/
typedef FNSVGAFIXSETMODE       *PFNSVGAFIXSETMODE;              /*@V2.1MNH13*/
typedef FNSVGAFIXSETBGND       *PFNSVGAFIXSETBGND;              /*@V2.1MNH13*/
typedef FNSVGAWRITEGDCDATAFGND *PFNSVGAWRITEGDCDATAFGND;        /*@V2.1MNH13*/
typedef BFNSVGAREADSEQDATABGND *PBFNSVGAREADSEQDATABGND;        /*@V2.1MNH13*/
typedef FNSVGAWRITESEQDATABGND *PFNSVGAWRITESEQDATABGND;        /*@V2.1MNH13*/
typedef FNSVGADACRS2CLEAR      *PFNSVGADACRS2CLEAR;             /*@V2.1MNH25*/
typedef FNSVGADACRS2SET        *PFNSVGADACRS2SET;               /*@V2.1MNH20*/
typedef FNSVGADACRS3           *PFNSVGADACRS3;                  /*@V2.1MNH20*/

typedef PCHAR *PPCHAR;

typedef struct sSVGAInfo_s {                                    /*@V2.1MNH20*/
  SVGAINFO sVGAInfo;                                            /*@V2.1MNH14*/
  PFNSVGAEDITTABLES pfnSVGAEditTables;                          /*@V2.1MNH14*/
  PBFNSVGAINTERLACED pbfnSVGAInterlaced;                        /*@V2.1MNH14*/
  PFNSVGAUPDATEIOSTATE pfnSVGAUpdateIoState;                    /*@V2.1MNH14*/
  PFNSVGARESTOREIOSTATE pfnSVGARestoreIoState;                  /*@V2.1MNH14*/
  PFNSVGASETBANK pfnSVGASetBank;                                /*@V2.1MNH13*/
  PULFNSVGAGETBANK pulfnSVGAGetBank;                            /*@V2.1MNH13*/
  PFNSVGAFIXSETMODE pfnSVGAFixSetMode;                          /*@V2.1MNH13*/
  PFNSVGAFIXSETBGND pfnSVGAFixSetBgnd;                          /*@V2.1MNH13*/
  PFNSVGAWRITEGDCDATAFGND pfnSVGAWriteGDCDataFgnd;              /*@V2.1MNH14*/
  PBFNSVGAREADSEQDATABGND pbfnSVGAReadSEQDataBgnd;              /*@V2.1MNH14*/
  PFNSVGAWRITESEQDATABGND pfnSVGAWriteSEQDataBgnd;              /*@V2.1MNH14*/
  PFNSVGADACRS2CLEAR pfnSVGADacRS2Clear;                        /*@V2.1MNH25*/
  PFNSVGADACRS2SET pfnSVGADacRS2Set;                            /*@V2.1MNH20*/
  PFNSVGADACRS3 pfnSVGADacRS3;                                  /*@V2.1MNH20*/
  PSACCELERATORINFO psAcceleratorInfo;                          /*@V2.1MNH13*/
  PCHAR pszSVGAAdapterName;                                     /*@V2.1MNH14*/
  ULONG ulSVGAAdapterMaxChip;                                   /*@V2.1MNH14*/
  PPCHAR ppszSVGAAdapterChipNames;                              /*@V2.1MNH14*/
  PFNUPDATEMODEDATA   pfnUpdateModeData;                        /*@V2.2SEN01*/
  ULONG flSVGAAdapterFlag;                                      /* @V2.2SEN01 */
} SSVGAINFO;
   /* flSVGAAdapterFlag is used to enable features on adapter basis:    */
   /* INT10 restore mode support is enabled either thru PMI or thru this flag   */
   /* vvUpdateIOState as part of the vvInt10SetModePrepare is enabled thru this flag    */
#define SVGA_INT10ENABLED               0x00000001              /* @V2.2SEN01 */
#define SVGA_INT10INITUPDATEENABLED     0x00000002              /* @V2.2SEN01 */
typedef SSVGAINFO *PSSVGAINFO;                                  /*@V2.1MNH20*/

typedef SSVGAINFO SADAPTERINFO;                                 /*@V2.1MNH20*/

#endif /* SVGA */                                               /*@V2.1MNH14*/

typedef SADAPTERINFO *PSADAPTERINFO;                            /*@V2.1MNH14*/

 /*
 ** C function prototypes
 */

 /*
 **  vvinit.c
 */


BOOL    EXPENTRY  VDDInit(PSZ);
#ifdef EGAVGA
VOID    PRIVENTRY vvEditVideoTables(PVOID);
#endif
//VOID    PRIVENTRY vvFindMono(PVOID);                          /*@V2.1MNH39*/
VOID    PRIVENTRY vvFindMono( VOID );                           /*@V2.1MNH39*/

 /*
 **  vvuser.c
 */

BOOL    EXPENTRY  VVCreate(HVDM);
VOID    EXPENTRY  VVCreateDone(HVDM);                           /*@V2.0TPL03*/
VOID    EXPENTRY  VVSetFgnd(HVDM);
VOID    EXPENTRY  VVSetBgnd(HVDM);
BOOL    EXPENTRY  VVChangeCodePage(ULONG);
BOOL    EXPENTRY  VVChangeTitle(PSZ);
VOID    EXPENTRY  VVDestroy(HVDM);
#ifdef PROPERTIES
ULONG   EXPENTRY  VVSetInt10Emulation(ULONG, HVDM, ULONG, PSZ);
ULONG   EXPENTRY  VVSetRetraceEmulation(ULONG, HVDM, ULONG, PSZ);
ULONG   EXPENTRY  VVSetUpdateFrequency(ULONG, HVDM, ULONG, PSZ);
/* ULONG   EXPENTRY  VVSetSyncOutput(ULONG, HVDM, ULONG, PSZ);       @V2.0WKB01 */
ULONG   EXPENTRY  VVSetInt2F(ULONG, HVDM, ULONG, PSZ);
ULONG   EXPENTRY  VVSetOnDemandAlloc(ULONG, HVDM, ULONG, PSZ);
#endif
VOID    HOOKENTRY VVFgndContext(PVOID, PCRF);
VOID    HOOKENTRY VVBgndContext(PVOID, PCRF);
BOOL    PRIVENTRY vvFreezeVDM(HVDM, BOOL);
VOID    PRIVENTRY vvThawVDM(HVDM);
VOID    PRIVENTRY vvInt2FNotify(ULONG, PCRF);
VOID    HOOKENTRY VVInt2FReturn(PVOID, PCRF);

 /*
 **  vvport.c
 */

BOOL    PRIVENTRY vvSetIOHooks( BOOL, BOOL, BOOL );             /*@V2.1MNH15*/
VOID    PRIVENTRY vvEnableIO(VOID);
VOID    HOOKENTRY VVSpecialCaseIO(HHOOK, PCRF);
BYTE    PRIVENTRY vvInput( HVDM, PPLE );                        /*@V2.1MNH06*/
VOID    PRIVENTRY vvOutput( HVDM, PPLE, BYTE );                 /*@V2.1MNH06*/
WORD    PRIVENTRY vvInputWord( HVDM, PSTRAPREGINFO );           /*@V2.1MNH14*/
VOID    PRIVENTRY vvOutputWord( HVDM, PSTRAPREGINFO, WORD );    /*@V2.1MNH14*/
#ifdef VGA
VOID    PRIVENTRY vvDisableVRAM(HVDM);                          /*@V2.1TPL15*/
#endif
VOID    PRIVENTRY vvDisableDisplay(HVDM);
VOID    PRIVENTRY vvEnableDisplay(HVDM);
#ifdef CGA
VOID    EXPENTRY  VVForceDisplay(VOID);
#endif


 /*
 **  vvpage.c
 */

BOOL    PRIVENTRY vvSetFaultHooks(BOOL, BOOL);
VOID    HOOKENTRY VVFaultHook(PVDM);
VOID    HOOKENTRY VVEnableBuffer(BOOL, PCRF);
BOOL    PRIVENTRY vvTransferBuffer(HVDM, INT, BOOL);
#ifdef SVGA
BOOL    PRIVENTRY vvTransferLinearBuffer(HVDM, INT, BOOL);
VOID    EXPENTRY  vvPrepareForTransfer(HVDM, BOOL, ULONG);      /* @V2.0SEN07, @V2.1SEN14 */
#endif
BOOL    PRIVENTRY vvTransferPage(HVDM, INT, INT, INT, BOOL);
VOID    PRIVENTRY vvValidatePage(INT, INT, INT);                /* @V2.2SEN01 */
VOID    PRIVENTRY vvMapBank(INT);                               /* @V2.0DRW03 */
VOID    PRIVENTRY vvUnMapBuffer(VOID);                          /* @V2.0DRW03 */
#ifdef EGAVGA
VOID    PRIVENTRY vvUnvalidatePage(HVDM, HVDM, INT);            /*@V2.2SEN01*/
#endif
BOOL    PRIVENTRY vvUpdatePageStates(HVDM);
VOID    PRIVENTRY vvMapPage(PBVDM, PVOID, INT, INT, INT, FLAGS);     /* @V2.0DRW03, @V2.2SEN01 */
VOID    PRIVENTRY vvFlushPages(HVDM);
ULONG   PRIVENTRY vvRectsFromPageMap(HVDM, FLAGS, ULONG, PVVLVB);
ULONG   PRIVENTRY vvRectsFromShadowBuffer(HVDM, ULONG, PVVLVB);
VOID    PRIVENTRY vvRectFromOffset(HVDM, ULONG, ULONG, PRECTL);


 /*
 **  vvphys.c
 */

#ifdef EGAVGA
VOID    PRIVENTRY vvUpdatePhysPageMap(PVVDRQ);
BOOL    PRIVENTRY vvGetPhysPage(INT);
VOID    PRIVENTRY vvFreePhysPage(HVDM, INT);
VOID    PRIVENTRY vvFreeAllPhysPages(HVDM, BOOL);
ULONG   PRIVENTRY vvGetPhysBytes(ULONG);
VOID    PRIVENTRY vvFreePhysBytes(ULONG, ULONG);
VOID    HOOKENTRY VVUnmapPhysContext(HHOOK, PCRF);
VOID    HOOKENTRY VVUpdateContext(PVOID, PCRF);
VOID    HOOKENTRY VVUpdatePhysContext(PVOID, PCRF);
VOID    PRIVENTRY vvSetCopyState(HVDM, MSTATE, INT);
VOID    PRIVENTRY vvSetIOState( HVDM, PPRLE, INT );
VOID    PRIVENTRY vvRestoreCopyState(HVDM, INT);
VOID    PRIVENTRY vvSaveLatches(HVDM, BOOL);
VOID    PRIVENTRY vvRestoreLatches(HVDM, BOOL);
PBYTE   PRIVENTRY vvQueryLatchAddress(HVDM);
#endif /* EGAVGA */


 /*
 **  vvbuff.c
 */

BOOL    PRIVENTRY vvGrowLinearBuffer(HVDM, INT);                /* @V2.0DRW03 */
BOOL    PRIVENTRY vvGrowBuffer(HVDM, INT, INT, INT);
VOID    PRIVENTRY vvShrinkBuffer(HVDM, BOOL);
BOOL    PRIVENTRY vvGrowPlane(HVDM, INT, INT, INT);
VOID    PRIVENTRY vvShrinkPlane(HVDM, INT, INT, INT);
BOOL    PRIVENTRY vvAllocShadowBuffer(HVDM);


 /*
 **  vvstate.c
 */

VOID    PRIVENTRY vvUpdateAll(HVDM, BOOL);
#ifdef EGAVGA
VOID    PRIVENTRY vvUpdateIOState(HVDM, BOOL);
#endif
VOID    PRIVENTRY vvUpdateMemoryState(HVDM);
VOID    PRIVENTRY vvUpdateScreenState(HVDM, BOOL);
VOID    PRIVENTRY vvUpdateModeData(HVDM);
#ifdef EGAVGA
VOID    PRIVENTRY vvSetCopyState(HVDM, MSTATE, INT);
VOID    PRIVENTRY vvRestoreCopyState(HVDM, INT);
#endif
VOID    PRIVENTRY vvRestoreIOState(HVDM);


 /*
 **  vvmode.c
 */

VOID    PRIVENTRY vvInt10Initialize(PCRF);
BOOL    HOOKENTRY vvInt10SetMode(PCRF);
VOID    HOOKENTRY VVInt10SetModeReturn(PVOID, PCRF);
#ifdef EGAVGA
BOOL    PRIVENTRY vvLoadCodePageFont(VOID);
BOOL    PRIVENTRY vvGetCodePageFont(ULONG, ULONG, PBVDM);       /* @V2.0TPL09 */
#endif

USHORT  PRIVENTRY vvCrtcPort(VOID);                             /*@V2.1MNH05*/

 /*
 **  vvevent.c
 */

VOID    PRIVENTRY vvAddEvent(HVDM, INT, PVOID, FLAGS);
VOID    PRIVENTRY vvFlushEvent(HVDM, INT, FLAGS);
VOID    PRIVENTRY vvFlushEventNotify(HVDM, INT);
VOID    PRIVENTRY vvDeleteEvent(HVDM, INT, FLAGS);
INT     PRIVENTRY vvGetEvent(PHVDM, BOOL);
BOOL    PRIVENTRY VVCheckForEvents(HVDM, BOOL);
BOOL    PRIVENTRY vvCheckForDirtyLVB(HVDM, FLAGS);
BOOL    PRIVENTRY vvCheckForDirtyPalette(HVDM, FLAGS);
BOOL    PRIVENTRY vvEnumerateVDMs(PENUMHOOK, BOOL);
VOID    HOOKENTRY VVEventTimer(PVOID, PCRF);


 /*
 **  vvdevrq.c
 */

LONG    EXPENTRY  VVDevReqProc(HVDM, ULONG, PVOID, PVOID);
LONG    PRIVENTRY vvDevPostPeek(HVDM, BOOL);
LONG    PRIVENTRY vvDevPostRead(HVDM, BOOL);
LONG    PRIVENTRY vvDevPostPaste(HVDM, BOOL);
LONG    PRIVENTRY vvDevPostMouse(HVDM, BOOL);
LONG    PRIVENTRY vvDevAcceptAdapter(HVDM, BOOL);
LONG    PRIVENTRY vvDevReleaseAdapter(HVDM, BOOL);
LONG    PRIVENTRY vvDevAcceptDisplay(HVDM, BOOL);
LONG    PRIVENTRY vvDevReleaseDisplay(HVDM, BOOL);
LONG    PRIVENTRY vvDevPostVideoEvent(HVDM, PVVPOST);
VOID    PRIVENTRY vvKeyboardCheck(HVDM, BOOL);
VOID    HOOKENTRY VVInitContext(PBOOL, PCRF);
LONG    PRIVENTRY vvDevSaveRestoreAdapter(HVDM, BOOL);          /* @V2.0TPL01 */
LONG    PRIVENTRY vvDevRepaint(HVDM, BOOL);                     /* @V2.0TPL01 */
LONG    PRIVENTRY vvDevRequestController(HVDM, BOOL);           /* @V2.0XXX01 */
LONG    PRIVENTRY vvDevFreeController(HVDM, BOOL);              /* @V2.0XXX01 */
LONG    PRIVENTRY vvDevWindowsDeskTop(HVDM, BOOL);              /* @V2.0XXX01 */
VOID    PRIVENTRY vvDevEnableDDE(HVDM, BOOL);                   /* @V2.0TPL12 */
VOID    PRIVENTRY vvDevXGAPresent(HVDM,BOOL);                   /* @V2.0YEE01 */
LONG    PRIVENTRY vvDevUnmapVRAM(HVDM,BOOL);                    /* @V2.0YEE02 */
VOID    PRIVENTRY vvDev8514Present(HVDM,BOOL);                  /* @V2.1SEN12 */


 /*
 **  vvsysrq.c
 */

LONG    EXPENTRY  VVSysReqProc(SGID, ULONG, ULONG, PVOID, ULONG, PVOID);
LONG    PRIVENTRY vvSysSetAccess(HVDM, ULONG, PVOID, ULONG, PVOID);
LONG    PRIVENTRY vvSysSetFocus(HVDM, ULONG, PVOID, ULONG, PVOID);
LONG    PRIVENTRY vvSysSetLock(HVDM, ULONG, PVOID, ULONG, PVOID);
LONG    PRIVENTRY vvSysQueryMode(HVDM, ULONG, PVOID, ULONG, PVVMODE);
LONG    PRIVENTRY vvSysQueryCursor(HVDM, ULONG, PVOID, ULONG, PVVCURSOR);
LONG    PRIVENTRY vvSysQueryPalette(HVDM, ULONG, PVOID, ULONG, PRGB);
LONG    PRIVENTRY vvSysCopyLVB(HVDM, ULONG, PRECTL, ULONG, PBYTE);
LONG    PRIVENTRY vvSysCopyBitmap(HVDM, ULONG, PVVRECT, ULONG, PBYTE);
LONG    PRIVENTRY vvSysWaitEvent(HVDM, ULONG, PVOID, ULONG, PVVEVENT);
LONG    PRIVENTRY vvSysControlEvent(HVDM, ULONG, PVOID, ULONG, PVOID);
LONG    PRIVENTRY vvSysSetDisplayReq(HVDM, ULONG, PVVDRQ, ULONG, PVOID);
LONG    PRIVENTRY vvSysRequestMemory(HVDM, ULONG, PVOID, ULONG, PULONG);
LONG    PRIVENTRY vvSysFreeMemory(HVDM, ULONG, PVOID, ULONG, PULONG);
LONG    PRIVENTRY vvSysRequestController(HVDM, ULONG, PVOID, ULONG, PVOID);
LONG    PRIVENTRY vvSysFreeController(HVDM, ULONG, PVOID, ULONG, PVOID);
LONG    PRIVENTRY vvSysQueryVRAMStatus(HVDM, ULONG, PVOID, ULONG, PVOID);
LONG    PRIVENTRY vvSysSetOEMFlag(HVDM, ULONG, PVOID, ULONG, PVOID);    /* @V2.0TPL10 */

 /*
 **  vvptr.c
 */

BOOL    EXPENTRY  VVShowPtr(HVDM, ULONG, ULONG);
BOOL    EXPENTRY  VVHidePtr(HVDM);
BOOL    EXPENTRY  VVDefineTextPtr(HVDM, ULONG, ULONG, BOOL);
BOOL    EXPENTRY  VVDefineGraphPtr(HVDM, PUSHORT, ULONG, ULONG);
BOOL    EXPENTRY  VVSetPtrPage(HVDM, ULONG);
BOOL    EXPENTRY  VVSetLPenEmulation(HVDM, BOOL);
VOID    HOOKENTRY VVUpdatePtrContext(PULONG, PCRF);


 /*
 **  vvptra.asm
 */

VOID    PRIVENTRY vvPtrReset(HVDM);
VOID    PRIVENTRY vvPtrSetMasks(HVDM, PUSHORT);
VOID    PRIVENTRY vvPtrDraw(HVDM, ULONG, ULONG);
VOID    PRIVENTRY vvPtrErase(HVDM);


 /*
 **  vvint10.asm
 */

VOID    HOOKENTRY VVInt10Hook(PCRF);
VOID    HOOKENTRY VVInt10Return(PVOID, PCRF);


 /*
 **  vvcopy.asm
 */

VOID    PRIVENTRY vvCopyLVBToLVB(HVDM, PRECTL, PVOID, ULONG);           /* @V2.0TPL07 */
VOID    PRIVENTRY vvCopyBlankToLVB(HVDM, PRECTL, PVOID, ULONG);         /* @V2.0TPL07 */
VOID    PRIVENTRY vvCopyGraphicsToBitmap(HVDM, PVVRECT, PVOID);
VOID    PRIVENTRY vvCopyGraphicsToBitmap256(HVDM, PVVRECT, PVOID);
VOID    PRIVENTRY vvCopyGraphicsToDDBitmap(HVDM, PVVRECT, PVOID);
VOID    PRIVENTRY vvConvertPalette(HVDM, ULONG, PVOID);
BOOL    PRIVENTRY vvFillShadowBuffer(HVDM, PRECTL);
BOOL    PRIVENTRY vvDiffShadowBuffer(HVDM, PRECTL);
#ifdef EGAVGA
BOOL    PRIVENTRY vvDiffPhysPage(HVDM, INT, PULONG, PULONG, BOOL);
#endif


 /*
 **  vvphysio.asm
 */

VOID    PRIVENTRY vvSetupShadowPtrs(PVVREG, ULONG, PRLE);
VOID    PRIVENTRY vvSetPhysIOState(VOID);
BYTE    PRIVENTRY vvAdjustShadowOutput(PRLE, BYTE);
VOID    PRIVENTRY vvShadowOutput(HVDM, PORT, PORT, LONG, ULONG, PBYTE, PBYTE, FLAGS);
HVDM    PRIVENTRY vvRequestController(HVDM, BOOL);
VOID    PRIVENTRY vvLockController(VOID);
VOID    PRIVENTRY vvUnlockController(VOID);
VOID    PRIVENTRY vvFreeController(HVDM);
VOID    PRIVENTRY vvDebugSaveInfo(BYTE, HVDM, BOOL);    /* 75466 */

 /*
 **  vvcga.c
 */

//c-begin
PORTFNCGAADJUSTEDPORT vvCGAAdjustedPort;                        /*@V2.1MNH14*/
ULFNCGASTARTADDR      vvCGAStartAddr;                           /*@V2.1MNH14*/
BFNCGAODDEVENMODE     vvCGAOddEvenMode;                         /*@V2.1MNH14*/
BFNCGAODDEVENMODE     vvCGAHighResMode;                         /*@V2.1MNH16*/
USFNCGAHORZDSPEND     vvCGAHorzDspEnd;                          /*@V2.1MNH14*/
USFNCGAHORZLOGEND     vvCGAHorzLogEnd;                          /*@V2.1MNH14*/
USFNCGAVERTDSPEND     vvCGAVertDspEnd;                          /*@V2.1MNH14*/
USFNCGABITSPERPIXEL   vvCGABitsPerPixel;                        /*@V2.1MNH14*/
USFNCGAPREPARESETMODE vvCGAPrepareSetMode;                      /*@V2.1MNH20*/
//c-end

 /*
 **  vvega.c
 */

#ifdef EGAVGA
//c-begin
PORTFNCGAADJUSTEDPORT vvEGAAdjustedPort;                        /*@V2.1MNH14*/
ULFNCGASTARTADDR      vvEGAStartAddr;                           /*@V2.1MNH14*/
BFNCGAODDEVENMODE     vvEGAOddEvenMode;                         /*@V2.1MNH14*/
BFNCGAHIGHRESMODE     vvEGAHighResMode;                         /*@V2.1MNH16*/
USFNCGAHORZDSPEND     vvEGAHorzDspEnd;                          /*@V2.1MNH14*/
USFNCGAHORZLOGEND     vvEGAHorzLogEnd;                          /*@V2.1MNH14*/
USFNCGAVERTDSPEND     vvEGAVertDspEnd;                          /*@V2.1MNH14*/
USFNCGABITSPERPIXEL   vvEGABitsPerPixel;                        /*@V2.1MNH14*/

BFNEGAPACKEDMODE      vvEGAPackedMode;                          /*@V2.1MNH14*/
USFNEGAVERTLINECMP    vvEGAVertLineCmp;                         /*@V2.1MNH14*/
//c-end
#endif /* EGAVGA */

 /*
 **  vvvga.c
 */

#ifdef VGA                                                      /*@V2.1MNH14*/

//c-begin
ULFNCGASTARTADDR       vvVGAStartAddr;                          /*@V2.1MNH14*/
USFNCGAHORZDSPEND      vvVGAHorzDspEnd;                         /*@V2.1MNH14*/
USFNCGAHORZLOGEND      vvVGAHorzLogEnd;                         /*@V2.1MNH14*/
USFNCGAVERTDSPEND      vvVGAVertDspEnd;                         /*@V2.1MNH14*/
USFNCGABITSPERPIXEL    vvVGABitsPerPixel;                       /*@V2.1MNH14*/
USFNCGAPREPARESETMODE  vvVGAPrepareSetMode;                     /*@V2.1MNH20*/

USFNEGAVERTLINECMP     vvVGAVertLineCmp;                        /*@V2.1MNH14*/

FNVGADACSAVE           vvVGADacSave;                            /*@V2.1MNH25*/
FNVGADACRESTORE        vvVGADacRestore;                         /*@V2.1MNH25*/

FNDACIPFCLEAR          vvVGADacStdIPFClear;                     /*@V2.1MNH25*/
FNDACIPFSET            vvVGADacStdIPFSet;                       /*@V2.1MNH25*/
FNDACSAVE              vvVGADacStdSave;                         /*@V2.1MNH25*/
FNDACRESTORE           vvVGADacStdRestore;                      /*@V2.1MNH25*/
//c-end

VOID    PRIVENTRY vvVGAATCSaveState( HVDM );                    /*@V2.1MNH14*/
VOID    PRIVENTRY vvVGAEnableBankAddr( HVDM );                  /*@V2.1MNH20*/
VOID    PRIVENTRY vvVGASetBank(HVDM, ULONG, BOOL);              /*@V2.1MNH14*/
ULONG   PRIVENTRY vvVGAGetBank(HVDM, BOOL);                     /*@V2.1MNH14*/
VOID    PRIVENTRY vvGetIOState( HVDM, PPRLE );                  /*@V2.1MNH18*/

#endif /* VGA */                                                /*@V2.1MNH14*/

#ifdef SVGA                                                     /*@V2.1MNH14*/

//c-begin
FNSVGAEDITTABLES       vvVGAEditTables;                         /*@V2.1MNH14*/
BFNSVGAINTERLACED      vvVGAInterlaced;                         /*@V2.1MNH14*/
FNSVGAUPDATEIOSTATE    vvVGAUpdateIoState;                      /*@V2.1MNH14*/
FNSVGARESTOREIOSTATE   vvVGARestoreIoState;                     /*@V2.1MNH14*/
FNSVGAFIXSETMODE       vvVGAFixSetMode;                         /*@V2.1MNH13*/
FNSVGAFIXSETBGND       vvVGAFixSetBgnd;                         /*@V2.1MNH13*/
FNSVGAWRITEGDCDATAFGND vvVGAWriteGDCDataFgnd;                   /*@V2.1MNH14*/
BFNSVGAREADSEQDATABGND vvVGAReadSEQDataBgnd;                    /*@V2.1MNH14*/
FNSVGAWRITESEQDATABGND vvVGAWriteSEQDataBgnd;                   /*@V2.1MNH14*/
FNSVGADACRS2CLEAR      vvVGADacRS2Clear;                        /*@V2.1MNH25*/
FNSVGADACRS2SET        vvVGADacRS2Set;                          /*@V2.1MNH25*/
FNSVGADACRS3           vvVGADacRS3;                             /*@V2.1MNH25*/
//c-end

#endif /* SVGA */                                               /*@V2.1MNH14*/

#ifdef SVGA

 /*
 **  vvpmi.c
 */

VOID    PRIVENTRY vvPMIProcessFile( CHAR * );                   /*@V2.1MNH14*/

 /*
 **  vvsvga.c
 */

//c-begin
VOID   PRIVENTRY vvSVGAMaxBanks( HVDM );                       /*@V2.1MNH20, @V2.2SEN01*/
VOID    PRIVENTRY vvInt10SetModePrepare( HVDM );                /*@V2.1MNH12*/
VOID    PRIVENTRY vvSVGAExecCommands( HVDM, PHWCMD, PULONG );   /*@V2.1MNH14*/
VOID    PRIVENTRY vvSVGACleanup( HVDM, BOOL );                  /*@V2.1MNH14*/
BOOL    PRIVENTRY vvSVGALockPushState( HVDM );                  /*@V2.1MNH14*/
VOID    PRIVENTRY vvSVGALockPopState( HVDM, BOOL );             /*@V2.1MNH14*/
VOID    PRIVENTRY vvSVGALockRegisters( HVDM, BOOL );  /*@V2.0SEN02*//*@V2.1MNH06*/
VOID    PRIVENTRY vvSVGAUnLockRegisters( HVDM, BOOL );/*@V2.0DRW01*//*@V2.1MNH06*/
VOID    PRIVENTRY vvSVGASetBank( HVDM, ULONG, BOOL );           /*@V2.1MNH17*/
ULONG   PRIVENTRY vvSVGAGetBank( HVDM, BOOL );                  /*@V2.1MNH17*/
VOID    PRIVENTRY vvSVGASetBgnd(HVDM hvdm);                     /*@V2.0SEN10*/
VOID    PRIVENTRY vvSVGAFixSetMode( HVDM );                     /*@V2.1MNH06*/
VOID    PRIVENTRY vvSVGAFixSetBgnd( HVDM );                     /*@V2.0DRW01*/
VOID    HOOKENTRY vvSVGARestoreModeReturn(PVOID, PCRF);         /*@V2.2SEN01*/
VOID    HOOKENTRY vvSVGAFgndRestoreModeContext(PVOID, PCRF);    /*@V2.2SEN01*/
VOID    PRIVENTRY vvSVGARestoreFgnd(HVDM, ULONG);               /*@V2.2SEN01*/

FNDACSAVE              vvSVGAHiColorDACSave;                    /*@V2.1MNH20*/
FNDACRESTORE           vvSVGAHiColorDACRestore;                 /*@V2.1MNH20*/
//c-end

 /*
 **  vvaccel.c                                                    @V2.1MNH03
 */

VOID    PRIVENTRY vvAcceleratorInstallWordHooks( PORT );
VOID    PRIVENTRY vvAcceleratorSetWordHookState( PORT, FLAGS );
VOID    PRIVENTRY vvAcceleratorRead( PSTRAPREGINFO, PSTRAPREGPARTINFO, PVOID );
VOID    PRIVENTRY vvAcceleratorWrite( PSTRAPREGINFO, PSTRAPREGPARTINFO, PVOID, BOOL );

VOID    PRIVENTRY vvAcceleratorLockIO( HVDM );
VOID    PRIVENTRY vvAcceleratorUnlockIO( HVDM );
BOOL    PRIVENTRY vvAcceleratorChip( VOID );                    /*@V2.2SEN01*/
VOID    PRIVENTRY vvAcceleratorInstallIOHooks( HVDM );
VOID    PRIVENTRY vvAcceleratorSetBgndOnlyHooks( FLAGS );
VOID    PRIVENTRY vvAcceleratorSetIOHooks( FLAGS );
VOID    PRIVENTRY vvAcceleratorUpdateScreenState( HVDM );
VOID    PRIVENTRY vvAcceleratorWaitOnEngine( HVDM, BOOL );      /*@V2.1MNH20*/
VOID    PRIVENTRY vvAcceleratorUpdateIOState( HVDM );
VOID    PRIVENTRY vvAcceleratorRestoreIOState( HVDM );
BOOL    PRIVENTRY vvAcceleratorCreate( HVDM );                  /*@V2.1MNH08*/
VOID    PRIVENTRY vvAcceleratorDestroy( HVDM );                 /*@V2.1MNH08*/
BOOL    PRIVENTRY vvAcceleratorUpdateMemoryMapState(HVDM, PVDM, PULONG);        /*@V2.2SEN01*/

 /*
 **  vva8514.c                                                    @V2.1MNH13
 */

BYTE    HOOKENTRY vvA8514ReadWRegByteL( PORT, PCRF );           /*@V2.1MNH08*/
BYTE    HOOKENTRY vvA8514ReadWRegByteH( PORT, PCRF );           /*@V2.1MNH08*/
WORD    HOOKENTRY vvA8514ReadWRegWord( PORT, PCRF );            /*@V2.1MNH08*/
VOID    HOOKENTRY vvA8514WriteWRegByteL( BYTE, PORT, PCRF );    /*@V2.1MNH08*/
VOID    HOOKENTRY vvA8514WriteWRegByteH( BYTE, PORT, PCRF );    /*@V2.1MNH08*/
VOID    HOOKENTRY vvA8514WriteWRegWord( WORD, PORT, PCRF );     /*@V2.1MNH08*/

BYTE    HOOKENTRY vvA8514ReadMFRegByteL( PORT, PCRF );          /*@V2.1MNH08*/
BYTE    HOOKENTRY vvA8514ReadMFRegByteH( PORT, PCRF );          /*@V2.1MNH08*/
WORD    HOOKENTRY vvA8514ReadMFRegWord( PORT, PCRF );           /*@V2.1MNH08*/
VOID    HOOKENTRY vvA8514WriteMFRegByteL( BYTE, PORT, PCRF );   /*@V2.1MNH08*/
VOID    HOOKENTRY vvA8514WriteMFRegByteH( BYTE, PORT, PCRF );   /*@V2.1MNH08*/
VOID    HOOKENTRY vvA8514WriteMFRegWord( WORD, PORT, PCRF );    /*@V2.1MNH08*/
BOOL    PRIVENTRY vvA8514Create( HVDM hvdm);                    /*@V2.2SEN01*/

//c-begin

#define A8514TRAPREGSIZE 0x40                                   /*@V2.1MNH14*/
UIFNACCELERATORPORTINDEX      vvA8514PortIndex;                 /*@V2.1MNH14*/
BFNACCELERATORCHIP            vvA8514Chip;                      /*@V2.1MNH14*/
BFNACCELERATORISON            vvA8514IsOn;                      /*@V2.1MNH13*/
BFNACCELERATORBUSY            vvA8514Busy;                      /*@V2.1MNH13*/
FNACCELERATORRESET            vvA8514Reset;                     /*@V2.1MNH13*/
FNACCELERATORINSTALLIOHOOKS   vvA8514InstallIoHooks;            /*@V2.1MNH13*/
FNACCELERATORSETIOHOOKS       vvA8514SetIoHooks;                /*@V2.1MNH13*/
FNACCELERATORSETBGNDONLYHOOKS vvA8514SetBgndOnlyHooks;          /*@V2.1MNH13*/
FNACCELERATORUPDATESCRNSTATE  vvA8514UpdateScrnState;           /*@V2.1MNH13*/
FNUPDATEMODEDATA              vvA8514UpdateModeData;            /*@V2.1MNH13, @V2.2SEN01 */
FNACCELERATORUPDATEIOSTATE    vvA8514UpdateIoState;             /*@V2.1MNH13*/
FNACCELERATORRESTOREIOSTATE   vvA8514RestoreIoState;            /*@V2.1MNH13*/
FNACCELERATORINIT             vvA8514Init;                      /*@V2.1MNH13*/
PWFNA8514READMFREGSHADOW      vvA8514ReadMFRegShadow;           /*@V2.1MNH13*/
//c-end
VOID    PRIVENTRY vvA8514WriteOnly( PORT );                     /*@V2.1MNH13*/
VOID    PRIVENTRY vvA8514ReadOnly( PORT );                      /*@V2.1MNH16*/

 /*
 **  vvati.c                                                      @V2.1MNH13
 */

 /*
 **  vvcirrus.c                                                   @V2.1MNH13
 */

 /*
 **  vvs3.c                                                       @V2.1MNH13
 */

 /*
 **  vvtridnt.c                                                   @V2.1MNH13
 */

 /*
 **  vvtseng.c                                                    @V2.1MNH13
 */

 /*
 **  vvwd.c                                                       @V2.1MNH13
 */

 /*
 **  vvsvgaio.asm
 */

/* JWK01 begin */

VOID    EXPENTRY  VVWriteTsengSegSelectFgnd( BYTE, PORT, PCRF );
VOID    EXPENTRY  VVWriteTsengSegSelectBgnd( BYTE, PORT, PCRF );
BYTE    EXPENTRY  VVReadTsengSegSelectFgnd( PORT, PCRF );
BYTE    EXPENTRY  VVReadTsengSegSelectBgnd( PORT, PCRF );

VOID    EXPENTRY  VVWriteTsengSegSelect2Fgnd( BYTE, PORT, PCRF );
VOID    EXPENTRY  VVWriteTsengSegSelect2Bgnd( BYTE, PORT, PCRF );
BYTE    EXPENTRY  VVReadTsengSegSelect2Fgnd( PORT, PCRF );
BYTE    EXPENTRY  VVReadTsengSegSelect2Bgnd( PORT, PCRF );

VOID    EXPENTRY  VVWriteTsengCRTCBDataFgnd( BYTE, PORT, PCRF );
VOID    EXPENTRY  VVWriteTsengCRTCBDataBgnd( BYTE, PORT, PCRF );
BYTE    EXPENTRY  VVReadTsengCRTCBDataFgnd( PORT, PCRF );
BYTE    EXPENTRY  VVReadTsengCRTCBDataBgnd( PORT, PCRF );

VOID    EXPENTRY  VVWriteTsengCRTCBIndexFgnd( BYTE, PORT, PCRF );
VOID    EXPENTRY  VVWriteTsengCRTCBIndexBgnd( BYTE, PORT, PCRF );
BYTE    EXPENTRY  VVReadTsengCRTCBIndexFgnd( PORT, PCRF );
BYTE    EXPENTRY  VVReadTsengCRTCBIndexBgnd( PORT, PCRF );


/* JWK01 end */


BOOL    EXPENTRY  VVGetTridentRegDef();
VOID    EXPENTRY  VVWriteIBMApertureCtrlFgnd( BYTE, PORT, PCRF );  /*@V2.0TPL13*/
VOID    EXPENTRY  VVWriteIBMApertureCtrlBgnd( BYTE, PORT, PCRF );  /*@V2.0TPL13*/
VOID    EXPENTRY  VVWriteIBMApertureIndxBgnd( BYTE, PORT, PCRF );  /*@V2.1MNH15*/
VOID    EXPENTRY  VVWriteIBMOperatingModeBgnd( BYTE, PORT, PCRF ); /*@V2.1MNH15*/
VOID    EXPENTRY  VVWriteIBMRegistersBgnd( BYTE, PORT, PCRF );
BYTE    EXPENTRY  VVReadIBMRegistersBgnd( PORT, PCRF );
BYTE    EXPENTRY  VVReadOrchidClockSelectFgnd( PORT, PCRF );       /*@V2.0DRW06*/
BYTE    EXPENTRY  VVReadOrchidClockSelectBgnd( PORT, PCRF );       /*@V2.0DRW06*/
VOID    EXPENTRY  VVWriteOrchidClockSelectFgnd( BYTE, PORT, PCRF );/*@V2.0DRW06*/
VOID    EXPENTRY  VVWriteOrchidClockSelectBgnd( BYTE, PORT, PCRF );/*@V2.0DRW06*/

VOID    PRIVENTRY SETDIAMONDCLK(HVDM, ULONG, ULONG);            /*@V2.1YEE03*/
VOID    PRIVENTRY Prog_Clock();                                 /*@V2.0WKB04*/
VOID    PRIVENTRY Send_Serial();                                /*@V2.0WKB04*/
VOID    PRIVENTRY GetCRTCAddr();                                /*@V2.0WKB04*/
VOID    PRIVENTRY GetDACTypeRtn();                              /*@V2.0WKB04*/
VOID    PRIVENTRY SetDACCMDReg();                               /*@V2.0WKB04*/
VOID    PRIVENTRY WaitVertRetrace();                            /*@V2.0WKB04*/

VOID    PRIVENTRY SETNUMBER9CLK(HVDM, ULONG);                   /*@V2.1YEE04*/
#endif /* SVGA */

 /*
 **   MASM function prototypes
 **
 **   None of these functions are callable; they are declared
 **   so that they can be referenced in various function tables.  The
 **   one current exception is in vvcrtio.asm:  vvUpdateCursorData.
 */

 /*  vvatcio.asm
 **
 */

#ifdef EGA
BYTE    EXPENTRY  VVReadATCFgnd( PORT, PCRF );
#endif
#ifdef EGAVGA
BYTE    EXPENTRY  VVReadATCBgnd( PORT, PCRF );
VOID    EXPENTRY  VVWriteATCFgnd( BYTE, PORT, PCRF );
VOID    EXPENTRY  VVWriteATCBgnd( BYTE, PORT, PCRF );
#endif
#ifdef EGA
WORD    EXPENTRY  VVReadATCFgndW( PORT, PCRF );
VOID    EXPENTRY  VVWriteATCFgndW( WORD, PORT, PCRF );
#endif
#ifdef EGA
BYTE    EXPENTRY  VVReadATC1Fgnd( PORT, PCRF );
#endif
#ifdef EGAVGA
BYTE    EXPENTRY  VVReadATC1Bgnd( PORT, PCRF );
#endif


 /*
 **  vvcrtio.asm
 */

#ifndef VGA
BYTE    EXPENTRY  VVReadCRTIndxFgnd( PORT, PCRF );
#endif
BYTE    EXPENTRY  VVReadCRTIndxBgnd( PORT, PCRF );
#ifndef VGA
VOID    EXPENTRY  VVWriteCRTIndxFgnd( BYTE, PORT, PCRF );
#endif
VOID    EXPENTRY  VVWriteCRTIndxBgnd( BYTE, PORT, PCRF );
#ifndef VGA
WORD    EXPENTRY  VVReadCRTIndxFgndW( PORT, PCRF );
#endif
VOID    EXPENTRY  VVWriteCRTIndxFgndW( WORD, PORT, PCRF );
VOID    EXPENTRY  VVWriteCRTIndxBgndW( WORD, PORT, PCRF );
#ifndef VGA
BYTE    EXPENTRY  VVReadCRTDataFgnd( PORT, PCRF );
#endif
BYTE    EXPENTRY  VVReadCRTDataBgnd( PORT, PCRF );
#ifndef VGA
VOID    EXPENTRY  VVWriteCRTDataFgnd( BYTE, PORT, PCRF );
#endif
VOID    EXPENTRY  VVWriteCRTDataBgnd( BYTE, PORT, PCRF );
VOID    PRIVENTRY vvUpdateCursorData(HVDM);

 /*
 **  vvdacio.asm
 */

#ifdef VGA
VOID    EXPENTRY  VVWriteDACReadFgnd( BYTE, PORT, PCRF );
VOID    EXPENTRY  VVWriteDACWriteFgnd( BYTE, PORT, PCRF );
BYTE    EXPENTRY  VVReadDACDataFgnd( PORT, PCRF );
VOID    EXPENTRY  VVWriteDACDataFgnd( BYTE, PORT, PCRF );
BYTE    EXPENTRY  VVReadDACMaskBgnd( PORT, PCRF );
VOID    EXPENTRY  VVWriteDACMaskBgnd( BYTE, PORT, PCRF );
BYTE    EXPENTRY  VVReadDACStateBgnd( PORT, PCRF );
VOID    EXPENTRY  VVWriteDACReadBgnd( BYTE, PORT, PCRF );
BYTE    EXPENTRY  VVReadDACIndxBgnd( PORT, PCRF );
VOID    EXPENTRY  VVWriteDACWriteBgnd( BYTE, PORT, PCRF );
BYTE    EXPENTRY  VVReadDACDataBgnd( PORT, PCRF );
VOID    EXPENTRY  VVWriteDACDataBgnd( BYTE, PORT, PCRF );
#endif


 /*
 **  vvgdcio.asm
 */

#ifdef EGA
VOID    EXPENTRY  VVWriteGDC2Fgnd( BYTE, PORT, PCRF );
VOID    EXPENTRY  VVWriteGDC2Bgnd( BYTE, PORT, PCRF );
VOID    EXPENTRY  VVWriteGDC1Fgnd( BYTE, PORT, PCRF );
VOID    EXPENTRY  VVWriteGDC1Bgnd( BYTE, PORT, PCRF );
#endif
#ifdef EGA
BYTE    EXPENTRY  VVReadGDCIndxFgnd( PORT, PCRF );
#endif
#ifdef EGAVGA
BYTE    EXPENTRY  VVReadGDCIndxBgnd( PORT, PCRF );
#endif
#ifdef EGAVGA
VOID    EXPENTRY  VVWriteGDCIndxFgnd( BYTE, PORT, PCRF );
VOID    EXPENTRY  VVWriteGDCIndxBgnd( BYTE, PORT, PCRF );
#endif
#ifdef EGA
WORD    EXPENTRY  VVReadGDCIndxFgndW( PORT, PCRF );
VOID    EXPENTRY  VVWriteGDCIndxFgndW( WORD, PORT, PCRF );
#endif
#ifdef EGA
BYTE    EXPENTRY  VVReadGDCDataFgnd( PORT, PCRF );
#endif
#ifdef EGAVGA
BYTE    EXPENTRY  VVReadGDCDataBgnd( PORT, PCRF );
#endif
#ifdef EGAVGA
VOID    EXPENTRY  VVWriteGDCDataFgnd( BYTE, PORT, PCRF );
VOID    EXPENTRY  VVWriteGDCDataBgnd( BYTE, PORT, PCRF );
#endif


 /*
 **  vvmscio.asm
 */

BYTE    EXPENTRY  VVReadModeFgnd( PORT, PCRF );
BYTE    EXPENTRY  VVReadModeBgnd( PORT, PCRF );
VOID    EXPENTRY  VVWriteModeFgnd( BYTE, PORT, PCRF );
VOID    EXPENTRY  VVWriteModeBgnd( BYTE, PORT, PCRF );

#ifndef CGA                                                     /*@V2.1MNH15*/
VOID    EXPENTRY  VVWriteHercCompatibilityFgnd( BYTE, PORT, PCRF );
VOID    EXPENTRY  VVWriteHercCompatibilityBgnd( BYTE, PORT, PCRF );
#endif /* !CGA */                                               /*@V2.1MNH15*/

#ifndef MONO
BYTE    EXPENTRY  VVReadCGAColorFgnd( PORT, PCRF );
BYTE    EXPENTRY  VVReadCGAColorBgnd( PORT, PCRF );
VOID    EXPENTRY  VVWriteCGAColorFgnd( BYTE, PORT, PCRF );
VOID    EXPENTRY  VVWriteCGAColorBgnd( BYTE, PORT, PCRF );
#endif
#ifdef EGAVGA
BYTE    EXPENTRY  VVReadStatus0Bgnd( PORT, PCRF );
#endif
#ifdef EGAVGA                                                   /*@V2.0TPL02*/
VOID    EXPENTRY  VVWriteMiscOutFgnd( BYTE, PORT, PCRF );
#endif
#ifdef EGAVGA
VOID    EXPENTRY  VVWriteMiscOutBgnd( BYTE, PORT, PCRF );
#endif
#ifdef EGA
BYTE    EXPENTRY  VVReadFeatureFgnd( PORT, PCRF );
#endif
#ifdef EGAVGA
BYTE    EXPENTRY  VVReadFeatureBgnd( PORT, PCRF );
#endif
#ifdef EGA
BYTE    EXPENTRY  VVReadMiscOutFgnd( PORT, PCRF );
#endif
#ifdef EGAVGA
BYTE    EXPENTRY  VVReadMiscOutBgnd( PORT, PCRF );
#endif
#ifdef EGAVGA
BYTE    EXPENTRY  VVReadStatus1Fgnd( PORT, PCRF );
#endif
BYTE    EXPENTRY  VVReadStatus1Bgnd( PORT, PCRF );
#ifdef EGA
VOID    EXPENTRY  VVWriteFeatureFgnd( BYTE, PORT, PCRF );
#endif
#ifdef EGAVGA
VOID    EXPENTRY  VVWriteFeatureBgnd( BYTE, PORT, PCRF );
#endif
#ifndef MONO
BYTE    EXPENTRY  VVReadUnknownBgnd( PORT, PCRF );
#endif
VOID    EXPENTRY  VVWriteUnknownBgnd( BYTE, PORT, PCRF );
VOID    EXPENTRY  VVWriteUnknownBgnd( BYTE, PORT, PCRF );
#ifdef VGA                                                      /*@V2.1MNH14*/
BYTE    EXPENTRY  VVReadVVReservedFgnd( PORT, PCRF );           /*@V2.0XXX03*/
VOID    EXPENTRY  VVWriteVVReservedFgnd( BYTE, PORT, PCRF );    /*@V2.0XXX03*/
BYTE    EXPENTRY  VVReadVVReservedBgnd( PORT, PCRF );           /*@V2.0XXX03*/
VOID    EXPENTRY  VVWriteVVReservedBgnd( BYTE, PORT, PCRF );    /*@V2.0XXX03*/

VOID    EXPENTRY  VVWriteVSEFgnd( BYTE, PORT, PCRF );           /*@V2.1MNH20*/
VOID    EXPENTRY  VVWriteVSEBgnd( BYTE, PORT, PCRF );           /*@V2.1MNH20*/
BYTE    EXPENTRY  VVReadVSEBgnd( PORT, PCRF );                  /*@V2.1MNH20*/
VOID    EXPENTRY  VVWriteVSEAlternateFgnd( BYTE, PORT, PCRF );  /*@V2.1MNH20*/
VOID    EXPENTRY  VVWriteVSEAlternateBgnd( BYTE, PORT, PCRF );  /*@V2.1MNH20*/
BYTE    EXPENTRY  VVReadVSEAlternateBgnd( PORT, PCRF );         /*@V2.1MNH20*/
#endif                                                          /*@V2.1MNH14*/


 /*
 **  vvseqio.asm
 */

#ifdef EGA
BYTE    EXPENTRY  VVReadSEQIndxFgnd( PORT, PCRF );
#endif
#ifdef EGAVGA
BYTE    EXPENTRY  VVReadSEQIndxBgnd( PORT, PCRF );
#endif
#ifdef EGAVGA
VOID    EXPENTRY  VVWriteSEQIndxFgnd( BYTE, PORT, PCRF );
VOID    EXPENTRY  VVWriteSEQIndxBgnd( BYTE, PORT, PCRF );
#endif
#ifdef EGA
WORD    EXPENTRY  VVReadSEQIndxFgndW( PORT, PCRF );
VOID    EXPENTRY  VVWriteSEQIndxFgndW( WORD, PORT, PCRF );
#endif
#ifdef EGA
BYTE    EXPENTRY  VVReadSEQDataFgnd( PORT, PCRF );
#endif
#ifdef EGAVGA
BYTE    EXPENTRY  VVReadSEQDataBgnd( PORT, PCRF );
#endif
#ifdef EGAVGA
VOID    EXPENTRY  VVWriteSEQDataFgnd( BYTE, PORT, PCRF );
VOID    EXPENTRY  VVWriteSEQDataBgnd( BYTE, PORT, PCRF );
#endif


 /*
 **  vvoem.asm
 */

#ifdef COMPAQ
#ifdef EGA
BYTE    EXPENTRY  VVReadCompaqCtrlBgnd( PORT, PCRF );
VOID    EXPENTRY  VVWriteCompaqCtrlBgnd( BYTE, PORT, PCRF );
#endif
#endif

#ifdef ATI
#ifdef EGAVGA
BYTE    EXPENTRY  VVReadATIIndxBgnd( PORT, PCRF );
VOID    EXPENTRY  VVWriteATIIndxBgnd( BYTE, PORT, PCRF );
BYTE    EXPENTRY  VVReadATIDataBgnd( PORT, PCRF );
VOID    EXPENTRY  VVWriteATIDataBgnd( BYTE, PORT, PCRF );
#endif
#endif


//masm-begin

//word_s struc
//  lo  db  ?
//  hi  db  ?
//word_s ends
//
//dword_s struc
//  off dw  ?
//  sel dw  ?
//dword_s ends

//masm-end


 /*
 ** Random macro support
 **
 **   If VDDSTRICT is defined, the Assert macros generate appropriate code.
 **
 **   If VDDSTRICT is not defined, the Assert macros are NO-OPs (with the
 **   exception of AssertRC, in which case the function is still called, but
 **   the return code is not checked).
 **
 **   If VDDDEBUG is defined, debug printfs (PRINTDEBUGs) are generated, and
 **   failed assertions (assuming VDDSTRICT is defined) break at the assertion
 **   rather than in the kernel's "panic" service.  VDDDEBUG requires the
 **   kernel debugger, in other words.
 **
 **   If VDDDEBUG is not defined, debug printfs (PRINTDEBUGs) are NOT
 **   generated, and failed assertions (assuming VDDSTRICT is defined) simply
 **   panic.
 */

#ifdef VDDSTRICT


//c-begin

extern CHAR szAssertMsg[];
#define MODNAME static CHAR szFile[]

#ifdef VDDDEBUG
#define Assert(t) { \
                    if (!(t)) { \
                      PRINTDEBUG(szAssertMsg, szFile, __LINE__); \
                      INT3(); \
                    } \
                  }
#else
#define Assert(t) { \
                    if (!(t)) { \
                      PANIC(szAssertMsg, szFile, __LINE__); \
                    } \
                  }
#endif

#define AssertTRUE(t)   Assert(t)
#define AssertFALSE(t)  Assert(!(t))
#define AssertZERO(t)   Assert(!(t))
#define AssertNONZERO(t)Assert(t)
#define AssertERROR()   Assert(FALSE)
#define AssertRC(t)     Assert(t)       /* verify function return code good */

//c-end


//masm-begin

//?ASSERT macro   cond,msg,args
//        local   l1
//        ifnb    <cond>
//        j&cond  short l1
//        endif
//        ifdef   VDDDEBUG
//        DBPRINT <msg>,<args>
//        int 3
//        else
//        PANIC   <msg>,<args>
//        endif
//        ifnb    <cond>
//l1:
//        endif
//        endm

//masm-end


#else


//c-begin

#define Assert(t)
#define AssertTRUE(t)
#define AssertFALSE(t)
#define AssertZERO(t)
#define AssertNONZERO(t)
#define AssertERROR()
#define AssertRC(t)     (t)             /* perform function, but don't verify */

//c-end


//masm-begin

//?ASSERT macro cond,msg,args
//        endm

//masm-end


#endif


//masm-begin

//ASSERT   equ   <?ASSERT ,>
//ASSERTC  equ   <?ASSERT c,>
//ASSERTNC equ   <?ASSERT nc,>
//ASSERTZ  equ   <?ASSERT z,>
//ASSERTNZ equ   <?ASSERT nz,>
//ASSERTE  equ   <?ASSERT e,>
//ASSERTNE equ   <?ASSERT ne,>
//ASSERTB  equ   <?ASSERT b,>
//ASSERTBE equ   <?ASSERT be,>
//ASSERTA  equ   <?ASSERT a,>
//ASSERTAE equ   <?ASSERT ae,>

//masm-end


 /*
 ** Random debugging support
 */


#ifdef VDDDEBUG


//c-begin

extern CHAR szModule[];
extern CHAR *apszPageStates[];

#undef  PRINTDEBUG
#define PRINTDEBUG  printf(szModule); printf

/* Maybe someday... */
/* #undef  INB */
/* #define INB(p)      vvINB(p) */
/* #undef  OUTB */
/* #define OUTB(p,b)   vvOUTB(p,b,NULL) */
/* #undef  OUTW */
/* #define OUTW(p,w)   vvOUTW(p,w,NULL,NULL) */

//c-end


//masm-begin

//DefData IMPORT,INSTANCE,C
//SZ szModule
//EndData
//
//DBPRINT macro msg,args
//        PRINTDEBUG <szModule>,<00>
//        PRINTDEBUG <msg>,<args>
//        endm

//masm-end


#else


//masm-begin

//DBPRINT macro msg,args
//        endm

//masm-end


#endif


 /*
 ** LOOP alternative to enhance performance                               @V2.0TPL08
 */


//masm-begin

//hploop  macro   target
//        dec     ecx
//        jnz     target
//        endm

//masm-end

