/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = VVDATA.C
 *
 * DESCRIPTIVE NAME = Virtual Video Private Data
 *
 *
 * VERSION = V2.0
 *
 * DATE      11/10/88
 *
 * DESCRIPTION  This module contains the VVD's private data.
 *
 *
 * FUNCTIONS    None
 *
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/


#include <mvdm.h>
#include <vvd.h>
#include "vvdp.h"

#pragma BEGIN_SWAP_INSTANCE

PERVDMDATA VDMData;

#pragma END_SWAP_INSTANCE



#pragma BEGIN_SWAP_DATA

#ifndef CGA                                                     /*          */
extern PLE pleHercCompatibility;                                /*          */
#endif /* !CGA */                                               /*          */

extern PLE pleCRTIndx;                                          /*          */
extern PLE pleCRTData;                                          /*          */
extern PLE pleCRTMode;                                          /*          */
extern PLE pleFeatureWrite;                                     /*          */

#ifndef MONO                                                    /*          */
extern PLE pleCGAColor;                                         /*          */
#endif /* !MONO */                                              /*          */

#ifdef EGA

#ifdef COMPAQ
extern PLE pleCompaqCtrl;                                       /*          */
extern PLE pleCompaqEnv;                                        /*          */
extern PLE pleCompaqDsp;                                        /*          */
extern PLE pleCompaqMode;                                       /*          */
#endif /* COMPAQ */

#ifdef ATI
extern PLE pleATIEGAIndx;                                       /*          */
extern PLE pleATIEGAData;                                       /*          */
#endif /* ATI */

#endif /* EGA */

#ifdef EGAVGA
extern PLE pleATC1;                     /* 0x03c1 */            /*          */
extern PLE pleATCx;                                             /*          */
extern PLE pleMiscOutWrite;                                     /*          */
extern PLE pleSEQIndx;                                          /*          */
extern PLE pleSEQData;                                          /*          */
extern PLE pleGDCIndx;                                          /*          */
extern PLE pleGDCData;                                          /*          */
extern PLE pleGDCPos2;                                          /*          */
extern PLE pleGDCPos1;                                          /*          */
#endif /* EGAVGA */

#ifdef VGA
extern PLE pleVVReserved;               /* 0x03d6 */            /*          */
extern PLE pleVSE;                      /* 0x03c3 */            /*          */
extern PLE pleVGADACWrite;                                      /*          */
extern PLE pleVGADACRead;                                       /*          */
extern PLE pleVGADACMask;                                       /*          */
extern PLE pleVGADACData;                                       /*          */
extern PLE pleVGADACAuto;                                       /*          */
extern PLE pleIBMP70Indx;                                       /*          */
extern PLE pleIBMP70Data;                                       /*          */
#ifdef SVGA
extern PLE pleVSEAlternate;             /* 0x46e8 */            /*          */
#endif
#endif /* VGA */

#ifdef SVGA                                                     /*          */
extern PLE pleATIVGAIndx;               /* 0x01ce */            /*          */
extern PLE pleATIVGAData;               /* 0x01cf */            /*          */
extern PLE pleATIDacWrite;              /* 0x02ea */            /*          */
extern PLE pleATIDacRead;               /* 0x02eb */            /*          */
extern PLE pleATIDacMask;               /* 0x02ec */            /*          */
extern PLE pleATIDacData;               /* 0x02ed */            /*          */
extern PLE pleOrchidClkSelect;                                  /*          */
extern PLE pleTsengSegSelect2;          /* 0x03cb */            /*          */
extern PLE pleTsengSegSelect;           /* 0x03cd */            /*          */
extern PLE pleTsengCRTCBData;                                   /* JWK01 */
extern PLE pleTsengCRTCBIndex;                                  /* JWK01 */
extern PLE apleXGA [AXGA_TOTAL];        /* 0x21?x */            /*          */
#endif /* SVGA */                                               /*          */

 /*
 ** Global port trapping lists, per adapter per screen-state
 **
 **  appleAll contains a list of all byte wide port PLEs
 **  each PLE has a pointer to a pair of IOHs,
 **  one IOH for foreground and one for background
 **
 **  Note that if a port # is not in the appleAll list, then
 **  nothing is installed AND I/O trapping is disabled for the port.  This
 **  is done for ports that the VDM can have complete unrestricted access to.
 **  When handlers ARE listed, they must be in the same order as given in
 **  the IOH structure (see V8086.H).  NULL can appear in
 **  place of a handler address, in which case no handler is specified for
 **  that particular I/O action entry (NULL is what V8086 expects for default
 **  action hook).
 **
 **  I/O trapping will also be disabled for ports that have the PORTF_NOTRAP
 **  bit set within the PLE, but any handlers will still be installed.
 **  This is for ports that normally have no need of trapping until certain
 **  circumstances arise, at which time we do an explicit VDHSetIOHookState().
 **
 **  Two potential video problems related to virtualizing the interrupt flag:
 **
 **  On a CGA, we might preempt an application in the middle of a video
 **  update, thereby causing snow (this risk exists in real-mode today,
 **  it's just that the odds are somewhat greater in our case).  Also, if
 **  we preempted a foreground application for a long time while it had the
 **  sequencer reset, VRAM could become garbled, since it is not being
 **  refreshed.  This is a potentially much more serious problem for which
 **  there is no work-around.  Again, since we shouldn't be virtualizing
 **  the interrupt flag all that often, this situation should be rare enough.
 */

 /*
 **  Port and Register lists
 **
 **  The format of each port list (eg, appleAll) is:
 **
 **      Port #, total regs, offsets of virtual index & data, flags, ...
 **      Port #, total regs, offsets of virtual index & data, flags, ...
 **      ...
 **      0
 **  The format of each register list (eg, aprleMemory) is:
 **
 **      Port #, starting index, total regs, offsets, copy states, flags, ...
 **      Port #, starting index, total regs, offsets, copy states, flags, ...
 **      ...
 **      0
 **
 **  appleAll lists all I/O ports that contain indexed or non-indexed
 **  registers that can be automatically transferred during foreground screen
 **  switches.  Note that there are a variety of registers that require
 **  special treatment when writing, and most of these special cases can be
 **  handled with the flag words (flResetSeq, flWaitVert and flWaitHorz).  Any
 **  other special cases are handled directly in vvRestoreIOState().
 **
 **  appleUpdate lists all sets of registers that are untrapped for foreground
 **  VDMs (this is for VGAs -- and some other non-IBM adapters -- only).
 **  These must be updated by vvUpdateIOState when switching away from a VDM.
 **
 */

CONST PPLE appleAll[] =                                         /*          */
{                                                               /*          */
#ifdef SVGA                                                     /*          */
  &pleATIVGAIndx,                       /* 0x01ce */            /*          */
  &pleATIVGAData,                       /* 0x01cf */            /*          */
  &pleATIDacMask,                       /* 0x02ea */            /*          */
  &pleATIDacRead,                       /* 0x02eb */            /*          */
  &pleATIDacWrite,                      /* 0x02ec */            /*          */
  &pleATIDacData,                       /* 0x02ed */            /*          */
#endif /* SVGA */                                               /*          */
  &pleCRTIndx,                          /* 03b4/03d4 */         /*          */
  &pleCRTData,                          /* 03b5/03d5 */         /*          */
#ifdef VGA                                                      /*          */
  &pleVVReserved,                       /* 03d6 */              /*          */
#endif /* VGA */                                                /*          */
  &pleCRTMode,                          /* 03b8/03d8 */         /*          */
#ifdef CGA                                                      /*          */
  &pleCGAColor,                         /* 03b9/03d9 */         /*          */
#endif /* CGA */                                                /*          */
#ifdef SVGA                                                     /*          */
  &pleCGAColor,                         /* 03b9/03d9 */         /*          */
#endif /* SVGA */                                               /*          */
#ifdef EGAVGA                                                   /*          */
  &pleFeatureWrite,                     /* 03ba/03da */         /*          */
#endif /* EGAVGA */                                             /*          */
#ifndef CGA                                                     /*          */
  &pleHercCompatibility,                /* 03bf */              /*          */
#endif /* !CGA */                                               /*          */
#ifdef EGAVGA                                                   /*          */
  &pleATCx,                             /* 0x03c0 */            /*          */
//           #ifdef SVGA                                                     /*          */
  &pleATC1,                             /* 0x03c1 */            /*          */
//                 /* SVGA */                                               /*          */
  &pleMiscOutWrite,                     /* 0x03c2 */            /*          */
#ifdef VGA                                                      /*          */
  &pleVSE,                              /* 0x03c3 */            /*          */
#endif /* VGA */                                                /*          */
  &pleSEQIndx,                          /* 0x03c4 */            /*          */
  &pleSEQData,                          /* 0x03c5 */            /*          */
#ifdef EGA                                                      /*          */
#ifdef COMPAQ
  &pleCompaqCtrl,                       /* 0x03c6 */            /*          */
  &pleCompaqEnv,                        /* 0x07c6 */            /*          */
  &pleCompaqDsp,                        /* 0x0bc6 */            /*          */
  &pleCompaqMode,                       /* 0x0fc6 */            /*          */
#endif /* COMPAQ */
#endif /* EGA */                                                /*          */
#ifdef VGA                                                      /*          */
  &pleVGADACMask,                       /* 0x03c6 */            /*          */
  &pleVGADACRead,                       /* 0x03c7 */            /*          */
  &pleVGADACWrite,                      /* 0x03c8 */            /*          */
  &pleVGADACData,                       /* 0x03c9 */            /*          */
  &pleIBMP70Indx,                       /* 0x0d01 */            /*          */
  &pleIBMP70Data,                       /* 0x0d01 */            /*          */
#endif /* VGA */                                                /*          */
  &pleGDCPos2,                          /* 0x03ca */            /*          */
#ifdef EGA                                                      /*          */
#ifdef ATI                                                      /*          */
  &pleATIEGAIndx,                       /* 0x03cb */            /*          */
#endif /* ATI */                                                /*          */
#endif /* EGA */                                                /*          */
#ifdef SVGA                                                     /*          */
  &pleTsengSegSelect2,                  /* 0x03cb */            /*          */
#endif /* SVGA */                                               /*          */
  &pleGDCPos1,                          /* 0x03cc */            /*          */
#ifdef EGA                                                      /*          */
#ifdef ATI                                                      /*          */
  &pleATIEGAData,                       /* 0x03cd */            /*          */
#endif /* ATI */                                                /*          */
#endif /* EGA */                                                /*          */
#ifdef SVGA                                                     /*          */
  &pleTsengSegSelect,                   /* 0x03cd */            /*          */
#endif /* SVGA */                                               /*          */
  &pleGDCIndx,                          /* 0x03ce */            /*          */
  &pleGDCData,                          /* 0x03cf */            /*          */
#endif /* EGAVGA */                                             /*          */
#ifdef SVGA                                                     /*          */
  &pleOrchidClkSelect,                  /* 0x03dd */            /*          */
  &apleXGA [0x00],                      /* 21x0 */              /*          */
  &apleXGA [0x01],                      /* 21x1 */              /*          */
  &apleXGA [0x02],                      /* 21x2 */              /*          */
  &apleXGA [0x03],                      /* 21x3 */              /*          */
  &apleXGA [0x04],                      /* 21x4 */              /*          */
  &apleXGA [0x05],                      /* 21x5 */              /*          */
  &apleXGA [0x06],                      /* 21x6 */              /*          */
  &apleXGA [0x07],                      /* 21x7 */              /*          */
  &apleXGA [0x08],                      /* 21x8 */              /*          */
  &apleXGA [0x09],                      /* 21x9 */              /*          */
  &apleXGA [0x0a],                      /* 21xa */              /*          */
  &apleXGA [0x0b],                      /* 21xb */              /*          */
  &apleXGA [0x0c],                      /* 21xc */              /*          */
  &apleXGA [0x0d],                      /* 21xd */              /*          */
  &apleXGA [0x0e],                      /* 21xe */              /*          */
  &apleXGA [0x0f],                      /* 21xf */              /*          */
  &pleTsengCRTCBIndex,                  /* 0x217a */            /*          */
  &pleTsengCRTCBData,                   /* 0x217b */            /*          */
#endif /* SVGA */                                               /*          */
#ifdef SVGA                                                      /*          */
  &pleVSEAlternate,                     /* 0x46e8 */            /*          */
#endif /* VGA */                                                /*          */
  NULL                                                          /*          */
};                                                              /*          */

#ifdef EGAVGA

CONST PPLE appleUpdate [] =                                     /*          */
{                                                               /*          */
#ifdef EGA                                                      /*          */
#ifdef COMPAQ
  &pleCompaqCtrl,                                               /*          */
#endif
#endif /* EGA */                                                /*          */
#ifdef SVGA                                                     /*          */
  &pleATIVGAIndx,                       /* 0x01ce */            /*          */
  &pleATIVGAData,                       /* 0x01cf */            /*          */
#endif /* SVGA */                                               /*          */
#ifdef VGA                                                      /*          */
  &pleCRTIndx,                          /* 0x03b4/0x03d4 */     /*          */
  &pleCRTData,                          /* 0x03b5/0x03d5 */     /*          */
/* Although some VGAs can read this port, some cannot. */       /*          */
/* So this port is best treated as write only internally. */    /*          */
//&pleVSE,                              /* 0x03c3 */            /*          */
  &pleSEQIndx,                          /* 0x03c4 */            /*          */
  &pleSEQData,                          /* 0x03c5 */            /*          */
  &pleVGADACMask,                       /* 0x03c6 */            /*          */
  &pleGDCPos2,                          /* 0x03ca */            /*          */
#ifdef SVGA                                                     /*          */
  &pleTsengSegSelect2,                  /* 0x03cb */            /*          */
#endif /* VGA */                                                /*          */
  &pleGDCPos1,                          /* 0x03cc */            /*          */
#ifdef SVGA                                                     /*          */
  &pleTsengSegSelect,                   /* 0x03cd */            /*          */
#endif /* SVGA */                                               /*          */
  &pleGDCIndx,                          /* 0x03ce */            /*          */
  &pleGDCData,                          /* 0x03cf */            /*          */
#ifdef SVGA                                                     /*          */
  &apleXGA [0x00],                      /* 21x0 *//*          *//*          */
  &apleXGA [0x01],                      /* 21x1 *//*          *//*          */
  &apleXGA [0x02],                      /* 21x2 */              /*          */
  &apleXGA [0x03],                      /* 21x3 */              /*          */
  &apleXGA [0x04],                      /* 21x4 */              /*          */
  &apleXGA [0x05],                      /* 21x5 */              /*          */
  &apleXGA [0x06],                      /* 21x6 */              /*          */
  &apleXGA [0x07],                      /* 21x7 */              /*          */
  &apleXGA [0x08],                      /* 21x8 *//*          *//*          */
  &apleXGA [0x09],                      /* 21x9 */              /*          */
  &apleXGA [0x0a],                      /* 21xa */              /*          */
  &apleXGA [0x0b],                      /* 21xb */              /*          */
  &apleXGA [0x0c],                      /* 21xc */              /*          */
  &apleXGA [0x0d],                      /* 21xd */              /*          */
  &apleXGA [0x0e],                      /* 21xe */              /*          */
  &apleXGA [0x0f],                      /* 21xf */              /*          */
  &pleTsengCRTCBIndex,                  /* 0x217a */            /*          */
  &pleTsengCRTCBData,                   /* 0x217b */            /*          */
#endif /* SVGA */                                               /*          */
/* Although some VGAs can read this port, some cannot. */       /*          */
/* So this port is best treated as write only internally. */    /*          */
//&pleVSEAlternate,                     /* 0x46e8 */            /*          */
#endif /* VGA */                                                /*          */
  NULL                                                          /*          */
};                                                              /*          */

#endif /* EGAVGA */                                             /*          */

CONST PPLE appleRestore [] =                                    /*          */
{                                                               /*          */
#ifdef SVGA                                                     /*          */
  &apleXGA [0x00],                      /* 21x0 */              /*          */
  &apleXGA [0x01],                      /* 21x1 */              /*          */
  &apleXGA [0x02],                      /* 21x2 */              /*          */
  &apleXGA [0x03],                      /* 21x3 */              /*          */
  &apleXGA [0x04],                      /* 21x4 */              /*          */
  &apleXGA [0x05],                      /* 21x5 */              /*          */
  &apleXGA [0x06],                      /* 21x6 */              /*          */
  &apleXGA [0x07],                      /* 21x7 */              /*          */
  &apleXGA [0x08],                      /* 21x8 */              /*          */
  &apleXGA [0x09],                      /* 21x9 */              /*          */
  &apleXGA [0x0a],                      /* 21xa */              /*          */
  &apleXGA [0x0b],                      /* 21xb */              /*          */
  &apleXGA [0x0c],                      /* 21xc */              /*          */
  &apleXGA [0x0d],                      /* 21xd */              /*          */
  &apleXGA [0x0e],                      /* 21xe */              /*          */
  &apleXGA [0x0f],                      /* 21xf */              /*          */
#endif /* SVGA */                                               /*          */
#ifdef EGAVGA                                                   /*          */
  &pleATCx,                                                     /*          */
  &pleMiscOutWrite,                                             /*          */
  &pleSEQIndx,                                                  /*          */
  &pleSEQData,                                                  /*          */
#endif /* EGAVGA */                                             /*          */
#ifdef EGA                                                      /*          */
#ifdef COMPAQ
  &pleCompaqCtrl,                                               /*          */
#endif /* COMPAQ */
  &pleGDCPos2,                                                  /*          */
  &pleGDCPos1,                                                  /*          */
#endif /* EGA */                                                /*          */
#ifdef VGA                                                      /*          */
/* Although some VGAs can read this port, some cannot. */       /*          */
/* So this port is best treated as write only internally. */    /*          */
  &pleVSE,                              /* 0x03c3 */            /*          */
  &pleVGADACMask,                                               /*          */
  &pleVGADACAuto,                                               /*          */
  &pleVGADACWrite,                                              /*          */
/* Although some VGAs can read this port, some cannot. */       /*          */
/* So this port is best treated as write only internally. */    /*          */
#ifdef SVGA                                                     /*            */
  &pleVSEAlternate,                     /* 0x46e8 */            /*          */
#endif
#endif /* VGA */                                                /*          */
#ifdef EGAVGA                                                   /*          */
  &pleGDCIndx,                                                  /*          */
  &pleGDCData,                                                  /*          */
#endif /* EGAVGA */                                             /*          */
#ifndef CGA                                                     /*          */
  &pleHercCompatibility,                /* 0x03bf */            /*          */
#endif /* !CGA */                                               /*          */
  &pleCRTIndx,                                                  /*          */
  &pleCRTData,                                                  /*          */
  &pleCRTMode,                                                  /*          */
#ifndef MONO                                                    /*          */
  &pleCGAColor,                                                 /*          */
#endif /* !MONO */                                              /*          */
#ifdef SVGA                                                     /*          */
  &pleCGAColor,                                                 /*          */
#endif /* SVGA */                                               /*          */
#ifdef EGAVGA                                                   /*          */
  &pleFeatureWrite,                                             /*          */
#endif /* EGAVGA */                                             /*          */
#ifdef SVGA                                                     /*          */
  &pleTsengSegSelect2,                  /* 0x03cb */            /*          */
  &pleTsengSegSelect,                   /* 0x03cd */            /*          */
  /* Deliberately at the end: */
  &pleTsengCRTCBIndex,                  /* 0x217a */            /*          */
  &pleTsengCRTCBData,                   /* 0x217b */            /*          */
  &pleATIVGAIndx,                       /* 0x01ce */            /*          */
  &pleATIVGAData,                       /* 0x01cf */            /*          */
#endif /* SVGA */                                               /*          */
  NULL                                                          /*          */
};                                                              /*          */

 /*
 ** Other global data
 **
 **  pPhysVRAM is a global address giving us access to all physical VRAM,
 **  which lets us play with physical video memory whenever we please (although
 **  we will NEVER do so except on behalf of a foreground VDM).
 **
 **  pvdmPhysVRAM contains the physical address of VRAM as it should appear
 **  within each VDM.  Since we don't virtualize non-native video hardware,
 **  this is the same as the actual physical address of system VRAM.
 **
 **  npgPhysVRAM is the no. of pages that physical VRAM extends across.  All
 **  the video hardware we support uses single, contiguous ranges of physical
 **  memory for VRAM.
 **
 **  npgPlane is the size of each video plane, in pages.  This is the size that
 **  each plane in our virtual video buffer is grown to when a VDM has been
 **  switched foreground.
 */

#ifndef EGAVGA
FLAGS   flVVD = VVD_GRFXALLOWED;        /* VVD flags (for CGA and MONO) */
#endif /* !EGAVGA */

ULONG   ulAdapter = ADAPTER_IBM;        /* adapter type */

PSZ     pszVVDName = NULL;

PBYTE   pPhysVRAM = (PBYTE)NULL;        /* global pointer to physical VRAM */

PBVDM   pvdmPhysVRAM =(PBVDM)VRAM_START;/* address of physical VRAM range */

                                        /* # of pages in physical VRAM range */
ULONG   npgPhysVRAM = PAGESFROMBYTES(VRAM_LEN);

ULONG   npgPlane = MAX_PAGESPERPLANE;   /* # of pages in every plane */

LSENTRY lseHeadActive;                  /* head of active VDM list */

HVDM    hvdmFocus;                      /* handle of focus VDM, if any */

HVDM    hvdmUpdate;                     /* handle of next VDM to update (temp.) */

ULONG   nWindowedEvents = 0;            /* total outstanding events */

HMXSEM  hmxWindowedEvent = (HMXSEM)0;   /* controls access to video event data */

HEVSEM  hevWindowedEvent = (HEVSEM)0;   /* cleared when a video event is posted */

ULONG   nWindowedVDMs = 0;              /* total current windowed VDMs */
ULONG   nPMWindowedVDMs = 0;            /* total VDMs being windowed by PM */
ULONG   nMinWindowedVDMs = 0;           /* total VDMs windowed but minimized */

HHOOK   hhookEventTimer;                /* hook handle for VVEventTimer */

PBOOL   pflVDMBusy = NULL;              /* offset to VKBD WakeIdle Flag               */

ULONG   npgActive[] =                                                   /*            */
{                                                                       /*            */
  EGAVGAMEM_PAGES,                                                      /*            */
  EGAVGAMEM_PAGES/2,                                                    /*            */
  MONOMEM_PAGES*2,                      /* EGA has x2 VRAM                            */
  CGAMEM_PAGES*2,                       /* EGA has x2 VRAM                            */
};                                                                      /*            */


 /*  Data conversion tables
 **
 **  apstateMap maps MEMORY_* constants to PAGE_* constants.
 **
 **  abNextStatusState is sort of a condensed version of the real CGA/EGA/VGA
 **  retrace waveforms (condensed so that we make the apps think that they can
 **  write to virtual video memory much more frequently than they could if they
 **  were writing to *physical* video memory).  We can't just always have the
 **  bits ON because some apps look for the transitions that take place in the
 **  actual hardware, and a few apps even look for particular durations.  The
 **  longest expected duration I've seen is 10 consecutive horizontal retraces,
 **  so be sure the table always has at least that many;  it's probably also
 **  best if the table have mixed odd- and/or prime-sized sequences, to
 **  reduce the risk of falling into infinite sync with some piece of complex
 **  retrace logic.  If that still somehow happens, then the user will simply
 **  have to turn off retrace emulation.
 */

CONST PSTATE apstateMap[] =
{
    PAGE_NONE,                          /* MEMORY_NONE (invalid) */
    PAGE_TEXT,                          /* MEMORY_TEXT */
    PAGE_FONT,                          /* MEMORY_FONT */
    PAGE_CGAX,                          /* MEMORY_CGAX */
    PAGE_GRFX,                          /* MEMORY_GRFX */
    PAGE_GRFX,                          /* MEMORY_GRFX2 */
    PAGE_GRFX256,                       /* MEMORY_GRFX256 */
};

CONST BYTE  abNextStatusState[] =       /* see comments above */
{
    0,
    STATUS1_HORZRTRC,
    0,
    STATUS1_HORZRTRC,
    0,
    STATUS1_HORZRTRC,
    0,
    STATUS1_HORZRTRC,
    STATUS1_HORZRTRC | STATUS1_VERTRTRC,
    0,
    STATUS1_HORZRTRC,
    0,
    STATUS1_HORZRTRC,
    0,
    STATUS1_HORZRTRC,
    0,
    STATUS1_HORZRTRC,
    STATUS1_HORZRTRC | STATUS1_VERTRTRC,
    0,
    STATUS1_HORZRTRC,
    0,
    STATUS1_HORZRTRC,
    0,
    STATUS1_HORZRTRC,
    0,
    STATUS1_HORZRTRC,
    STATUS1_HORZRTRC | STATUS1_VERTRTRC,
    0,
    STATUS1_HORZRTRC,
    STATUS1_HORZRTRC | STATUS1_VERTRTRC,
    STATUS1_HORZRTRC | STATUS1_VERTRTRC,
    STATUS1_HORZRTRC | STATUS1_VERTRTRC,
    STATUS1_HORZRTRC | STATUS1_VERTRTRC,
    STATUS1_HORZRTRC | STATUS1_VERTRTRC,
    STATUS1_HORZRTRC | STATUS1_VERTRTRC,
    STATUS1_HORZRTRC | STATUS1_VERTRTRC,
    STATUS1_HORZRTRC | STATUS1_VERTRTRC,
    STATUS1_HORZRTRC | STATUS1_VERTRTRC,
    STATUS1_HORZRTRC | STATUS1_VERTRTRC,
    STATUS1_HORZRTRC | STATUS1_VERTRTRC,
    STATUS1_HORZRTRC,
    0xff                                /* end of table marker */
};

 /*
 **  Mouse data
 **
 **  hvddMouse will contain a handle to the VMD (virtual mouse driver) if it
 **  is installed. It is set up during the first VDM creation, in case we were
 **  installed BEFORE the mouse driver.
 **
 **  vmreg defines, for the VMDEVREQ_REGISTER command, our mouse services
 **  entry points, which the VMD will use at interrupt-time and/or task-time to
 **  manage the video pointer image.
 **
 **  vmfunc, if filled in by the VMD, contains the address of a mouse status
 **  query function, which we will call whenever a light-pen INT 10h request is
 **  made AND the VMD has enabled emulation (ie, PTR_LPENEM is set).
 */

HVDD  hvddMouse = NULL;                 /* non-zero if registered with mouse */


VMREG vmreg =
{
    sizeof(VMREG),
    VVShowPtr,
    VVHidePtr,
    VVDefineTextPtr,
    VVDefineGraphPtr,
    VVSetPtrPage,
    VVSetLPenEmulation,
};

VMFUNC vmfunc =
{
    sizeof(VMFUNC),
    NULL,
};


 /*
 ** Define array of function addresses for DosRequestVDD services
 */


PSYSFUN apfnSysReq[VVDSYSREQ_MAX] =
{
    vvSysSetAccess,
    vvSysSetFocus,
    vvSysSetLock,
    vvSysQueryMode,
    vvSysQueryCursor,
    vvSysQueryPalette,
    vvSysCopyLVB,
    vvSysCopyBitmap,
    vvSysWaitEvent,
    vvSysControlEvent,
    vvSysSetDisplayReq,
    vvSysRequestMemory,
    vvSysFreeMemory,
    vvSysRequestController,
    vvSysFreeController,
    vvSysQueryVRAMStatus,
    vvSysSetOEMFlag                                                     /*            */
};


 /*
 ** Define array of function addresses for VDHRequestVDD services
 */


PDEVFUN apfnDevReq[VVDDEVREQ_MAX] =
{
    vvDevPostPeek,
    vvDevPostRead,
    vvDevPostPaste,
    vvDevPostMouse,
    vvDevAcceptAdapter,
    vvDevReleaseAdapter,
    vvDevAcceptDisplay,
    vvDevReleaseDisplay,
    (PDEVFUN)vvDevPostVideoEvent,
    vvDevSaveRestoreAdapter,                                            /*            */
    vvDevRepaint,                                                       /*            */
    vvDevRequestController,                                             /*            */
    vvDevFreeController,                                                /*            */
    vvDevWindowsDeskTop,                                                /*            */
    vvDevEnableDDE,                                                     /*            */
    vvDevXGAPresent,                                                    /*            */
    vvDevUnmapVRAM,                                                     /*            */
    vvDev8514Present                                                    /*            */
};


#ifdef VDDSTRICT

#if   defined(SVGA)
CHAR szAssertMsg[] = "VSVGA assertion failure in %s, line %d\n";
#elif defined(CGA)
CHAR szAssertMsg[] = "VCGA assertion failure in %s, line %d\n";
#elif defined(EGA)
CHAR szAssertMsg[] = "VEGA assertion failure in %s, line %d\n";
#elif defined(VGA)
CHAR szAssertMsg[] = "VVGA assertion failure in %s, line %d\n";
#elif defined(MONO)
CHAR szAssertMsg[] = "VMONO assertion failure in %s, line %d\n";
#endif

#endif


#ifdef VDDDEBUG

#if   defined(SVGA)
CHAR szModule[] = "VSVGA: ";
#elif defined(CGA)
CHAR szModule[] = "VCGA: ";
#elif defined(EGA)
CHAR szModule[] = "VEGA: ";
#elif defined(VGA)
CHAR szModule[] = "VVGA: ";
#elif defined(MONO)
CHAR szModule[] = "VMONO: ";
#endif
CHAR *apszPageStates[] = {"NONE", "TEXT", "FONT", "CGAX", "GRFX", "NULL"};

#endif

#pragma END_SWAP_DATA



#pragma BEGIN_GLOBAL_DATA

#ifdef EGAVGA

FLAGS   flVVD = VVD_GRFXALLOWED;        /* VVD flags */

HVDM    hvdmController = NULL;          /* handle of owning VDM, NULL if none */
HEVSEM  hevControllerEvent = (HEVSEM)0;
#ifdef VGA                                                        /*          */
FLAGS      flNotifyType = NULL;                                   /*          */
PFNINT2FP  pfnInt2FProc = (PFNINT2FP)0;                           /*          */
ULONG   pfOEMFlags = NULL;              /* pointer to OEM flag*/  /*          */
#endif                                                            /*          */
VVDRQ   vvdrqVideo = {0, ALL_RESERVED, NULL, 0, NULL, NULL, 0, NULL};

#endif

#ifdef VDDDEBUG                                                         /*75466*/
BYTE vvDebugInfo[128*5*2]; /* 128 bytes for 5 slots with 2 save areas *//*75466*/
#endif                                                                  /*75466*/

#pragma END_GLOBAL_DATA
