/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = VVDAC.C
 *
 * DESCRIPTIVE NAME = Virtual Video HiColor DAC Specific routines
 *
 *
 * VERSION = V2.0
 *
 * DATE      11/10/88
 *
 * DESCRIPTION
 *              This module contains the VVD's HiColor DAC specific rtn & data.
 *
 *
 * FUNCTIONS
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/


#define  IO8BIT          /* CL386 Version 6.00.054 FLAG:               */
#include <mvdm.h>
#include <vvd.h>
#include "vvdp.h"

#ifdef   VDDSTRICT
MODNAME = __FILE__;
#endif

#pragma  BEGIN_SWAP_DATA

extern PLE pleCRTIndx;                  /* 0x03d4 (R/W) */      /*          */
extern PLE pleCRTData;                  /* 0x03d5 (R/W) */      /*          */
extern PLE pleVGADACMask;               /* 0x03c6 (R/W) */      /*          */
extern PLE pleVGADACRead;               /* 0x03c7 (R/W) */      /*          */
extern PLE pleVGADACWrite;              /* 0x03c8 (R/W) */      /*          */
extern PLE pleVGADACData;               /* 0x03c8 (R/W) */      /*          */

extern SDACINFO sVGADacStdInfo;                                 /*          */
extern PSDACINFO psCurDacInfo;                                  /*          */

extern PSSVGAINFO psCurAdapterInfo;                             /*          */

PPLE ppleDacExtMask = &pleVGADACMask;                           /*          */
PPLE ppleDacExtRead = &pleVGADACRead;                           /*          */
PPLE ppleDacExtWrite = &pleVGADACWrite;                         /*          */
PPLE ppleDacExtData = &pleVGADACData;                           /*          */

#pragma  END_SWAP_DATA

#pragma  BEGIN_SWAP_CODE
                                                                /*          */
/* Was vvVGADACRS2Reset */                                      /*          */
/***************************************************************************
 *
 * FUNCTION NAME = vvDacHiColorIPFClear()
 *
 * DESCRIPTION   = Clear DAC IPF (Internal Programming Flag)
 *
 * INPUT         = NONE
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL =
 * RETURN-ERROR  =
 *
 ****************************************************************************/

VOID PRIVENTRY vvDacHiColorIPFClear(                            /*          */
  HVDM hvdm )
{
  hvdm;
  vvInput( INVALID_HVDM,                                        /*          */
           ppleDacExtWrite );           /* reset DAC RS2 = 0  *//*          */
  vvInput( INVALID_HVDM,                                        /*          */
           ppleDacExtRead );            /* reset DAC RS2 = 0  *//*          */
}
                                                                /*          */
/* Was vvVGADACRS2Set */                                        /*          */
/***************************************************************************
 *
 * FUNCTION NAME = vvDacHiColorIPFSet()
 *
 * DESCRIPTION   = Set DAC IPF (Internal Programming Flag)
 *
 * INPUT         = NONE
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL =
 * RETURN-ERROR  =
 *
 ****************************************************************************/

VOID PRIVENTRY vvDacHiColorIPFSet(                              /*          */
  HVDM hvdm )
{
  register INT i;

  vvDacHiColorIPFClear( hvdm );         /* DAC RS2 = 0 */       /*          */
  for( i = 0;
       i < 4;
       i++ )
    vvInput( INVALID_HVDM,                                      /*          */
             ppleDacExtMask );          /* set DAC RS2 = 1 */   /*          */
}
                                                                /*          */
/* Was vvSVGAHiColorDACSave */                                  /*          */
/***************************************************************************
 *
 * FUNCTION NAME = vvDacHiColorSave()
 *
 * DESCRIPTION   = Save DAC state from hardware
 *
 *                 Save the DAC's internal state.  Specifically, this is:
 *                     - Read/Write mode
 *                     - 0 (normal), 1 or 2 bytes read/written
 *
 * INPUT         = hvdm -> VDM
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL =
 * RETURN-ERROR  =
 *
 ****************************************************************************/

VOID PRIVENTRY vvDacHiColorSave(                                /*          */
  HVDM hvdm )
{
  register PVDMDATA pvd = pVDMData(hvdm);

  psCurAdapterInfo->pfnSVGADacRS2Clear( hvdm );/* DAC RS2 = 0 *//*          */
  vvVGADacStdSave( hvdm );                                      /*          */
  psCurAdapterInfo->pfnSVGADacRS2Set( hvdm );  /* DAC RS2 = 1 *//*          */
  pvd->VdmSVGA.abregHiColorDac [0] =                            /*          */
    vvInput( INVALID_HVDM,                                      /*          */
             ppleDacExtMask );          /*save 1 value*/        /*          */
  psCurAdapterInfo->pfnSVGADacRS2Clear( hvdm );/* DAC RS2 = 0 *//*          */
}
                                                                /*          */
/***************************************************************************
 *
 * FUNCTION NAME = vvDacHiColorRestore()
 *
 * DESCRIPTION   = Restore DAC state to hardware
 *
 *                 Restore the DAC's internal state.  Specifically, this is:
 *                     - Read/Write mode
 *                     - 0 (normal), 1 or 2 bytes read/written
 *
 * INPUT         = hvdm -> VDM
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL =
 * RETURN-ERROR  =
 *
 ****************************************************************************/

VOID PRIVENTRY vvDacHiColorRestore(                             /*          */
  HVDM hvdm )
{
  register PVDMDATA pvd = pVDMData(hvdm);

  psCurAdapterInfo->pfnSVGADacRS2Set( hvdm );  /* DAC RS2 = 1 *//*          */
  vvOutput( INVALID_HVDM,                                       /*          */
            ppleDacExtMask,                                     /*          */
            pvd->VdmSVGA.abregHiColorDac [0] );/* set 1 value *//*          */
  psCurAdapterInfo->pfnSVGADacRS2Clear( hvdm );/* DAC RS2 = 0 *//*          */
  /* Just in case this is NOT a HiColor DAC: */                 /*          */
  vvOutput( INVALID_HVDM,                                       /*          */
            ppleDacExtMask,                                     /*          */
            pvd->regDACMask );                                  /*          */
  vvVGADacStdRestore( hvdm );                                   /*          */
}
                                                                /*          */
/* Was vvS3BT485Save */                                         /*          */
/***************************************************************************
 *
 * FUNCTION NAME = vvDacBT485Save()
 *
 * DESCRIPTION   = Save DAC state from hardware
 *
 *                 Save the DAC's internal state.  Specifically, this is:
 *                     - Read/Write mode
 *                     - 0 (normal), 1 or 2 bytes read/written
 *
 * INPUT         = hvdm -> VDM
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL =
 * RETURN-ERROR  =
 *
 ****************************************************************************/

VOID PRIVENTRY vvDacBT485Save(                                  /*          */
  HVDM hvdm )
{
  register PVDMDATA pvd = pVDMData(hvdm);

  vvDacHiColorSave( hvdm );                                     /*          */
//psCurAdapterInfo->pfnSVGADacRS2Clear( hvdm );/* DAC RS2 = 0 *//*          */

  /* access Command Reg 1 */
  psCurAdapterInfo->pfnSVGADacRS3( hvdm,                        /*          */
                                   TRUE );     /* DAC RS3 = 1 */
  pvd->VdmSVGA.abregHiColorDac [1] =                            /*          */
    vvInput( INVALID_HVDM,
             ppleDacExtWrite );                /* save CR1 */   /*          */

  /* access Command Reg 2 */
  pvd->VdmSVGA.abregHiColorDac [2] =                            /*          */
    vvInput( INVALID_HVDM,
             ppleDacExtData );                 /* save CR2 */   /*          */
  psCurAdapterInfo->pfnSVGADacRS3( hvdm,                        /*          */
                                   FALSE );    /* DAC RS3 = 0 */

  /* access Command Reg 3 */
  /* first turn on Bit 7 of Cmd Reg 0 */
  psCurAdapterInfo->pfnSVGADacRS2Set( hvdm );  /* DAC RS2 = 1 *//*          */
  vvOutput( INVALID_HVDM,
            ppleDacExtMask,                                     /*          */
            (BYTE) (pvd->VdmSVGA.abregHiColorDac [0] | 0x80) ); /*          */
  psCurAdapterInfo->pfnSVGADacRS2Clear( hvdm );/* DAC RS2 = 0 *//*          */

  /* second set index to 0x01 */
  vvOutput( INVALID_HVDM,
            ppleDacExtWrite,                                    /*          */
            0x01 );

  psCurAdapterInfo->pfnSVGADacRS3( hvdm,                        /*          */
                                   TRUE );     /* DAC RS3 = 1 */
  pvd->VdmSVGA.abregHiColorDac [3] =                            /*          */
    vvInput( INVALID_HVDM,
             ppleDacExtMask );                 /* save CR3 */   /*          */
  psCurAdapterInfo->pfnSVGADacRS3( hvdm,                        /*          */
                                   FALSE );    /* DAC RS3 = 0 */

  /* restore DAC index */
  vvOutput( INVALID_HVDM,
            ppleDacExtWrite,
            pvd->regDACIndx );

  /* restore Bit 7 of Cmd Reg 0 */
  psCurAdapterInfo->pfnSVGADacRS2Set( hvdm );  /* DAC RS2 = 1 *//*          */
  vvOutput( INVALID_HVDM,
            ppleDacExtMask,                                     /*          */
            pvd->VdmSVGA.abregHiColorDac [0] );                 /*          */
  psCurAdapterInfo->pfnSVGADacRS2Clear( hvdm );/* DAC RS2 = 0 *//*          */
}
                                                                /*          */
/***************************************************************************
 *
 * FUNCTION NAME = vvDacBT485Restore()
 *
 * DESCRIPTION   = Restore DAC state to hardware
 *
 *                 Restore the DAC's internal state.  Specifically, this is:
 *                     - Read/Write mode
 *                     - 0 (normal), 1 or 2 bytes read/written
 *
 * INPUT         = hvdm -> VDM
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL =
 * RETURN-ERROR  =
 *
 ****************************************************************************/

VOID PRIVENTRY vvDacBT485Restore(                               /*          */
  HVDM hvdm )
{
  register PVDMDATA pvd = pVDMData(hvdm);

  /* access Command Reg 1 */
  psCurAdapterInfo->pfnSVGADacRS3( hvdm,                        /*          */
                                   TRUE );     /* DAC RS3 = 1 */
  vvOutput( INVALID_HVDM,
            ppleDacExtWrite,                                    /*          */
            pvd->VdmSVGA.abregHiColorDac [1] );/* set CR1 */    /*          */

  /* access Command Reg 2 */
  vvOutput( INVALID_HVDM,
            ppleDacExtData,                                     /*          */
            pvd->VdmSVGA.abregHiColorDac [2] );/* set CR2 */    /*          */
  psCurAdapterInfo->pfnSVGADacRS3( hvdm,                        /*          */
                                   FALSE );    /* DAC RS3 = 0 */

  /* access Command Reg 3 */
  /* first turn on Bit 7 of Cmd Reg 0 */
  psCurAdapterInfo->pfnSVGADacRS2Set( hvdm );  /* DAC RS2 = 1 *//*          */
  vvOutput( INVALID_HVDM,
            ppleDacExtMask,                                     /*          */
            (BYTE) (pvd->VdmSVGA.abregHiColorDac [0] | 0x80) ); /*          */
  psCurAdapterInfo->pfnSVGADacRS2Clear( hvdm );/* DAC RS2 = 0 *//*          */

  /* second set index to 0x01 */
  vvOutput( INVALID_HVDM,
            ppleDacExtWrite,                                    /*          */
            0x01 );
  psCurAdapterInfo->pfnSVGADacRS3( hvdm,                        /*          */
                                   TRUE );     /* DAC RS3 = 1 */
  vvOutput( INVALID_HVDM,
            ppleDacExtMask,                                     /*          */
            pvd->VdmSVGA.abregHiColorDac [3] );/* set CR3 */    /*          */
  psCurAdapterInfo->pfnSVGADacRS3( hvdm,                        /*          */
                                   FALSE );    /* DAC RS3 = 0 */

  /* restore DAC index */
  vvOutput( INVALID_HVDM,
            ppleDacExtWrite,                                    /*          */
            pvd->regDACIndx );

  /* restore Bit 7 of Cmd Reg 0 */
  vvDacHiColorRestore( hvdm );                                  /*          */
//psCurAdapterInfo->pfnSVGADacRS2Clear( hvdm );/* DAC RS2 = 0 *//*          */
}
                                                                /*          */
/***************************************************************************
 *
 * FUNCTION NAME = vvDacSGS1700Save()
 *
 * DESCRIPTION   = Save DAC state from hardware
 *
 *                 Save the DAC's internal state.  Specifically, this is:
 *
 * INPUT         = hvdm -> VDM
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL =
 * RETURN-ERROR  =
 *
 ****************************************************************************/

VOID PRIVENTRY vvDacSGS1700Save(                                /*          */
  HVDM hvdm )
{
  register PVDMDATA pvd = pVDMData(hvdm);

  vvDacHiColorSave( hvdm );
  psCurAdapterInfo->pfnSVGADacRS2Set( hvdm );  /* DAC RS2 = 1 */
  vvOutput( INVALID_HVDM,
            ppleDacExtMask,                                     /*          */
            (BYTE) (pvd->VdmSVGA.abregHiColorDac [0] | 0x10) );
  psCurAdapterInfo->pfnSVGADacRS2Clear( hvdm ); /* DAC RS2 = 0 */
  /* Deliberately set via IPF method */
  /* So that next bytes can be addressed implicitly */
  vvDacHiColorIPFSet( hvdm );
  vvInput( INVALID_HVDM,                /* Skip cmd reg */      /*          */
           ppleDacExtMask );                                    /*          */
  vvOutput( INVALID_HVDM,
            ppleDacExtMask,                                     /*          */
            0x03 );
  vvOutput( INVALID_HVDM,
            ppleDacExtMask,                                     /*          */
            0x00 );
  pvd->VdmSVGA.abregHiColorDac [1] =
    vvInput( INVALID_HVDM,
             ppleDacExtMask );          /*save 1 value*/        /*          */
  pvd->VdmSVGA.abregHiColorDac [2] =
    vvInput( INVALID_HVDM,
             ppleDacExtMask );          /*save 1 value*/        /*          */
  pvd->VdmSVGA.abregHiColorDac [3] =
    vvInput( INVALID_HVDM,
             ppleDacExtMask );          /*save 1 value*/        /*          */
  psCurAdapterInfo->pfnSVGADacRS2Set( hvdm );  /* DAC RS2 = 1 */
  vvOutput( INVALID_HVDM,
            ppleDacExtMask,                                     /*          */
            pvd->VdmSVGA.abregHiColorDac [0] );
  psCurAdapterInfo->pfnSVGADacRS2Clear( hvdm );/* DAC RS2 = 0 */
}
                                                                /*          */
/***************************************************************************
 *
 * FUNCTION NAME = vvDacSGS1700Restore()
 *
 * DESCRIPTION   = Restore DAC state to hardware
 *
 *                 Restore the DAC's internal state.  Specifically, this is:
 *                     - Read/Write mode
 *                     - 0 (normal), 1 or 2 bytes read/written
 *
 * INPUT         = hvdm -> VDM
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL =
 * RETURN-ERROR  =
 *
 ****************************************************************************/

VOID PRIVENTRY vvDacSGS1700Restore(                             /*          */
  HVDM hvdm )
{
  register PVDMDATA pvd = pVDMData(hvdm);

  psCurAdapterInfo->pfnSVGADacRS2Set( hvdm );  /* DAC RS2 = 1 */
  vvOutput( INVALID_HVDM,
            ppleDacExtMask,                                     /*          */
            (BYTE) (pvd->VdmSVGA.abregHiColorDac [0] | 0x10) );
  psCurAdapterInfo->pfnSVGADacRS2Clear( hvdm ); /* DAC RS2 = 0 */
  /* Deliberately set via IPF method */
  /* So that next bytes can be addressed implicitly */
  vvDacHiColorIPFSet( hvdm );
  vvInput( INVALID_HVDM,                /* Skip cmd reg */      /*          */
           ppleDacExtMask );                                    /*          */
  vvOutput( INVALID_HVDM,
            ppleDacExtMask,                                     /*          */
            0x03 );
  vvOutput( INVALID_HVDM,
            ppleDacExtMask,                                     /*          */
            0x00 );
  vvOutput( INVALID_HVDM,
            ppleDacExtMask,                                     /*          */
            pvd->VdmSVGA.abregHiColorDac [1] );
  vvOutput( INVALID_HVDM,
            ppleDacExtMask,                                     /*          */
            pvd->VdmSVGA.abregHiColorDac [2] );
  vvOutput( INVALID_HVDM,
            ppleDacExtMask,                                     /*          */
            pvd->VdmSVGA.abregHiColorDac [3] );
  vvDacHiColorRestore( hvdm );
//psCurAdapterInfo->pfnSVGADacRS2Clear( hvdm );/* DAC RS2 = 0 */
}
                                                                /*          */
/* Was vvS3SDACSave */                                          /*          */
/***************************************************************************
 *
 * FUNCTION NAME = vvDacS3SDACSave()
 *
 * DESCRIPTION   = Save DAC state from hardware
 *
 *                 Save the DAC's internal state.  Specifically, this is:
 *                     - Read/Write mode
 *                     - 0 (normal), 1 or 2 bytes read/written
 *
 * INPUT         = hvdm -> VDM
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL =
 * RETURN-ERROR  =
 *
 ****************************************************************************/

VOID PRIVENTRY vvDacS3SDACSave(                                 /*          */
  HVDM hvdm )
{
  register PVDMDATA pvd = pVDMData(hvdm);                       /*          */

  vvDacHiColorSave( hvdm );                                     /*          */
//psCurAdapterInfo->pfnSVGADacRS2Clear( hvdm );/* DAC RS2 = 0 *//*          */

  psCurAdapterInfo->pfnSVGADacRS2Set( hvdm );  /* DAC RS2 = 1 *//*          */
  vvOutput( INVALID_HVDM,                                       /*          */
            ppleDacExtWrite,                                    /*          */
            0x02 );                     /* set PLL DCLK index *//*          */
  pvd->VdmSVGA.abregHiColorDac [1] =                            /*          */
    vvInput( INVALID_HVDM,                                      /*          */
             ppleDacExtData );          /* set M and N*/        /*          */
  pvd->VdmSVGA.abregHiColorDac [2] =                            /*          */
    vvInput( INVALID_HVDM,                                      /*          */
             ppleDacExtData );          /* set N      */        /*          */
  vvOutput( INVALID_HVDM,                                       /*          */
            ppleDacExtWrite,                                    /*          */
            0x0a );                     /* set PLL MCLK index *//*          */
  pvd->VdmSVGA.abregHiColorDac [3] =                            /*          */
    vvInput( INVALID_HVDM,                                      /*          */
             ppleDacExtData );          /* set M and N*/        /*          */
  pvd->VdmSVGA.abregHiColorDac [4] =                            /*          */
    vvInput( INVALID_HVDM,                                      /*          */
             ppleDacExtData );          /* set N      */        /*          */
  psCurAdapterInfo->pfnSVGADacRS2Clear( hvdm );/* DAC RS2 = 0 *//*          */
}
                                                                /*          */
/* Was vvS3SDACRestore */                                       /*          */
/***************************************************************************
 *
 * FUNCTION NAME = vvDacS3SDACRestore()
 *
 * DESCRIPTION   = Restore DAC state to hardware
 *
 *                 Restore the DAC's internal state.  Specifically, this is:
 *                     - Read/Write mode
 *                     - 0 (normal), 1 or 2 bytes read/written
 *
 * INPUT         = hvdm -> VDM
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL =
 * RETURN-ERROR  =
 *
 ****************************************************************************/

VOID PRIVENTRY vvDacS3SDACRestore(                              /*          */
  HVDM hvdm )
{
  register PVDMDATA pvd = pVDMData(hvdm);                       /*          */

  psCurAdapterInfo->pfnSVGADacRS2Set( hvdm );  /* DAC RS2 = 1 *//*          */
  vvOutput( INVALID_HVDM,                                       /*          */
            ppleDacExtWrite,                                    /*          */
            0x02 );               /* set PLL DCLK index */      /*          */
  vvOutput( INVALID_HVDM,         /* set M and N*/              /*          */
            ppleDacExtData,                                     /*          */
            pvd->VdmSVGA.abregHiColorDac [1] );                 /*          */
  vvOutput( INVALID_HVDM,         /* set N   */                 /*          */
            ppleDacExtData,                                     /*          */
            pvd->VdmSVGA.abregHiColorDac [2] );                 /*          */
  vvOutput( INVALID_HVDM,                                       /*          */
            ppleDacExtWrite,                                    /*          */
            0x0a );               /* set PLL MCLK index */      /*          */
  vvOutput( INVALID_HVDM,         /* set M and N*/              /*          */
            ppleDacExtData,                                     /*          */
            pvd->VdmSVGA.abregHiColorDac [3] );                 /*          */
  vvOutput( INVALID_HVDM,         /* set N   */                 /*          */
            ppleDacExtData,                                     /*          */
            pvd->VdmSVGA.abregHiColorDac [4] );                 /*          */
  vvDacHiColorRestore( hvdm );                                  /*          */
//psCurAdapterInfo->pfnSVGADacRS2Clear( hvdm );/* DAC RS2 = 0 *//*          */
}
                                                                /*          */
/***************************************************************************
 *
 * FUNCTION NAME = vvDacTLC34075Save()
 *
 * DESCRIPTION   = Save DAC state from hardware
 *
 *                 Save the DAC's internal state.  Specifically, this is:
 *
 * INPUT         = hvdm -> VDM
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL =
 * RETURN-ERROR  =
 *
 ****************************************************************************/

VOID PRIVENTRY vvDacTLC34075Save(                               /*          */
  HVDM hvdm )
{
  register PVDMDATA pvd = pVDMData(hvdm);

  psCurAdapterInfo->pfnSVGADacRS2Clear( hvdm );/* DAC RS2 = 0 */
  psCurAdapterInfo->pfnSVGADacRS3( hvdm,                        /*          */
                                   FALSE );    /* DAC RS3 = 0 */
  vvVGADacStdSave( hvdm );
  psCurAdapterInfo->pfnSVGADacRS3( hvdm,                        /*          */
                                   TRUE );     /* DAC RS3 = 1 */
  pvd->VdmSVGA.abregHiColorDac [3] =                            /*          */
    vvInput( INVALID_HVDM,
             ppleDacExtData );          /*save 1 value*/        /*          */
  pvd->VdmSVGA.abregHiColorDac [2] =                            /*          */
    vvInput( INVALID_HVDM,
             ppleDacExtWrite );         /*save 1 value*/        /*          */
  pvd->VdmSVGA.abregHiColorDac [1] =                            /*          */
    vvInput( INVALID_HVDM,
             ppleDacExtRead );          /*save 1 value*/        /*          */
  pvd->VdmSVGA.abregHiColorDac [0] =                            /*          */
    vvInput( INVALID_HVDM,
             ppleDacExtMask );          /*save 1 value*/        /*          */
  psCurAdapterInfo->pfnSVGADacRS3( hvdm,                        /*          */
                                   FALSE );    /* DAC RS3 = 0 */
}
                                                                /*          */
/***************************************************************************
 *
 * FUNCTION NAME = vvDacTLC34075Restore()
 *
 * DESCRIPTION   = Restore DAC state to hardware
 *
 *                 Restore the DAC's internal state.  Specifically, this is:
 *
 * INPUT         = hvdm -> VDM
 *
 * OUTPUT        = None
 *
 * RETURN-NORMAL =
 * RETURN-ERROR  =
 *
 ****************************************************************************/

VOID PRIVENTRY vvDacTLC34075Restore(                            /*          */
  HVDM hvdm )
{
  register PVDMDATA pvd = pVDMData(hvdm);

  psCurAdapterInfo->pfnSVGADacRS2Clear( hvdm );  /* DAC RS2 = 0 */
  psCurAdapterInfo->pfnSVGADacRS3( hvdm,
                                   TRUE );     /* DAC RS3 = 1 */
  /* Must be restored in this order! */                         /*          */
  vvOutput( INVALID_HVDM,
            ppleDacExtMask,                                     /*          */
            pvd->VdmSVGA.abregHiColorDac [0] );/* set 1 value */
  vvOutput( INVALID_HVDM,
            ppleDacExtRead,                                     /*          */
            pvd->VdmSVGA.abregHiColorDac [1] );/* set 1 value */
  vvOutput( INVALID_HVDM,
            ppleDacExtWrite,                                    /*          */
            pvd->VdmSVGA.abregHiColorDac [2] );/* set 1 value */
  vvOutput( INVALID_HVDM,
            ppleDacExtData,                                     /*          */
            pvd->VdmSVGA.abregHiColorDac [3] );/* set 1 value */
  psCurAdapterInfo->pfnSVGADacRS3( hvdm,
                                   FALSE );    /* DAC RS3 = 0 */
  vvVGADacStdRestore( hvdm );
}
                                                                /*          */
/***************************************************************************
 *
 * FUNCTION NAME = vvDacMusicBugIPFSet()
 *
 * DESCRIPTION   = Set DAC IPF (Internal Programming Flag)
 *
 * INPUT         = NONE
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL =
 * RETURN-ERROR  =
 *
 ****************************************************************************/

VOID PRIVENTRY vvDacMusicBugIPFSet(                             /*          */
  HVDM hvdm )
{
  register INT i;

  vvDacHiColorIPFSet( hvdm );
  /* One more input than the usual! */
  vvInput( INVALID_HVDM,
           ppleDacExtMask );            /* set DAC RS2 = 1 */   /*          */
}

#pragma  END_SWAP_CODE

/****************************************************************************/

#pragma  BEGIN_SWAP_DATA                                        /*          */

SDACINFO sDacATI68830Info =                                     /*          */
{                                                               /*          */
  ATI68830_NAME,                                                /*          */
  &vvVGADacStdIPFClear,                                         /*          */
  &vvVGADacStdIPFSet,                                           /*          */
  &vvDacTLC34075Save,                                           /*          */
  &vvDacTLC34075Restore,                                        /*          */
};                                                              /*          */

SDACINFO sDacATI68860Info =                                     /*          */
{                                                               /*          */
  ATI68860_NAME,                                                /*          */
  &vvVGADacStdIPFClear,                                         /*          */
  &vvVGADacStdIPFSet,                                           /*          */
  &vvDacTLC34075Save,                                           /*          */
  &vvDacTLC34075Restore,                                        /*          */
};                                                              /*          */

SDACINFO sDacBT485Info =                                        /*          */
{                                                               /*          */
  BT485_NAME,                                                   /*          */
  &vvVGADacStdIPFClear,                                         /*          */
  &vvVGADacStdIPFSet,                                           /*          */
  &vvDacBT485Save,                                              /*          */
  &vvDacBT485Restore,                                           /*          */
};                                                              /*          */

SDACINFO sDacHiColorInfo =                                      /*          */
{                                                               /*          */
  HICOLOR_NAME,                                                 /*          */
  &vvDacHiColorIPFClear,                                        /*          */
  &vvDacHiColorIPFSet,                                          /*          */
  &vvDacHiColorSave,                                            /*          */
  &vvDacHiColorRestore,                                         /*          */
};                                                              /*          */

SDACINFO sDacMusicBugInfo =                                     /*          */
{                                                               /*          */
  MU9CBUG_NAME,                                                 /*          */
  &vvDacHiColorIPFClear,                                        /*          */
  &vvDacMusicBugIPFSet,                                         /*          */
  &vvDacHiColorSave,                                            /*          */
  &vvDacHiColorRestore,                                         /*          */
};                                                              /*          */

SDACINFO sDacS3SDACInfo =                                       /*          */
{                                                               /*          */
  S3SDAC_NAME,                                                  /*          */
  &vvVGADacStdIPFClear,                                         /*          */
  &vvVGADacStdIPFSet,                                           /*          */
  &vvDacS3SDACSave,                                             /*          */
  &vvDacS3SDACRestore,                                          /*          */
};                                                              /*          */

SDACINFO sDacSGS1700Info =                                      /*          */
{                                                               /*          */
  SGS1700_NAME,                                                 /*          */
  &vvDacHiColorIPFClear,                                        /*          */
  &vvDacHiColorIPFSet,                                          /*          */
  &vvDacSGS1700Save,                                            /*          */
  &vvDacSGS1700Restore,                                         /*          */
};                                                              /*          */

SDACINFO sDacSGS1702Info =                                      /*          */
{                                                               /*          */
  SGS1702_NAME,                                                 /*          */
  &vvDacHiColorIPFClear,                                        /*          */
  &vvDacHiColorIPFSet,                                          /*          */
  &vvDacSGS1700Save,                                            /*          */
  &vvDacSGS1700Restore,                                         /*          */
};                                                              /*          */

SDACINFO sDacSGS1703Info =                                      /*          */
{                                                               /*          */
  SGS1703_NAME,                                                 /*          */
  &vvDacHiColorIPFClear,                                        /*          */
  &vvDacHiColorIPFSet,                                          /*          */
  &vvDacSGS1700Save,                                            /*          */
  &vvDacSGS1700Restore,                                         /*          */
};                                                              /*          */

SDACINFO sDacTLC34075Info =                                     /*          */
{                                                               /*          */
  TLC34075_NAME,                                                /*          */
  &vvVGADacStdIPFClear,                                         /*          */
  &vvVGADacStdIPFSet,                                           /*          */
  &vvDacTLC34075Save,                                           /*          */
  &vvDacTLC34075Restore,                                        /*          */
};                                                              /*          */

/* Except for the first two entries in apsAllDacInfo */         /*          */
/* this does NOT have to be in DAC index consecutive order. */  /*          */
/* DAC is identified by name in table, not the number. */       /*          */
/* Unmatched names get treated as identical to HiColor. */      /*          */
/* Null pointer entries are ignored */                          /*          */

PSDACINFO apsAllDacInfo [MAX_DAC] =                             /*          */
{
  &sVGADacStdInfo,      /* 00 = UNKNOWN_DAC        */           /*          */
  &sDacHiColorInfo,     /* 01 = HICOLOR_DAC        */           /*          */
  &sDacBT485Info,       /* 02 = BT485_DAC          */           /*          */
  &sDacMusicBugInfo,    /* 06 = MU9CBUG_DAC        */           /*          */
  &sDacSGS1702Info,     /* 12 = SGS1702_DAC        */           /*          */
  &sDacSGS1703Info,     /* 13 = SGS1703_DAC        */           /*          */
  &sDacATI68830Info,    /* 15 = ATI68830_DAC       */           /*          */
  &sDacS3SDACInfo,      /* 16 = S3SDAC_DAC         */           /*          */
  &sDacSGS1700Info,     /* 18 = SGS1703_DAC        */           /*          */
  &sDacTLC34075Info,    /* 19 = TLC34075_DAC       */           /*          */
  &sDacATI68860Info,    /* 22 = ATI68860_DAC       */           /*          */
};

#pragma  END_SWAP_DATA                                          /*          */

