/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = VV8514P.H
 *
 * DESCRIPTIVE NAME = Virtual Video Private Definitions for the 8514/A
 *
 *
 * VERSION = V2.0
 *
 * DATE      02/07/90
 *
 * DESCRIPTION  V8514.SYS private constants, types, and function prototypes
 *
 * FUNCTIONS
 *
 * NOTES
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/


#define PROPERTIES                      /* include properties support         */

#include <int2f.h>                      /* Also                                       */
#define INT2F_SYSBGND   0x4001          /*     defined                                */
#define INT2F_SYSFGND   0x4002          /*            in VVDP.H                       */

#define MAX_HRES        1024
#define MAX_VRES        1024

#define MAX_VDM_WAIT    15000           /* max screen-switch delay (ms)       */

#define MAX_DACREGS     TOTAL_DACREGS


#ifdef SETMODE_SUPPORT

 /*
 ** Internally defined modes
 */

#define MODE_1024x768   0
#define MODE_640x480x4  1
#define MODE_640x480x8  2

#define MAX_MODES       3
#define MAX_INITREGS    10

#endif


 /*
 ** Per-VDM Video VDD flags (see flVDM8514)
 **
 ** The DEVOWNER bit is set as long as the VDD owns the device (ie,
 ** is responsible for I/O trapping, buffer save/restore, etc).  It can be
 ** cleared if another VDD requests the adapter from us, and set when the
 ** adapter is given back.  This is to allow other VDDs to extend the
 ** functionality of our VDD if they have extended modes that they need to
 ** manage themselves.
 **
 ** The DSPOWNER bit is set if the VDD owns the display, and clear otherwise.
 ** This is only important in systems where two or more adapters can drive
 ** a single display (ie, planar VGA and 8514/A, with monitor connected to the
 ** 8514/A).  Each of the corresponding VDDs assumes a posture that corresponds
 ** to the power-up configuration, and they must cooperatively request and
 ** release display ownership.  On a VGA+8514/A system, when the 8514/A enters
 ** "native mode" and exits "pass-thru mode", it must request display
 ** ownership; similarly, when returning to "pass-thru mode", it must release
 ** display ownership.
 **
 ** Note that losing display ownership does not imply losing device ownership;
 ** as in the case of VGA+8514/A, even though only one of the devices can
 ** drive the display at any one time, both devices are constantly active, and
 ** so both VDDs must remain active as well.
 */

#define VDM_DEVOWNER    0x00000002      /* VDD owns device for this VDM       */
#define VDM_DSPOWNER    0x00000004      /* VDD owns display for this VDM      */
#define VDM_FGND        0x00000008      /* VDM foreground (owns screen)       */
#define VDM_IOINIT      0x00000080      /* VDM I/O initialization is done     */
#define VDM_DACREADING  0x00000400      /* DAC color table is being read      */
#define VDM_IOOWNED     0x00000800      /* I/O ownership flag                 */
#define VDM_IOWAKEME    0x00001000      /* I/O ownership notify flag          */
#define VDM_FROZEN      0x00020000      /* We have suspended VDM              */
#define VDM_BLOCKED     0x00040000      /* We have blocked VDM I/O            */
#define VDM_CONTEXTHOOK 0x00400000      /* VDMContext hook is armed           */
#define VDM_INT2FWAKEME 0x20000000      /* Int 2F completion flag                     */
#define VDM_INT2F       0x40000000      /* Enable Int 2Fh notification                */
#define VDM_IOTRAPPED   0x80000000      /* trapping enabled at all times      */


#define INVALID_HVDM    ((HVDM)-2)

typedef LONG (PRIVENTRY *PSYSFUN)(HVDM, ULONG, PVOID, ULONG, PVOID);
typedef LONG (PRIVENTRY *PDEVFUN)(HVDM);


 /*
 ** NOTE: this list of registers MUST be kept in sync with aportWReg, as
 ** well as the format of the aawModeInit table (see vv8514.c)
 */

#define WREG_HORZTOTAL      0   /* private indexes into aportWReg             */
#define WREG_HORZDSP        1
#define WREG_HORZSSTART     2
#define WREG_HORZSWIDTH     3
#define WREG_VERTTOTAL      4
#define WREG_VERTDSP        5
#define WREG_VERTSSTART     6
#define WREG_VERTSWIDTH     7
#define WREG_DSPCTRL        8
#define WREG_SUBSYSCTRL     9
#define WREG_ROMPAGESELECT  10
#define WREG_ADVCTRL        11
#define WREG_COMMAND        12
#define WREG_CURRENTY       13
#define WREG_CURRENTX       14
#define WREG_DESTYAXSTP     15
#define WREG_DESTXDIASTP    16
#define WREG_ERRORTERM      17
#define WREG_MAJORAXISCNT   18
#define WREG_BGNDCOLOR      19
#define WREG_FGNDCOLOR      20
#define WREG_WRITEMASK      21
#define WREG_READMASK       22
#define WREG_COLORCOMPARE   23
#define WREG_BGNDMIX        24
#define WREG_FGNDMIX        25
#define WREG_SHORTSTROKE    26
#define WREG_PIXELTRANSFER  27
#define WREG_TOTAL          28

#define MFREG_MINORAXISCNT   (MFINDX_MINORAXISCNT   >> MFINDX_INDXSHIFT)
#define MFREG_TOPSCISSORS    (MFINDX_TOPSCISSORS    >> MFINDX_INDXSHIFT)
#define MFREG_LEFTSCISSORS   (MFINDX_LEFTSCISSORS   >> MFINDX_INDXSHIFT)
#define MFREG_BOTTOMSCISSORS (MFINDX_BOTTOMSCISSORS >> MFINDX_INDXSHIFT)
#define MFREG_RIGHTSCISSORS  (MFINDX_RIGHTSCISSORS  >> MFINDX_INDXSHIFT)
#define MFREG_MEMORYCTRL     (MFINDX_MEMORYCTRL     >> MFINDX_INDXSHIFT)
#define MFREG_PATTERNLOW     (MFINDX_PATTERNLOW     >> MFINDX_INDXSHIFT)
#define MFREG_PATTERNHIGH    (MFINDX_PATTERNHIGH    >> MFINDX_INDXSHIFT)
#define MFREG_PIXELCTRL      (MFINDX_PIXELCTRL      >> MFINDX_INDXSHIFT)


 /*
 ** DAC (Digital-to-Analog Color-lookup) states
 **
 ** These are the states that the DAC hardware on a VGA can be in.
 */

#define DAC_DATA0       0x0000  /* ready first 1st byte of data               */
#define DAC_DATA1       0x0001  /* ready first 2nd byte of data               */
#define DAC_DATA2       0x0002  /* ready first 3rd byte of data               */


 /*
 ** DAC color register structure
 **
 ** This structure contains the 3x6 bits (total of 18 bits) that make up
 ** the DAC information for one color register.
 */




typedef struct dac_s {          /* dac */
    BYTE  dac_bRed;
    BYTE  dac_bGreen;
    BYTE  dac_bBlue;
} DACREG;
typedef DACREG *PDACREG;        /* pdac */


typedef HVDHSEM HEVSEM;
typedef HVDHSEM HMXSEM;


//c-begin

#define CreateEventSem(phev) \
            VDHCreateSem(phev, VDH_EVENTSEM)
#define DestroyEventSem(hev) \
            VDHDestroySem(hev)
#define ResetEventSem(hev) \
            VDHResetEventSem(hev)
#define PostEventSem(hev) \
            VDHPostEventSem(hev)
#define WaitEventSem(hev) \
            VDHWaitEventSem(hev, SEM_INDEFINITE_WAIT)
#define CreateMutexSem(phmx) \
            VDHCreateSem(phmx, VDH_MUTEXSEM)
#define DestroyMutexSem(hmx) \
            VDHDestroySem(hmx)
#define RequestMutexSem(hmx) \
            VDHRequestMutexSem(hmx, SEM_INDEFINITE_WAIT)
#define ReleaseMutexSem(hmx) \
            VDHReleaseMutexSem(hmx)
//c-end


typedef struct vdmdata_s {      /* beginning of PERVDMDATA structure          */

 /*
 ** Per-VDM data
 */

BOOL    flVDM8514;              /* per-VDM flags (see VDM_* constants)        */

HVDM    hvdm8514;               /* handle for this VDM                        */
ULONG   sgID8514;               /* screen group # for this VDM                */

HMXSEM  hmx8514State;           /* semaphore for internal state               */
HEVSEM  hev8514WakeUp;          /* semaphore for bgnd sleeping/fgnd wakeup    */
HHOOK   hhookVDMContext;        /* hook handle for V8514VDMContext            */

PBYTE   pBuffer;                /* pointer to pixel save/restore buffer       */
INT     npgBuffer;              /* current size of the save/restore buffer    */
INT     npgBufferReq;           /* required size of the save/restore buffer   */
VVMODE  vvm8514;                /* mode data for 8514/A                       */

WORD    wreg8514MFIndx;         /* for interim settings (for byte I/O)        */
WORD    awreg8514Data[WREG_TOTAL];
WORD    awreg8514MFData[MFINDX_INDXTOTAL];

BYTE    regDACMask8514;         /* note that these byte registers are R/W     */
BYTE    regDACIndx8514;
DACREG  adacDACData8514[MAX_DACREGS];
DACREG  dacDACDataCur8514;      /* current DAC data register                  */
INT     stateDAC8514;           /* state of DAC                               */

} PERVDMDATA;                   /* end of PERVDMDATA structure                */

typedef PERVDMDATA *PVDMDATA;


//masm-begin
//DefData IMPORT,INSTANCE,C
//PERVDMDATA V8514Data
//VDMData catstr V8514Data
//EndData
//masm-end

//c-begin
#pragma BEGIN_SWAP_INSTANCE
extern  PERVDMDATA V8514Data;
#define VDMData V8514Data
#pragma END_SWAP_INSTANCE
//c-end


 /*
 ** Private function prototypes
 */


 /*
 ** vv8514.c
 */

BOOL    EXPENTRY  VDDInit(PSZ);
BOOL    EXPENTRY  V8514Create(HVDM);
VOID    EXPENTRY  V8514SetFgnd(HVDM);
VOID    EXPENTRY  V8514SetBgnd(HVDM);
VOID    EXPENTRY  V8514Destroy(HVDM);
VOID    HOOKENTRY V8514VDMContext(PVOID, PCRF);
#ifdef OLD_PROPERTIES
ULONG   EXPENTRY  V8514SetIOTrapping(ULONG, HVDM, ULONG, PSZ);
#endif
VOID    PRIVENTRY v8514SetIOHooks(VOID);
VOID    PRIVENTRY v8514UpdateScreenState(HVDM);
VOID    PRIVENTRY v8514UpdateInitialState(HVDM);                        /* @82093 */
VOID    PRIVENTRY v8514AddEvent(HVDM, INT, PVOID, FLAGS);
VOID    PRIVENTRY v8514DeleteEvent(HVDM, INT);
VOID    PRIVENTRY v8514RestoreIOState(HVDM);
VOID    PRIVENTRY v8514TransferBuffer(HVDM, BOOL);
VOID    PRIVENTRY v8514DisableDisplay(HVDM);
VOID    PRIVENTRY v8514EnableDisplay(HVDM);
BOOL    PRIVENTRY v8514GrowBuffer(HVDM);
VOID    PRIVENTRY v8514ShrinkBuffer(HVDM);
LONG    EXPENTRY  V8514SysReqProc(SGID, ULONG, ULONG, PVOID, ULONG, PVOID);
LONG    PRIVENTRY v8514SysQueryMode(HVDM, ULONG, PVOID, ULONG, PVVMODE);
LONG    PRIVENTRY v8514SysQueryCursor(HVDM, ULONG, PVOID, ULONG, PVVCURSOR);
LONG    PRIVENTRY v8514SysQueryPalette(HVDM, ULONG, PVOID, ULONG, PRGB);
LONG    PRIVENTRY v8514SysCopyLVB(HVDM, ULONG, PRECTL, ULONG, PBYTE);
LONG    PRIVENTRY v8514SysCopyBitmap(HVDM, ULONG, PVVRECT, ULONG, PBYTE);
LONG    EXPENTRY  V8514DevReqProc(HVDM, ULONG, PVOID, PVOID);
LONG    PRIVENTRY v8514DevWindowsDeskTop(HVDM, BOOL); /*                    */

VOID    PRIVENTRY v8514LockIO(HVDM);
VOID    PRIVENTRY v8514UnlockIO(HVDM);
BOOL    PRIVENTRY v8514EnterIO(ULONG, ULONG);
VOID    PRIVENTRY v8514ExitIO(VOID);
VOID    PRIVENTRY v8514CheckDisplayOwner(WORD);
BYTE    HOOKENTRY V8514ReadWRegByteL(ULONG, PCRF);
VOID    HOOKENTRY V8514WriteWRegByteL(BYTE, ULONG, PCRF);
BYTE    HOOKENTRY V8514ReadWRegByteH(ULONG, PCRF);
VOID    HOOKENTRY V8514WriteWRegByteH(BYTE, ULONG, PCRF);
WORD    HOOKENTRY V8514ReadWRegWord(ULONG, PCRF);
VOID    HOOKENTRY V8514WriteWRegWord(WORD, ULONG, PCRF);

BYTE    HOOKENTRY V8514ReadMFRegByteL(ULONG, PCRF);
VOID    HOOKENTRY V8514WriteMFRegByteL(BYTE, ULONG, PCRF);
BYTE    HOOKENTRY V8514ReadMFRegByteH(ULONG, PCRF);
VOID    HOOKENTRY V8514WriteMFRegByteH(BYTE, ULONG, PCRF);
WORD    HOOKENTRY V8514ReadMFRegWord(ULONG, PCRF);
VOID    HOOKENTRY V8514WriteMFRegWord(WORD, ULONG, PCRF);

BYTE    HOOKENTRY V8514ReadDACMask(ULONG, PCRF);
VOID    HOOKENTRY V8514WriteDACMask(BYTE, ULONG, PCRF);
BYTE    HOOKENTRY V8514ReadDACReadIndx(ULONG, PCRF);
VOID    HOOKENTRY V8514WriteDACReadIndx(BYTE, ULONG, PCRF);
BYTE    HOOKENTRY V8514ReadDACWriteIndx(ULONG, PCRF);
VOID    HOOKENTRY V8514WriteDACWriteIndx(BYTE, ULONG, PCRF);
BYTE    HOOKENTRY V8514ReadDACData(ULONG, PCRF);
VOID    HOOKENTRY V8514WriteDACData(BYTE, ULONG, PCRF);
VOID    PRIVENTRY v8514AdvanceDACReadState(VOID);
VOID    EXPENTRY  V8514Int2FHandler(HVDM, ULONG, PCRF);                 /*            */


 /*
 **  Random macro support
 **
 **  If VDDSTRICT is defined, the Assert macros generate appropriate code.
 **
 **  If VDDSTRICT is not defined, the Assert macros are NO-OPs (with the
 **  exception of AssertRC, in which case the function is still called, but
 **  the return code is not checked).
 **
 **  If VDDDEBUG is defined, debug printfs (PRINTDEBUGs) are generated, and
 **  failed assertions (assuming VDDSTRICT is defined) break at the assertion
 **  rather than in the kernel's "panic" service.  VDDDEBUG requires the
 **  kernel debugger, in other words.
 **
 **  If VDDDEBUG is not defined, debug printfs (PRINTDEBUGs) are NOT
 **  generated, and failed assertions (assuming VDDSTRICT is defined) simply
 **  panics.
 */

//masm-begin
//dword_s struc
//  lo dw ?
//  hi dw ?
//dword_s ends
//masm-end


#ifdef VDDSTRICT

//c-begin

extern CHAR szAssertMsg[];
#define MODNAME static CHAR szFile[]

#ifdef VDDDEBUG
#define Assert(t) { \
                    if (!(t)) { \
                      PRINTDEBUG(szAssertMsg, szFile, __LINE__); \
                      INT3(); \
                    } \
                  }
#else
#define Assert(t) { \
                    if (!(t)) { \
                      PANIC(szAssertMsg, szFile, __LINE__); \
                    } \
                  }
#endif

#define AssertTRUE(t)   Assert(t)
#define AssertFALSE(t)  Assert(!(t))
#define AssertZERO(t)   Assert(!(t))
#define AssertNONZERO(t)Assert(t)
#define AssertERROR()   Assert(FALSE)
#define AssertRC(t)     Assert(t)       /* verify function return code good   */

//c-end

//masm-begin
//?ASSERT macro   cond,msg,args
//        local   l1
//        ifnb    <cond>
//        j&cond  short l1
//        endif
//        ifdef   VDDDEBUG
//        DBPRINT <msg>,<args>
//        int 3
//        else
//        PANIC   <msg>,<args>
//        endif
//        ifnb    <cond>
//l1:
//        endif
//        endm
//masm-end

#else

//c-begin

#define Assert(t)
#define AssertTRUE(t)
#define AssertFALSE(t)
#define AssertZERO(t)
#define AssertNONZERO(t)
#define AssertERROR()
#define AssertRC(t)     (t)             /* perform function, but don't verify */

//c-end

//masm-begin
//?ASSERT macro cond,msg,args
//        endm
//masm-end
#endif

//masm-begin
//ASSERT   equ   <?ASSERT ,>
//ASSERTC  equ   <?ASSERT c,>
//ASSERTNC equ   <?ASSERT nc,>
//ASSERTZ  equ   <?ASSERT z,>
//ASSERTNZ equ   <?ASSERT nz,>
//ASSERTE  equ   <?ASSERT e,>
//ASSERTNE equ   <?ASSERT ne,>
//ASSERTB  equ   <?ASSERT b,>
//ASSERTBE equ   <?ASSERT be,>
//ASSERTA  equ   <?ASSERT a,>
//ASSERTAE equ   <?ASSERT ae,>
//masm-end


 /*
 ** Random debugging support
 */

#ifdef VDDDEBUG

//c-begin

extern CHAR szModule[];
extern CHAR *apszPageStates[];

#undef  PRINTDEBUG
#define PRINTDEBUG  printf(szModule); printf

/* Maybe someday... -JTP                                                      */
/* #undef  INB                                                                */
/* #define INB(p)      vvINB(p)                                               */
/* #undef  OUTB                                                               */
/* #define OUTB(p,b)   vvOUTB(p,b,NULL)                                       */
/* #undef  OUTW                                                               */
/* #define OUTW(p,w)   vvOUTW(p,w,NULL,NULL)                                  */

//c-end


//masm-begin
//DefData IMPORT,INSTANCE,C
//SZ szModule
//EndData
//
//DBPRINT macro msg,args
//        PRINTDEBUG <szModule>
//        PRINTDEBUG <msg>,<args>
//        endm
//masm-end

#else

//masm-begin
//DBPRINT macro msg,args
//        endm
//masm-end

#endif
