/**************************************************************************
 *
 * File Name    DBGDATA.CMD
 *
 * Descriptive Name  Debug Data Viewer
 *
 * Description  This REXX cmd file allows for easy viewing of the debug
 *              data gathered by the debug version of SWINVGA.DLL.  To
 *              use it, the debug data must be dumped via the debugger and
 *              stored in a separate file.  The debug command to obtain
 *              the data is:
 *
 *                              dd _vvdebuginfo l290
 *
 *              This data must be stored in a file with no leading or
 *              trailing blank lines and with the memory addresses intact,
 *              e.g.,
 *                      %1aea0020 0023 0231 0100 0000 0120 3312 0123 5123
 *                      %1aea0030 4768 5765 0000 0000 4565 4859 0001 0031
 *
 * Parameters   filename - name of file containing data, will prompt for if
 *                         missing
 *
 * Notes
 *
 *
 * Change Activity =
 *   Date      Flag        APAR   Change Description
 *   --------  ----------  -----  --------------------------------------
 *   11/17/93  jdn         75466  Created
 *
 ***********************************************************************/
trace o
arg fn

slot.0 = 'Waiting for semaphore'
slot.1 = 'vvRequestController'
slot.2 = 'vvFreeController'
slot.3 = 'vvLockController'
slot.4 = 'vvUnlockController'

call Get_Fn

call Get_Data

call Print_Data

exit


/************* routines *****************/


Get_Fn:

if fn = '' then do
   say 'Enter the file name containing the vv debug info'
   pull fn
   if fn = '' then exit
end
fn = strip(fn)

return


Get_Data:

do slot_i = 0 to 4
   do save_area = 1 to 2
      data.slot_i.save_area = ''
      do line_i = 1 to 8
         new_line = linein(fn)
         if new_line = '' then do
             say 'No more data from file' fn', slot #' slot_i 'area' save_area
             exit 1
         end
         parse var new_line addr b1 b2 b3 b4 .
         data.slot_i.save_area = data.slot_i.save_area || b1 || b2 || b3 || b4
      end
   end
end

return


Print_Data:

indent = 15
indent2 = 20

do i = 0 to 4
   say ' '
   say '********************************************************************'
   say 'Data for' slot.i
   say '********************************************************************'
   do j = 1 to 2
      say ' '
      say 'Save area' j
      say '-----------'
      parse value data.i.j with 1 eyecatcher 9 slotnum 17 pid 25 tid 33 time1     ,
           41 time2 49 hvdmc 57 flvvd 65 hvdmid 73 lockflag 81 vvdrqvideo 145 . ,
           151 ctrlown 153 . 159 ctrlnot 161 . 167 vdmmine 169 stack
      if eyecatcher = '214e444a'
         then text = 'JDN!'
         else
            if eyecatcher = '00000000'
               then text = '<none>'
               else text = '????'
      say left('Eyecatcher',indent) text
      say left('slot num',indent) slotnum
      say left('pid',indent) pid
      say left('tid',indent) tid
      say left('time',indent) time1 time2
      say left('hvdmController',indent) hvdmc
      say left('flVVD',indent) flvvd
      say left('hvdmID',indent) hvdmid
      say left('lock flag',indent) lockflag
      parse value vvdrqvideo with 1 vram 9 reser 17 latch 25 pflags 33 pctrlown ,
           41 pctrlnot 49 shadowreg 57 shadowdata 65 .
   /*   say left('vvdrqVideo',indent)  vvdrqVideo */
      say left('vvdrqVideo',indent) left('vvd_pPhysVRAM',indent2) vram
      say left(' ',indent) left('vvd_nbReserved',indent2) reser
      say left(' ',indent) left('vvd_offLatchByte',indent2) latch
      say left(' ',indent) left('vvd_pfbDRQFlags',indent2) pflags
      say left(' ',indent) left('vvd_pfCtrlOwned',indent2) pctrlown '('ctrlown')'
      pvdmmine = X2D(pctrlnot)
      if pvdmmine <> 0
         then do
            pvdmmine = pvdmmine + 4
            pvdmmine = D2X(pvdmmine)
         end
      pvdmmine = right(pvdmmine,8,'0')
      say left(' ',indent) left('vvd_pfVDMCtrlMine',indent2) pvdmmine '('vdmmine')'
      say left(' ',indent) left('vvd_pfCtrlNotify',indent2) pctrlnot '('ctrlnot')'
      say left(' ',indent) left('vvd_nShadowRegs',indent2) shadowreg
      say left(' ',indent) left('vvd_pShadowData',indent2) shadowdata
      do s = 1 to 11
         parse value stack with 1 word 9 stack
         if s = 1
         then say left('Stack contents',indent) word
         else say left(' ',indent) word
      end
    end
end

return
