;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = VTROUTER.ASM
;*
;* DESCRIPTIVE NAME = Function Router of Virtual Touch DD.
;*
;*
;* VERSION      V2.0
;*
;* DATE         07/16/91
;*
;* DESCRIPTION
;*              Facilitate routing of DOS Touch Device Driver calls made
;*              through the jump table to the Touch Virtual Device Driver.
;*              Calls through the jump table have input-output parameters
;*              on the stack. Calls passed to Virtual Driver are translated
;*              into
;*                  AX = Function number
;*                  DS:SI -> Input parameters
;*                  ES:DI -> Output parameters
;*
;* FUNCTIONS    _VTouchRouter,  _VTouchInt7fHandler,    VTouchInt74Handler,
;*              TouchInit,      TouchMsg.
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   03/01/91                     drw     Created.
;*   11/21/91                     drw     VMBoot additions. (TOUCHCOM)
;*   03/22/93              64395  Use Int 2f, not int 66 to call VDD.
;*****************************************************************************/

                        .386c

INT7FH_AX               EQU     0ABCDH
INT7FH_BX               EQU     0

ARPLCODE                EQU     063H                    ;ARPL Opcode
VDDINTERFACE            EQU     02fH                    ;VDD Interface Vector
TOUCHINT                EQU     07FH                    ;Touch Vector

RouterSeg               SEGMENT USE16 para public 'CODE'

                        PUBLIC  _VTouchBPAddress
                        PUBLIC  _VTouchNextInt7f
                        PUBLIC  _VTouchRouter
                        PUBLIC  _VTouchRouterBegin
                        PUBLIC  _VTouchRouterEnd
                        PUBLIC  _VTouchRouterTable
                        PUBLIC  _VTouchInt7fHandler

                        ASSUME  cs:RouterSeg, ds:nothing, ss:nothing

IFDEF   TOUCHCOM
                        ORG     100H
TouchBegin:             jmp     TouchInit               ; 

ELSE

TouchBegin:

ENDIF

_VTouchRouterBegin      LABEL   FAR

_VTouchBPAddress        dd      0ffff0000h              ; 
_VTouchNextInt7f        dd      0h                      ; 

;/***************************************************************************
;*
;* FUNCTION NAME = _VTouchRouter
;*
;* DESCRIPTION   =
;*
;*
;* INPUT         = AX    =  Function number
;*                 DS:SI -> Input parameters
;* OUTPUT        = ES:DI -> Output parameters
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

_VTouchRouter           PROC    FAR
                        pop     ax                      ;Get address we were
                        sub     ax, offset cs:Fn0+3     ; called from and make
                        shr     ax, 2                   ; it into a fn. number.
                        push    bp                      ; 
                        mov     bp, sp                  ; 
                        push    ds                      ;Save registers
                        push    si                      ;       "
                        push    es                      ;       "
                        push    di                      ;       "
                        les     di, [bp+06]             ;Output parameters
                        lds     si, [bp+10]             ;Input parameters
                        call    dword ptr cs:_VTouchBPAddress
                        pop     di                      ;Restore registers
                        pop     es                      ;       "
                        pop     si                      ;       "
                        pop     ds                      ;       "
                        leave                           ; 
                        retf    8                       ; 
_VTouchRouter           ENDP


;/***************************************************************************
;*
;* FUNCTION NAME = _VTouchInt7fHandler
;*
;* DESCRIPTION   = Interrupt 7FH intercept.
;*     If AX and BX match our codes:
;*            o Returns pointer to a Function Table in ES:BX,
;*                    if AX and BX match our function codes.
;*     If AX and BX not ours:
;*            o Check for non-zero chain address.
;*            o Chain to next handler or return with carry set.
;*
;*
;* INPUT         = AX, BX
;* OUTPUT        = ES:BX
;*
;* RETURN-NORMAL = Carry flag clear
;* RETURN-ERROR  = Carry flag set
;*
;**************************************************************************/

_VTouchInt7fHandler     PROC    FAR
                        push    bp
                        mov     bp, sp
                        cmp     ax, INT7FH_AX           ;Both AX and
                        jne     short int7f_notus       ;  BX must be
                        cmp     bx, INT7FH_BX           ;  satisfied.
                        ja      short int7f_notus       ;Not our interrupt
                        mov     bx, cs                  ; 
                        mov     es, bx                  ;Return ptr to table
                        mov     bx, offset _VTouchRouterTable
                        mov     ax, No_Functions        ; 
                        and     byte ptr [bp+6], 0FEH   ;clear carry flag
int7f_iret:             pop     bp
                        iret
int7f_notus:            cmp     word ptr cs:_VTouchNextInt7f[0], 0
                        jnz     short int7f_next        ; 
                        cmp     word ptr cs:_VTouchNextInt7f[2], 0
                        jnz     short int7f_next        ; 
                        or      byte ptr [bp+6], 01H    ;set carry flag
                        jmp     short int7f_iret        ; 
int7f_next:             pop     bp                      ; 
                        jmp     dword ptr cs:_VTouchNextInt7f
_VTouchInt7fHandler     ENDP


                        ALIGN 4
Fn0:                    call    NEAR PTR _VTouchRouter
                        ALIGN 4
Fn1:                    call    NEAR PTR _VTouchRouter
                        ALIGN 4
Fn2:                    call    NEAR PTR _VTouchRouter
                        ALIGN 4
Fn3:                    call    NEAR PTR _VTouchRouter
                        ALIGN 4
Fn4:                    call    NEAR PTR _VTouchRouter
                        ALIGN 4
Fn5:                    call    NEAR PTR _VTouchRouter
                        ALIGN 4
Fn6:                    call    NEAR PTR _VTouchRouter
                        ALIGN 4
Fn7:                    call    NEAR PTR _VTouchRouter
                        ALIGN 4
Fn8:                    call    NEAR PTR _VTouchRouter
                        ALIGN 4
Fn9:                    call    NEAR PTR _VTouchRouter
                        ALIGN 4
Fn10:                   call    NEAR PTR _VTouchRouter
                        ALIGN 4
Fn11:                   call    NEAR PTR _VTouchRouter
                        ALIGN 4
Fn12:                   call    NEAR PTR _VTouchRouter
                        ALIGN 4
Fn13:                   call    NEAR PTR _VTouchRouter
                        ALIGN 4
Fn14:                   call    NEAR PTR _VTouchRouter
                        ALIGN 4
Fn15:                   call    NEAR PTR _VTouchRouter
                        ALIGN 4
Fn16:                   call    NEAR PTR _VTouchRouter
                        ALIGN 4
Fn17:                   call    NEAR PTR _VTouchRouter
                        ALIGN 4
Fn18:                   call    NEAR PTR _VTouchRouter
                        ALIGN 4
Fn19:                   call    NEAR PTR _VTouchRouter
                        ALIGN 4
Fn20:                   call    NEAR PTR _VTouchRouter
                        ALIGN 4
Fn21:                   call    NEAR PTR _VTouchRouter
                        ALIGN 4
Fn22:                   call    NEAR PTR _VTouchRouter
                        ALIGN 4
Fn23:                   call    NEAR PTR _VTouchRouter
                        ALIGN 4
Fn24:                   call    NEAR PTR _VTouchRouter
                        ALIGN 4
Fn25:                   call    NEAR PTR _VTouchRouter
                        ALIGN 4
Fn26:                   call    NEAR PTR _VTouchRouter
                        ALIGN 4
Fn27:                   call    NEAR PTR _VTouchRouter
                        ALIGN 4
Fn28:                   call    NEAR PTR _VTouchRouter
                        ALIGN 4
Fn29:                   call    NEAR PTR _VTouchRouter
                        ALIGN 4
Fn30:                   call    NEAR PTR _VTouchRouter
                        ALIGN 4
Fn31:                   call    NEAR PTR _VTouchRouter

                        ALIGN 4                         ;Must always be
DldCalibConsts:         call    NEAR PTR _VTouchRouter  ;the last entry


;*
;* User jump table to Int 7fh functions.
;*

                        ALIGN 4
_VTouchRouterTable:     DW      Fn0             ;Installed Flag and Reset
                        DW      0               ;RouterSeg
                        DW      Fn1             ;Mouse Emulation Reset
                        DW      0               ;RouterSeg
                        DW      Fn2             ;Mouse Emulation ON/OFF
                        DW      0               ;RouterSeg
                        DW      Fn3             ;Set Co-Ordinate System
                        DW      0               ;RouterSeg
                        DW      Fn4             ;Set Co-Ordinate Origin
                        DW      0               ;RouterSeg
                        DW      Fn5             ;Set Thresholds
                        DW      0               ;RouterSeg
                        DW      Fn6             ;Set Selection Mechanism
                        DW      0               ;RouterSeg
                        DW      Fn7             ;Set Data Report Rate
                        DW      0               ;RouterSeg
                        DW      Fn8             ;Set Data Block Mask
                        DW      0               ;RouterSeg
                        DW      Fn9             ;Get Touch-Down Info
                        DW      0               ;RouterSeg
                        DW      Fn10            ;Get Lift-Off Info
                        DW      0               ;RouterSeg
                        DW      Fn11            ;Selection Turned-ON Info
                        DW      0               ;RouterSeg
                        DW      Fn12            ;Selection Turned-OFF Info
                        DW      0               ;RouterSeg
                        DW      Fn13            ;Get Current Position & Status
                        DW      0               ;RouterSeg
                        DW      Fn14            ;Set User-Defined Subroutine
                        DW      0               ;RouterSeg
                        DW      Fn15            ;Swap User-Defined Subroutine
                        DW      0               ;RouterSeg
                        DW      Fn16            ;DownLoad Filter Constants
                        DW      0               ;RouterSeg
                        DW      Fn17            ;Query Save State Storage
                        DW      0               ;RouterSeg
                        DW      Fn18            ;Save Driver State
                        DW      0               ;RouterSeg
                        DW      Fn19            ;Restore Driver State
                        DW      0               ;RouterSeg
                        DW      Fn20            ;Get Emul State
                        DW      0               ;RouterSeg
                        DW      Fn21            ;Get Emul On/Off
                        DW      0               ;RouterSeg
                        DW      Fn22            ;Get Co-Ordinate System
                        DW      0               ;RouterSeg
                        DW      Fn23            ;Get Co-Ordinate Origin
                        DW      0               ;RouterSeg
                        DW      Fn24            ;Get Thresholds
                        DW      0               ;RouterSeg
                        DW      Fn25            ;Get Selection Mechanism
                        DW      0               ;RouterSeg
                        DW      Fn26            ;Get Report Rate
                        DW      0               ;RouterSeg
                        DW      Fn27            ;Get Data Block Mask
                        DW      0               ;RouterSeg
                        DW      Fn28            ;Get Current Filter Type
                        DW      0               ;RouterSeg
                        DW      Fn29            ;Get Driver Info
                        DW      0               ;RouterSeg
                        DW      Fn30            ;Get Click Locking Parameters
                        DW      0               ;RouterSeg
                        DW      Fn31            ;Set Click Locking Parameters
                        DW      0               ;RouterSeg

No_Functions            EQU     ($-_VTouchRouterTable)/4
                        DW      DldCalibConsts  ;Download Calib Constants
                        DW      0               ;RouterSeg
                        DD      0               ;End Of Table Null Marker


IFDEF   TOUCHCOM

VTouchInt74BP           LABEL   DWORD                   ; 
VTouchInt74Off          dw      0                       ; 
VTouchInt74Seg          dw      0                       ; 

NextInt74               LABEL   DWORD                   ; 
NextInt74Off            dw      0                       ; 
NextInt74Seg            dw      0                       ; 


;/***************************************************************************
;*
;* FUNCTION NAME = VTouchInt74Handler
;*
;* DESCRIPTION   =
;*
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

VTouchInt74Handler      PROC    FAR
                        push    ax                      ; 
                        mov     ax, cs:VTouchInt74Off   ; 
                        or      ax, cs:VTouchInt74Seg   ; 
                        pop     ax                      ; 
                        jz      short CallNextInt74     ; 
                        pushf                           ; 
                        call    dword ptr cs:VTouchInt74BP
CallNextInt74:          push    ax                      ; 
                        mov     ax, cs:NextInt74Off     ; 
                        or      ax, cs:NextInt74Seg     ; 
                        pop     ax                      ; 
                        jz      short VTouchInt74Iret   ; 
                        jmp     dword ptr cs:NextInt74  ; 
VTouchInt74Iret:        iret                            ; 
VTouchInt74Handler      ENDP

ENDIF


_VTouchRouterEnd        LABEL   FAR

IFDEF   TOUCHCOM
                        .8086

VTName                  db      'VTOUCH$', 0
pfnVTOUCH               dd      0               ; entry to VTOUCH VDD


;/***************************************************************************
;*
;* FUNCTION NAME = TouchInit
;*
;* DESCRIPTION   =
;*
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

TouchInit               PROC    NEAR
                        mov     ax, cs                  ;set up segment regs
                        mov     ds, ax                  ; 
                        mov     es, ax                  ; 

;                       push    es                      ;
;                       xor     ax, ax                  ;
;                       mov     es, ax                  ;
;                       mov     di, VDDINTERFACE*4      ;
;                       les     di, dword ptr es:[di]   ;
;                       cmp     byte ptr es:[di], ARPLCODE
;                       pop     es                      ;
;                       jz      OS2Present              ;
                        mov     ax,4010h                            ;                               ;60491
                        int     VDDINTERFACE            ; OS/2?     ;           S/2
                        cmp     ax,4010h                            ;                               ;60491
                        jne     short OS2Present                    ;                               ;60491

OS2Missing:
                        mov     dx, offset cs:NoOS2Msg  ; 
                        call    TouchMsg                ; 
                        mov     ax, 4C02h               ;Needs OS/2
                        int     21h                     ;terminate with error

OS2Present:
                        mov     si, offset VTName       ;Determine VTOUCH
;                       xor     ax, ax                  ; Present
;                       int     VDDINTERFACE            ;
;                       jnc     VDDPresent              ;

                        xor     di,di                               ;          
                        push    es                                  ;          
                        mov     es,di                               ;          
                        mov     ax,04011h                           ;          
                        int     VDDINTERFACE                        ;          
                        mov     ax,es                               ;          
                        or      ax,di                               ;          
                        mov     ax,es   ; AX:DI = VTOUCH entry      ;          
                        pop     es                                  ;          
                        jnz     VDDPresent                          ;          

VDDMissing:
                        mov     dx, offset cs:NoVDDMsg  ; 
                        call    TouchMsg                ; 
                        mov     ax, 4C03h               ;Needs VTOUCH
                        int     21h                     ;terminate with error

VDDPresent:
                        mov     word ptr cs:[pfnVTOUCH],di              ;60491
                        mov     word ptr cs:[pfnVTOUCH+2],ax            ;60491
;                       mov     si, offset cs:VTName    ;Get Int74h BP Hook addr
                        mov     di, offset cs:VTouchInt74BP
                        mov     ax, 100h                ;(May not be int 74)
                        call    cs:[pfnVTOUCH]          ; call VTOUCH   ;60491
;                       int     VDDINTERFACE            ;Returns int no in AX
                        push    es                      ; 
                        mov     bx, ax                  ; 
                        shl     bx, 1                   ; 
                        shl     bx, 1                   ; 
                        xor     ax, ax                  ; 
                        mov     es, ax                  ; 
                        mov     word ptr es:[bx], offset cs:VTouchInt74Handler
                        mov     word ptr es:[bx+2], cs  ; 
                        pop     es

;                       mov     si, offset cs:VTName    ;Get Int7fh BP Hook addr
                        mov     di, offset cs:_VTouchBPAddress
                        mov     ax, 200h                ; 
                        call    cs:[pfnVTOUCH]          ; call VTOUCH   ;60491
;                       int     VDDINTERFACE            ;

                        push    es                      ; 
                        xor     ax, ax                  ; 
                        mov     es, ax                  ; 
                        mov     word ptr es:[TOUCHINT*4], \
                                offset cs:_VTouchInt7fHandler
                        mov     word ptr es:[TOUCHINT*4+2], cs
                        pop     es                      ; 

                                                        ;Fill in segment values
                        mov     di, offset cs:_VTouchRouterTable
                        mov     cx, No_Functions+1      ; 
                        mov     ax, cs                  ; 
@@:                     inc     di                      ;skip an offset
                        inc     di                      ; 
                        stosw                           ;store Router segment
                        loop    @B                      ;do more

                        mov     dx, offset cs:LoadedMsg ; 
                        call    TouchMsg                ; 

                        mov     dx, offset _VTouchRouterEnd
                        shr     dx, 1                   ; 
                        shr     dx, 1                   ; 
                        shr     dx, 1                   ; 
                        shr     dx, 1                   ; 
                        inc     dx                      ; 
                        mov     ax, 3100h               ; 
                        int     21h                     ; 

TouchInit               ENDP


;/***************************************************************************
;*
;* FUNCTION NAME = TouchMsg
;*
;* DESCRIPTION   = ds:dx point to message to print
;*
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

TouchMsg                PROC    NEAR
                        push    ax
                        mov     ah, 9                   ; 
                        int     21h                     ; 
                        pop     ax
                        ret
TouchMsg                ENDP

LoadedMsg               DB      'VTOUCH Loaded', 0dh, 0ah, '$'
NoOS2Msg                DB      'Needs OS/2', 0dh, 0ah, '$'
NoVDDMsg                DB      'Needs VTOUCH', 0dh, 0ah, '$'

ENDIF

RouterSeg               ENDS

IFNDEF  TOUCHCOM
                        INCLUDE touchend.inc
ENDIF
                                                        ;This point only reached
                        END     TouchBegin              ;if TOUCHCOM is defined.
