/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = VTINIT.C
 *
 * DESCRIPTIVE NAME = Virtual Touch Device Driver Initialization
 *
 *
 * VERSION = V2.0
 *
 * DATE        02/17/92
 *
 * DESCRIPTION
 *             This module contains the VTD's initialization code.
 *
 * FUNCTIONS   VDDInit.
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#include "vtdef.h"

/*
** External References
*/

extern FPFNPDD        fpfnPTDRequestProc;
extern HIRQ           hirq;
extern TOUDEVICESTATE touDeviceState;
extern PSZ            pszExclusiveTouch;

#pragma  BEGIN_INIT_CODE


/****************************************************************************
 *
 * FUNCTION NAME = VDDInit
 *
 * DESCRIPTION   = VTD initialization
 *                 This routine is defined as the device driver entry point,
 *                 and is called during system initialization (aka VDD-init
 *                 time).
 *   USES        - 32-bit small-model PASCAL calling/register conventions
 *   CONTEXT     - System initialization ie. VDD-init time
 *   PSEUDO-CODE -
 *      verify existence of PDD (open it)
 *      install user hooks; create, fgnd, bkgnd
 *      get hardware setup from PDD
 *      open VIRQ for shared/not
 *      register properties
 *      Register System & Device Request entry points
 *
 *
 * INPUT         = PSZ psz
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = TRUE
 * RETURN-ERROR  = FALSE (ie, hardware missing)
 *
 ****************************************************************************/

BOOL EXPENTRY VDDInit( PSZ psz )
{
  BOOL rc = FALSE;

  if( fpfnPTDRequestProc = VDHOpenPDD( PTD_NAME, VTEventProc ) )
  {
    VDHInstallUserHook( VDM_CREATE, (PUSERHOOK)VTCreate );
    VDHInstallUserHook( VDM_TERMINATE, (PUSERHOOK)VTDestroy );
    VDHInstallUserHook( VDM_FOREGROUND, (PUSERHOOK)VTSetFgnd );
    VDHInstallUserHook( VDM_BACKGROUND, (PUSERHOOK)VTSetBgnd );
    if( (*fpfnPTDRequestProc)( PTDREQ_QUERYDEVICESTATE,
                               NULL,
                               F16PFROMP( &touDeviceState ) ) )
    {
      if( hirq = VDHOpenVIRQ( touDeviceState.irq,
                              VPIC_NOEOIHOOK,
                              VPIC_NOIRETHOOK,
                              VPIC_NOIRETHOOK_TIMEOUT,
                              VPIC_SHARE_IRQ ) )
      {
        if( VDHRegisterProperty( pszExclusiveTouch, /* Property string        */
                                 NULL,              /* help file              */
                                 0,                 /* help id                */
                                 VDMP_BOOL,         /* property type (on/off) */
                                 VDMP_ORD_OTHER,    /* custom VDD property    */
                                 0,                 /* modifiable after creation */
                                 (PVOID)FALSE,      /* default value          */
                                 NULL,              /* validation info        */
                                 VTExclusiveTouch ) )  /* function to call    */
        {
          rc = TRUE;
          VDHRegisterVDD( VTD_NAME, VTDosReqProc, VTVddReqProc );
        }
      }
      else
        Assert( !(*fpfnPTDRequestProc)( PTDREQ_DEREGISTER, NULL, NULL ) );
    }
    else
      Assert( TRUE );
  }
  return ( rc );
}

#pragma  END_INIT_CODE
