/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = VTDPTD.H
 *
 * DESCRIPTIVE NAME = Touch VDD/PDD shared structures/constants
 *
 *
 * VERSION = V2.0
 *
 * DATE        07/16/91
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define PTD_NAME                "TOUCH$"     /* registered name of PDD       */
#define VTD_NAME                "VTOUCH$"    /*                    VDD       */
#define VMD_NAME                "VMOUSE$"    /*                    VMD       */

#define PTDREQ_QUERYDEVICESTATE 1            /* get hardware configuration   */
#define PTDREQ_SETEMULSTATE     2            /* set emulation on/off         */
#define PTDREQ_DEREGISTER       3            /* tell PDD couldn't load       */
#define PTDREQ_EXCLUSIVEACCESS  4            /* give a window excl access    */

#define MOUSTATE_REALMOUSE      0x01         /* set if is a real mouse       */
#define MOUSTATE_EMULALLOWED    0x08         /* set if emul allowed          */
#define MOUSTATE_BEEPALLOWED    0x10         /* set if beep allowed          */
#define TOUSTATE_CALIBRATED     0x01         /* set if calibrated            */
/* end */

/*
** VTD-to-PTD communication structures
*/

typedef struct                               /* PTDREQ_QUERYDEVICESTATE      */
{
  WORD         cb;                           /* byte count                   */
  BYTE         irq;                          /* hardware IRQ for touch data  */
  USHORT       fMouState;                    /* MOUSTATE_* bit field above   */
  USHORT       fTouState;                    /* TOUSTATE_*  "    "     "     */
} TOUDEVICESTATE, *PTOUDEVICESTATE;

typedef struct                               /* PTDREQ_SETEMULSTATE          */
{
  WORD         cb;                           /* byte count                   */
  BYTE         fEmulState;                   /* Emulation type/state         */
} TOUEMULSTATE, * PTOUEMULSTATE;

typedef struct                               /* PTDREQ_EXCLUSIVEACCESS       */
{
  WORD         cb;                           /* byte count                   */
  BYTE         fExclAccess;                  /* BOOL for state               */
} TOUEXCLACCESS, * PTOUEXCLACCESS;
/* end */

#define VTDCMD_REPORT_EVENT     1            /* Event available              */

/*
** Event packet flags
*/

#define STATUS_OFF_SCREEN       0x00
#define STATUS_LIFT_OFF         0x01
#define STATUS_TOUCH_DOWN       0x02
#define STATUS_ON_SCREEN        (STATUS_LIFT_OFF | STATUS_TOUCH_DOWN)
#define STATUS_SELECT_DETECTED  0x04
#define STATUS_CHANNEL_PEGGED   0x10
/* end */

/*
** PTD-to-VTD communication structures
*/

typedef struct                               /* VTDCMD_REPORT_EVENT          */
{
  USHORT       Status;
  ULONG        TimeStamp;
  USHORT       x;
  USHORT       y;
  USHORT       z;
} QEVENT, *PQEVENT, **PPQEVENT;

typedef struct
{
  USHORT       SGId;
  QEVENT       QEvent;
} MONREC, *PMONREC;
/* end */
