/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = VTDOSREQ.C
 *
 * DESCRIPTIVE NAME = Virtual Touch Device Driver System (OS/2) Requests
 *
 *
 * VERSION = V2.0
 *
 * DATE        07/16/91
 *
 * DESCRIPTION
 *             This module contains the VTD's OS/2 entry point for use by
 *             applications via DosOpenVDD/DosRequestVDD.
 *
 * FUNCTIONS   VTDosReqProc,     vtDosSetFocus,    vtDosPostTouch.
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#include "vtdef.h"

/*
** Externals
*/

extern PFNVTDOSREQ apfnDosReq[];
extern BOOL fTouchEnabled;
extern ULONG ulSstate;

#pragma  BEGIN_SWAP_CODE


/****************************************************************************
 *
 * FUNCTION NAME = VTDosReqProc
 *
 * DESCRIPTION   = DosRequestVDD function dispatcher.
 *
 *     pfnDosReq - function for use by DosRequestVDD,
 *                 RETCODE pfnDosReq(SgId, ulCmd, cbIn, pReqIn, cbOut, pReqOut)
 *   PSEUDO-CODE - NONE
 *
 *
 * INPUT         = SGID    SGid    - Screen group id
 *                 ULONG   ulCmd   - Command
 *                 ULONG   cbIn    - Input buffer size (0 if none)
 *                 PVOID   pReqIn  - Input packet
 *                 ULONG   cbOut   - Output buffer size (0 if none)
 *                 PVOID   pReqOut - output packet
 * OUTPUT        = VDDREQ_PASS - VDM manager will call the next routine
 *                               registered under same name.
 *                 TRUE        - return failure (For APIs 0 is success)
 *                 FALSE       - return the caller success
 *
 *
 * RETURN-NORMAL = Zero
 * RETURN-ERROR  = Error code
 *
 ****************************************************************************/

RETCODE EXPENTRY VTDosReqProc( SGID SgId, ULONG ulCmd, ULONG cbIn, PVOID pReqIn,
                               ULONG cbOut, PVOID pReqOut )
{
  HVDM hvdm;

  if( !( hvdm = VDHHandleFromSGID( SgId ) ) )
    return( ERROR_INVALID_SGID );
  if( ulCmd < VTDOSREQ_MAX )
    return( ( *apfnDosReq[ulCmd] )( hvdm, cbIn, pReqIn, cbOut, pReqOut ) );
  else
    return( ERROR_INVALID_PARAMETER );
}


/****************************************************************************
 *
 * FUNCTION NAME = vtDosSetFocus
 *
 * DESCRIPTION   = Set Foreground/Background focus.
 *   PSEUDO-CODE - NONE
 *
 *
 * INPUT         = hvdm    - VDM handle
 *                 cbIn    - 0, set background
 *                           1, set foreground
 *                 pReqIn  - not used
 *                 cbOut   - not used
 *                 pReqOut - not used
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = ERROR_NONE
 * RETURN-ERROR  = Error code
 *
 ****************************************************************************/

LONG PRIVENTRY vtDosSetFocus( HVDM hvdm, ULONG cbIn, PVOID pReqIn, ULONG cbOut,
                              PVOID pReqOut )
{
  if( cbIn )
    REFHVDM( hvdm, ULONG, ulSstate ) |= SESSION_FOREGROUND;
  else
    REFHVDM( hvdm, ULONG, ulSstate ) &= ~SESSION_FOREGROUND;
  return( ERROR_NONE );
}


/****************************************************************************
 *
 * FUNCTION NAME = vtDosPostTouch
 *
 * DESCRIPTION   = Post a Touch event to a VDM.
 *   PSEUDO-CODE - NONE
 *
 *
 * INPUT         = hvdm    - VDM handle
 *                 cbIn    - byte count (size of input packet)
 *                 pReqIn  -> 0:32 address of structure as defined by MONREC
 *                 cbOut   - not used
 *                 pReqOut - not used
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = ERROR_NONE
 * RETURN-ERROR  = Error code
 *
 ****************************************************************************/

LONG PRIVENTRY vtDosPostTouch( HVDM hvdm, ULONG cbIn, PVOID pReqIn, ULONG cbOut,
                               PVOID pReqOut )
{
  if( cbIn == sizeof( MONREC ) ) {
    if( REFHVDM( hvdm, BOOL, fTouchEnabled ) ) {
      vtAddEvent( hvdm, ( &( (PMONREC)pReqIn )->QEvent ) );
      return( ERROR_NONE );
    }
    else
      return  ERROR_NOT_ENABLED;
  }
  else
    return  ERROR_INVALID_PARAMETER;
}

#pragma  END_SWAP_CODE
