/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = VTD.H
 *
 * DESCRIPTIVE NAME = MVDM Virtual Touch Exported Definitions
 *
 *
 * VERSION = V2.0
 *
 * DATE        07/16/91
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#ifndef INCL_NONE
#define INCL_VTOUCH
#endif

#ifdef  INCL_VTOUCH
#define INCL_VTOUCHINT
#define INCL_VTOUCHSYSREQ
#define INCL_VTOUCHDEVREQ
#endif

#ifdef  INCL_VTOUCHINT
/*
** VTD INT 7fh constants
*/

#define VTOUCH_INT              0x7f    /* Touch software interrupt no        */
#define VTOUCH_INT_AX           0xABCD  /* AX & BX register values to         */
#define VTOUCH_INT_BX           0x0000  /* get the jump table address.        */
#endif

#ifdef  INCL_VTOUCHSYSREQ
/*
** VTOUCH constants
*/

#define VTD_NAME "VTOUCH$"              /* name of VTD                        */

/*
** VTOUCH functions for use by PMVDMP
*/

#define VTOUCHSYSREQ_SETACCESS  1       /* obtain exclusive access for VDM    */
#define VTOUCHSYSREQ_SETFOCUS   2       /* notify VDM is gaining/losing focus */
#define VTOUCHSYSREQ_POSTTOUCH  3       /* send touch events to a VDM         */
#define VTOUCHSYSREQ_MAX        3
#endif

#ifdef  INCL_VTOUCHDEVREQ

/*
** EK+ VTD constants
*/

#define VTDEVREQ_REGISTER       1       /* VTD-defined functions for          */
#define VTDEVREQ_SETSIZE        2       /* communication from VVD to VTD      */
/* end */

/*
** ET+ VTD VDHRequestVDD communication structures
**
** VMSSIZE is the input packet passed with the VTDEVREQ_SETSIZE request
** from a VVD, and defines the current video mode (or -1 if unknown),
** physical screen dimensions, and cell size.  There is no output packet
** for this request.
*/

typedef struct vmss_s            /* vmss                                      */
{
  ULONG  vmss_nb;                /* size of structure, in bytes (36)          */
  LONG   vmss_lMode;             /* video mode (eg, 00h-13h, or -1)           */
  ULONG  vmss_ulWidth;           /* width of screen, in pixels                */
  ULONG  vmss_ulHeight;          /* height of screen, in pixels               */
  ULONG  vmss_ulCellWidth;       /* width of screen cells, in pixels          */
  ULONG  vmss_ulCellHeight;      /* height of screen cells, in pixels         */
  ULONG  vmss_ulPtrWidth;        /* width of pointer drawing size, in pixels  */
  ULONG  vmss_ulPtrHeight;       /* height of pointer drawing size, in pixels */
  ULONG  vmss_ulPtrUnitWidth;    /* width of pointer drawing unit, in pixels  */
} VMSSIZE, *PVMSSIZE;
/* end */

#endif                           /* INCL_VTOUCHDEVREQ                         */
