/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**************************************************************************
 *
 * SOURCE FILE NAME = VMRESET.C
 *
 * DESCRIPTIVE NAME = Virtual Mouse Device Driver Int 33h Reset Services
 *
 *
 * VERSION =  V2.0
 *
 * DATE       05/28/90
 *
 * DESCRIPTION This module contains the VMD's Int 33h reset services.
 *
 *
 * FUNCTIONS
 *
 *   vmInt33Reset()          Int 33h Reset (function 0)
 *   vmInt33SoftwareReset()  Int 33h Software Reset (function 33)
 *   vmSoftReset()           Soft mouse reset (ie, reinitialize the interface)
 *
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/
#include "vmdp.h"

#ifdef   VDDSTRICT
MODNAME = __FILE__;
#endif

/*
**    External References
*/

extern MHARDWARE mhwInstalled;
extern BOOL fMouseEnabled;

#pragma  BEGIN_SWAP_CODE

 /***************************************************************************
 *
 *  FUNCTION NAME :  vmInt33Reset()
 *
 *  DESCRIPTION   :  Int 33h Reset (function 0)
 *
 *  INPUT    :
 *               pcrf -> VDM register frame
 *  OUTPUT   :
 *               EMULATED
 *                   TRUE
 *               NOT EMULATED
 *                   FALSE (pass control to next VDD and/or ROM)
 *  USES     :
 *               32-bit small-model PASCAL calling/register conventions
 *
 *  CONTEXT  :
 *               VDM Task-time
 *
 *  PSEUDO-CODE                                     REFERENCES
 *      do a software reset;
 *
 ***************************************************************************/

BOOL PRIVENTRY vmInt33Reset(register PCRF pcrf)
{
  return (vmInt33SoftwareReset(pcrf));
}                                      /* vmInt33Reset                       */

 /***************************************************************************
 *
 *  FUNCTION NAME :  vmInt33SoftwareReset()
 *
 *  DESCRIPTION   :  Int 33h Software Reset (function 33)
 *
 *  INPUT    :
 *                 pcrf -> VDM register frame
 *  OUTPUT   :
 *               EMULATED
 *                   TRUE
 *               NOT EMULATED
 *                   FALSE (pass control to next VDD and/or ROM)
 *  USES     :
 *               32-bit small-model PASCAL calling/register conventions
 *
 *  CONTEXT  :
 *               VDM Task-time
 *
 *
 *
 *  PSEUDO-CODE                                     REFERENCES
 *      do a software reset;
 *      return mouse state and button states to VDM;
 *
 ****************************************************************************/

BOOL PRIVENTRY vmInt33SoftwareReset(register PCRF pcrf)
{
  vmSoftReset(CURRENT_VDM);

    /*
    ** Set up the return values
    */

  if (fMouseEnabled)
  {
    AX(pcrf) = MOUSE_INSTALLED;
    BX(pcrf) = mhwInstalled.mhw_nButtons;
  }
  return  TRUE;
}                                      /* vmInt33SoftwareReset               */

 /***************************************************************************
 *
 *  FUNCTION NAME :  vmSoftReset()
 *
 *  DESCRIPTION   :  Soft mouse reset (ie, reinitialize the interface)
 *
 *  INPUT    :
 *              hvdm -> VDM
 *  OUTPUT   :
 *              None
 *  USES     :
 *              32-bit small-model PASCAL calling/register conventions
 *
 *  CONTEXT  :
 *              VDM Task-time
 *
 *  PSEUDO-CODE                                     REFERENCES
 *      if mouse pointer is not hidden
 *          hide it;
 *      reset to default software pointer;
 *      reset screen boundaries;
 *      reset condition-off rectangle;
 *      reset user sub. call mask;
 *      reset motion counts;
 *      reset button states;
 *      reset button info. states;
 *      reset text mask;
 *      enable light pen emulation;
 *      reset threshold to default;
 *      reset scale factor to default;
 *      reset mouse pointer to the middle of the screen;
 *
 **************************************************************************/

VOID PRIVENTRY vmSoftReset(HVDM hvdm)
{
  register PVDMDATA pvd = pVDMData(hvdm);
  if ( !pvd->mstates.fPtrHidden )
    vmHidePointer(hvdm);

  pvd->mstates.fPtrHidden = PTR_HIDDEN;
  pvd->mstates.fHWPtr = FALSE;

    /*
    ** Reset bounds to screen boundaries
    */

  pvd->mstates.xMin = pvd->mstates.yMin = 0;
  pvd->mstates.xMax = pvd->vmss.vmss_ulWidth-1;
  pvd->mstates.yMax = pvd->vmss.vmss_ulHeight-1;

    /*
    ** Reset conditional-off
    */

  pvd->mstates.fOffEnable = FALSE;
  pvd->mstates.subinfo[SUB_NORMAL].si_flCallMask = 0;
  pvd->mstates.nxMics = 0;

  pvd->mstates.nyMics = 0;
  pvd->flButtons = 0;

  memset(&pvd->mstates.butinfo, 0, sizeof(pvd->mstates.butinfo));

  vmResetMasks(hvdm, TRUE);
  vmSetLightPen(hvdm, TRUE);

  vmSetThreshold(DEF_THRESHOLD);
  vmSetScaleFactor(DEF_XMICKEYS, DEF_YMICKEYS);

  vmSetPosition(hvdm, pvd->vmss.vmss_ulWidth/2,
                      pvd->vmss.vmss_ulHeight/2,
                      TRUE );
}                                      /* vmSoftReset */

#pragma  END_SWAP_CODE
