/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**************************************************************************
 *
 * SOURCE FILE NAME = VMMISC.C
 *
 * DESCRIPTIVE NAME = Virtual Mouse Device Driver Int 33h Miscellaneous Services
 *
 *
 * VERSION =  V2.0
 *
 * DATE       11/19/90
 *
 * DESCRIPTION This module contains the VMD's Int 33h miscellaneous services.
 *
 *
 * FUNCTIONS
 *    vmInt33SetLanguage()          Int 33h Set Language # (function 34)
 *    vmInt33QueryLanguage()        Int 33h Query Language # (function 35)
 *    vmInt33QueryMouseVersion()    Int 33h Query Mouse Version (function 36)
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/
#include "vmdp.h"

#ifdef   VDDSTRICT
MODNAME = __FILE__;
#endif

/*
**    External References
*/

extern MHARDWARE mhwInstalled;
#pragma  BEGIN_SWAP_CODE

 /**************************************************************************
 *
 *  FUNCTION NAME : vmInt33SetLanguage()
 *
 *  DESCRIPTION   : Int 33h Set Language # (function 34)
 *
 *  INPUT         :
 *                  pcrf -> VDM register frame
 *  OUTPUT        :
 *                  EMULATED
 *                      TRUE
 *                  NOT EMULATED
 *                :      FALSE (pass control to next VDD and/or ROM)
 *  USES
 *                   32-bit small-model PASCAL calling/register conventions
 *
 *  CONTEXT       :
 *                   VDM Task-time
 *
 *  PSEUDO-CODE   :                                  REFERENCES
 *      store language number;
 ****************************************************************************/

BOOL PRIVENTRY vmInt33SetLanguage(register PCRF pcrf)
{
  /*
  ** This is specific to the DOS driver and is faked.
  */

  VDMData.mstates.ulLanguage = (ULONG)BX(pcrf);
  return  TRUE;
}                                      /* vmInt33SetLanguage                 */

 /**************************************************************************
 *
 * FUNCTION NAME  : vmInt33QueryLanguage()
 *
 * DESCRIPTION    : Int 33h Query Language # (function 35)
 *
 * INPUT          :
 *                  pcrf -> VDM register frame
 *  OUTPUT        :
 *                  EMULATED
 *                      TRUE
 *                  NOT EMULATED
 *                      FALSE (pass control to next VDD and/or ROM)
 *  USES          :
 *                  32-bit small-model PASCAL calling/register conventions
 *
 *  CONTEXT       :
 *                    VDM Task-time
 *
 *  PSEUDO-CODE                                     REFERENCES
 *      set VDM BX to language number;
 ***************************************************************************/

BOOL PRIVENTRY vmInt33QueryLanguage(register PCRF pcrf)
{
  /*
  ** This is specific to the MS driver and is faked.
  */

  BX(pcrf) = (WORD)VDMData.mstates.ulLanguage;
  return  TRUE;
}                                      /* vmInt33QueryLanguage               */

 /**************************************************************************
 *
 *  FUNCTION NAME : vmInt33QueryMouseVersion()
 *
 *  DESCRIPTION   : Int 33h Query Mouse Version (function 36)
 *
 *  INPUT         :
 *                  pcrf -> VDM register frame
 *  OUTPUT        :
 *                      EMULATED
 *                          TRUE
 *                      NOT EMULATED
 *                          FALSE (pass control to next VDD and/or ROM)
 *  USES          :
 *                   32-bit small-model PASCAL calling/register conventions
 *
 *  CONTEXT       :
 *                     VDM Task-time
 *
 *  PSEUDO-CODE                                     REFERENCES
 *      set VDM BX to mouse version;
 *      set VDM CH to mouse type;
 *      set VDM CL to mouse IRQ;
 **************************************************************************/

BOOL PRIVENTRY vmInt33QueryMouseVersion(register PCRF pcrf)
{
  BX(pcrf) = MOUSE_VERSION;
  CH(pcrf) = mhwInstalled.mhw_uType;
  CL(pcrf) = mhwInstalled.mhw_irq;
  return  TRUE;
}                                      /* vmInt33QueryMouseVersion           */

 /**************************************************************************
 *
 *  FUNCTION NAME : vmInt33GetGeneralInfo()
 *
 *  DESCRIPTION   : Int 33h Get general driver info (function 37)
 *
 *  INPUT         :
 *                  pcrf -> VDM register frame
 *  OUTPUT        :
 *                      EMULATED
 *                          TRUE
 *                      NOT EMULATED
 *                          FALSE (pass control to next VDD and/or ROM)
 *  USES          :
 *                   32-bit small-model PASCAL calling/register conventions
 *
 *  CONTEXT       :
 *                     VDM Task-time
 *
 **************************************************************************/

BOOL PRIVENTRY
vmInt33GetGeneralInfo(register PCRF pcrf)
{
     AX(pcrf)=0x8000;              /* general info bits                    */
     BX(pcrf)=0;                   /* fCursorLock                          */
     CX(pcrf)=0;                   /* fInMouseCode                         */
     DX(pcrf)=0;                   /* fMouseBusy                           */
     return(TRUE);
}

 /**************************************************************************
 *
 *  FUNCTION NAME : vmInt33GetMaxVirtual()
 *
 *  DESCRIPTION   : Int 33h Get maximum virtual coordinates (function 38)
 *
 *  INPUT         :
 *                  pcrf -> VDM register frame
 *  OUTPUT        :
 *                      EMULATED
 *                          TRUE
 *                      NOT EMULATED
 *                          FALSE (pass control to next VDD and/or ROM)
 *  USES          :
 *                   32-bit small-model PASCAL calling/register conventions
 *
 *  CONTEXT       :
 *                     VDM Task-time
 *
 **************************************************************************/

BOOL PRIVENTRY
vmInt33GetMaxVirtual(register PCRF pcrf)
{
     BX(pcrf)=0;                        /* fMouseDisabled                  */
     CX(pcrf)=VDMData.mstates.xMax;     /* Maximum X coordinate            */
     DX(pcrf)=VDMData.mstates.yMax;     /* Maximum Y coordinate            */
     return(TRUE);
}

 /**************************************************************************
 *
 *  FUNCTION NAME : vmInt33GetMaskMickey()
 *
 *  DESCRIPTION   : Int 33h Get masks and mickey counts (function 39)
 *
 *  INPUT         :
 *                  pcrf -> VDM register frame
 *  OUTPUT        :
 *                      EMULATED
 *                          TRUE
 *                      NOT EMULATED
 *                          FALSE (pass control to next VDD and/or ROM)
 *  USES          :
 *                   32-bit small-model PASCAL calling/register conventions
 *
 *  CONTEXT       :
 *                     VDM Task-time
 *
 **************************************************************************/

BOOL PRIVENTRY
vmInt33GetMaskMickey(register PCRF pcrf)
{
     AX(pcrf)=VDMData.mstates.ulTextANDMask;
     BX(pcrf)=VDMData.mstates.ulTextXORMask;
     CX(pcrf)=VDMData.mstates.nxMics;
     DX(pcrf)=VDMData.mstates.nyMics;
     return(TRUE);
}

 /**************************************************************************
 *
 *  FUNCTION NAME : vmInt33GetHotSpot()
 *
 *  DESCRIPTION   : Int 33h Get cursor hot spot (function 42)
 *
 *  INPUT         :
 *                  pcrf -> VDM register frame
 *  OUTPUT        :
 *                      EMULATED
 *                          TRUE
 *                      NOT EMULATED
 *                          FALSE (pass control to next VDD and/or ROM)
 *  USES          :
 *                   32-bit small-model PASCAL calling/register conventions
 *
 *  CONTEXT       :
 *                     VDM Task-time
 *
 **************************************************************************/

BOOL PRIVENTRY
vmInt33GetHotSpot(register PCRF pcrf)
{
     AX(pcrf)=VDMData.mstates.fPtrHidden;         /* fCursor               */
     BX(pcrf)=VDMData.mstates.xHot;
     CX(pcrf)=VDMData.mstates.yHot;
     DX(pcrf)=mhwInstalled.mhw_uType;             /* mouse type            */
     return(TRUE);
}

 /**************************************************************************
 *
 *  FUNCTION NAME : vmInt33HdwReset()
 *
 *  DESCRIPTION   : Int 33h Hardware Reset (function 47)
 *
 *  INPUT         :
 *                  pcrf -> VDM register frame
 *  OUTPUT        :
 *                      EMULATED
 *                          TRUE
 *                      NOT EMULATED
 *                          FALSE (pass control to next VDD and/or ROM)
 *  USES          :
 *                   32-bit small-model PASCAL calling/register conventions
 *
 *  CONTEXT       :
 *                     VDM Task-time
 *
 **************************************************************************/

BOOL PRIVENTRY
vmInt33HdwReset(register PCRF pcrf)
{
     AX(pcrf)=0xFFFF;
     return(TRUE);
}

 /**************************************************************************
 *
 *  FUNCTION NAME : vmInt33GetMinMax()
 *
 *  DESCRIPTION   : Int 33h Get mimimum/maximum virtual (function 49)
 *
 *  INPUT         :
 *                  pcrf -> VDM register frame
 *  OUTPUT        :
 *                      EMULATED
 *                          TRUE
 *                      NOT EMULATED
 *                          FALSE (pass control to next VDD and/or ROM)
 *  USES          :
 *                   32-bit small-model PASCAL calling/register conventions
 *
 *  CONTEXT       :
 *                     VDM Task-time
 *
 **************************************************************************/

BOOL PRIVENTRY
vmInt33GetMinMax(register PCRF pcrf)
{
     AX(pcrf)=VDMData.mstates.xMin;          /* Minimum X coordinate       */
     BX(pcrf)=VDMData.mstates.yMin;          /* Minimum Y coordinate       */
     CX(pcrf)=VDMData.mstates.xMax;          /* Maximum X coordinate       */
     DX(pcrf)=VDMData.mstates.yMax;          /* Maximum Y coordinate       */
     return(TRUE);
}

 /**************************************************************************
 *
 *  FUNCTION NAME : vmInt33GetAdvanced()
 *
 *  DESCRIPTION   : Int 33h Get active advanced functions (function 50)
 *
 *  INPUT         :
 *                  pcrf -> VDM register frame
 *  OUTPUT        :
 *                      EMULATED
 *                          TRUE
 *                      NOT EMULATED
 *                          FALSE (pass control to next VDD and/or ROM)
 *  USES          :
 *                   32-bit small-model PASCAL calling/register conventions
 *
 *  CONTEXT       :
 *                     VDM Task-time
 *
 **************************************************************************/

BOOL PRIVENTRY
vmInt33GetAdvanced(register PCRF pcrf)
{
/* Returns bitmap, where: bit 15 indicates function 37 support * (*=supported)
                          bit 14 indicates function 38 support *
                          bit 13 indicates function 39 support *
                          bit 12 indicates function 40 support   set video mode

                          bit 11 indicates function 41 support   enum video mode
                          bit 10 indicates function 42 support *
                          bit  9 indicates function 43 support  \
                          bit  8 indicates function 44 support   \ Acceleration
                                                                 / Curvers
                          bit  7 indicates function 45 support  /
                          bit  6 indicates function 46 support  Undocumented
                          bit  5 indicates function 47 support *
                          bit  4 indicates function 48 support  (ballpoint)

                          bit  3 indicates function 49 support *
                          bit  2 indicates function 50 support *
                          bit  1 indicates function 51 support *
                          bit  0 indicates function 52 support  MOUSE.INI
*/
     AX(pcrf)=0xE42E;
     return(TRUE);
}

 /**************************************************************************
 *
 *  FUNCTION NAME : vmInt33GetSwitches()
 *
 *  DESCRIPTION   : Int 33h Get switch settings (function 51)
 *
 *  INPUT         :
 *                  pcrf -> VDM register frame
 *  OUTPUT        :
 *                      EMULATED
 *                          TRUE
 *                      NOT EMULATED
 *                          FALSE (pass control to next VDD and/or ROM)
 *  USES          :
 *                   32-bit small-model PASCAL calling/register conventions
 *
 *  CONTEXT       :
 *                     VDM Task-time
 *
 **************************************************************************/

BOOL PRIVENTRY
vmInt33GetSwitches(register PCRF pcrf)
{
     int blen;
     struct {
          char mtype;
          char lang;
          char hsens;
          char vsens;
          char dblthr;
          char actvcurv;
          char intrrt;
          char curovrmsk;
          char lapadj;
          char memtyp;
          char svgasppt;
          char rotang;
          char pribut;
          char secbut;
          char clklock;
          char accldata[324];
     } *rtdat;

     blen=CX(pcrf);
     rtdat=PFROMVADDR(ES(pcrf),DX(pcrf));
     if (blen--) {
          rtdat->mtype=mhwInstalled.mhw_uType;
     }
     if (blen--) {
          rtdat->lang=VDMData.mstates.ulLanguage;
     }
     if (blen--) {
          rtdat->hsens=VDMData.mstates.scaleXMics;
     }
     if (blen--) {
          rtdat->vsens=VDMData.mstates.scaleYMics;
     }
     if (blen--) {
          rtdat->dblthr=VDMData.mstates.scaleThreshold;
     }
     if (blen--) {
          rtdat->actvcurv=1;
     }
     if (blen--) {
          rtdat->intrrt=1;
     }
     if (blen--) {
          rtdat->curovrmsk=0;
     }
     if (blen--) {
          rtdat->lapadj=0;
     }
     if (blen--) {
          rtdat->memtyp=0;
     }
     if (blen--) {
          rtdat->svgasppt=0;
     }
     if (blen--) {
          rtdat->rotang=0;
     }
     if (blen--) {
          rtdat->pribut=0;
     }
     if (blen--) {
          rtdat->secbut=1;
     }
     if (blen--) {
          rtdat->clklock=0;
     }
     /* GetCurveData(rtdat->accldata,blen); */
     AX(pcrf)=0;
     return(TRUE);
}

#pragma  END_SWAP_CODE
