/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = VMDATA.C
 *
 * DESCRIPTIVE NAME = Virtual Mouse Private Data
 *
 *
 * VERSION =   V2.0
 *
 * DATE        02/28/92
 *
 * DESCRIPTION Virtual Mouse Private Data
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#include "vmdp.h"
#include "propname.h"
#pragma  BEGIN_SWAP_INSTANCE

PERVDMDATA VDMData = {NULL,                 /* ulSG                    */
                      NULL,                 /* flEventMask             */
                      {NULL},               /* vmss                    */
                      FALSE,                /* fShiftX                 */
                      FALSE,                /* fScrInit                */
                      FALSE,                /* fPassAbs                */
                      FALSE,                /* fAbsPt                  */
                      NULL,                 /* flButtons               */
                      0,                    /* ulcVPMapps              */
                      NULL,                 /* fpfnVPMBP               */
                      NULL,                 /* pointer to perappdata   */
                      /*
                      ** mouse states
                      */
                      {FALSE,               /* fInOffRegion            */
                       FALSE,               /* fOffEnable              */
                       PTR_HIDDEN,          /* fPtrHidden              */
                       NULL,                /* xCur                    */
                       NULL,                /* yCur                    */
                       {NULL},              /* butinfo                 */
                       NULL,                /* xMin                    */
                       NULL,                /* xMax                    */
                       NULL,                /* yMin                    */
                       NULL,                /* yMax                    */
                       NULL,                /* xMinOff                 */
                       NULL,                /* xMaxOff                 */
                       NULL,                /* yMinOff                 */
                       NULL,                /* yMaxOff                 */
                       NULL,                /* nxMics                  */
                       NULL,                /* nyMics                  */
                       DEF_XMICKEYS,        /* nxMicsPer8Pix           */
                       DEF_YMICKEYS,        /* nyMicsPer8Pix           */
                       DEF_THRESHOLD,       /* ulThreshold             */
                       DEF_XMICSSCALE,      /* scaleXMics              */
                       DEF_YMICSSCALE,      /* scaleYMics              */
                       DEF_THRESHOLDSCALE,  /*scaleThreshold           */
                       {NULL},              /* subinfo                 */
                       /*
                       ** int15info
                       */
                       {NULL,               /* ii_SubAddr              */
                        NULL,               /* ii_fstatus              */
                        0x64,               /* ii_srate                */
                        2,                  /* ii_res                  */
                       },
                       TRUE,                /* fLPenEmulate            */
                       FALSE,               /* fHWPtr                  */
                       DEF_TEXTANDMASK,     /* ulTextANDMask           */
                       DEF_TEXTXORMASK,     /* ulTextXORMask           */
                       DEF_XHOT,            /* xHot                    */
                       DEF_YHOT,            /* yHot                    */
                       0,                   /* ulVideoPage             */
                       0,                   /* ulLanguage              */
                                            /* ausGraphMasks           */
                      }

};

#pragma  END_SWAP_INSTANCE


#pragma  BEGIN_SWAP_DATA

/*
** Property names (defined here so that only one instance exists)
*/

PSZ pszPropMouseCapture = PROP_NAME_MOUSECAPTURE;
LONG ulsgCapture = 0L;
FPFNPDD fpfnPMRequestProc = (FPFNPDD)0;/* pointer to PMD function router     */

MHARDWARE mhwInstalled =
{
  sizeof(MHARDWARE)
};                                    /* hardware information packet         */

HIRQ hirq = NULL;                     /* virtual mouse IRQ handle            */

SHORT nxPixelsRemain = 0;
SHORT nyPixelsRemain = 0;

PVVINFO pvvinfoHead = (PVVINFO)0;
PVVINFO pvvinfoTail = (PVVINFO)0;     /* pointers to registered video service*/

PFNINT33PROCS apfnInt33Services[] =
{                                     /* should match function list in VMD.H */
  vmInt33Reset,                       /* 0                                   */
  vmInt33ShowPointer,                 /* 1                                   */
  vmInt33HidePointer,                 /* 2                                   */
  vmInt33QueryStatus,                 /* 3                                   */
  vmInt33SetPosition,                 /* 4                                   */
  vmInt33GetPressInfo,                /* 5                                   */
  vmInt33GetReleaseInfo,              /* 6                                   */
  vmInt33SetHorizontal,               /* 7                                   */
  vmInt33SetVertical,                 /* 8                                   */
  vmInt33DefineGraphPointer,          /* 9                                   */
  vmInt33DefineTextPointer,           /* 10                                  */
  vmInt33GetMotionCounts,             /* 11                                  */
  vmInt33SetUserSub,                  /* 12                                  */
  vmInt33EnableLightPen,              /* 13                                  */
  vmInt33DisableLightPen,             /* 14                                  */
  vmInt33SetMickeyRatio,              /* 15                                  */
  vmInt33SetConditional,              /* 16                                  */
  vmInt33SetThreshold,                /* 17                                  */
  vmInt33DefineVarPointer,            /* 18                                  */
  vmInt33SetThreshold,                /* 19                                  */
  vmInt33SwapUserSub,                 /* 20                                  */
  vmInt33QueryStateSize,              /* 21                                  */
  vmInt33SaveState,                   /* 22                                  */
  vmInt33RestoreState,                /* 23                                  */
  vmInt33SetAltUserSub,               /* 24                                  */
  vmInt33QueryAltUserSub,             /* 25                                  */
  vmInt33SetSensitivity,              /* 26                                  */
  vmInt33QuerySensitivity,            /* 27                                  */
  vmInt33SetInterruptRate,            /* 28                                  */
  vmInt33SetCRTPage,                  /* 29                                  */
  vmInt33QueryCRTPage,                /* 30                                  */
  vmInt33DisableDriver,               /* 31                                  */
  vmInt33EnableDriver,                /* 32                                  */
  vmInt33SoftwareReset,               /* 33                                  */
  vmInt33SetLanguage,                 /* 34                                  */
  vmInt33QueryLanguage,               /* 35                                  */
  vmInt33QueryMouseVersion,           /* 36                                  */
  vmInt33GetGeneralInfo,              /* 37 Get general driver information   */
  vmInt33GetMaxVirtual,               /* 38 Get maximum virtual coordinates  */
  vmInt33GetMaskMickey,               /* 39 Get screen/cursor masks & counts */
  NULL,                               /* 40 Set Video Mode                   */
  NULL,                               /* 41 Enumerate Video modes            */
  vmInt33GetHotSpot,                  /* 42 Get cursor hot spot              */
  NULL,                               /* 43 Load acceleration curves         */
  NULL,                               /* 44 Read acceleration curves         */
  NULL,                               /* 45 Set/Get active acceleration curve*/
  NULL,                               /* 46 Undocumented misc function       */
  vmInt33HdwReset,                    /* 47 Mouse hardware reset             */
  NULL,                               /* 48 Set/Get ballpoint information    */
  vmInt33GetMinMax,                   /* 49 Get minimum/maximum virtual coord*/
  vmInt33GetAdvanced,                 /* 50 Get active advanced functions    */
  vmInt33GetSwitches,                 /* 51 Get switch settings              */
  NULL                                /* 52 Get Mouse.ini                    */
};


USHORT ausDefGraphMasks[2*MAX_PTRHEIGHT] =
{
  0x3FFF,                  /* 00111111,11111111 default graphics pointer     */
  0x1FFF,                  /* 00011111,11111111 AND mask                     */
  0x0FFF,                  /* 00001111,11111111                              */
  0x07FF,                  /* 00000111,11111111                              */
  0x03FF,                  /* 00000011,11111111                              */
  0x01FF,                  /* 00000001,11111111                              */
  0x00FF,                  /* 00000000,11111111                              */
  0x007F,                  /* 00000000,01111111                              */
  0x003F,                  /* 00000000,00111111                              */
  0x001F,                  /* 00000000,00011111                              */
  0x01FF,                  /* 00000001,11111111                              */
  0x10FF,                  /* 00010000,11111111                              */
  0x30FF,                  /* 00110000,11111111                              */
  0xF87F,                  /* 11111000,01111111                              */
  0xF87F,                  /* 11111000,01111111                              */
  0xFC7F,                  /* 11111100,01111111                              */
  0x0000,                  /* 00000000,00000000 XOR mask                     */
  0x4000,                  /* 01000000,00000000                              */
  0x6000,                  /* 01100000,00000000                              */
  0x7000,                  /* 01110000,00000000                              */
  0x7800,                  /* 01111000,00000000                              */
  0x7C00,                  /* 01111100,00000000                              */
  0x7E00,                  /* 01111110,00000000                              */
  0x7F00,                  /* 01111111,00000000                              */
  0x7F80,                  /* 01111111,10000000                              */
  0x7C00,                  /* 01111100,00000000                              */
  0x6C00,                  /* 01101100,00000000                              */
  0x4600,                  /* 01000110,00000000                              */
  0x0600,                  /* 00000110,00000000                              */
  0x0300,                  /* 00000011,00000000                              */
  0x0300,                  /* 00000011,00000000                              */
  0x0000                   /* 00000000,00000000                              */
};

ULONG aulScaleTable[MAX_SCALERANGE] =
{
  (14*SENS_SCALAR)/4,                 /* 3 1/2                               */
  (13*SENS_SCALAR)/4,                 /* 3 1/4                               */
  (12*SENS_SCALAR)/4,                 /* 3                                   */
  (11*SENS_SCALAR)/4,                 /* 2 3/4                               */
  (10*SENS_SCALAR)/4,                 /* 2 1/2                               */
  (9*SENS_SCALAR)/4,                  /* 2 1/4                               */
  (8*SENS_SCALAR)/4,                  /* 2                                   */
  (7*SENS_SCALAR)/4,                  /* 1 3/4                               */
  (6*SENS_SCALAR)/4,                  /* 1 1/2                               */
  (5*SENS_SCALAR)/4,                  /* 1 1/4                               */
  (8*SENS_SCALAR)/8,                  /* 1                                   */
  (7*SENS_SCALAR)/8,                  /* 7/8                                 */
  (6*SENS_SCALAR)/8,                  /* 3/4                                 */
  (5*SENS_SCALAR)/8,                  /* 5/8                                 */
  (4*SENS_SCALAR)/8,                  /* 1/2                                 */
  (3*SENS_SCALAR)/8,                  /* 3/8                                 */
  (2*SENS_SCALAR)/8,                  /* 1/4                                 */
  (1*SENS_SCALAR)/8,                  /* 1/8                                 */
  (1*SENS_SCALAR)/16,                 /* 1/16                                */
  (1*SENS_SCALAR)/32,                 /* 1/32                                */
  0
};

IOH iohVM =
{
  vmReadPort, vmWritePort, NULL, NULL, NULL
};

#pragma  END_SWAP_DATA


#pragma  BEGIN_GLOBAL_DATA

#ifdef   VDDSTRICT
CHAR szAssertMsg[] = "VMSE assertion failure in %s, line %d\n";
#endif

#ifdef   VDDDEBUG
CHAR szModule[] = "VMSE: ";
#endif

LONG nxMickeysRemain = 0;
LONG nyMickeysRemain = 0;
USHORT nThreshold;
USHORT uxScale;
USHORT uyScale;
USHORT usMouExclusive = 0;

#pragma  END_GLOBAL_DATA


#pragma  BEGIN_INSTANCE_DATA

MEVBUFF amevBuffer[MAX_MEVBUFFS];     /* mouse event buffer                  */
PMEVBUFF pEventHead = & amevBuffer[0];/* head ptr of mouse event buffer      */
PMEVBUFF pEventTail = & amevBuffer[0];/* tail ptr of mouse event buffer      */
BOOL fMouseEnabled = TRUE;            /* mouse driver enabled for this VDM   */
BOOL fEventsPending = FALSE;          /* there are pending mouse events      */
BOOL fContextHookFlag = FALSE;        /* Indicates VDHSetContextHook called  */
HHOOK hhookSendEventHook = NULL;      /* hook handle for vmSendEventHook     */
HHOOK hhookUserSubReturnHook = NULL;  /* hook handle for VMUserSubReturnHook */
HHOOK hhookUserSubIntHook = NULL;     /* hook handle for VMUserSubIntHook    */
ULONG iSubActive = SUB_NONE;          /* index of active user-subroutine     */
ULONG fsstate = 0;                    /* VDM session state flags             */

#pragma  END_INSTANCE_DATA
