.*	SCCSID = @(#)mousehis.sci    11.1 88/08/08
.*
.*	Design history

:history id=novirt.Pointer management for background VDMs
The virtual mouse driver is free to call the virtual video at any time,
in order to draw the mouse pointer at a specific position.  However, it
is deemed of no value to actually draw the pointer if the VDM is
currently running in the &bgd., since the pointer can always be updated
at screen-switch time, and since the act of touching virtual video
memory risks freezing the VDM if it is not in a text mode at the time.
Furthermore, it is believed that no apps depend on the actual detectable
presence of a mouse pointer within video memory.
:ehistory.


:history id=supp33.Ways to provide Int 33h support
To provide Int 33h support, there were two basic options&gml.
:dl compact tsize=5
:dt.1.
:dd.Allow each VDM to have its own arbitrary real-mode mouse driver loaded.
:dl compact tsize=3
:dt.+
:dd.Less overall work.	OS/2 would no longer directly supply Int 33h support.
The real-mode driver currently supplied with DOS could be included
instead.  The VPIC component would be required to automatically simulate
interrupts for unowned devices.

:dt.-
:dd.Increases overall system memory consumption, since there must be
a separate instance of the Int 33h support in each VDM.

:dt.-
:dd.Reduced performance, since all mouse interrupts must be "simulated" into
the VDM, rather than handled directly by a PDD/VDD pair.

:dt.-
:dd.Mouse hardware state impossible to preserve for each VDM.  The impact
could be anything from insignificant to severe, depending on the nature of
the hardware.

:dt.-
:dd.Compatibility problems.  We cannot be sure that third-party
mouse drivers will not be confused by &bgd. VDMs, which are running
and perhaps even issuing Int 33h calls periodically, but for which no
interrupts are ever received.

:dt.-
:dd.Precludes use of mouse within a VDM window, since the PM
environment must be able to dictate mouse position to the driver.

:dt.?
:dd.Will this require any additional work, such as support for non-block
real-mode device drivers that issue Int 21h at installation time?
:edl

:dt.2.
:dd.Provide a &vmd. that communicates directly with a Physical Mouse Driver.
:dl compact tsize=3
:dt.+
:dd.Reduces overall system memory consumption, since there is only one
instance of the Int 33h support for all VDMs.

:dt.+
:dd.Hardware state for supported mice easily preserved across VDMs.

:dt.+
:dd.Promises highest level of Int 33h compatibility for users of supported
mice.  Also allows us to continue to assert control over the Int 33h
interface standard.

:dt.+
:dd.Does not preclude the use of mouse within a VDM window, since the &vmd.
can include a PM interface to coerce the pointer position.

:dt.-
:dd.More overall work.	The Int 33h support must be ripped from the PDDs,
upgraded, and dropped in VMDs.	There is also the related issue of what to do
with POINTDD support, which is discussed in "Video pointer management".
:edl
:edl

Option #2 is preferred.
:ehistory.


:history id=intsim.Approach to VDM event notification
Invoking VDM mouse event notification handlers via interrupt simulation
is the preferred approach because it takes advantage of the VPIC's
IRQ-based priority-boosting mechanism rather than working around it or
against it, is slightly simpler to implement, and has potential for greater
compatibility by prioritizing the call-out with other interrupt-based events.
:ehistory.


:history id=modechg.Approaches to VDM video mode change notification
There were two basic ways to do this&gml.
:dl compact tsize=5
:dt.1.
:dd.Have the VMD hook the Int 10h software interrupt and watch for
mode changes.

:dt.2.
:dd.Have the VVD, which already has an Int 10h software interrupt hook, notify
the VMD via a VMD export.
:edl
The latter is nice because, even though it promotes an additional interface,
it makes the VMD more video hardware-independent and reduces the length
of the Int 10h path by a very small amount.  Hardware independence is an
important factor, because some manufacturers have defined new Int 10h modes,
and ideally they should only have to provide a separate VVD to automatically
support a mouse pointer in all the new modes.

However, the former is simpler to implement, and an Int 10h hook is needed
anyway for Light Pen emulation (discussed below), which the VVD would have no
interest in assisting.	On the other hand, that Int 10h hook is only needed
while the mouse' Light Pen emulation mode is active, which for most apps is
probably never.

Therefore, Option #2 is preferred.
:ehistory.


:history id=drawptr.Approaches to VMD pointer drawing
To manage the video pointer image, there are four basic options&gml.
:dl compact tsize=5
:dt.1.
:dd.Call the POINTDD protected-mode device driver from the VMD, just as
the mouse PDD does today.
:dl compact tsize=3
:dt.+
:dd.Less overall work (less deviation from existing model).

:dt.+
:dd.Video-dependent code well-separated from mouse-dependent code.

:dt.-
:dd.Video-dependent code spread across several components.

:dt.-
:dd.Excessive VDM support would always be loaded in a non-MVDM system (unless
POINTDD can be easily modified from its existing implementation to throw
away V86-mode support).
:edl
In summary, no radical change from current implementation.

:dt.2.
:dd.Incorporate all MVDM pointer-draw support into the VMD.
:dl compact tsize=3
:dt.+
:dd.Significantly less VDM support is loaded in a non-MVDM system.

:dt.+
:dd.Simpler to implement, allowing existing DOS mouse drivers to be
more quickly converted to genuine VMDs.

:dt.-
:dd.Video-dependent code is not well-separated from mouse-dependent code.
:edl
In other words, expedient but, architecturally, somewhat undesirable.

:dt.3.
:dd.Provide a VDM complement to POINTDD (that is, provide a VDD that serves
the role of POINTDD, for MVDMs only).  This still spreads video-dependent
code around and requires yet-another-component.

:dt.4.
:dd.Incorporate a pointer-drawing interface into the &vvd..
:dl compact tsize=3
:dt.+
:dd.Significantly less VDM support is loaded in a non-MVDM system.

:dt.+
:dd.All video-dependent code is combined in a single VDD.

:dt.+
:dd.Video-dependent code is well-separated from mouse-dependent code.
:edl
:edl

Option #4 is preferred.

Note that even if we were to retain VDM pointer drawing support in POINTDD,
that interface is not significantly different.	POINTDD provides a separate
service to verify video-mode supportability, and a separate service to free
any memory associated with a defined pointer.  The latter makes no sense
for a VDM, because there is no necessarily good time to "undefine" a pointer;
the Int 33h is not OPENed like the protected-mode interface is.  Thus, VDM
pointer-drawing logic must keep the current pointer definition indefinitely.
:ehistory.
