/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = vkbdp.h
 *
 * DESCRIPTIVE NAME = Virtual Keyboard Device Driver (VKBD)
 *
 *
 * VERSION = V2.0
 *
 * DATE   05/12/91
 *
 * DESCRIPTION
 *
 *      VKBD private constants, types, macros and function declarations.
 *
 *      Include file hierarchy:
 *
 *        vkbdp.h
 *          /src/inc/vkbd.h
 *          /src/inc/vkbdpdd.h
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#include <kbd.h>                      /* public keyboard constants           */
#include <beep.h>                     /* beep equates                        */
#include <vkbdpdd.h>                  /* public/exported vkbd-pkbd stuff     */

/*
** Per-VDM flags
*/
#define  VDM_WINDOWED  0x00001
#define  VDM_FGND      0x00002
#define  VDM_FOCUS     0x00004
#define  VDM_PASTING   0x00008        /* pasting in progress                 */
#define  VDM_PASTEINIT 0x00010        /* pasting initialization done         */
#define  VDM_PASTEPAUSE 0x00020       /* pasting currently paused            */
#define  VDM_PASTEDONE 0x00040        /* shield has no more paste data       */
#define  VDM_ENDPASTING 0x00080       /* pasting has been aborted by user    */
#define  VDM_XFERPENDING 0x00100
#define  VDM_EOIPENDING 0x00200
#define  VDM_IRETPENDING 0x00400
#define  VDM_INT15RET  0x00800
#define  VDM_EXTRAKEYS 0x01000     /* enlarged key buffer enabled (default)  */
#define  VDM_FASTPASTE 0x02000     /* fast (INT 16h) pasting enabled (NOT    */
                                   /*                               DEFAULT) */
#define  VDM_PASTEDATA 0x04000     /* buffer has not been emptied since      */
                                   /* last paste                             */
#define  VDM_KBDRESTRICT 0x08000   /* keyboard controller commands           */
                                   /* restricted                             */
#define  VDM_TIMERARMED 0x10000    /* timer has been armed                   */


/*
** flhkVDM
*/
#define  VDM_NONE      0x00000        /* all control sequences               */
#define  VDM_ALTESC    0x00001        /*                                     */
#define  VDM_CTRLESC   0x00002        /*                                     */
#define  VDM_ALTHOME   0x00004        /*                                     */

/*
** Input flags for VKAddScan
*/
#define  ADDSCAN_TASK  0x0000         /* task-time                           */
#define  ADDSCAN_INTERRUPT 0x0001     /* interrupt-time                      */
#define  ADDSCAN_INPUT 0x0002         /* normal input                        */
#define  ADDSCAN_PASTEINPUT 0x0004    /* paste input                         */
#define  ADDSCAN_RESPONSE 0x0008      /* command response                    */

/*
** Result codes from VKPeekScan
*/
#define  PEEKSCAN_NONE 0           /* no scan code available                 */
#define  PEEKSCAN_PAUSE 1          /* no scan code available (pasting        */
                                   /*                         breather)      */
#define  PEEKSCAN_WAITEOI 2        /* interrupt should be simulated at EOI   */
#define  PEEKSCAN_WAITIRET 3       /* interrupt should be simulated at IRET  */

/*
** Private flag bits in scan code buffer
*/
#define  FKEYPKT_WAITEOI 0x01     /* indicates no wait interrupt simulation  */

/*
** Implementation-related constants (tunable)
*/
#define  MAX_SCANS     64        /* maximum codes our virtual kbd buffers    */
#define  SCANBUF_THRESHOLD 16    /* free space threshold to restart pasting  */
#define  KEYSBUF_THRESHOLD 3     /* free space threshold for fast pasting    */
#define  MAX_EXTRAKEYS 64             /* maximum "extra" keys bufferable     */
#define  NUM_SHIFTS    6              /* number of shift table entries       */
#define  MAX_PASTEEXPAND 16           /* max. paste scan expansion           */
#define  MAX_NUMSCANS  10             /* max. number of numpad scans         */
#define  IRET_TIMEOUT  250            /* iret timeout in msec                */

/*
** Miscellaneous equates
*/
#define  ASC_ESC       0x1b           /* ascii code for the escape key       */

/*
**    Subcomponent-specific types
*/

typedef struct tls_s
{
  PCHAR tls_pchList;
  PULONG tls_pulVal;
} TLS;
                                      /* tls frame list value pair           */
typedef TLS *PTLS;
typedef(PASCAL *PFNSYSRQ)(HVDM,ULONG,PVOID,ULONG,PVOID);
typedef struct cpentry_s
{
  struct cpentry_s *cp_pcpPrev;       /* backward link                       */
  struct cpentry_s *cp_pcpNext;       /* forward link                        */
  USHORT cp_usCodePage;               /* codepage value                      */
  USHORT cp_hCodePage;                /* codepage table handle               */
  USHORT cp_cReference;               /* reference count                     */
  RXTABLE cp_RXTable;                 /* rev xlate table                     */
  SHTABLE cp_ShTable;                 /* shift scan table                    */
  NUMTABLE cp_NumTable;               /* num scan table                      */
} CPENTRY;

typedef CPENTRY *PCPENTRY;
typedef PCPENTRY *PPCPENTRY;

#ifdef   MYDEBUG
   #define  MAX_DEBUG_ENTRIES 8192
typedef struct debugentry_s
{
  UCHAR de_op;
  UCHAR de_value;
} DEBUGENTRY;

typedef DEBUGENTRY *PDEBUGENTRY;
VOID PRIVENTRY VKAddDebugEntry(HVDM,UCHAR,UCHAR);
   #define  ADDDEBUG(hvdm,op,value) VKAddDebugEntry(hvdm,op,value)

#else
   #define  ADDDEBUG(hvdm,op,value)
#endif
/*
** c-begin
*/

/*
**    Subcomponent-specific macros
*/

#define  VKBeep()      VDHDevBeep(KBDBEEP_FREQ, KBDBEEP_DURATION)
/*
** c-end
*/

/*
**   These are "extended scan codes" assigned by IBM's ROM BIOS to various
**   key combinations.  They are returned to the VDM along with a NULL
**   character code.  Because these are post-translation values, it's
**   reasonably OK to use them throughout the driver, as long as they're
**   used as such.  For many of the unshifted keys, the EXTSCAN_ value is the
**   same SCAN_ value, but that's only an interesting bit of trivia, not
**   something you should ever depend on.
**
**   Those keys marked as "ENHANCED BIOS" are only supported by enhanced
**   ROM BIOS (the kind you'd find on a 101-key system, although a 101-key
**   keyboard is not a strict requirement), and should only be readable via an
**   extended BIOS read (INT 16h, AH=10h instead AH=00h).
*/

#define  EXTSCAN_ALTESC 0x01          /* Alt Esc ENHANCED BIOS               */
#define  EXTSCAN_NULL  0x03           /* Null                                */
#define  EXTSCAN_ALTBKSP 0x0E         /* Alt Backspace ENHANCED BIOS         */
#define  EXTSCAN_ALTBKTAB 0x0F        /* Backtab                             */
#define  EXTSCAN_ALTQ  0x10           /* Alt Q                               */
#define  EXTSCAN_ALTW  0x11           /* Alt W                               */
#define  EXTSCAN_ALTE  0x12           /* Alt E                               */
#define  EXTSCAN_ALTR  0x13           /* Alt R                               */
#define  EXTSCAN_ALTT  0x14           /* Alt T                               */
#define  EXTSCAN_ALTY  0x15           /* Alt Y                               */
#define  EXTSCAN_ALTU  0x16           /* Alt U                               */
#define  EXTSCAN_ALTI  0x17           /* Alt I                               */
#define  EXTSCAN_ALTO  0x18           /* Alt O                               */
#define  EXTSCAN_ALTP  0x19           /* Alt P                               */
#define  EXTSCAN_ALTLB 0x1A           /* Alt [ ENHANCED BIOS                 */
#define  EXTSCAN_ALTRB 0x1B           /* Alt ] ENHANCED BIOS                 */
#define  EXTSCAN_ALTENTER 0x1C        /* Alt Enter ENHANCED BIOS             */
#define  EXTSCAN_ALTA  0x1E           /* Alt A                               */
#define  EXTSCAN_ALTS  0x1F           /* Alt S                               */
#define  EXTSCAN_ALTD  0x20           /* Alt D                               */
#define  EXTSCAN_ALTF  0x21           /* Alt F                               */
#define  EXTSCAN_ALTG  0x22           /* Alt G                               */
#define  EXTSCAN_ALTH  0x23           /* Alt H                               */
#define  EXTSCAN_ALTJ  0x24           /* Alt J                               */
#define  EXTSCAN_ALTK  0x25           /* Alt K                               */
#define  EXTSCAN_ALTL  0x26           /* Alt L                               */
#define  EXTSCAN_ALTSEMI 0x27         /* Alt ; ENHANCED BIOS                 */
#define  EXTSCAN_ALTSQ 0x28           /* Alt ' ENHANCED BIOS                 */
#define  EXTSCAN_ALTBQ 0x29           /* Alt ` ENHANCED BIOS                 */
#define  EXTSCAN_ALTBSLASH 0x2B       /* Alt \ ENHANCED BIOS                 */
#define  EXTSCAN_ALTZ  0x2C           /* Alt Z                               */
#define  EXTSCAN_ALTX  0x2D           /* Alt X                               */
#define  EXTSCAN_ALTC  0x2E           /* Alt C                               */
#define  EXTSCAN_ALTV  0x2F           /* Alt V                               */
#define  EXTSCAN_ALTB  0x30           /* Alt B                               */
#define  EXTSCAN_ALTN  0x31           /* Alt N                               */
#define  EXTSCAN_ALTM  0x32           /* Alt M                               */
#define  EXTSCAN_ALTCOMMA 0x33        /* Alt , ENHANCED BIOS                 */
#define  EXTSCAN_ALTPERIOD 0x34       /* Alt . ENHANCED BIOS                 */
#define  EXTSCAN_ALTSLASH 0x35        /* Alt / ENHANCED BIOS                 */
#define  EXTSCAN_ALTKPMULT 0x37       /* Alt Keypad * ENHANCED BIOS          */
#define  EXTSCAN_F1    0x3B           /* F1                                  */
#define  EXTSCAN_F2    0x3C           /* F2                                  */
#define  EXTSCAN_F3    0x3D           /* F3                                  */
#define  EXTSCAN_F4    0x3E           /* F4                                  */
#define  EXTSCAN_F5    0x3F           /* F5                                  */
#define  EXTSCAN_F6    0x40           /* F6                                  */
#define  EXTSCAN_F7    0x41           /* F7                                  */
#define  EXTSCAN_F8    0x42           /* F8                                  */
#define  EXTSCAN_F9    0x43           /* F9                                  */
#define  EXTSCAN_F10   0x44           /* F10                                 */
#define  EXTSCAN_HOME  0x47           /* Home                                */
#define  EXTSCAN_UP    0x48           /* Up                                  */
#define  EXTSCAN_PGUP  0x49           /* PgUp                                */
#define  EXTSCAN_ALTKPMINUS 0x4A      /* Alt Keypad - ENHANCED BIOS          */
#define  EXTSCAN_LEFT  0x4B           /* Left                                */
#define  EXTSCAN_CENTER 0x4C          /* Center ENHANCED BIOS                */
#define  EXTSCAN_RIGHT 0x4D           /* Right                               */
#define  EXTSCAN_ALTKPPLUS 0x4E       /* Alt Keypad + ENHANCED BIOS          */
#define  EXTSCAN_END   0x4F           /* End                                 */
#define  EXTSCAN_DOWN  0x50           /* Down                                */
#define  EXTSCAN_PGDN  0x51           /* PgDn                                */
#define  EXTSCAN_INS   0x52           /* Ins                                 */
#define  EXTSCAN_DEL   0x53           /* Del                                 */
#define  EXTSCAN_SHIFTF1 0x54         /* Shift F1                            */
#define  EXTSCAN_SHIFTF2 0x55         /* Shift F2                            */
#define  EXTSCAN_SHIFTF3 0x56         /* Shift F3                            */
#define  EXTSCAN_SHIFTF4 0x57         /* Shift F4                            */
#define  EXTSCAN_SHIFTF5 0x58         /* Shift F5                            */
#define  EXTSCAN_SHIFTF6 0x59         /* Shift F6                            */
#define  EXTSCAN_SHIFTF7 0x5A         /* Shift F7                            */
#define  EXTSCAN_SHIFTF8 0x5B         /* Shift F8                            */
#define  EXTSCAN_SHIFTF9 0x5C         /* Shift F9                            */
#define  EXTSCAN_SHIFTF10 0x5D        /* Shift F10                           */
#define  EXTSCAN_CTRLF1 0x5E          /* Ctrl F1                             */
#define  EXTSCAN_CTRLF2 0x5F          /* Ctrl F2                             */
#define  EXTSCAN_CTRLF3 0x60          /* Ctrl F3                             */
#define  EXTSCAN_CTRLF4 0x61          /* Ctrl F4                             */
#define  EXTSCAN_CTRLF5 0x62          /* Ctrl F5                             */
#define  EXTSCAN_CTRLF6 0x63          /* Ctrl F6                             */
#define  EXTSCAN_CTRLF7 0x64          /* Ctrl F7                             */
#define  EXTSCAN_CTRLF8 0x65          /* Ctrl F8                             */
#define  EXTSCAN_CTRLF9 0x66          /* Ctrl F9                             */
#define  EXTSCAN_CTRLF10 0x67         /* Ctrl F10                            */
#define  EXTSCAN_ALTF1 0x68           /* Alt F1                              */
#define  EXTSCAN_ALTF2 0x69           /* Alt F2                              */
#define  EXTSCAN_ALTF3 0x6A           /* Alt F3                              */
#define  EXTSCAN_ALTF4 0x6B           /* Alt F4                              */
#define  EXTSCAN_ALTF5 0x6C           /* Alt F5                              */
#define  EXTSCAN_ALTF6 0x6D           /* Alt F6                              */
#define  EXTSCAN_ALTF7 0x6E           /* Alt F7                              */
#define  EXTSCAN_ALTF8 0x6F           /* Alt F8                              */
#define  EXTSCAN_ALTF9 0x70           /* Alt F9                              */
#define  EXTSCAN_ALTF10 0x71          /* Alt F10                             */
#define  EXTSCAN_CTRLPRTSC 0x72       /* Ctrl PrtSc                          */
#define  EXTSCAN_CTRLLEFT 0x73        /* Ctrl Left                           */
#define  EXTSCAN_CTRLRIGHT 0x74       /* Ctrl Right                          */
#define  EXTSCAN_CTRLEND 0x75         /* Ctrl End                            */
#define  EXTSCAN_CTRLPGDN 0x76        /* Ctrl PgDn                           */
#define  EXTSCAN_CTRLHOME 0x77        /* Ctrl Home                           */
#define  EXTSCAN_ALT1  0x78           /* Alt 1                               */
#define  EXTSCAN_ALT2  0x79           /* Alt 2                               */
#define  EXTSCAN_ALT3  0x7A           /* Alt 3                               */
#define  EXTSCAN_ALT4  0x7B           /* Alt 4                               */
#define  EXTSCAN_ALT5  0x7C           /* Alt 5                               */
#define  EXTSCAN_ALT6  0x7D           /* Alt 6                               */
#define  EXTSCAN_ALT7  0x7E           /* Alt 7                               */
#define  EXTSCAN_ALT8  0x7F           /* Alt 8                               */
#define  EXTSCAN_ALT9  0x80           /* Alt 9                               */
#define  EXTSCAN_ALT0  0x81           /* Alt 0                               */
#define  EXTSCAN_ALTMINUS 0x82        /* Alt -                               */
#define  EXTSCAN_ALTEQUAL 0x83        /* Alt =                               */
#define  EXTSCAN_CTRLPGUP 0x84        /* Ctrl PgUp                           */
#define  EXTSCAN_F11   0x85           /* F11 ENHANCED BIOS                   */
#define  EXTSCAN_F12   0x86           /* F12 ENHANCED BIOS                   */
#define  EXTSCAN_SHIFTF11 0x87        /* Shift F11 ENHANCED BIOS             */
#define  EXTSCAN_SHIFTF12 0x88        /* Shift F12 ENHANCED BIOS             */
#define  EXTSCAN_CTRLF11 0x89         /* Ctrl F11 ENHANCED BIOS              */
#define  EXTSCAN_CTRLF12 0x8A         /* Ctrl F12 ENHANCED BIOS              */
#define  EXTSCAN_ALTF11 0x8B          /* Alt F11 ENHANCED BIOS               */
#define  EXTSCAN_ALTF12 0x8C          /* Alt F12 ENHANCED BIOS               */
#define  EXTSCAN_CTRLUP 0x8D          /* Ctrl Up ENHANCED BIOS               */
#define  EXTSCAN_CTRLKPMINUS 0x8E     /* Ctrl Keypad - ENHANCED BIOS         */
#define  EXTSCAN_CTRLCENTER 0x8F      /* Ctrl Center ENHANCED BIOS           */
#define  EXTSCAN_CTRLKPPLUS 0x90      /* Ctrl Keypad + ENHANCED BIOS         */
#define  EXTSCAN_CTRLDOWN 0x91        /* Ctrl Down ENHANCED BIOS             */
#define  EXTSCAN_CTRLINS 0x92         /* Ctrl Ins ENHANCED BIOS              */
#define  EXTSCAN_CTRLDEL 0x93         /* Ctrl Del ENHANCED BIOS              */
#define  EXTSCAN_CTRLTAB 0x94         /* Ctrl Tab ENHANCED BIOS              */
#define  EXTSCAN_CTRLKPSLASH 0x95     /* Ctrl Keypad / ENHANCED BIOS         */
#define  EXTSCAN_CTRLKPMULT 0x96      /* Ctrl Keypad * ENHANCED BIOS         */
#define  EXTSCAN_ALTHOME 0x97         /* Alt Home ENHANCED BIOS              */
#define  EXTSCAN_ALTUP 0x98           /* Alt Up ENHANCED BIOS                */
#define  EXTSCAN_ALTPGUP 0x99         /* Alt PgUp ENHANCED BIOS              */
#define  EXTSCAN_ALTLEFT 0x9B         /* Alt Left ENHANCED BIOS              */
#define  EXTSCAN_ALTRIGHT 0x9D        /* Alt Right ENHANCED BIOS             */
#define  EXTSCAN_ALTEND 0x9F          /* Alt End ENHANCED BIOS               */
#define  EXTSCAN_ALTDOWN 0xA0         /* Alt Down ENHANCED BIOS              */
#define  EXTSCAN_ALTPGDN 0xA1         /* Alt PgDn ENHANCED BIOS              */
#define  EXTSCAN_ALTINS 0xA2          /* Alt Ins ENHANCED BIOS               */
#define  EXTSCAN_ALTDEL 0xA3          /* Alt Del ENHANCED BIOS               */
#define  EXTSCAN_ALTKPSLASH 0xA4      /* Alt Keypad / ENHANCED BIOS          */
#define  EXTSCAN_ALTTAB 0xA5          /* Alt Tab ENHANCED BIOS               */
#define  EXTSCAN_ALTKPENTER 0xA6      /* Alt Keypad Enter ENHANCED BIOS      */

/*
*/
#define  EXTSCAN_F13   0xEC           /* F13 ENHANCED BIOS                   */
#define  EXTSCAN_F14   0xED           /* F14 ENHANCED BIOS                   */
#define  EXTSCAN_F15   0xEE           /* F15 ENHANCED BIOS                   */
#define  EXTSCAN_F16   0xEF           /* F16 ENHANCED BIOS                   */
#define  EXTSCAN_F17   0xF4           /* F17 ENHANCED BIOS                   */
#define  EXTSCAN_F18   0xF5           /* F18 ENHANCED BIOS                   */
#define  EXTSCAN_F19   0xF6           /* F19 ENHANCED BIOS                   */
#define  EXTSCAN_F20   0xF7           /* F20 ENHANCED BIOS                   */
#define  EXTSCAN_F21   0xF8           /* F21 ENHANCED BIOS                   */
#define  EXTSCAN_F22   0xF9           /* F22 ENHANCED BIOS                   */
#define  EXTSCAN_F23   0xFA           /* F23 ENHANCED BIOS                   */
#define  EXTSCAN_F24   0xC0           /* F24 ENHANCED BIOS                   */
#define  EXTSCAN_SHIFTF13 0xC1        /* Shift F13 ENHANCED BIOS             */
#define  EXTSCAN_SHIFTF14 0xC3        /* Shift F14 ENHANCED BIOS             */
#define  EXTSCAN_SHIFTF15 0xC4        /* Shift F15 ENHANCED BIOS             */
#define  EXTSCAN_SHIFTF16 0xC5        /* Shift F16 ENHANCED BIOS             */
#define  EXTSCAN_SHIFTF17 0xC6        /* Shift F17 ENHANCED BIOS             */
#define  EXTSCAN_SHIFTF18 0xC7        /* Shift F18 ENHANCED BIOS             */
#define  EXTSCAN_SHIFTF19 0xC8        /* Shift F19 ENHANCED BIOS             */
#define  EXTSCAN_SHIFTF20 0xC9        /* Shift F20 ENHANCED BIOS             */
#define  EXTSCAN_SHIFTF21 0xCA        /* Shift F21 ENHANCED BIOS             */
#define  EXTSCAN_SHIFTF22 0xCB        /* Shift F22 ENHANCED BIOS             */
#define  EXTSCAN_SHIFTF23 0xCC        /* Shift F23 ENHANCED BIOS             */
#define  EXTSCAN_SHIFTF24 0xCD        /* Shift F24 ENHANCED BIOS             */
#define  EXTSCAN_CTRLF13 0xCE         /* Ctrl F13 ENHANCED BIOS              */
#define  EXTSCAN_CTRLF14 0xCF         /* Ctrl F14 ENHANCED BIOS              */
#define  EXTSCAN_CTRLF15 0xD0         /* Ctrl F15 ENHANCED BIOS              */
#define  EXTSCAN_CTRLF16 0xD1         /* Ctrl F16 ENHANCED BIOS              */
#define  EXTSCAN_CTRLF17 0xD2         /* Ctrl F17 ENHANCED BIOS              */
#define  EXTSCAN_CTRLF18 0xD3         /* Ctrl F18 ENHANCED BIOS              */
#define  EXTSCAN_CTRLF19 0xD4         /* Ctrl F19 ENHANCED BIOS              */
#define  EXTSCAN_CTRLF20 0xD5         /* Ctrl F20 ENHANCED BIOS              */
#define  EXTSCAN_CTRLF21 0xD6         /* Ctrl F21 ENHANCED BIOS              */
#define  EXTSCAN_CTRLF22 0xD7         /* Ctrl F22 ENHANCED BIOS              */
#define  EXTSCAN_CTRLF23 0xD8         /* Ctrl F23 ENHANCED BIOS              */
#define  EXTSCAN_CTRLF24 0xD9         /* Ctrl F24 ENHANCED BIOS              */
#define  EXTSCAN_ALTF13 0xDA          /* Alt F13 ENHANCED BIOS               */
#define  EXTSCAN_ALTF14 0xDB          /* Alt F14 ENHANCED BIOS               */
#define  EXTSCAN_ALTF15 0xDC          /* Alt F15 ENHANCED BIOS               */
#define  EXTSCAN_ALTF16 0xDD          /* Alt F16 ENHANCED BIOS               */
#define  EXTSCAN_ALTF17 0xDE          /* Alt F17 ENHANCED BIOS               */
#define  EXTSCAN_ALTF18 0xDF          /* Alt F18 ENHANCED BIOS               */
#define  EXTSCAN_ALTF19 0xE2          /* Alt F19 ENHANCED BIOS               */
#define  EXTSCAN_ALTF20 0xE3          /* Alt F20 ENHANCED BIOS               */
#define  EXTSCAN_ALTF21 0xE4          /* Alt F21 ENHANCED BIOS               */
#define  EXTSCAN_ALTF22 0xE5          /* Alt F22 ENHANCED BIOS               */
#define  EXTSCAN_ALTF23 0xE6          /* Alt F23 ENHANCED BIOS               */
#define  EXTSCAN_ALTF24 0xE7          /* Alt F24 ENHANCED BIOS               */
#define  EXTSCAN_CLEAR 0xFB           /* CLEAR ENHANCED BIOS                 */
#define  EXTSCAN_SHIFTCLEAR 0xFB      /* SHIFT CLEAR ENHANCED BIOS           */
#define  EXTSCAN_CTRLCLEAR 0xFC       /* CTRL CLEAR ENHANCED BIOS            */
#define  EXTSCAN_ALTCLEAR 0xFD        /* ALT CLEAR ENHANCED BIOS             */
#define  EXTSCAN_ERASEEOF 0xF0        /* ERASEEOF ENHANCED BIOS              */
#define  EXTSCAN_SHIFTEEOF 0xF1       /* SHIFTEEOF ENHANCED BIOS             */
#define  EXTSCAN_CTRLEEOF 0xF2        /* CTRLEEOF ENHANCED BIOS              */
#define  EXTSCAN_ALTEEOF 0xF3         /* ALTEEOF ENHANCED BIOS               */
#define  EXTSCAN_PA1   0xE8           /* PA1 ENHANCED BIOS                   */
#define  EXTSCAN_SHIFTPA1 0xE9        /* SHIFT PA1 ENHANCED BIOS             */
#define  EXTSCAN_CTRLPA1 0xEA         /* CTRL PA1 ENHANCED BIOS              */
#define  EXTSCAN_ALTPA1 0xEB          /* ALT PA1 ENHANCED BIOS               */

/*
**    Private Function Prototypes
*/

/*
** File: vkbd.c
*/
BOOL EXPENTRY VDDInit(PSZ);

BOOL HOOKENTRY VKExit(VOID);
BOOL HOOKENTRY VKCreateVDM(HVDM);
BOOL HOOKENTRY VKTerminateVDM(HVDM);
BOOL HOOKENTRY VKSetFgnd(HVDM);
BOOL HOOKENTRY VKSetBgnd(HVDM);
BOOL HOOKENTRY VKSetCodePage(ULONG);
BOOL PRIVENTRY vkCreateRX(ULONG,PPCPENTRY);
VOID PRIVENTRY vkDestroyRX(PCPENTRY);
ULONG EXPENTRY VKSetExtraKeys(ULONG,HVDM,ULONG,PCHAR);
ULONG EXPENTRY VKSetFastPaste(ULONG,HVDM,ULONG,PCHAR);
ULONG EXPENTRY VKSetKbdRestrict(ULONG,HVDM,ULONG,PCHAR);

ULONG EXPENTRY VKAltHome(ULONG,HVDM,ULONG,PCHAR);
ULONG EXPENTRY VKHotKeyBypass(ULONG,HVDM,ULONG,PCHAR);
PCHAR PASCAL VKgetTheValue(PCHAR,ULONG,PULONG);
VOID VDHENTRY VDHRegisterScreenProc(PFNSCRNP);
USHORT VDHENTRY VDHQueryKeyShift(HVDM);

/*
** File: vkbdint.c
*/
SBOOL VDDENTRY VKPDDProc(ULONG,F16PVOID,F16PVOID);
VOID HOOKENTRY VKPasteTimeout(PVOID,PCRF);
VOID HOOKENTRY VKHotPlugEvent(PHVDM,PCRF);
VOID PRIVENTRY VKKbdChanged(HVDM,ULONG);
VOID HOOKENTRY VKIntEvent(ULONG,PCRF);
VOID HOOKENTRY VKEOIProc(PCRF);
VOID HOOKENTRY VKIRETProc(PCRF);
BOOL HOOKENTRY VKInt09Proc(PCRF);
VOID HOOKENTRY VKInt09PostInt15(PVOID,PCRF);
BOOL PRIVENTRY VKInt09Translate(PCRF,PKKEY);
VOID HOOKENTRY VKInt09PauseReturn(PVOID,PCRF);
VOID HOOKENTRY VKInt09PostBreak(PVOID,PCRF);
VOID HOOKENTRY VKInt09PostPrtSc(PVOID,PCRF);
VOID HOOKENTRY VKInt09PostSysReq(PVOID,PCRF);
VOID PRIVENTRY VKInt09Complete(PCRF);
VOID PRIVENTRY VKInt09IntRet(PCRF);
VOID HOOKENTRY VKInt09PostIntReturn(PVOID,PCRF);
VOID PRIVENTRY VKInt09Return(PCRF);
VOID PRIVENTRY VKDisableKbd(VOID);
VOID PRIVENTRY VKUpdateLEDs(HVDM);
VOID PRIVENTRY VKEnableKbd(VOID);
BOOL HOOKENTRY VKInt16Proc(PCRF);
VOID PRIVENTRY VKInt16PostVDD(ULONG);
VOID HOOKENTRY VKInt16ProcReturn(PVOID,PCRF);
USHORT PRIVENTRY VKGetEnhancedShift(HVDM);
VOID PRIVENTRY VKPutEnhancedShift(PKKEY);
VOID PRIVENTRY VKModifyNormalKey(PKKEY);

/*
** File: vkbdbuf.c
*/
PKEYPKT PRIVENTRY VKNextScanPtr(PKEYPKT);
PKEYPKT PRIVENTRY VKPrevScanPtr(PKEYPKT);
BOOL PRIVENTRY VKAddScan(HVDM,PKEYPKT,ULONG);
RETCODE PRIVENTRY VKPeekScan(HVDM);
BYTE PRIVENTRY VKRemoveScan(HVDM,BOOL);
VOID PRIVENTRY VKClearScan(HVDM);
VOID HOOKENTRY VKTransferScanHook(PHVDM,PCRF);
VOID HOOKENTRY VKTransferScan(HVDM,BOOL);
VOID PRIVENTRY VKSimulateInt(HVDM);
BOOL PRIVENTRY VKAddKey(HVDM,UCHAR,UCHAR);
USHORT PRIVENTRY VKNextKeyPtr(HVDM,USHORT);
VOID PRIVENTRY VKClearKeys(HVDM);
BOOL PRIVENTRY VKAddExtraKey(HVDM,UCHAR,UCHAR);
ULONG PRIVENTRY VKNextExtraKeyPtr(ULONG);
VOID PRIVENTRY VKTransferExtraKey(VOID);

/*
** File: vkbdreq.c
*/
LONG EXPENTRY VKSysReqProc(SGID,ULONG,ULONG,PVOID,ULONG,PVOID);
LONG PRIVENTRY vkSysSetAccess(HVDM,BOOL,PVOID,ULONG,PVOID);
VOID PRIVENTRY vkSysAddExpandScan(HVDM,UCHAR);
VOID PRIVENTRY vkSysXferExpandScan(HVDM);
VOID PRIVENTRY vkSysSyncShift(HVDM,USHORT,USHORT);
LONG PRIVENTRY vkSysSetFocus(HVDM,ULONG,PSHIFTPKT,ULONG,PVOID);
VOID PRIVENTRY vkSysEndPaste(HVDM);
LONG PRIVENTRY vkSysPostScan(HVDM,ULONG,PKEYPKT,ULONG,PULONG);
VOID PRIVENTRY vkSysSimCtrlAltUps(HVDM,PUSHORT);
VOID PRIVENTRY vkSysAddNumScans(HVDM,UCHAR);
VOID PRIVENTRY vkSysReverseXlate(HVDM,UCHAR,PUSHORT);
LONG PRIVENTRY vkSysPostChar(HVDM,ULONG,PUCHAR,ULONG,PULONG);

/*
** File: vkbdio.c
*/
BYTE HOOKENTRY VKReadCmd(ULONG,PCRF);
VOID HOOKENTRY VKWriteCmd(BYTE,ULONG,PCRF);
BYTE HOOKENTRY VKReadBuff(ULONG,PCRF);
VOID HOOKENTRY VKWriteBuff(BYTE,ULONG,PCRF);
VOID PRIVENTRY VKCheckKbdCmd(BYTE);

/*
** File: vpol.c   polling detection initialization and creation
*/
RETCODE NEAR PASCAL VPLCreate(HVDM);
VOID NEAR PASCAL VPLInit(VOID);
VOID VDHENTRY VDHNoIdle(HVDM,ULONG); 

/*
**   If VDDSTRICT is defined, the Assert macros generate appropriate code.
**
**   If VDDSTRICT is not defined, the Assert macros are NO-OPs (with the
**   exception of AssertRC, in which case the function is still called, but
**   the return code is not checked).
**
**   If VDDDEBUG is defined, debug printfs (PRINTDEBUGs) are generated, and
**   failed assertions (assuming VDDSTRICT is defined) break at the assertion
**   rather than in the kernel's "panic" service.  VDDDEBUG requires the
**   kernel debugger, in other words.
**
**   If VDDDEBUG is not defined, debug printfs (PRINTDEBUGs) are NOT
**   generated, and failed assertions (assuming VDDSTRICT is defined) simply
**   panics.
*/

#ifdef   VDDSTRICT

/*
** c-begin
*/

extern CHAR szAssertMsg[];
#define MODNAME static CHAR szFile[]

#ifdef VDDDEBUG
#define Assert(t) { \
                    if (!(t)) { \
                      PRINTDEBUG(szAssertMsg, szFile, __LINE__); \
                      INT3(); \
                    } \
                  }
#else
#define Assert(t) { \
                    if (!(t)) { \
                      PANIC(szAssertMsg, szFile, __LINE__); \
                    } \
                  }
#endif

#define AssertTRUE(t)   Assert(t)
#define AssertFALSE(t)  Assert(!(t))
#define AssertZERO(t)   Assert(!(t))
#define AssertNONZERO(t)Assert(t)
#define AssertRC(t)     Assert(t)       /* verify function return code good */

/*
** c-end
*/

#else

/*
** c-begin
*/

#define     Assert(t)
  #define  AssertTRUE(t)
  #define  AssertFALSE(t)
  #define  AssertZERO(t)
  #define  AssertNONZERO(t)
  #define  AssertRC(t)   (t)        /* perform function, but don't verify   */

/*
** c-end
*/

#endif

/*
** Random debugging support
*/

#ifdef   VDDDEBUG

/*
** c-begin
*/

extern CHAR szModule[];
   #undef   PRINTDEBUG
   #define  PRINTDEBUG    printf(szModule);                                 \
                          printf
/*
** c-end
*/
#endif
