/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = VFINIT.C
 *
 * DESCRIPTIVE NAME = Virtual Floppy Device Driver Initialization
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION  This module contains the VFD's initialization code.
 *
 *
 * FUNCTIONS        VDDInit
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#include "vfdp.h"

#ifdef   VDDSTRICT
MODNAME = __FILE__;
#endif
#pragma  BEGIN_GLOBAL_DATA
extern HHOOK hhookctxtFlpyIntr;                         /* context hook
                                                           handle for
                                                           floppy intr      */
extern HVDD hVDDVPIC;                                   /* VDDtoVdd comm to
                                                           VPIC             */
                                                         /* @VD1535         */

extern HVDHSEM hsemFloppyOwnership;                     /* Block
                                                           simultaneous
                                                           VDMs             */
                                                         /* @VD1535         */

extern PHVDHSEM phsemFloppyOwnership;                   /* pointer to sem
                                                           handle           */
                                                         /* @VD1535         */

#pragma  END_GLOBAL_DATA
#pragma  BEGIN_SWAP_DATA

/* @VD1535     extern  FPFNPDD fpfnPFDProc;   16:32 PDD entry point */

extern HIRQ hirq;                                       /* floppy IRQ
                                                           handle           */
extern HHOOK hhookvirrWaitPFD;                          /* VIRR hook handle
                                                           for waiting PFD  */
extern HHOOK hhooktimerInUseTimeout;                    /* timer hook
                                                           handle for inuse
                                                           timeout          */
extern HHOOK hhookDsktMotorTmr;                         /* Dskt motor
                                                           TimeOut          */
                                                         /* @V0855          */

#pragma  END_SWAP_DATA
#pragma  BEGIN_INSTANCE_DATA
extern HHOOK hhookctxtMotorResume;                      /* hook to Resume
                                                           from MotorOff    */
                                                        /* @VD1535          */

                                                        /* @V3516           */

#pragma  END_INSTANCE_DATA
#pragma  BEGIN_SWAP_INSTANCE
#pragma  END_SWAP_INSTANCE
#pragma  BEGIN_INIT_CODE

/****************************************************************************
 *
 * FUNCTION NAME = VDDInit
 *
 * DESCRIPTION   =
 *
 *     EP  VDDInit() - VFD initialization
 *
 *  This routine is defined as the device driver entry point, and
 *  is called during system initialization (also known as VDD-init time).
 *
 *  ENTRY
 *      None
 *  EXIT
 *      SUCCESS
 *          TRUE
 *      FAILURE
 *          FALSE (ie, register with VIRQ failed)
 *  USES
 *      32-bit small-model PASCAL calling/register conventions
 *
 *  CONTEXT
 *      System initialization (specifically, VDD-init time)
 *
 *  PCODE
 *      register with PDD;
 *      if success
 *          register exit hooks;
 *          register VIRQ with EOIProc;
 *          allocation context hook and timer hook;
 *          if success
 *              register DMA channel;
 *              register creation and termination hooks;
 *              return TRUE;
 *          endif;
 *      else
 *          register unsupport creation hook;
 *          register unsupport vdd request hook;
 *          return TRUE;
 *      endif
 *      return FALSE;
 *
 * INPUT         = (register PSZ pszInit)
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

BOOL EXPENTRY VDDInit(register PSZ pszInit)
{
  register BOOL fSuccess = FALSE;
  VDHInstallUserHook(VDD_EXIT,
                     VFExit);
  hirq = VDHOpenVIRQ(FLPY_IRQ,
                     VFEOIProc,
                     NULL,
                     VPIC_NOIRETHOOK_TIMEOUT,
                     (VDHQuerySysValue(CURRENT_VDM,
                                       VDHGSV_MACHINETYPE) == MACHINE_TYPE_AT)
                                          ?!VPIC_SHARE_IRQ:VPIC_SHARE_IRQ);

  if (hirq &&

/*
** @V3516
*/
/*
**   (hhhookctxtMotorResume = VDHAllocHook(VDH_CONTEXT_HOOK,
**                                         VFVDDResume,
**                                         sizeof(HVDM))) &&
*/

     (hhooktimerInUseTimeout = VDHAllocHook(VDH_TIMER_HOOK,
                                            VFClearInUse,
                                            0)) && (hhookDsktMotorTmr =
                                            VDHAllocHook(VDH_TIMER_HOOK, /* @V0855          */
                                                         VFVDDMotorOff,  /* @V0855          */
                                                         0)))
  {
    VDHRegisterDMAChannel(FLPY_DMA,
                          (PFNDMA)VFDMAMaskEvent);
    VDHInstallUserHook(VDM_CREATE,
                       VFCreate);
    VDHInstallUserHook(VDM_TERMINATE,
                       VFTerminate);
    fSuccess = TRUE;
  }
  VDHCreateSem(phsemFloppyOwnership,
               VDH_MUTEXSEM);                           /* Allocate a sem
                                                           handle for
                                                           simultaneous VDMs */
                                                        /* @VD1535           */

  VDHRegisterVDD(VFLPY_NAME,
                 NULL,
                 VFVDDReqProc);                         /* @@VD1809          */
  return  fSuccess;
}                                                       /* VDDInit           */
#pragma  END_INIT_CODE
