;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;       SCCSID = @(#)vcominit.asm       6.6 92/01/30

        Page    ,132
        NAME    VCOM
        TITLE   VCOM     - Virtual COM device driver
        SUBTTL  VCOMINIT.ASM - VCOM Initialization routine
; ****************************************************************************
; *                                                                          *
; *                                                                          *
; *                                                                          *
; ****************************************************************************

;;;;;;;;;;;;;;;;;;;;;;; START OF FILE SPECIFICATION ;;;;;;;;;;;;;;;;;;;;;;;;;;
;SOURCE FILE NAME: VCOMINIT.ASM
;
;DESCRIPTIVE NAME: VCOM Initialization routine
;
;FUNCTION:
;       Initialize VCOM at the request of VDMM at system initialization time
;
;SUBROUTINES:
;       VCOM_Init
;
;EXTERNAL REFERENCES:
;       VDHOpenVIRQ
;       VDHOpenPDD
;       VDHInstallUserHook
;       VDHQuerySel
;
;;;;;;;;;;;;;;;;;;;;;;; END OF FILE SPECIFICATION ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;       Jin Kim
;       Yoshihiko Nishida
;       Allen C. Wynn
;       (c) International Business Machines Corporation
;       January 1989
;
;Modification History
;
; @59629 3/29/93  J.W. Krier  Add ComRxBufferFlush Dos Property
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        .386p

.xlist
include STRUC.INC
include VCOM.INC
include mvdm.inc
include propname.inc    ;CP20D1390
.list

include VDDSEG.INC
include VCOMDATA.INC

public VCOM_Init

DefCode     IMPORT,INIT,PASCAL              ;start _INITTEXT segment
     DefFn   VDHOpenVIRQ                    ;Import definitions
     DefFn   VDHOpenPDD
     DefFn   VDHInstallUserHook
     DefFn   VDHQuerySel
     DefFn   VCOM_PCOMNotify
     DefFn   VCOM_VDMCreation
     DefFn   VCOM_VDMTermination
     DefFn   VCOM_PDBDestroy
     DefFn   VCOM_PDBChange
     DefFn   VCOM_VDMForeground             ;@59629
     DefFn   VCOM_Hold_Res
     DefFn   VCOM_Rx_Flush                  ;@59629
     DefFn   VCOM_HW_COM
     DefFn   VCOM_COM_SELECT
     DefFn   VDHRegisterProperty
     DefFn   VCOM_VPMBegin                  ;@95743

EndCode                                    ;end _INITTEXT segment

DefCode     PRIVATE,INIT,PASCAL              ;start _INITTEXT segment
                                            ;actual code

;********************** START OF SPECIFICATIONS ******************************
;SUBROUTINE NAME: VCOM_Init
;
;DESCRIPTIVE NAME: VCOM initialization routine
;
;INPUT:
;       pointer to string that follows DEVICE=VCOM.SYS in CONFIG.SYS
;
;OUTPUT:
;       Success: EAX != 0  (VDH_SUCCESS = 1)
;       Failure: EAX  = 0  (VDH_FAILURE = 0)
;
;RELATED DATA OBJECTS:
;  Instance Data per VDM:
;         None
;  Global Data:
;         sel_glbData
;         off_PICOMS
;         PCOMEntry
;         PI (Port_Info_Tab)
;  Initialization Data
;         Generic_Name
;         PDD_Init_Info
;         off_PCOMEntry
;         off_PDD_Init_Info
;         sel_InitData
;
;
;
;FUNCTION:
;       This routine is called at the system initialization time by
;       the VDM manager.
;       This routine performs the following functions:
;
;         Set hooks for VDM events ( VDHInstallUserHook )
;         Establish communications with PCOM ( VDHOpenPDD )
;         Save ROM BIOS 40:0 COM port information (from PCOM) into PI
;         Register the IRQ 3 and/or IRQ 4 for hardware interrupt simulation
;          (VDHOpenVIRQ)
;
;CALLED BY:
;       VDMM at System Init time
;
;INTERNAL REFERENCES:
;       VCOM_PCOMNotify
;       VCOM_VDMCreation
;       VCOM_VDMTermination
;       VCOM_PDBDestroy
;       VCOM_PDBChange
;       VCOM_VPMBegin                                        @95743
;
;EXTERNAL REFERENCES:
;       VDHInstallUserHook
;       VDHOpenPDD
;       VDHOpenVIRQ
;       VDHQuerySel
;
;NOTE:
;
;********************** END OF SPECIFICATIONS *********************************

VCOM_Init       proc    near             ; 


        push    ebx                      ; Save registers for VDMM
        push    edi
        push    esi
        push    ebp

        mov     eax,VDM_TERMINATE                ; Hook for
        lea     ebx,VCOM_VDMTermination          ; VDM Termination Event
        CallFn VDHInstallUserHook,<eax,ebx>     ; 
        .if <eax eq VDH_FAILURE>                 ; If fails
            jmp Init_Fail                        ;  then exit
        .endif

        mov     eax,VDM_FOREGROUND               ; Hook for     ;@59629
        lea     ebx,VCOM_VDMForeground           ; VDM Foreground Event
        CallFn VDHInstallUserHook,<eax,ebx>      ;              ;@59629
        .if <eax eq VDH_FAILURE>                 ; If fails     ;@59629
            jmp Init_Fail                        ;  then exit   ;@59629
        .endif

        mov     eax,VDM_CREATE                   ; Hook for
        lea     ebx,VCOM_VDMCreation             ; VDM Creation Event
        CallFn VDHInstallUserHook,<eax,ebx>     ; 
        .if <eax eq VDH_FAILURE>                 ; If fails
            jmp Init_Fail                        ;  then exit
        .endif

        mov     eax,VDM_PDB_CHANGE               ; Hook for
        lea     ebx,VCOM_PDBCHANGE               ; PDB change Event
        CallFn VDHInstallUserHook,<eax,ebx>     ; 
        .if <eax eq VDH_FAILURE>                 ; If fails
            jmp Init_Fail                        ;  then exit
        .endif

        mov     eax,VDM_PDB_DESTROY              ; Hook for
        lea     ebx,VCOM_PDBDestroy              ; App termination Event
        CallFn VDHInstallUserHook,<eax,ebx>     ; 
        .if <eax eq VDH_FAILURE>                 ; If fails
            jmp Init_Fail                        ;  then exit
        .endif

        mov     eax,VDM_BEGIN_VPM_TASK           ; Hook for           @95743
        lea     ebx,VCOM_VPMBegin                ; protect mode begin @95743
        CallFn VDHInstallUserHook,<eax,ebx>      ;                    @95743
        .if <eax eq VDH_FAILURE>                 ; If fails           @95743
            jmp Init_Fail                        ;  then exit         @95743
        .endif

        lea     eax, Generic_Name        ;"COM",0 name of device to open.
        lea     ebx, VCOM_PCOMNotify     ;Our entry point for PCOM

        push    eax
        push    cs
        push    ebx
        call VDHOpenPDD                  ;Can't use "CallFn" macro

        .if <dx eq VDH_FAILURE>          ;If a zero selector was returned
            jmp Init_Fail                ; then call failed
        .endif

        lea ebx,PCOMEntry
        mov DWORD PTR [ebx].Offst32, eax        ;Set offset of PCOM's entry
        mov WORD PTR [ebx].Segmt32, dx          ;Set segment of PCOM's entry

        lea     esi,PI                          ; linear addr to PI
        CallFn VDHQuerySel,<esi>                ; 
        .if <eax eq VDH_FAILURE>                ; If fails
            jmp     Init_Fail                   ;     Jump to Init_Fail
        .endif                                  ; 

        mov     sel_glbDATA, ax              ;Set GDT selector for _DATA

        push    ebx
        .for    ebx = 0 to ((MAXNUMPORT-1)*2) by 2
            mov     off_PICOMS[ebx], si     ;Set 16 bit offset for each comport
            add     si, size Port_Info_Tab
        .next   ebx                        ;and try again (DX is incremented)
        pop     ebx

        lea     esi, PCOMEntry                  ; linear addr to PCOMENTRY
        CallFn VDHQuerySel,<esi>                ; 
        .if <eax eq VDH_FAILURE>                ; If fails
            jmp     Init_Fail                   ;     Jump to Init_Fail
        .endif                                  ; 
        mov     sel_PCOMEntry, ax

        lea     esi, PDD_Init_Info              ; linear addr to PI
        CallFn VDHQuerySel,<esi>                ; 
        .if <eax eq VDH_FAILURE>                ; If fails
            jmp     Init_Fail                   ;     Jump to Init_Fail
        .endif                                  ; 
        mov     sel_InitData, ax

        mov     off_PDD_Init_Info, si        ;Initialization input pkt
        lea     esi, PCOMEntry               ;16 bit offset for PCOMEntry
        mov     off_PCOMEntry, si

        mov     esi, GETREGISTERENTRY            ;function to get init_info
        push    esi                              ;and register based entry

        push    sel_PCOMEntry                    ;offset:sel for PCOMEntry
        push    off_PCOMEntry                    ;(returns register based
                                                 ; entry point)
        push    sel_InitData                     ;offset:sel for
        push    off_PDD_Init_Info                ;initialization data pkt

        call    PCOMEntry

        .if <PDD_Init_Info.PPI_NumPorts eq 0>    ;If PCOM is supporting
            jmp     Init_Fail                    ;zero ports, then just
        .endif                                   ;return failure


        lea     esi, PI                          ;ESI -> PI for COM1
        lea     ebx, PDD_Init_Info.PPI_PortAddr  ;EBX -> PCOM supported coms

        .for    edi = 0 to ((MAXNUMPORT-1)*2) by 2
            mov dx,[ebx+edi]             ; Get the port address
            .if <dx ne 0>
            mov [esi].Port_Addr, dx

                xor     eax,eax
                mov     al,[ebx+edi+MAXNUMPORT*2] ; Get the irq level
                .if <al eq 0>
                   .if <dx eq IRQ4_ADDR>    ; 3F8h = IRQ4
                       mov  eax, IRQ4
                   .else
                       mov  eax, IRQ3
                   .endif
                .endif
                mov     [esi].IRQ_Level,al
                mov     ecx,VPIC_SHARE_IRQ
                CallFn VDHOpenVIRQ, <eax,0,0,-1,ecx>
                .if <eax eq VDH_FAILURE>
                    jmp Init_Fail
                .endif
                mov     [esi].hIRQ_PI, eax  ;hIRQ returned in EAX
            .endif
            add esi, size Port_Info_Tab
        .next edi

        mov     eax,VDH_SUCCESS          ; Set eax = SUCCESS

        ;CP20D1390 Register Hold COM Resource DOS Property
        ;          - Creation Only,OFF as default
        mov     eax, OFFSET FLAT:szPropHoldRes
        mov     ecx, OFFSET FLAT:VCOM_Hold_Res
        CallFn  VDHRegisterProperty    <eax,0,0,0,0,VDMP_CREATE,0,0,ecx>


        ;CP20D1607 Register Hardware COM DOS Property
        ;          - Creation Only,OFF as default
        mov     eax, OFFSET FLAT:szPropHardwareCOM
        mov     ecx, OFFSET FLAT:VCOM_HW_COM
        CallFn  VDHRegisterProperty    <eax,0,0,0,0,VDMP_CREATE,0,0,ecx>


        ;@59629 Register Rx Buffer Flush Property
        ;          - Creation Only, OFF as default              ;@59629
        mov     eax, OFFSET FLAT:szPropRxFlush                  ;@59629
        mov     ecx, OFFSET FLAT:VCOM_Rx_Flush                  ;@59629
        mov     ebx, OFFSET FLAT:szRxFlushList                  ;@59629
        mov     edx, OFFSET FLAT:pchNone                        ;@59629
        CallFn  VDHRegisterProperty    <eax,0,0,VDMP_ENUM,VDMP_ORD_OTHER,VDMP_CREATE,edx,ebx,ecx>


        ;CP20D1608 Register COM Select DOS Property
        ;          - Creation Only,OFF as default
        mov     eax, OFFSET FLAT:szPropCOMSelect
        mov     ecx, OFFSET FLAT:VCOM_COM_SELECT
        mov     ebx, OFFSET FLAT:szCOMList
        mov     edx, OFFSET FLAT:pchAll
        CallFn  VDHRegisterProperty    <eax,0,0,VDMP_ENUM,VDMP_ORD_OTHER,VDMP_CREATE,edx,ebx,ecx>

        mov     eax,VDH_SUCCESS          ; Set eax = SUCCESS
        jmp     short Init_Ret           ; Return

Init_Fail:                               ; Initialization Failure Handling
        mov     eax, VDH_FAILURE         ; Return failure in EAX
Init_Ret:
        pop     ebp
        pop     esi
        pop     edi
        pop     ebx
        ret     4

VCOM_Init       endp

EndCode                                    ;end _INITTEXT segment
          END  VCOM_Init
