;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;       SCCSID = @(#)vcomdata.inc       6.7 91/08/29
; ****************************************************************************
; *                                                                          *
; *                                                                          *
; *                                                                          *
; ****************************************************************************

;;;;;;;;;;;;;;;;;;;;;;; START OF FILE SPECIFICATION ;;;;;;;;;;;;;;;;;;;;;;;;;;
;SOURCE FILE NAME: VCOMDATA.INC
;
;DESCRIPTIVE NAME: EXTRN statements for Data items for VCOM
;
;FUNCTION:
;       This file contains all EXTRN's for data needed for VCOM.
;
;NOTES:
;      VCOMDATA.ASM contains the data declarations
;
;
;;;;;;;;;;;;;;;;;;;;;;; END OF FILE SPECIFICATION ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;       Jin Kim
;       Yoshihiko Nishida
;       Allen C. Wynn
;       (c) International Business Machines Corporation
;       January 1989
;
;Modification History
;
;@59629  3/29/93  J.W. Krier  Add Rx Buffer Flush DosProperty
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                  Global  data starts here...                        ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

DefData IMPORT,GLOBAL,PASCAL                ;Start _DATA segment

    ;Port Info Table
        EXTRN    PI:BYTE

EndData                                     ;End _DATA segmenet


DefData IMPORT,SWAP,PASCAL                ;Start CSWAP_DATA segment

    ;16:16 value for PCOM's IOCTL function.
        _WORD   sel_glbDATA        ;GDT selector for our DATA segment
    ;16 bit offset table of PI for PCOM's use
        EXTRN   off_PICOMS:WORD

    ;For VDHIntallIOHook.  IN/OUT hook entry points.
        EXTRN   IOHook:DWORD
        EXTRN   PCOMEntry:FWORD

        EXTRN   In_Jmp_Tab:DWORD
        EXTRN   Int14_Jump_Tab:DWORD
        EXTRN   VCOM_VxD_Service_Table:DWORD
        EXTRN   VCOM_ExtFn_Table:DWORD
        EXTRN   BaudTbl:WORD

        EXTRN   szPropHoldRes:BYTE          ;CP20D1390
        EXTRN   szPropRxFlush:BYTE          ;@59629
        EXTRN   szPropHardwareCOM:BYTE      ; 
        EXTRN   szPropCOMSelect:BYTE        ; 
        EXTRN   szCOMList:BYTE              ; 
        EXTRN   szRxFlushList:BYTE          ;@59629
        EXTRN   pchAll:BYTE                 ; 
        EXTRN   pchNone:BYTE                ; 
        EXTRN   szVCOM:BYTE                 ; 
EndData                                     ;End CSWAP_DATA segmenet





;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                 Instance data starts here...                        ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

DefData IMPORT,SWAPINST,PASCAL          ;Start SWAP_INST segment
                                        ;imported items
    HHOOK  hhookInt2fBPHook             ;@95743
    HHOOK  hhookVxDServiceBPHook        ;@95743
    FPFN   fpfnOldInt2f                 ;@95743
    FPFN   fpfnInt2fHandler             ;@95743
    FPFN   fpfnVxDServiceRouter         ;@95743

    HHOOK  hhookInt14ReturnHook
    _DWORD       ihVDM                  ;handle for this VDM
    HVDHSEM      ihComSem               ;Semaphore for this VDM
    VDHSEMSTATE  iSemState              ;Structure to query sema4 state
    _DWORD  Response_Num                ;for VDHPopUp
    _DWORD  hHook_Timeout
    _WORD        ipdbCurrent            ;current PDB
    _WORD        iflgIgnore             ;Ignore flag for each port
                                        ;Bit 0=COM1, bit 1=COM2, bit 2=COM3
    _WORD        iClients_DX


        EXTRN   Subst_String_Tabl:BYTE
        EXTRN   Subst_Num:BYTE

    _BYTE  iSaveInt14Cmd
    _BYTE  iInt14h_Complete
    _BYTE  iIOHooksDone
    _BYTE  iCreateSemDone

        EXTRN   szVMBoot:BYTE
    _BYTE  iDOSProp                     ;CP20D1390
    _BYTE  iData                        ; 
    _WORD  iPortAddr                    ; 

    _DWORD      VCOM_VXD_MSRshadow      ;array of shadow locations
    _DWORD      VCOM_VXD_MSRshadow2
    _DWORD      VCOM_VXD_MSRshadow3
    _DWORD      VCOM_VXD_MSRshadow4

     _WORD   Events                     ;Event
     _WORD   Events2
     _WORD   Events3
     _WORD   Events4

     _WORD   EventMask                  ;Event Masks
     _WORD   EventMask2
     _WORD   EventMask3
     _WORD   EventMask4

     _DWORD  EventPtr                   ;ptr to Event Flags
     _DWORD  EventPtr2
     _DWORD  EventPtr3
     _DWORD  EventPtr4

        EXTRN   PDCD:BYTE
        EXTRN   PSTAT:BYTE

EndData                                     ;End SWAP_INST segment








;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;               Initialization data starts here...                    ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

DefData IMPORT,INIT,PASCAL                  ;Start _INITDATA segment

         EXTRN  PDD_Init_Info:WORD
         _WORD  sel_PCOMEntry
         _WORD  off_PCOMEntry
         _WORD  off_PDD_Init_Info
         _WORD  sel_InitData

    ;ASCIIZ name of the registered PCOM
        _BYTE Generic_Name
        _BYTE G_N_PAD

EndData                                     ;End _INITDATA segment
