;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;       SCCSID = @(#)vcomdata.asm       6.10 92/02/06

        Page    ,132
        NAME    VCOM
        TITLE   VCOM         - Virtual COM device driver
        SUBTTL  VCOMDATA.ASM - Data for VCOM
; ****************************************************************************
; *                                                                          *
; *                                                                          *
; *                                                                          *
; ****************************************************************************

;;;;;;;;;;;;;;;;;;;;;;; START OF FILE SPECIFICATION ;;;;;;;;;;;;;;;;;;;;;;;;;;
;SOURCE FILE NAME: VCOMDATA.ASM
;
;DESCRIPTIVE NAME: Data segments for VCOM
;
;FUNCTION:
;       This file contains all data needed for VCOM.  Data needs to be
;       in this (separate) file in order to force things to be
;       relocatable.
;
;NOTES:
;      VCOMDATA.INC contains the EXTRN statments needed by any module
;      that will need to use this data
;
;
;;;;;;;;;;;;;;;;;;;;;;; END OF FILE SPECIFICATION ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;       Jin Kim
;       Yoshihiko Nishida
;       Allen C. Wynn
;       (c) International Business Machines Corporation
;       January 1989
;
;Modification History
;
; @59629 3/29/93 J.W. Krier  Add Rx Buffer Flush DosProperty

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        .386p
.xlist
include mvdm.inc
include VCOM.INC
include VDDSEG.INC
include propname.INC
.list



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                  Global  data starts here...                        ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


        EXTRN   DLL_Handler:near
        EXTRN   DLM_Handler:near
        EXTRN   IIR_Handler:near
        EXTRN   LCR_Handler:near
        EXTRN   MCR_Handler:near
        EXTRN   LSR_Handler:near
        EXTRN   MSR_Handler:near
        EXTRN   SCR_Handler:near
        EXTRN   RBR_Handler:near
        EXTRN   THR_Handler:near
        EXTRN   IER_Handler:near
        EXTRN   XXR_Handler:near
        EXTRN   XLR_Handler:near

;NOTE: The following functions should be uppercase because the
;      macro DefFn forces them to uppercase on the define.

        EXTRN   VCOM_PORTIN:near
        EXTRN   VCOM_PORTOUT:near
        EXTRN   VCOM_INT14H:near
        EXTRN   INT14H_INIT:near
        EXTRN   INT14H_RX:near
        EXTRN   INT14H_TX:near
        EXTRN   INT14H_STATUS:near
        EXTRN   INT14H_XCTL:near
        EXTRN   INT14H_XINIT:near

        EXTRN  VCOM_OpenCom:near
        EXTRN  VCOM_SetCom:near
        EXTRN  VCOM_Setup:near
        EXTRN  VCOM_ctx:near
        EXTRN  VCOM_TrmCom:near
        EXTRN  VCOM_StaCom:near
        EXTRN  VCOM_ExtFn:near
        EXTRN  VCOM_Flush:near
        EXTRN  VCOM_cevt:near
        EXTRN  VCOM_cevtGet:near
        EXTRN  VCOM_SetMSRShadow:near
        EXTRN  VCOM_WriteString:near
        EXTRN  VCOM_ReadString:near
        EXTRN  VCOM_EnableNotify:near

        EXTRN  VCOM_ExtFn_SETXOFF:near
        EXTRN  VCOM_ExtFn_SETXON:near
        EXTRN  VCOM_ExtFn_SETRTS:near
        EXTRN  VCOM_ExtFn_CLRRTS:near
        EXTRN  VCOM_ExtFn_SETDTR:near
        EXTRN  VCOM_ExtFn_CLRDTR:near
        EXTRN  VCOM_ExtFn_SETBRK:near
        EXTRN  VCOM_ExtFn_CLRBRK:near
        EXTRN  VCOM_ExtFn_UnSupported:near
        EXTRN  VCOM_ExtFn_Return:near


DefData EXPORT,GLOBAL,PASCAL                ;Start _DATA segment
    ;PI must be the first item in segment!!!  It is used a lot and
    ;should be aligned on 32-bit boundary .  This way it is sure
    ;to be aligned.

    ;Port Info Table
        PI      Port_Info_Tab MAXNUMPORT dup (<>)   ;This must be the first
                                                    ;item in segment!!!
        public  PI
EndData                                     ;End _DATA segmenet



DefData EXPORT,SWAP,PASCAL                ;Start CSWAP_DATA segment

    ;For VDHIntallIOHook.  IN/OUT hook entry points.
        public  IOHook
        IOHook  dd      VCOM_PORTIN       ;Byte IN entry point
                dd      VCOM_PORTOUT      ;Byte OUT entry point
                dd      0                 ;WORD IN entry point
                dd      0                 ;WORD OUT entry point
                dd      0                 ;Other

        public      In_Jmp_Tab
        In_Jmp_Tab  dd      DLL_Handler
                    dd      DLM_Handler
                    dd      IIR_Handler
                    dd      LCR_Handler
                    dd      MCR_Handler
                    dd      LSR_Handler
                    dd      MSR_Handler
                    dd      SCR_Handler
                    dd      RBR_Handler
                    dd      THR_Handler
                    dd      IER_Handler
                    dd      XXR_Handler
                    dd      XLR_Handler

        public      Int14_Jump_Tab
        Int14_Jump_Tab  dd  INT14H_INIT
                        dd  INT14H_TX
                        dd  INT14H_RX
                        dd  INT14H_STATUS
                        dd  INT14H_XINIT
                        dd  INT14H_XCTL

        public  VCOM_VxD_Service_Table
VCOM_VxD_Service_Table  dd     VCOM_OpenCom
                        dd     VCOM_SetCom
                        dd     VCOM_Setup
                        dd     VCOM_ctx
                        dd     VCOM_TrmCom
                        dd     VCOM_StaCom
                        dd     VCOM_ExtFn
                        dd     VCOM_Flush
                        dd     VCOM_cevt
                        dd     VCOM_cevtGet
                        dd     VCOM_SetMSRShadow
                        dd     VCOM_WriteString
                        dd     VCOM_ReadString
                        dd     VCOM_EnableNotify

        public  VCOM_ExtFn_Table
VCOM_ExtFn_Table        dd     VCOM_ExtFn_UnSupported
                        dd     VCOM_ExtFn_SETXOFF
                        dd     VCOM_ExtFn_SETXON
                        dd     VCOM_ExtFn_SETRTS
                        dd     VCOM_ExtFn_CLRRTS
                        dd     VCOM_ExtFn_SETDTR
                        dd     VCOM_ExtFn_CLRDTR
                        dd     VCOM_ExtFn_Return
                        dd     VCOM_ExtFn_UnSupported
                        dd     VCOM_ExtFn_UnSupported
                        dd     VCOM_ExtFn_UnSupported
                        dd     VCOM_ExtFn_UnSupported
                        dd     VCOM_ExtFn_SETBRK
                        dd     VCOM_ExtFn_CLRBRK
        public  BaudTbl
BaudTbl         dw      1047            ;10h -   110 baud
                dw       384            ;11h     300
                dw       192            ;12h     600
                dw        96            ;13h    1200
                dw        48            ;14h    2400
                dw        24            ;15h    4800
                dw        12            ;16h    9600
                dw         9            ;17h   14400
                dw         6            ;18h   19200
                dw          0           ;19h
                dw          0           ;1Ah
                dw         3            ;1Bh   38400
                dw          0           ;1Ch
                dw          0           ;1Dh
                dw          0           ;1Eh
                dw         2            ;1Fh   56000
                dw          0           ;20h
                dw          0           ;21h
                dw          0           ;22h
                dw         1            ;23h  128000
                dw          0           ;24h
                dw          0           ;25h
                dw          0           ;26h
                dw          0           ;27h  256000

    ;16:16 value for PCOM's IOCTL function.
        _WORD   sel_glbDATA   0     ;GDT selector for our DATA segment
    ;16 bit offset table of PI for PCOM's use
        public off_PICOMS
        off_PICOMS      dw  MAXNUMPORT dup (0)

        public  PCOMEntry
        PCOMEntry  FarPtr32  <0,0>              ;exported code

    ;Hold COM Resource DOS Property name  CP201390
        public  szPropHoldRes
        szPropHoldRes   db  PROP_NAME_HOLD_RES,  00H

    ;Hardware COM DOS Property name
        public  szPropHardwareCOM
        szPropHardwareCOM  db  PROP_NAME_HW_COM,    00H

    ;Rx buffer flush property name                             ;@59629
        public  szPropRxFlush                                  ;@59629
        szPropRxFlush  db  PROP_NAME_COM_RX_BUFFER_FLUSH, 00H  ;@59629

        public  szRxFlushList                                  ;@59629
        szRxFlushList db 'ALL',0,'RECEIVE DATA INTERRUPT ENABLE',0,'SWITCH TO FOREGROUND',0,'NONE',0,0   ;@59629

        public  pchNone                                        ;@59629
        pchNone    db 'NONE',0,0                               ;@59629


    ;COM Select DOS Property name
        public  szPropCOMSelect
        szPropCOMSelect  db  PROP_NAME_COM_SELECT,    00H

        public  szCOMList
        szCOMList db ' ALL',0,'COM1',0,'COM2',0,'COM3',0,'COM4',0,'NONE',0,0

        public  pchAll
        pchAll    db ' ALL',0,0

        public  szVCOM
        szVCOM  db 'VCOM',0

EndData                                     ;End CSWAP_DATA segmenet





;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                 Instance data starts here...                        ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

DefData EXPORT,SWAPINST,PASCAL          ;Start SWAP_INST segment
                                        ;exported items
    HHOOK  hhookInt2fBPHook             ;@95743
    HHOOK  hhookVxDServiceBPHook        ;@95743
    FPFN   fpfnOldInt2f                 ;@95743
    FPFN   fpfnInt2fHandler             ;@95743
    FPFN   fpfnVxDServiceRouter         ;@95743

    HHOOK  hhookInt14ReturnHook
    _DWORD       ihVDM,        -1       ;handle for this VDM
    HVDHSEM      ihComSem,       0      ;space for Sema4 handle for this VDM
    VDHSEMSTATE  iSemState              ;Structure to query sema4 state
    _DWORD  Response_Num,      0        ;for VDHPopUp
    _DWORD  hHook_Timeout      0
    _WORD        ipdbCurrent,INVALID_PDB;current PDB
    _WORD        iflgIgnore,    0       ;Ignore flag for each port
                                        ;Bit 0=COM1, bit 1=COM2, bit 2=COM3
    _WORD        iClients_DX,  -1


      public  Subst_String_Tabl
      public  Subst_Num

    Subst_String_Tabl label byte
                db      'COM'       ;To start COM# string
    Subst_Num   db      0           ;Used for COM n ("1", "2", "3")
                db      0           ;Make it asciiz (null terminate)

    _BYTE  iSaveInt14Cmd,-1
    _BYTE  iInt14h_Complete,COMPLETED
    _BYTE  iIOHooksDone,0
    _BYTE  iCreateSemDone,0

    public szVMBoot
    szVMBoot label byte
             db '#'
             db VDMP_ORD_VMBOOT+'0'
             db 0

    _BYTE  iDOSProp,0               ;CP20D1390
    _BYTE  iData,0                  ; 
    _WORD  iPortAddr,0              ; 

     _DWORD  VCOM_VXD_MSRshadow,0       ;MSR shadows
     _DWORD  VCOM_VXD_MSRshadow2,0
     _DWORD  VCOM_VXD_MSRshadow3,0
     _DWORD  VCOM_VXD_MSRshadow4,0

     _WORD   Events,0                   ;Events
     _WORD   Events2,0
     _WORD   Events3,0
     _WORD   Events4,0

     _WORD   EventMask,0                ;Event Masks
     _WORD   EventMask2,0
     _WORD   EventMask3,0
     _WORD   EventMask4,0

     _DWORD  EventPtr,0                 ;ptr to Event Flags
     _DWORD  EventPtr2,0
     _DWORD  EventPtr3,0
     _DWORD  EventPtr4,0

   public PDCD
   PDCD label byte
        dd      0,0,0,0
        dd      0,0,0

    public PSTAT
    PSTAT label byte
        dd      0,0

EndData                                     ;End SWAP_INST segment








;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;               Initialization data starts here...                    ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

DefData EXPORT,INIT,PASCAL                 ;Start _INITDATA segment
         public PDD_Init_Info
         PDD_Init_Info       PDD_Port_Info_Pkt <4+(MAXNUMPORT*4),0,>
         _WORD  sel_PCOMEntry        0
         _WORD  off_PCOMEntry        0
         _WORD  off_PDD_Init_Info    0
         _WORD  sel_InitData         0
    ;ASCIIZ name of the registered PCOM
        _BYTE Generic_Name   'COM'
        _BYTE G_N_PAD        0           ;Null termination

EndData                                     ;End _INITDATA segment


        END
