;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;       SCCSID = src/vdev/vcom/vcom.inc, vcom, r206, 6c.479 92/08/21
; ****************************************************************************
; *                                                                          *
; *                                                                          *
; *                                                                          *
; ****************************************************************************

;FILE NAME VCOM.INC
;Structure Definition and equates for VCOM
;Created Jan. 1989
;
;modifications
;
;@59629  3/29/93  J.W. Krier  Add Rx Flush Buffer DosProperty
;


MAXNUMPORT      equ     4               ;Max Number of Ports supported by
                                        ; VCOM
MAXBIOSPORT     equ     4               ;Max Number of Ports supported by
                                        ; ABIOS

;Register ID
DLL             equ     0
DLM             equ     1
IIR             equ     2
LCR             equ     3
MCR             equ     4
LSR             equ     5
MSR             equ     6
SCR             equ     7
RBR             equ     8
THR             equ     9
IER             equ     10
XXR             equ     11              ;LOOP BACK bIT - DIRECT TX/RX MODE
XLR             equ     12              ;LOOP BACK bIT - DIRECT LSR MODE

;---- Bit definitions for each register ----
;IER:
ERXI            equ     00000001b       ;Enable Received Data Available Int
ETXI            equ     00000010b       ;Enable Tranmitter Holding Reg Empty
ELSI            equ     00000100b       ;Enable Receiver LIne Status Int
EMSI            equ     00001000b       ;Enable Modem Status Interrupt

;IIR:
NO_INT_PENDING  equ     00000001b       ;Interrupt is not pending
FIFO_ENABLE     equ     00000001b       ;Interrupt is not pending
FIFO_ENABLED    equ     11000000b       ;Interrupt is not pending

;LCR:
WLSBITS         equ     00000011b       ;word length select bits
STBIT           equ     00000100b       ;number of stop bits indicator
PENBIT          equ     00001000b       ;parity enable bit
EPSBIT          equ     00010000b       ;even parity select
STICKPBIT       equ     00100000b       ;stick parity bit
BREAKBIT        equ     01000000b       ;Set break bit
DLAB            equ     10000000b       ;Divisor latch access bit
DLAB_EXP        equ     0111111101111111b       ;Except Divisor latch access bit

;MCR:
DTR             equ     00000001b       ;Data Terminal Ready
RTS             equ     00000010b       ;Request to Send
OUT1            equ     00000100b       ;OUT1 bit  - no support
OUT2            equ     00001000b       ;OUT2 bit
LOOPBIT         equ     00010000b       ;Loop back - no support

;LSR:
DR              equ     00000001b       ;Data Ready
OERR            equ     00000010b       ;Overrun error
PERR            equ     00000100b       ;Parity error
FERR            equ     00001000b       ;Framing error
BREAKINT        equ     00010000b       ;Break Interrupt indicator
ERR_BITS        equ     OERR+PERR+FERR+BREAKINT ;Error bits in LSR
THRE            equ     00100000b       ;Transmitter Holding Register Empty
TEMT            equ     01000000b       ;Transmitter Empty

;MSR:
DCTS            equ     00000001b       ;Delta Clear to Send
DDSR            equ     00000010b       ;Delta Data Set Ready
TERI            equ     00000100b       ;Trailing Edge Ring Indicator
                                        ;(Set when RI changes from 1 -> 0)
DDCR            equ     00001000b       ;Delta Data Carrier Detect
DELTA_BITS      equ     DCTS+DDSR+TERI+DDCR ;delta bits in MSR
CTS             equ     00010000b       ;Clear to send
DSR             equ     00100000b       ;Data Set Ready
RI              equ     01000000b       ;Ring Indicator
DCD             equ     10000000b       ;Data Carrier Detect

;**** Param Value update from PCOM
LCR_IOCTL       EQU     8
MCR_IOCTL       EQU     9
DLL_IOCTL       EQU    10
DLM_IOCTL       EQU    11

;**** Definitions for IOCTL call Interfaces
;Data Bits
DATA_BITS5         equ   5h
DATA_BITS6         equ   6h
DATA_BITS7         equ   7h
DATA_BITS8         equ   8h

;Parity Bits
PARITY_NONE        equ   0h
PARITY_ODD         equ   1h
PARITY_EVEN        equ   2h
PARITY_STICK_ODD   equ   3h
PARITY_STICK_EVEN  equ   4h

;Stop Bit
STOP_BIT1          equ   0h
STOP_BIT15         equ   1h
STOP_BIT2          equ   2h

;Set Modem Control Signals Masks
SETDTR_ON_MASK     equ   00000001b
CLEARDTR_ON_MASK   equ   00000000b
SETRTS_ON_MASK     equ   00000010b
CLEARRTS_ON_MASK   equ   00000000b
SETLOOP_ON_MASK    equ   00010000b
CLEARLOOP_ON_MASK  equ   00000000b
SETDTR_OFF_MASK    equ   11111111b
CLEARDTR_OFF_MASK  equ   11111110b
SETRTS_OFF_MASK    equ   11111111b
CLEARRTS_OFF_MASK  equ   11111101b
SETLOOP_OFF_MASK   equ   11111111b
CLEARLOOP_OFF_MASK equ   11101111b

;**** End of IOCTL interface defintion

;Interrupt Type
LSINT           equ     6
RXINT           equ     4
TXINT           equ     2
MSINT           equ     0
ALLINT          equ     0FFh


;Interrupt type bit position in VIIR_Req
LSINT_POS       equ     00000001b
RXINT_POS       equ     00000010b
TXINT_POS       equ     00000100b
MSINT_POS       equ     00001000b
SLEEPING        equ     00010000b

;flgStatus
IRRSET          equ     00000001b  ;VDHSetVIRR called
NO_IRRSET       equ     11111110b  ;VDHClearVIRR called

;flgRxOp
MORE_TO_COME    equ     00000001b  ;PCOM's RxQueue not empty
RXINT_REQD      equ     00000010b  ;RxInt notified from PCOM
NO_MORE_TO_COME equ     11111110b  ; 
NO_RXINT_REQD   equ     11111101b  ; 

MAXRETRY        equ     6                  ;Retry 6 times with 5 sec interval

;Caller ID for Get_PortID_Register procedure
VPORTIN         equ     1
VPORTOUT        equ     2

;More Room indication in CL from PCOM at PDDProc PutByte request
MORE_ROOM       equ     00000001b       ;More Room in PCOM's TxQueue

Port_Info_Tab   Struc
    Port_Addr       dw      0           ;Address of port
    pdb_PI          dw      0           ;PDB of the port owner
    hVDM_PI         dd      -1          ;VDM handle of the port owner
    hIRQ_PI         dd      -1          ;Handle for IRQ
    Wait_TimeOut    dd      0           ;Timeout for Tx or Rx (if interrupted)
    Wait_AX         dw      0           ;Copy of AX for TX or Rx ( "         )
    Wait_DX         dw      0           ;Copy of DX for TX or Rx ( "         )
    VDLL            db      30h         ;Our copy of DLL
    VDLM            db      0           ;Our copy of DLM
    VIER            db      0           ;Our copy of IER
    VIIR            db      1           ;Our copy of IIR
    VLCR            db      3           ;Our copy of LCR
    VMCR            db      0           ;Our copy of MCR
    VLSR            db      60h         ;Our copy of LSR
    VMSR            db      0           ;Our copy of MSR
    XLSR            db      60h         ;Old copy of LSR
    XMSR            db      0           ;Old copy of MSR
    VMSR_Delta      db      0           ;Old copy of VMSR delta bits
    VRBR            db      0           ;Our copy of RBR
;   VRBR            db      0ffh        ;Our copy of RBR
    VSCR            db      0           ;Our copy of SCR
    flgStatus       db      0           ; 
    flgRxOp         db      0           ; 
    VIIR_Req        db      0
                    db      3 dup (0)   ;Pad so struct will be DWORD aligned
    Ioctl_Parm_Pkt  db      4 dup (0)   ;IOCTL Parameter packet
    Ioctl_Data_Pkt  db      4 dup (0)   ;IOCTL Data packet
    FIFO            db      0           ;FIFO condition
    IRQ_Level       db      0           ;Actual IRQ level
Port_Info_Tab   ends

LCR_Ioctl_Data_Pkt       struc           ;data
    Data_Bits_Data  db      0
    Parity_Data     db      0
    Stop_Bits_Data  db      0
    Tx_Break_Data   db      0
LCR_Ioctl_Data_Pkt      ends

LCR_Ioctl_Parm_Pkt        struc           ;parm
    Data_Bits_Parm  db      0
    Parity_Parm     db      0
    Stop_Bits_Parm  db      0
LCR_Ioctl_Parm_Pkt        ends

MCR_Ioctl_Parm_Pkt     struc              ;parm
    MC_Mask_On_Parm    db      0
    MC_Mask_Off_Parm   db      0
MCR_Ioctl_Parm_Pkt     ends

;Packet to receive initialization data from PCOM
PDD_Port_Info_Pkt   struc
PPI_Length      dw      4+(MAXNUMPORT*4)      ;length of packet (bytes)
PPI_NumPorts    dw      0                     ;number of port addresses
PPI_PortAddr    dw      MAXNUMPORT dup (0)    ;return addresses
PPI_PortIrq     dw      MAXNUMPORT dup (0)    ;return addresses
PDD_Port_Info_Pkt   ends

;PDDProc function number (stack bases)
GETREGISTERENTRY  equ     1

;PDDProc function numbers (in AH)
OPENPORT        equ     1
CLOSEPORT       equ     2
GETBYTE         equ     3
PUTBYTE         equ     4
GETDLLDLM       equ     5
SETDLLDLM       equ     6
SETMCR          equ     46h
SETLCR          equ     42h
SETBREAKON      equ     4bh
SETBREAKOFF     equ     45h
GETLCR          equ     62h
GETMCR          equ     66h
GETMSR          equ     67h

;INT14h function numbers (in AH)
INT14INIT       equ     0
INT14TX         equ     1
INT14RX         equ     2
INT14STATUS     equ     3
INT14XINIT      equ     4
INT14XCTL       equ     5

;Error indication from normal call
SUCCESS         equ     0
RETURNGOOD      equ     SUCCESS

PORT_NOT_OWNED  equ    -1               ;Free port indicator

ILLEGAL_PORTADDR      equ  -1           ;Illegal Port address

;DLL/DLM values
DLL_110BAUD     equ       17h           ;DLL value for 110 buad
DLM_110BAUD     equ       04h           ;DLM value for 110 baud
BASE_DLLDLM     equ     0600h           ;Base DLL/DLM for other baud rates

;maximum acceptable value for Int14h Extended init function
MAX_XINITSTOPB  equ       01h           ;Maximum value for Stop bits
MAX_XINITPARITY equ       04h           ;Maximum value for Parity bits
MAX_XINITBREAK  equ       01h           ;Maximum value for Break bits
MAX_XINITWORDL  equ       03h           ;Maximum value for Word Length
MAX_XINITBAUD   equ       08h           ;Maximum value for Baud rate accepted
                                        ;by Int14h_xInit (08 = 19200 Baud)

;Shift values for Int14h_xInit          ;Used to shift input parameters
STBIT_SHIFT     equ     2               ; into position so they can be
PARITY_SHIFT    equ     4               ; moved into VLCR
BREAKBIT_SHIFT  equ     6
BAUDRATEPOSITION equ    5

;Delay values
DELAY_1SEC      equ     1000d           ;1000 microsecond delay (1 second)
DELAY_5SEC      equ     5000d           ;5000 micorsecond delay (5 seconds)

;TimeOut bit (Int14h_TX and Int14h_Rx)
TIMEOUT         equ     80h             ;Timeout (mask) indicator


XCTL_READ       equ     0               ;Read function for Int14h_xCtl
XCTL_WRITE      equ     1               ;Write function for Int14h_xCtl

;Get_Portid_Register
BASE_ADDR_BITS  equ     0FFF8h          ;Mask to get Base Port Address
COM_REG_BITS    equ     07h             ;Mask to get COM Register ID

ZERO            equ     0

;Device addr
IRQ4_ADDR       equ     03f8h           ;Port address for IRQ4.
                                        ;Other addresses are for IRQ3.
IRQ4            equ     4
IRQ3            equ     3

;flag values for Int14h (iInt14h_Complete flag)
COMPLETED       equ     1
INTERRUPTED     equ     0

Stack_Frame Struc                           ;Stucture (mask) used to extract
    ss_EBP      dd  ?                       ;Pointer to CRF, and pointer to
    ss_RetAddr  dd  ?                       ;correct PI from stack in
    ss_pcrf     dd  ?                       ;Int14h_ReturnProc (Return Hook
    ss_ppi      dd  ?                       ;handler).
Stack_Frame ends

INVALID_PDB     equ     0                ; initial PDB value

;Hold Resource DOS Property Flag        CP20D1390
HOLD_RESOURCE   equ     001h

;Hardware COM DOS Property Flag
HW_COM          equ     002h

;COM Rx Buffer Flush Property            ;@59629
COM_FLUSH_Rx         equ     004h        ;@59629
COM_FLUSH_BACKGROUND equ     008h        ;@59629

FLUSH_NONE       equ 04eh                ;@59629
FLUSH_ALL        equ 041h                ;@59629
FLUSH_Rx         equ 052h                ;@59629
FLUSH_BACKGROUND equ 053h                ;@59629

;COM Select DOS Property Flag
COM_SELECT_NONE equ     000h
COM_SELECT_ALL  equ     0F0h
COM_SELECT_1    equ     010h
COM_SELECT_2    equ     020h
COM_SELECT_3    equ     030h
COM_SELECT_4    equ     040h

NONE            equ     045h
ONE             equ     031h
TWO             equ     032h
THREE           equ     033h
FOUR            equ     034h
ALL             equ     04Ch

ALL_SEL         equ     0Fh

NO_PORT         equ     0FFh

;Int14h Timer Timeout Procedure routine
HOOKENTRY Int14h_Timeout_Proc         <VOID>
HOOKENTRY VCOM_VDMRxBufferFlush       <VOID>                    ;@59629

;Windows 3.11 device id for VCOM.386 VxD
VCOM_VXD_MAGIC   equ     1684002Bh                               ;@95743
VCOM_VXD_MIN_SVC equ     0                                       ;@95743
VCOM_VXD_MAX_SVC equ     0dh                                     ;@95743
