/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = VCDROMP.H
 *
 * DESCRIPTIVE NAME = VCDROM private constants
 *
 * DESCRIPTION VCDROM private constants and external prototypes.
 *
 *
 *
 * ENTRY POINTS:
 *
 * EXTERNAL REFERENCES:
 *
*/


#define ERROR_INVALID_2F_FUNCTION           1
#define CARRY_FLAG                          0x0001

#define STANDARD_VOLUME_DESCRIPTOR          1
#define VOLUME_DESCRIPTOR_TERMINATOR        0xFF
#define OTHER_VOLUME_DESCRIPTOR             0

/*
** VPIC VDD IDC function
*/
#define VPIC_SLAVE_ADDRESS                  3

/*
** DOS device driver request packet commands, with cdrom extensions
*/
#define DOS_IOCTL_INPUT                     3
#define DOS_IOCTL_OUTPUT                    12
#define DOS_READ_LONG                       128
#define DOS_READ_LONG_PREFETCH              130
#define DOS_SEEK                            131
#define DOS_PLAY_AUDIO                      132
#define DOS_STOP_AUDIO                      133
#define DOS_RESUME_AUDIO                    136

#define DOS_INPUT_FLUSH                     7
#define DOS_DEVICE_OPEN                     13
#define DOS_DEVICE_CLOSE                    14

/*
** Identifying strings
*/
#define CD01    0x31304443L
#define VCDR    0x52444356L
#define OM02    0x32304D4FL

/*
** VDHOpen parameters
*/
#define CDROM_CHAR_DRIVER_NAME      "CD-ROM2$"
#define FILESIZE                    0
#define FILEATTRIBUTE               0
#define OPENFLAG                    1
#define CHAROPENMODE                0x2040
#define OPENMODE                    0x8040
#define EABUF                       0

/*
** General constants
*/
#define PARM_LENGTH_MAX             16
#define DATA_LENGTH_MAX             16

#define MEDIA_CHANGED_EXCEPTION     0
#define RETURN_VOLUME_SIZE          0x78
#define DRIVE_PLAYING               0x1000
#define MAX_NUMBER_OF_DRIVES        26
#define CDROM_SECTOR_SIZE           2048

#define VDH_ERROR                   -1L

struct
CategoryCode {
                UCHAR   code;
                UCHAR   category;
};

/*
**  Subcomponent-specific macros
*/

#define INT_3                       _asm { int 3 }
#define GET_DRIVE_STRING(n)         ( &DriveString [n*3] )
#define UNIT_TO_DRIVE_NUMBER(n)     ( n + FirstDriveNumber )
#define FRAMES(l)                   ( (UCHAR) (l & 0x00FF) )
#define SECONDS(l)                  ( (UCHAR) ((l >> 8) & 0x00FF) )
#define MINUTES(l)                  ( (UCHAR) ((l >> 16) & 0x00FF) )

/*
**  Private Function Prototypes
*/

/*
** File: vcdrom.c
*/
BOOL
EXPENTRY
VDDInit ( PSZ );

BOOL
HOOKENTRY
VCDROMCreateVDM ( HVDM );

BOOL
PRIVENTRY
InstallStub ( VOID );

BOOL
HOOKENTRY
VCDROMTerminateVDM ( HVDM );

BOOL
HOOKENTRY
VCDROMPDBDestroy ( HVDM, USHORT );

VOID
PRIVENTRY
CloseHandles ( VOID );

/*
**  File: vcdrom2f.c
*/
BOOL
HOOKENTRY
VCDROMDosLink ( PVOID pHookData,
                register
                PCRF  pcrf);

VOID
PRIVENTRY
SendDeviceRequest ( register
                    struct
                    DosRh   *reqhdr,
                    ULONG    drive_number );

VOID
PRIVENTRY
ResetMedia ( ULONG drive_number );

USHORT
PRIVENTRY
MapOS2toDosCode ( ULONG rc );

USHORT
PRIVENTRY
GetPlayStatus ( HFILE handle );

ULONG
PRIVENTRY
HsgToRedbook ( register ULONG hsg_value );

ULONG
PRIVENTRY
AddSectors ( ULONG start_sector,
             ULONG number,
             ULONG address_mode );

HFILE
PRIVENTRY
GetDriveHandle ( ULONG drive_number );


/*
**** Random macro support
**
**   If VDDSTRICT is defined, the Assert macros generate appropriate code.
**
**   If VDDSTRICT is not defined, the Assert macros are NO-OPs (with the
**   exception of AssertRC, in which case the function is still called, but
**   the return code is not checked).
**
**   If VDDDEBUG is defined, debug printfs (PRINTDEBUGs) are generated, and
**   failed assertions (assuming VDDSTRICT is defined) break at the assertion
**   rather than in the kernel's "panic" service.  VDDDEBUG requires the
**   kernel debugger, in other words.
**
**   If VDDDEBUG is not defined, debug printfs (PRINTDEBUGs) are NOT
**   generated, and failed assertions (assuming VDDSTRICT is defined) simply
**   panics.
*/

#ifdef VDDSTRICT

/*c-begin*/
extern CHAR szAssertMsg[];
#define MODNAME static CHAR szFile[]

#ifdef VDDDEBUG
#define Assert(t) { \
                    if (!(t)) { \
                      PRINTDEBUG(szAssertMsg, szFile, __LINE__); \
                      INT3(); \
                    } \
                  }
#else
#define Assert(t) { \
                    if (!(t)) { \
                      PANIC(szAssertMsg, szFile, __LINE__); \
                    } \
                  }
#endif

#define AssertTRUE(t)   Assert(t)
#define AssertFALSE(t)  Assert(!(t))
#define AssertZERO(t)   Assert(!(t))
#define AssertNONZERO(t)Assert(t)
#define AssertRC(t)     Assert(t)       /* verify function return code good */
/*c-end*/

#else

/*c-begin*/
#define Assert(t)       //
#define AssertTRUE(t)   //
#define AssertFALSE(t)  //
#define AssertZERO(t)   //
#define AssertNONZERO(t)//
#define AssertRC(t)     (t)            /* perform function, but don't verify */
/*c-end*/

#endif

/*
**  Random debugging support
*/

#ifdef VDDDEBUG

/*c-begin*/
extern CHAR szModule[];
extern CHAR *apszPageStates[];

#undef PRINTDEBUG
#define PRINTDEBUG  printf(szModule); printf
/*c-end*/

#endif
