/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = ReqHdr.h
 *
 * DESCRIPTIVE NAME = Request header structures
 *
 * DESCRIPTION VCDROM's DOS device driver request header structures
 *
 *
 * ENTRY POINTS:
 *
 * EXTERNAL REFERENCES:
 *
*/

/*
** macros
*/
#define FP_SEG(fp) (*((unsigned short *)&(fp) + 1))
#define FP_OFF(fp) (*((unsigned short *)&(fp)))
#define RH(n)      (struct DosRh ## n *)

/*
** General OS/2 device driver error codes, a superset of the DOS codes
*/
#define DEVIOCTL_ERROR     0xFF00
#define ERROR              0x8000
#define DEV_ERROR          0x4000
#define BUSY               0x0200
#define DONE               0x0100

/*
** Media changed codes
*/
#define MEDIA_CHANGED          -1
#define MEDIA_UNCERTAIN         0
#define MEDIA_NOT_CHANGED       1

/*
** DOS device driver request packet structures
*/
struct
DosRh  {                                              /* request header */
            UCHAR       length;
            UCHAR       subunit;
            UCHAR       command;
            USHORT      status;
            UCHAR       reserved[8];
};


struct
DosRh0 {                                               /* initialize     */
            struct
            DosRh       rh;
            UCHAR       number_of_units;
            ULONG       end_address;
            F16PVOID    bpb_array;
            UCHAR       first_unit_number;
};

struct
DosRh1 {                                               /* media check    */
            struct
            DosRh       rh;
            UCHAR       media_descriptor;
            UCHAR       media_status;
            F16PVOID    volume_ID;
};

struct
DosRh2 {                                               /* build BPB      */
            struct
            DosRh       rh;
            UCHAR       media_descriptor;
            F16PVOID    transfer_area;
            F16PVOID    bpb;
};

struct
DosRh3 {                                               /* ioctl input    */
            struct
            DosRh       rh;
            UCHAR       media_descriptor;
            F16PVOID    control_block;
            USHORT      control_block_size;
            USHORT      start_sector;
            F16PVOID    volume_ID;
            ULONG       start_sector32;    /* for dos 4.0 w > 32mb partition */
 };

struct
DosRh4 {                                               /* input          */
            struct
            DosRh       rh;
            UCHAR       media_descriptor;
            F16PVOID    transfer_area;
            USHORT      transfer_count;
            USHORT      start_sector;
            F16PVOID    volume_ID;
            ULONG       start_sector32;    /* for dos 4.0 w > 32mb partition */
};

struct
DosRh5 {                                               /* peek input     */
            struct
            DosRh       rh;
            UCHAR       character;
};

struct
DosRh6 {                                               /* input status   */
            struct
            DosRh       rh;
};

struct
DosRh7 {                                               /* input flush    */
            struct
            DosRh       rh;
};

struct
DosRh8 {                                               /* output         */
            struct
            DosRh       rh;
            UCHAR       media_descriptor;
            F16PVOID    transfer_area;
            USHORT      transfer_count;
            USHORT      start_sector;
            F16PVOID    volume_ID;
            ULONG       start_sector32;   /* for dos 4.0 w > 32mb partition */
};

struct
DosRh9 {                                               /* output verify  */
            struct
            DosRh       rh;
            UCHAR       media_descriptor;
            F16PVOID    transfer_area;
            USHORT      transfer_count;
            USHORT      start_sector;
            F16PVOID    volume_ID;
            ULONG       start_sector32;   /* for dos 4.0 w > 32mb partition */
};

struct
DosRh10 {                                               /* output status */
            struct
            DosRh       rh;
};

struct
DosRh11 {                                               /* output flush  */
            struct
            DosRh       rh;
};

struct
DosRh12 {                                               /* ioctl output   */
            struct
            DosRh       rh;
            UCHAR       media_descriptor;
            F16PVOID    control_block;
            USHORT      control_block_size;
            USHORT      start_sector;
            F16PVOID    volume_ID;
            ULONG       start_sector32;   /* for dos 4.0 w > 32mb partition */
};

struct
DosRh13 {                                              /* open           */
            struct
            DosRh       rh;
};

struct
DosRh14 {                                              /* close          */
            struct
            DosRh       rh;
};

struct
DosRh15 {                                              /* removable media */
            struct
            DosRh       rh;
};

struct
DosRh16 {                                              /* output until busy */
            struct
            DosRh       rh;
            UCHAR       media_descriptor;
            F16PVOID    transfer_area;
            USHORT      transfer_count;
};

struct
DosRh19 {                                              /* generic ioctl  */
            struct
            DosRh       rh;
            UCHAR       major_function;
            UCHAR       minor_function;
            USHORT      SI_contents;
            USHORT      DI_contents;
            F16PVOID    packet;
};

struct
DosRh23 {                                           /* get logical device */
            struct
            DosRh       rh;
            UCHAR       logical_device;
            UCHAR       command;
            USHORT      status;
            ULONG       reserved;
};

struct
DosRh24 {                                          /* set logical device */
            struct
            DosRh       rh;
            UCHAR       logical_device;
            UCHAR       command;
            USHORT      status;
            ULONG       reserved;
};

/*
** Extended commands to support CDROM
*/
struct
DosRh128 {                                             /* read long      */
            struct
            DosRh       rh;
            UCHAR       address_mode;
            F16PVOID    transfer_area;
            USHORT      transfer_count;
            ULONG       start_sector;
            UCHAR       read_mode;
            UCHAR       interleave_size;
            UCHAR       interleave_skip_factor;
};

struct
DosRh130 {                                         /* read long prefetch */
            struct
            DosRh       rh;
            UCHAR       address_mode;
            F16PVOID    transfer_area;
            USHORT      transfer_count;
            ULONG       start_sector;
            UCHAR       read_mode;
            UCHAR       interleave_size;
            UCHAR       interleave_skip_factor;
};

struct
DosRh131 {                                             /* seek           */
            struct
            DosRh       rh;
            UCHAR       address_mode;
            F16PVOID    transfer_area;
            USHORT      transfer_count;
            ULONG       start_sector;
};

struct
DosRh132 {                                             /* play audio     */
            struct
            DosRh       rh;
            UCHAR       address_mode;
            ULONG       start_sector;
            ULONG       number_of_sectors;
};

struct
DosRh133 {                                             /* stop audio     */
            struct
            DosRh       rh;
};

struct
DosRh134 {                                              /* write long    */
            struct
            DosRh       rh;
            UCHAR       address_mode;
            F16PVOID    transfer_area;
            USHORT      transfer_count;
            ULONG       start_sector;
            UCHAR       write_mode;
            UCHAR       interleave_size;
            UCHAR       interleave_skip_factor;
};

struct
DosRh135 {                                          /* write long verify */
            struct
            DosRh       rh;
            UCHAR       address_mode;
            F16PVOID    transfer_area;
            USHORT      transfer_count;
            ULONG       start_sector;
            UCHAR       write_mode;
            UCHAR       interleave_size;
            UCHAR       interleave_skip_factor;
};

struct
DosRh136 {                                             /* resume audio   */
            struct
            DosRh       rh;
};

