/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = CtrlBlk.h
 *
 * DESCRIPTIVE NAME = Control block structures
 *
 *
 * VERSION = V2.0
 *
 * DATE        08/23/91, dtf
 *
 * DESCRIPTION
 *
 * FUNCTIONS   Define the DOS control blocks for
 *                 1. Ioctl Input  (3)
 *                 2. Ioctl Output (12)
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/


/*
** Read Ioctl request codes
*/
#define RADDR       0
#define LOCHEAD     1
/* reserved         2 */
#define ERRSTAT     3
#define AUDINFOIN   4
#define DRVBYTESIN  5
#define DEVSTAT     6
#define SECTSIZE    7
#define VOLSIZE     8
#define MEDCHNG     9
#define DISKINFO    10
#define TNOINFO     11
#define QINFO       12
#define SUBCHANINFO 13
#define UPCCODE     14
#define AUDSTAT     15

/*
** Device Status Flags
*/
#define DOOR_OPEN                   0x0001
#define DOOR_UNLOCKED               0x0002
#define RAW_READING_SUPPORT         0x0004
#define READ_WRITE_SUPPORT          0x0008
#define PLAY_TRACKS_SUPPORT         0x0010
#define INTERLEAVING_SUPPORT        0x0020
/* RESERVED                         0x0040 */
#define PREFETCHING_SUPPORT         0x0080
#define AUDIO_MANIPULATION_SUPPORT  0x0100
#define REDBOOK_SUPPORT             0x0200

/*
** Data Modes
*/
#define COOKED_MODE                 0
#define RAW_MODE                    1
#define HSG_ADDRESS                 0
#define REDBOOK_ADDRESS             1

/*
** Read Ioctl request control blocks
*/
struct Raddr {                          /* return address of device header */
            UCHAR       control_code;
            F16PVOID    *device_header;
};

struct LocHead {                        /* location of head */
            UCHAR       control_code;
            UCHAR       address_mode;
            ULONG       head_location;
};

struct ErrStat {                        /* error statistics */
            UCHAR       control_code;
            /* not yet defined */
};

struct AudInfo {                        /* audio channel info */
            UCHAR       control_code;
            UCHAR       input_0;
            UCHAR       volume_0;
            UCHAR       input_1;
            UCHAR       volume_1;
            UCHAR       input_2;
            UCHAR       volume_2;
            UCHAR       input_3;
            UCHAR       volume_3;
};

struct DrvBytesIn {                     /* read drive bytes */
            UCHAR       control_code;
            UCHAR       bytes_read;
            char        read_buffer[128];
};

struct DevStat {                        /* device status */
            UCHAR       control_code;
            ULONG       device_parameters;
};

struct SectSize {                       /* return sector size */
            UCHAR       control_code;
            UCHAR       read_mode;
            USHORT      sector_size;
};

struct VolSize {                        /* return volume size */
            UCHAR       control_code;
            USHORT      volume_size;
};

struct MedChng {                        /* media changed */
            UCHAR       control_code;
            UCHAR       media_byte;
};

struct DiskInfo {                       /* audio disk info */
            UCHAR       control_code;
            UCHAR       lowest_track;
            UCHAR       highest_track;
            ULONG       leadout_track_start;
};

struct TnoInfo {                        /* audio track info */
            UCHAR       control_code;
            UCHAR       track_number;
            ULONG       track_start;
            UCHAR       track_control;
};

struct QInfo {                          /* audio Q-channel info */
            UCHAR       control_code;
            UCHAR       control;
            UCHAR       track_number;
            UCHAR       point;
                                        /* running time on the track */
            UCHAR       minutes;
            UCHAR       seconds;
            UCHAR       frames;
            UCHAR       zero;
                                        /* running time on the disk */
            UCHAR       amin;
            UCHAR       asec;
            UCHAR       aframe;
};

struct SubChanInfo {                    /* audio sub-channel info */
            UCHAR       control_code;
            ULONG       start_frame_address;
            F16PVOID    *tranfer_area;
            ULONG       number_of_sectors;
};

struct UPCCode {                        /* UPC code */
            UCHAR       control_code;
            UCHAR       control;
            char        UPC_code[7];
            UCHAR       zero;
            UCHAR       aframe;
};

struct AudStat {                        /* audio status info */
            UCHAR       control_code;
            USHORT      audio_status;
            ULONG       last_start_location;
            ULONG       last_end_location;
};

/*
** Write Ioctl request codes
*/
#define EJECT       0
#define LOCKDOOR    1
#define RESETDRV    2
#define AUDINFOOUT  3
#define DRVBYTESOUT 4
#define CLOSETRAY   5

/*
** Write Ioctl request control blocks
*/
struct Eject {                          /* eject disk */
            UCHAR       control_code;
};

struct LockDoor {                       /* lock/unlock door */
            UCHAR       control_code;
            UCHAR       lock_function;
};

struct ResetDrv {                       /* reset drive */
            UCHAR       control_code;
};

/* struct AudInfo (see above) */        /* audio channel control */

struct DrvBytesOut {                    /* write device control string */
            UCHAR       control_code;
                                        /* variable size control string */
};

struct CloseTray {                      /* close tray */
            UCHAR       control_code;
};
