/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "src/vdev/vaspi/vaspix.h, vaspi, r207 94/08/15";*/
/**************************************************************************
 *
 * SOURCE FILE NAME = VASPIX.H
 *
 * DESCRIPTIVE NAME = VASPI.SYS - OS/2 Virtual ASPI Device Driver
 *
 *
 *
 * VERSION = V1.0
 *
 * DATE
 *
 * DESCRIPTION : External data definitions
 *
 *      VASPI is organized as follows:
 *         VAINIT.C    - Init routine
 *         VAUSER.C    - UserHooks for VDM Creation, VDMTermination
 *         VADATA.C    - Data
 *         VAEVENT.C   - Entry point in VDD for PDD to call
 *         VAMEM.C     - Memory and queue management routines
 *         VAROUTER.C  - ASPI Router and DOS Link routines
 *
 *         VASPI.H     - Defines, etc
 *         VASPIX.H    - External data definitions
 *         VASPIP.H    - Function profile definitions
 *         VASPIMAC.H  - Macros
 *
 *
*/
// while debugging, make all objects public
#ifdef VDDDEBUG
#define static
#endif

#pragma BEGIN_INIT_DATA

extern PASPI_SRB_INQUIRY pInquirySRB;

#pragma END_INIT_DATA

#pragma BEGIN_SWAP_DATA

#ifdef VDDSTRICT
extern CHAR szVASPIAssertMsg[];
#endif

/***LD+ VDM - VASPI's global VDM data structures
 *
 */

// global data
/**
 ** VAMEM.C
 **
 ** Memory allocator variables
 **/
extern USHORT           adapterCount;

extern HVDHSEM          hMemorySem;
extern PPGHEADER        pPGHead;
extern PPGHEADER        pPGTail;
extern ADPTINFO adapterInfo[MAX_ADAPTER_COUNT];

extern SZ szVMBoot;

// vastub.h tells us about the device driver stub we install into
// each VDM.

#include "vastub.h"

extern FPFNPDD PDDProc;                      /* addr of PDD entry point */

#pragma END_SWAP_DATA

#pragma BEGIN_SWAP_INSTANCE

// instance data

extern BOOL   VDMActive;                     /* Flag for VDM I/O status */
extern HVDM   sessionHandle;                 /* DOS session handle */

extern ULONG  VPMModeActive;

extern HHOOK  hVPMBP;
extern FPFN   pVPMBP;

extern HHOOK  hV86BP;
extern VPVOID pV86BP;

extern HHOOK  hTimerHook;

extern NPVSRB_LINK npVirtSRBLinkActiveList;
extern PWAITQ_HEAD pWaitQStart;

extern HVDHSEM  vaspiQueueSem;
extern HVDHSEM  vaspiWaitQueueSem;

extern ASPI_SRB_DEVICE_TYPE deviceSRB;
extern PASPI_SRB_DEVICE_TYPE pDeviceSRB;

/**
 ** Working vars for VAROUTER.C
 **/
extern NPVSRB_LINK       pSRBL;
extern PASPI_SRB_HEADER  pDosSRB;
extern ULONG             V86SRBPtr;
extern USHORT            SRBSize;

extern HVDHSEM           hPostSem;

/**
 ** VAMEM.C
 **
 ** Memory allocator session based variables
 **/
extern ULONG            cBytesUsed;
extern ULONG            cBytesAvail;
extern ULONG            cAllocBytes;

extern ULONG            pBufPhys;
extern PVOID            pBufLin;

extern PASPI_SRB_ABORT_IO pAbortSRB;
extern USHORT           timerRunning;

#pragma END_SWAP_INSTANCE

