/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "src/vdev/vaspi/vaspimac.h, vaspi, r207 94/08/15";*/
/**************************************************************************
 *
 * SOURCE FILE NAME = VASPIMAC.H
 *
 * DESCRIPTIVE NAME = VASPI.SYS - OS/2 Virtual ASPI Device Driver
 *
 *
 *
 * VERSION = V1.0
 *
 * DATE
 *
 * DESCRIPTION : Macros
 *
 *      VASPI is organized as follows:
 *         VAINIT.C    - Init routine
 *         VAUSER.C    - UserHooks for VDM Creation, VDMTermination
 *         VADATA.C    - Data
 *         VAEVENT.C   - Entry point in VDD for PDD to call
 *         VAMEM.C     - Memory and queue management routines
 *         VAROUTER.C  - ASPI Router and DOS Link routines
 *
 *         VASPI.H     - Defines, etc
 *         VASPIX.H    - External data definitions
 *         VASPIP.H    - Function profile definitions
 *         VASPIMAC.H  - Macros
 *
 *
*/
// Shift values for convering between various memory units

#define KBTOLIN         10
#define PAGETOLIN       12
#define PAGETOKB         2
#define PAGETOPARA       8
#define PARATOLIN        4

/* Translation macros
 *
 * The macro  X_TO_Y  converts from X units to Y units.  For example,
 * KB_TO_LIN converts a count of kilobytes to a count of bytes (or
 * a linear address).  If the macro has a "_C" suffixed, then any
 * remainder is rounded up (C = "ceiling").
 */

#define SHIFT_RIGHT_CEIL(u,n) (((ULONG)(u) + (1<<(n))-1) >> (n))

#define SHIFT_LEFT(u,n) ((ULONG)(u) << (n))
#define SHIFT_RIGHT(u,n) ((ULONG)(u) >> (n))

#define KB_TO_LIN(u) SHIFT_LEFT(u,KBTOLIN)
#define LIN_TO_KB(u) SHIFT_RIGHT(u,KBTOLIN)

#define PAGE_TO_LIN(u) SHIFT_LEFT(u,PAGETOLIN)
#define LIN_TO_PAGE(u) SHIFT_RIGHT(u,PAGETOLIN)

#define KB_TO_PAGE_C(u) SHIFT_RIGHT_CEIL(u,PAGETOKB)
#define PAGE_TO_KB(u) SHIFT_LEFT(u,PAGETOKB)

#define PARA_TO_PAGE_C(u) SHIFT_RIGHT_CEIL(u,PAGETOPARA)
#define PAGE_TO_PARA(u) SHIFT_LEFT(u,PAGETOPARA)

#define PARA_TO_LIN(u) SHIFT_LEFT(u,PARATOLIN)
#define LIN_TO_PARA(u) SHIFT_RIGHT(u,PARATOLIN)

// Build a linear pointer out of a real-mode seg:off pair
#define MK_LIN_PTR(seg,off) ((PVOID)(((seg)<<4)+(off)))

// To emphasize that we are intentionally doing nothing.
//   (To act as dummy statements in "for" and "while" loops, for example.)
#define do_nothing /* twiddle thumbs */

/* Failure codes are returned via the client's BL.
 * WARNING:  The macro always places the return code into the
 *              register set pointed to by pcrf.
 */
#define FAILURE(code) (BL(pcrf) = (BYTE)(code))

#ifdef VDDSTRICT

#ifdef VDDDEBUG
#define VASPIPanic() { PRINTDEBUG(szVASPIAssertMsg, __FILE__, __LINE__); INT3(); }
#else
#define VASPIPanic() { PANIC(szVASPIAssertMsg, __FILE__, __LINE__); }
#endif

/* The trailing "else" exists for two reasons
 *
 *      (1) to eat the semicolon
 *      (2) to ensure that "if" and "else" keywords match up
 *              in case the assertion appeared inside a conditional.
 */

#define ASSERT(x)        if (!(x)) VASPIPanic() else do_nothing
#define ASSERT_NZ        ASSERT
#define ASSERT_EQ(x, y)  if ((x) != (y)) VASPIPanic() else do_nothing
#define ASSERT_NE(x, y)  if ((x) == (y)) VASPIPanic() else do_nothing
#define ASSERT_GT(x, y)  if ((x) <= (y)) VASPIPanic() else do_nothing
#define ASSERT_LT(x, y)  if ((x) >= (y)) VASPIPanic() else do_nothing
#define ASSERT_GE(x, y)  if ((x) < (y)) VASPIPanic() else do_nothing
#define ASSERT_LE(x, y)  if ((x) > (y)) VASPIPanic() else do_nothing
#define ASSERT_REGSIZE4() if (sizeof(REG) != 4) VASPIPanic() else do_nothing
#else
#define ASSERT(x)
#define ASSERT_NZ(x)
#define ASSERT_EQ(x, y)
#define ASSERT_NE(x, y)
#define ASSERT_GT(x, y)
#define ASSERT_LT(x, y)
#define ASSERT_GE(x, y)
#define ASSERT_LE(x, y)
#define ASSERT_REGSIZE4()

#endif
