/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "src/vdev/vaspi/vaspi.h, vaspi, r207 94/08/15";*/
/**************************************************************************
 *
 * SOURCE FILE NAME = VASPI.H
 *
 * DESCRIPTIVE NAME = VASPI.SYS - OS/2 Virtual ASPI Device Driver
 *
 *
 *
 * VERSION = V1.0
 *
 * DATE
 *
 * DESCRIPTION : Defines, etc
 *
 *      VASPI is organized as follows:
 *         VAINIT.C    - Init routine
 *         VAUSER.C    - UserHooks for VDM Creation, VDMTermination
 *         VADATA.C    - Data
 *         VAEVENT.C   - Entry point in VDD for PDD to call
 *         VAMEM.C     - Memory and queue management routines
 *         VAROUTER.C  - ASPI Router and DOS Link routines
 *
 *         VASPI.H     - Defines, etc
 *         VASPIX.H    - External data definitions
 *         VASPIP.H    - Function profile definitions
 *         VASPIMAC.H  - Macros
 *
 *
*/
#ifndef ENABLE
#define ENABLE  _asm{ sti }
#define DISABLE _asm{ cli }
#endif

#define iszCMDPARM1 0
#define iszCMDPARM2 1
#define iszCMDPARM3 2
#define iszCMDPARM4 3
#define iszCMDPARM5 5


#define PDD_NAME "ASPI"

#define PDDCMD_VDD_INITIALIZE 0
#define PDDCMD_SRB_REQUEST 2
#define PDDCMD_OS2_ASPI_PASSTHRU 3
#define PDDCMD_VDM_DESTROY 4

/**
 ** VDPX registration info
 **/
#define ASPIVDD_NAME "ASPIVDD$"
#define ASPIVDD_INT21_REGISTER 1

#define MAX_VIRT_SG_LIST      255
#define MAX_VIRT_SG_LIST_SIZE ((MAX_VIRT_SG_LIST) * sizeof(VDHPAGELIST))

typedef struct _VSRB_LINK   VSRB_LINK, *NPVSRB_LINK, FAR *PVSRB_LINK;

/*----------------------------------------------------------*/
/*                                                          */
/* Virtual SRB Link Element                                 */
/* ------------------------                                 */
/*                                                          */
/* Tracks data required for each ASPI request from a VDD    */
/*                                                          */
/*----------------------------------------------------------*/
typedef struct _VSRB_LINK
{
   NPVSRB_LINK              pNextSRBL;

   PASPI_SRB_HEADER         pOS2SRB;          /* Linear address of OS2 SRB */
   PASPI_SRB_HEADER         pDosSRB;          /* Linear address of DOS SRB */

   ULONG                    pSRBL16;          /* 16:16 Alias to SRB Link   */

   PVOID                    pPageList;
   HLOCK                    hDataLock;

   HHOOK                    hkVDMContext;
   HVDM                     hHVDM;

   USHORT                   AllocBytes;
   USHORT                   Flags;

   ULONG                    V86SRBPtr;
   ULONG                    linkOffset;

}  VSRB_LINK;

#define LF_VPM_CLIENT      0x0001
#define LF_VPM_MODESWITCH  0x0002
#define LF_ON_LINKQ        0x0004
#define LF_VDM_DESTROYED   0x8000

typedef struct _WAITQ_HEAD WAITQ_HEAD, *PWAITQ_HEAD;
typedef struct _WAITQ_LINK WAITQ_LINK, *PWAITQ_LINK;

/*----------------------------------------------------------*/
/*                                                          */
/* Wait Queue Head                                          */
/* ---------------                                          */
/*                                                          */
/* Tracks the information about the status of a SCSI device */
/*                                                          */
/*----------------------------------------------------------*/
typedef struct _WAITQ_HEAD
{
  PWAITQ_HEAD              pNextQHead;        /* Pointer to the next queue */
  PWAITQ_HEAD              pNextAdapter;      /* Pointer to next adapter */
  UCHAR                    adapterIndex;
  UCHAR                    targetID;
  UCHAR                    targetLUN;
  UCHAR                    reserved1;         /* Padding for DWORD alignment */
  BOOL                     PostRoutineActive; /* Flag marking execution of post routine */
  PWAITQ_LINK              pFirstLink;        /* Pointer to next active SRB */
  PWAITQ_LINK              pLastLink;         /* Pointer to last waiting SRB */
} WAITQ_HEAD;

/*----------------------------------------------------------*/
/*                                                          */
/* Wait Queue Link                                          */
/* ---------------                                          */
/*                                                          */
/* Tracks an individual SRB waiting to be issued to a device*/
/*                                                          */
/*----------------------------------------------------------*/
typedef struct _WAITQ_LINK
{
  PWAITQ_LINK              pNextQLink;
  PWAITQ_LINK              pPrevQLink;
  NPVSRB_LINK              pSRBL;             /* Pointer to next waiting SRB */

} WAITQ_LINK;

typedef struct _ADPTINFO   ADPTINFO, *PADPTINFO;

/*----------------------------------------------------------*/
/*                                                          */
/* Adapter Info Element                                     */
/* --------------------                                     */
/*                                                          */
/* Tracks the limitations for each SCSI adapter             */
/*                                                          */
/*----------------------------------------------------------*/
typedef struct _ADPTINFO
{
  PADPTINFO                pNextInfo;
  USHORT                   adapterFeatures;
  USHORT                   maximumSGList;
  ULONG                    maximumCDBTransfer;
}ADPTINFO;

#define MAX_ADAPTER_COUNT  10

/*---------------------------------------------------*/
/*                                                   */
/*                                                   */
/*---------------------------------------------------*/

/**
 ** Note: Pad these structures to 8-byte boundaries as required!
 **/

typedef struct _PGHEADER   PGHEADER,  *PPGHEADER;
typedef struct _BUFHEADER  BUFHEADER, *PBUFHEADER;

typedef struct _BUFHEADER
{

   PBUFHEADER               pNext;
   ULONG                    Size;

} BUFHEADER;

typedef struct _PGHEADER
{

   PPGHEADER                pNext;
   ULONG                    cAllocations;
   ULONG                    PhysAddr;

   ULONG                    MaxSize;
   ULONG                    Reserved;

   PBUFHEADER               pBUFChain;

} PGHEADER;

#define MAX_BUF_SIZE (4*1024L - sizeof(PGHEADER))
#define MIN_BUF_SIZE 128



