/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "src/vdev/vaspi/vadata.c, vaspi, r207 94/08/15";*/
/**************************************************************************
 *
 * SOURCE FILE NAME = VADATA.C
 *
 * DESCRIPTIVE NAME = VASPI.SYS - OS/2 Virtual ASPI Device Driver
 *
 *
 *
 * VERSION = V1.0
 *
 * DATE
 *
 * DESCRIPTION : This module contains the data for VASPI.SYS
 *
 *      VASPI is organized as follows:
 *         VAINIT.C    - Init routine
 *         VAUSER.C    - UserHooks for VDM Creation, VDMTermination
 *         VADATA.C    - Data
 *         VAEVENT.C   - Entry point in VDD for PDD to call
 *         VAMEM.C     - Memory and queue management routines
 *         VAROUTER.C  - ASPI Router and DOS Link routines
 *
 *         VASPI.H     - Defines, etc
 *         VASPIX.H    - External data definitions
 *         VASPIP.H    - Function profile definitions
 *         VASPIMAC.H  - Macros
 *
 *
*/
#include <mvdm.h>

#include <scsi.h>
#include <aspi.h>
#include <vaspi.h>

// while debugging, make all objects public
#ifdef VDDDEBUG
#define static
#endif

#pragma BEGIN_INIT_DATA

/* These are in vainit.c.  Only INIT routines need INIT data. */
ASPI_SRB_INQUIRY inquirySRB;
PASPI_SRB_INQUIRY pInquirySRB = &inquirySRB;

#pragma END_INIT_DATA

#pragma BEGIN_SWAP_DATA

#ifdef VDDSTRICT
CHAR szVASPIAssertMsg[] = "assertion failure in file %s, line %d\n";
#endif

/***LD+ VDM - VASPI's global VDM data structures
 *
 */

// global data
USHORT adapterCount = 0;

/**
 ** VAMEM.C
 **
 ** Memory allocator variables
 **/
HVDHSEM          hMemorySem = 0;
PPGHEADER        pPGHead    = 0;
PPGHEADER        pPGTail    = 0;

ADPTINFO adapterInfo[MAX_ADAPTER_COUNT];

SZ szVMBoot = {'#', VDMP_ORD_VMBOOT+'0', 0};

// vastub.h tells us about the device driver stub we install into
// each VDM.

#include "vastub.h"

FPFNPDD PDDProc = (FPFNPDD)0;               /* addr of PDD entry point */

#pragma END_SWAP_DATA

#pragma BEGIN_SWAP_INSTANCE

/* Instance data */
BOOL VDMActive = FALSE;                     /* Flag for VDM I/O status */
ULONG sessionHandle     = 0;                /* DOS session handle */

HHOOK  hVPMBP           = 0;
FPFN   pVPMBP           = 0;

HHOOK  hV86BP           = 0;
VPVOID pV86BP           = 0;

HHOOK  hTimerHook       = 0;

NPVSRB_LINK npVirtSRBLinkActiveList = 0;
PWAITQ_HEAD pWaitQStart = 0;

HVDHSEM  vaspiQueueSem  = 0;                /* Queue semaphore */
HVDHSEM  vaspiWaitQueueSem  = 0;            /* Wait queue semaphore */

ASPI_SRB_DEVICE_TYPE deviceSRB;
PASPI_SRB_DEVICE_TYPE pDeviceSRB = &deviceSRB;

/**
 ** Working vars for VAROUTER.C
 **/
NPVSRB_LINK       pSRBL;
PASPI_SRB_HEADER  pDosSRB;
ULONG             V86SRBPtr;
USHORT            SRBSize;

/**
 ** VAMEM.C
 **
 ** Memory allocator session based variables
 **/
ULONG            cBytesUsed;
ULONG            cBytesAvail;
ULONG            cAllocBytes;

ULONG            pBufPhys;
PVOID            pBufLin;

/* Local variables for use during VASPIDestroy */
ASPI_SRB_ABORT_IO abortSRB;
PASPI_SRB_ABORT_IO pAbortSRB = &abortSRB;
USHORT timerRunning = 0;

#pragma END_SWAP_INSTANCE


