;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = VDHEQU.INC
;*
;* DESCRIPTIVE NAME = SVDH definitions file
;*
;*
;* VERSION      V2.0
;*
;* DATE         
;*
;* DESCRIPTION 
;*
;* FUNCTIONS    NONE
;*
;* NOTES        NONE
;*             
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES  NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVIY =
;*   DATE      FLAG       APAR    CHANGE DESCRIPTION
;*   --------  ---------- -----   --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx xxxxx   xxxxxxx
;*   03/25/89  @P1        D132    TPL, DCR 132 changes
;*   04/11/91  D1348      D1348   NAKADA, Enable DBCS support in Vio-Window
;*   09/25/91  B726706            WKB, OEM changes
;****************************************************************************/

FUNC_NUM        EQU     256               ; BufferUpdate function number
GRAPHICS_MODE   EQU     0000000000000010b ; Mode type bit 1
PVB_SEL_BIT     EQU     0000000000000001b ; PVB flag bit
LVB_SEL_BIT     EQU     0000000000000010b ; LVB flag bit
CGAAttr         EQU     0000000000000100b ; passed attrs are CGA format ;@P1
RESERVED_FLAGS  EQU     1111111111111000b
I_ReadCellTypes equ     0               ; table for EGA format LVB      ;@P1
I_ReadCharStr   equ     1               ; Read characters               ;@P1
I_ReadCellStr   equ     2               ; Read character/attribute 's   ;@P1
I_ScrollUp      equ     3               ; Scroll window up              ;@P1
I_ScrollDown    equ     4               ; Scroll window down            ;@P1
I_ScrollLeft    equ     5               ; Scroll window left            ;@P1
I_ScrollRight   equ     6               ; Scroll window right           ;@P1
I_WrtCellStr    equ     7               ; Write character/attribute 's  ;@P1
I_WrtCharStr    equ     8               ; Write characters              ;@P1
I_WrtCharStrAt  equ     9               ; Write characters with attr    ;@P1
I_WrtNChar      equ     0ah             ; Write character N times       ;@P1
I_WrtNAttr      equ     0bh             ; Write attribute N times       ;@P1
I_WrtNCell      equ     0ch             ; Write cell N times            ;@P1
I_LVBToPVB      equ     0dh             ; Copy the LVB to the PVB       ;@P1
MIN_WRT_INDEX   EQU     7                                               ;@P1
MAX_INDEX       EQU     13              ; Max index value allowed       ;@P1
STATUS_PORT     EQU     3DAH            ; Video port for retrace status

WorldAttrCount  equ     3                                               ;@P1
WorldFMTATTR    equ     0370h                                           ;@P1
WorldCellSize   equ     4                                               ;@P1
DefaultCellSize equ     2                                               ;@P1
LEFT            equ     0001h                                           ;@P1
UP              equ     0002h                                           ;@P1
RIGHT           equ     0004h                                           ;@P1
DOWN            equ     0008h                                           ;@P1
LVBPVB          equ     0010h                                           ;@P1
DOMOVE          equ     0001h                                           ;@P1
DOFILL          equ     0002h                                           ;@P1

;/*
;** OEMFlags bit definitions:                              ;@MS?? - BEGIN
;** WARNING: These are also defined in VDH.H, be sure to update both files
;*/

IDC_CGA         equ     0001h   ; Dual Mode Plasma Controller
VDU_CGA         equ     0002h   ; VDU Controller
DSM_MONITOR     equ     0004h   ; Dual Scan Monitor
PARADISE_VGA    equ     0008h   ; Paradise VGA adapter
PRISM_VGA       equ     0010h   ; Prism LCD VGA adapter
CRYSTAL_VGA     equ     0020h   ; Crystal LCD VGA adapter
STARLIGHT_VGA   equ     0040h   ; Starlight 132 VGA adapter
STARDUST_VGA    equ     0080h   ; Stardust VGA adapter
VGA_E           equ     0100h   ; IBM VGA-E adapter
FAST_CGA        equ     8000h   ; Don't wait on CGA retrace for screen update

OEM_132_COLUMNS equ     (STARLIGHT_VGA OR STARDUST_VGA)

IFDEF D1348
                                ;/function index for DBCS BufferUpdate
DefaultFmtIndx  equ     0       ; index of default format function
WorldFmtIndx    equ     2       ; index of world format function
PSFmtIndx       equ     4       ; index of default PS format function
ExtPSFmtIndx    equ     6       ; index of extended PS format function

                                ;/DBCS BufferUpdate (bisecting DBCS
                                ; character status)
BisectDBCS_START        equ     0001h   ; bisected starting DBCS character
BisectDBCS_LAST         equ     0002h   ; bisected ending DBCS character
BisectDBCS_LEFT         equ     0004h   ; bisected DBCS character in left side
BisectDBCS_RIGHT        equ     0008h   ; bisected DBCS character in right side

CharBlank       equ     ' '             ; space character
DBCSFlag        equ     01h
TrailByteFlag   equ     80h
SBCS_BYTE       equ     0

;/****************************************************************************
;*
;* MACRO NAME    = CheckLeadByte
;*
;* DESCRIPTION   = Check if DBCS leading byte or not   
;*
;* INPUT         = AL = Checked Character Code Point
;*                 AH = attr#3 when cell size = 4 bytes
;*                    = 0      when cell size = 2 bytes
;*                 DS -> viops_*
;*
;* OUTPUT        = CF = 0 if SBCS      
;*                      1 if DBCS      
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;****************************************************************************/

lcid_mask       equ     00000011B
DBCSEvBufSiz    equ     10
CheckLeadByte macro
        local   DBCS_LOOP, DBCS_NO, DBCS_OK, DBCS_END
        push    cx
        push    dx
        push    bx
        xor     bh,bh
        mov     bl,ah
        and     bl,lcid_mask
        xchg    bx,ax
        mov     dx,size DBCSENVINFO
        mul     dx
        xchg    bx,ax

        clc
        mov     cx,DBCSEvBufSiz/2       ; set loop count

        lds     si,[bp].lpNLSExt        ; ds:si -> dbcs env. buffer

        mov     dx,ds:[bx+si]
DBCS_LOOP:
        cmp     dx,0
        jz      DBCS_END
        cmp     dl,al                   ; comp start value
        ja      DBCS_END                ; smaller than lower limit
        cmp     al,dh                   ; comp stop value
        jbe     DBCS_OK                 ; in range
DBCS_NO:
        inc     si                      ; see next vecter
        inc     si
        mov     dx,ds:[si]
        loop    DBCS_LOOP
DBCS_OK:
        stc
DBCS_END:
        pop     bx
        pop     dx
        pop     cx
        endm
ENDIF ;D1348

