/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*****************************************************************************
 *
 * SOURCE FILE NAME = SVGAWD.C
 *
 * DESCRIPTIVE NAME = Chipdata for Western Digital/Paradise adapters
 *
 *
 * VERSION = V2.2
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * NOTES
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/*
**      Include files
*/

#define PMIDEF_INCL
#include "svga.h"

FILE *textfile;                                                 /*@V3.0YEE05*/
USHORT  ThinkpadRefresh640 = 0;                                 /*@V3.0YEE05*/
USHORT  ThinkpadRefresh800 = 0;                                 /*@V3.0YEE07*/

/*
**
**              Chipset Lock/Unlock Information
**
*/

/*
**      Only CRT ports used and not MONO because VSVGA automatically
**      adjusts the ports depending on the MISC OUTPUT color bit.
*/

REGDATA ParadiseUnLockData1[] =
{
  { PMICMD_INB,   GDC_INDEXPORT, NONE, NONE, 0, NONE,           NULL   },
  { PMICMD_OUTB,  GDC_INDEXPORT, NONE, NONE, 0, WRITEONLY_DATA, b_F    },
  { PMICMD_INB,   GDC_DATAPORT,  NONE, NONE, 1, NONE,           NULL   }, /*          */
  { PMICMD_RMWBI, GDC_INDEXPORT,  GDC_DATAPORT, 0x0f, 0xf8, WRITEONLY_DATA, b_5 }, /*          */
  { PMICMD_OUTB,  GDC_INDEXPORT, NONE, NONE, 0, WRITEREG_DATA,  NULL   },
  { PMICMD_NONE },
};

REGDATA ParadiseLockData1[] =
{
  { PMICMD_REGOP, NONE,          NONE, 0x01, 1, READWRITE_DATA, "\x00" }, /*          */
  { PMICMD_INB,   GDC_INDEXPORT, NONE, NONE, 0, NONE,           NULL   },
  { PMICMD_OUTB,  GDC_INDEXPORT, NONE, NONE, 0, WRITEONLY_DATA, b_F    },
  { PMICMD_OUTB,  GDC_DATAPORT,  NONE, NONE, 1, WRITEREG_DATA,  NULL   },
  { PMICMD_OUTB,  GDC_INDEXPORT, NONE, NONE, 0, WRITEREG_DATA,  NULL   },
  { PMICMD_NONE },
};

REGDATA ParadiseUnLockData2[] =
{
  { PMICMD_INB,   GDC_INDEXPORT,  NONE, NONE, 0, NONE,           NULL   },
  { PMICMD_INB,   CRT_INDEXPORT,  NONE, NONE, 1, NONE,           NULL   },
  { PMICMD_OUTB,  GDC_INDEXPORT,  NONE, NONE, 0, WRITEONLY_DATA, b_F    },
  { PMICMD_INB,   GDC_DATAPORT,   NONE, NONE, 2, NONE,           NULL   }, /*          */
  { PMICMD_RMWBI, GDC_INDEXPORT,  GDC_DATAPORT, 0x0f, 0xf8, WRITEONLY_DATA, b_5 }, /*          */
  { PMICMD_OUTB,  CRT_INDEXPORT,  NONE, NONE, 0, WRITEONLY_DATA, "\x29" },
  { PMICMD_INB,   CRT_DATAPORT,   NONE, NONE, 3, NONE,           NULL   }, /*          */
  { PMICMD_OUTB,  CRT_DATAPORT,   NONE, NONE, 0, WRITEONLY_DATA, "\x85" },
  { PMICMD_OUTB,  CRT_INDEXPORT,  NONE, NONE, 1, WRITEREG_DATA,  NULL   },
  { PMICMD_OUTB,  GDC_INDEXPORT,  NONE, NONE, 0, WRITEREG_DATA,  NULL   },
  { PMICMD_NONE },
};

REGDATA ParadiseLockData2[] =
{
  { PMICMD_REGOP, NONE,           NONE, 0x01, 3, READWRITE_DATA, "\x80" }, /*          */
  { PMICMD_REGOP, NONE,           NONE, 0x01, 2, READWRITE_DATA, "\x00" }, /*          */
  { PMICMD_INB,   GDC_INDEXPORT,  NONE, NONE, 0, NONE,           NULL   },
  { PMICMD_INB,   CRT_INDEXPORT,  NONE, NONE, 1, NONE,           NULL   },
  { PMICMD_OUTB,  CRT_INDEXPORT,  NONE, NONE, 0, WRITEONLY_DATA, "\x29" }, /*          */
  { PMICMD_OUTB,  CRT_DATAPORT,   NONE, NONE, 3, WRITEREG_DATA,  NULL   }, /*          */
  { PMICMD_OUTB,  GDC_INDEXPORT,  NONE, NONE, 0, WRITEONLY_DATA, b_F    }, /*          */
  { PMICMD_OUTB,  GDC_DATAPORT,   NONE, NONE, 2, WRITEREG_DATA,  NULL   }, /*          */
  { PMICMD_OUTB,  CRT_INDEXPORT,  NONE, NONE, 1, WRITEREG_DATA,  NULL   },
  { PMICMD_OUTB,  GDC_INDEXPORT,  NONE, NONE, 0, WRITEREG_DATA,  NULL   },
  { PMICMD_NONE },
};

REGDATA ParadiseUnLockData3[] =
{
  { PMICMD_INB,   GDC_INDEXPORT,  NONE, NONE, 0, NONE,           NULL   },
  { PMICMD_INB,   CRT_INDEXPORT,  NONE, NONE, 1, NONE,           NULL   },
  { PMICMD_INB,   SEQ_INDEXPORT,  NONE, NONE, 2, NONE,           NULL   },
  { PMICMD_OUTB,  GDC_INDEXPORT,  NONE, NONE, 0, WRITEONLY_DATA, b_F    },
  { PMICMD_INB,   GDC_DATAPORT,   NONE, NONE, 3, NONE,           NULL   }, /*          */
  { PMICMD_OUTB,  GDC_DATAPORT,   NONE, NONE, 0, WRITEONLY_DATA, b_5    },
  { PMICMD_OUTB,  CRT_INDEXPORT,  NONE, NONE, 0, WRITEONLY_DATA, "\x29" },
  { PMICMD_INB,   CRT_DATAPORT,   NONE, NONE, 4, NONE,           NULL   }, /*          */
  { PMICMD_OUTB,  CRT_DATAPORT,   NONE, NONE, 0, WRITEONLY_DATA, "\x85" },
  { PMICMD_OUTB,  SEQ_INDEXPORT,  NONE, NONE, 0, WRITEONLY_DATA, "\x48" },
  { PMICMD_INB,   SEQ_INDEXPORT,  NONE, NONE, 5, NONE,           NULL   }, /*          */
  { PMICMD_REGOP, 0x05,           NONE, 0x01, 5, REGISTER_OR,    "\x40" }, /*          */
  { PMICMD_OUTB,  SEQ_INDEXPORT,  NONE, NONE, 0, WRITEONLY_DATA, b_6    },
  { PMICMD_OUTB,  SEQ_DATAPORT,   NONE, NONE, 0, WRITEONLY_DATA, "\x48" },
  { PMICMD_OUTB,  SEQ_INDEXPORT,  NONE, NONE, 2, WRITEREG_DATA,  NULL   },
  { PMICMD_OUTB,  CRT_INDEXPORT,  NONE, NONE, 1, WRITEREG_DATA,  NULL   },
  { PMICMD_OUTB,  GDC_INDEXPORT,  NONE, NONE, 0, WRITEREG_DATA,  NULL   },
  { PMICMD_NONE },
};

REGDATA ParadiseLockData3[] =
{
  { PMICMD_REGOP, NONE,           NONE, 0x01, 5, READWRITE_DATA, "\x40" }, /*          */
  { PMICMD_REGOP, NONE,           NONE, 0x01, 4, READWRITE_DATA, "\x80" }, /*          */
  { PMICMD_REGOP, NONE,           NONE, 0x01, 3, READWRITE_DATA, "\x00" }, /*          */
  { PMICMD_INB,   GDC_INDEXPORT,  NONE, NONE, 0, NONE,           NULL   },
  { PMICMD_INB,   CRT_INDEXPORT,  NONE, NONE, 1, NONE,           NULL   },
  { PMICMD_INB,   SEQ_INDEXPORT,  NONE, NONE, 2, NONE,           NULL   },
  { PMICMD_OUTB,  SEQ_INDEXPORT,  NONE, NONE, 0, WRITEONLY_DATA, b_6    }, /*          */
  { PMICMD_OUTB,  SEQ_DATAPORT,   NONE, NONE, 5, WRITEREG_DATA,  NULL   }, /*          */
  { PMICMD_OUTB,  CRT_INDEXPORT,  NONE, NONE, 0, WRITEONLY_DATA, "\x29" }, /*          */
  { PMICMD_OUTB,  CRT_DATAPORT,   NONE, NONE, 4, WRITEREG_DATA,  NULL   }, /*          */
  { PMICMD_OUTB,  GDC_INDEXPORT,  NONE, NONE, 0, WRITEONLY_DATA, b_F    }, /*          */
  { PMICMD_OUTB,  GDC_DATAPORT,   NONE, NONE, 3, WRITEREG_DATA,  NULL   }, /*          */
  { PMICMD_OUTB,  SEQ_INDEXPORT,  NONE, NONE, 2, WRITEREG_DATA,  NULL   },
  { PMICMD_OUTB,  CRT_INDEXPORT,  NONE, NONE, 1, WRITEREG_DATA,  NULL   },
  { PMICMD_OUTB,  GDC_INDEXPORT,  NONE, NONE, 0, WRITEREG_DATA,  NULL   },
  { PMICMD_NONE },
};

/**  IF YOU CHANGE R5, CHANGE WRITELOCKDATA IN SVGA.C !!!!!  @V3.0YEE01 **/
/**  R5 REFERENCES CRT34 (PR1B).  THIS IS FOR UNLOCKDATA4.   @V3.0YEE01 **/
REGDATA ParadiseUnLockData4[] =
{
  { PMICMD_INB,   GDC_INDEXPORT,  NONE, NONE,  0, NONE,           NULL   },
  { PMICMD_INB,   CRT_INDEXPORT,  NONE, NONE,  1, NONE,           NULL   },
  { PMICMD_INB,   SEQ_INDEXPORT,  NONE, NONE,  2, NONE,           NULL   },
  { PMICMD_OUTB,  GDC_INDEXPORT,  NONE, NONE,  0, WRITEONLY_DATA, b_F    },
  { PMICMD_INB,   GDC_DATAPORT,   NONE, NONE,  3, NONE,           NULL   }, /*          */
  { PMICMD_RMWBN, GDC_DATAPORT,   GDC_DATAPORT, 0x0f, 0xf8, WRITEONLY_DATA, b_5 }, /*          */
#if WD90C2X_SHADOW_LOCKED                                       /*          */
#else                                                           /*          */
  { PMICMD_OUTB,  CRT_INDEXPORT,  NONE, NONE,  0, WRITEONLY_DATA, "\x29" }, /*          */
  { PMICMD_OUTB,  CRT_DATAPORT,   NONE, NONE,  0, WRITEONLY_DATA, "\xd5" }, /*          */
  { PMICMD_OUTB,  CRT_INDEXPORT,  NONE, NONE,  0, WRITEONLY_DATA, "\x27" }, /*          */
  { PMICMD_OUTB,  CRT_DATAPORT,   NONE, NONE,  0, WRITEONLY_DATA, "\x80" }, /*          */
#endif                                                          /*          */
  { PMICMD_OUTB,  CRT_INDEXPORT,  NONE, NONE,  0, WRITEONLY_DATA, "\x29" },
  { PMICMD_INB,   CRT_DATAPORT,   NONE, NONE,  4, NONE,           NULL   }, /*          */
  { PMICMD_OUTB,  CRT_DATAPORT,   NONE, NONE,  0, WRITEONLY_DATA, "\xa5" },
  { PMICMD_OUTB,  CRT_INDEXPORT,  NONE, NONE,  0, WRITEONLY_DATA, "\x34" }, /*          */
  { PMICMD_INB,   CRT_DATAPORT,   NONE, NONE,  5, NONE,           NULL   }, /*          */
  { PMICMD_REGOP, 0x05,           NONE, 0x01,  5, REGISTER_AND,   "\xf8" }, /*          */
#if WD90C2X_SHADOW_LOCKED                                       /*          */
  { PMICMD_RMWBN, CRT_DATAPORT,   CRT_DATAPORT, 0x34, 0x07, WRITEONLY_DATA, "\xa0" }, /*          */
#else                                                           /*          */
  { PMICMD_OUTB,  CRT_DATAPORT,   NONE, NONE,  0, WRITEONLY_DATA, "\xa6" }, /*          */
#endif                                                          /*          */
  { PMICMD_OUTB,  CRT_INDEXPORT,  NONE, NONE,  0, WRITEONLY_DATA, "\x35" }, /*          */
  { PMICMD_INB,   CRT_DATAPORT,   NONE, NONE,  6, NONE,           NULL   }, /*          */
  { PMICMD_OUTB,  CRT_DATAPORT,   NONE, NONE,  0, WRITEONLY_DATA, "\x30" }, /*          */
  { PMICMD_OUTB,  SEQ_INDEXPORT,  NONE, NONE,  0, WRITEONLY_DATA, "\x48" },
  { PMICMD_INB,   SEQ_INDEXPORT,  NONE, NONE,  7, NONE,           NULL   }, /*          */
  { PMICMD_REGOP, 0x07,           NONE, 0x01,  7, REGISTER_OR,    "\x40" }, /*          */
  { PMICMD_OUTB,  SEQ_INDEXPORT,  NONE, NONE,  0, WRITEONLY_DATA, b_6    },
  { PMICMD_OUTB,  SEQ_DATAPORT,   NONE, NONE,  0, WRITEONLY_DATA, "\x48" },
  { PMICMD_OUTB,  SEQ_INDEXPORT,  NONE, NONE,  0, WRITEONLY_DATA, "\x35" }, /*          */
  { PMICMD_INB,   SEQ_DATAPORT,   NONE, NONE,  8, NONE,           NULL   }, /*          */
  { PMICMD_OUTB,  SEQ_DATAPORT,   NONE, NONE,  0, WRITEONLY_DATA, "\x50" }, /*          */
  { PMICMD_OUTB,  CRT_INDEXPORT,  NONE, NONE,  0, WRITEONLY_DATA, "\x2a" }, /*@V3.0YEE04*/
  { PMICMD_INB,   CRT_DATAPORT,   NONE, NONE,  9, NONE,           NULL   }, /*@V3.0YEE04*/
  { PMICMD_REGOP, 0x09,           NONE, 0x01, 0x0a, REGISTER_OPERAND},      /*@V3.0YEE04*/
  { PMICMD_REGOP, 0x0a,           NONE, 0x01, 0x0a, REGISTER_AND,   "\xf8" }, /*@V3.0YEE04*/
  { PMICMD_OUTB,  CRT_DATAPORT,   NONE, NONE, 0x0a, WRITEREG_DATA,  NULL   }, /*@V3.0YEE04*/
  { PMICMD_OUTB,  SEQ_INDEXPORT,  NONE, NONE,  2, WRITEREG_DATA,  NULL   },
  { PMICMD_OUTB,  CRT_INDEXPORT,  NONE, NONE,  1, WRITEREG_DATA,  NULL   },
  { PMICMD_OUTB,  GDC_INDEXPORT,  NONE, NONE,  0, WRITEREG_DATA,  NULL   },
  { PMICMD_NONE },
};

REGDATA ParadiseLockData4[] =
{
  { PMICMD_REGOP, NONE,           NONE, 0x01,  9, READWRITE_DATA, "\x07" }, /*@V3.0YEE04*/
  { PMICMD_REGOP, NONE,           NONE, 0x01,  8, READWRITE_DATA, "\x43" }, /*          */
  { PMICMD_REGOP, NONE,           NONE, 0x01,  7, READWRITE_DATA, "\x40" }, /*          */
  { PMICMD_REGOP, NONE,           NONE, 0x01,  6, READWRITE_DATA, "\xcf" }, /*          */
  { PMICMD_REGOP, NONE,           NONE, 0x01,  5, READWRITE_DATA, "\x59" }, /*          */
  { PMICMD_REGOP, NONE,           NONE, 0x01,  4, READWRITE_DATA, "\xa2" }, /*          */
  { PMICMD_REGOP, NONE,           NONE, 0x01,  3, READWRITE_DATA, "\x00" }, /*          */
  { PMICMD_INB,   GDC_INDEXPORT,  NONE, NONE,  0, NONE,           NULL   },
  { PMICMD_INB,   CRT_INDEXPORT,  NONE, NONE,  1, NONE,           NULL   },
  { PMICMD_INB,   SEQ_INDEXPORT,  NONE, NONE,  2, NONE,           NULL   },
  { PMICMD_OUTB,  CRT_INDEXPORT,  NONE, NONE,  0, WRITEONLY_DATA, "\x2a" }, /*@V3.0YEE04*/
  { PMICMD_OUTB,  CRT_DATAPORT,   NONE, NONE,  9, WRITEREG_DATA,  NULL   }, /*@V3.0YEE04*/
  { PMICMD_OUTB,  SEQ_INDEXPORT,  NONE, NONE,  0, WRITEONLY_DATA, "\x35" }, /*          */
  { PMICMD_OUTB,  SEQ_DATAPORT,   NONE, NONE,  8, WRITEREG_DATA,  NULL   }, /*          */
  { PMICMD_OUTB,  SEQ_INDEXPORT,  NONE, NONE,  0, WRITEONLY_DATA, b_6    }, /*          */
  { PMICMD_OUTB,  SEQ_DATAPORT,   NONE, NONE,  7, WRITEREG_DATA,  NULL   }, /*          */
  { PMICMD_OUTB,  CRT_INDEXPORT,  NONE, NONE,  0, WRITEONLY_DATA, "\x35" }, /*          */
  { PMICMD_OUTB,  CRT_DATAPORT,   NONE, NONE,  6, WRITEREG_DATA,  NULL   }, /*          */
  { PMICMD_OUTB,  CRT_INDEXPORT,  NONE, NONE,  0, WRITEONLY_DATA, "\x34" }, /*          */
  { PMICMD_INB,   CRT_DATAPORT,   NONE, NONE,  6, NONE,           NULL   }, /*          */
  { PMICMD_REGOP, 0x06,           NONE, 0x01,  6, REGISTER_AND,   "\x07" }, /*          */
  { PMICMD_REGOP, 0x06,           NONE, 0x01,  5, REGISTER_OR | REGISTER_OPEQUAL | REGISTER_OPERAND, NULL }, /*          */
  { PMICMD_OUTB,  CRT_DATAPORT,   NONE, NONE,  5, WRITEREG_DATA,  NULL   }, /*          */
#if WD90C2X_SHADOW_LOCKED                                       /*          */
#else                                                           /*          */
  { PMICMD_OUTB,  CRT_INDEXPORT,  NONE, NONE,  0, WRITEONLY_DATA, "\x29" }, /*          */
  { PMICMD_OUTB,  CRT_DATAPORT,   NONE, NONE,  0, WRITEONLY_DATA, "\xd5" }, /*          */
  { PMICMD_OUTB,  CRT_INDEXPORT,  NONE, NONE,  0, WRITEONLY_DATA, "\x27" }, /*          */
  { PMICMD_OUTB,  CRT_DATAPORT,   NONE, NONE,  0, WRITEONLY_DATA, "\x00" }, /*          */
#endif                                                          /*          */
  { PMICMD_OUTB,  CRT_INDEXPORT,  NONE, NONE,  0, WRITEONLY_DATA, "\x29" }, /*          */
  { PMICMD_OUTB,  CRT_DATAPORT,   NONE, NONE,  4, WRITEREG_DATA,  NULL   }, /*          */
  { PMICMD_OUTB,  GDC_INDEXPORT,  NONE, NONE,  0, WRITEONLY_DATA, b_F    }, /*          */
  { PMICMD_OUTB,  GDC_DATAPORT,   NONE, NONE,  3, WRITEREG_DATA,  NULL   }, /*          */
  { PMICMD_OUTB,  SEQ_INDEXPORT,  NONE, NONE,  2, WRITEREG_DATA,  NULL   },
  { PMICMD_OUTB,  CRT_INDEXPORT,  NONE, NONE,  1, WRITEREG_DATA,  NULL   },
  { PMICMD_OUTB,  GDC_INDEXPORT,  NONE, NONE,  0, WRITEREG_DATA,  NULL   },
  { PMICMD_NONE },
};

/*
**
**              Chipset Cleanup Information
**
*/
                                                                  /*          */
/*
**          WARNING:
**              PR18 for LCD/FLAT PANELS is 3x5.31 Flat Panel Status (C24)
**              PR18 for desktops is 3x5.3e Vertical Timing Overflow (C31/C33)
**              PR18A for LCD/FLAT PANELS is 3x5.3d Vertical Timing Overflow (C24)
**
**          WARNING:
**              3x5.3e is PR18 Vertical Timing Overflow for desktops (C33)
**              3x5.3e is PR39 Flat Panel Blinking for LCD/FLAT PANELS (C24)
**
**          So we cannot just read 3x5.3e and expect the Vertical
**          Timing Overflow, without knowing which chip we have!
*/

REGDATA WDCleanData1[] = /* Desktops <= C31 */
{
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x07, 0x00, READWRITE_DATA, &SEQRegData[0x07] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x08, 0x00, READWRITE_DATA, &SEQRegData[0x08] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x09, 0x00, READWRITE_DATA, &SEQRegData[0x09] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x10, 0x20, READWRITE_DATA, &SEQRegData[0x10] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x11, 0x00, READWRITE_DATA, &SEQRegData[0x11] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x12, 0x00, READWRITE_DATA, &SEQRegData[0x12] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x20, 0x00, READWRITE_DATA, &SEQRegData[0x20] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x21, 0x07, READWRITE_DATA, &SEQRegData[0x21] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x22, 0x00, READWRITE_DATA, &SEQRegData[0x22] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x23, 0x00, READWRITE_DATA, &SEQRegData[0x23] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x24, 0x00, READWRITE_DATA, &SEQRegData[0x24] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x25, 0x00, READWRITE_DATA, &SEQRegData[0x25] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x26, 0x00, READWRITE_DATA, &SEQRegData[0x26] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x27, 0x00, READWRITE_DATA, &SEQRegData[0x27] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x28, 0x00, READWRITE_DATA, &SEQRegData[0x28] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x29, 0x04, READWRITE_DATA, &SEQRegData[0x29] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x31, 0x00, READWRITE_DATA, &SEQRegData[0x31] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x33, 0x00, READWRITE_DATA, &SEQRegData[0x33] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x34, 0x00, READWRITE_DATA, &SEQRegData[0x34] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x36, 0x00, READWRITE_DATA, &SEQRegData[0x36] }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x2c, 0x00, READWRITE_DATA, &CRTRegData[0x2c] }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x2d, 0x00, WRITEONLY_DATA, b_0 },
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x2e, 0x00, READWRITE_DATA, &CRTRegData[0x2e] },
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x2f, 0x00, WRITEONLY_DATA, "\x42" },
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x31, 0x87, READWRITE_DATA, &CRTRegData[0x31] }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x32, 0x74, READWRITE_DATA, &CRTRegData[0x32] }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x33, 0x61, READWRITE_DATA, &CRTRegData[0x33] }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x34, 0x1f, READWRITE_DATA, &CRTRegData[0x34] }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x36, 0x00, READWRITE_DATA, &CRTRegData[0x36] }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x37, 0x00, READWRITE_DATA, &CRTRegData[0x37] }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x38, 0x00, READWRITE_DATA, &CRTRegData[0x38] }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x39, 0x00, READWRITE_DATA, &CRTRegData[0x39] }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x3a, 0x02, READWRITE_DATA, &CRTRegData[0x3a] }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x3c, 0x3f, READWRITE_DATA, &CRTRegData[0x3c] }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x3e, 0x00, READWRITE_DATA, &CRTRegData[0x3e] }, /*          */
  { PMICMD_RMWBI, GDC_INDEXPORT, GDC_DATAPORT, 0x09, 0x00, WRITEONLY_DATA, b_0 },
  { PMICMD_RMWBI, GDC_INDEXPORT, GDC_DATAPORT, 0x0a, 0x00, READWRITE_DATA, &GDCRegData[0x0a] }, /*          */
  { PMICMD_RMWBI, GDC_INDEXPORT, GDC_DATAPORT, 0x0b, 0x00, READWRITE_DATA, &GDCRegData[0x0b] }, /*          */
  { PMICMD_RMWBI, GDC_INDEXPORT, GDC_DATAPORT, 0x0c, 0xe7, READWRITE_DATA, &GDCRegData[0x0c] },
  { PMICMD_RMWBI, GDC_INDEXPORT, GDC_DATAPORT, 0x0d, 0x00, READWRITE_DATA, &GDCRegData[0x0d] }, /*          */
  { PMICMD_RMWBI, GDC_INDEXPORT, GDC_DATAPORT, 0x0e, 0x60, WRITEONLY_DATA, b_0 },
  { PMICMD_RMWBI, GDC_INDEXPORT, GDC_DATAPORT, 0x0f, 0x00, READWRITE_DATA, &GDCRegData[0x0f] }, /*          */
  { PMICMD_OUTW,  WD_INDEXPORT,  WD_INDEXPORT, 0x00, 0x00, WRITEONLY_DATA, "\x02\x00" }, /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   WD_DATAPORT,  0x00, 0x00, WRITEONLY_DATA, "\x00\x10" }, /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   WD_DATAPORT,  0x00, 0x00, WRITEONLY_DATA, "\x00\x20" }, /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   WD_DATAPORT,  0x00, 0x00, WRITEONLY_DATA, "\xc0\x67" }, /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   WD_DATAPORT,  0x00, 0x00, WRITEONLY_DATA, "\x00\x70" }, /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   WD_DATAPORT,  0x00, 0x00, WRITEONLY_DATA, &MiscRegData [2*0x20] }, /*          */
  /* Fix VSVGA to not shadow cursor previous turn on */                                  /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   WD_DATAPORT,  0x00, 0x00, WRITEONLY_DATA, "\x00\xf0" }, /*          */
  { PMICMD_NONE },
};

REGDATA WDCleanData2[] = /* Laptops <= C27 */
{
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x07, 0x00, READWRITE_DATA, &SEQRegData[0x07] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x08, 0x00, READWRITE_DATA, &SEQRegData[0x08] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x09, 0x00, READWRITE_DATA, &SEQRegData[0x09] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x10, 0x20, READWRITE_DATA, &SEQRegData[0x10] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x11, 0x00, READWRITE_DATA, &SEQRegData[0x11] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x12, 0x04, READWRITE_DATA, &SEQRegData[0x12] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x13, 0x03, READWRITE_DATA, &SEQRegData[0x13] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x20, 0x00, READWRITE_DATA, &SEQRegData[0x20] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x21, 0x07, READWRITE_DATA, &SEQRegData[0x21] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x22, 0x00, READWRITE_DATA, &SEQRegData[0x22] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x23, 0x00, READWRITE_DATA, &SEQRegData[0x23] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x24, 0x00, READWRITE_DATA, &SEQRegData[0x24] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x25, 0x00, READWRITE_DATA, &SEQRegData[0x25] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x26, 0x00, READWRITE_DATA, &SEQRegData[0x26] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x27, 0x10, READWRITE_DATA, &SEQRegData[0x27] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x28, 0x00, READWRITE_DATA, &SEQRegData[0x28] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x29, 0x0c, READWRITE_DATA, &SEQRegData[0x29] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x31, 0x00, READWRITE_DATA, &SEQRegData[0x31] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x33, 0x00, READWRITE_DATA, &SEQRegData[0x33] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x34, 0x00, READWRITE_DATA, &SEQRegData[0x34] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x36, 0x00, READWRITE_DATA, &SEQRegData[0x36] }, /*          */
#if WD90C2X_SHADOW_LOCKED                                         /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x2b, 0x00, READWRITE_DATA, &CRTRegData[0x2b] }, /*          */
#else                                                             /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x2b, 0xff, READWRITE_DATA, &CRTRegData[0x2b] }, /*          */
#endif                                                            /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x2c, 0x00, READWRITE_DATA, &CRTRegData[0x2c] }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x2d, 0x00, WRITEONLY_DATA, b_0 },
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x2e, 0x40, READWRITE_DATA, &CRTRegData[0x2e] }, /*@V3.0YEE06*/
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x2f, 0x00, WRITEONLY_DATA, "\x42" },
  /* Get Dual panel/16-bit STN state as 0x40/0x00 */                                            /*@V3.0MNH01*/
  { PMICMD_OUTB,  CRT_INDEXPORT, NONE,         NONE, 0x00, WRITEONLY_DATA, "\x33" },            /*@V3.0MNH01*/
  { PMICMD_INB,   CRT_DATAPORT,  NONE,         NONE, 0x01, NONE,           NULL },              /*@V3.0MNH01*/
  { PMICMD_REGOP, 0x01,          NONE,         0x01, 0x02, REGISTER_SHL,   b_1 },               /*@V3.0MNH01*/
  { PMICMD_REGOP, 0x02,          NONE,         0x01, 0x01, REGISTER_AND | REGISTER_OPEQUAL | REGISTER_OPERAND, NULL },/*@V3.0MNH01*/
  { PMICMD_REGOP, 0x01,          NONE,         0x01, 0x01, REGISTER_AND,   "\x40" },            /*@V3.0MNH02*/
  /* Undocumented feature:  3d4.30 is READ (not write!) locked by */                            /*          */
  /* UNLOCKing (not locking!) 3d4.34.  Furthermore the first reads */                           /*          */
  /* after locking may be return the 3d4.34 lock value instead! */                              /*          */
  /* It is still unclear what else to do before it becomes OK to read! */                       /*          */
  /* So we just write it without really reading it! */                                          /*          */
//{ PMICMD_OUTB,  CRT_INDEXPORT, NONE,         NONE, 0x00, EXECUTE_CMD | WRITEONLY_DATA, "\x34" }, /*          */
//{ PMICMD_INB,   CRT_DATAPORT,  NONE,         NONE, 0x00, EXECUTE_CMD | NONE,           NULL   }, /*          */
//{ PMICMD_OUTB,  CRT_DATAPORT,  NONE,         NONE, 0x00, EXECUTE_CMD | WRITEONLY_DATA, "\x30" }, /*          */
//{ PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x30, 0x30, READWRITE_DATA, &CRTRegData[0x30] }, /*          */
//{ PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x30, 0x00, WRITEONLY_DATA, &CRTRegData[0x30] }, /*@V3.0MNH01*/
  { PMICMD_OUTB,  CRT_INDEXPORT, NONE,         NONE, 0x00, WRITEONLY_DATA, "\x30" },            /*@V3.0MNH01*/
  { PMICMD_OUTB,  CRT_DATAPORT,  NONE,         NONE, 0x01, WRITEREG_DATA,  NULL },              /*@V3.0MNH01*/
//{ PMICMD_OUTB,  CRT_INDEXPORT, NONE,         NONE, 0x00, EXECUTE_CMD | WRITEONLY_DATA, "\x34" }, /*          */
//{ PMICMD_OUTB,  CRT_DATAPORT,  NONE,         NONE, 0x00, EXECUTE_CMD | WRITEREG_DATA,  NULL   }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x31, 0x87, READWRITE_DATA, &CRTRegData[0x31] }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x32, 0x7c, READWRITE_DATA, &CRTRegData[0x32] }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x33, 0x61, READWRITE_DATA, &CRTRegData[0x33] }, /*          */
//@V3.0YEE02 { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x34, 0x1f, READWRITE_DATA, &CRTRegData[0x34] }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x36, 0x00, READWRITE_DATA, &CRTRegData[0x36] }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x37, 0x00, READWRITE_DATA, &CRTRegData[0x37] }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x38, 0x00, READWRITE_DATA, &CRTRegData[0x38] }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x39, 0x00, READWRITE_DATA, &CRTRegData[0x39] }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x3a, 0x02, READWRITE_DATA, &CRTRegData[0x3a] }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x3c, 0x3f, READWRITE_DATA, &CRTRegData[0x3c] }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x3e, 0xa7, READWRITE_DATA, &CRTRegData[0x3e] }, /*          */
  { PMICMD_RMWBI, GDC_INDEXPORT, GDC_DATAPORT, 0x09, 0x00, WRITEONLY_DATA, b_0 },
  { PMICMD_RMWBI, GDC_INDEXPORT, GDC_DATAPORT, 0x0a, 0x00, READWRITE_DATA, &GDCRegData[0x0a] }, /*          */
  /* Get internal/external state as 0x40/0x00 */                                                /*          */
  { PMICMD_OUTB,  CRT_INDEXPORT, NONE,         NONE, 0x00, WRITEONLY_DATA, "\x32" },            /*          */
  { PMICMD_INB,   CRT_DATAPORT,  NONE,         NONE, 0x00, NONE,           NULL },              /*          */
  { PMICMD_REGOP, 0x00,          NONE,         0x01, 0x02, REGISTER_AND,   "\x20" },            /*@V3.0MNH01*/
  { PMICMD_REGOP, 0x02,          NONE,         0x01, 0x02, REGISTER_XOR,   "\x20" },            /*@V3.0MNH01*/
  { PMICMD_REGOP, 0x02,          NONE,         0x01, 0x02, REGISTER_SHL,   b_1 },               /*@V3.0MNH01*/
  { PMICMD_REGOP, 0x00,          NONE,         0x01, 0x00, REGISTER_AND,   "\x10" },            /*@V3.0MNH02*/
  { PMICMD_REGOP, 0x00,          NONE,         0x01, 0x00, REGISTER_SHL,   b_2 },               /*@V3.0MNH02*/
  { PMICMD_REGOP, 0x02,          NONE,         0x01, 0x00, REGISTER_OR | REGISTER_OPEQUAL | REGISTER_OPERAND, NULL }, /*@V3.0MNH01*/
  /* Get internal and Dual panel/16-bit STN state as 0x40/0x00 */                               /*          */
  { PMICMD_REGOP, 0x01,          NONE,         0x01, 0x00, REGISTER_AND | REGISTER_OPEQUAL | REGISTER_OPERAND, NULL },/*          */
  /* Allow 1M only if NOT internal dual panel 16-bit STN! */                                    /*          */
  { PMICMD_REGOP, 0x00,          NONE,         0x01, 0x00, REGISTER_XOR,   "\xff" },            /*          */
  { PMICMD_RMWBI, GDC_INDEXPORT, GDC_DATAPORT, 0x0b, 0x00, READWRITE_DATA, &GDCRegData[0x0b] }, /*          */
  { PMICMD_OUTB,  GDC_INDEXPORT, NONE,         NONE, 0x00, WRITEONLY_DATA, b_B },               /*          */
  { PMICMD_INB,   GDC_DATAPORT,  NONE,         NONE, 0x01, NONE,           NULL },              /*          */
  { PMICMD_REGOP, 0x00,          NONE,         0x01, 0x01, REGISTER_AND | REGISTER_OPEQUAL | REGISTER_OPERAND, NULL },/*          */
  { PMICMD_OUTB,  GDC_DATAPORT,  NONE,         NONE, 0x01, WRITEREG_DATA,  NULL },              /*          */
  { PMICMD_RMWBI, GDC_INDEXPORT, GDC_DATAPORT, 0x0c, 0xe7, READWRITE_DATA, &GDCRegData[0x0c] },
  { PMICMD_RMWBI, GDC_INDEXPORT, GDC_DATAPORT, 0x0d, 0x00, READWRITE_DATA, &GDCRegData[0x0d] }, /*          */
  { PMICMD_RMWBI, GDC_INDEXPORT, GDC_DATAPORT, 0x0e, 0x60, WRITEONLY_DATA, b_0 },
  { PMICMD_RMWBI, GDC_INDEXPORT, GDC_DATAPORT, 0x0f, 0x00, READWRITE_DATA, &GDCRegData[0x0f] }, /*          */
  { PMICMD_OUTW,  WD_INDEXPORT,  WD_INDEXPORT, 0x00, 0x00, WRITEONLY_DATA, "\x02\x00" }, /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   WD_DATAPORT,  0x00, 0x00, WRITEONLY_DATA, "\x00\x10" }, /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   WD_DATAPORT,  0x00, 0x00, WRITEONLY_DATA, "\x00\x20" }, /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   WD_DATAPORT,  0x00, 0x00, WRITEONLY_DATA, "\xc0\x67" }, /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   WD_DATAPORT,  0x00, 0x00, WRITEONLY_DATA, "\x00\x70" }, /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   WD_DATAPORT,  0x00, 0x00, WRITEONLY_DATA, &MiscRegData [2*0x20] }, /*          */
  /* Fix VSVGA to not shadow cursor previous turn on */                                  /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   WD_DATAPORT,  0x00, 0x00, WRITEONLY_DATA, "\x00\xf0" }, /*          */
  { PMICMD_NONE },
};

REGDATA WDCleanData3[] = /* Desktops >= C33 */
{
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x07, 0x00, READWRITE_DATA, &SEQRegData[0x07] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x08, 0x00, READWRITE_DATA, &SEQRegData[0x08] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x09, 0x00, READWRITE_DATA, &SEQRegData[0x09] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x10, 0x20, READWRITE_DATA, &SEQRegData[0x10] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x11, 0x00, READWRITE_DATA, &SEQRegData[0x11] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x12, 0x00, READWRITE_DATA, &SEQRegData[0x12] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x20, 0x00, READWRITE_DATA, &SEQRegData[0x20] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x21, 0x07, READWRITE_DATA, &SEQRegData[0x21] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x22, 0x00, READWRITE_DATA, &SEQRegData[0x22] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x23, 0x00, READWRITE_DATA, &SEQRegData[0x23] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x24, 0x00, READWRITE_DATA, &SEQRegData[0x24] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x25, 0x00, READWRITE_DATA, &SEQRegData[0x25] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x26, 0x00, READWRITE_DATA, &SEQRegData[0x26] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x27, 0x00, READWRITE_DATA, &SEQRegData[0x27] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x28, 0x00, READWRITE_DATA, &SEQRegData[0x28] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x29, 0x04, READWRITE_DATA, &SEQRegData[0x29] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x31, 0x00, READWRITE_DATA, &SEQRegData[0x31] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x33, 0x00, READWRITE_DATA, &SEQRegData[0x33] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x34, 0x00, READWRITE_DATA, &SEQRegData[0x34] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x36, 0x00, READWRITE_DATA, &SEQRegData[0x36] }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x2c, 0x00, READWRITE_DATA, &CRTRegData[0x2c] }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x2d, 0x00, WRITEONLY_DATA, b_0 },
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x2e, 0x00, READWRITE_DATA, &CRTRegData[0x2e] },
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x2f, 0x00, WRITEONLY_DATA, "\x42" },
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x31, 0x87, READWRITE_DATA, &CRTRegData[0x31] }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x32, 0x74, READWRITE_DATA, &CRTRegData[0x32] }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x33, 0x61, READWRITE_DATA, &CRTRegData[0x33] }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x34, 0x1f, READWRITE_DATA, &CRTRegData[0x34] }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x36, 0x00, READWRITE_DATA, &CRTRegData[0x36] }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x37, 0x00, READWRITE_DATA, &CRTRegData[0x37] }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x38, 0x00, READWRITE_DATA, &CRTRegData[0x38] }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x39, 0x00, READWRITE_DATA, &CRTRegData[0x39] }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x3a, 0x02, READWRITE_DATA, &CRTRegData[0x3a] }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x3c, 0x3f, READWRITE_DATA, &CRTRegData[0x3c] }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x3e, 0x00, READWRITE_DATA, &CRTRegData[0x3e] }, /*          */
  { PMICMD_RMWBI, GDC_INDEXPORT, GDC_DATAPORT, 0x09, 0x00, WRITEONLY_DATA, b_0 },
  { PMICMD_RMWBI, GDC_INDEXPORT, GDC_DATAPORT, 0x0a, 0x00, READWRITE_DATA, &GDCRegData[0x0a] }, /*          */
  { PMICMD_RMWBI, GDC_INDEXPORT, GDC_DATAPORT, 0x0b, 0x00, READWRITE_DATA, &GDCRegData[0x0b] }, /*          */
  { PMICMD_RMWBI, GDC_INDEXPORT, GDC_DATAPORT, 0x0c, 0xe7, READWRITE_DATA, &GDCRegData[0x0c] },
  { PMICMD_RMWBI, GDC_INDEXPORT, GDC_DATAPORT, 0x0d, 0x00, READWRITE_DATA, &GDCRegData[0x0d] }, /*          */
  { PMICMD_RMWBI, GDC_INDEXPORT, GDC_DATAPORT, 0x0e, 0x60, WRITEONLY_DATA, b_0 },
  { PMICMD_RMWBI, GDC_INDEXPORT, GDC_DATAPORT, 0x0f, 0x00, READWRITE_DATA, &GDCRegData[0x0f] }, /*          */
  { PMICMD_OUTW,  WD_INDEXPORT,  NONE,         0x00, 0x00, WRITEONLY_DATA, "\x02\x00" }, /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE,         0x00, 0x00, WRITEONLY_DATA, "\x00\x10" }, /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE,         0x00, 0x00, WRITEONLY_DATA, "\x00\x20" }, /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE,         0x00, 0x00, WRITEONLY_DATA, "\xc0\xd7" }, /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE,         0x00, 0x00, WRITEONLY_DATA, "\x00\xe0" }, /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE,         0x00, 0x00, WRITEONLY_DATA, &MiscRegData [2*0x20] }, /*          */
  /* Fix VSVGA to not shadow cursor previous turn on */                                  /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   WD_DATAPORT,  0x00, 0x00, WRITEONLY_DATA, "\x00\xf0" }, /*          */
  { PMICMD_OUTW,  WD_BUSPORT,    WD_BUSPORT,   NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x50] }, /*          */
  { PMICMD_OUTW,  WD_MEMPORT,    WD_MEMPORT,   NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x51] }, /*          */
  { PMICMD_OUTW,  WD_BUSPORT2,   WD_BUSPORT2,  NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x52] }, /*          */
  { PMICMD_OUTW,  WD_MEMPORT2,   WD_MEMPORT2,  NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x53] }, /*          */
  { PMICMD_NONE },
};

/*
**
**              Chipset Setbank Information
**
**              Set/Get Banks are based on svgabank.asm in screendd
**              of Picard.           
**
**              Registers are unlocked already and always set/get
**              write bank only.
**
*/

REGDATA ParadiseSetBankCmd[] =
/************************************************ Borg 2/8/94

Western Digital
  r0 = 0;
  inb(r1, 0x3ce);             save index
  outb(0x3ce, 0x11);          fix system interface reg.
  inb(r2, 0x3cf);
  r2 &= 0x7f;
  outb(0x3cf, r2);
  outb(0x3ce, 0x0b);          fix memory size reg.
  inb(r3, 0x3cf);
  r3 &= 0xf7;
  outb(0x3cf, r3);
  r0 <= 0x04;
  outb(0x3ce, 0x09);          set bank
  outb(0x3cf, r0);
  outb(0x3ce, r1);            restore index
***************************************************************/
{
  { PMICMD_REGOP, NONE,          NONE, 0x01, 0x00, WRITEONLY_DATA, b_0 },
  { PMICMD_INB,   GDC_INDEXPORT, NONE, NONE, 0x01, NONE,           NULL },
  { PMICMD_OUTB,  GDC_INDEXPORT, NONE, NONE, 0x00, WRITEONLY_DATA, "\x11" },
  { PMICMD_INB,   GDC_DATAPORT,  NONE, NONE, 0x02, NONE,           NULL },
  { PMICMD_REGOP, 0x02,          NONE, 0x01, 0x02, REGISTER_AND,   "\x7f" }, /*          */
  { PMICMD_OUTB,  GDC_DATAPORT,  NONE, NONE, 0x02, WRITEREG_DATA,  NULL },
  { PMICMD_OUTB,  GDC_INDEXPORT, NONE, NONE, 0x00, WRITEONLY_DATA, b_B },
  { PMICMD_INB,   GDC_DATAPORT,  NONE, NONE, 0x03, NONE,           NULL },
  { PMICMD_REGOP, 0x03,          NONE, 0x01, 0x03, REGISTER_AND,   "\xf7" }, /*          */
  { PMICMD_OUTB,  GDC_DATAPORT,  NONE, NONE, 0x03, WRITEREG_DATA,  NULL },
  { PMICMD_REGOP, 0x00,          NONE, 0x01, 0x00, REGISTER_SHL,   b_4 },    /*          */
  { PMICMD_OUTB,  GDC_INDEXPORT, NONE, NONE, 0x00, WRITEONLY_DATA, b_9 },
  { PMICMD_OUTB,  GDC_DATAPORT,  NONE, NONE, 0x00, WRITEREG_DATA,  NULL },
  { PMICMD_OUTB,  GDC_INDEXPORT, NONE, NONE, 0x01, WRITEREG_DATA,  NULL },
  { PMICMD_NONE },
};

/*
**
**              Chipset Getbank Information            
**
*/

REGDATA ParadiseGetBankCmd[] =
/*********************************************  Borg 2/8/94
----------------------------------------------
WD getbank

inb (r1, 0x3ce); save current index
outb(0x3ce, 0x09);   getbank
inb(r0, 0x3cf);
r0 >= 0x04;
outb(0x3ce, r1); restore index

***************************************************************/
{
  { PMICMD_INB,   GDC_INDEXPORT, NONE, NONE, 0x01, NONE,           NULL },
  { PMICMD_OUTB,  GDC_INDEXPORT, NONE, NONE, 0x00, WRITEONLY_DATA, b_9 },
  { PMICMD_INB,   GDC_DATAPORT,  NONE, NONE, 0x00, NONE,           NULL },
  { PMICMD_REGOP, 0x00,          NONE, 0x01, 0x00, REGISTER_SHR,   b_4 },  /*          */
  { PMICMD_OUTB,  GDC_INDEXPORT, NONE, NONE, 0x01, WRITEREG_DATA,  NULL },
  { PMICMD_NONE },
};

/*
**      Standard VGA Chipset - for GENERIC use only.
*/

BANKROUTINE ParadiseSetBank = {"SetBankLinear", ParadiseSetBankCmd};
BANKROUTINE ParadiseGetBank = {"GetBankLinear", ParadiseGetBankCmd};

/*
**              Chipset Mode Information
*/

/*
**                      Paradise/Western Digital
*/

REGDATA ParadiseModeSet1 [] =
{
  { PMICMD_OUTB,  MISCOUTPUTREG_WRITE, NONE,   0x00, 0x00, WRITEONLY_DATA, &MiscOutRegMask }, /*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x05, 0x00, READWRITE_DATA, &SEQRegData[0x00] },
  { PMICMD_OUTW,  SEQ_INDEXPORT, NONE,         NONE, 0x00, WRITEONLY_DATA, &bEndSEQReset[0] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x19, 0x00, READWRITE_DATA, &CRTRegData[0x00] },
  { PMICMD_BOUTB, ATC_INDEXPORT, ATC_DATAPORT, 0x15, 0x00, READWRITE_DATA, &ATCRegData[0x00] }, /*          */
  { PMICMD_BOUTB, GDC_INDEXPORT, GDC_DATAPORT, 0x0f, 0x00, READWRITE_DATA, &GDCRegData[0x00] },
  { PMICMD_OUTB,  MISCOUTPUTREG_WRITE, NONE,   0x00, 0x00, WRITEONLY_DATA, &MiscOutRegData }, /*          */
  { PMICMD_NONE }
};

CHIPINFO ParadiseChipSet1[] =
{
  {
    0x01,
    &ChipInfoHeader[TEXT_40x25],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet1,
    0,                                                  /*JWK10*/
  },
  {
    0x03,
    &ChipInfoHeader[TEXT_80x25],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet1,
    0,                                                  /*JWK10*/
  },
  {
    VGAMODE,
    &ChipInfoHeader[GRAPHICS_640x480x16],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet1,
    0,                                                  /*JWK10*/
  },
  {
    0x5F,
    &ChipInfoHeader[GRAPHICS_640x480x256],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet1,
    0,                                                  /*JWK10*/
  },
  {
    0x58,
    &ChipInfoHeader[GRAPHICS_800x600x16],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet1,
    0,                                                  /*JWK10*/
  },
  {
    0x55,
    &ChipInfoHeader[TEXT_132x25],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet1,
    0,                                                  /*JWK10*/
  },
  {
    0x54,
    &ChipInfoHeader[TEXT_132x44],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet1,
    0,                                                  /*JWK10*/
  },
};

USHORT usSizeParadiseChipSet1 = sizeof(ParadiseChipSet1)/sizeof(CHIPINFO);

REGDATA ParadiseModeSet2 [] =
{
  { PMICMD_OUTB,  MISCOUTPUTREG_WRITE, NONE,   0x00, 0x00, WRITEONLY_DATA, &MiscOutRegMask }, /*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x05, 0x00, READWRITE_DATA, &SEQRegData[0x00] },
  { PMICMD_OUTW,  SEQ_INDEXPORT, NONE,         NONE, 0x00, WRITEONLY_DATA, &bEndSEQReset[0] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x19, 0x00, READWRITE_DATA, &CRTRegData[0x00] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x04, 0x2c, READWRITE_DATA, &CRTRegData[0x2c] },
  { PMICMD_BOUTB, ATC_INDEXPORT, ATC_DATAPORT, 0x15, 0x00, READWRITE_DATA, &ATCRegData[0x00] }, /*          */
  { PMICMD_BOUTB, GDC_INDEXPORT, GDC_DATAPORT, 0x0f, 0x00, READWRITE_DATA, &GDCRegData[0x00] },
  { PMICMD_OUTB,  MISCOUTPUTREG_WRITE, NONE,   0x00, 0x00, WRITEONLY_DATA, &MiscOutRegData }, /*          */
  { PMICMD_NONE }
};

CHIPINFO ParadiseChipSet2[] =
{
  {
    0x01,
    &ChipInfoHeader[TEXT_40x25],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet2,
    0,                                                  /*JWK10*/
  },
  {
    0x03,
    &ChipInfoHeader[TEXT_80x25],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet2,
    0,                                                  /*JWK10*/
  },
  {
    VGAMODE,
    &ChipInfoHeader[GRAPHICS_640x480x16],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet2,
    0,                                                  /*JWK10*/
  },
  {
    0x5F,
    &ChipInfoHeader[GRAPHICS_640x480x256],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet2,
    0,                                                  /*JWK10*/
  },
  {
    0x58,
    &ChipInfoHeader[GRAPHICS_800x600x16],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet2,
    0,                                                  /*JWK10*/
  },
  {
    0x5C,
    &ChipInfoHeader[GRAPHICS_800x600x256],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet2,
    0,                                                  /*JWK10*/
  },
  {
    0x5D,
    &ChipInfoHeader[GRAPHICS_1024x768x16],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet2,
    0,                                                  /*JWK10*/
  },
  {
    0x55,
    &ChipInfoHeader[TEXT_132x25],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet2,
    0,                                                  /*JWK10*/
  },
  {
    0x54,
    &ChipInfoHeader[TEXT_132x44],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet2,
    0,                                                  /*JWK10*/
  },
} ;

USHORT usSizeParadiseChipSet2 = sizeof(ParadiseChipSet2)/sizeof(CHIPINFO);

REGDATA ParadiseModeSet3 [] =
{
  { PMICMD_OUTB,  MISCOUTPUTREG_WRITE, NONE,   0x00, 0x00, WRITEONLY_DATA, &MiscOutRegMask }, /*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x05, 0x00, READWRITE_DATA, &SEQRegData[0x00] },
  { PMICMD_OUTW,  SEQ_INDEXPORT, NONE,         NONE, 0x00, WRITEONLY_DATA, &bEndSEQReset[0] },
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x02, 0x08, READWRITE_DATA, &SEQRegData[0x08] },
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x03, 0x10, READWRITE_DATA, &SEQRegData[0x10] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x19, 0x00, READWRITE_DATA, &CRTRegData[0x00] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x05, 0x2b, READWRITE_DATA, &CRTRegData[0x2b] },
  { PMICMD_BOUTB, ATC_INDEXPORT, ATC_DATAPORT, 0x15, 0x00, READWRITE_DATA, &ATCRegData[0x00] }, /*          */
  { PMICMD_BOUTB, GDC_INDEXPORT, GDC_DATAPORT, 0x0f, 0x00, READWRITE_DATA, &GDCRegData[0x00] },
  { PMICMD_OUTB,  MISCOUTPUTREG_WRITE, NONE,   0x00, 0x00, WRITEONLY_DATA, &MiscOutRegData }, /*          */
  { PMICMD_NONE }
};

CHIPINFO ParadiseChipSet3[] =
{
  {
    0x01,
    &ChipInfoHeader[TEXT_40x25],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet3,
    0,                                                  /*JWK10*/
  },
  {
    0x03,
    &ChipInfoHeader[TEXT_80x25],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet3,
    0,                                                  /*JWK10*/
  },
  {
    VGAMODE,
    &ChipInfoHeader[GRAPHICS_640x480x16],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet3,
    0,                                                  /*JWK10*/
  },
  {
    0x5F,
    &ChipInfoHeader[GRAPHICS_640x480x256],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet3,
    0,                                                  /*JWK10*/
  },
  {
    0x58,
    &ChipInfoHeader[GRAPHICS_800x600x16],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet3,
    0,                                                  /*JWK10*/
  },
  {
    0x5C,
    &ChipInfoHeader[GRAPHICS_800x600x256],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet3,
    0,                                                  /*JWK10*/
  },
  {
    0x5D,
    &ChipInfoHeader[GRAPHICS_1024x768x16],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet3,
    0,                                                  /*JWK10*/
  },
  {
    0x60,
    &ChipInfoHeader[GRAPHICS_1024x768x256],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet3,
    0,                                                  /*JWK10*/
  },
  {
    0x55,
    &ChipInfoHeader[TEXT_132x25],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet3,
    0,                                                  /*JWK10*/
  },
  {
    0x54,
    &ChipInfoHeader[TEXT_132x44],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet3,
    0,                                                  /*JWK10*/
  },
};

USHORT usSizeParadiseChipSet3 = sizeof(ParadiseChipSet3)/sizeof(CHIPINFO);

REGDATA ParadiseModeSet4 [] = /* Laptops C24 */
{
  { PMICMD_OUTB,  MISCOUTPUTREG_WRITE, NONE,   0x00, 0x00, WRITEONLY_DATA, &MiscOutRegMask },    /*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x05, 0x00, READWRITE_DATA, &SEQRegData[0x00] },
  { PMICMD_OUTW,  SEQ_INDEXPORT, NONE,         NONE, 0x00, WRITEONLY_DATA, "\x00\x03" },   /* end synch reset */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x03, 0x07, READWRITE_DATA, &SEQRegData[0x07] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x10, 0x20, READWRITE_DATA, &SEQRegData[0x10] }, /*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x01, 0x11, READWRITE_DATA, &SEQRegData[0x11] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x12, 0x04, READWRITE_DATA, &SEQRegData[0x12] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x13, 0x03, READWRITE_DATA, &SEQRegData[0x13] }, /*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x01, 0x20, READWRITE_DATA, &SEQRegData[0x20] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x21, 0x07, READWRITE_DATA, &SEQRegData[0x21] }, /*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x05, 0x22, READWRITE_DATA, &SEQRegData[0x22] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x27, 0x10, READWRITE_DATA, &SEQRegData[0x27] }, /*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x01, 0x28, READWRITE_DATA, &SEQRegData[0x28] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x29, 0x0c, READWRITE_DATA, &SEQRegData[0x29] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x31, 0x00, READWRITE_DATA, &SEQRegData[0x31] }, /*          */
#if WD90C2X_SHADOW_LOCKED                                       /*          */
#else                                                           /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x32, 0xff, READWRITE_DATA, &SEQRegData[0x32] }, /*          */
#endif                                                          /*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x02, 0x33, READWRITE_DATA, &SEQRegData[0x33] },
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x01, 0x36, READWRITE_DATA, &SEQRegData[0x36] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x19, 0x00, READWRITE_DATA, &CRTRegData[0x00] },
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x2a, 0x05, READWRITE_DATA, &CRTRegData[0x2a] }, /*          */
#if WD90C2X_SHADOW_LOCKED                                       /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x2b, 0x00, READWRITE_DATA, &CRTRegData[0x2b] }, /*          */
#else                                                           /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x2b, 0xff, READWRITE_DATA, &CRTRegData[0x2b] }, /*          */
#endif                                                          /*          */
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x02, 0x2c, READWRITE_DATA, &CRTRegData[0x2c] }, /*           @V3.0YEE06*/
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x2e, 0x40, READWRITE_DATA, &CRTRegData[0x2e] }, /*@V3.0YEE06*/
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x01, 0x2f, READWRITE_DATA, &CRTRegData[0x2f] }, /*@V3.0YEE06*/
  /* Get Dual panel/16-bit STN state as 0x40/0x00 */                                            /*@V3.0MNH01*/
  { PMICMD_OUTB,  CRT_INDEXPORT, NONE,         NONE, 0x00, WRITEONLY_DATA, "\x33" },            /*@V3.0MNH01*/
  { PMICMD_INB,   CRT_DATAPORT,  NONE,         NONE, 0x01, NONE,           NULL },              /*@V3.0MNH01*/
  { PMICMD_REGOP, 0x01,          NONE,         0x01, 0x02, REGISTER_SHL,   b_1 },               /*@V3.0MNH01*/
  { PMICMD_REGOP, 0x02,          NONE,         0x01, 0x01, REGISTER_AND | REGISTER_OPEQUAL | REGISTER_OPERAND, NULL },/*@V3.0MNH01*/
  { PMICMD_REGOP, 0x01,          NONE,         0x01, 0x01, REGISTER_AND,   "\x40" },            /*@V3.0MNH02*/
  /* Undocumented feature:  3d4.30 is READ (not write!) locked by */                            /*          */
  /* UNLOCKing (not locking!) 3d4.34.  Furthermore the first reads */                           /*          */
  /* after locking may be return the 3d4.34 lock value instead! */                              /*          */
  /* It is still unclear what else to do before it becomes OK to read! */                       /*          */
  /* So we just write it without really reading it! */                                          /*          */
//{ PMICMD_OUTB,  CRT_INDEXPORT, NONE,         NONE, 0x00, EXECUTE_CMD | WRITEONLY_DATA, "\x34" }, /*          */
//{ PMICMD_INB,   CRT_DATAPORT,  NONE,         NONE, 0x00, EXECUTE_CMD | NONE,           NULL   }, /*          */
//{ PMICMD_OUTB,  CRT_DATAPORT,  NONE,         NONE, 0x00, EXECUTE_CMD | WRITEONLY_DATA, "\x30" }, /*          */
//{ PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x30, 0x30, READWRITE_DATA, &CRTRegData[0x30] }, /*          */
//{ PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x30, 0x00, WRITEONLY_DATA, &CRTRegData[0x30] }, /*@V3.0MNH01*/
  { PMICMD_OUTB,  CRT_INDEXPORT, NONE,         NONE, 0x00, WRITEONLY_DATA, "\x30" },            /*@V3.0MNH01*/
  { PMICMD_OUTB,  CRT_DATAPORT,  NONE,         NONE, 0x01, WRITEREG_DATA,  NULL },              /*@V3.0MNH01*/
//{ PMICMD_OUTB,  CRT_INDEXPORT, NONE,         NONE, 0x00, EXECUTE_CMD | WRITEONLY_DATA, "\x34" }, /*          */
//{ PMICMD_OUTB,  CRT_DATAPORT,  NONE,         NONE, 0x00, EXECUTE_CMD | WRITEREG_DATA,  NULL   }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x31, 0x87, READWRITE_DATA, &CRTRegData[0x31] }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x32, 0x7c, READWRITE_DATA, &CRTRegData[0x32] }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x33, 0x61, READWRITE_DATA, &CRTRegData[0x33] }, /*          */
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x04, 0x36, READWRITE_DATA, &CRTRegData[0x36] }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x3a, 0x02, READWRITE_DATA, &CRTRegData[0x3a] }, /*          */
#if WD90C2X_SHADOW_LOCKED                                       /*          */
#else                                                           /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x3b, 0xff, READWRITE_DATA, &CRTRegData[0x3b] }, /*          */
#endif                                                          /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x3c, 0x3f, READWRITE_DATA, &CRTRegData[0x3c] }, /*          */
#if WD90C2X_SHADOW_LOCKED                                       /*          */
#else                                                           /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x3d, 0xff, READWRITE_DATA, &CRTRegData[0x3d] }, /*          */
#endif                                                          /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x3e, 0xa7, READWRITE_DATA, &CRTRegData[0x3e] }, /*          */
#if WD90C2X_SHADOW_LOCKED                                       /*          */
#else                                                           /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x3f, 0xff, READWRITE_DATA, &CRTRegData[0x3d] }, /*          */
#endif                                                          /*          */
  { PMICMD_BOUTB, ATC_INDEXPORT, ATC_DATAPORT, 0x15, 0x00, READWRITE_DATA, &ATCRegData[0x00] }, /*          */
  { PMICMD_BOUTB, GDC_INDEXPORT, GDC_DATAPORT, 0x0b, 0x00, READWRITE_DATA, &GDCRegData[0x00] }, /*          */
  /* Get internal/external state as 0x40/0x00 */                                                /*          */
  { PMICMD_OUTB,  CRT_INDEXPORT, NONE,         NONE, 0x00, WRITEONLY_DATA, "\x32" },            /*          */
  { PMICMD_INB,   CRT_DATAPORT,  NONE,         NONE, 0x00, NONE,           NULL },              /*          */
  { PMICMD_REGOP, 0x00,          NONE,         0x01, 0x02, REGISTER_AND,   "\x20" },            /*@V3.0MNH01*/
  { PMICMD_REGOP, 0x02,          NONE,         0x01, 0x02, REGISTER_XOR,   "\x20" },            /*@V3.0MNH01*/
  { PMICMD_REGOP, 0x02,          NONE,         0x01, 0x02, REGISTER_SHL,   b_1 },               /*@V3.0MNH01*/
  { PMICMD_REGOP, 0x00,          NONE,         0x01, 0x00, REGISTER_AND,   "\x10" },            /*@V3.0MNH02*/
  { PMICMD_REGOP, 0x00,          NONE,         0x01, 0x00, REGISTER_SHL,   b_2 },               /*@V3.0MNH02*/
  { PMICMD_REGOP, 0x02,          NONE,         0x01, 0x00, REGISTER_OR | REGISTER_OPEQUAL | REGISTER_OPERAND, NULL }, /*@V3.0MNH01*/
  /* Get internal and Dual panel/16-bit STN state as 0x40/0x00 */                               /*          */
  { PMICMD_REGOP, 0x01,          NONE,         0x01, 0x00, REGISTER_AND | REGISTER_OPEQUAL | REGISTER_OPERAND, NULL },/*          */
  /* Allow 1M only if NOT internal dual panel 16-bit STN! */                                    /*          */
  { PMICMD_REGOP, 0x00,          NONE,         0x01, 0x00, REGISTER_XOR,   "\xff" },            /*          */
  { PMICMD_RMWBI, GDC_INDEXPORT, GDC_DATAPORT, 0x0b, 0x00, READWRITE_DATA, &GDCRegData[0x0b] }, /*          */
  { PMICMD_OUTB,  GDC_INDEXPORT, NONE,         NONE, 0x00, WRITEONLY_DATA, b_B },               /*          */
  { PMICMD_INB,   GDC_DATAPORT,  NONE,         NONE, 0x01, NONE,           NULL },              /*          */
  { PMICMD_REGOP, 0x00,          NONE,         0x01, 0x01, REGISTER_AND | REGISTER_OPEQUAL | REGISTER_OPERAND, NULL },/*          */
  { PMICMD_OUTB,  GDC_DATAPORT,  NONE,         NONE, 0x01, WRITEREG_DATA,  NULL },              /*          */
  { PMICMD_RMWBI, GDC_INDEXPORT, GDC_DATAPORT, 0x0c, 0x01, READWRITE_DATA, &GDCRegData[0x0c] }, /*          */
  { PMICMD_BOUTB, GDC_INDEXPORT, GDC_DATAPORT, 0x01, 0x0d, READWRITE_DATA, &GDCRegData[0x0d] }, /*          */
  { PMICMD_RMWBI, GDC_INDEXPORT, GDC_DATAPORT, 0x0e, 0x60, READWRITE_DATA, &GDCRegData[0x0e] }, /*          */
  { PMICMD_OUTB,  MISCOUTPUTREG_WRITE, NONE,   0x00, 0x00, WRITEONLY_DATA, &MiscOutRegData },   /*          */

  { PMICMD_OUTW,  WD_INDEXPORT,  NONE, NONE, 0x00, WRITEONLY_DATA | EXECUTE_CMD, "\x00\x20" },   /*          */
  { PMICMD_WAITW, WD_DATAPORT,   0x0800, NONE, 100, 0x0000 },               /*          */
  { PMICMD_OUTW,  WD_INDEXPORT,  NONE, NONE, 0x00, WRITEONLY_DATA | EXECUTE_CMD, &b_0 [0] },     /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x00] }, /* 00 */
  /* Having quick start on may cause accelerator activation */  /*          */
  /* So save and restore other registers first with bit off */  /*          */
  { PMICMD_OUTW,  WD_INDEXPORT,  NONE, NONE, 0x00, WRITEONLY_DATA, "\x01\x01" },                 /*          */
  { PMICMD_RMWWN, WD_DATAPORT,   WD_DATAPORT, 0x00, 0xff7f, WRITEONLY_DATA, &b_0 [0] },          /*          */
  { PMICMD_OUTW,  WD_INDEXPORT,  NONE, NONE, 0x00, WRITEONLY_DATA | EXECUTE_CMD, "\x02\x01" },   /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x12] }, /* 02 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x13] }, /* 03 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x14] }, /* 04 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x15] }, /* 05 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x16] }, /* 06 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x17] }, /* 07 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x18] }, /* 08 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x19] }, /* 09 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x1a] }, /* 0a */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x1b] }, /* 0b */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x1c] }, /* 0c */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x1d] }, /* 0d */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x1e] }, /* 0e */
  { PMICMD_OUTW,  WD_INDEXPORT,  NONE, NONE, 0x00, WRITEONLY_DATA | EXECUTE_CMD, "\x00\x01" },   /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x10] }, /* 00 */ /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x11] }, /* 01 */ /*          */
  /* Since writes to Cursor Pattern Address or Cursor Origin, *//*          */
  /* do not take effect until the next write to Cursor        *//*          */
  /* Control, we need to write Cursor Control Last!           *//*          */
  { PMICMD_OUTW,  WD_INDEXPORT,  NONE, NONE, 0x00, WRITEONLY_DATA | EXECUTE_CMD, "\x02\x03" },   /*          */                   /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x23] }, /* 03 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x24] }, /* 04 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x25] }, /* 05 */
  { PMICMD_OUTW,  WD_INDEXPORT,  NONE, NONE, 0x00, WRITEONLY_DATA | EXECUTE_CMD, "\x02\x08" },   /*          */                   /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x28] }, /* 08 */
  { PMICMD_OUTW,  WD_INDEXPORT,  NONE, NONE, 0x00, WRITEONLY_DATA | EXECUTE_CMD, "\x02\x01" },   /*          */                   /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, WRITEONLY_DATA, "\x00\x10" },            /* 01 *//*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, WRITEONLY_DATA, "\x00\x20" },            /* 02 *//*          */
  { PMICMD_OUTW,  WD_INDEXPORT,  NONE, NONE, 0x00, WRITEONLY_DATA | EXECUTE_CMD, "\x02\x06" },   /*          */                   /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, WRITEONLY_DATA, "\xc0\x67" },            /* 06 *//*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, WRITEONLY_DATA, "\x00\x70" },            /* 07 *//*          */
  { PMICMD_OUTW,  WD_INDEXPORT,  NONE, NONE, 0x00, WRITEONLY_DATA | EXECUTE_CMD, "\x02\x00" },   /*          */                   /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, WRITEONLY_DATA, &MiscRegData [2*0x20] },  /* 00 *//*          */
  { PMICMD_OUTW,  WD_HBLT0PORT,  NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x44] },
  { PMICMD_OUTW,  WD_HBLT1PORT,  NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x46] },
  { PMICMD_OUTW,  WD_K1PORT,     NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x48] },
  { PMICMD_OUTW,  WD_K2PORT,     NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x4a] },
  { PMICMD_OUTW,  WD_ETPORT,     NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x4c] },
  { PMICMD_NONE }
};

CHIPINFO ParadiseChipSet4[] = /* C24 */
{
  {
    0x01,
    &ChipInfoHeader[TEXT_40x25],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet4,
    0,                                                  /*JWK10*/
  },
  {
    0x03,
    &ChipInfoHeader[TEXT_80x25],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet4,
    0,                                                  /*JWK10*/
  },
  {
    VGAMODE,
    &ChipInfoHeader[GRAPHICS_640x480x16],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet4,
    0,                                                  /*JWK10*/
  },
  {
    0x5f,
    &ChipInfoHeader[GRAPHICS_640x480x256],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet4,
    0,                                                  /*JWK10*/
  },
//            {                                                             /*          */
//              0x62,
//              &ChipInfoHeader[GRAPHICS_640x480x32K],
//              &ParadiseSetBank,
//              &ParadiseGetBank,
//              ParadiseModeSet4,
//              0,                                                  /*JWK10*/
//            },
  {                                                             /*          */
//              0x72,
    VESA_640_480_64K,
    &ChipInfoHeader[GRAPHICS_640x480x64K],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet4,
    0,                                                  /*JWK10*/
  },
  /* Not enough memory to support this mode */                  /*          */
//{                                                             /*          */
//              0x6e,
//  VESA_640_480_16M,                                           /*          */
//  &ChipInfoHeader[GRAPHICS_640x480x16M],                      /*          */
//  &ParadiseSetBank,                                           /*          */
//  &ParadiseGetBank,                                           /*          */
//  ParadiseModeSet4,                                           /*          */
//  0,                                                          /*          */
//},                                                            /*          */
  {
    0x58,
    &ChipInfoHeader[GRAPHICS_800x600x16],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet4,
    0,                                                  /*JWK10*/
  },
  {
    0x5c,
    &ChipInfoHeader[GRAPHICS_800x600x256],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet4,
    0,                                                  /*JWK10*/
  },
//            {                                                             /*          */
//              0x63,
//              &ChipInfoHeader[GRAPHICS_800x600x32K],
//              &ParadiseSetBank,
//              &ParadiseGetBank,
//              ParadiseModeSet4,
//              0,                                                  /*JWK10*/
//            },
  /* Out of sync on the one test machine which has this mode! *//*          */
  {                                                             /*          */
//  0x73,                                           /*          */
    VESA_800_600_64K,                                           /*          */
//@3.0YEE03  &ChipInfoHeader[GRAPHICS_800x600x64K],             /*          */
    &ChipInfoHeader[GRAPHICS_800x600x64K_2KSL],     /*2M VRAM     @V3.0YEE03*/
    &ParadiseSetBank,                                           /*          */
    &ParadiseGetBank,                                           /*          */
    ParadiseModeSet4,                                           /*          */
    0,                                                          /*          */
  },                                                            /*          */
  /* Not enough memory to support this mode */                  /*          */
//{                                                             /*          */
//  VESA_800_600_16M,                                           /*          */
//  &ChipInfoHeader[GRAPHICS_800x600x16M],                      /*          */
//  &ParadiseSetBank,                                           /*          */
//  &ParadiseGetBank,                                           /*          */
//  ParadiseModeSet4,                                           /*          */
//  0,                                                          /*          */
//},                                                            /*          */
  {
    0x5d,
    &ChipInfoHeader[GRAPHICS_1024x768x16],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet4,
    0,                                                  /*JWK10*/
  },
//            {
//              VESA_1024_768_16,
//              &ChipInfoHeader[GRAPHICS_1024x768x16],
//              &ParadiseSetBank,
//              &ParadiseGetBank,
//              ParadiseModeSet4,
//              0,                                                  /*JWK10*/
//            },
  {
    0x60,
    &ChipInfoHeader[GRAPHICS_1024x768x256],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet4,
    0,                                                  /*JWK10*/
  },
  /* Not enough memory to support this mode */                  /*          */
//{                                                             /*          */
//  VESA_1024_768_32K,                                          /*          */
//  &ChipInfoHeader[GRAPHICS_1024x768x32K],                     /*          */
//  &ParadiseSetBank,                                           /*          */
//  &ParadiseGetBank,                                           /*          */
//  ParadiseModeSet4,                                           /*          */
//  0,                                                          /*          */
//},                                                            /*          */
  /* Not enough memory to support this mode */                  /*          */
//{                                                             /*          */
//  VESA_1024_768_64K,                                          /*          */
//  &ChipInfoHeader[GRAPHICS_1024x768x64K],                     /*          */
//  &ParadiseSetBank,                                           /*          */
//  &ParadiseGetBank,                                           /*          */
//  ParadiseModeSet4,                                           /*          */
//  0,                                                          /*          */
//},                                                            /*          */
  /* Not enough memory to support this mode */                  /*          */
//{                                                             /*          */
//  VESA_1024_768_16M,                                          /*          */
//  &ChipInfoHeader[GRAPHICS_1024x768x16M],                     /*          */
//  &ParadiseSetBank,                                           /*          */
//  &ParadiseGetBank,                                           /*          */
//  ParadiseModeSet4,                                           /*          */
//  0,                                                          /*          */
//},                                                            /*          */
  {                                                             /*          */
    VESA_1280_1024_16,
    &ChipInfoHeader[GRAPHICS_1280x1024x16],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet4,
    0,                                                  /*JWK10*/
  },
  /* Not enough memory to support this mode */                  /*          */
//{                                                             /*          */
//  VESA_1280_1024_256,                                         /*          */
//  &ChipInfoHeader[GRAPHICS_1280x1024x256],                    /*          */
//  &ParadiseSetBank,                                           /*          */
//  &ParadiseGetBank,                                           /*          */
//  ParadiseModeSet4,                                           /*          */
//  0,                                                          /*          */
//},                                                            /*          */
  /* Not enough memory to support this mode */                  /*          */
//{                                                             /*          */
//  VESA_1280_1024_64K,                                         /*          */
//  &ChipInfoHeader[GRAPHICS_1280x1024x64K],                    /*          */
//  &ParadiseSetBank,                                           /*          */
//  &ParadiseGetBank,                                           /*          */
//  ParadiseModeSet4,                                           /*          */
//  0,                                                          /*          */
//},                                                            /*          */
  /* Not enough memory to support this mode */                  /*          */
//{                                                             /*          */
//  VESA_1600_1200_256,                                         /*          */
//  &ChipInfoHeader[GRAPHICS_1600x1200x256],                    /*          */
//  &ParadiseSetBank,                                           /*          */
//  &ParadiseGetBank,                                           /*          */
//  ParadiseModeSet4,                                           /*          */
//  0,                                                          /*          */
//},                                                            /*          */
  {
    0x55,
    &ChipInfoHeader[TEXT_132x25],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet4,
    0,                                                  /*JWK10*/
  },
  {
    0x54,
    &ChipInfoHeader[TEXT_132x44],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet4,
    0,                                                  /*JWK10*/
  },
};

USHORT usSizeParadiseChipSet4 = sizeof(ParadiseChipSet4)/sizeof(CHIPINFO);
/*
**            D90318 Change 90c31 back to 90c30+3e+accelerators.
** Not mucking with crt 3d, since no laptops with c31 reported yet.
*/
REGDATA ParadiseModeSet5 [] = /* C31 */
{
  { PMICMD_OUTB,  MISCOUTPUTREG_WRITE, NONE,   0x00, 0x00, WRITEONLY_DATA, &MiscOutRegMask }, /*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x05, 0x00, READWRITE_DATA, &SEQRegData[0x00] },
  { PMICMD_OUTW,  SEQ_INDEXPORT, NONE, NONE, 0x00, WRITEONLY_DATA, &bEndSEQReset[0] },
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x02, 0x08, READWRITE_DATA, &SEQRegData[0x08] },
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x03, 0x10, READWRITE_DATA, &SEQRegData[0x10] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x19, 0x00, READWRITE_DATA, &CRTRegData[0x00] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x05, 0x2b, READWRITE_DATA, &CRTRegData[0x2b] },
  { PMICMD_BOUTB, ATC_INDEXPORT, ATC_DATAPORT, 0x15, 0x00, READWRITE_DATA, &ATCRegData[0x00] }, /*          */
  { PMICMD_BOUTB, GDC_INDEXPORT, GDC_DATAPORT, 0x0f, 0x00, READWRITE_DATA, &GDCRegData[0x00] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x01, 0x3e, READWRITE_DATA, &CRTRegData[0x3e] }, /*          */
  { PMICMD_OUTB,  MISCOUTPUTREG_WRITE, NONE,   0x00, 0x00, WRITEONLY_DATA, &MiscOutRegData },  /*          */

  { PMICMD_OUTW,  WD_INDEXPORT,  NONE, NONE, 0x00, WRITEONLY_DATA | EXECUTE_CMD, "\x00\x20" },   /*          */
  { PMICMD_WAITW, WD_DATAPORT,   0x0800, NONE, 100, 0x0000 },               /*          */
  { PMICMD_OUTW,  WD_INDEXPORT,  NONE, NONE, 0x00, WRITEONLY_DATA | EXECUTE_CMD, &b_0 [0] },     /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x00] }, /* 00 */
  /* Having quick start on may cause accelerator activation */  /*          */
  /* So save and restore other registers first with bit off */  /*          */
  { PMICMD_OUTW,  WD_INDEXPORT,  NONE, NONE, 0x00, WRITEONLY_DATA | EXECUTE_CMD, "\x01\x01" },   /*          */
  { PMICMD_RMWWN, WD_DATAPORT,   WD_DATAPORT, 0x00, 0xff7f, WRITEONLY_DATA | EXECUTE_CMD, &b_0 [0] }, /*          */
  { PMICMD_OUTW,  WD_INDEXPORT,  NONE, NONE, 0x00, WRITEONLY_DATA | EXECUTE_CMD, "\x02\x01" },   /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x12] }, /* 02 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x13] }, /* 03 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x14] }, /* 04 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x15] }, /* 05 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x16] }, /* 06 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x17] }, /* 07 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x18] }, /* 08 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x19] }, /* 09 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x1a] }, /* 0a */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x1b] }, /* 0b */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x1c] }, /* 0c */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x1d] }, /* 0d */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x1e] }, /* 0e */
  { PMICMD_OUTW,  WD_INDEXPORT,  NONE, NONE, 0x00, WRITEONLY_DATA | EXECUTE_CMD, "\x00\x01" },   /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x10] }, /* 00 */ /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x11] }, /* 01 */ /*          */
  /* Since writes to Cursor Pattern Address or Cursor Origin, *//*          */
  /* do not take effect until the next write to Cursor        *//*          */
  /* Control, we need to write Cursor Control Last!           *//*          */
  { PMICMD_OUTW,  WD_INDEXPORT,  NONE, NONE, 0x00, WRITEONLY_DATA | EXECUTE_CMD, "\x02\x03" },  /*          */                   /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x23] }, /* 03 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x24] }, /* 04 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x25] }, /* 05 */
  { PMICMD_OUTW,  WD_INDEXPORT,  NONE, NONE, 0x00, WRITEONLY_DATA | EXECUTE_CMD, "\x02\x08" },  /*          */                   /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x28] }, /* 08 */
  { PMICMD_OUTW,  WD_INDEXPORT,  NONE, NONE, 0x00, WRITEONLY_DATA | EXECUTE_CMD, "\x02\x01" },  /*          */                   /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, WRITEONLY_DATA, "\x00\x10" },            /* 01 *//*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, WRITEONLY_DATA, "\x00\x20" },            /* 02 *//*          */
  { PMICMD_OUTW,  WD_INDEXPORT,  NONE, NONE, 0x00, WRITEONLY_DATA | EXECUTE_CMD, "\x02\x06" },  /*          */                   /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, WRITEONLY_DATA, "\xc0\x67" },            /* 06 *//*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, WRITEONLY_DATA, "\x00\x70" },            /* 07 *//*          */
  { PMICMD_OUTW,  WD_INDEXPORT,  NONE, NONE, 0x00, WRITEONLY_DATA | EXECUTE_CMD, "\x02\x00" },  /*          */                   /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, WRITEONLY_DATA, &MiscRegData [2*0x20] }, /* 00 *//*          */
  { PMICMD_OUTW,  WD_HBLT0PORT,  NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x44] },
  { PMICMD_OUTW,  WD_HBLT1PORT,  NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x46] },
  { PMICMD_OUTW,  WD_K1PORT,     NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x48] },
  { PMICMD_OUTW,  WD_K2PORT,     NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x4a] },
  { PMICMD_OUTW,  WD_ETPORT,     NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x4c] },
  { PMICMD_NONE }
};

CHIPINFO ParadiseChipSet5[] =
{
  {
    0x01,
    &ChipInfoHeader[TEXT_40x25],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet5,
    0,                                                  /*JWK10*/
  },
  {
    0x03,
    &ChipInfoHeader[TEXT_80x25],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet5,
    0,                                                  /*JWK10*/
  },
  {
    VGAMODE,
    &ChipInfoHeader[GRAPHICS_640x480x16],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet5,
    0,                                                  /*JWK10*/
  },
  {
    0x5f,
    &ChipInfoHeader[GRAPHICS_640x480x256],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet5,
    0,                                                  /*JWK10*/
  },
//            {                                                             /*          */
//              0x62,
//              &ChipInfoHeader[GRAPHICS_640x480x32K],
//              &ParadiseSetBank,
//              &ParadiseGetBank,
//              ParadiseModeSet5,
//              0,                                                  /*JWK10*/
//            },
  {                                                             /*          */
//              0x72,
    VESA_640_480_64K,
    &ChipInfoHeader[GRAPHICS_640x480x64K],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet5,
    0,                                                  /*JWK10*/
  },
  {                                                             /*          */
    0x6e,
    &ChipInfoHeader[GRAPHICS_640x480x16M],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet5,
    0,                                                  /*JWK10*/
  },
  {
    0x58,
    &ChipInfoHeader[GRAPHICS_800x600x16],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet5,
    0,                                                  /*JWK10*/
  },
  {
    0x5c,
    &ChipInfoHeader[GRAPHICS_800x600x256],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet5,
    0,                                                  /*JWK10*/
  },
//            {                                                             /*          */
//              0x63,
//              &ChipInfoHeader[GRAPHICS_800x600x32K],
//              &ParadiseSetBank,
//              &ParadiseGetBank,
//              ParadiseModeSet5,
//              0,                                                  /*JWK10*/
//            },
  {                                                             /*          */
//              0x73,
    VESA_800_600_64K,
    &ChipInfoHeader[GRAPHICS_800x600x64K],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet5,
    0,                                                  /*JWK10*/
  },
  {                                                             /*          */
    VESA_800_600_16M,
    &ChipInfoHeader[GRAPHICS_800x600x16M],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet5,
    0,                                                  /*JWK10*/
  },
  {
    0x5d,
    &ChipInfoHeader[GRAPHICS_1024x768x16],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet5,
    0,                                                  /*JWK10*/
  },
  {
    0x60,
    &ChipInfoHeader[GRAPHICS_1024x768x256],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet5,
    0,                                                  /*JWK10*/
  },
  {                                                             /*          */
    VESA_1024_768_32K,
    &ChipInfoHeader[GRAPHICS_1024x768x32K],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet5,
    0,                                                  /*JWK10*/
  },
  {                                                             /*          */
    VESA_1024_768_64K,
    &ChipInfoHeader[GRAPHICS_1024x768x64K],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet5,
    0,                                                  /*JWK10*/
  },
  {                                                             /*          */
    VESA_1024_768_16M,
    &ChipInfoHeader[GRAPHICS_1024x768x16M],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet5,
    0,                                                  /*JWK10*/
  },
  {                                                             /*          */
    VESA_1280_1024_16,
    &ChipInfoHeader[GRAPHICS_1280x1024x16],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet5,
    0,                                                  /*JWK10*/
  },
  {                                                             /*          */
    VESA_1280_1024_256,
    &ChipInfoHeader[GRAPHICS_1280x1024x256],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet5,
    0,                                                  /*JWK10*/
  },
  {                                                             /*          */
    VESA_1280_1024_64K,
    &ChipInfoHeader[GRAPHICS_1280x1024x64K],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet5,
    0,                                                  /*JWK10*/
  },
  {                                                             /*          */
    VESA_1600_1200_256,
    &ChipInfoHeader[GRAPHICS_1600x1200x256],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet5,
    0,                                                  /*JWK10*/
  },
  {
    0x55,
    &ChipInfoHeader[TEXT_132x25],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet5,
    0,                                                  /*JWK10*/
  },
  {
    0x54,
    &ChipInfoHeader[TEXT_132x44],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet5,
    0,                                                  /*JWK10*/
  },
};

USHORT usSizeParadiseChipSet5 = sizeof(ParadiseChipSet5)/sizeof(CHIPINFO);

REGDATA ParadiseModeSet6 [] =  /* C33 */
{
  { PMICMD_OUTB,  MISCOUTPUTREG_WRITE, NONE,   0x00, 0x00, WRITEONLY_DATA, &MiscOutRegMask },    /*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x05, 0x00, READWRITE_DATA, &SEQRegData[0x00] },
  { PMICMD_OUTW,  SEQ_INDEXPORT, NONE, NONE, 0x00, WRITEONLY_DATA, "\x00\x03" },   /* end synch reset                   */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x03, 0x07, READWRITE_DATA, &SEQRegData[0x07] },  /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x10, 0x20, READWRITE_DATA, &SEQRegData[0x10] },  /*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x03, 0x11, READWRITE_DATA, &SEQRegData[0x11] },  /*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x01, 0x20, READWRITE_DATA, &SEQRegData[0x20] },  /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x21, 0x07, READWRITE_DATA, &SEQRegData[0x21] },  /*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x07, 0x22, READWRITE_DATA, &SEQRegData[0x22] },  /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x29, 0x04, READWRITE_DATA, &SEQRegData[0x29] },  /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x31, 0x00, READWRITE_DATA, &SEQRegData[0x31] },  /*          */
#if WD90C2X_SHADOW_LOCKED                                       /*          */
#else                                                           /*          */
  { PMICMD_RMWBI,  SEQ_INDEXPORT, SEQ_DATAPORT, 0x32, 0xff, READWRITE_DATA, &SEQRegData[0x32] }, /*          */
#endif                                                          /*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x02, 0x33, READWRITE_DATA, &SEQRegData[0x33] },
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x01, 0x36, READWRITE_DATA, &SEQRegData[0x36] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x19, 0x00, READWRITE_DATA, &CRTRegData[0x00] },
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x2a, 0x05, READWRITE_DATA, &CRTRegData[0x2a] },  /*          */
#if WD90C2X_SHADOW_LOCKED                                       /*          */
#else                                                           /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x2b, 0xff, READWRITE_DATA, &CRTRegData[0x2b] },  /*          */
#endif                                                          /*          */
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x04, 0x2c, READWRITE_DATA, &CRTRegData[0x2c] },  /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x31, 0x87, READWRITE_DATA, &CRTRegData[0x31] },  /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x32, 0x74, READWRITE_DATA, &CRTRegData[0x32] },  /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x33, 0x61, READWRITE_DATA, &CRTRegData[0x33] },  /*          */
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x04, 0x36, READWRITE_DATA, &CRTRegData[0x36] },  /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x3a, 0x02, READWRITE_DATA, &CRTRegData[0x3a] },  /*          */
#if WD90C2X_SHADOW_LOCKED                                       /*          */
#else                                                           /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x3b, 0xff, READWRITE_DATA, &CRTRegData[0x3b] },  /*          */
#endif                                                          /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x3c, 0x3f, READWRITE_DATA, &CRTRegData[0x3c] },  /*          */
#if WD90C2X_SHADOW_LOCKED                                       /*          */
#else                                                           /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x3d, 0xff, READWRITE_DATA, &CRTRegData[0x3d] },  /*          */
#endif                                                          /*          */
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x01, 0x3e, READWRITE_DATA, &CRTRegData[0x3e] },  /*          */
#if WD90C2X_SHADOW_LOCKED                                       /*          */
#else                                                           /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x3f, 0xff, READWRITE_DATA, &CRTRegData[0x3d] },  /*          */
#endif                                                          /*          */
  { PMICMD_BOUTB, ATC_INDEXPORT, ATC_DATAPORT, 0x15, 0x00, READWRITE_DATA, &ATCRegData[0x00] },  /*          */
  { PMICMD_BOUTB, GDC_INDEXPORT, GDC_DATAPORT, 0x0b, 0x00, READWRITE_DATA, &GDCRegData[0x00] },  /*          */
  { PMICMD_RMWBI, GDC_INDEXPORT, GDC_DATAPORT, 0x0b, 0x00, READWRITE_DATA, &GDCRegData[0x0b] },  /*          */
  { PMICMD_RMWBI, GDC_INDEXPORT, GDC_DATAPORT, 0x0c, 0x01, READWRITE_DATA, &GDCRegData[0x0c] },  /*          */
  { PMICMD_BOUTB, GDC_INDEXPORT, GDC_DATAPORT, 0x01, 0x0d, READWRITE_DATA, &GDCRegData[0x0d] },  /*          */
  { PMICMD_RMWBI, GDC_INDEXPORT, GDC_DATAPORT, 0x0e, 0x60, READWRITE_DATA, &GDCRegData[0x0e] },  /*          */
  { PMICMD_OUTB,  MISCOUTPUTREG_WRITE, NONE,   0x00, 0x00, WRITEONLY_DATA, &MiscOutRegData },    /*          */

  { PMICMD_WAITW, WD_ENGINEPORT, 0x0080, NONE, 100, 0x0000 },              /*          */
  { PMICMD_OUTW,  WD_ENGINEPORT, NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x4e] }, /* 00 */
  { PMICMD_OUTW,  WD_INDEXPORT,  NONE, NONE, 0x00, WRITEONLY_DATA | EXECUTE_CMD, &b_0 [0] },     /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x00] }, /* 00 */
  /* Make sure cmd reg contains a NO-OP during restore! */      /*          */
  { PMICMD_OUTW,  WD_INDEXPORT,  NONE, NONE, 0x00, WRITEONLY_DATA | EXECUTE_CMD, &b_1 [0] },     /*          */
  { PMICMD_RMWWN, WD_DATAPORT,  WD_DATAPORT, 0x00, 0xf1ff, WRITEONLY_DATA | EXECUTE_CMD, &b_0 [0] }, /*          */
  { PMICMD_OUTW,  WD_INDEXPORT,  NONE, NONE, 0x00, WRITEONLY_DATA | EXECUTE_CMD, &b_1 [0] },     /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x10] }, /* 00 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x11] }, /* 01 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x12] }, /* 02 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x13] }, /* 03 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x14] }, /* 04 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x15] }, /* 05 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x16] }, /* 06 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x17] }, /* 07 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x18] }, /* 08 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x19] }, /* 09 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x1a] }, /* 0a */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x1b] }, /* 0b */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x1c] }, /* 0c */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x1d] }, /* 0d */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x1e] }, /* 0e */
  /* Since writes to Cursor Pattern Address or Cursor Origin, *//*          */
  /* do not take effect until the next write to Cursor        *//*          */
  /* Control, we need to write Cursor Control Last!           *//*          */
  { PMICMD_OUTW,  WD_INDEXPORT,  NONE, NONE, 0x00, WRITEONLY_DATA | EXECUTE_CMD, "\x02\x03" },  /*          */                    /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x23] }, /* 03 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x24] }, /* 04 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x25] }, /* 05 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x26] }, /* 06 *//*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x27] }, /* 07 *//*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x28] }, /* 08 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x29] }, /* 09 *//*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x2a] }, /* 0a *//*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x2b] }, /* 0b *//*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x2c] }, /* 0c *//*          */
  { PMICMD_OUTW,  WD_INDEXPORT,  NONE, NONE, 0x00, WRITEONLY_DATA | EXECUTE_CMD, "\x02\x01" },   /*          */                   /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, WRITEONLY_DATA, "\x00\x10" },            /* 01 *//*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, WRITEONLY_DATA, "\x00\x20" },            /* 02 *//*          */
  { PMICMD_OUTW,  WD_INDEXPORT,  NONE, NONE, 0x00, WRITEONLY_DATA | EXECUTE_CMD, "\x02\x0d" },   /*          */                   /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, WRITEONLY_DATA, "\xc0\xd7" },            /* 0d *//*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, WRITEONLY_DATA, "\x00\xe0" },            /* 0e *//*          */
  { PMICMD_OUTW,  WD_INDEXPORT,  NONE, NONE, 0x00, WRITEONLY_DATA | EXECUTE_CMD, "\x02\x00" },   /*          */                   /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, WRITEONLY_DATA, &MiscRegData [2*0x20] }, /* 00 *//*          */
  { PMICMD_OUTW,  WD_INDEXPORT,  NONE, NONE, 0x00, WRITEONLY_DATA | EXECUTE_CMD, &b_3 [0] },     /*          */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x30] }, /* 00 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x31] }, /* 01 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x32] }, /* 02 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x33] }, /* 03 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x34] }, /* 04 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x35] }, /* 05 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x36] }, /* 06 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x37] }, /* 07 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x38] }, /* 08 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x39] }, /* 09 */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x3a] }, /* 0a */
  { PMICMD_OUTW,  WD_DATAPORT,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x3b] }, /* 0b */
//{ PMICMD_OUTW,  WD_HBLT0PORT,  NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x44] },
//{ PMICMD_OUTW,  WD_HBLT1PORT,  NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x46] },
  { PMICMD_OUTW,  WD_K1PORT,     NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x48] },
  { PMICMD_OUTW,  WD_K2PORT,     NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x4a] },
  { PMICMD_OUTW,  WD_ETPORT,     NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x4c] },
  { PMICMD_OUTW,  WD_BUSPORT,    NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x50] }, /*          */
  { PMICMD_OUTW,  WD_MEMPORT,    NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x51] }, /*          */
  { PMICMD_OUTW,  WD_BUSPORT2,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x52] }, /*          */
  { PMICMD_OUTW,  WD_MEMPORT2,   NONE, NONE, 0x00, READWRITE_DATA, &MiscRegData [2*0x53] }, /*          */
  { PMICMD_NONE }
};

CHIPINFO ParadiseChipSet6[] =
{
  {
    VGAMODE,
    &ChipInfoHeader[GRAPHICS_640x480x16],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet6,
    0,                                                  /*JWK10*/
  },
  {
    0x5F,
    &ChipInfoHeader[GRAPHICS_640x480x256],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet6,
    0,                                                  /*JWK10*/
  },
//            {                                                             /*          */
//              0x62,
//              &ChipInfoHeader[GRAPHICS_640x480x32K],
//              &ParadiseSetBank,
//              &ParadiseGetBank,
//              ParadiseModeSet6,
//              0,                                                  /*JWK10*/
//            },
  {                                                             /*          */
//              0x72,
    VESA_640_480_64K,
    &ChipInfoHeader[GRAPHICS_640x480x64K],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet6,
    0,                                                  /*JWK10*/
  },
  {                                                             /*          */
    0x6e,
    &ChipInfoHeader[GRAPHICS_640x480x16M],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet6,
    0,                                                  /*JWK10*/
  },
  {
    0x58,
    &ChipInfoHeader[GRAPHICS_800x600x16],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet6,
    0,                                                  /*JWK10*/
  },
  {
    0x5c,
    &ChipInfoHeader[GRAPHICS_800x600x256],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet6,
    0,                                                  /*JWK10*/
  },
//            {                                                             /*          */
//              0x63,
//              &ChipInfoHeader[GRAPHICS_800x600x32K],
//              &ParadiseSetBank,
//              &ParadiseGetBank,
//              ParadiseModeSet6,
//              0,                                                  /*JWK10*/
//            },
  {                                                             /*          */
//              0x73,
    VESA_800_600_64K,
    &ChipInfoHeader[GRAPHICS_800x600x64K],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet6,
    0,                                                  /*JWK10*/
  },
  {                                                             /*          */
    VESA_800_600_16M,
    &ChipInfoHeader[GRAPHICS_800x600x16M],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet6,
    0,                                                  /*JWK10*/
  },
  {
    0x5d,
    &ChipInfoHeader[GRAPHICS_1024x768x16],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet6,
    0,                                                  /*JWK10*/
  },
  {
    0x60,
    &ChipInfoHeader[GRAPHICS_1024x768x256],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet6,
    0,                                                  /*JWK10*/
  },
//            {                                                             /*          */
//              VESA_1024_768_32K,
//              &ChipInfoHeader[GRAPHICS_1024x768x32K],
//              &ParadiseSetBank,
//              &ParadiseGetBank,
//              ParadiseModeSet6,
//              0,                                                  /*JWK10*/
//            },
  {                                                             /*          */
    VESA_1024_768_64K,
    &ChipInfoHeader[GRAPHICS_1024x768x64K],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet6,
    0,                                                  /*JWK10*/
  },
  {                                                             /*          */
    VESA_1024_768_16M,
    &ChipInfoHeader[GRAPHICS_1024x768x16M],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet6,
    0,                                                  /*JWK10*/
  },
  {                                                             /*          */
    VESA_1280_1024_16,
    &ChipInfoHeader[GRAPHICS_1280x1024x16],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet6,
    0,                                                  /*JWK10*/
  },
  {                                                             /*          */
    VESA_1280_1024_256,
    &ChipInfoHeader[GRAPHICS_1280x1024x256],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet6,
    0,                                                  /*JWK10*/
  },
  {                                                             /*          */
    VESA_1280_1024_64K,
    &ChipInfoHeader[GRAPHICS_1280x1024x64K],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet6,
    0,                                                  /*JWK10*/
  },
  {                                                             /*          */
    VESA_1600_1200_256,
    &ChipInfoHeader[GRAPHICS_1600x1200x256],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet6,
    0,                                                  /*JWK10*/
  },
  {
    0x01,
    &ChipInfoHeader[TEXT_40x25],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet6,
    0,                                                  /*JWK10*/
  },
  {
    0x03,
    &ChipInfoHeader[TEXT_80x25],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet6,
    0,                                                  /*JWK10*/
  },
  {
    0x55,
    &ChipInfoHeader[TEXT_132x25],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet6,
    0,                                                  /*JWK10*/
  },
  {
    0x54,
    &ChipInfoHeader[TEXT_132x44],
    &ParadiseSetBank,
    &ParadiseGetBank,
    ParadiseModeSet6,
    0,                                                  /*JWK10*/
  },
};

USHORT usSizeParadiseChipSet6 = sizeof(ParadiseChipSet6)/sizeof(CHIPINFO);

/*****************************************************************************
 *
 * FUNCTION NAME = IsThinkpad()                                   @V3.0YEE05
 *
 * DESCRIPTION   = Look for Thinkpad and set manufacturer type
 *
 * INPUT         = NONE
 * OUTPUT        = NONE
 *
 ****************************************************************************/

VOID IsThinkpad(VOID)
{
  /* looking for Thinkpad system with WD90C24 by verifying      @V3.0YEE07*/
  /* that SMAPI is installed.  SMAPI unique to Thinkpad.        @V3.0YEE07*/
  /* CMOS.7ch = I; CMOS.7dh=S or 06h indicates SMAPI.           @V3.0YEE07*/

   _disable();               /* no interrupts while poking around at CMOS */
   OutpDelay(0x070, 0x7C);
   if (InpDelay(0x071) == 'I')
   {
      OutpDelay(0x070, 0x7D);
      if ((InpDelay(0x071) == 'S') ||     /* TBird Enhanced or later */
          (InpDelay(0x071) == 0x06))      /* TBird or Flamingo       */
        sOEM.Manufacturer = THINKPAD_MANUFACTURER;

      /*   get refresh rate from CMOS */
      OutpDelay(0x070, 0x6B);
      ThinkpadRefresh640 = InpDelay(0x071) & 0x07;

      OutpDelay(0x070, 0x6C);     /* refresh bits 3-5      @V3.0YEE07*/
      ThinkpadRefresh800 = (InpDelay(0x071) >>0x03) & 0x07;
   }
   _enable();
}

/*****************************************************************************
 *
 * FUNCTION NAME = ThinkpadMaxLCDRes()                            @V3.0YEE07
 *
 * DESCRIPTION   = Obtain maximum resolution supported by Thinkpad LCD
 *
 * INPUT         = NONE
 * OUTPUT        = LCD panel max resolution / 720
 *
 ****************************************************************************/

USHORT ThinkpadMaxLCDRes(VOID)
{
  USHORT MaxRes = 720;                /* set lowest denominator */

  /* PR1A has flat panel max resolution size.                     */
  /* This doesn't work on Thinkpad.  It appears PR1A is set after */
  /* the setmode.  PR1A also controls the screen centering.       */
  /* This is how the TFT panel manufacturer designed it.          */
  /* So for Thinkpad systems, get the value from (d00h.12h+1)*8   */
  /* to determine max resolution supported on panel.              */

  if (sOEM.Manufacturer == THINKPAD_MANUFACTURER)
  {
     OutpDelay(0x0d00, 0x12);
     MaxRes = (InpDelay(0x0d01) +1) * 8;

     if (MaxRes == 640)
       MaxRes = 720;               /* anticipate text mode */
  }
  return (MaxRes);

}

/*****************************************************************************
 *
 * FUNCTION NAME = ThinkpadGetPanelType()                          @V3.0YEE05
 *
 * DESCRIPTION   = Prints out instructions to read Refresh and Panel values
 *
 * INPUT         = NONE
 * OUTPUT        = NONE
 *
 *****************************************************************************/
VOID ThinkpadGetPanelType(VOID)
{
   /* get panel type from CR32, bits 4,5 */

   fprintf(textfile, "outb(0x3d4, 0x32);\n");
   fprintf(textfile, "inb(r0, 0x3d5);\n");
   fprintf(textfile, "r0 &= 0x10;\n");         /* CRT = 0       */
   fprintf(textfile, "r1  = r0;\n");           /* LCD/BOTH = 10 */
   fprintf(textfile, "r0 ^= 0x10;\n");         /* CRT=10/LCD=0  */
}

/*****************************************************************************
 *
 * FUNCTION NAME = ThinkpadWriteVGAFixup()                         @V3.0YEE05
 *
 * DESCRIPTION   = Prints out instructions to fixup clock for VGA (mode <= 13)
 *
 * INPUT         = NONE        r0:CRT/LCD=10/00   r1:CRT/LCD=00/10
 * OUTPUT        = NONE
 *
 *****************************************************************************/
VOID ThinkpadWriteVGAFixup(VOID)
{
   ThinkpadGetPanelType();

   /* set miscellaneous register 3c2h        CRT    LCD/BOTH*/
   fprintf(textfile, "r0 >>= 0x02;\n");   /* 04      00     */
   fprintf(textfile, "r0  |= 0x63;\n");   /* 67      63     */
   fprintf(textfile, "outb(0x3c2, r0);\n");   /* set misc  */

   /* determine clock value */
   fprintf(textfile, "r0   = r1 ^ 0x10;\n");  /* CRT=10 LCD=00   */
   fprintf(textfile, "r0 >>= 0x01;\n");       /* CRT=08 LCD=00   */

   switch(ThinkpadRefresh640)
   {
      case 2:             /* 75Hz */
         fprintf(textfile, "r0  |= 0x15;\n"); /* CRT=1d LCD=15   */
         break;

      default:            /* 60Hz/72Hz */
         fprintf(textfile, "r0 |= 0x05;\n");  /* CRT=0d LCD=05   */
         fprintf(textfile, "r0 |= r1;\n");    /* CRT=0d LCD=15   */
         break;
   }

   /* set SEQ 31h - PR68 Programmable Clock Select Register      */
   fprintf(textfile, "outb(0x3c4, 0x31);\n");
   fprintf(textfile, "outb(0x3c5, r0);\n");
}

/*****************************************************************************
 *
 * FUNCTION NAME = ThinkpadCleanup()                               @V3.0YEE05
 *
 * DESCRIPTION   = Fixup cleanup section for Thinkpad systems
 *
 * INPUT         = NONE
 * OUTPUT        = NONE
 *
 *****************************************************************************/
VOID ThinkpadCleanup(VOID)
{
  /* Set clock according to CRT/LCD/BOTH and refresh rate       @V3.0YEE05*/

  if (ThinkpadMaxLCDRes() == 800)   /* 800x600 panel */
  {
     ThinkpadWriteVGAFixup();
  }
}

/*****************************************************************************
 *
 * FUNCTION NAME = ThinkpadModeFixup()                            @V3.0YEE05
 *
 * DESCRIPTION   = Fixup setmode for Thinkpad systems
 *
 * INPUT         = NONE
 * OUTPUT        = NONE
 *
 *****************************************************************************/
VOID ThinkpadModeFixup(PCHIPHEADER pChipHdr)
{
  /* d00h.12h and d00h.13h is LCD panel resolution and is       @V3.0YEE07*/
  /*    set by the BIOS and never changed.                      @V3.0YEE07*/
  /* d00h.14h and d00h.15h is the CRT display resolution and    @V3.0YEE07*/
  /*    must be set for the respective graphics modes.          @V3.0YEE07*/
  /* On LCD panel that does 800x600, need to do some register   @V3.0YEE05*/
  /* fix-ups to set clock correctly since PMI generated on CRT  @V3.0YEE05*/
  /* does not work properly in simultaneous mode.               @V3.0YEE05*/
  /* Code duplicated in vvwdrestoreiostate also.  (U-G-L-Y!!)   @V3.0YEE05*/

  if  (pChipHdr->bModeAttributes & GRAPHICS_MODEATTR)
  {
     /**  d00h.14h is the horizontal resolution (H-res/8)-1) **/
     fprintf(textfile, "outb(0xd00, 0x14);\n");
     fprintf(textfile, "outb(0xd01, 0x%03x);\n", (pChipHdr->usXResolution/8)-1);

     /**  d00h.15h is the horizontal resolution (V-res/8)-1) **/
     fprintf(textfile, "outb(0xd00, 0x15);\n");
     fprintf(textfile, "outb(0xd01, 0x%03x);\n", (pChipHdr->usYResolution/8)-1);
  }

  if (ThinkpadMaxLCDRes() == 800)   /* 800x600 panel  */
  {

     if (pChipHdr->usXResolution == 1024)               /*@V3.0YEE09 */
     {
       /* Disable write buffer (3c4.11h, bit 2 = 0)
        * for 1024x768 resolution on Tbird-Enh
        * due to timing problem while playing Mahjongg.
        * This is on recommendation from the TB-Enh engineer.
        */

       fprintf(textfile, "outb(0x3c4, 0x11);\n");
       fprintf(textfile, "inb(r0, 0x3c5);\n");
       fprintf(textfile, "r0  &= 0xfb;\n");
       fprintf(textfile, "outb(0x3c5, r0);\n");
     }

     else                           /* not 1024x768       @V3.0YEE08 */
     {
       ThinkpadGetPanelType();

       /* set CRT 2eh - Miscellaneous Control 1           @V3.0YEE08 */
       /* set bit6 - High VCLK = 0 for CRT                @V3.0YEE08 */
       /* don't care for LCD                              @V3.0YEE08 */
       fprintf(textfile, "outb(0x3d4, 0x2e);\n");
       fprintf(textfile, "inb(r3, 0x3d5);\n");
       fprintf(textfile, "r2   = r1 << 0x02;\n");   /* CRT=00 LCD=40 */
       fprintf(textfile, "r2  |= 0xbf;\n");         /* CRT=bf LCD=ff */
       fprintf(textfile, "r3  &= r2;\n");
       fprintf(textfile, "outb(0x3d5, r3);\n");
     }

     if (pChipHdr->usXResolution == 640)
     {
        if (pChipHdr->bBitsPerPixel <= 8)             /* 16/256 cols   */
        {
//         /* set miscellaneous register 3c2h    */
//         fprintf(textfile, "outb(0x3c2, 0xe3);\n");

           /* determine clock value */                /* CRT=10 LCD=00 */
           fprintf(textfile, "r0 >>= 0x01;\n");       /* CRT=08 LCD=00 */
           switch(ThinkpadRefresh640)
           {
              case 1:             /* 72Hz */
              case 2:             /* 75Hz */
                 fprintf(textfile, "r0  |= 0x15;\n"); /* CRT=1d LCD=15 */
                 break;

              default:            /* 60Hz */
                 fprintf(textfile, "r0 |= 0x05;\n");  /* CRT=0d LCD=05 */
                 fprintf(textfile, "r0 |= r1;\n");    /* CRT=0d LCD=15 */
                 break;
           }

           /* set SEQ 31h - PR68 Programmable Clock Select Register  */
           fprintf(textfile, "outb(0x3c4, 0x31);\n");
           fprintf(textfile, "outb(0x3c5, r0);\n");
        }

        else if (pChipHdr->bBitsPerPixel == 16)   /* 64K cols    */
        {
           /* set miscellaneous register 3c2h           CRT   LCD/BOTH*/
           fprintf(textfile, "r0   = 0xe3;\n");       /* e3     e3    */
           fprintf(textfile, "r2   = r1 >> 0x01;\n"); /* 00     08    */
           fprintf(textfile, "r0  |= r2;\n");         /* e3     eb    */
           fprintf(textfile, "r2 >>= 0x01;\n");       /* 00     04    */
           fprintf(textfile, "r0  |= r2;\n");         /* e3     ef    */
           fprintf(textfile, "outb(0x3c2, r0);\n");

           /* determine clock value */
           switch(ThinkpadRefresh640)
           {
              case 1:             /* 72Hz */
              case 2:             /* 75Hz */
                 fprintf(textfile, "r0  = r1 ^ 0x10;\n");/* CRT=10 LCD=00 */
                 fprintf(textfile, "r0 |= 0x0d;\n");     /* CRT=1d LCD=0d */
                 break;

              default:            /* 60Hz */
                 fprintf(textfile, "r0 = 0x0d;\n");   /* CRT=0d LCD=0d   */
                 break;
           }

           /* set SEQ 31h - PR68 Programmable Clock Select Register  */
           fprintf(textfile, "outb(0x3c4, 0x31);\n");
           fprintf(textfile, "outb(0x3c5, r0);\n");
        }
     }

     else if ((pChipHdr->usXResolution == 800) &&     /* @V3.0YEE07  */
              (pChipHdr->bBitsPerPixel == 8))         /* 256 cols    */
     {
        /* determine clock value */
        if (ThinkpadRefresh800 == 0x01)               /* 72Hz        */
        {
           /* set miscellaneous register 3c2h           CRT  LCD/BOTH*/
           fprintf(textfile, "r0 >>= 0x02;\n");       /* 04    00    */
           fprintf(textfile, "r0  |= 0x23;\n");       /* 27    23    */
           fprintf(textfile, "outb(0x3c2, r0);\n");
        }

//yee07 /* set SEQ 31h - PR68 Programmable Clock Select Register  */
//      fprintf(textfile, "outb(0x3c4, 0x31);\n");
//      fprintf(textfile, "outb(0x3c5, 0x15);\n");

     }

     else if (!(pChipHdr->bModeAttributes & GRAPHICS_MODEATTR))  /*text*/
     {
       ThinkpadWriteVGAFixup();

       /* set SEQ 01h - Clocking Mode Register            @V3.0YEE06 */
       /* set bit0 - 8/9 character clock = 0 for CRT      @V3.0YEE06 */
       /* set bit0 - 8/9 character clock = 1 for LCD/BOTH @V3.0YEE06 */
       fprintf(textfile, "outb(0x3c4, 0x01);\n");
       fprintf(textfile, "inb(r0, 0x3c5);\n");
       fprintf(textfile, "r2   = r1 >> 0x04;\n");   /* CRT=00 LCD=01 */
       fprintf(textfile, "r0  &= 0xfe;\n");
       fprintf(textfile, "r0  |= r2;\n");
       fprintf(textfile, "outb(0x3c5, r0);\n");
     }
  }
}
