/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*****************************************************************************
 *
 * SOURCE FILE NAME = SVGATSNG.C
 *
 * DESCRIPTIVE NAME = Chipdata for Tseng adapters
 *
 *
 * VERSION = V2.2
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * NOTES
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/*
**      Include files
*/

#define PMIDEF_INCL
#include "svga.h"


extern OURADAPTERINFO sAdapter;
extern UCHAR   DisplayMonitorTable;

USHORT TsengGetBank(VOID);
VOID TsengSetBank(USHORT Bank);
VOID ShowYourStuff( PCHIPINFO ChipInfo,  INT Adapter,  INT Chip );
VOID set_cur(USHORT row, USHORT col);
VOID scrnID(PCHIPINFO ChipInfo,  INT Adapter,  INT Chip, USHORT BytesPerScanLine);  //JWK28
INT  isdigit(INT);

USHORT MonitorCableData = 0;  /* for debug */
CHAR MonitorBuffer[128];                               /*JWK26*/
CHAR *pszMonitorBuffer = &MonitorBuffer[0];            /*JWK26*/




#define TSENG_MONITOR_CS1572  TSENG_MONITOR_45HI
#define TSENG_MONITOR_CS1024  TSENG_MONITOR_45HI

#define TSENG_MONITOR_IBM_8513     TSENG_MONITOR_45MI
#define TSENG_MONITOR_IBM_8514     TSENG_MONITOR_45MI
#define TSENG_MONITOR_IBM_8515     TSENG_MONITOR_45MI
#define TSENG_MONITOR_VALUE_POINT  TSENG_MONITOR_45HI
//#define DEFAULT_TSENG_MONITOR          TSENG_MONITOR_IBM_8514   /* can improve with cable data */
#define DEFAULT_TSENG_MONITOR      16
//#define DEFAULT_TSENG_MONITOR_DIAMOND  4  /* needs looking into */
#define DEFAULT_TSENG_MONITOR_DIAMOND  16 /* needs looking into */



/*
**      This table matches that described below in the code to handle
**      displaying the ValuePoint text and getting user reponses.
**
**      NOTE: The results of this process should duplicate that produced
**      by running the VMODE utility with these same values as parameters.
**
**      The ORMask is that required to OR with the bytes in the BIOS
**      data area at 40:88h and 89h which force the BIOS to use
**      appropriate values when setting modes.
*/

typedef struct _RESPONSEDATA {
        CHAR *      response;
        BYTE        ORMask88;
        BYTE        ORMask89;
} RESPONSEDATA;

RESPONSEDATA responsedata[] =
{
        "60HZ", 0x20, 0x40,
        "72HZ", 0x60, 0x40,
        "35K",  0x40, 0x40,
        "38K",  0x40, 0x00,
        "48K",  0x60, 0x40,
        "45M",  0x60, 0x40,
        "65M",  0x60, 0x60,
        "72M",  0x70, 0x60,
};




USHORT DiamondMonitorCableTypes[] =   /* fill in this table with known monitor data */

{
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x00,  3ca = 0x00 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x01,  3ca = 0x00 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x02,  3ca = 0x00 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x03,  3ca = 0x00 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x04,  3ca = 0x00 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x05,  3ca = 0x00 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x06,  3ca = 0x00 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x07,  3ca = 0x00 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x08,  3ca = 0x00 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x09,  3ca = 0x00 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0a,  3ca = 0x00 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0b,  3ca = 0x00 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0c,  3ca = 0x00 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0d,  3ca = 0x00 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0e,  3ca = 0x00 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0f,  3ca = 0x00 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x00,  3ca = 0x01 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x01,  3ca = 0x01 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x02,  3ca = 0x01 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x03,  3ca = 0x01 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x04,  3ca = 0x01 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x05,  3ca = 0x01 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x06,  3ca = 0x01 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x07,  3ca = 0x01 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x08,  3ca = 0x01 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x09,  3ca = 0x01 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0a,  3ca = 0x01 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0b,  3ca = 0x01 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0c,  3ca = 0x01 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0d,  3ca = 0x01 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0e,  3ca = 0x01 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0f,  3ca = 0x01 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x00,  3ca = 0x02 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x01,  3ca = 0x02 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x02,  3ca = 0x02 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x03,  3ca = 0x02 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x04,  3ca = 0x02 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x05,  3ca = 0x02 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x06,  3ca = 0x02 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x07,  3ca = 0x02 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x08,  3ca = 0x02 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x09,  3ca = 0x02 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0a,  3ca = 0x02 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0b,  3ca = 0x02 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0c,  3ca = 0x02 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0d,  3ca = 0x02 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0e,  3ca = 0x02 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0f,  3ca = 0x02 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x00,  3ca = 0x03 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x01,  3ca = 0x03 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x02,  3ca = 0x03 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x03,  3ca = 0x03 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x04,  3ca = 0x03 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x05,  3ca = 0x03 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x06,  3ca = 0x03 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x07,  3ca = 0x03 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x08,  3ca = 0x03 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x09,  3ca = 0x03 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0a,  3ca = 0x03 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0b,  3ca = 0x03 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0c,  3ca = 0x03 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0d,  3ca = 0x03 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0e,  3ca = 0x03 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0f,  3ca = 0x03 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x00,  3ca = 0x04 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x01,  3ca = 0x04 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x02,  3ca = 0x04 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x03,  3ca = 0x04 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x04,  3ca = 0x04 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x05,  3ca = 0x04 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x06,  3ca = 0x04 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x07,  3ca = 0x04 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x08,  3ca = 0x04 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x09,  3ca = 0x04 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0a,  3ca = 0x04 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0b,  3ca = 0x04 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0c,  3ca = 0x04 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0d,  3ca = 0x04 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0e,  3ca = 0x04 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0f,  3ca = 0x04 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x00,  3ca = 0x05 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x01,  3ca = 0x05 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x02,  3ca = 0x05 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x03,  3ca = 0x05 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x04,  3ca = 0x05 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x05,  3ca = 0x05 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x06,  3ca = 0x05 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x07,  3ca = 0x05 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x08,  3ca = 0x05 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x09,  3ca = 0x05 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0a,  3ca = 0x05 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0b,  3ca = 0x05 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0c,  3ca = 0x05 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0d,  3ca = 0x05 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0e,  3ca = 0x05 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0f,  3ca = 0x05 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x00,  3ca = 0x06 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x01,  3ca = 0x06 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x02,  3ca = 0x06 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x03,  3ca = 0x06 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x04,  3ca = 0x06 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x05,  3ca = 0x06 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x06,  3ca = 0x06 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x07,  3ca = 0x06 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x08,  3ca = 0x06 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x09,  3ca = 0x06 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0a,  3ca = 0x06 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0b,  3ca = 0x06 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0c,  3ca = 0x06 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0d,  3ca = 0x06 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0e,  3ca = 0x06 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0f,  3ca = 0x06 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x00,  3ca = 0x07 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x01,  3ca = 0x07 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x02,  3ca = 0x07 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x03,  3ca = 0x07 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x04,  3ca = 0x07 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x05,  3ca = 0x07 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x06,  3ca = 0x07 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x07,  3ca = 0x07 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x08,  3ca = 0x07 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x09,  3ca = 0x07 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0a,  3ca = 0x07 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0b,  3ca = 0x07 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0c,  3ca = 0x07 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0d,  3ca = 0x07 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0e,  3ca = 0x07 */
    DEFAULT_TSENG_MONITOR_DIAMOND,          /* 3c2 = 0x0f,  3ca = 0x07 */
};
USHORT TsengMonitorCableTypes[] =   /* fill in this table with known monitor data */
                                      /* using value point default for now */
{
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x00,  3ca = 0x00 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x01,  3ca = 0x00 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x02,  3ca = 0x00 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x03,  3ca = 0x00 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x04,  3ca = 0x00 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x05,  3ca = 0x00 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x06,  3ca = 0x00 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x07,  3ca = 0x00 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x08,  3ca = 0x00 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x09,  3ca = 0x00 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0a,  3ca = 0x00 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0b,  3ca = 0x00 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0c,  3ca = 0x00 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0d,  3ca = 0x00 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0e,  3ca = 0x00 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0f,  3ca = 0x00 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x00,  3ca = 0x01 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x01,  3ca = 0x01 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x02,  3ca = 0x01 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x03,  3ca = 0x01 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x04,  3ca = 0x01 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x05,  3ca = 0x01 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x06,  3ca = 0x01 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x07,  3ca = 0x01 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x08,  3ca = 0x01 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x09,  3ca = 0x01 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0a,  3ca = 0x01 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0b,  3ca = 0x01 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0c,  3ca = 0x01 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0d,  3ca = 0x01 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0e,  3ca = 0x01 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0f,  3ca = 0x01 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x00,  3ca = 0x02 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x01,  3ca = 0x02 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x02,  3ca = 0x02 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x03,  3ca = 0x02 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x04,  3ca = 0x02 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x05,  3ca = 0x02 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x06,  3ca = 0x02 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x07,  3ca = 0x02 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x08,  3ca = 0x02 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x09,  3ca = 0x02 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0a,  3ca = 0x02 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0b,  3ca = 0x02 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0c,  3ca = 0x02 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0d,  3ca = 0x02 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0e,  3ca = 0x02 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0f,  3ca = 0x02 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x00,  3ca = 0x03 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x01,  3ca = 0x03 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x02,  3ca = 0x03 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x03,  3ca = 0x03 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x04,  3ca = 0x03 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x05,  3ca = 0x03 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x06,  3ca = 0x03 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x07,  3ca = 0x03 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x08,  3ca = 0x03 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x09,  3ca = 0x03 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0a,  3ca = 0x03 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0b,  3ca = 0x03 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0c,  3ca = 0x03 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0d,  3ca = 0x03 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0e,  3ca = 0x03 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0f,  3ca = 0x03 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x00,  3ca = 0x04 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x01,  3ca = 0x04 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x02,  3ca = 0x04 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x03,  3ca = 0x04 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x04,  3ca = 0x04 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x05,  3ca = 0x04 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x06,  3ca = 0x04 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x07,  3ca = 0x04 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x08,  3ca = 0x04 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x09,  3ca = 0x04 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0a,  3ca = 0x04 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0b,  3ca = 0x04 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0c,  3ca = 0x04 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0d,  3ca = 0x04 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0e,  3ca = 0x04 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0f,  3ca = 0x04 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x00,  3ca = 0x05 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x01,  3ca = 0x05 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x02,  3ca = 0x05 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x03,  3ca = 0x05 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x04,  3ca = 0x05 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x05,  3ca = 0x05 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x06,  3ca = 0x05 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x07,  3ca = 0x05 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x08,  3ca = 0x05 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x09,  3ca = 0x05 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0a,  3ca = 0x05 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0b,  3ca = 0x05 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0c,  3ca = 0x05 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0d,  3ca = 0x05 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0e,  3ca = 0x05 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0f,  3ca = 0x05 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x00,  3ca = 0x06 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x01,  3ca = 0x06 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x02,  3ca = 0x06 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x03,  3ca = 0x06 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x04,  3ca = 0x06 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x05,  3ca = 0x06 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x06,  3ca = 0x06 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x07,  3ca = 0x06 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x08,  3ca = 0x06 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x09,  3ca = 0x06 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0a,  3ca = 0x06 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0b,  3ca = 0x06 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0c,  3ca = 0x06 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0d,  3ca = 0x06 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0e,  3ca = 0x06 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0f,  3ca = 0x06 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x00,  3ca = 0x07 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x01,  3ca = 0x07 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x02,  3ca = 0x07 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x03,  3ca = 0x07 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x04,  3ca = 0x07 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x05,  3ca = 0x07 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x06,  3ca = 0x07 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x07,  3ca = 0x07 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x08,  3ca = 0x07 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x09,  3ca = 0x07 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0a,  3ca = 0x07 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0b,  3ca = 0x07 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0c,  3ca = 0x07 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0d,  3ca = 0x07 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0e,  3ca = 0x07 */
    DEFAULT_TSENG_MONITOR,          /* 3c2 = 0x0f,  3ca = 0x07 */
};

TSENG_MONITORS TsengMonitorTableET4000[] =                 /*            ET4000 version*/
{
  {"UNKNOWN", {60, 56, 43, 00}},    /*JWK10*/
  {"60HZ",    {60, 00, 00, 00}},       /* fixed */
  {"72HZ",    {72, 00, 00, 00}},       /* fixed */
  {"35K",     {60, 56, 00, 00}},       /* fixed */
  {"38K",     {72, 60, 00, 00}},       /* fixed */
  {"48K",     {72, 72, 00, 00}},       /* fixed */
  {"45MI",    {72, 60, 43, 00}},       /* multi interlaced */
  {"65M",     {72, 72, 60, 00}},       /* multi */
  {"70M",     {72, 72, 70, 00}},       /* multi */
  {"72M",     {72, 72, 70, 00}},       /* multi */
  {"45HI",    {72, 72, 43, 00}},       /* high interlaced */
  {"60H",     {72, 72, 60, 00}},       /* high */
  {"70H",     {72, 72, 70, 00}},       /* high */
  {"CUSTOM",  {0xfe, 0xfe, 0xfe, 0x00}},
  {"AUTO",    {72, 72, 70, 00}},    /* works ONLY with BIOSMonitorSupport */ /*JWK08*/
  {"DEFAULT", {72, 72, 43, 00}},    /*JWK08*/
  {"UNKNOWN", {60, 56, 43, 00}},    /*JWK10*/
  {"UNLIMITED", {TSENG_REFRESH_UNLIMITED,TSENG_REFRESH_UNLIMITED,TSENG_REFRESH_UNLIMITED,TSENG_REFRESH_UNLIMITED}},    /*JWK26*/
};

USHORT usSizeTsengMonitorTableET4000 =
  sizeof(TsengMonitorTableET4000)/sizeof(TSENG_MONITORS);

TSENG_MONITORS TsengMonitorTableW32[] =                 /*            ET4000W32x version*/
{
  {"UNKNOWN", {60, 56, 43, 00}},    /*JWK10*/
  {"60HZ",    {60, 00, 00, 00}},       /* fixed */
  {"72HZ",    {72, 00, 00, 00}},       /* fixed */
  {"35K",     {60, 56, 00, 00}},       /* fixed */
  {"38K",     {72, 60, 00, 00}},       /* fixed */
  {"48K",     {72, 72, 00, 00}},       /* fixed */
  {"45MI",    {72, 60, 43, 00}},       /* multi interlaced */
  {"65M",     {72, 72, 60, 00}},       /* multi */
  {"70M",     {72, 72, 70, 00}},       /* multi */
  {"72M",     {72, 72, 70, 00}},       /* multi */
  {"45HI",    {72, 72, 43, 43}},       /* high interlaced */
  {"60H",     {72, 72, 70, 60}},       /* high */
  {"70H",     {72, 72, 70, 70}},       /* high */
  {"CUSTOM",  {0xfe, 0xfe, 0xfe, 0xfe}},
  {"AUTO",    {72, 72, 70, 70}},    /* works ONLY with BIOSMonitorSupport */ /*JWK08*/
  {"DEFAULT", {72, 72, 43, 43}},    /*JWK08*/
  {"UNKNOWN", {60, 56, 43, 00}},    /*JWK10*/
  {"UNLIMITED", {TSENG_REFRESH_UNLIMITED,TSENG_REFRESH_UNLIMITED,TSENG_REFRESH_UNLIMITED,TSENG_REFRESH_UNLIMITED}},    /*JWK26*/
};

USHORT usSizeTsengMonitorTableW32 =
  sizeof(TsengMonitorTableW32)/sizeof(TSENG_MONITORS);

TSENG_MONITORS TsengMonitorTableW32x[] =                 /*            ET4000W32x version*/
{
  {"UNKNOWN", {60, 56, 43, 00}},    /*JWK10*/
  {"60HZ",    {60, 00, 00, 00}},       /* fixed */
  {"72HZ",    {72, 00, 00, 00}},       /* fixed */
  {"35K",     {60, 56, 00, 00}},       /* fixed */
  {"38K",     {72, 60, 00, 00}},       /* fixed */
  {"48K",     {72, 72, 00, 00}},       /* fixed */
  {"45MI",    {72, 60, 43, 00}},       /* multi interlaced */
  {"65M",     {72, 72, 60, 00}},       /* multi */
  {"70M",     {72, 72, 70, 00}},       /* multi */
  {"72M",     {72, 72, 70, 00}},       /* multi */
  {"45HI",    {72, 72, 43, 43}},       /* high interlaced */
  {"60H",     {72, 72, 70, 60}},       /* high */
  {"70H",     {72, 72, 70, 70}},       /* high */
  {"75H",     {75, 75, 75, 75}},       /* high */   /*jwk05*/
  {"90H",     {90, 90, 75, 75}},       /* high */   /*jwk05*/
  {"CUSTOM",  {0xfe, 0xfe, 0xfe, 0xfe}},
  {"UNKNOWN", {60, 56, 43, 00}},    /*JWK10*/
  {"AUTO",    {90, 90, 75, 75}},    /* works ONLY with BIOSMonitorSupport */ /*JWK08*/
  {"DEFAULT", {72, 72, 43, 43}},    /*JWK08*/
  {"UNLIMITED", {TSENG_REFRESH_UNLIMITED,TSENG_REFRESH_UNLIMITED,TSENG_REFRESH_UNLIMITED,TSENG_REFRESH_UNLIMITED}},    /*JWK26*/
};

USHORT usSizeTsengMonitorTableW32x =
  sizeof(TsengMonitorTableW32x)/sizeof(TSENG_MONITORS);

TSENG_MONITORS  DiaMonTableW32[] =                 /*            ET4000W32x version*/
{
  {"UNKNOWN",   {60, 56, 43, NO_REFRESH}},              // unknown
  {"NEC3FG",    {72, 60, 43, NO_REFRESH}},              // NEC 3fg
  {"NEC6FG",    {72, 72, 75, 75}},              // NEC 6fg
  {"VESA75",    {75, 75, 75, 75}},              // VESA 75
  {"NEC4FG",    {72, 72, 70, 43}},              // NEC 4fg
  {"GENERIC90", {90, 90, 72, 72}},              // Generic 90
  {"CS1024NI",  {60, 72, 60, NO_REFRESH}},              // CS1024ni
  {"NEC3FGX",   {72, 72, 60, 43}},              // NEC 3fgx
  {"NEC5FG",    {72, 72, 72, 60}},              // NEC 5fg
  {"FIXED",     {60, 56, 43, NO_REFRESH}},      // fixed
  {"SONY1304",  {60, 72, 60, 43}},              // Sony 1304
  {"SONY1304S", {60, 72, 70, NO_REFRESH}},      // Sony 1304S
  {"CS1572",    {72, 72, 72, 60}},              // CS1572
  {"NEC5FGE",   {72, 72, 75, 43}},              // NEC 5fge
  {"UNISYS",    {72, 72, 72, 60}},              // Unisys
//  {"CUSTOM",    {60, 56, 43, NO_REFRESH}},    // custom (not supported)
    {"CUSTOM",  {0xfe, 0xfe, 0xfe, 0xfe}},
  {"UNKNOWN",   {60, 56, 43, NO_REFRESH}},      // unknown
  {"UNLIMITED", {TSENG_REFRESH_UNLIMITED,TSENG_REFRESH_UNLIMITED,TSENG_REFRESH_UNLIMITED,TSENG_REFRESH_UNLIMITED}},    /*JWK26*/
};

USHORT usSizeDiaMonTableW32 =
  sizeof(DiaMonTableW32)/sizeof(TSENG_MONITORS);

/* to find the correct clock value given resolution, refresh, and color depth */
//           moving this to IBMGPMI
//                              DIA_ModeStruct[DIA_NUM_MODES] =                  /*JWK08*/
//           
//           {  640, 480, 60, 4,0x00},
//           {  640, 480, 60, 8,0x00},
//           {  640, 480, 60,16,0x17},
//           {  640, 480, 60,24,0x17},
//           {  640, 480, 72, 4,0x02},
//           {  640, 480, 72, 8,0x02},
//           {  640, 480, 72,16,0x13},
//           {  640, 480, 72,24,0x13},
//           {  640, 480, 75, 4,0x02},
//           {  640, 480, 75, 8,0x02},
//           {  640, 480, 75,16,0x18},
//           {  640, 480, 75,24,0x18},
//           {  640, 480, 90, 4,0x04},
//           {  640, 480, 90, 8,0x04},
//           {  640, 480, 90,16,0x14},
//           {  640, 480, 90,24,0x14},
//           {  800, 600, 56, 4,0x03},
//           {  800, 600, 56, 8,0x03},
//           {  800, 600, 56,16,0x16},
//           {  800, 600, 56,24,0x16},
//           {  800, 600, 60, 4,0x04},
//           {  800, 600, 60, 8,0x04},
//           {  800, 600, 60,16,0x14},
//           {  800, 600, 60,24,0x14},
//           {  800, 600, 72, 4,0x10},
//           {  800, 600, 72, 8,0x10},
//           {  800, 600, 72,16,0x07},
//           {  800, 600, 72,24,0x07},
//           {  800, 600, 75, 4,0x0d},
//           {  800, 600, 75, 8,0x0d},
//           {  800, 600, 75,16,0x15},
//           {  800, 600, 75,24,0x15},
//           {  800, 600, 90, 4,0x09},
//           {  800, 600, 90, 8,0x09},
//           {  800, 600, 90,16,0x15},
//           { 1024, 768, 43, 4,0x05},
//           { 1024, 768, 43, 8,0x05},
//           { 1024, 768, 43,16,0x14},
//           { 1024, 768, 60, 4,0x08},
//           { 1024, 768, 60, 8,0x08},
//           { 1024, 768, 60,16,0x07},
//           { 1024, 768, 70, 4,0x07},
//           { 1024, 768, 70, 8,0x07},
//           { 1024, 768, 70,16,0x07},
//           { 1024, 768, 72, 4,0x0b},
//           { 1024, 768, 72, 8,0x0b},
//           { 1024, 768, 72,16,0x15},
//           { 1024, 768, 75, 4,0x0e},
//           { 1024, 768, 75, 8,0x0e},
//           { 1024, 768, 75,16,0x15},
//           { 1280,1024, 43, 4,0x12},
//           { 1280,1024, 43, 8,0x12},
//           { 1280,1024, 60, 8,0x12},
//           { 1280,1024, 72, 8,0x12},
//           { 1280,1024, 75, 8,0x12},
//            
//          
//           * use index found above to offset into the clock values */
//          
//                   DIA_ClockTable[] =                                          /*JWK08*/
//           
//                  0x045A8BC,                           // 00 - 25.175
//                  0x04960AC,                           // 01 - 28.322
//                  0x04BD8B5,                           // 02 - 31.5
//                  0x04F54A1,                           // 03 - 36.0
//                  0x043543D,                           // 04 - 40
//                  0x043082A,                           // 05 - 44.9
//                  0x045A83C,                           // 06 - 50.35
//                  0x04FAC28,                           // 07 - 75.00
//                  0x04D4423,                           // 09 - 65.0
//                  0x04BD835,                           // 09 - 63.0
//                  0x04FD82E,                           // 0A - 72.2
//                  0x04FE42C,                           // 0B - 77.2
//                  0x047542B,                           // 0C - 56.0
//                  0x045D844,                           // 0D - 49.5
//                  0x04FD82A,                           // 0E - 78.750
//                  0x04D8028,                           // 0F - 67.500
//                  0x045AC3C,                           // 10 - 50.800
//                  0x04BBC31,                           // 11 - 64.000
//                  0x04F7020,                           // 12 - 80.000
//                  0x043803A,                           // 19 - 47.25
//                  0x0495428,                           // 14 - 60.00
//                  0x04D0C19,                           // 15 - 74.25
//                  0x041D03D,                           // 16 - 54.1
//                  0x04CFC97,                           // 17 - 37.80
//                  0x043B443                            // 18 - 46.5
//            


//                  DIA_OUTPUT(port, value)                                          /*JWK08*/                                                       \
//              fprintf(file, "OUTB(0x%03x, 0x%02X);\n", port, value);               /*JWK08*/

VARIABLE_DEC TSENGDeclarations[] =
{
   "MMUBasePointer0",0x00000000,
   "MMUBasePointer1",0x00000004,
   "MMUBasePointer2",0x00000008,
   "MMUControl",0x13,
   "ACLSuspendTerminate",0x30,
   "ACLOperationState",0x31,
   "ACLSyncEnable",0x32,
   "ACLInterruptMask",0x34,
   "ACLInterruptStatus",0x35,
   "ACLAcceleratorStatus",0x36,
   "ACLPatternAddress",0x00000080,
   "ACLSourceAddress",0x00000084,
   "ACLPatternYOffset",0x0088,
   "ACLSourceYOffset",0x008a,
   "ACLDestinationYOffset",0x008c,
   "ACLVirtualBusSize",0x8e,
   "ACLXYDirection",0x8f,
   "ACLPatternWrap",0x90,
   "ACLSourceWrap",0x92,
   "ACLXPosition",0x0094,
   "ACLYPosition",0x0096,
   "ACLXCount",0x0098,
   "ACLYCount",0x009a,
   "ACLRoutingControl",0x9c,
   "ACLReloadControl",0x9d,
   "ACLBackgroundROP",0x9e,
   "ACLForegroundROP",0x9f,
   "ACLDestinationAddress",0x000000a0,

};

USHORT usSizeTSENGDeclaration = sizeof(TSENGDeclarations)/sizeof(VARIABLE_DEC); /*

/*
**      This table matches that described below in the code to handle
**      displaying the ValuePoint text and getting user reponses.
**
**      NOTE: The results of this process should duplicate that produced
**      by running the VMODE utility with these same values as parameters.
**
**      The ORMask is that required to OR with the bytes in the BIOS
**      data area at 40:88h and 89h which force the BIOS to use
**      appropriate values when setting modes.
*/

/*   info from tseng
**
**   The following are bits in the video BIOS data area of system RAM. These bits
**   are used by the video BIOS to select the display monitor refresh rates.
**   These bits simultaneously control 16 and 256 color refresh rates.
**
**   These bits are looked at by the BIOS during mode sets; that is, a BIOS
**   mode set must be done after changing the bits in order to have the refresh
**   rate change.
**
**   Note, other bits in these two memory locations must be preserved.
**
**
**   0:488   0:488   0:488   0:489  0:489
**   bit6    bit5    bit4    bit6   bit5       Resolution and Vertical refresh rate
**
**    0       X       X       X      X         640x480 60Hz
**    1       X       X       X      X         640x480 72Hz
**    X       0       X       1      X         800x600 56Hz
**    X       0       X       0      X         800x600 60Hz
**    X       1       X       1      X         800x600 72Hz
**    X       X       0       X      0         1024x768 87Hz (interlaced)
**    X       X       0       X      1         1024x768 60Hz (non-interlaced)
**    X       X       1       X      1         1024x768 70Hz (non-interlaced)
**
**            X = Don't care            note absence of 1280x1024 !!!!
*/



/*JWK06 bugbug table not complete, waiting for CRTC data from tseng for 75hz and 90 hz */


TSENGRESPONSEDATA TSENGresponsedata[] =
{
        "60",                                              /*user entry */
               0x00,0x40,0x00,0x00,                        /*ORMask88[]*/  /* WKB01 changed 8x6 to correct for et4000 60Hz */
               0x00,0x00,0x20,0x00,                        /*ORMask89[]*/
               0x00,0x00,0x00,0x00,                        /*ORMaskCRTC[]*//*jwk05*/
                           0xbf,0xdf,0xef,0xff,            /*ANDMask88[]*/ /*JWK08*/
                           0xff,0xff,0xdf,0xff,            /*ANDMask89[]*/ /* WKB01 changed 8x6 bf to ff to preserve bit 6 */
                           0xff,0xff,0xff,0xff,            /*ANDMaskCRTC[]*//*jwk05*/
                                    0x00,0x01,0x01,0x01,   /*TsengFrequency[]*/
                                      60,  60,  60,  60,   /*frequency[]*/ /*JWK10*/
//WKB01 "60",                                              /*user entry */
//WKB01        0x00,0x00,0x00,0x00,                        /*ORMask88[]*/
//WKB01        0x00,0x00,0x20,0x00,                        /*ORMask89[]*/
//WKB01        0x00,0x00,0x00,0x00,                        /*ORMaskCRTC[]*//*jwk05*/
//WKB01                    0xbf,0xdf,0xef,0xff,            /*ANDMask88[]*/ /*JWK08*/
//WKB01                    0xff,0xbf,0xdf,0xff,            /*ANDMask89[]*/
//WKB01                    0xff,0xff,0xff,0xff,            /*ANDMaskCRTC[]*//*jwk05*/
//WKB01                             0x00,0x01,0x01,0x01,   /*TsengFrequency[]*/
//WKB01                               60,  60,  60,  60,   /*frequency[]*/ /*JWK10*/
        "70",
               0x00,0x00,0x10,0x00,
               0x00,0x00,0x20,0x00,
               0x00,0x00,0x00,0x00,                        /*jwk05*/ /*JWK08*/
                           0xff,0xff,0xef,0xff,
                           0xff,0xff,0xdf,0xff,
                           0xff,0xff,0xff,0xff,            /*jwk05*/
                                    0xff,0xff,0x02,0x02,
                                      00,  00,  70,  70,  /*JWK10*/

        "56",
               0x00,0x00,0x00,0x00,
               0x00,0x40,0x00,0x00,
               0x00,0x00,0x00,0x00,                        /*jwk05*/
                           0xff,0xdf,0xff,0xff,
                           0xff,0xbf,0xff,0xff,
                           0xff,0xff,0xff,0xff,            /*jwk05*/
                                    0xff,0x00,0xff,0xff,
                                      00,  56,  00,  00,   /*JWK10*/
        "43",
               0x00,0x00,0x00,0x00,
               0x00,0x00,0x00,0x00,
               0x00,0x00,0x00,0x00,                        /*jwk05*/
                           0xff,0xff,0xef,0xff,
                           0xff,0xff,0xdf,0xff,
                           0xff,0xff,0xff,0xff,            /*jwk05*/
                                    0xff,0xff,0x00,0x00,
                                      00,  00,  43,  43,   /*JWK10*/
        "72",
               0x40,0x20,0x00,0x00,
               0x00,0x40,0x00,0x00,
               0x00,0x00,0x00,0x00,                        /*jwk05*/
                           0xbf,0xdf,0xff,0xff,
                           0xff,0xbf,0xff,0xff,
                           0xff,0xff,0xff,0xff,            /*jwk05*/
                                    0x01,0x02,0xff,0xff,
                                      72,  72,  00,  00,   /*JWK10*/
        "NONE",
               0x00,0x00,0x00,0x00,
               0x00,0x00,0x00,0x00,
               0x00,0x00,0x00,0x00,                        /*jwk05*/
                           0xff,0xff,0xff,0xff,
                           0xff,0xff,0xff,0xff,
                           0xff,0xff,0xff,0xff,               /*jwk05*/
                                    REFRESH_DISABLED,REFRESH_DISABLED,REFRESH_DISABLED,REFRESH_DISABLED,
                                    REFRESH_DISABLED,REFRESH_DISABLED,REFRESH_DISABLED,REFRESH_DISABLED,
        "75",                                                 /*jwk05*/
               0x40,0x20,0x10,0x00,                           /*jwk05*/
               0x00,0x40,0x20,0x00,                           /*jwk05*/
               0x00,0x00,0x00,0x00,                           /*jwk05*/
                           0xbf,0xdf,0xef,0xff,               /*jwk05*/
                           0xff,0xbf,0xdf,0xff,               /*jwk05*/
                           0xff,0xff,0xff,0xff,               /*jwk05*/
                                    0x02,0x03,0x03,0x03,      /*jwk05*/
                                      75,  75,  75,  75,      /*JWK10*//*jwk05*/
        "90",                                                 /*jwk05*/
               0x40,0x20,0x00,0x00,                           /*jwk05*/
               0x00,0x40,0x00,0x00,                           /*jwk05*/
               0x00,0x00,0x00,0x00,                           /*jwk05*/
                           0xbf,0xdf,0xff,0xff,               /*jwk05*/
                           0xff,0xbf,0xff,0xff,               /*jwk05*/
                           0xff,0xff,0xff,0xff,               /*jwk05*/
                                    0x03,0x04,0xff,0xff,      /*jwk05*/
                                      90,  90,  00,  00,      /*jwk05*/
};
USHORT usSizeTSENGresponsedata =
  sizeof(TSENGresponsedata)/ sizeof(TSENGRESPONSEDATA);

CHAR   * TsengMessageDiamondW32[] =
{
"\t\tMonitor Types and Refresh Rates Supported\n",
" Monitor Type   640x480   800x600   1024x768   1280x1024   ",
"-----------------------------------------------------------",
"   NEC3FG         72        60         43i                 ",
"   NEC6FG         72        72         75         75       ",
"   VESA75         75        75         75         75       ",
"   NEC4FG         72        72         70         43i      ",
"   GENERIC90      90        90         72         72       ",
"   CS1024NI       60        72         60                  ",
"   NEC3FGX        72        72         60         43i      ",
"   NEC5FG         72        72         72         60       ",
"   FIXED          60        56         43         00       ",
"   SONY1304       60        72         60         43i      ",
"   SONY1304S      60        72         70                  ",
"   CS1572         72        72         72         60       ",
"   NEC5FGE        72        72         75         43i      ",
"   UNISYS         72        72         72         60       ",
"   UNKNOWN        60        56         43i                 \n",
"* For compatable monitors: Make sure the desired refresh rate is supported",      /*JWK08*/
"  by your monitor for each resolution.\n",
};
USHORT usSizeTsengMessageDiamondW32 = sizeof(TsengMessageDiamondW32)/sizeof(CHAR *);

CHAR   * TsengMessage[] =
{
"\t\tModes and Refresh rates supported\n",
"HorzxVert@Ref   Key   8511,12,13,18   8514,15   6312   6314,19   OEM Horiz Freq*",
"-------------------------------------------------------------------------------",
" 640x480@60Hz   60HZ       Y             Y       Y       Y         31.5KHz",
" 640x480@72Hz   72HZ       N             N       Y       Y         37.8KHz",
" 800x600@56Hz   35K        N             N       Y       Y         35.5KHz",
" 800x600@60Hz   38K        N             N       Y       Y         38.0KHz",
" 800x600@72Hz   48K        N             N       Y       Y         48.4KHz",
"1024x768@43Hz   45Mi       N             Y       Y       Y         35.5KHz",
"1024x768@60Hz   65M        N             N       Y       Y         49.0KHz",
"1024x768@70Hz   70M        N             N       N       N         56.5KHz",
"1024x768@72Hz   72M        N             N       N       Y         56.5KHz",
"1280x1024@43Hz  45Hi       N             N       N       N         48.1KHz",
"1280x1024@60Hz  60H        N             N       N       N         64.0KHz",
"1280x1024@70Hz  70H        N             N       N       N         76.8KHz",    /*JWK08*/
"1280x1024@75Hz  75H        N             N       N       N         79.9KHz",    /*JWK08*/
"  800x600@90Hz  90H        N             N       N       N         48.1KHz\n",  /*JWK08*/
"* For OEM monitors: Make sure the desired mode and refresh is supported.",      /*JWK08*/
"  Monitor horizontal frequency must meet or exceed value listed.\n"             /*JWK08*/
};
USHORT usSizeTsengMessage = sizeof(TsengMessage)/sizeof(CHAR *);

CHAR   * TsengMonitorChoices[] =
{
"Enter desired Refresh Key (60HZ, 72HZ ... 90H | CUSTOM):",         /*JWK08*/
"Enter desired Refresh Key (60HZ, 72HZ ... 90H | AUTO | CUSTOM):",  /*JWK08*/
"Enter installed Monitor Type (NEC3FG, NEC6FG ... UNKNOWN):",         /*JWK10*/
};

CHAR   * TsengRefreshChoices[] =
{
"Enter desired Refresh Rate for 640x480 resolution (60,72,75,90,None):",
"Enter desired Refresh Rate for 800x600 resolution (56,60,72,75,90,None):",
"Enter desired Refresh Rate for 1024x768 resolution (43,60,70,75,None):",
"Enter desired Refresh Rate for 1280x1024 resolution (43,60,70,75,None):"
};
//          
//USHORT TSENGMonitorRefresh[5] =   /* magic numbers are index into TSENGresponsedata[] */
//{                                 /*JWK10 now using more readable refresh rates       */
//    75,       /*  640 x 480  @ 72 hz default */                           /*JWK10*/  /*JWK18*/
//    72,       /*  800 x 600  @ 72 hz default */                           /*JWK10*/  /*JWK18*/
//    60,       /* 1024 x 640  @ 43 hz interlaced default */                /*JWK10*/  /*JWK18*/
//    43,       /* 1280 x 1024 @ 43 hz interlaced default */                /*JWK10*/  /*JWK18*/
//     0,       /* monitor name UNKNOWN                        */           /*JWK10*/  /*JWK18*/
//};

USHORT TSENGMonitorRefresh[5] =  /*JWK22 default values for video.cfg */
                                 /* selecting a monitor will change */
{
    60,       /*  640 x 480  @ 72 hz default */                           /*JWK10*/  /*JWK18*/
    72,       /*  800 x 600  @ 72 hz default */                           /*JWK10*/  /*JWK18*/
    60,       /* 1024 x 640  @ 43 hz interlaced default */                /*JWK10*/  /*JWK18*/
    43,       /* 1280 x 1024 @ 43 hz interlaced default */                /*JWK10*/  /*JWK18*/
     0,       /* monitor name UNKNOWN                        */           /*JWK10*/  /*JWK18*/
};

USHORT TSENGMaxMonitorRefresh[5] =  /* JWK max default values for .pmi */
                                    /* selecting a monitor can increase */
{
    75,       /*  640 x 480  @ 72 hz default */                           /*JWK10*/  /*JWK18*/
    72,       /*  800 x 600  @ 72 hz default */                           /*JWK10*/  /*JWK18*/
    60,       /* 1024 x 640  @ 43 hz interlaced default */                /*JWK10*/  /*JWK18*/
    43,       /* 1280 x 1024 @ 43 hz interlaced default */                /*JWK10*/  /*JWK18*/
     0,       /* monitor name UNKNOWN                        */           /*JWK10*/  /*JWK18*/
};

USHORT TSENGRefreshFlags[5][5][10] = {0,}; /* JWK26  for use with NO init parm */
                                      /* nonzero if any refresh set */
                                      /* for resolution&color depth */
BOOL    fTsengInt3 = FALSE;
USHORT  TSENGInstance = 0;
USHORT  TSENGBaseIOData = 0;
USHORT  TSENGBaseIOIndex = 0;
ULONG   TSENGVGABase = 0;
ULONG   TSENGVGARange = 0;
ULONG   TSENGMMUApertureSize = 0;
ULONG   TSENGMMUBase = 0;
ULONG   TSENGMMURange = 0;
ULONG   TSENGMMRBase = 0;
ULONG   TSENGMMRRange = 0;
ULONG   TSENGEMRBase = 0;
ULONG   TSENGEMRRange = 0;
USHORT  TSENGBIOSMonitorSupport = 0;
USHORT  TSENGDiamondW32 = 0;                          /*JWK10*/

REGDATA TsengLockData[] =
{
  { PMICMD_REGOP, NONE,  NONE, 0x01, 2, READWRITE_DATA, "\x29" }, /*          */
  { PMICMD_REGOP, NONE,  NONE, 0x01, 1, READWRITE_DATA, "\x01" }, /*          */
  { PMICMD_REGOP, NONE,  NONE, 0x01, 0, READWRITE_DATA, "\x29" }, /*          */
  { PMICMD_OUTB,  0x3b8, NONE, NONE, 2, WRITEREG_DATA,  NULL   }, /*          */
  { PMICMD_OUTB,  0x3d8, NONE, NONE, 0, WRITEREG_DATA,  NULL   },
  { PMICMD_OUTB,  0x3bf, NONE, NONE, 1, WRITEREG_DATA,  NULL   }, /*          */
  { PMICMD_NONE },
};

REGDATA TsengUnLockData[] =
{
  { PMICMD_INB,   0x3d8, NONE, NONE, 0, NONE,           NULL   }, /*          */
  { PMICMD_INB,   0x3d8, NONE, NONE, 1, NONE,           NULL   }, /*          */
  { PMICMD_REGOP, NONE,  NONE, 0x01, 1, REGISTER_OPEQUAL | REGISTER_AND, "\x40" }, /*          */
  { PMICMD_REGOP, NONE,  NONE, 0x01, 1, REGISTER_OPEQUAL | REGISTER_SHR, "\x05" }, /*          */ /*JWK04 was 6 */
  { PMICMD_REGOP, NONE,  NONE, 0x01, 1, REGISTER_OPEQUAL | REGISTER_OR, "\x01" }, /*          *//*JWK04*/
  { PMICMD_INB,   0x3b8, NONE, NONE, 2, NONE,           NULL   }, /*          */
  { PMICMD_OUTB,  0x3bf, NONE, NONE, 0, WRITEONLY_DATA, b_3    }, /*          */
  { PMICMD_OUTB,  0x3d8, NONE, NONE, 0, WRITEONLY_DATA, "\xa0" },
  { PMICMD_OUTB,  0x3b8, NONE, NONE, 0, WRITEONLY_DATA, "\xa0" },
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x11, 0x7f, WRITEONLY_DATA, &b_0[0] },  /*JWK04*/
  { PMICMD_NONE },
};

REGDATA TsengLockDataW32[] =
{
  { PMICMD_REGOP, NONE,  NONE,  0x01, 2, READWRITE_DATA, "\x29" }, /*          */
  { PMICMD_REGOP, NONE,  NONE,  0x01, 1, READWRITE_DATA, "\x01" }, /*          */
  { PMICMD_REGOP, NONE,  NONE,  0x01, 0, READWRITE_DATA, "\x29" }, /*          */
  { PMICMD_OUTB,  0x3b8, NONE,  NONE, 2, WRITEREG_DATA,  NULL   }, /*          */
  { PMICMD_OUTB,  0x3d8, NONE,  NONE, 0, WRITEREG_DATA,  NULL   }, /*          */
  { PMICMD_OUTB,  0x3bf, NONE,  NONE, 1, WRITEREG_DATA,  NULL   }, /*          */
  { PMICMD_NONE },
};

REGDATA TsengUnLockDataW32[] =       /*jwk04 */                                        /*V2.2JWK04*/
{                                                                                      /*V2.2JWK04*/
  { PMICMD_INB,   0x3d8, NONE, NONE, 0, NONE,           NULL   },                      /*V2.2JWK04*/
  { PMICMD_INB,   0x3d8, NONE, NONE, 1, NONE,           NULL   },                      /*V2.2JWK04*/
  { PMICMD_REGOP, NONE,  NONE, 0x01, 1, REGISTER_OPEQUAL | REGISTER_AND, "\x40" },     /*V2.2JWK04*/
  { PMICMD_REGOP, NONE,  NONE, 0x01, 1, REGISTER_OPEQUAL | REGISTER_SHR, "\x05" },     /*V2.2JWK04*/
  { PMICMD_REGOP, NONE,  NONE, 0x01, 1, REGISTER_OPEQUAL | REGISTER_OR,  "\x01" },     /*V2.2JWK04*/
  { PMICMD_INB,   0x3b8, NONE, NONE, 2, NONE,           NULL   },                      /*V2.2JWK04*/
  { PMICMD_OUTB,  0x3bf, NONE, NONE, 0, WRITEONLY_DATA, b_3    },                      /*V2.2JWK04*/
  { PMICMD_OUTB,  0x3d8, NONE, NONE, 0, WRITEONLY_DATA, "\xa0" },                      /*V2.2JWK04*/
  { PMICMD_OUTB,  0x3b8, NONE, NONE, 0, WRITEONLY_DATA, "\xa0" },                      /*V2.2JWK04*/
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x11, 0x7f, WRITEONLY_DATA, &b_0[0] },  /*V2.2JWK04*/
  { PMICMD_RMWBI, ATC_INDEXPORT, ATC_DATAPORT, 0x16, 0xfc, WRITEONLY_DATA, &b_0[0] },  /*V2.2JWK04*/
  { PMICMD_NONE },
};






/*
**
**              Chipset Cleanup Information
**
**    If an adapter has no cleanup information, no space is allocated for
**    it. ADAPTER_CLEANUP_INDEX needs to be defined for all those that
**    do have cleanup section. These indices are used rather than ADAPTER
**    ID's to facilitate different cleanup routines for different chipsets
**    and not to depend on the adapter ID values.
*/
REGDATA TsengET4000CleanData[] =
{                                    /* Tseng Cleanups        */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x07, 0x00, READWRITE_DATA, &SEQRegData[0x07] },
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x31, 0x3f, READWRITE_DATA, &CRTRegData[0x31] },
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x33, 0x00, READWRITE_DATA, &CRTRegData[0x33] },
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x34, 0x00, READWRITE_DATA, &CRTRegData[0x34] },
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x35, 0x00, READWRITE_DATA, &CRTRegData[0x35] },
  { PMICMD_RMWBN, TSENG_SETBANK, TSENG_SETBANK, 0x00, 0x00, WRITEONLY_DATA, b_0 },
  { PMICMD_NONE },
};
REGDATA TsengET4000W32CleanData[] =
{
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x06, 0x00, READWRITE_DATA, &SEQRegData[0x06] }, /*JWK04*/
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x07, 0x00, READWRITE_DATA, &SEQRegData[0x07] }, /*JWK04*/
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x30, 0x00, READWRITE_DATA, &CRTRegData[0x30] },
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x31, 0x00, READWRITE_DATA, &CRTRegData[0x31] },
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x32, 0x00, READWRITE_DATA, &CRTRegData[0x32] },
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x33, 0x00, READWRITE_DATA, &CRTRegData[0x33] },
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x34, 0x00, READWRITE_DATA, &CRTRegData[0x34] },
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x35, 0x00, READWRITE_DATA, &CRTRegData[0x35] },
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x36, 0x00, READWRITE_DATA, &CRTRegData[0x36] }, /* disable mmu  */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x37, 0x00, READWRITE_DATA, &CRTRegData[0x37] },
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x3f, 0x00, READWRITE_DATA, &CRTRegData[0x3f] },
  { PMICMD_RMWBI, ATC_INDEXPORT, ATC_DATAPORT, 0x16, 0x00, READWRITE_DATA, &ATCRegData[0x16] }, /*JWK04*/
  { PMICMD_RMWBI, ATC_INDEXPORT, ATC_DATAPORT, 0x17, 0x00, READWRITE_DATA, &ATCRegData[0x17] }, /*JWK04*/
  { PMICMD_RMWBI, TSENG_BASE_INDEX, TSENG_BASE_DATA, 0xE0, 0x00, READWRITE_DATA, &IMARegData[0xE0] },    /* CRTCB */
  { PMICMD_RMWBI, TSENG_BASE_INDEX, TSENG_BASE_DATA, 0xE1, 0x00, READWRITE_DATA, &IMARegData[0xE1] },
  { PMICMD_RMWBI, TSENG_BASE_INDEX, TSENG_BASE_DATA, 0xE2, 0x00, READWRITE_DATA, &IMARegData[0xE2] },
  { PMICMD_RMWBI, TSENG_BASE_INDEX, TSENG_BASE_DATA, 0xE3, 0x00, READWRITE_DATA, &IMARegData[0xE3] },
  { PMICMD_RMWBI, TSENG_BASE_INDEX, TSENG_BASE_DATA, 0xE4, 0x00, READWRITE_DATA, &IMARegData[0xE4] },
  { PMICMD_RMWBI, TSENG_BASE_INDEX, TSENG_BASE_DATA, 0xE5, 0x00, READWRITE_DATA, &IMARegData[0xE5] },
  { PMICMD_RMWBI, TSENG_BASE_INDEX, TSENG_BASE_DATA, 0xE6, 0x00, READWRITE_DATA, &IMARegData[0xE6] },
  { PMICMD_RMWBI, TSENG_BASE_INDEX, TSENG_BASE_DATA, 0xE7, 0x00, READWRITE_DATA, &IMARegData[0xE7] },
  { PMICMD_RMWBI, TSENG_BASE_INDEX, TSENG_BASE_DATA, 0xE8, 0x00, READWRITE_DATA, &IMARegData[0xE8] },
  { PMICMD_RMWBI, TSENG_BASE_INDEX, TSENG_BASE_DATA, 0xE9, 0x00, READWRITE_DATA, &IMARegData[0xE9] },
  { PMICMD_RMWBI, TSENG_BASE_INDEX, TSENG_BASE_DATA, 0xEA, 0x00, READWRITE_DATA, &IMARegData[0xEA] },
  { PMICMD_RMWBI, TSENG_BASE_INDEX, TSENG_BASE_DATA, 0xEB, 0x00, READWRITE_DATA, &IMARegData[0xEB] },
  { PMICMD_RMWBI, TSENG_BASE_INDEX, TSENG_BASE_DATA, 0xEC, 0x00, READWRITE_DATA, &IMARegData[0xEC] },
  { PMICMD_RMWBI, TSENG_BASE_INDEX, TSENG_BASE_DATA, 0xED, 0x00, READWRITE_DATA, &IMARegData[0xED] },
  { PMICMD_RMWBI, TSENG_BASE_INDEX, TSENG_BASE_DATA, 0xEE, 0x00, READWRITE_DATA, &IMARegData[0xEE] },
  { PMICMD_RMWBI, TSENG_BASE_INDEX, TSENG_BASE_DATA, 0xEF, 0x00, READWRITE_DATA, &IMARegData[0xEF] },
  { PMICMD_RMWBI, TSENG_BASE_INDEX, TSENG_BASE_DATA, 0xF0, 0x00, READWRITE_DATA, &IMARegData[0xF0] },  /* ima */
  { PMICMD_RMWBI, TSENG_BASE_INDEX, TSENG_BASE_DATA, 0xF1, 0x00, READWRITE_DATA, &IMARegData[0xF1] },
  { PMICMD_RMWBI, TSENG_BASE_INDEX, TSENG_BASE_DATA, 0xF2, 0x00, READWRITE_DATA, &IMARegData[0xF2] },
  { PMICMD_RMWBI, TSENG_BASE_INDEX, TSENG_BASE_DATA, 0xF3, 0x00, READWRITE_DATA, &IMARegData[0xF3] },
  { PMICMD_RMWBI, TSENG_BASE_INDEX, TSENG_BASE_DATA, 0xF4, 0x00, READWRITE_DATA, &IMARegData[0xF4] },
  { PMICMD_RMWBI, TSENG_BASE_INDEX, TSENG_BASE_DATA, 0xF5, 0x00, READWRITE_DATA, &IMARegData[0xF5] },
  { PMICMD_RMWBI, TSENG_BASE_INDEX, TSENG_BASE_DATA, 0xF6, 0x00, READWRITE_DATA, &IMARegData[0xF6] },
  { PMICMD_RMWBI, TSENG_BASE_INDEX, TSENG_BASE_DATA, 0xF7, 0x00, READWRITE_DATA, &IMARegData[0xF7] },
  { PMICMD_RMWBN, TSENG_SETBANK, TSENG_SETBANK,   0x00, 0x00, WRITEONLY_DATA, b_0 },                   /* DONT MUCK WITH THE  MMU OR ACL */
  { PMICMD_RMWBN, TSENG_SETBANK_W32, TSENG_SETBANK_W32, 0x00, 0x00, WRITEONLY_DATA, b_0 },
  { PMICMD_NONE },
};

/*
**
**              Chipset Setbank Information
**
**              Set/Get Banks are based on svgabank.asm in screendd
**              of Picard.           
**
**              Registers are unlocked already and always set/get
**              write bank only.
**
*/

REGDATA TsengSetBank_ET3000Cmd[] =
/*******************************************  Picard 2/8/94

r0 = 0;                 ; Up to 4 M, should be O.K.
r0 &= 0x0f;
r1 = r0 & 0x30;
if (ET4000 or above)
   r2 = r0 << 0x04;
else                    ; ET3000
   r2 = r0 << 0x03;
r3 >= 0x04;
r0 |= r2;               ;get GDC segment select 1 addr.
outb (0x3cd, r0);       ;output bits 0:3 of read/write bank
r1 |= r3;               ;get GDC segment select 2 addr.
outb (0x3cb, r1);       ;output bits 4:5 of read/write bank
                        ; doesn't exist on ET3000/ET4000
***************************************************************/

{
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x00, WRITEONLY_DATA, b_0 },
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x00, REGISTER_OPEQUAL|REGISTER_AND, b_7 },
    { PMICMD_REGOP, 0x00, NONE, 0x01, 0x01, REGISTER_OPERAND|REGISTER_AND, "\x30" },
    { PMICMD_REGOP, 0x00, NONE, 0x01, 0x02, REGISTER_OPERAND|REGISTER_SHL, b_3 },
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x03, REGISTER_OPEQUAL|REGISTER_SHR, b_4 },
    { PMICMD_REGOP, 0x02, NONE, 0x01, 0x00, REGISTER_OPEQUAL|REGISTER_OPERAND|REGISTER_OR },
    { PMICMD_OUTB, TSENG_SETBANK, NONE, NONE, 0, WRITEREG_DATA },
    { PMICMD_NONE },
};

REGDATA TsengSetBank_ET4000Cmd[] =
{
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x00, WRITEONLY_DATA, b_0 },
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x00, REGISTER_OPEQUAL|REGISTER_AND, b_F },
    { PMICMD_REGOP, 0x00, NONE, 0x01, 0x01, REGISTER_OPERAND|REGISTER_AND, "\x30" },
    { PMICMD_REGOP, 0x00, NONE, 0x01, 0x02, REGISTER_OPERAND|REGISTER_SHL, b_4 },
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x03, REGISTER_OPEQUAL|REGISTER_SHR, b_4 },
    { PMICMD_REGOP, 0x02, NONE, 0x01, 0x00, REGISTER_OPEQUAL|REGISTER_OPERAND|REGISTER_OR },
    { PMICMD_OUTB, TSENG_SETBANK, NONE, NONE, 0, WRITEREG_DATA },
    { PMICMD_NONE },
};

REGDATA TsengSetBank_ET4000W32xCmd[] =      /* jwk */
{
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x00, WRITEONLY_DATA, b_0 },
    { PMICMD_REGOP, 0x00, NONE, 0x01, 0x01, REGISTER_OPERAND|REGISTER_AND, b_F },
    { PMICMD_REGOP, 0x01, NONE, 0x01, 0x02, REGISTER_OPERAND|REGISTER_SHL, b_4 },
    { PMICMD_REGOP, 0x01, NONE, 0x01, 0x02, REGISTER_OPEQUAL|REGISTER_OPERAND|REGISTER_OR },
    { PMICMD_OUTB, TSENG_SETBANK, NONE, NONE, 2, WRITEREG_DATA },
    { PMICMD_REGOP, 0x00, NONE, 0x01, 0x01, REGISTER_OPERAND|REGISTER_AND, "\x30" },
    { PMICMD_REGOP, 0x01, NONE, 0x01, 0x02, REGISTER_OPERAND|REGISTER_SHR, b_4 },
    { PMICMD_REGOP, 0x01, NONE, 0x01, 0x02, REGISTER_OPEQUAL|REGISTER_OPERAND|REGISTER_OR },
    { PMICMD_OUTB, TSENG_SETBANK_W32, NONE, NONE, 2, WRITEREG_DATA },
    { PMICMD_NONE },
};

/*
**
**              Chipset Getbank Information            
**
*/

REGDATA TsengGetBank_ET3000Cmd[] =
/********************************************     Borg 2/8/94
----------------------------------------------------
Tseng ET4000

    inw(r0, 0x3cd);
    r0 &= 0x0f;

----------------------------------------
Tseng ET3000

    inw(r0, 0x3cd);
    r0 &= 0x07;
***************************************************************/
{
    { PMICMD_INB,   TSENG_SETBANK, NONE, NONE, 0, NONE, NULL },
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x00, REGISTER_OPEQUAL|REGISTER_AND, b_7 },
    { PMICMD_NONE },
};

REGDATA TsengGetBank_ET4000Cmd[] =
{
    { PMICMD_INB,   TSENG_SETBANK, NONE, NONE, 0, NONE, NULL },
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x00, REGISTER_OPEQUAL|REGISTER_AND, b_F },
    { PMICMD_NONE },
};

REGDATA TsengGetBank_ET4000W32xCmd[] =
{
    { PMICMD_INB,   TSENG_SETBANK, NONE, NONE, 0, NONE, NULL },
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x00, REGISTER_OPEQUAL|REGISTER_AND, b_F },
    { PMICMD_INB,   TSENG_SETBANK_W32, NONE,  NONE, 1, NONE, NULL },
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x01, REGISTER_OPEQUAL|REGISTER_AND, b_3 },
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x01, REGISTER_OPEQUAL|REGISTER_SHL, b_4 },
    { PMICMD_REGOP, 0x01, NONE, 0x01, 0x00, REGISTER_OPEQUAL|REGISTER_OPERAND|REGISTER_OR },
    { PMICMD_NONE },
};

/*
**      Standard VGA Chipset - for GENERIC use only.
*/

BANKROUTINE  TsengSetBank_ET3000 = {"SetBankLinear", TsengSetBank_ET3000Cmd};
BANKROUTINE  TsengGetBank_ET3000 = {"GetBankLinear", TsengGetBank_ET3000Cmd};
BANKROUTINE  TsengSetBank_ET4000 = {"SetBankLinear", TsengSetBank_ET4000Cmd};
BANKROUTINE  TsengGetBank_ET4000 = {"GetBankLinear", TsengGetBank_ET4000Cmd};
BANKROUTINE  TsengSetBank_ET4000W32x = {"SetBankLinear", TsengSetBank_ET4000W32xCmd};
BANKROUTINE  TsengGetBank_ET4000W32x = {"GetBankLinear", TsengGetBank_ET4000W32xCmd};

/*
**
**              Chipset Mode Information
**
*/

/*
** Tseng ET3000
*/

REGDATA TsengModeSet1 [] =
{
  { PMICMD_OUTB,  MISCOUTPUTREG_WRITE, NONE,   0x00, 0x00, WRITEONLY_DATA, &MiscOutRegData }, /*          */
  { PMICMD_BOUTB, TSENG_SETBANK, TSENG_SETBANK, 0x01, 0x00, WRITEONLY_DATA, b_0 },
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x05, 0x00, READWRITE_DATA, &SEQRegData[0x00] },
  { PMICMD_OUTW,  SEQ_INDEXPORT, NONE, NONE, 0x00, WRITEONLY_DATA, &bEndSEQReset[0] },
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x02, 0x06, READWRITE_DATA, &SEQRegData[0x06] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x26, 0x00, READWRITE_DATA, &CRTRegData[0x00] },
  { PMICMD_BOUTB, ATC_INDEXPORT, ATC_DATAPORT, 0x15, 0x00, READWRITE_DATA, &ATCRegData[0x00] },
  { PMICMD_BOUTB, ATC_INDEXPORT, ATC_DATAPORT, 0x01, 0x16, READWRITE_DATA, &ATCRegData[0x16] },
  { PMICMD_BOUTB, GDC_INDEXPORT, GDC_DATAPORT, 0x09, 0x00, READWRITE_DATA, &GDCRegData[0x00] },
  { PMICMD_NONE }
};

CHIPINFO TsengChipSetET3000[] =
{

  {
    0x2e,
    &ChipInfoHeader[GRAPHICS_640x480x256],
    &TsengSetBank_ET3000,
    &TsengGetBank_ET3000,
    TsengModeSet1,
    0,
  },

  {
    0x29,
    &ChipInfoHeader[GRAPHICS_800x600x16],
    &TsengSetBank_ET3000,
    &TsengGetBank_ET3000,
    TsengModeSet1,
    0,
  },

  {
    0x30,
    &ChipInfoHeader[GRAPHICS_800x600x256],
    &TsengSetBank_ET3000,
    &TsengGetBank_ET3000,
    TsengModeSet1,
    0,
  },

  {
    0x37,
    &ChipInfoHeader[GRAPHICS_1024x768x16],
    &TsengSetBank_ET3000,
    &TsengGetBank_ET3000,
    TsengModeSet1,
    0,
  },

  {
    0x23,
    &ChipInfoHeader[GRAPHICS_1024x768x256],
    &TsengSetBank_ET3000,
    &TsengGetBank_ET3000,
    TsengModeSet1,
    0,
  },

  {
    0x22,
    &ChipInfoHeader[TEXT_132x43],
    &TsengSetBank_ET3000,
    &TsengGetBank_ET3000,
    TsengModeSet1,
    0,
  },
};

USHORT usSizeTsengChipSetET3000 = sizeof(TsengChipSetET3000)/sizeof(CHIPINFO);

/*
** Tseng ET4000
*/

REGDATA TsengModeSet2a [] =
{
  { PMICMD_OUTB,  MISCOUTPUTREG_WRITE, NONE,   0x00, 0x00, WRITEONLY_DATA, &MiscOutRegData }, /*          */
  { PMICMD_BOUTB, TSENG_SETBANK, TSENG_SETBANK,0x01, 0x00, WRITEONLY_DATA, b_0 },
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x05, 0x00, READWRITE_DATA, &SEQRegData[0x00] },
  { PMICMD_OUTW,  SEQ_INDEXPORT, NONE,         NONE, 0x00, WRITEONLY_DATA, &bEndSEQReset[0] },
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x02, 0x06, READWRITE_DATA, &SEQRegData[0x06] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x19, 0x00, READWRITE_DATA, &CRTRegData[0x00] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x01, 0x31, READWRITE_DATA, &CRTRegData[0x31] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x02, 0x34, READWRITE_DATA, &CRTRegData[0x34] },
  { PMICMD_BOUTB, ATC_INDEXPORT, ATC_DATAPORT, 0x15, 0x00, READWRITE_DATA, &ATCRegData[0x00] },
  { PMICMD_BOUTB, ATC_INDEXPORT, ATC_DATAPORT, 0x01, 0x16, READWRITE_DATA, &ATCRegData[0x16] },
  { PMICMD_BOUTB, GDC_INDEXPORT, GDC_DATAPORT, 0x09, 0x00, READWRITE_DATA, &GDCRegData[0x00] },
                                            /*            MC Pro start */
  { PMICMD_INB,   MC_SETUPREG,   NONE,         NONE, 0x01, NONE, NULL },
  { PMICMD_OUTB,  MC_SETUPREG,   NONE,         NONE, 0x00, WRITEONLY_DATA, &MiscRegData[0x00] },
  { PMICMD_RMWBI,  MC_POS3REG,    MC_POS3REG,   0x00, 0x00, READWRITE_DATA, &MiscRegData[0x01] },
  { PMICMD_OUTB,  MC_SETUPREG,   NONE,         NONE, 0x01, WRITEREG_DATA },
                                            /*            MC Pro end   */
  { PMICMD_NONE }
};

REGDATA TsengModeSet2b [] =
{
  { PMICMD_BOUTB, TSENG_SETBANK, TSENG_SETBANK,0x01, 0x00, WRITEONLY_DATA, b_0 },
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x05, 0x00, READWRITE_DATA, &SEQRegData[0x00] },
  { PMICMD_INB,   ORCHID_PSEUDO, NONE,         NONE, 0x01, NONE, NULL },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x02, 0x34, READWRITE_DATA, &CRTRegData[0x34] },
  { PMICMD_OUTB,  MISCOUTPUTREG_WRITE, NONE,   NONE, 0x00, WRITEONLY_DATA, "\xE3"},
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x02, 0x06, READWRITE_DATA, &SEQRegData[0x06] },
  { PMICMD_OUTW,  SEQ_INDEXPORT, NONE,         NONE, 0x00, WRITEONLY_DATA, &bEndSEQReset[0] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x19, 0x00, READWRITE_DATA, &CRTRegData[0x00] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x01, 0x31, READWRITE_DATA, &CRTRegData[0x31] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x02, 0x34, READWRITE_DATA, &CRTRegData[0x34] },
  { PMICMD_BOUTB, ATC_INDEXPORT, ATC_DATAPORT, 0x15, 0x00, READWRITE_DATA, &ATCRegData[0x00] },
  { PMICMD_BOUTB, ATC_INDEXPORT, ATC_DATAPORT, 0x01, 0x16, READWRITE_DATA, &ATCRegData[0x16] },
  { PMICMD_BOUTB, GDC_INDEXPORT, GDC_DATAPORT, 0x09, 0x00, READWRITE_DATA, &GDCRegData[0x00] },
  { PMICMD_OUTB,  ORCHID_PSEUDO, NONE,         NONE, 0x00, WRITEONLY_DATA, NULL },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x02, 0x34, READWRITE_DATA, &CRTRegData[0x34] },
                                            /*            MC Pro start */
  { PMICMD_INB,   MC_SETUPREG,   NONE,         NONE, 0x01, NONE, NULL },
  { PMICMD_OUTB,  MC_SETUPREG,   NONE,         NONE, 0x00, WRITEONLY_DATA, &MiscRegData[0x00] },
  { PMICMD_RMWBI,  MC_POS3REG,    MC_POS3REG,   0x00, 0x00, READWRITE_DATA, &MiscRegData[0x01] },
  { PMICMD_OUTB,  MC_SETUPREG,   NONE,         NONE, 0x01, WRITEREG_DATA },
                                            /*            MC Pro end   */
  { PMICMD_NONE }
};

/**
 ** JWK26 This list is order dependant.
 **
 **       The UNKNOWN refresh rates must be first so that we can
 **       collect the register settings before changing refresh rates,
 **       which may have been set by a manufactureres utility.  These
 **       entries are ignored if the MONITOR or INIT parameter flags are set.
 **
 **       The ANY refresh rates are used as a wild card, and cause a mode
 **       set attempt only if not previously successfull for a given
 **       resolution and color depth, at any refresh rate.  This is for
 **       adapters that do not fit our model for setting refresh rates.
 **       We really only allow refresh rates as published by Tseng
 **       AND if the extended BIOS supports the Get/Set refresh rate function.
 **       This is needed for BIOS's which do not support get/set refresh rates,
 **       but do support 1280 resolution (DELL VESA).
 */

CHIPINFO TsengChipSetET4000[] =
{
  {
    VGAMODE,
    &ChipInfoHeader[GRAPHICS_640x480x16],
    &TsengSetBank_ET4000,
    &TsengGetBank_ET4000,
    TsengModeSet2a,
    0,                                         /*JWK26*/
  },
  {
    VGAMODE,
    &ChipInfoHeader[GRAPHICS_640x480x16],
    &TsengSetBank_ET4000,
    &TsengGetBank_ET4000,
    TsengModeSet2a,
    TSENG_REFRESH_UNKNOWN,                     /*JWK26*/
  },
  {
    0x2e,
    &ChipInfoHeader[GRAPHICS_640x480x256],
    &TsengSetBank_ET4000,
    &TsengGetBank_ET4000,
    TsengModeSet2a,
    TSENG_REFRESH_UNKNOWN,
  },
  {
    0x29,
    &ChipInfoHeader[GRAPHICS_800x600x16],
    &TsengSetBank_ET4000,
    &TsengGetBank_ET4000,
    TsengModeSet2a,
    TSENG_REFRESH_UNKNOWN,
  },
  {                                              /*JWK10*/
    0x30,                                        /*JWK10*/
    &ChipInfoHeader[GRAPHICS_800x600x256],       /*JWK10*/
    &TsengSetBank_ET4000,                        /*JWK10*/
    &TsengGetBank_ET4000,                        /*JWK10*/
    TsengModeSet2a,                              /*JWK10*/
    TSENG_REFRESH_UNKNOWN,                       /*JWK10*/
  },                                             /*JWK10*/
  {                                              /*JWK10*/
    0x37,                                        /*JWK10*/
    &ChipInfoHeader[GRAPHICS_1024x768x16],       /*JWK10*/
    &TsengSetBank_ET4000,                        /*JWK10*/
    &TsengGetBank_ET4000,                        /*JWK10*/
    TsengModeSet2a,                              /*JWK10*/
    TSENG_REFRESH_UNKNOWN,                       /*JWK10*/
  },                                             /*JWK10*/

  {
    VGAMODE,
    &ChipInfoHeader[GRAPHICS_640x480x16],
    &TsengSetBank_ET4000,
    &TsengGetBank_ET4000,
    TsengModeSet2a,
    72,                                          /*JWK10*/
  },                                             /*JWK10*/
  {
    VGAMODE,
    &ChipInfoHeader[GRAPHICS_640x480x16],
    &TsengSetBank_ET4000,
    &TsengGetBank_ET4000,
    TsengModeSet2a,
    60,                                          /*JWK10*/
  },                                             /*JWK10*/
  {
    VGAMODE,
    &ChipInfoHeader[GRAPHICS_640x480x16],
    &TsengSetBank_ET4000,
    &TsengGetBank_ET4000,
    TsengModeSet2a,
    TSENG_REFRESH_ANY,                           /*JWK10*/
  },                                             /*JWK10*/
                                                 /*JWK10*/
  {                                              /*JWK10*/
    0x2e,                                        /*JWK10*/
    &ChipInfoHeader[GRAPHICS_640x480x256],       /*JWK10*/
    &TsengSetBank_ET4000,                        /*JWK10*/
    &TsengGetBank_ET4000,                        /*JWK10*/
    TsengModeSet2a,                              /*JWK10*/
    72,                                          /*JWK10*/
  },                                             /*JWK10*/
  {                                              /*JWK10*/
    0x2e,                                        /*JWK10*/
    &ChipInfoHeader[GRAPHICS_640x480x256],       /*JWK10*/
    &TsengSetBank_ET4000,                        /*JWK10*/
    &TsengGetBank_ET4000,                        /*JWK10*/
    TsengModeSet2a,                              /*JWK10*/
    60,                                          /*JWK10*/
  },                                             /*JWK10*/
  {                                              /*JWK10*/
    0x2e,                                        /*JWK10*/
    &ChipInfoHeader[GRAPHICS_640x480x256],       /*JWK10*/
    &TsengSetBank_ET4000,                        /*JWK10*/
    &TsengGetBank_ET4000,                        /*JWK10*/
    TsengModeSet2a,                              /*JWK10*/
    TSENG_REFRESH_ANY,                           /*JWK10*/
  },                                             /*JWK10*/
                                                 /*JWK10*/
//{                                              /*JWK10*/
//  0x2e,                                        /*JWK10*/
//  &ChipInfoHeader[GRAPHICS_640x480x32K],       /*JWK10*/
//  &TsengSetBank_ET4000,                        /*JWK10*/
//  &TsengGetBank_ET4000,                        /*JWK10*/
//  TsengModeSet2b,                              /*JWK10*/
//  72,                                          /*JWK10*/
//},                                             /*JWK10*/
//{                                              /*JWK10*/
//  0x2e,                                        /*JWK10*/
//  &ChipInfoHeader[GRAPHICS_640x480x32K],       /*JWK10*/
//  &TsengSetBank_ET4000,                        /*JWK10*/
//  &TsengGetBank_ET4000,                        /*JWK10*/
//  TsengModeSet2b,                              /*JWK10*/
//  60,                                          /*JWK10*/
//},                                             /*JWK10*/
                                                 /*JWK10*/
  {                                              /*JWK10*/
    0x29,                                        /*JWK10*/
    &ChipInfoHeader[GRAPHICS_800x600x16],        /*JWK10*/
    &TsengSetBank_ET4000,                        /*JWK10*/
    &TsengGetBank_ET4000,                        /*JWK10*/
    TsengModeSet2a,                              /*JWK10*/
    72,                                          /*JWK10*/
  },                                             /*JWK10*/
  {                                              /*JWK10*/
    0x29,                                        /*JWK10*/
    &ChipInfoHeader[GRAPHICS_800x600x16],        /*JWK10*/
    &TsengSetBank_ET4000,                        /*JWK10*/
    &TsengGetBank_ET4000,                        /*JWK10*/
    TsengModeSet2a,                              /*JWK10*/
    60,                                          /*JWK10*/
  },                                             /*JWK10*/
  {                                              /*JWK10*/
    0x29,                                        /*JWK10*/
    &ChipInfoHeader[GRAPHICS_800x600x16],        /*JWK10*/
    &TsengSetBank_ET4000,                        /*JWK10*/
    &TsengGetBank_ET4000,                        /*JWK10*/
    TsengModeSet2a,                              /*JWK10*/
    56,                                          /*JWK10*/
  },                                             /*JWK10*/
  {                                              /*JWK10*/
    0x29,                                        /*JWK10*/
    &ChipInfoHeader[GRAPHICS_800x600x16],        /*JWK10*/
    &TsengSetBank_ET4000,                        /*JWK10*/
    &TsengGetBank_ET4000,                        /*JWK10*/
    TsengModeSet2a,                              /*JWK10*/
    TSENG_REFRESH_ANY,                           /*JWK10*/
  },                                             /*JWK10*/
                                                 /*JWK10*/
  {                                              /*JWK10*/
    0x30,                                        /*JWK10*/
    &ChipInfoHeader[GRAPHICS_800x600x256],       /*JWK10*/
    &TsengSetBank_ET4000,                        /*JWK10*/
    &TsengGetBank_ET4000,                        /*JWK10*/
    TsengModeSet2a,                              /*JWK10*/
    72,                                          /*JWK10*/
  },                                             /*JWK10*/
  {                                              /*JWK10*/
    0x30,                                        /*JWK10*/
    &ChipInfoHeader[GRAPHICS_800x600x256],       /*JWK10*/
    &TsengSetBank_ET4000,                        /*JWK10*/
    &TsengGetBank_ET4000,                        /*JWK10*/
    TsengModeSet2a,                              /*JWK10*/
    60,                                          /*JWK10*/
  },                                             /*JWK10*/
  {                                              /*JWK10*/
    0x30,                                        /*JWK10*/
    &ChipInfoHeader[GRAPHICS_800x600x256],       /*JWK10*/
    &TsengSetBank_ET4000,                        /*JWK10*/
    &TsengGetBank_ET4000,                        /*JWK10*/
    TsengModeSet2a,                              /*JWK10*/
    56,                                          /*JWK10*/
  },                                             /*JWK10*/
  {                                              /*JWK10*/
    0x30,                                        /*JWK10*/
    &ChipInfoHeader[GRAPHICS_800x600x256],       /*JWK10*/
    &TsengSetBank_ET4000,                        /*JWK10*/
    &TsengGetBank_ET4000,                        /*JWK10*/
    TsengModeSet2a,                              /*JWK10*/
    TSENG_REFRESH_ANY,                           /*JWK10*/
  },                                             /*JWK10*/
                                                 /*JWK10*/
  {                                              /*JWK10*/
    0x37,                                        /*JWK10*/
    &ChipInfoHeader[GRAPHICS_1024x768x16],       /*JWK10*/
    &TsengSetBank_ET4000,                        /*JWK10*/
    &TsengGetBank_ET4000,                        /*JWK10*/
    TsengModeSet2a,                              /*JWK10*/
    70,                                          /*JWK10*/
  },                                             /*JWK10*/
  {                                              /*JWK10*/
    0x37,                                        /*JWK10*/
    &ChipInfoHeader[GRAPHICS_1024x768x16],       /*JWK10*/
    &TsengSetBank_ET4000,                        /*JWK10*/
    &TsengGetBank_ET4000,                        /*JWK10*/
    TsengModeSet2a,                              /*JWK10*/
    60,                                          /*JWK10*/
  },                                             /*JWK10*/
  {                                              /*JWK10*/
    0x37,                                        /*JWK10*/
    &ChipInfoHeader[GRAPHICS_1024x768x16],       /*JWK10*/
    &TsengSetBank_ET4000,                        /*JWK10*/
    &TsengGetBank_ET4000,                        /*JWK10*/
    TsengModeSet2a,                              /*JWK10*/
    43,                                          /*JWK10*/
  },                                             /*JWK10*/
  {                                              /*JWK10*/
    0x37,                                        /*JWK10*/
    &ChipInfoHeader[GRAPHICS_1024x768x16],       /*JWK10*/
    &TsengSetBank_ET4000,                        /*JWK10*/
    &TsengGetBank_ET4000,                        /*JWK10*/
    TsengModeSet2a,                              /*JWK10*/
    TSENG_REFRESH_ANY,                           /*JWK10*/
  },                                             /*JWK10*/
  {                                              /*JWK10*/
    0x38,                                        /*JWK10*/
    &ChipInfoHeader[GRAPHICS_1024x768x256],      /*JWK10*/
    &TsengSetBank_ET4000,                        /*JWK10*/
    &TsengGetBank_ET4000,                        /*JWK10*/
    TsengModeSet2a,                              /*JWK10*/
    TSENG_REFRESH_UNKNOWN,                       /*JWK10*/
  },
                                                 /*JWK10*/
  {                                              /*JWK10*/
    0x38,                                        /*JWK10*/
    &ChipInfoHeader[GRAPHICS_1024x768x256],      /*JWK10*/
    &TsengSetBank_ET4000,                        /*JWK10*/
    &TsengGetBank_ET4000,                        /*JWK10*/
    TsengModeSet2a,                              /*JWK10*/
    70,                                          /*JWK10*/
  },                                             /*JWK10*/
  {                                              /*JWK10*/
    0x38,                                        /*JWK10*/
    &ChipInfoHeader[GRAPHICS_1024x768x256],      /*JWK10*/
    &TsengSetBank_ET4000,                        /*JWK10*/
    &TsengGetBank_ET4000,                        /*JWK10*/
    TsengModeSet2a,                              /*JWK10*/
    60,                                          /*JWK10*/
  },                                             /*JWK10*/
  {                                              /*JWK10*/
    0x38,                                        /*JWK10*/
    &ChipInfoHeader[GRAPHICS_1024x768x256],      /*JWK10*/
    &TsengSetBank_ET4000,                        /*JWK10*/
    &TsengGetBank_ET4000,                        /*JWK10*/
    TsengModeSet2a,                              /*JWK10*/
    43,                                          /*JWK10*/
  },
  {                                              /*JWK10*/
    0x38,                                        /*JWK10*/
    &ChipInfoHeader[GRAPHICS_1024x768x256],      /*JWK10*/
    &TsengSetBank_ET4000,                        /*JWK10*/
    &TsengGetBank_ET4000,                        /*JWK10*/
    TsengModeSet2a,                              /*JWK10*/
    TSENG_REFRESH_ANY,                           /*JWK10*/
  },
  {
    0x3d,
    &ChipInfoHeader[GRAPHICS_1280x1024x16],
    &TsengSetBank_ET4000,
    &TsengGetBank_ET4000,
    TsengModeSet2a,
    TSENG_REFRESH_UNKNOWN,                       /*JWK10*/
  },

  {
    0x3d,
    &ChipInfoHeader[GRAPHICS_1280x1024x16],
    &TsengSetBank_ET4000,
    &TsengGetBank_ET4000,
    TsengModeSet2a,
    TSENG_REFRESH_ANY,                           /*JWK10*/
  },

  {
    0x01,
    &ChipInfoHeader[TEXT_40x25],
    &TsengSetBank_ET4000,
    &TsengGetBank_ET4000,
    TsengModeSet2a,
    0,
  },

  {
    0x03,
    &ChipInfoHeader[TEXT_80x25],
    &TsengSetBank_ET4000,
    &TsengGetBank_ET4000,
    TsengModeSet2a,
    0,
  },

  {
    0x23,
    &ChipInfoHeader[TEXT_132x25],
    &TsengSetBank_ET4000,
    &TsengGetBank_ET4000,
    TsengModeSet2a,
    0,
  },

  {
    0x22,
    &ChipInfoHeader[TEXT_132x44],
    &TsengSetBank_ET4000,
    &TsengGetBank_ET4000,
    TsengModeSet2a,
    0,
  },
};


USHORT usSizeTsengChipSetET4000 = sizeof(TsengChipSetET4000)/sizeof(CHIPINFO);


REGDATA TsengModeSet3a [] =
{
  { PMICMD_OUTB,  MISCOUTPUTREG_WRITE, NONE,   0x00, 0x00, WRITEONLY_DATA, &MiscOutRegData }, /*          */ /*JWK06*/
  { PMICMD_BOUTB, TSENG_SETBANK, TSENG_SETBANK, 1, 0, WRITEONLY_DATA, b_0 },
  { PMICMD_BOUTB, TSENG_SETBANK_W32, TSENG_SETBANK_W32, 1, 0, WRITEONLY_DATA, b_0 },
// jwk04 must write crtc35 before crtc11 because of lock set by writing crtc11 (code in svga.c unlocking)
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 8, 0x30, READWRITE_DATA, &CRTRegData[0x30] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 1, 0x3f, READWRITE_DATA, &CRTRegData[0x3f] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x19, 0, READWRITE_DATA, &CRTRegData[0x00] },
  { PMICMD_BOUTB, ATC_INDEXPORT, ATC_DATAPORT, 0x15, 0, READWRITE_DATA, &ATCRegData[0x00] },
  { PMICMD_BOUTB, ATC_INDEXPORT, ATC_DATAPORT, 2, 0x16, READWRITE_DATA, &ATCRegData[0x16] },
  { PMICMD_BOUTB, GDC_INDEXPORT, GDC_DATAPORT, 9, 0x00, READWRITE_DATA, &GDCRegData[0x00] },
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 5, 0, READWRITE_DATA, &SEQRegData[0] },   /*JWK04*/
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 2, 6, READWRITE_DATA, &SEQRegData[6] },   /*JWK04*/
  { PMICMD_OUTW,  SEQ_INDEXPORT, NONE, NONE, 0, WRITEONLY_DATA, &bEndSEQReset[0] },
  { PMICMD_BOUTB, TSENG_BASE_INDEX, TSENG_BASE_DATA, 0x10, 0xE0, READWRITE_DATA, &CRTCBRegData[0xE0] },
  { PMICMD_BOUTB, TSENG_BASE_INDEX, TSENG_BASE_DATA, 0x8, 0xF0, READWRITE_DATA, &IMARegData[0xF0] },

                                            /*            MC Pro start */
  { PMICMD_INB,   MC_SETUPREG, NONE, NONE, 1, NONE, NULL },
  { PMICMD_OUTB,  MC_SETUPREG, NONE, NONE, 0, WRITEONLY_DATA, NULL },
  { PMICMD_RMWBI,  MC_POS3REG, MC_POS3REG, 0, 0, 0 },
  { PMICMD_OUTB,  MC_SETUPREG, NONE, NONE, 1, WRITEREG_DATA},
                                            /*            MC Pro end   */
  { PMICMD_NONE },
};

/*JWK10 add refresh entries.  for compatability, high to low */

/**
 ** JWK26 This list is order dependant.
 **
 **       The UNKNOWN refresh rates must be first so that we can
 **       collect the register settings before changing refresh rates,
 **       which may have been set by a manufactureres utility.  These
 **       entries are ignored if the MONITOR or INIT parameter flags are set.
 **
 **       The ANY refresh rates are used as a wild card, and cause a mode
 **       set attempt only if not previously successfull for a given
 **       resolution and color depth, at any refresh rate.  This is for
 **       adapters that do not fit our model for setting refresh rates.
 **       We really only allow refresh rates that are published by Tseng,
 **       and the BIOS supports the Get/Set refresh rate.  This is
 **       needed for BIOS's which do not support get/set refresh rates,
 **       but does support 1280 resolution (DELL VESA).
 */

CHIPINFO TsengChipSetW32[] =                      /*JWK10 for W32 */
{
  {
    0x12,
    &ChipInfoHeader[GRAPHICS_640x480x16],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    0,
  },
  {
    0x2e,
    &ChipInfoHeader[GRAPHICS_640x480x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_UNKNOWN,
  },
  {
    0x2e, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_640x480x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_UNKNOWN,
  },
  {
    0x2e, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_640x480x16M],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_UNKNOWN,
  },
  {
    0x30,
    &ChipInfoHeader[GRAPHICS_800x600x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_UNKNOWN,
  },
  {
    0x30, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_800x600x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_UNKNOWN,
  },
  {
    0x38,
    &ChipInfoHeader[GRAPHICS_1024x768x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_UNKNOWN,
  },
  {
    0x38,
    &ChipInfoHeader[GRAPHICS_1024x768x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_UNKNOWN,
  },
  {
    0x2e,
    &ChipInfoHeader[GRAPHICS_640x480x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    72,
  },
  {
    0x2e,
    &ChipInfoHeader[GRAPHICS_640x480x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    60,
  },
  {
    0x2e,
    &ChipInfoHeader[GRAPHICS_640x480x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_ANY,
  },
  {
    0x2e, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_640x480x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    72,
  },
  {
    0x2e, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_640x480x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    60,
  },
  {
    0x2e, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_640x480x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_ANY,
  },
  {
    0x2e, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_640x480x16M],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    72,
  },
  {
    0x2e, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_640x480x16M],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    60,
  },
  {
    0x2e, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_640x480x16M],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_ANY,
  },
//{
//  0x29,
//  &ChipInfoHeader[GRAPHICS_800x600x16],
//  &TsengSetBank_ET4000W32x,
//  &TsengGetBank_ET4000W32x,
//  TsengModeSet3a,
//  0,
//},
  {
    0x30,
    &ChipInfoHeader[GRAPHICS_800x600x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    72,
  },
  {
    0x30,
    &ChipInfoHeader[GRAPHICS_800x600x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    60,
  },
  {
    0x30,
    &ChipInfoHeader[GRAPHICS_800x600x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    56,
  },
  {
    0x30,
    &ChipInfoHeader[GRAPHICS_800x600x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_ANY,
  },
  {
    0x30, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_800x600x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    72,
  },
  {
    0x30, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_800x600x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    60,
  },
  {
    0x30, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_800x600x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    56,
  },
  {
    0x30, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_800x600x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_ANY,
  },
//{
//  0x37,
//  &ChipInfoHeader[GRAPHICS_1024x768x16],
//  &TsengSetBank_ET4000W32x,
//  &TsengGetBank_ET4000W32x,
//  TsengModeSet3a,
//  0,
//},
  {
    0x38,
    &ChipInfoHeader[GRAPHICS_1024x768x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    75,
  },
  {
    0x38,
    &ChipInfoHeader[GRAPHICS_1024x768x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    70,
  },
  {
    0x38,
    &ChipInfoHeader[GRAPHICS_1024x768x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    60,
  },
  {
    0x38,
    &ChipInfoHeader[GRAPHICS_1024x768x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    43,
  },
  {
    0x38,
    &ChipInfoHeader[GRAPHICS_1024x768x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_ANY,
  },
  {
    0x38,
    &ChipInfoHeader[GRAPHICS_1024x768x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    75,
  },
  {
    0x38,
    &ChipInfoHeader[GRAPHICS_1024x768x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    70,
  },
  {
    0x38,
    &ChipInfoHeader[GRAPHICS_1024x768x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    60,
  },
  {
    0x38,
    &ChipInfoHeader[GRAPHICS_1024x768x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    43,
  },
  {
    0x38,
    &ChipInfoHeader[GRAPHICS_1024x768x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_ANY,
  },
//{
//  0x3d,
//  &ChipInfoHeader[GRAPHICS_1280x1024x16],
//  &TsengSetBank_ET4000W32x,
//  &TsengGetBank_ET4000W32x,
//  TsengModeSet3a,
//  0,
//},
  {
    01,
    &ChipInfoHeader[TEXT_40x25],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    0,
  },
  {
    03,
    &ChipInfoHeader[TEXT_80x25],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    0,
  },
  {
    0x23,
    &ChipInfoHeader[TEXT_132x25],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    0,
  },
  {
    0x22,
    &ChipInfoHeader[TEXT_132x44],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    0,
  },

};

USHORT usSizeTsengChipSetW32 = sizeof(TsengChipSetW32)/sizeof(CHIPINFO);


/**
 ** JWK26 This list is order dependant.
 **
 **       The UNKNOWN refresh rates must be first so that we can
 **       collect the register settings before changing refresh rates,
 **       which may have been set by a manufactureres utility.  These
 **       entries are ignored if the MONITOR or INIT parameter flags are set.
 **
 **       The ANY refresh rates are used as a wild card, and cause a mode
 **       set attempt only if not previously successfull for a given
 **       resolution and color depth, at any refresh rate.  This is for
 **       adapters that do not fit our model for setting refresh rates.
 **       We really only allow refresh rates that are published by Tseng,
 **       and the BIOS supports the Get/Set refresh rate.  This is
 **       needed for BIOS's which do not support get/set refresh rates,
 **       but does support 1280 resolution (DELL VESA).
 */

CHIPINFO TsengChipSetW32i[] =                      /* for W32i */
{
  {
    0x12,
    &ChipInfoHeader[GRAPHICS_640x480x16],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    0,
  },
  {
    0x2e,
    &ChipInfoHeader[GRAPHICS_640x480x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_UNKNOWN,
  },
  {
    0x2e, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_640x480x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_UNKNOWN,
  },
  {
    0x2e, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_640x480x16M],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_UNKNOWN,
  },
  {
    0x30,
    &ChipInfoHeader[GRAPHICS_800x600x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_UNKNOWN,
  },
  {
    0x30, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_800x600x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_UNKNOWN,
  },
  {
    0x38,
    &ChipInfoHeader[GRAPHICS_1024x768x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_UNKNOWN,
  },
  {
    0x38,
    &ChipInfoHeader[GRAPHICS_1024x768x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_UNKNOWN,
  },
  {
    0x3f,
    &ChipInfoHeader[GRAPHICS_1280x1024x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_UNKNOWN,
  },
  {
    0x2e,
    &ChipInfoHeader[GRAPHICS_640x480x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    90,
  },
  {
    0x2e,
    &ChipInfoHeader[GRAPHICS_640x480x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    75,
  },
  {
    0x2e,
    &ChipInfoHeader[GRAPHICS_640x480x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    72,
  },
  {
    0x2e,
    &ChipInfoHeader[GRAPHICS_640x480x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    60,
  },
  {
    0x2e,
    &ChipInfoHeader[GRAPHICS_640x480x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_ANY,
  },
  {
    0x2e, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_640x480x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    90,
  },
  {
    0x2e, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_640x480x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    75,
  },
  {
    0x2e, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_640x480x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    72,
  },
  {
    0x2e, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_640x480x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    60,
  },
  {
    0x2e, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_640x480x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_ANY,
  },
  {
    0x2e, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_640x480x16M],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    90,
  },
  {
    0x2e, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_640x480x16M],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    75,
  },
  {
    0x2e, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_640x480x16M],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    72,
  },
  {
    0x2e, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_640x480x16M],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    60,
  },
  {
    0x2e, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_640x480x16M],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_ANY,
  },
//{
//  0x29,
//  &ChipInfoHeader[GRAPHICS_800x600x16],
//  &TsengSetBank_ET4000W32x,
//  &TsengGetBank_ET4000W32x,
//  TsengModeSet3a,
//  0,
//},
  {
    0x30,
    &ChipInfoHeader[GRAPHICS_800x600x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    90,
  },
  {
    0x30,
    &ChipInfoHeader[GRAPHICS_800x600x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    75,
  },
  {
    0x30,
    &ChipInfoHeader[GRAPHICS_800x600x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    72,
  },
  {
    0x30,
    &ChipInfoHeader[GRAPHICS_800x600x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    60,
  },
  {
    0x30,
    &ChipInfoHeader[GRAPHICS_800x600x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    56,
  },
  {
    0x30,
    &ChipInfoHeader[GRAPHICS_800x600x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_ANY,
  },
  {
    0x30, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_800x600x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    90,
  },
  {
    0x30, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_800x600x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    75,
  },
  {
    0x30, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_800x600x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    72,
  },
  {
    0x30, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_800x600x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    60,
  },
  {
    0x30, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_800x600x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    56,
  },
  {
    0x30, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_800x600x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_ANY,
  },
//{
//  0x37,
//  &ChipInfoHeader[GRAPHICS_1024x768x16],
//  &TsengSetBank_ET4000W32x,
//  &TsengGetBank_ET4000W32x,
//  TsengModeSet3a,
//  0,
//},
  {
    0x38,
    &ChipInfoHeader[GRAPHICS_1024x768x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    75,
  },
  {
    0x38,
    &ChipInfoHeader[GRAPHICS_1024x768x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    70,
  },
  {
    0x38,
    &ChipInfoHeader[GRAPHICS_1024x768x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    60,
  },
  {
    0x38,
    &ChipInfoHeader[GRAPHICS_1024x768x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    43,
  },
  {
    0x38,
    &ChipInfoHeader[GRAPHICS_1024x768x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_ANY,
  },
  {
    0x38,
    &ChipInfoHeader[GRAPHICS_1024x768x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    75,
  },
  {
    0x38,
    &ChipInfoHeader[GRAPHICS_1024x768x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    70,
  },
  {
    0x38,
    &ChipInfoHeader[GRAPHICS_1024x768x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    60,
  },
  {
    0x38,
    &ChipInfoHeader[GRAPHICS_1024x768x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    43,
  },
  {
    0x38,
    &ChipInfoHeader[GRAPHICS_1024x768x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_ANY,
  },
//{
//  0x3d,
//  &ChipInfoHeader[GRAPHICS_1280x1024x16],
//  &TsengSetBank_ET4000W32x,
//  &TsengGetBank_ET4000W32x,
//  TsengModeSet3a,
//  0,
//},
  {
    0x3f,
    &ChipInfoHeader[GRAPHICS_1280x1024x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    75,
  },
  {
    0x3f,
    &ChipInfoHeader[GRAPHICS_1280x1024x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    70,
  },
  {
    0x3f,
    &ChipInfoHeader[GRAPHICS_1280x1024x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    60,
  },
  {
    0x3f,
    &ChipInfoHeader[GRAPHICS_1280x1024x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    43,
  },
  {
    0x3f,
    &ChipInfoHeader[GRAPHICS_1280x1024x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_ANY,
  },
  {
    01,
    &ChipInfoHeader[TEXT_40x25],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    0,
  },
  {
    03,
    &ChipInfoHeader[TEXT_80x25],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    0,
  },
  {
    0x23,
    &ChipInfoHeader[TEXT_132x25],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    0,
  },
  {
    0x22,
    &ChipInfoHeader[TEXT_132x44],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    0,
  },

};

USHORT usSizeTsengChipSetW32i = sizeof(TsengChipSetW32i)/sizeof(CHIPINFO);


/**
 ** JWK26 This list is order dependant.
 **
 **       The UNKNOWN refresh rates must be first so that we can
 **       collect the register settings before changing refresh rates,
 **       which may have been set by a manufactureres utility.  These
 **       entries are ignored if the MONITOR or INIT parameter flags are set.
 **
 **       The ANY refresh rates are used as a wild card, and cause a mode
 **       set attempt only if not previously successfull for a given
 **       resolution and color depth, at any refresh rate.  This is for
 **       adapters that do not fit our model for setting refresh rates.
 **       We really only allow refresh rates that are published by Tseng,
 **       and the BIOS supports the Get/Set refresh rate.  This is
 **       needed for BIOS's which do not support get/set refresh rates,
 **       but does support 1280 resolution (DELL VESA).
 */

CHIPINFO TsengChipSetW32p[] =
{
  {
    0x12,
    &ChipInfoHeader[GRAPHICS_640x480x16],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    0,
  },
  {
    0x2e,
    &ChipInfoHeader[GRAPHICS_640x480x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_UNKNOWN,
  },
  {
    0x2e, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_640x480x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_UNKNOWN,
  },
  {
    0x2e, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_640x480x16M],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_UNKNOWN,
  },
  {
    0x30,
    &ChipInfoHeader[GRAPHICS_800x600x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_UNKNOWN,
  },
  {
    0x30, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_800x600x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_UNKNOWN,
  },
  {
    0x30,  /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_800x600x16M],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_UNKNOWN,
  },
  {
    0x38,
    &ChipInfoHeader[GRAPHICS_1024x768x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_UNKNOWN,
  },
  {
    0x38,
    &ChipInfoHeader[GRAPHICS_1024x768x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_UNKNOWN,
  },
  {
    0x3f,
    &ChipInfoHeader[GRAPHICS_1280x1024x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_UNKNOWN,
  },
  {
    0x2e,
    &ChipInfoHeader[GRAPHICS_640x480x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    90,
  },
  {
    0x2e,
    &ChipInfoHeader[GRAPHICS_640x480x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    75,
  },
  {
    0x2e,
    &ChipInfoHeader[GRAPHICS_640x480x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    72,
  },
  {
    0x2e,
    &ChipInfoHeader[GRAPHICS_640x480x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    60,
  },
  {
    0x2e,
    &ChipInfoHeader[GRAPHICS_640x480x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_ANY,
  },
  {
    0x2e, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_640x480x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    90,
  },
  {
    0x2e, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_640x480x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    75,
  },
  {
    0x2e, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_640x480x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    72,
  },
  {
    0x2e, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_640x480x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    60,
  },
  {
    0x2e, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_640x480x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_ANY,
  },
  {
    0x2e, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_640x480x16M],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    90,
  },
  {
    0x2e, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_640x480x16M],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    75,
  },
  {
    0x2e, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_640x480x16M],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    72,
  },
  {
    0x2e, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_640x480x16M],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    60,
  },
  {
    0x2e, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_640x480x16M],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_ANY,
  },
//{
//  0x29,
//  &ChipInfoHeader[GRAPHICS_800x600x16],
//  &TsengSetBank_ET4000W32x,
//  &TsengGetBank_ET4000W32x,
//  TsengModeSet3a,
//  0,
//},
  {
    0x30,
    &ChipInfoHeader[GRAPHICS_800x600x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    90,
  },
  {
    0x30,
    &ChipInfoHeader[GRAPHICS_800x600x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    75,
  },
  {
    0x30,
    &ChipInfoHeader[GRAPHICS_800x600x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    72,
  },
  {
    0x30,
    &ChipInfoHeader[GRAPHICS_800x600x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    60,
  },
  {
    0x30,
    &ChipInfoHeader[GRAPHICS_800x600x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    56,
  },
  {
    0x30,
    &ChipInfoHeader[GRAPHICS_800x600x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_ANY,
  },
  {
    0x30, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_800x600x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    90,
  },
  {
    0x30, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_800x600x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    75,
  },
  {
    0x30, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_800x600x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    72,
  },
  {
    0x30, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_800x600x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    60,
  },
  {
    0x30, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_800x600x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    56,
  },
  {
    0x30, /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_800x600x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_ANY,
  },
  {
    0x30,  /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_800x600x16M],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    90,
  },
  {
    0x30,  /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_800x600x16M],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    75,
  },
  {
    0x30,  /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_800x600x16M],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    72,
  },
  {
    0x30,  /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_800x600x16M],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    60,
  },
  {
    0x30,  /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_800x600x16M],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    56,
  },
  {
    0x30,  /* bpp sets hicolor */
    &ChipInfoHeader[GRAPHICS_800x600x16M],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_ANY,
  },
//{
//  0x37,
//  &ChipInfoHeader[GRAPHICS_1024x768x16],
//  &TsengSetBank_ET4000W32x,
//  &TsengGetBank_ET4000W32x,
//  TsengModeSet3a,
//  0,
//},
  {
    0x38,
    &ChipInfoHeader[GRAPHICS_1024x768x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    75,
  },
  {
    0x38,
    &ChipInfoHeader[GRAPHICS_1024x768x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    70,
  },
  {
    0x38,
    &ChipInfoHeader[GRAPHICS_1024x768x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    60,
  },
  {
    0x38,
    &ChipInfoHeader[GRAPHICS_1024x768x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    43,
  },
  {
    0x38,
    &ChipInfoHeader[GRAPHICS_1024x768x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_ANY,
  },
  {
    0x38,
    &ChipInfoHeader[GRAPHICS_1024x768x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    75,
  },
  {
    0x38,
    &ChipInfoHeader[GRAPHICS_1024x768x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    70,
  },
  {
    0x38,
    &ChipInfoHeader[GRAPHICS_1024x768x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    60,
  },
  {
    0x38,
    &ChipInfoHeader[GRAPHICS_1024x768x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    43,
  },
  {
    0x38,
    &ChipInfoHeader[GRAPHICS_1024x768x64K],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_ANY,
  },
//{
//  0x3d,
//  &ChipInfoHeader[GRAPHICS_1280x1024x16],
//  &TsengSetBank_ET4000W32x,
//  &TsengGetBank_ET4000W32x,
//  TsengModeSet3a,
//  0,
//},
  {
    0x3f,
    &ChipInfoHeader[GRAPHICS_1280x1024x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    75,
  },
  {
    0x3f,
    &ChipInfoHeader[GRAPHICS_1280x1024x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    70,
  },
  {
    0x3f,
    &ChipInfoHeader[GRAPHICS_1280x1024x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    60,
  },
  {
    0x3f,
    &ChipInfoHeader[GRAPHICS_1280x1024x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    43,
  },
  {
    0x3f,
    &ChipInfoHeader[GRAPHICS_1280x1024x256],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    TSENG_REFRESH_ANY,
  },

  {
    01,
    &ChipInfoHeader[TEXT_40x25],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    0,
  },

  {
    03,
    &ChipInfoHeader[TEXT_80x25],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    0,
  },

  {
    0x23,
    &ChipInfoHeader[TEXT_132x25],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    0,
  },

  {
    0x22,
    &ChipInfoHeader[TEXT_132x44],
    &TsengSetBank_ET4000W32x,
    &TsengGetBank_ET4000W32x,
    TsengModeSet3a,
    0,
  },

};

USHORT usSizeTsengChipSetW32p = sizeof(TsengChipSetW32p)/sizeof(CHIPINFO);




VOID nextpointer(UCHAR **pp, USHORT *pBank)  /* it works HARD but it works */
{
    USHORT offset,segment,bank;
    UCHAR  *ptr = *pp;
    USHORT rc = 0;

    offset = OFFSETOF(ptr);
    segment = SEGMENTOF(ptr);

    if (offset == 0xffff)
    {
         bank = *pBank;
         TsengSetBank(++bank);
         offset = 0;
        *pBank  = bank;
    }
    else
    {
        offset++;
    }

    ptr = MAKEP(segment,offset);
     *pp = ptr;

    return;
}

VOID TsengSetBank(USHORT Bank)
{
  UCHAR bReadBank, bWriteBank, bExtBank;

  bWriteBank = (UCHAR) (Bank & 0x0f);           /* set up write bank       */

  bReadBank =(UCHAR)( bWriteBank                        /* set up read bank        */
              << (3 + (sSVGA.ChipType >= TSENG_ET4000_CHIP)));

  outp(0x3cd, (bReadBank | bWriteBank) );       /* write it out            */

  if (sSVGA.ChipType >= TSENG_ET4000W32_CHIP)
  {
      bExtBank =  (UCHAR)(Bank & 0x30);
      bExtBank |= (UCHAR)(bExtBank >> 4);        /* set read = write */
      outp(0x3cb, (UCHAR)(bExtBank));            /* write it out     */
  }

  return;
}

/***************************************************************************
 *
 * FUNCTION NAME = TsengGetBank()
 *
 * DESCRIPTION   = Get Tseng bank register
 *
 * INPUT         = none
 *
 * OUTPUT        = none
 *
 * RETURN-NORMAL = write bank value
 * RETURN-ERROR  = n/a
 *
 ****************************************************************************/

USHORT TsengGetBank(VOID)
{

  USHORT SegSelect;
  USHORT SegSelect2;



  SegSelect =  inp(0x3cd)
               & ((sSVGA.ChipType >= TSENG_ET4000_CHIP)
                 ? 0x0f
                 : 0x07);

  if (sSVGA.ChipType >= TSENG_ET4000W32_CHIP)
  {
      SegSelect2 = inp(0x3cb) & 0x03;

      return ( (SegSelect2 << 4) | SegSelect );

  }
  else
  {
      return (SegSelect);
  }

}

#define MAX_SCANLINE_BYTES 1280*4

CHAR ScanLineData[MAX_SCANLINE_BYTES];
char trace1 =0xa0;
char trace2 =0xa0;
char trace3 =0xff;
char trace4 =0xff;


VOID ShowYourStuff( PCHIPINFO ChipInfo,  INT Adapter,  INT Chip )
{


  UCHAR  red, green, blue,tmplo, tmphi;
  USHORT maxpixels;
  USHORT offset,segment;
  USHORT maxscanlinebytes,scanlineoffset;
  USHORT scanline,pixel,newbank,index;
  PCHIPHEADER   pChipHdr = ChipInfo->pChipHdr;
  UCHAR  far * pVRAMBuffer = NULL;
  CHAR    inpstr[80];
  USHORT CRTC13;
  USHORT CRTC3f;


  ULONG  pPhysVRAMBuffer = pChipHdr->ulBufferAddress;


  USHORT bank = 0xffff,bytes,byte,banksave;
  ULONG ulCurrentOffset  = 0;
  USHORT BankOffset = 0;

  UCHAR  CurrentGreen  = 0x00;
  UCHAR  CurrentRed    = 0xff;
  UCHAR  CurrentBlue   = 0x00;
  UCHAR  CurrentIndex  = 0x00;
  UCHAR  CurrentGreenX = 0xff;
  UCHAR  CurrentRedX   = 0xff;
  UCHAR  CurrentBlueX  = 0x00;

  CHAR *pScanLineData = &ScanLineData[0];


  if (  (Adapter != TSENG_ADAPTER)
  // || (pChipHdr->bBitsPerPixel <= 4)
  // || (!(pChipHdr->bModeAttributes & GRAPHICS_MODEATTR))
     || (!(sAdapter.RefreshTable))  )
  {
      return;
  }



  /* only display refresh rates available on the selected monitor */

//jwk26  if (pChipHdr->bModeAttributes & GRAPHICS_MODEATTR)
//jwk26  {
//jwk26     i = 0;
//jwk26     fSuccess = FALSE;
//jwk26     while((i < MAX_REFRESH_MODES) && sAdapter.RefreshTable[i].usYResolution)
//jwk26     {
//jwk26         if (pChipHdr->usXResolution == sAdapter.RefreshTable[i].usXResolution)
//jwk26         {
//jwk26             if (ChipInfo->Refresh <= sAdapter.RefreshTable[i].DefaultVRefresh )
//jwk26             {
//jwk26                 fSuccess = TRUE;
//jwk26                 i = MAX_REFRESH_MODES;
//jwk26             }
//jwk26         }
//jwk26         i++;
//jwk26     }
//jwk26     if (!fSuccess) return;
//jwk26  }

  /* calculate some things just once */

  maxpixels = pChipHdr->usXResolution;
  maxscanlinebytes = (maxpixels/8) * pChipHdr->bBitsPerPixel;

  /* correction for VESA 112 (640 x 480 x 16m) SOMETIMES setting 256 instead of 240 */

//if ((pChipHdr->bBitsPerPixel == 24)
//    && (pChipHdr->usXResolution == 640) )
//{
      outp(CRT_INDEXPORT, 0x13);
      CRTC13 = (USHORT)(inp(CRT_DATAPORT));
      outp(CRT_INDEXPORT, 0x3f);
      CRTC3f = ((USHORT)((inp(CRT_DATAPORT) & 0x80)) << 1);

      maxscanlinebytes = (CRTC13 + CRTC3f) * 8;
//}


  offset = (USHORT)(pPhysVRAMBuffer & 0x0000ffff);
  segment = (USHORT)(((USHORT)((pPhysVRAMBuffer >> 16) & 0x0000000f)) << 12);
  pVRAMBuffer = MAKEP(segment,offset);

  if (!(pChipHdr->bModeAttributes & GRAPHICS_MODEATTR))
  {
     scrnID(ChipInfo, Adapter, Chip, maxscanlinebytes);   /*JWK28*/
     if (fDebug)
     {
        gets(inpstr);
     }
     return;
  }

  if (  (Adapter != TSENG_ADAPTER)
     || (pChipHdr->bBitsPerPixel <= 4)
     || (!(pChipHdr->bModeAttributes & GRAPHICS_MODEATTR))
     || (!(sAdapter.RefreshTable))  )
  {
      return;
  }

     /* draw scanline by scanline */

     for (scanline = 0; scanline < pChipHdr->usYResolution; scanline++, ulCurrentOffset += (ULONG)maxscanlinebytes)
     {
         if (scanline == 50)
         {
             banksave = TsengGetBank();
             scrnID(ChipInfo, Adapter, Chip, maxscanlinebytes);   /*JWK28*/
             TsengSetBank(banksave);
         }


         CurrentRed    =0xff;
         CurrentBlue   =0x00;
         CurrentIndex  =0x00;

         /* calculate the color data for each pixel */

         for (pixel = 0, scanlineoffset=0; pixel < maxpixels; pixel++)
         {


         red   = 0;
         green = 0;
         blue  = 0;
         index = 0;

             if ( (scanline <=75)           /* red bar */
               && (scanline > 50)
               && (pixel <= 306)
               && (pixel > 50))
             {
                 red   = CurrentRed;
                 if (CurrentRed) CurrentRed--;
             }


             if ( (scanline <=341)           /* three way mixe */
               && (scanline > 85)
               && (pixel <= 306)
               && (pixel > 50))
             {
                 red   = CurrentRed;
                 if (CurrentRed) CurrentRed--;
                 green = CurrentGreen;
                 blue  = CurrentBlue;
                 if (CurrentBlue < 0xff) CurrentBlue++;
                 index = CurrentIndex;
                 if (CurrentIndex < 0xff) CurrentIndex++;
             }




             if ((scanline <= 376)      /* draw blue color bar */
               && (scanline > 351)
               && (pixel <= 306)
               && (pixel > 50))
             {
                 blue  = CurrentBlue;
                 if (CurrentBlue < 0xff) CurrentBlue++;
             }


             if ( (scanline <=341)           /* mixed */
               && (scanline > 85)
               && (pixel <=341)      /* draw green vertical */
               && (pixel > 316))
             {
                 green  = CurrentGreen;
             }

             if ( (scanline <=411)           /* greys */
               && (scanline > 386)
               && (pixel <= 306)
               && (pixel > 50))
             {
                 red   = (UCHAR)(pixel-51);
                 green = (UCHAR)(pixel-51);
                 blue  = (UCHAR)(pixel-51);
             }

             if (pChipHdr->usXResolution > 700)
             {
                 if ( (scanline <=341)           /* mix */
                   && (scanline > 85)
                   && (pixel <=376)      /* draw green/red vertical */
                   && (pixel > 351))
                 {
                     red    = CurrentRedX;
                     green  = CurrentGreen;
                 }

                 if ( (scanline <=341)           /* solid */
                   && (scanline > 85)
                   && (pixel <=411)      /* draw red vertical */
                   && (pixel > 386))
                 {
                     red  = CurrentRedX;
                 }

                 if ( (scanline <=341)           /* mix */
                   && (scanline > 85)
                   && (pixel <=446)      /* draw red/blue vertical */
                   && (pixel > 421))
                 {
                     red    = CurrentRedX;
                     blue   = CurrentBlueX;
                 }

                 if ( (scanline <=341)           /* solid */
                   && (scanline > 85)
                   && (pixel <=481)      /* draw blue vertical */
                   && (pixel > 456))
                 {
                     blue = CurrentBlueX;
                 }

                 if ( (scanline <=341)           /* mix */
                   && (scanline > 85)
                   && (pixel <=516)      /* draw blue/green vertical */
                   && (pixel > 491))
                 {
                     blue    = CurrentBlueX;
                     green   = CurrentGreenX;
                 }

                 if ( (scanline <=341)           /* solid */
                   && (scanline > 85)
                   && (pixel <=551)      /* draw green vertical */
                   && (pixel > 526))
                 {
                     green = CurrentGreenX;
                 }

             }


             switch (pChipHdr->bBitsPerPixel)
             {
                 case 32:

                         ScanLineData[scanlineoffset++] = (UCHAR)blue;
                         ScanLineData[scanlineoffset++] = (UCHAR)green;
                         ScanLineData[scanlineoffset++] = (UCHAR)red;
                         ScanLineData[scanlineoffset++] = (UCHAR)0;
                 break;

                 case 24:

                         ScanLineData[scanlineoffset++]  = (UCHAR)blue;
                         ScanLineData[scanlineoffset++]  = (UCHAR)green;
                         ScanLineData[scanlineoffset++]  = (UCHAR)red;
                 break;


                 case 16:
                         tmplo = (UCHAR)((blue >> 3) | ((green & 0xfc)<<3));
                         tmphi = (UCHAR)((red & 0xf8) | (green >> 5));
                         ScanLineData[scanlineoffset++]  = tmplo;
                         ScanLineData[scanlineoffset++]  = tmphi;
                 break;


                 case 15:
                         green = (UCHAR)(green >> 3);
                         tmplo = (UCHAR)((blue >> 3) | (green << 5));
                         tmphi = (UCHAR)(((red & 0xf8)>>1) | (green >> 3));
                         ScanLineData[scanlineoffset++]  = tmplo;
                         ScanLineData[scanlineoffset++]  = tmphi;
                 break;

                 case 8:
                         ScanLineData[scanlineoffset++]  = (UCHAR)index;
                 break;

                   default:
                         scanlineoffset++;
                 break;
             }

         }


         newbank = (USHORT) (ulCurrentOffset >> 16);
         BankOffset = (USHORT)(ulCurrentOffset & 0x0000ffff);
         if (newbank != bank)
         {
             TsengSetBank(newbank);
             bank = newbank;
         }

         if ( ((ULONG)BankOffset + (ULONG)maxscanlinebytes) > 0x0000ffff )
         {

             /* assume can cross only one segment at a time */

             bytes = (USHORT)((ULONG)0x10000 - (ULONG)BankOffset);

             for (byte = 0; byte < bytes; )
             {
                 pVRAMBuffer[BankOffset++] = ScanLineData[byte++];
             }

             TsengSetBank(++bank);
             BankOffset = 0;

             for (byte=bytes ; byte < maxscanlinebytes; )
             {
                 pVRAMBuffer[BankOffset++] = ScanLineData[byte++];
             }


         }
         else  /* copy the data without regard to bank setting */
         {
             for (pixel = 0; pixel < maxscanlinebytes; )
             {
                 pVRAMBuffer[BankOffset++] = ScanLineData[pixel++];
             }
         }


         /* adjust colors for next scanline */

         if (scanline > 85)
         {
             if (CurrentGreen < 0xff) CurrentGreen++;

             if (CurrentGreenX) CurrentGreenX--;
             if (CurrentRedX) CurrentRedX--;
             if (CurrentBlueX < 0xff) CurrentBlueX++;
         }


     }

     if (fDebug)
     {
          gets(inpstr);
     }

}







/*****************************************************************************
 *
 * FUNCTION NAME = TsengGetMonitorCableType(VOID)                 
 *
 * DESCRIPTION   = read the Tseng Feature bits (MonitorID) and return
 *                 the monitor type based on the cable connector
 *
 *               Key must be 'set' to read this data. The bits are ONLY
 *               set on POWER UP, not on reboot, not on monitor change
 *
 *               VERY UNRELIABLE
 *
 *               Some Value Points appear to not bring these bits in from the port.
 *               Some read different values between the ports so will use all bits
 *               as unique (gives 7 bit index instead of 4)
 *
 * INPUT         = NONE
 *
 *
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = index into the selected monitor table
 * RETURN-ERROR  = none
 *
 ****************************************************************************/
USHORT TsengGetMonitorCableType(VOID)   /*JWK10*/
{

USHORT InputStatusZero;  /*3c2*/
USHORT FeatureControl;   /*3ca*/
USHORT nMonIndex;


        outp(0x3bf, 0x03);  /* unlock */
        outp(0x3b8, 0xa0);
        outp(0x3d8, 0xa0);

        InputStatusZero = (inp(0x3c2) & 0x70) >> 4;         /* 3 bits low  */
        FeatureControl  = (inp(0x3ca) & 0x3c) << 1;         /* 4 bits high */

        nMonIndex = InputStatusZero | FeatureControl;

        /* for status */
        MonitorCableData = nMonIndex;

        if (TSENGDiamondW32)  /* we can assume better monitor than Value Point */  /*JWK10*/
        {                                                                          /*JWK10*/
            return (DEFAULT_TSENG_MONITOR_DIAMOND);

         //   return DiamondMonitorCableTypes[nMonIndex];

        }
        else
        {

            return (DEFAULT_TSENG_MONITOR);

         //   return TsengMonitorCableTypes[nMonIndex];
        }


}


/*****************************************************************************
 *
 * FUNCTION NAME = TsengGetVerticalRefreshRate                      JWK08 rewrite to support diamond
 *                                                                        change to nHorz
 * DESCRIPTION   = query the Tseng BIOS as to what the current refresh
 *                 rate is set at.  If the BIOS does not support the function
 *                 check the bios data area
 *
 *               This needs to be called dynamically (after actual mode set)
 *               because the tseng BIOS may have forced a lower refresh rate
 *               than requested.
 *
 * INPUT         = nHorz  (horizontal resolution)
 *               = Flags  if 1, return monitor table value
 *                        if 2, if monitor selected, return selected value, or if disabled
 *                        else determine actual rate
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = refresh rate   60, 72, 56, 43(87), 70, 75, 90  (0 if can't determine)
 * RETURN-ERROR  =  REFRESH_DISABLED if disabled or error
 *
 ****************************************************************************/

USHORT TsengGetVerticalRefreshRate(USHORT nHorz, USHORT Flags)   /*JWK08*/
{

#define MON_INDEX_640  0
#define MON_INDEX_800  1
#define MON_INDEX_1024 2
#define MON_INDEX_1280 3

static union REGS regs;
USHORT TsengFreqCode,TsengRefreshCode,fSuccess,i,j;
UCHAR far * pBiosData = (UCHAR far *)0x400000;
USHORT nMonType, nRef;


 /*
 ** convert the Horizontal resolution into the tseng BIOS resolution code
 **
 **      0=640x480
 **      1=800x600
 **      2=1024x768
 **      3=1280x1024
 */

 switch(nHorz)
 {
      case 640:
      default:
                TsengFreqCode=0;

                break;

      case 800:                         /* 800x600 */
                TsengFreqCode=1;

                break;

      case 1024:                        /* 1024x768 */
                TsengFreqCode=2;

                break;

      case 1280:                        /* 1280x1024 */
                TsengFreqCode=3;

                break;
 }

 if (Flags == TSENG_CHECK_DISABLED)  /* if monitor selected, return requested rate */
 {
     if (TSENGMonitorRefresh[4])
     {
         if (  (!TSENGMonitorRefresh[TsengFreqCode])
            || (TSENGMonitorRefresh[TsengFreqCode] == REFRESH_DISABLED)      /*JWK18*/
            || (TSENGMonitorRefresh[TsengFreqCode] == NO_REFRESH) )    /*JWK26*/
          {
             return(REFRESH_DISABLED);
         }
         else
         {
             return(TSENGMonitorRefresh[TsengFreqCode]);
         }
     }
 }

 if (Flags == 1)  /* return table info */
 {
     if ( (pMonitorTable[TSENGMonitorRefresh[4]].VRefr[TsengFreqCode])
       && (pMonitorTable[TSENGMonitorRefresh[4]].VRefr[TsengFreqCode] != REFRESH_DISABLED)
       && (pMonitorTable[TSENGMonitorRefresh[4]].VRefr[TsengFreqCode] != NO_REFRESH) )
     {
         return(pMonitorTable[TSENGMonitorRefresh[4]].VRefr[TsengFreqCode]);
     }
     else
     {
         return(REFRESH_DISABLED);
     }
 }




 /* return error if not valid entry in monitor table at given resolution */

 for ( i = 0,fSuccess=FALSE; !fSuccess && (i < usSizeMonitorTable); i++)
 {
     if ( (pMonitorTable[i].VRefr[TsengFreqCode])
       && (pMonitorTable[i].VRefr[TsengFreqCode] != 0xfe) )
     {
         fSuccess = TRUE;
     }
 }
 if (!fSuccess) return(REFRESH_DISABLED);   /*JWK18*/



 /* return error if not valid entry in refresh table */

 if (sAdapter.RefreshTable)
 {
     i = 0;
     fSuccess = FALSE;
     while((i < MAX_REFRESH_MODES) && sAdapter.RefreshTable[i].usYResolution)
     {
         if (nHorz == sAdapter.RefreshTable[i].usXResolution)
         {
             j = 0;
             while(!fSuccess && (sAdapter.RefreshTable[i].VerticalRefresh[j] != NO_REFRESH))
             {
                 if (sAdapter.RefreshTable[i].VerticalRefresh[j])

                 {
                     fSuccess = TRUE;
                 }
                 else
                 {
                     j++;
                 }
             }
             i = MAX_REFRESH_MODES;
         }
         else
         {
             i++;
         }
     }
     if (!fSuccess) return(REFRESH_DISABLED);    /*JWK18*/
 }


 /* if diamond, use this routine, otherwise use following routines */

    if (TSENGDiamondW32)
    {
        outp(0x3bf, 0x03);  /* unlock */
        outp(0x3b8, 0xa0);
        outp(0x3d8, 0xa0);

        outp(0x3d4, 0x31);
        nMonType = inp(0x3d5) & 0x0f;
        nMonType++;

        switch ( nHorz )
        {
                case 1280:
                        nRef = DiaMonTableW32[nMonType].VRefr[MON_INDEX_1280];
                        break;

                case 1024:
                        nRef = DiaMonTableW32[nMonType].VRefr[MON_INDEX_1024];
                        break;

                case 800:
                        nRef = DiaMonTableW32[nMonType].VRefr[MON_INDEX_800];
                        break;

                default:
                case 640:
                        nRef = DiaMonTableW32[nMonType].VRefr[MON_INDEX_640];
                        break;

        }
        return(nRef);

    }




    if (TSENGBIOSMonitorSupport)
    {


        regs.x.ax = 0x1201;                  /* get frequency type */
        regs.h.bl = 0xf1;
        regs.h.bh = (BYTE)TsengFreqCode;
        int86(VBIOS, &regs, &regs);

        TsengRefreshCode = regs.x.cx;

        /*
        ** return the frequncy based on the Tseng BIOS refresh code
        */

        switch(nHorz)
        {
             default:
                       return(REFRESH_DISABLED);  /*JWK26*//*error-unknown*/                                      break;
                       break;

             case 640:                        /* 640x480 */
                       switch(TsengRefreshCode)
                       {
                            case 0:
                                     return(60);
                                     break;
                            case 1:
                                     return(72);
                                     break;
                            case 2:
                                     return(75);
                                     break;
                            case 3:
                                     return(90);
                                     break;
                            default:
                                     return(TSENG_REFRESH_UNKNOWN);  /*JWK18*//*error-unknown*/                                      break;
                       }

                       break;
             case 800:                        /* 800x600 */
                       switch(TsengRefreshCode)
                       {
                            case 0:
                                     return(56);
                                     break;
                            case 1:
                                     return(60);
                                     break;
                            case 2:
                                     return(72);
                                     break;
                            case 3:
                                     return(75);
                                     break;
                            case 4:
                                     return(90);
                                     break;
                            default:
                                     return(TSENG_REFRESH_UNKNOWN);  /*JWK18*//*error-unknown*/                                      break;
                                     break;
                       }


                       break;
             case 1024:                        /* 1024x768 */
                       switch(TsengRefreshCode)
                       {
                            case 0:
                                     return(43);
                                     break;
                            case 1:
                                     return(60);
                                     break;
                            case 2:
                                     return(70);
                                     break;
                            case 3:
                                     return(75);
                                     break;
                            default:
                                     return(TSENG_REFRESH_UNKNOWN);  /*JWK18*//*error-unknown*/                                      break;
                                     break;
                       }
                       break;
             case 1280:                        /* 1280x1024 */
                       switch(TsengRefreshCode)
                       {
                            case 0:
                                     return(43);
                                     break;
                            case 1:
                                     return(60);
                                     break;
                            case 2:
                                     return(70);
                                     break;
                            case 3:
                                     return(75);
                                     break;
                            default:
                                     return(TSENG_REFRESH_UNKNOWN);  /*JWK18*//*error-unknown*/                                      break;
                                     break;
                       }
                       break;
        }
    }


    /* if not found yet,
    ** return the frequncy based on the BIOS DATA area
    */

/*   info from tseng
**
**   The following are bits in the video BIOS data area of system RAM. These bits
**   are used by the video BIOS to select the display monitor refresh rates.
**   These bits simultaneously control 16 and 256 color refresh rates.
**
**   These bits are looked at by the BIOS during mode sets; that is, a BIOS
**   mode set must be done after changing the bits in order to have the refresh
**   rate change.
**
**   Note, other bits in these two memory locations must be preserved.
**
**
**   0:488   0:488   0:488   0:489  0:489
**   bit6    bit5    bit4    bit6   bit5       Resolution and Vertical refresh rate
**
**    0       X       X       X      X         640x480 60Hz
**    1       X       X       X      X         640x480 72Hz
**    X       0       X       1      X         800x600 56Hz
**    X       0       X       0      X         800x600 60Hz
**    X       1       X       1      X         800x600 72Hz
**    X       X       0       X      0         1024x768 87Hz (interlaced)
**    X       X       0       X      1         1024x768 60Hz (non-interlaced)
**    X       X       1       X      1         1024x768 70Hz (non-interlaced)
**
**            X = Don't care            note absence of 1280x1024 !!!!
*/

    switch(nHorz)
    {
         case 640:                        /* 640x480 */
                   if (pBiosData[0x88] & 0x40)
                   {
                       return(72);
                   }
                   else
                   {
                       return(60);
                   }

                   break;
         case 800:                        /* 800x600 */
                   if (!(pBiosData[0x88] & 0x20))
                   {
                       if (pBiosData[0x89] & 0x40)
                       {
                            return(56);
                       }
                       else
                       {
                            return(60);
                       }

                   }
                   else
                   {
                       if (pBiosData[0x89] & 0x40)
                       {
                           return(72);
                       }
                       else
                       {
                           return(TSENG_REFRESH_UNKNOWN);  /*JWK18*//*error-unknown*/                                      break;
                       }
                   }


                   break;
         case 1024:                        /* 1024x768 */
                   if (!(pBiosData[0x88] & 0x10))
                   {

                       if (pBiosData[0x89] & 0x20)
                       {
                            return(60);
                       }
                       else
                       {
                            return(43);
                       }

                   }
                   else
                   {
                       if (pBiosData[0x89] & 0x20)
                       {
                           return(70);
                       }
                       else
                       {
                           return(TSENG_REFRESH_UNKNOWN);  /*JWK18*//*error-unknown*/                                      break;
                       }
                   }


                   break;
         case 1280:                        /* 1280x1024 */
         default:
//                   return(0);    /* error, cant determine */
                     return(TSENG_REFRESH_UNKNOWN);  /*JWK26*//*JWK18*//*error-unknown*/                                      break;

                   break;
    }

}



/*****************************************************************************
 *
 * FUNCTION NAME = TsengSetVerticalRefreshRate     JWK10
 *
 * DESCRIPTION   = SET the refresh rate (in preparation for a setmode)
 *                 begin at the requested rate, if error, try lower rate
 *
 * INPUT         = nHorz  (horizontal resolution)
 *               = nRate  (vertical refresh rate)
 *               = nBPP   (bits per pixel (for diamond only)
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = actual rate set
 * RETURN-ERROR  = REFRESH_DISABLED (unable to set rate)
 *
 ****************************************************************************/

USHORT TsengSetVerticalRefreshRate(USHORT nHorz, USHORT nRate, USHORT nBPP, USHORT Flags)   /*JWK10*/
{

static union REGS regs;
USHORT TsengResolutionCode,RateOffset,RateIndex;
UCHAR far * pBiosData = (UCHAR far *)0x400000;
USHORT i,j,k;
USHORT bTemp, fSuccess, lastbest;
INT Temp;






   if (!nRate)      /* can always not set a refresh rate */
   {
      return(0);
   }

   /* skip list entries of UNKNOWN if INIT parameter specified */
   /* dont set refresh rate */
   /* for collecting pmi data set up by adapter utility */


   if (nRate == TSENG_REFRESH_UNKNOWN)
   {
       if (SetDefaultMonitor)
       {
           return(REFRESH_DISABLED);
       }
       else
       {
           return(TSENG_REFRESH_UNKNOWN);
       }
   }



   /* adjust refresh rate to highest valid if flag = TSENG_FIND_CLOSEST JWK26 */

   if (Flags == TSENG_FIND_CLOSEST)
   {

       if (sAdapter.RefreshTable)
       {
           i = 0;
           lastbest = 0;
           while(i < MAX_REFRESH_MODES && sAdapter.RefreshTable[i].usYResolution)
           {
               if (nHorz == sAdapter.RefreshTable[i].usXResolution)
               {
                   j = 0;
                   while(sAdapter.RefreshTable[i].VerticalRefresh[j] != NO_REFRESH)
                   {
                       if (  (sAdapter.RefreshTable[i].VerticalRefresh[j] <= (BYTE)nRate)
                          && (sAdapter.RefreshTable[i].VerticalRefresh[j] > (BYTE)lastbest) )
                       {
                           lastbest = sAdapter.RefreshTable[i].VerticalRefresh[j];
                       }
                       else
                       {
                           j++;
                       }
                   }
                   i = MAX_REFRESH_MODES;
               }
               else
               {
                   i++;
               }
           }
           if (lastbest) nRate = lastbest;
       }
   }


    /*
    ** convert the Horizontal resolution into the tseng BIOS resolution code
    ** we will use as index into other data as well
    **
    **      0=640x480
    **      1=800x600
    **      2=1024x768
    **      3=1280x1024
    */

    switch(nHorz)
    {
         case 640:
         default:
                   TsengResolutionCode=0;

                   break;

         case 800:                         /* 800x600 */
                   TsengResolutionCode=1;

                   break;

         case 1024:                        /* 1024x768 */
                   TsengResolutionCode=2;

                   break;

         case 1280:                        /* 1280x1024 */
                   TsengResolutionCode=3;

                   break;
    }

    /*
    ** convert the refresh rate into an index
    ** we will use as index into other data as well
    **
    **      0=0
    **      1=43
    **      2=56
    **      3=60
    **      4=70
    **      5=72
    **      6=75
    **      7=90
    **      8=unknown
    */

    switch(nRate)
    {
         case 0:
                   RateIndex=0;

                   break;

         case 43:
                   RateIndex=1;

                   break;

         case 56:
                   RateIndex=2;

                   break;
         case 60:
                   RateIndex=3;

                   break;

         case 70:
                   RateIndex=4;

                   break;

         case 72:
                   RateIndex=5;

                   break;

         case 75:
                   RateIndex=6;

                   break;

         case 90:
                   RateIndex=7;

                   break;

         default:
                   RateIndex=8;

                   break;


    }




   /* skip entries if already successfull mode set */
   /* for Dell VESA without get/set refresh (1280) */
   /* for if used adapter utility */


   if (Flags == TSENG_CHECK_LIMITS)
   {

       /* return an error if rate exceeds max monitor refresh rate */    /*JWK18*/
       /* this limits pmi entries from exceeding monitor capabilities */
                                                                   /*JWK18*/
       if (  nRate > TSENGMaxMonitorRefresh[TsengResolutionCode] )       /*JWK22*/   /*JWK18*/
       {                                                                 /*JWK18*/
           return(REFRESH_DISABLED);                                     /*JWK18*/
       }                                                                 /*JWK18*/

       k = nBPP/8;

       if (TSENGRefreshFlags[TsengResolutionCode][k][RateIndex])   /* return error if any refresh already set (prevents duplicate entries) */
       {
           return(REFRESH_DISABLED);
       }
       else
       {
           if (nRate == TSENG_REFRESH_ANY)
           {
               return(TSENG_REFRESH_ANY);
           }
       }
   }




 /* return an error if not valid entry in refresh table */

 if (sAdapter.RefreshTable)
 {
     i = 0;
     fSuccess = FALSE;
     while(i < MAX_REFRESH_MODES && sAdapter.RefreshTable[i].usYResolution)
     {
         if (nHorz == sAdapter.RefreshTable[i].usXResolution)
         {
             j = 0;
             while(!fSuccess && (sAdapter.RefreshTable[i].VerticalRefresh[j] != NO_REFRESH))
             {
                 if (sAdapter.RefreshTable[i].VerticalRefresh[j] == (BYTE)nRate)
                 {
                     fSuccess = TRUE;
                 }
                 else
                 {
                     j++;
                 }
             }
             i = MAX_REFRESH_MODES;
         }
         else
         {
             i++;
         }
     }
     if (!fSuccess) return(REFRESH_DISABLED);   /*JWK18*/
 }


 if (Flags == TSENG_CHECK_DISABLED)  /* return error if monitor selected and rate disabled */
 {
     if (TSENGMonitorRefresh[4])
     {
         if (  (!TSENGMonitorRefresh[TsengResolutionCode])
            || (TSENGMonitorRefresh[TsengResolutionCode] == REFRESH_DISABLED)  /*JWK18*/
            || (TSENGMonitorRefresh[TsengResolutionCode] == NO_REFRESH)  /*JWK26*/
            || (TSENGMonitorRefresh[TsengResolutionCode] == TSENG_RESOLUTION_DISABLED))  /*JWK26*/
         {
             return(REFRESH_DISABLED);          /*JWK18*/
         }
     }
 }


 /* return error if rate is not valid entry in monitor table at given resolution */

 for ( i = 0,fSuccess=FALSE; !fSuccess && (i < usSizeMonitorTable); i++)
 {
     if (pMonitorTable[i].VRefr[TsengResolutionCode] == (BYTE) nRate)
     {
         fSuccess = TRUE;
     }
 }
 if (!fSuccess) return REFRESH_DISABLED;        /*JWK18*/



 /* if diamondW32, use this routine, otherwise use following routines */
 /* just set ANY monitor type that supports the resolution, BPP and refresh rate */
 /* requested, if none found, return an error */

    if (TSENGDiamondW32)
    {

        if (!nBPP)    /* if no color depth, monitor type has been set and we are only looking for monitor capability */
        {
            if ( DiaMonTableW32[TSENGMonitorRefresh[4]].VRefr[TsengResolutionCode] == (BYTE)nRate)
            {
                return(nRate);
            }
            else
            {
                return REFRESH_DISABLED;        /*JWK18*/
            }
        }
        else
        {
//           this outer look is not doing anything. The horizontal res is already
//           varified in the upper switch statement and DiaMonTableW32 already contains
//           maximum that is supported by the adapter!
//                      for ( i = 0; i < DIA_NUM_MODES; i++ )    /* if valid mode and refresh and bpp */
//                      {
//                          if ( ( DIA_ModeStruct[i].nHorzRes == nHorz )
//                            && ( DIA_ModeStruct[i].nRef == nRate)
//                            && (DIA_ModeStruct[i].nBPP == nBPP) )
//                          {

                    for ( j = 1; j < DIA_NUM_MONITORS; j++)  /* if monitor supports */
                    {
                        if ( DiaMonTableW32[j].VRefr[TsengResolutionCode] == (BYTE)nRate)
                        {
                              outp(0x3bf, 0x03);  /* unlock */
                              outp(0x3b8, 0xa0);
                              outp(0x3d8, 0xa0);

                              outp(CRT_INDEXPORT,0x31);
                              bTemp = inp(CRT_DATAPORT);

                              bTemp &= ~0x0f;
                              bTemp |= ((j-1) & 0x0f);   /* set monitor type that supports this mode */

                              outp(CRT_DATAPORT,bTemp);

                              return(nRate);
                        }
                    }
//                          }
//                      }
        }
        return(REFRESH_DISABLED);  /* no resolution, refresh rate, and bpp match with supported monitors */  /*JWK18*/
     }


    /*
    ** convert the refresh rate into an offset into the monitor data table
    **  (faster than search)
    */

    switch(nRate)
    {
         case 60:
                   RateOffset = 0;

                   break;
         case 70:
                   RateOffset = 1;

                   break;
         case 56:
                   RateOffset = 2;

                   break;
         case 43:
                   RateOffset = 3;

                   break;
         case 72:
                   RateOffset = 4;

                   break;

         case NO_REFRESH:
         case REFRESH_DISABLED:         /*JWK18*/
         default:
                   RateOffset = TSENG_RESOLUTION_DISABLED;

                   break;
         case 75:
                   RateOffset = 6;

                   break;
         case 90:
                   RateOffset = 7;

                   break;

    }


    /* if disabled return error */

    if (RateOffset == TSENG_RESOLUTION_DISABLED)
    {
        return(REFRESH_DISABLED);               /*JWK18*/
    }


//JWK26    /* if not valid rate for resolution return error */
//JWK26
//JWK26     if (TSENGresponsedata[RateOffset].TsengFrequency[TsengResolutionCode] > TSENG_MAX_REFRESH_RATE)
//JWK26     {
//JWK26         return(REFRESH_DISABLED);               /*JWK18*/
//JWK26     }


    /* set BIOS data */

    pBiosData[0x88] &= TSENGresponsedata[RateOffset].ANDMask88[TsengResolutionCode];
    pBiosData[0x89] &= TSENGresponsedata[RateOffset].ANDMask89[TsengResolutionCode];
    pBiosData[0x88] |= TSENGresponsedata[RateOffset].ORMask88[TsengResolutionCode];
    pBiosData[0x89] |= TSENGresponsedata[RateOffset].ORMask89[TsengResolutionCode];


    /* set CRTC31 data */

    outp(0x3bf, 0x03);  /* unlock */
    outp(0x3b8, 0xa0);
    outp(0x3d8, 0xa0);


    outp(CRT_INDEXPORT,0x31);
    bTemp = inp(CRT_DATAPORT);

    bTemp &= TSENGresponsedata[RateOffset].ANDMaskCRTC[TsengResolutionCode];         /*JWK05*/
    bTemp |= TSENGresponsedata[RateOffset].ORMaskCRTC[TsengResolutionCode];

    outp(CRT_DATAPORT,bTemp);


    /* call tseng bios monitor support if was flagged to exist */
    /* search for success.  BIOS data area updated automatically */

    if (TSENGBIOSMonitorSupport)
    {
        fSuccess = FALSE;
        /* get starting point */
        Temp = TSENGresponsedata[RateOffset].TsengFrequency[TsengResolutionCode];

        while (!fSuccess && (Temp >= 0))
        {

            regs.x.cx = Temp;
            regs.x.ax = 0x1200;   /* al=0, set freq */
            regs.h.bh = (BYTE) TsengResolutionCode;
            regs.h.bl = 0xf1;
            int86(VBIOS, &regs, &regs);
                                       /* some bios do not update the cx parameter */
            regs.x.cx = 0xffff;
            regs.x.ax = 0x1201;   /* al=1, get freq */
            regs.h.bh = (BYTE) TsengResolutionCode;
            regs.h.bl = 0xf1;
            int86(VBIOS, &regs, &regs);

            /* if get=set end */

            if ((regs.h.al == 0x12) && (regs.x.cx == (USHORT)Temp))
            {
                fSuccess = TRUE;
            }
            else
            {
                Temp--;
            }
        }
        if (fSuccess)
        {

            /*
            ** return the frequncy based on the Tseng BIOS refresh code that worked
            */

            switch(nHorz)
            {
                 case 640:                        /* 640x480 */
                 default:
                           switch(Temp)
                           {
                                case 0:
                                         return(60);
                                         break;
                                case 1:
                                         return(72);
                                         break;
                                case 2:
                                         return(75);
                                         break;
                                case 3:
                                         return(90);
                                         break;
                                default:
                                         return(REFRESH_DISABLED);              /*JWK18*/
/*error-unknown*/                                          break;
                           }

                           break;
                 case 800:                        /* 800x600 */
                           switch(Temp)
                           {
                                case 0:
                                         return(56);
                                         break;
                                case 1:
                                         return(60);
                                         break;
                                case 2:
                                         return(72);
                                         break;
                                case 3:
                                         return(75);
                                         break;
                                case 4:
                                         return(90);
                                         break;
                                default:
                                         return(REFRESH_DISABLED);              /*JWK18*/
                                         break;
                           }


                           break;
                 case 1024:                        /* 1024x768 */
                           switch(Temp)
                           {
                                case 0:
                                         return(43);
                                         break;
                                case 1:
                                         return(60);
                                         break;
                                case 2:
                                         return(70);
                                         break;
                                case 3:
                                         return(75);
                                         break;
                                default:
                                         return(REFRESH_DISABLED);              /*JWK18*/
                                         break;
                           }
                           break;
                 case 1280:                        /* 1280x1024 */
                           switch(Temp)
                           {
                                case 0:
                                         return(43);
                                         break;
                                case 1:
                                         return(60);
                                         break;
                                case 2:
                                         return(70);
                                         break;
                                case 3:
                                         return(75);
                                         break;
                                default:
                                         return(REFRESH_DISABLED);              /*JWK18*/
                                         break;
                           }
                           break;
            }
        }
        else
        {
            return REFRESH_DISABLED;            /*JWK18*/
        }
    }

    return nRate;
}

/*****************************************************************************
 *
 * FUNCTION NAME = TsengGetVerticalPolarity       JWK10
 *
 * DESCRIPTION   = determine if vertical retrace polarity is positive
 *
 *               This needs to be called dynamically (after actual mode set)
 *               because the tseng BIOS may have set a new polarity.
 *
 * INPUT         = NONE
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = TRUE if positive, FALSE if negative
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

USHORT TsengGetVerticalPolarity(USHORT nHorz)   /*JWK10*/
{

USHORT bMiscInput;

     /*Misc Output Register (0x3cc) bit 7 , set => negative retrace polarity */

      bMiscInput = inp(0x3cc);

      return( (bMiscInput & 0x80)
              ? FALSE
              : TRUE );
}

/*****************************************************************************
 *
 * FUNCTION NAME = TsengGetHorizontalPolarity       JWK10
 *
 * DESCRIPTION   = determine if horizontal retrace polarity is positive
 *
 *               This needs to be called dynamically (after actual mode set)
 *               because the tseng BIOS may have set a new polarity.
 *
 * INPUT         = NONE
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = TRUE if positive, FALSE if negative
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

USHORT TsengGetHorizontalPolarity(USHORT nHorz)   /*JWK10*/
{

USHORT bMiscInput;

     /*Misc Output Register (0x3cc) bit 6, set => negative retrace polarity */

      bMiscInput = inp(0x3cc);

      return( (bMiscInput & 0x40)
              ? FALSE
              : TRUE );
}



/*****************************************************************************
 *
 * FUNCTION NAME = GetTSENGBaseIO()
 *
 * DESCRIPTION   =
 *
 * INPUT         = NONE
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

VOID GetTSENGBaseIO(VOID)
{
  _asm {
        mov     dx,TSENG_BASE_INDEX     ; get the register base default

GTBIOLoop:
        mov    al, TSENG_INDEX_CRTCB_COLOR_DEPTH
        out     dx, al
        inc     dx                      ; point to data
        in      al, dx                  ; get original value
        mov     ah, al                  ; save original value
        xor     al, 8fh                 ; create a new value write/readback
        and     al, 0cfh                ; mask off reserved bits
        mov     bl, al                  ; save new value
        out     dx, al                  ; write new value
        in      al, dx                  ; read back data
;;;     and     al, 0cfh                ; mask off reserved bits
        cmp     al, bl                  ; see if same data 'saved'
        je      FoundTsengInstance

        dec     dx                      ; back to index
        add     dx, 10h                 ; try next IO Address
        cmp     dx,TSENG_BASE_INDEX+0f0h ; try from base plus sixteen addresses
        jbe     GTBIOLoop               ;  yup - try again
        jmp     SHORT GTBIOExit         ; no Instance found

FoundTsengInstance:
        mov     al, ah                  ; get original data value
        out     dx, al                  ; write back original data value
        mov     TSENGBaseIOData, dx     ; report back BaseIO data port value
        dec     dx                      ; point back to index
        mov     TSENGBaseIOIndex, dx    ; report back BaseIO index port value
        shr     dx, 4                   ; get rid of low nibble
        and     dx, 07h                 ; make number 0-7
        mov     TSENGInstance, dx       ; save number
GTBIOExit:

        }
}
/*****************************************************************************
 *
 * FUNCTION NAME = GetTSENGBaseMMIO()
 *
 * DESCRIPTION   =
 *
 * INPUT         = NONE
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

VOID GetTSENGBaseMMIO(VOID)
{
  USHORT CRTC36Data = 0;
  USHORT GDC6Data = 0;
  USHORT IMAPortEnabled = FALSE;



  TSENGMMUBase  = 0;
  TSENGMMURange = 0;
  TSENGMMUApertureSize = 0;
  TSENGMMRBase  = 0;
  TSENGMMRRange = 0;
  TSENGEMRBase  = 0;
  TSENGEMRRange = 0;

  _asm {

  ; read CRTC Indexed Register 36: Video System Configuration
  ; assume unlocked

        mov     dx, CRT_INDEXPORT
        mov     al, 36h
        out     dx, al
        mov     dx, CRT_DATAPORT
        in      al, dx
        shr     al, 3
        and     ax, 7


        mov     CRTC36Data, ax

  ; read GDC Indexed Register 6: Miscellaneous

        mov     dx, GDC_INDEXPORT
        mov     al, 6
        out     dx, al
        mov     dx, GDC_DATAPORT
        in      al, dx
        shr     al, 2
        and     ax, 3
        mov     GDC6Data, ax

  ; see if IMA port is enabled, flag it if it is
  ; read IMA Indexed Register F7: Image Port Control

        mov     dx, TSENGBaseIOIndex
        mov     al, 0f7h
        out     dx, al
        mov     dx, TSENGBaseIOData
        in      al, dx
        test    al, 40h
        jnz     ok
        test    al, 01
        jz      ok
        mov     IMAPortEnabled, TRUE
   ok:

        }

        switch(CRTC36Data)
        {
            case 0:
                switch(GDC6Data)
                {
                    case 0:
                        TSENGVGABase  = 0xA0000;
                        TSENGVGARange = 0xBFFFF - 0xA0000;
                    break;

                    case 1:
                        TSENGVGABase  = 0xA0000;
                        TSENGVGARange = 0xAFFFF - 0xA0000;
                    break;

                    case 2:
                        TSENGVGABase  = 0xB0000;
                        TSENGVGARange = 0xB7FFF - 0xB0000;
                    break;

                    case 3:
                        TSENGVGABase  = 0xB8000;
                        TSENGVGARange = 0xBFFFF - 0xB8000;
                    break;

                }
            break;

            case 1:
                switch(GDC6Data)
                {
                    case 0:
                        TSENGVGABase  = 0xA0000;
                        TSENGVGARange = 0xBFFFF - 0xA0000;
                        TSENGMMUBase  = 0xB8000;
                        TSENGMMURange = 0xBDFFF - 0xB8000;
                    break;

                    case 1:
                        TSENGVGABase  = 0xA0000;
                        TSENGVGARange = 0xAFFFF - 0xA0000;
                        TSENGMMUBase  = 0xB8000;
                        TSENGMMURange = 0xBDFFF - 0xB8000;
                        TSENGMMUApertureSize = 8 * 1024;
                    break;

                    case 2:
                        TSENGVGABase  = 0xB0000;
                        TSENGVGARange = 0xB7FFF - 0xB0000;
                        TSENGMMUBase  = 0xA8000;
                        TSENGMMURange = 0xADFFF - 0xA8000;
                        TSENGMMUApertureSize = 8 * 1024;
                    break;

                    case 3:
                        TSENGVGABase  = 0xB8000;
                        TSENGVGARange = 0xBFFFF - 0xB8000;
                        TSENGMMUBase  = 0xA8000;
                        TSENGMMURange = 0xADFFF - 0xA8000;
                        TSENGMMUApertureSize = 8 * 1024;
                    break;

                }
            break;

            case 5:
                switch(GDC6Data)
                {
                    case 0:
                        TSENGVGABase  = 0xA0000;
                        TSENGVGARange = 0xBFFFF - 0xA0000;
                        TSENGMMUBase  = 0xB8000;
                        TSENGMMURange = 0xBDFFF - 0xB8000;
                    break;

                    case 1:
                        TSENGVGABase  = 0xA0000;
                        TSENGVGARange = 0xAFFFF - 0xA0000;
                        TSENGMMUBase  = 0xB8000;
                        TSENGMMURange = 0xBDFFF - 0xB8000;
                        TSENGMMUApertureSize = 8 * 1024;
                        TSENGMMRBase  = 0xBFF00;
                        TSENGMMRRange = 0xBFFFF - 0xBFF00;
                        TSENGEMRBase  = 0xBE000;
                        TSENGEMRRange = 0xBEFFF - 0xBE000;
                    break;

                    case 2:
                        TSENGVGABase  = 0xB0000;
                        TSENGVGARange = 0xB7FFF - 0xB0000;
                        TSENGMMUBase  = 0xA8000;
                        TSENGMMURange = 0xADFFF - 0xA8000;
                        TSENGMMUApertureSize = 8 * 1024;
                        TSENGMMRBase  = 0xAFF00;
                        TSENGMMRRange = 0xAFFFF - 0xAFF00;
                        TSENGEMRBase  = 0xAE000;
                        TSENGEMRRange = 0xAEFFF - 0xAE000;
                    break;

                    case 3:
                        TSENGVGABase  = 0xB8000;
                        TSENGVGARange = 0xBFFFF - 0xB8000;
                        TSENGMMUBase  = 0xA8000;
                        TSENGMMURange = 0xADFFF - 0xA8000;
                        TSENGMMUApertureSize = 8 * 1024;
                        TSENGMMRBase  = 0xAFF00;
                        TSENGMMRRange = 0xAFFFF - 0xAFF00;
                        TSENGEMRBase  = 0xAE000;
                        TSENGEMRRange = 0xAEFFF - 0xAE000;
                    break;

                }
            break;

            case 2:
                if (IMAPortEnabled)
                {
                    TSENGVGABase  = 0x00000;
                    TSENGVGARange = 0xFFFFF - 0x00000;
                }
                else
                {
                    TSENGVGABase  = 0x00000;
                    TSENGVGARange = 0x3FFFFF - 0x00000;
                }
            break;

            case 7:
                if (IMAPortEnabled)
                {
                    TSENGVGABase  = 0x00000;
                    TSENGVGARange = 0x7FFFF - 0x00000;
                    TSENGMMUBase  = 0x80000;
                    TSENGMMURange = 0xDFFFF - 0x80000;
                    TSENGMMUApertureSize = 128 * 1024;
                    TSENGMMRBase  = 0xFFF00;
                    TSENGMMRRange = 0xFFFFF - 0xFFF00;
                    TSENGEMRBase  = 0xFE000;
                    TSENGEMRRange = 0xFEFFF - 0xFE000;
                }
                else
                {
                    TSENGVGABase  = 0x00000;
                    TSENGVGARange = 0x1FFFFF - 0x00000;
                    TSENGMMUBase  = 0x200000;
                    TSENGMMURange = 0x37FFFF - 0x200000;
                    TSENGMMUApertureSize = 512 * 1024;
                    TSENGMMRBase  = 0x3FFF00;
                    TSENGMMRRange = 0x3FFFFF - 0x3FFF00;
                    TSENGEMRBase  = 0x380000;
                    TSENGEMRRange = 0x3BFFFF - 0x380000;
                }
            break;

      /*    default: _asm int 3;    should not get here */

        }
}


/*
 *    NEXT VERSION WILL USE CONFIGURATOR
 *
 */


//           moving Diamond to IBMGPMI, not needed anymore.
//           USHORT DIA_WriteClockStream(FILE *file, int nHorz, int nVert, int nBPP)
//           {
//                   USHORT                     i;
//                   USHORT                     nRef;
//                   USHORT                     nMonType;
//          
//          
//                    if (TSENGDiamondW32)   // This should have been checked already,
//                                       // but just in case, we will check again...
//                   {
//                           outp(0x3bf, 0x03);  /* unlock */
//                           outp(0x3b8, 0xa0);
//                           outp(0x3d8, 0xa0);
//          
//                           outp(0x3d4, 0x31);
//                           nMonType = inp(0x3d5) & 0x0f;
//                           nMonType++;  /* correct for our table */
//          
//                           switch ( nHorz )
//                           {
//                                   case 1280:
//                                           nRef = DiaMonTableW32[nMonType].VRefr[MON_INDEX_1280];
//                                           break;
//          
//                                   case 1024:
//                                           nRef = DiaMonTableW32[nMonType].VRefr[MON_INDEX_1024];
//                                           break;
//          
//                                   case 800:
//                                           nRef = DiaMonTableW32[nMonType].VRefr[MON_INDEX_800];
//                                           break;
//          
//                                   case 640:
//                                           nRef = DiaMonTableW32[nMonType].VRefr[MON_INDEX_640];
//                                           break;
//          
//                                   default:
//                                           nRef = 0;
//                           }

//                           if ( nRef )
//                           {
//                                   for ( i = 0; i < DIA_NUM_MODES; i++ )
//                                   {
//                                           if ( ( DIA_ModeStruct[i].nHorzRes == (USHORT)nHorz )
//                                             && ( DIA_ModeStruct[i].nVertRes == (USHORT)nVert )
//                                             && ( DIA_ModeStruct[i].nRef == nRef )
//                                             && ( DIA_ModeStruct[i].nBPP == (USHORT)nBPP ) )
//                                           {
//           //yeexx                                 fprintf(file, "/*\n * Program External Clock\n * MonitorType = %s (%d Hz) Data = 0x%08lx\n */\n",
//           //                                              &DiaMonTableW32[nMonType].name[0], DIA_ModeStruct[i].nRef, DIA_ClockTable[DIA_ModeStruct[i].nClock]);
//           //                                      DIA_WriteIC(file,DIA_ClockTable[DIA_ModeStruct[i].nClock]);
//                                              fprintf(file, "r0 = 0x%08lx;\n",                     /*          */
//                                                      DIA_ClockTable[DIA_ModeStruct[i].nClock]);   /*          */
//                                              fprintf(file,"call pfnPMISetMonitorTimings;\n");     /*          */
//                                                              return(FALSE);
//          
//                                           }
//                                   }
//                           }
//                   }
//                   return(TRUE);
//           }

// Determine whether or not this is a Diamond board with Tseng W32
USHORT IsDiamondW32()
{
        union REGS      InRegs;
        union REGS      OutRegs;


   if ( (sSVGA.AdapterType == TSENG_ADAPTER)
        && (sSVGA.ChipType >= TSENG_ET4000W32_CHIP))
   {
        // check for diamond display per Diamond recommendation
        InRegs.x.ax = 0x1daa;
        InRegs.x.bx = 0xfdec;
        int86(VBIOS, &InRegs, &OutRegs);

        return(OutRegs.x.bx == 0xcedf);
   }

   return(FALSE);

}

/*
 * WriteIC writes a single 24bit value to the ICDESIGNS Frequency
 * Synthesizer chip, one bit at a time, as required.
 */

//           VOID DIA_WriteIC(FILE *file, ULONG data)
//           {
//             USHORT i;
//             USHORT oldstate;
//          
//                   oldstate = 0x0000;
//          
//                 //**********************************************
//                 //First, send the "Unlock sequence" to the clock chip.
//                 DIA_OUTPUT(DIA_MISCOUT,oldstate | DIA_MISCD);     //raise the data bit
//                 for (i=0;i<5;i++)                 //send at least 5 unlock bits
//                 {
//                    DIA_OUTPUT(DIA_MISCOUT,oldstate | DIA_MISCD);          //hold the data on while
//                    DIA_OUTPUT(DIA_MISCOUT,oldstate | DIA_MISCD | DIA_MISCC); //lowering and raising the clock
//                 }
//                 DIA_OUTPUT(DIA_MISCOUT,oldstate);         //then turn the data and clock off
//                 DIA_OUTPUT(DIA_MISCOUT,oldstate | DIA_MISCC);  //and turn the clock on one more time.
//                                //now send the start bit:
//                 DIA_OUTPUT(DIA_MISCOUT,oldstate);         //leave data off, and lower the clock
//                 DIA_OUTPUT(DIA_MISCOUT,oldstate | DIA_MISCC);  //leave data off, and raise the clock
//                                  //localbus position for hacking bits out
//                 //****************************************************************
//                 //Next, send the 24 data bits.
//                 for (i=0; i<24; i++)
//                 {
//                           //leaving the clock high, raise the inverse of the data bit
//                    DIA_OUTPUT(DIA_MISCOUT,oldstate | ((~(((short)data)<<3))&DIA_MISCD) | DIA_MISCC);
//                          //leaving the inverse data in place, lower the clock
//                    DIA_OUTPUT(DIA_MISCOUT,oldstate | (~(((short)data)<<3))&DIA_MISCD);
//                          //leaving the clock low, rais the data bit
//                    DIA_OUTPUT(DIA_MISCOUT,oldstate | (((short)data)<<3)&DIA_MISCD);
//                         //leaving the data bit in place, raise the clock
//                    DIA_OUTPUT(DIA_MISCOUT,oldstate | ((((short)data)<<3)&DIA_MISCD) | DIA_MISCC);
//                    data = data >> 1;          //get the next bit of the data
//                 }
//                          //leaving the clock high, raise the data bit
//                 DIA_OUTPUT(DIA_MISCOUT,oldstate | DIA_MISCD | DIA_MISCC);
//                          //leaving the data high, drop the clock low, then high again
//                 DIA_OUTPUT(DIA_MISCOUT,oldstate | DIA_MISCD);
//                 DIA_OUTPUT(DIA_MISCOUT,oldstate | DIA_MISCD | DIA_MISCC);
//                          //setting both serial control bits to 1 will
//                 DIA_OUTPUT(DIA_MISCOUT,oldstate | DIA_MISCD | DIA_MISCC);  //select regester 2 frequency
//             return;
//           }


/**********************************************************************
 *
 */
unsigned long segsel(long row, long col, int bpPix, int hRes, USHORT BytesPerScanline)  //JWK28
{
   long pos, hBytes;
   int seg;

   //JWK28 hBytes = (hRes * bpPix)/8;
      hBytes = BytesPerScanline;

   // Determine which segment to address
   if (bpPix > 8)
      pos = (hBytes * row) + (col * bpPix)/8;
   else
      pos = hBytes * row +col;
   seg = (int) (pos >> 16);
   TsengSetBank(seg);
   return pos & 0xffff;
}



/**********************************************************************
 * void pixText(int bpPix, int hRes, char *textStr);
 */
void pixText(int bpPix, int hRes, char *textStr, USHORT BytesPerScanline)  //JWK28
{

   unsigned long pixOff, pixSeg = 0xa0000000;
   unsigned int colptr, patptr, cnt, len;
   long row, col;
   char far *pixAddr;


   unsigned int patM[8] = {0xff,0x2,0x4,0x8,0x4,0x2,0xff,0};
   unsigned int pato[8] = {0x78,0x84,0x84,0x84,0x84,0x84,0x78,0};
   unsigned int patd[8] = {0x78,0x84,0x84,0x84,0x84,0x48,0xff,0};
   unsigned int pate[8] = {0x78,0x94,0x94,0x94,0x94,0x94,0x58,0};
   unsigned int patf[8] = {0x90,0x90,0xfe,0x91,0x91,0x1,0x2,0};
   unsigned int patx[7] = {0x84,0x48,0x30,0x30,0x48,0x84,0};
   unsigned int patH[8] = {0xff,0x10,0x10,0x10,0x10,0x10,0xff,0};
   unsigned int patz[7] = {0x8c,0xc4,0xa4,0x94,0x8c,0xc4,0};
   unsigned int patT[8] = {0x3,0x1,0x1,0xff,0x1,0x1,0x3,0};
   unsigned int patC[7] = {0x3c,0x42,0x81,0x81,0x81,0x42,0};
   unsigned int pat_[8] = {0x80,0x80,0x80,0x80,0x80,0x80,0x80,0};
   unsigned int pat0[8] = {0x3e,0xc1,0xa1,0x91,0x89,0x85,0x3e,0};
   unsigned int pat1[7] = {0x80,0x82,0x82,0xff,0x80,0x80,0};
   unsigned int pat2[8] = {0x82,0xc1,0xa1,0x91,0x89,0x85,0xc2,0};
   unsigned int pat3[8] = {0x42,0x81,0x81,0x89,0x99,0xa5,0x42,0};
   unsigned int pat4[8] = {0x10,0x98,0x94,0x92,0xff,0x90,0x90,0};
   unsigned int pat5[8] = {0x4f,0x89,0x89,0x89,0x89,0x89,0x71,0};
   unsigned int pat6[8] = {0x7c,0xa2,0x91,0x91,0x91,0x91,0x60,0};
   unsigned int pat7[8] = {0x3,0x1,0x1,0xf1,0x9,0x5,0x3,0};
   unsigned int pat8[8] = {0x76,0x89,0x89,0x89,0x89,0x89,0x76,0};
   unsigned int pat9[8] = {0x6,0x89,0x89,0x89,0x49,0x29,0x1e,0};
   unsigned int pat, *patAddr, *numStr[10] = {
      pat0,pat1,pat2,pat3,pat4,pat5,pat6,pat7,pat8,pat9};


   len = strlen (textStr);
   col = (long)hRes/2-(4*len);
   for (cnt = 0; cnt < len; cnt++, col++) {
      switch (textStr[cnt]) {
         case 'M': patAddr = patM; break;
         case 'o': patAddr = pato; break;
         case 'd': patAddr = patd; break;
         case 'e': patAddr = pate; break;
         case 'f': patAddr = patf; break;
         case 'H': patAddr = patH; break;
         case 'z': patAddr = patz; break;
         case 'T': patAddr = patT; break;
         case 'C': patAddr = patC; break;
         case 'x': patAddr = patx; break;
         case ' ': col += 7;       continue;
         default:
            if (!isdigit(textStr[cnt]))
               continue;
            patAddr = numStr[textStr[cnt]-0x30];
         }
      for (patptr = 0;  patAddr[patptr]; col++, patptr++) {
         pat = patAddr[patptr];
         for (row=5; pat; row++, pat>>=1) {
            if (pat & 0x1) {
               if (bpPix == 8)
                  for (colptr = 0; colptr < 3; colptr++) {
                     pixOff = segsel (row, col*3+colptr, bpPix, hRes*3, BytesPerScanline); //JWK28
                     pixAddr = (char far *)(pixSeg | pixOff);
                     *pixAddr++ = (char)0xff;
                     }
               else {
                  pixOff = segsel (row, col, bpPix, hRes, BytesPerScanline); //JWK28
                  pixAddr = (char far *)(pixSeg | pixOff);
                  *(int far *)pixAddr = 0x7fff;
                  }
               }
            }
         }
      }
}

void scrnID(PCHIPINFO ChipInfo,  INT Adapter,  INT Chip, USHORT BytesPerScanline)  //JWK28
{
   char buf[120];

   PCHIPHEADER   pChipHdr = ChipInfo->pChipHdr;
   USHORT row = 1;
   USHORT ifreq;

   ifreq = TsengGetVerticalRefreshRate(pChipHdr->usXResolution, 0);


   if ( (pChipHdr->bBitsPerPixel == 24)
     && ((pChipHdr->bModeAttributes & GRAPHICS_MODEATTR)) )
   {
      sprintf (buf," TC Mode %x  %dx%dx%d %dHz",ChipInfo->Int10Mode,pChipHdr->usXResolution,
         pChipHdr->usYResolution,pChipHdr->bBitsPerPixel, ifreq);
      pixText (8, pChipHdr->usXResolution, buf, BytesPerScanline);  //JWK28
      return;
   }

   if ( (pChipHdr->bBitsPerPixel == 16)
     && ((pChipHdr->bModeAttributes & GRAPHICS_MODEATTR)) )
   {
      sprintf (buf," HC Mode %x  %dx%dx%d %dHz",ChipInfo->Int10Mode,pChipHdr->usXResolution,
         pChipHdr->usYResolution,pChipHdr->bBitsPerPixel, ifreq);
      pixText (16, pChipHdr->usXResolution, buf,BytesPerScanline);  //JWK28
      return;
   }

   if (pChipHdr->bModeAttributes & GRAPHICS_MODEATTR)
   {
      sprintf (buf," Mode %x  %dx%dx%d  %dHz",ChipInfo->Int10Mode,pChipHdr->usXResolution,
        pChipHdr->usYResolution,pChipHdr->bBitsPerPixel,ifreq);
      set_cur (row,10);
      printf ("%s",buf);
      return;
   }

   if (!(pChipHdr->bModeAttributes & GRAPHICS_MODEATTR))
   {
      sprintf (buf," Text Mode %x  %dx%dx%d  \n\n",ChipInfo->Int10Mode,pChipHdr->usXResolution,
        pChipHdr->usYResolution,pChipHdr->bBitsPerPixel);
      set_cur (row,10);
      printf ("%s",buf);
      printf ("  1234567890 1234567890 1234567890\n");
      printf ("  abcdefghijklmnopqrstuvwxyz\n");
      printf ("  ABCDEFGHIJKLMNOPQRSTUVWXYZ\n");

      return;
   }
}


/**********************************************************************
 * void set_cur(int row, int col);
 */
void set_cur(USHORT row, USHORT col)
{
   union REGS inregs, outregs;

   inregs.h.bh = 0x0;
   inregs.h.dl = (BYTE) col;
   inregs.h.dh = (BYTE) row;
   inregs.h.ah = 0x2;
   int86(VBIOS, &inregs, &outregs);
}










