/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*****************************************************************************
 *
 * SOURCE FILE NAME = SVGAS3.C
 *
 * DESCRIPTIVE NAME = Chipdata
 *
 *
 * VERSION = V2.2
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * NOTES
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/*
**      Include files
*/

#define PMIDEF_INCL
#include "svga.h"

S3_MODETABLE S3ModeTable[ ]=            /*            */
{
  {0x0100, 0x68},
  {0x0101, 0x69},
  {0x0102, 0x6a},
  {0x0103, 0x6b},
  {0x0104, 0x6c},
  {0x0105, 0x6d},
  {0x0106, 0x6e},
  {0x0107, 0x6f},
  {0x0109, 0x55},
  {0x010a, 0x54},
  {0x0110, 0x70},
  {0x0111, 0x71},
  {0x0112, 0x72},
  {0x0113, 0x73},
  {0x0114, 0x74},
  {0x0115, 0x75},
  {0x0116, 0x76},
  {0x0117, 0x77},
  {0x0118, 0x78},
  {0x0119, 0x79},
  {0x011A, 0x7A},
  {0x011B, 0x7B},
  {0x0120, 0x7C},
  {0x0121, 0x7D},
  {0x0122, 0x7E},
  {0x0123, 0x7F},
  {0x0201, 0x49},
  {0x0202, 0x4A},
  {0x0203, 0x4B},
  {0x0204, 0x4C},
  {0x0205, 0x4D},
  {0x0207, 0x4E},
  {0x0208, 0x4F},
};

USHORT NUM_S3ENTRIES = sizeof(S3ModeTable) / sizeof (S3_MODETABLE); /*          */

/*
**
**              Chipset Lock/Unlock Information
**
*/

REGDATA S3LockData[] =
{
//{ PMICMD_REGOP, NONE,           NONE, 0x01, 7, READWRITE_DATA, "\x00" }, /*          */
  { PMICMD_REGOP, NONE,           NONE, 0x01, 6, READWRITE_DATA, "\x00" }, /*          */
//{ PMICMD_REGOP, NONE,           NONE, 0x01, 5, READWRITE_DATA, "\x00" }, /*          */
  { PMICMD_REGOP, NONE,           NONE, 0x01, 4, READWRITE_DATA, "\x00" }, /*          */
//{ PMICMD_REGOP, NONE,           NONE, 0x01, 3, READWRITE_DATA, "\x00" }, /*          */
  { PMICMD_REGOP, NONE,           NONE, 0x01, 2, READWRITE_DATA, "\x00" }, /*          */
  { PMICMD_INB,   CRT_INDEXPORT,  NONE, NONE, 0, NONE,           NULL   },
//{ PMICMD_INB,   MONO_INDEXPORT, NONE, NONE, 1, NONE,           NULL   }, /*          */

//{ PMICMD_OUTB,  MONO_INDEXPORT, NONE, NONE, 0, WRITEONLY_DATA, "\x40" }, /*          */
//{ PMICMD_OUTB,  MONO_DATAPORT,  NONE, NONE, 7, WRITEREG_DATA,  NULL   }, /*          */
  { PMICMD_OUTB,  CRT_INDEXPORT,  NONE, NONE, 0, WRITEONLY_DATA, "\x40" }, /*          */
  { PMICMD_OUTB,  CRT_DATAPORT,   NONE, NONE, 6, WRITEREG_DATA,  NULL   }, /*          */

//{ PMICMD_OUTB,  MONO_INDEXPORT, NONE, NONE, 0, WRITEONLY_DATA, "\x39" }, /*          */
//{ PMICMD_OUTB,  MONO_DATAPORT,  NONE, NONE, 5, WRITEREG_DATA,  NULL   }, /*          */
  { PMICMD_OUTB,  CRT_INDEXPORT,  NONE, NONE, 0, WRITEONLY_DATA, "\x39" }, /*          */
  { PMICMD_OUTB,  CRT_DATAPORT,   NONE, NONE, 4, WRITEREG_DATA,  NULL   }, /*          */
//{ PMICMD_OUTB,  MONO_INDEXPORT, NONE, NONE, 0, WRITEONLY_DATA, "\x38" }, /*          */
//{ PMICMD_OUTB,  MONO_DATAPORT,  NONE, NONE, 3, WRITEREG_DATA,  NULL   }, /*          */
  { PMICMD_OUTB,  CRT_INDEXPORT,  NONE, NONE, 0, WRITEONLY_DATA, "\x38" }, /*          */
  { PMICMD_OUTB,  CRT_DATAPORT,   NONE, NONE, 2, WRITEREG_DATA,  NULL   }, /*          */
//{ PMICMD_OUTB,  MONO_INDEXPORT, NONE, NONE, 1, WRITEREG_DATA,  NULL   }, /*          */
  { PMICMD_OUTB,  CRT_INDEXPORT,  NONE, NONE, 0, WRITEREG_DATA,  NULL   },
  { PMICMD_NONE },
};

REGDATA S3UnLockData[] =
{
  { PMICMD_INB,   CRT_INDEXPORT,  NONE, NONE, 0, NONE,           NULL   },
//{ PMICMD_INB,   MONO_INDEXPORT, NONE, NONE, 1, NONE,           NULL   }, /*          */
  { PMICMD_OUTB,  CRT_INDEXPORT,  NONE, NONE, 0, WRITEONLY_DATA, "\x38" }, /*          */
  { PMICMD_INB,   CRT_DATAPORT,   NONE, NONE, 2, NONE,           NULL   }, /*          */
  { PMICMD_OUTB,  CRT_DATAPORT,   NONE, NONE, 0, WRITEONLY_DATA, "\x48" }, /*          */
//{ PMICMD_OUTB,  MONO_INDEXPORT, NONE, NONE, 0, WRITEONLY_DATA, "\x38" }, /*          */
//{ PMICMD_INB,   MONO_DATAPORT,  NONE, NONE, 3, NONE,           NULL   }, /*          */
//{ PMICMD_OUTB,  MONO_DATAPORT,  NONE, NONE, 0, WRITEONLY_DATA, "\x48" }, /*          */
  { PMICMD_OUTB,  CRT_INDEXPORT,  NONE, NONE, 0, WRITEONLY_DATA, "\x39" }, /*          */
  { PMICMD_INB,   CRT_DATAPORT,   NONE, NONE, 4, NONE,           NULL   }, /*          */
  { PMICMD_OUTB,  CRT_DATAPORT,   NONE, NONE, 0, WRITEONLY_DATA, "\xa5" }, /*          */
//{ PMICMD_OUTB,  MONO_INDEXPORT, NONE, NONE, 0, WRITEONLY_DATA, "\x39" }, /*          */
//{ PMICMD_INB,   MONO_DATAPORT,  NONE, NONE, 5, NONE,           NULL   }, /*          */
//{ PMICMD_OUTB,  MONO_DATAPORT,  NONE, NONE, 0, WRITEONLY_DATA, "\xa5" }, /*          */
  { PMICMD_OUTB,  CRT_INDEXPORT,  NONE, NONE, 0, WRITEONLY_DATA, "\x40" }, /*          */
  { PMICMD_INB,   CRT_DATAPORT,   NONE, NONE, 6, NONE,           NULL   }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT,  CRT_DATAPORT, 0x40, 0xFE, WRITEONLY_DATA, b_1 }, /*          */
//{ PMICMD_OUTB,  MONO_INDEXPORT, NONE, NONE, 0, WRITEONLY_DATA, "\x40" }, /*          */
//{ PMICMD_INB,   MONO_DATAPORT,  NONE, NONE, 7, NONE,           NULL   }, /*          */
//{ PMICMD_RMWBI, MONO_INDEXPORT, MONO_DATAPORT, 0x40, 0xFE, WRITEONLY_DATA, b_1 }, /*          */
//{ PMICMD_OUTB,  MONO_INDEXPORT, NONE, NONE, 1, WRITEREG_DATA,  NULL   }, /*          */
  { PMICMD_OUTB,  CRT_INDEXPORT,  NONE, NONE, 0, WRITEREG_DATA,  NULL   },
  { PMICMD_NONE },
};

/*
**
**              Chipset Cleanup Information
**
*/

REGDATA S3CleanData[] =
{                                     /* S3 Cleanups */
//  { PMICMD_RMWWN, S3_ADVFUNC_CNTL, S3_ADVFUNC_CNTL, 0x00, 0x00, WRITEONLY_DATA, b_0 },//          
  { PMICMD_OUTW, S3_ADVFUNC_CNTL, NONE, NONE, 0x00, WRITEONLY_DATA, b_2 },//          
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x31, 0xf7, WRITEONLY_DATA, b_0 },
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x34, 0x00, WRITEONLY_DATA, b_0 },
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x3a, 0xef, WRITEONLY_DATA, b_0 },
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x40, 0xfe, WRITEONLY_DATA, b_0 }, //          
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x45, 0xfe, WRITEONLY_DATA, b_0 },
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x51, 0xf3, WRITEONLY_DATA, b_0 },
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x58, 0xec, WRITEONLY_DATA, b_0 },
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x59, 0x00, WRITEONLY_DATA, "\x0a" },    /*            */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x5A, 0x00, WRITEONLY_DATA, b_0 },       /*            */
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x60, 0x00, WRITEONLY_DATA, b_7 },
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x61, 0x00, WRITEONLY_DATA, "\x80" },
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x62, 0x00, WRITEONLY_DATA, "\xa1" },
  { PMICMD_NONE },
};

/*
**
**              Chipset Setbank Information
**
**              Set/Get Banks are based on svgabank.asm in screendd
**              of Picard.           
**
**              Registers are unlocked already and always set/get
**              write bank only.
**
*/

REGDATA S3SetBankCmd1[] =
/*************************  Picard w/o 911/924 support 2/8/94
S3                         ;Up to 4MB              fixing
  r0 = 0;
  inb(r1, 0x3d4);          ;save CRTC index
  rmwbi(0x3d4,0x3d5,0x31,0xf6,0x09);
  rmwbi(0x3d4,0x3d5,0x40,0xf7,0x08);
  rmwbi(0x3d4,0x3d5,0x58,0xff,0x10);
  inb(r2, 0x3d5);
  r2 &= 0x0f0;
  r3  = r0 & 0x0f;
  r3 |= r2;
  outb(0x3d5, r3);
  outb(0x3d4, 0x51);
  inb(r2, 0x3d5);
  r2 &= 0xF3;
  r3 = r0 & 0x30;
  r3 >>= 0x02;
  r3 |= r2;
  outb(0x3d5, r3);          ;set bank
  outb(0x3d4, r1);          ;restore CRTC index
***************************************************************/
{
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x00, WRITEONLY_DATA, b_0 },
    { PMICMD_INB, CRT_INDEXPORT, NONE, NONE, 1, NONE, NULL },
    { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x31, 0xf6, WRITEONLY_DATA, "\x09"},
    { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x40, 0xf7, WRITEONLY_DATA, "\x08" }, /*          */
    { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x58, 0xff, WRITEONLY_DATA, "\x10" },
    { PMICMD_OUTB, CRT_INDEXPORT, NONE, NONE, 0, WRITEONLY_DATA, "\x35" },
    { PMICMD_INB, CRT_DATAPORT, NONE, NONE, 2, NONE, NULL },
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x02, REGISTER_OPEQUAL|REGISTER_AND, "\xF0" },
    { PMICMD_REGOP, 0x00, NONE, 0x01, 0x03, REGISTER_OPERAND|REGISTER_AND, "\x0F" },
    { PMICMD_REGOP, 0x02, NONE, 0x01, 0x03, REGISTER_OPERAND|REGISTER_OPEQUAL|REGISTER_OR, NULL },
    { PMICMD_OUTB, CRT_DATAPORT, NONE, NONE, 0x03, WRITEREG_DATA },
    { PMICMD_OUTB, CRT_INDEXPORT, NONE, NONE, 0, WRITEONLY_DATA, "\x51" },
    { PMICMD_INB, CRT_DATAPORT, NONE, NONE, 2, NONE, NULL },
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x02, REGISTER_OPEQUAL|REGISTER_AND, "\xF3" },
    { PMICMD_REGOP, 0x00, NONE, 0x01, 0x03, REGISTER_OPERAND|REGISTER_AND, "\x30" },
    { PMICMD_REGOP, 0x00, NONE, 0x01, 0x03, REGISTER_OPEQUAL|REGISTER_SHR, b_2 },
    { PMICMD_REGOP, 0x02, NONE, 0x01, 0x03, REGISTER_OPEQUAL|REGISTER_OPERAND|REGISTER_OR },
    { PMICMD_OUTB, CRT_DATAPORT, NONE, NONE, 0x03, WRITEREG_DATA },
    { PMICMD_OUTB, CRT_INDEXPORT, NONE, NONE, 1, WRITEREG_DATA },
    { PMICMD_NONE },
};

REGDATA S3SetBankCmd2[] =
/*************************  for 864 and 964
S3                         ;Up to 8MB on 964
  r0 = 0;
  inb(r1, 0x3d4);          ;save CRTC index
  rmwbi(0x3d4,0x3d5,0x31,0xf6,0x09);
  outb(0x3d4, 0x6a);       ;
  outb(0x3d5, r0);         ;set bank

  rmwbi(0x3d4,0x3d5,0x40,0xf7,0x08);
  rmwbi(0x3d4,0x3d5,0x58,0xff,0x10);
  outb(0x3d4, 0x35);
  inb(r2, 0x3d5);
  r2 &= 0x0f0;
  r3  = r0 & 0x0f;
  r3 |= r2;
  outb(0x3d5, r3);
  outb(0x3d4, 0x51);
  inb(r2, 0x3d5);
  r2 &= 0xF3;
  r3 = r0 & 0x30;
  r3 >>= 0x02;
  r3 |= r2;
  outb(0x3d5, r3);          ;set bank
  outb(0x3d4, r1);         ;restore CRTC index
***************************************************************/
{
    { PMICMD_REGOP, NONE,          NONE, 0x01, 0x00, WRITEONLY_DATA, b_0 },
    { PMICMD_INB,   CRT_INDEXPORT, NONE, NONE, 0x01, NONE,           NULL },
    { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x31, 0xf6, WRITEONLY_DATA, "\x09"},
    { PMICMD_OUTB,  CRT_INDEXPORT, NONE, NONE, 0x00, WRITEONLY_DATA, "\x6a" },
    { PMICMD_OUTB,  CRT_DATAPORT,  NONE, NONE, 0x00, WRITEREG_DATA },
    { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x40, 0xf7, WRITEONLY_DATA, "\x08" },
    { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x58, 0xff, WRITEONLY_DATA, "\x10" },
    { PMICMD_OUTB, CRT_INDEXPORT, NONE, NONE, 0, WRITEONLY_DATA, "\x35" },
    { PMICMD_INB, CRT_DATAPORT, NONE, NONE, 2, NONE, NULL },
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x02, REGISTER_OPEQUAL|REGISTER_AND, "\xF0" },
    { PMICMD_REGOP, 0x00, NONE, 0x01, 0x03, REGISTER_OPERAND|REGISTER_AND, "\x0F" },
    { PMICMD_REGOP, 0x02, NONE, 0x01, 0x03, REGISTER_OPERAND|REGISTER_OPEQUAL|REGISTER_OR, NULL },
    { PMICMD_OUTB, CRT_DATAPORT, NONE, NONE, 0x03, WRITEREG_DATA },
    { PMICMD_OUTB, CRT_INDEXPORT, NONE, NONE, 0, WRITEONLY_DATA, "\x51" },
    { PMICMD_INB, CRT_DATAPORT, NONE, NONE, 2, NONE, NULL },
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x02, REGISTER_OPEQUAL|REGISTER_AND, "\xF3" },
    { PMICMD_REGOP, 0x00, NONE, 0x01, 0x03, REGISTER_OPERAND|REGISTER_AND, "\x30" },
    { PMICMD_REGOP, 0x00, NONE, 0x01, 0x03, REGISTER_OPEQUAL|REGISTER_SHR, b_2 },
    { PMICMD_REGOP, 0x02, NONE, 0x01, 0x03, REGISTER_OPEQUAL|REGISTER_OPERAND|REGISTER_OR },
    { PMICMD_OUTB, CRT_DATAPORT, NONE, NONE, 0x03, WRITEREG_DATA },
    { PMICMD_OUTB,  CRT_INDEXPORT, NONE, NONE, 0x01, WRITEREG_DATA },
    { PMICMD_NONE },
};

/*
**
**              Chipset Getbank Information            
**
*/

REGDATA S3GetBankCmd1[] =
/***********************  w/o 911/924 support Picard 2/8/94
-----------------------------------------------
S3
    inb(r1, 0x3d4);  save index

    outb(0x3d4, 0x35);     getbank
    inb(r0, 0x3d5);
    r0 &= 0x0f;

    ; if extended register r0 |= 0x10;

    outb (0x3d4, 0x51);
    inb (r2, 0x3d5);
    r2 &= 0x04;          ; extended bank bit set?
    r2 <<= 0x02;         ; make it 0x10
    r0 |= r2;

    outb(0x3d4, r1); restore index
***************************************************************/
{
    { PMICMD_INB, CRT_INDEXPORT, NONE, NONE, 1, NONE, NULL },
    { PMICMD_OUTB, CRT_INDEXPORT, NONE, NONE, 0, WRITEONLY_DATA, "\x35" },
    { PMICMD_INB, CRT_DATAPORT, NONE, NONE, 0, NONE, NULL },
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x00, REGISTER_OPEQUAL|REGISTER_AND, b_F },
    { PMICMD_OUTB, CRT_INDEXPORT, NONE, NONE, 0, WRITEONLY_DATA, "\x51" },
    { PMICMD_INB, CRT_DATAPORT, NONE, NONE, 2, NONE, NULL },
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x02, REGISTER_OPEQUAL|REGISTER_AND, b_4 },
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x02, REGISTER_OPEQUAL|REGISTER_SHL, b_2 },
    { PMICMD_REGOP, 0x02, NONE, 0x01, 0x00, REGISTER_OPEQUAL|REGISTER_OPERAND|REGISTER_OR },
    { PMICMD_OUTB, CRT_INDEXPORT, NONE, NONE, 1, WRITEREG_DATA },
    { PMICMD_NONE },
};

REGDATA S3GetBankCmd2[] =
/***********************  for 864/964
-----------------------------------------------
S3
    inb(r1, 0x3d4);  save index

    outb(0x3d4, 0x6a);     getbank
    inb(r0, 0x3d5);        r2 has value from CR6a

    ; now get it the old way in case 6a=0

    outb(0x3d4, 0x35);     getbank
    inb(r3, 0x3d5);
    r3 &= 0x0f;

    ; if extended register r0 |= 0x10;

    outb (0x3d4, 0x51);
    inb (r4, 0x3d5);
    r4 &= 0x0C;          ; extended bank bits set?
    r4 <<= 0x02;         ; shift to high nibble
    r3 |= r4;            ; r3 has value from CR35 and CR51

    ; should we return r2 or r3?
    r2 = r0;
    r2 <<= 0x03;
    r3 >>= r2;           ; return r3 if r0=0
    r0 |= r3;            ; return r0 if something there

    outb(0x3d4, r1); restore index
***************************************************************/
{
    { PMICMD_INB, CRT_INDEXPORT, NONE, NONE, 1, NONE, NULL },
    { PMICMD_OUTB, CRT_INDEXPORT, NONE, NONE, 0, WRITEONLY_DATA, "\x6a" },
    { PMICMD_INB, CRT_DATAPORT, NONE, NONE, 0, NONE, NULL },
    { PMICMD_OUTB, CRT_INDEXPORT, NONE, NONE, 0, WRITEONLY_DATA, "\x35" },
    { PMICMD_INB, CRT_DATAPORT, NONE, NONE, 3, NONE, NULL },
    { PMICMD_REGOP, 0x00, NONE, 0x01, 0x03, REGISTER_OPERAND|REGISTER_AND, "\x0F" },
    { PMICMD_OUTB, CRT_INDEXPORT, NONE, NONE, 0, WRITEONLY_DATA, "\x51" },
    { PMICMD_INB, CRT_DATAPORT, NONE, NONE, 4, NONE, NULL },
    { PMICMD_REGOP, 0x00, NONE, 0x01, 0x04, REGISTER_OPEQUAL|REGISTER_AND, "\x0C" },
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x04, REGISTER_OPEQUAL|REGISTER_SHL, b_2 },
    { PMICMD_REGOP, 0x04, NONE, 0x01, 0x03, REGISTER_OPEQUAL|REGISTER_OPERAND|REGISTER_OR },
    { PMICMD_REGOP, 0x00, NONE, 0x01, 0x02, REGISTER_OPERAND},
    { PMICMD_REGOP, 0x03, NONE, 0x01, 0x02, REGISTER_OPEQUAL|REGISTER_SHL, b_3 },
    { PMICMD_REGOP, 0x02, NONE, 0x01, 0x03, REGISTER_OPEQUAL|REGISTER_OPERAND|REGISTER_SHR },
    { PMICMD_REGOP, 0x03, NONE, 0x01, 0x00, REGISTER_OPEQUAL|REGISTER_OPERAND|REGISTER_OR },
    { PMICMD_OUTB, CRT_INDEXPORT, NONE, NONE, 1, WRITEREG_DATA },
    { PMICMD_NONE },
};

/*
**      Standard VGA Chipset - for GENERIC use only.
*/


BANKROUTINE S3SetBank1 = {"SetBankLinear", S3SetBankCmd1};
BANKROUTINE S3GetBank1 = {"GetBankLinear", S3GetBankCmd1};
BANKROUTINE S3SetBank2 = {"SetBankLinear", S3SetBankCmd2};
BANKROUTINE S3GetBank2 = {"GetBankLinear", S3GetBankCmd2};

/*
**
**              Chipset Mode Information
**
*/

REGDATA S3ModeSet1a [] =
{
  { PMICMD_OUTB,  MISCOUTPUTREG_WRITE, NONE,   0x00, 0x00, WRITEONLY_DATA, &MiscOutRegData }, /*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x05, 0x00, READWRITE_DATA, &SEQRegData[0x00] },
  { PMICMD_OUTW,  SEQ_INDEXPORT, NONE, NONE, 0x00, WRITEONLY_DATA, &bEndSEQReset[0] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x19, 0x00, READWRITE_DATA, &CRTRegData[0x00] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x05, 0x31, READWRITE_DATA, &CRTRegData[0x31] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x03, 0x3a, READWRITE_DATA, &CRTRegData[0x3a] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x01, 0x40, READWRITE_DATA, &CRTRegData[0x40] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x01, 0x43, READWRITE_DATA, &CRTRegData[0x43] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x05, 0x45, READWRITE_DATA, &CRTRegData[0x45] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x04, 0x4c, READWRITE_DATA, &CRTRegData[0x4c] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x01, 0x42, READWRITE_DATA, &CRTRegData[0x42] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x0b, 0x50, READWRITE_DATA, &CRTRegData[0x50] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x03, 0x5c, READWRITE_DATA, &CRTRegData[0x5c] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x03, 0x60, READWRITE_DATA, &CRTRegData[0x60] },
  { PMICMD_CALL, CALL_MONITOR_TIMINGS            ,0,0x0000,0x0000,0x0000,NULL},/*            */
  { PMICMD_BOUTB, ATC_INDEXPORT, ATC_DATAPORT, 0x15, 0x00, READWRITE_DATA, &ATCRegData[0x00] },
  { PMICMD_BOUTB, GDC_INDEXPORT, GDC_DATAPORT, 0x09, 0x00, READWRITE_DATA, &GDCRegData[0x00] },

  { PMICMD_WAITW, A8514_STATUS,     0x0200, NONE, 100,  0x0000 } , /*          */
  { PMICMD_OUTW,  S3_ADVFUNC_CNTL,  NONE,   NONE, 0x00, WRITEONLY_DATA, "\x07\x00" },
  { PMICMD_OUTW,  S3_MULTIFUNCTION, NONE,   NONE, 0x00, WRITEONLY_DATA, "\x00\x10" },
  { PMICMD_OUTW,  S3_MULTIFUNCTION, NONE,   NONE, 0x00, WRITEONLY_DATA, "\xff\x33" },
  { PMICMD_OUTW,  S3_MULTIFUNCTION, NONE,   NONE, 0x00, WRITEONLY_DATA, "\x00\x20" },
  { PMICMD_OUTW,  S3_MULTIFUNCTION, NONE,   NONE, 0x00, WRITEONLY_DATA, "\xff\x43" },
  { PMICMD_OUTW,  S3_MULTIFUNCTION, NONE,   NONE, 0x00, WRITEONLY_DATA, "\x00\xa0" },
  { PMICMD_OUTW,  S3_MULTIFUNCTION, NONE,   NONE, 0x00, WRITEONLY_DATA, "\xff\x03" },
  { PMICMD_OUTW,  S3_MAX_AXIS_PCNT, NONE,   NONE, 0x00, WRITEONLY_DATA, "\xff\x03" },
  { PMICMD_OUTW,  S3_CUR_X,         NONE,   NONE, 0x00, WRITEONLY_DATA, b_0 },
  { PMICMD_OUTW,  S3_CUR_Y,         NONE,   NONE, 0x00, WRITEONLY_DATA, b_0 },
  { PMICMD_NONE }
};

REGDATA S3ModeSet1b [] =
{
  { PMICMD_OUTB,  MISCOUTPUTREG_WRITE, NONE,   0x00, 0x00, WRITEONLY_DATA, &MiscOutRegData }, /*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x05, 0x00, READWRITE_DATA, &SEQRegData[0x00] },
  { PMICMD_OUTW,  SEQ_INDEXPORT, NONE,         NONE, 0x00, WRITEONLY_DATA, &bEndSEQReset[0]  },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x19, 0x00, READWRITE_DATA, &CRTRegData[0x00] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x05, 0x31, READWRITE_DATA, &CRTRegData[0x31] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x03, 0x3a, READWRITE_DATA, &CRTRegData[0x3a] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x01, 0x40, READWRITE_DATA, &CRTRegData[0x40] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x01, 0x43, READWRITE_DATA, &CRTRegData[0x43] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x05, 0x45, READWRITE_DATA, &CRTRegData[0x45] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x04, 0x4c, READWRITE_DATA, &CRTRegData[0x4c] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x01, 0x42, READWRITE_DATA, &CRTRegData[0x42] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x0b, 0x50, READWRITE_DATA, &CRTRegData[0x50] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x03, 0x5c, READWRITE_DATA, &CRTRegData[0x5c] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x03, 0x60, READWRITE_DATA, &CRTRegData[0x60] },
  { PMICMD_CALL, CALL_MONITOR_TIMINGS            ,0,0x0000,0x0000,0x0000,NULL},/*            */
  { PMICMD_BOUTB, ATC_INDEXPORT, ATC_DATAPORT, 0x15, 0x00, READWRITE_DATA, &ATCRegData[0x00] },
  { PMICMD_BOUTB, GDC_INDEXPORT, GDC_DATAPORT, 0x09, 0x00, READWRITE_DATA, &GDCRegData[0x00] },

  { PMICMD_WAITW, A8514_STATUS,     0x0200, NONE, 100,  0x0000 }, /*          */
  { PMICMD_OUTW,  S3_ADVFUNC_CNTL,  NONE,   NONE, 0x00, WRITEONLY_DATA, "\x01\x00" },
  { PMICMD_OUTW,  S3_MULTIFUNCTION, NONE,   NONE, 0x00, WRITEONLY_DATA, "\x00\x10" },
  { PMICMD_OUTW,  S3_MULTIFUNCTION, NONE,   NONE, 0x00, WRITEONLY_DATA, "\xff\x33" },
  { PMICMD_OUTW,  S3_MULTIFUNCTION, NONE,   NONE, 0x00, WRITEONLY_DATA, "\x00\x20" },
  { PMICMD_OUTW,  S3_MULTIFUNCTION, NONE,   NONE, 0x00, WRITEONLY_DATA, "\xff\x43" },
  { PMICMD_OUTW,  S3_MULTIFUNCTION, NONE,   NONE, 0x00, WRITEONLY_DATA, "\x00\xa0" },
  { PMICMD_OUTW,  S3_MULTIFUNCTION, NONE,   NONE, 0x00, WRITEONLY_DATA, "\xff\x03" },
  { PMICMD_OUTW,  S3_MAX_AXIS_PCNT, NONE,   NONE, 0x00, WRITEONLY_DATA, "\xff\x03" },
  { PMICMD_OUTW,  S3_CUR_X,         NONE,   NONE, 0x00, WRITEONLY_DATA, b_0 },
  { PMICMD_OUTW,  S3_CUR_Y,         NONE,   NONE, 0x00, WRITEONLY_DATA, b_0 },
  { PMICMD_NONE }
};

REGDATA S3ModeSet1c [] =
{
  { PMICMD_OUTB,  MISCOUTPUTREG_WRITE, NONE,   0x00, 0x00, WRITEONLY_DATA, &MiscOutRegData }, /*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x05, 0x00, READWRITE_DATA, &SEQRegData[0x00] },
  { PMICMD_OUTW,  SEQ_INDEXPORT, NONE, NONE, 0x00, WRITEONLY_DATA, &bEndSEQReset[0] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x19, 0x00, READWRITE_DATA, &CRTRegData[0x00] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x05, 0x31, READWRITE_DATA, &CRTRegData[0x31] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x03, 0x3a, READWRITE_DATA, &CRTRegData[0x3a] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x01, 0x40, READWRITE_DATA, &CRTRegData[0x40] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x01, 0x43, READWRITE_DATA, &CRTRegData[0x43] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x05, 0x45, READWRITE_DATA, &CRTRegData[0x45] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x04, 0x4c, READWRITE_DATA, &CRTRegData[0x4c] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x01, 0x42, READWRITE_DATA, &CRTRegData[0x42] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x0b, 0x50, READWRITE_DATA, &CRTRegData[0x50] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x03, 0x5c, READWRITE_DATA, &CRTRegData[0x5c] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x03, 0x60, READWRITE_DATA, &CRTRegData[0x60] },
  { PMICMD_CALL, CALL_MONITOR_TIMINGS            ,0,0x0000,0x0000,0x0000,NULL},/*            */
  { PMICMD_BOUTB, ATC_INDEXPORT, ATC_DATAPORT, 0x15, 0x00, READWRITE_DATA, &ATCRegData[0x00] },
  { PMICMD_BOUTB, GDC_INDEXPORT, GDC_DATAPORT, 0x09, 0x00, READWRITE_DATA, &GDCRegData[0x00] },

  { PMICMD_WAITW, A8514_STATUS,    0x0200,       NONE, 100,  0x0000 }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT,   CRT_DATAPORT, 0x40, 0xfe, WRITEONLY_DATA, b_1 },
  { PMICMD_OUTW,  S3_ADVFUNC_CNTL, NONE,         NONE, 0x00, WRITEONLY_DATA, b_0 },
  { PMICMD_RMWBI, CRT_INDEXPORT,   CRT_DATAPORT, 0x40, 0xfe, WRITEONLY_DATA, b_0 },
  { PMICMD_NONE }
};

CHIPINFO S3ChipSet1[] =
{
  {
    VGAMODE,
    &ChipInfoHeader[GRAPHICS_640x480x16],
    &S3SetBank1,
    &S3GetBank1,
    S3ModeSet1c,                //                  S3ModeSet1a
    0,                          /*JWK10*/
  },
  {
    VESA_640_480_256,
    &ChipInfoHeader[GRAPHICS_640x480x256],
    &S3SetBank1,
    &S3GetBank1,
    S3ModeSet1b,
    0,                          /*JWK10*/
  },
  {
    VESA_640_480_64K,
    &ChipInfoHeader[GRAPHICS_640x480x64K],
    &S3SetBank1,
    &S3GetBank1,
    S3ModeSet1b,
    0,                          /*JWK10*/
  },
  {
    VESA_640_480_16M,
    &ChipInfoHeader[GRAPHICS_640x480x16M],
    &S3SetBank1,
    &S3GetBank1,
    S3ModeSet1b,
    0,                          /*JWK10*/
  },
  {
    VESA_800_600_16,
    &ChipInfoHeader[GRAPHICS_800x600x16],
    &S3SetBank1,
    &S3GetBank1,
    S3ModeSet1c,                //              S3ModeSet1a
    0,                          /*JWK10*/
  },
  {
    VESA_800_600_256,
    &ChipInfoHeader[GRAPHICS_800x600x256],
    &S3SetBank1,
    &S3GetBank1,
    S3ModeSet1b,
    0,                          /*JWK10*/
  },
  {
    VESA_800_600_64K,
    &ChipInfoHeader[GRAPHICS_800x600x64K],
    &S3SetBank1,
    &S3GetBank1,
    S3ModeSet1b,
    0,                          /*JWK10*/
  },
//{
//  VESA_800_600_16M,
//  &ChipInfoHeader[GRAPHICS_800x600x16M],
//  &S3SetBank1,
//  &S3GetBank1,
//  S3ModeSet1b,
//  0,                          /*JWK10*/
//},
  {
    VESA_1024_768_16,
    &ChipInfoHeader[GRAPHICS_1024x768x16],
    &S3SetBank1,
    &S3GetBank1,
    S3ModeSet1a,
    0,                          /*JWK10*/
  },
  {
    VESA_1024_768_256,
    &ChipInfoHeader[GRAPHICS_1024x768x256],
    &S3SetBank1,
    &S3GetBank1,
    S3ModeSet1a,                //              S3ModeSet1b
    0,                          /*JWK10*/
  },
  {
    VESA_1024_768_64K,
    &ChipInfoHeader[GRAPHICS_1024x768x64K],
    &S3SetBank1,
    &S3GetBank1,
    S3ModeSet1a,                //              S3ModeSet1b
    0,                          /*JWK10*/
  },
//{
//  VESA_1024_768_16M,
//  &ChipInfoHeader[GRAPHICS_1024x768x16M],
//  &S3SetBank1,
//  &S3GetBank1,
//  S3ModeSet1a,                //              S3ModeSet1b
//  0,                          /*JWK10*/
//},
//{
//  S3_1152_864_256,
//  &ChipInfoHeader[GRAPHICS_1152x864x256],
//  &S3SetBank1,
//  &S3GetBank1,
//  S3ModeSet1a,                //              S3ModeSet1b
//  0,                          /*JWK10*/
//},
  {
    VESA_1280_1024_256,
    &ChipInfoHeader[GRAPHICS_1280x1024x256],
    &S3SetBank1,
    &S3GetBank1,
    S3ModeSet1b,
    0,                          /*JWK10*/
  },
//{
//  VESA_1280_1024_64K,
//  &ChipInfoHeader[GRAPHICS_1280x1024x64K],
//  &S3SetBank1,
//  &S3GetBank1,
//  S3ModeSet1b,
//  0,                          /*JWK10*/
//},
  {
    VESA_1600_1200_256,
    &ChipInfoHeader[GRAPHICS_1600x1200x256],
    &S3SetBank1,
    &S3GetBank1,
    S3ModeSet1a,                //              S3ModeSet1b
    0,                          /*JWK10*/
  },
  {
    0x01,
    &ChipInfoHeader[TEXT_40x25],
    &S3SetBank1,
    &S3GetBank1,
    S3ModeSet1c,
    0,                          /*JWK10*/
   },
  {
    0x03,
    &ChipInfoHeader[TEXT_80x25],
    &S3SetBank1,
    &S3GetBank1,
    S3ModeSet1c,
    0,                          /*JWK10*/
  },
  {
    VESA_TEXT_132_25,
    &ChipInfoHeader[TEXT_132x25],
    &S3SetBank1,
    &S3GetBank1,
    S3ModeSet1c,
    0,                          /*JWK10*/
  },
  {
    VESA_TEXT_132_43,
    &ChipInfoHeader[TEXT_132x43],
    &S3SetBank1,
    &S3GetBank1,
    S3ModeSet1c,
    0,                          /*JWK10*/
  },
};

USHORT usSizeS3ChipSet1 = sizeof(S3ChipSet1)/sizeof(CHIPINFO);


REGDATA S3ModeSet2a [] =
{
  { PMICMD_OUTB,  MISCOUTPUTREG_WRITE, NONE,   0x00, 0x00, WRITEONLY_DATA, &MiscOutRegData }, /*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x05, 0x00, READWRITE_DATA, &SEQRegData[0x00] },
  { PMICMD_OUTW,  SEQ_INDEXPORT, NONE, NONE, 0x00, WRITEONLY_DATA, &bEndSEQReset[0] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x19, 0x00, READWRITE_DATA, &CRTRegData[0x00] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x05, 0x31, READWRITE_DATA, &CRTRegData[0x31] }, /*@V3.0MNH01*/
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x36, 0xe0, READWRITE_DATA, &CRTRegData[0x36] }, /*@V3.0MNH01*/
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x03, 0x3a, READWRITE_DATA, &CRTRegData[0x3a] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x01, 0x40, READWRITE_DATA, &CRTRegData[0x40] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x01, 0x43, READWRITE_DATA, &CRTRegData[0x43] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x05, 0x45, READWRITE_DATA, &CRTRegData[0x45] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x04, 0x4c, READWRITE_DATA, &CRTRegData[0x4c] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x01, 0x42, READWRITE_DATA, &CRTRegData[0x42] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x1e, 0x50, READWRITE_DATA, &CRTRegData[0x50] },
  { PMICMD_BOUTB, ATC_INDEXPORT, ATC_DATAPORT, 0x15, 0x00, READWRITE_DATA, &ATCRegData[0x00] },
  { PMICMD_BOUTB, GDC_INDEXPORT, GDC_DATAPORT, 0x09, 0x00, READWRITE_DATA, &GDCRegData[0x00] },

  { PMICMD_WAITW, A8514_STATUS,     0x0200, NONE, 100,  0x0000 }, /*          */
  { PMICMD_OUTW,  S3_ADVFUNC_CNTL,  NONE,   NONE, 0x00, WRITEONLY_DATA, "\x07\x00" },
  { PMICMD_OUTW,  S3_MULTIFUNCTION, NONE,   NONE, 0x00, WRITEONLY_DATA, "\x00\x10" },
  { PMICMD_OUTW,  S3_MULTIFUNCTION, NONE,   NONE, 0x00, WRITEONLY_DATA, "\xff\x33" },
  { PMICMD_OUTW,  S3_MULTIFUNCTION, NONE,   NONE, 0x00, WRITEONLY_DATA, "\x00\x20" },
  { PMICMD_OUTW,  S3_MULTIFUNCTION, NONE,   NONE, 0x00, WRITEONLY_DATA, "\xff\x43" },
  { PMICMD_OUTW,  S3_MULTIFUNCTION, NONE,   NONE, 0x00, WRITEONLY_DATA, "\x00\xa0" },
  { PMICMD_OUTW,  S3_MULTIFUNCTION, NONE,   NONE, 0x00, WRITEONLY_DATA, "\xff\x03" },
  { PMICMD_OUTW,  S3_MAX_AXIS_PCNT, NONE,   NONE, 0x00, WRITEONLY_DATA, "\xff\x03" },
  { PMICMD_OUTW,  S3_CUR_X,         NONE,   NONE, 0x00, WRITEONLY_DATA, b_0 },
  { PMICMD_OUTW,  S3_CUR_Y,         NONE,   NONE, 0x00, WRITEONLY_DATA, b_0 },
  { PMICMD_CALL,  CALL_MONITOR_TIMINGS            ,0,0x0000,0x0000,0x0000,NULL},/*            */
  { PMICMD_NONE }
};

REGDATA S3ModeSet2b [] =
{
  { PMICMD_OUTB,  MISCOUTPUTREG_WRITE, NONE,   0x00, 0x00, WRITEONLY_DATA, &MiscOutRegData }, /*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x05, 0x00, READWRITE_DATA, &SEQRegData[0x00] },
  { PMICMD_OUTW,  SEQ_INDEXPORT, NONE, NONE, 0x00, WRITEONLY_DATA, &bEndSEQReset[0] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x19, 0x00, READWRITE_DATA, &CRTRegData[0x00] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x05, 0x31, READWRITE_DATA, &CRTRegData[0x31] }, /*@V3.0MNH01*/
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x36, 0xe0, READWRITE_DATA, &CRTRegData[0x36] }, /*@V3.0MNH01*/
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x03, 0x3a, READWRITE_DATA, &CRTRegData[0x3a] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x01, 0x40, READWRITE_DATA, &CRTRegData[0x40] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x01, 0x43, READWRITE_DATA, &CRTRegData[0x43] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x05, 0x45, READWRITE_DATA, &CRTRegData[0x45] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x04, 0x4c, READWRITE_DATA, &CRTRegData[0x4c] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x01, 0x42, READWRITE_DATA, &CRTRegData[0x42] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x1e, 0x50, READWRITE_DATA, &CRTRegData[0x50] },
  { PMICMD_BOUTB, ATC_INDEXPORT, ATC_DATAPORT, 0x15, 0x00, READWRITE_DATA, &ATCRegData[0x00] },
  { PMICMD_BOUTB, GDC_INDEXPORT, GDC_DATAPORT, 0x09, 0x00, READWRITE_DATA, &GDCRegData[0x00] },

  { PMICMD_WAITW, A8514_STATUS,     0x0200, NONE, 100,  0x0000 }, /*          */
  { PMICMD_OUTW,  S3_ADVFUNC_CNTL,  NONE,   NONE, 0x00, WRITEONLY_DATA, "\x01\x00" },
  { PMICMD_OUTW,  S3_MULTIFUNCTION, NONE,   NONE, 0x00, WRITEONLY_DATA, "\x00\x10" },
  { PMICMD_OUTW,  S3_MULTIFUNCTION, NONE,   NONE, 0x00, WRITEONLY_DATA, "\xff\x33" },
  { PMICMD_OUTW,  S3_MULTIFUNCTION, NONE,   NONE, 0x00, WRITEONLY_DATA, "\x00\x20" },
  { PMICMD_OUTW,  S3_MULTIFUNCTION, NONE,   NONE, 0x00, WRITEONLY_DATA, "\xff\x43" },
  { PMICMD_OUTW,  S3_MULTIFUNCTION, NONE,   NONE, 0x00, WRITEONLY_DATA, "\x00\xa0" },
  { PMICMD_OUTW,  S3_MULTIFUNCTION, NONE,   NONE, 0x00, WRITEONLY_DATA, "\xff\x03" },
  { PMICMD_OUTW,  S3_MAX_AXIS_PCNT, NONE,   NONE, 0x00, WRITEONLY_DATA, "\xff\x03" },
  { PMICMD_OUTW,  S3_CUR_X,         NONE,   NONE, 0x00, WRITEONLY_DATA, b_0 },
  { PMICMD_OUTW,  S3_CUR_Y,         NONE,   NONE, 0x00, WRITEONLY_DATA, b_0 },
  { PMICMD_CALL,  CALL_MONITOR_TIMINGS            ,0,0x0000,0x0000,0x0000,NULL},/*            */
  { PMICMD_NONE }
};

REGDATA S3ModeSet2c [] =
{
  { PMICMD_OUTB,  MISCOUTPUTREG_WRITE, NONE,   0x00, 0x00, WRITEONLY_DATA, &MiscOutRegData }, /*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x05, 0x00, READWRITE_DATA, &SEQRegData[0x00] },
  { PMICMD_OUTW,  SEQ_INDEXPORT, NONE, NONE, 0x00, WRITEONLY_DATA, &bEndSEQReset[0] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x19, 0x00, READWRITE_DATA, &CRTRegData[0x00] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x05, 0x31, READWRITE_DATA, &CRTRegData[0x31] }, /*@V3.0MNH01*/
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x36, 0xe0, READWRITE_DATA, &CRTRegData[0x36] }, /*@V3.0MNH01*/
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x03, 0x3a, READWRITE_DATA, &CRTRegData[0x3a] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x01, 0x40, READWRITE_DATA, &CRTRegData[0x40] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x01, 0x43, READWRITE_DATA, &CRTRegData[0x43] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x05, 0x45, READWRITE_DATA, &CRTRegData[0x45] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x04, 0x4c, READWRITE_DATA, &CRTRegData[0x4c] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x01, 0x42, READWRITE_DATA, &CRTRegData[0x42] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x1e, 0x50, READWRITE_DATA, &CRTRegData[0x50] },
  { PMICMD_BOUTB, ATC_INDEXPORT, ATC_DATAPORT, 0x15, 0x00, READWRITE_DATA, &ATCRegData[0x00] },
  { PMICMD_BOUTB, GDC_INDEXPORT, GDC_DATAPORT, 0x09, 0x00, READWRITE_DATA, &GDCRegData[0x00] },

  { PMICMD_WAITW, A8514_STATUS,    0x0200,       NONE, 100,  0x0000 }, /*          */
  { PMICMD_RMWBI, CRT_INDEXPORT,   CRT_DATAPORT, 0x40, 0xfe, WRITEONLY_DATA, b_1 },
  { PMICMD_OUTW,  S3_ADVFUNC_CNTL, NONE,         NONE, 0x00, WRITEONLY_DATA, b_0 },
  { PMICMD_RMWBI, CRT_INDEXPORT,   CRT_DATAPORT, 0x40, 0xfe, WRITEONLY_DATA, b_0 },
  { PMICMD_CALL,  CALL_MONITOR_TIMINGS            ,0,0x0000,0x0000,0x0000,NULL},/*            */
  { PMICMD_NONE }
};

CHIPINFO S3ChipSet2[] =
{
  {
    VGAMODE,
    &ChipInfoHeader[GRAPHICS_640x480x16],
    &S3SetBank2,
    &S3GetBank2,
    S3ModeSet2c,
    0,                          /*JWK10*/
  },
  {
    VESA_640_480_256,
    &ChipInfoHeader[GRAPHICS_640x480x256],
    &S3SetBank2,
    &S3GetBank2,
    S3ModeSet2b,
    0,                          /*JWK10*/
  },
  {
    VESA_640_480_64K,
    &ChipInfoHeader[GRAPHICS_640x480x64K],
    &S3SetBank2,
    &S3GetBank2,
    S3ModeSet2b,
    0,                          /*JWK10*/
  },
  {
    VESA_640_480_16M,
    &ChipInfoHeader[GRAPHICS_640x480x32bpp],
    &S3SetBank2,
    &S3GetBank2,
    S3ModeSet2b,
    0,                          /*JWK10*/
  },
  {
    VESA_800_600_16,
    &ChipInfoHeader[GRAPHICS_800x600x16],
    &S3SetBank2,
    &S3GetBank2,
    S3ModeSet2a,
    0,                          /*JWK10*/
  },
  {
    VESA_800_600_256,
    &ChipInfoHeader[GRAPHICS_800x600x256],
    &S3SetBank2,
    &S3GetBank2,
    S3ModeSet2b,
    0,                          /*JWK10*/
  },
  {
    VESA_800_600_64K,
    &ChipInfoHeader[GRAPHICS_800x600x64K_2KSL],     /*            */
    &S3SetBank2,
    &S3GetBank2,
    S3ModeSet2b,
    0,                          /*JWK10*/
  },
  {
    VESA_800_600_16M,
    &ChipInfoHeader[GRAPHICS_800x600x32bpp],
    &S3SetBank2,
    &S3GetBank2,
    S3ModeSet2b,
    0,                          /*JWK10*/
  },
  {
    VESA_1024_768_16,
    &ChipInfoHeader[GRAPHICS_1024x768x16],
    &S3SetBank2,
    &S3GetBank2,
    S3ModeSet2a,
    0,                          /*JWK10*/
  },
  {
    VESA_1024_768_256,
    &ChipInfoHeader[GRAPHICS_1024x768x256],
    &S3SetBank2,
    &S3GetBank2,
    S3ModeSet2b,
    0,                          /*JWK10*/
  },
  {
    VESA_1024_768_64K,
    &ChipInfoHeader[GRAPHICS_1024x768x64K],
    &S3SetBank2,
    &S3GetBank2,
    S3ModeSet2b,
    0,                          /*JWK10*/
  },
  {
    VESA_1024_768_16M,
    &ChipInfoHeader[GRAPHICS_1024x768x32bpp],
    &S3SetBank2,
    &S3GetBank2,
    S3ModeSet2b,
    0,                          /*JWK10*/
  },
  {
    S3_1152_864_256,
    &ChipInfoHeader[GRAPHICS_1152x864x256],
    &S3SetBank2,
    &S3GetBank2,
    S3ModeSet2b,
    0,                          /*JWK10*/
  },
  {
    VESA_1280_1024_256,
    &ChipInfoHeader[GRAPHICS_1280x1024x256],
    &S3SetBank2,
    &S3GetBank2,
    S3ModeSet2b,
    0,                          /*JWK10*/
  },
  {
    VESA_1280_1024_64K,
    &ChipInfoHeader[GRAPHICS_1280x1024x64K_4KSL],   /*            */
    &S3SetBank2,
    &S3GetBank2,
    S3ModeSet2b,
    0,                          /*JWK10*/
  },
  {
    VESA_1600_1200_256,
    &ChipInfoHeader[GRAPHICS_1600x1200x256],
    &S3SetBank2,
    &S3GetBank2,
    S3ModeSet2b,
    0,                          /*JWK10*/
  },
  {
    0x01,
    &ChipInfoHeader[TEXT_40x25],
    &S3SetBank2,
    &S3GetBank2,
    S3ModeSet2c,
    0,                          /*JWK10*/
   },
  {
    0x03,
    &ChipInfoHeader[TEXT_80x25],
    &S3SetBank2,
    &S3GetBank2,
    S3ModeSet2c,
    0,                          /*JWK10*/
  },
  {
    VESA_TEXT_132_25,
    &ChipInfoHeader[TEXT_132x25],
    &S3SetBank2,
    &S3GetBank2,
    S3ModeSet2c,
    0,                          /*JWK10*/
  },
  {
    VESA_TEXT_132_43,
    &ChipInfoHeader[TEXT_132x43],
    &S3SetBank2,
    &S3GetBank2,
    S3ModeSet2c,
    0,                          /*JWK10*/
  },
};

USHORT usSizeS3ChipSet2 = sizeof(S3ChipSet2)/sizeof(CHIPINFO);
