/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*****************************************************************************
 *
 * SOURCE FILE NAME = SVGACIRS.C
 *
 * DESCRIPTIVE NAME = Chipdata for Cirrus adapters
 *
 *
 * VERSION = V2.2
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * NOTES
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/*
**      Include files
*/

#define PMIDEF_INCL
#include "svga.h"

/*
**
**              Chipset Lock/Unlock Information
**
**    Please note that in order to push and pop locking states,             
**    VVIDEO now requires:                                                  
**    1) these be PAIRs of OUTBs.                                           
**    2) number of locks = number of unlocks.                               
**    3) that the lock pairs be in the inverse order                        
**       from the unlock pairs.                                             
**
*/

REGDATA CirrusLockData[] =
{
  { PMICMD_REGOP, NONE,          NONE, 0x01, 1, READWRITE_DATA, "\x0f" }, /*          */
  { PMICMD_INB,   SEQ_INDEXPORT, NONE, NONE, 0, NONE,           NULL   },
  { PMICMD_OUTB,  SEQ_INDEXPORT, NONE, NONE, 0, WRITEONLY_DATA, b_6    },
  { PMICMD_OUTB,  SEQ_DATAPORT,  NONE, NONE, 1, WRITEREG_DATA,  NULL   }, /*          */
  { PMICMD_OUTB,  SEQ_INDEXPORT, NONE, NONE, 0, WRITEREG_DATA,  NULL   },
  { PMICMD_NONE },
};

REGDATA CirrusUnLockData[] =
{
  { PMICMD_INB,   SEQ_INDEXPORT, NONE, NONE, 0, NONE,           NULL   },
  { PMICMD_OUTB,  SEQ_INDEXPORT, NONE, NONE, 0, WRITEONLY_DATA, b_6    },
  { PMICMD_INB,   SEQ_DATAPORT,  NONE, NONE, 1, NONE,           NULL   }, /*          */
  { PMICMD_OUTB,  SEQ_DATAPORT,  NONE, NONE, 0, WRITEONLY_DATA, "\x12" },
  { PMICMD_OUTB,  SEQ_INDEXPORT, NONE, NONE, 0, WRITEREG_DATA,  NULL   },
  { PMICMD_NONE },
};

/*
**
**              Chipset Cleanup Information
**
**    If an adapter has no cleanup information, no space is allocated for
**    it. ADAPTER_CLEANUP_INDEX needs to be defined for all those that
**    do have cleanup section. These indices are used rather than ADAPTER
**    ID's to facilitate different cleanup routines for different chipsets
**    and not to depend on the adapter ID values.
*/

REGDATA CirrusCleanData[] =
{                                    /* Cirrus cleanups */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x07, 0x00, READWRITE_DATA, &SEQRegData[0x07] },
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x0e, 0x00, READWRITE_DATA, &SEQRegData[0x0e] },
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x0f, 0x10, READWRITE_DATA, &SEQRegData[0x0f] },
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x12, 0x00, READWRITE_DATA, &GDCRegData[0x12] },/*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x1e, 0x00, READWRITE_DATA, &SEQRegData[0x1e] },
  { PMICMD_RMWBI, GDC_INDEXPORT, GDC_DATAPORT, 0x00, 0x00, READWRITE_DATA, &GDCRegData[0x00] },
  { PMICMD_RMWBI, GDC_INDEXPORT, GDC_DATAPORT, 0x09, 0x00, READWRITE_DATA, &GDCRegData[0x09] },
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x19, 0x00, READWRITE_DATA, &CRTRegData[0x19] },
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x1a, 0x00, READWRITE_DATA, &CRTRegData[0x1a] },
  { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x1b, 0x00, READWRITE_DATA, &CRTRegData[0x1b] },
  { PMICMD_NONE },
};

/*
**
**              Chipset Setbank Information
**
**              Set/Get Banks are based on svgabank.asm in screendd
**              of Picard.           
**
**              Registers are unlocked already and always set/get
**              write bank only.
**
*/

REGDATA CirrusSetBankCmd[] =
/********************************************  Borg 2/8/94
Cirrus Logic

r0 = 0;
inb (r1, 0x3ce);         ; save GDC index
outb (0x3ce, 0x0b);      ; get graphics controller reg
inb (r3, 0x3cf);
r3 &= 0xde;              ; set Offset Register 1
r3 |= 0x20;              ; set Offset granularity bit
outb (0x3cf, r3);        ; set GR[B]
outb (0x3ce, 0x09);      ; get bank reg
r0 <<= 0x2;              ; using 16Kbyte granularity
outb (0x3cf, r0);        ; set bank
outb (0x3ce, r1);        ; restore GDC index

***************************************************************/
{
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x00, WRITEONLY_DATA, b_0 },
    { PMICMD_INB, GDC_INDEXPORT, NONE, NONE, 1, NONE, NULL },
    { PMICMD_OUTB, GDC_INDEXPORT, NONE, NONE, 0, WRITEONLY_DATA, b_B },
    { PMICMD_INB, GDC_DATAPORT, NONE, NONE, 3, NONE, NULL },
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x03, REGISTER_OPEQUAL|REGISTER_AND, "\xde" },
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x03, REGISTER_OPEQUAL|REGISTER_OR,  "\x20" },
    { PMICMD_OUTB, GDC_DATAPORT, NONE, NONE, 3, WRITEREG_DATA },
    { PMICMD_OUTB, GDC_INDEXPORT, NONE, NONE, 0, WRITEONLY_DATA, b_9 },
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x00, REGISTER_OPEQUAL|REGISTER_SHL, b_2 },
    { PMICMD_OUTB, GDC_DATAPORT, NONE, NONE, 0, WRITEREG_DATA },
    { PMICMD_OUTB, GDC_INDEXPORT, NONE, NONE, 1, WRITEREG_DATA },
    { PMICMD_NONE },
};

/*
**
**              Chipset Getbank Information            
**
*/

REGDATA CirrusGetBankCmd[] =
/*********************************************** Need verification
2MB addressing capability when GRB[5] is set to '1'.
-------------------------------------------------------
Cirrus
inb(r1, 0x3ce); Save index
outb(0x3ce, 0x09);
inb(r0, 0x3cf);   r2: offset reg. selected.
outb(0x3ce, 0x0b);
inb(r3, 0x3cf);   r2: offset reg. selected.

Next set of instructions is just to avoid "if"
What should happen:
  if (r3 == 0x20)
  {
     r0 &= 0x7f;
     r0 >= 0x2;
  }
  else
     r0 >= 0x4;

r3 &= 0x20;              ; check offset granularity bit
r3 >= 0x05;
r4  = 0xff;
r4 >= r3;
r0 &= r4;
r5  = 2;
r3 ^= 1;
r5 <= r3;
r0 >= r5;
outb(0x3ce, r1); restore index
***************************************************************/
{
    { PMICMD_INB, GDC_INDEXPORT, NONE, NONE, 1, NONE, NULL },
    { PMICMD_OUTB, GDC_INDEXPORT, NONE, NONE, 0, WRITEONLY_DATA, b_9 },
    { PMICMD_INB, GDC_DATAPORT, NONE, NONE, 0, NONE, NULL },
    { PMICMD_OUTB, GDC_INDEXPORT, NONE, NONE, 0, WRITEONLY_DATA, b_B },
    { PMICMD_INB, GDC_DATAPORT, NONE, NONE, 3, NONE, NULL },
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x03, REGISTER_OPEQUAL|REGISTER_AND, "\x20" },
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x03, REGISTER_OPEQUAL|REGISTER_SHR, b_5 },
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x04, WRITEONLY_DATA, "\xFF" },
    { PMICMD_REGOP, 0x03, NONE, 0x01, 0x04, REGISTER_OPEQUAL|REGISTER_OPERAND|REGISTER_SHR },
    { PMICMD_REGOP, 0x04, NONE, 0x01, 0x00, REGISTER_OPEQUAL|REGISTER_OPERAND|REGISTER_AND },
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x05, WRITEONLY_DATA, b_2 },
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x03, REGISTER_OPEQUAL|REGISTER_XOR, b_1 },
    { PMICMD_REGOP, 0x03, NONE, 0x01, 0x05, REGISTER_OPEQUAL|REGISTER_OPERAND|REGISTER_SHL },
    { PMICMD_REGOP, 0x05, NONE, 0x01, 0x00, REGISTER_OPEQUAL|REGISTER_OPERAND|REGISTER_SHR },
    { PMICMD_OUTB, GDC_INDEXPORT, NONE, NONE, 1, WRITEREG_DATA },
    { PMICMD_NONE },
};

/*
**      Standard VGA Chipset - for GENERIC use only.
*/

BANKROUTINE CirrusSetBank = {"SetBankLinear", CirrusSetBankCmd};
BANKROUTINE CirrusGetBank = {"GetBankLinear", CirrusGetBankCmd};

/*
**
**              Chipset Mode Information
**
*/

/*
** Cirrus Logic   5420 or 5422 or 5424
*/

REGDATA CirrusModeSet1 [] =
{
  { PMICMD_OUTB,  MISCOUTPUTREG_WRITE, NONE,   0x00, 0x00, WRITEONLY_DATA, &MiscOutRegData },
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x14, 0x00, READWRITE_DATA, &SEQRegData[0x00]},
  { PMICMD_OUTW,  SEQ_INDEXPORT, NONE, NONE, 0x00, WRITEONLY_DATA, &bEndSEQReset[0] },
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x05, 0x1B, READWRITE_DATA, &SEQRegData[0x1B]},
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x28, 0x00, READWRITE_DATA, &CRTRegData[0x00]},
  { PMICMD_BOUTB, ATC_INDEXPORT, ATC_DATAPORT, 0x15, 0x00, READWRITE_DATA, &ATCRegData[0x00]}, /*          */
  { PMICMD_BOUTB, GDC_INDEXPORT, GDC_DATAPORT, 0x0C, 0x00, READWRITE_DATA, &GDCRegData[0x00]},
  { PMICMD_BOUTB, GDC_INDEXPORT, GDC_DATAPORT, 0x02, 0x10, READWRITE_DATA, &GDCRegData[0x10]},
  { PMICMD_NONE }
};

CHIPINFO CirrusChipSet1[] = {
  {
    VGAMODE,
    &ChipInfoHeader[GRAPHICS_640x480x16],
    &CirrusSetBank,
    &CirrusGetBank,
    CirrusModeSet1,
    0,                                                          /*JWK10*/
  },
  {
    VESA_640_480_256,
    &ChipInfoHeader[GRAPHICS_640x480x256],
    &CirrusSetBank,
    &CirrusGetBank,
    CirrusModeSet1,
    0,                                                          /*JWK10*/
  },
  {
    VESA_800_600_16,
    &ChipInfoHeader[GRAPHICS_800x600x16],
    &CirrusSetBank,
    &CirrusGetBank,
    CirrusModeSet1,
    0,                                                          /*JWK10*/
  },
  {
    VESA_800_600_256,
    &ChipInfoHeader[GRAPHICS_800x600x256],
    &CirrusSetBank,
    &CirrusGetBank,
    CirrusModeSet1,
    0,                                                          /*JWK10*/
  },
  {
    VESA_1024_768_16,
    &ChipInfoHeader[GRAPHICS_1024x768x16],
    &CirrusSetBank,
    &CirrusGetBank,
    CirrusModeSet1,
    0,                                                          /*JWK10*/
  },
  {
    VESA_1024_768_256,
    &ChipInfoHeader[GRAPHICS_1024x768x256],
    &CirrusSetBank,
    &CirrusGetBank,
    CirrusModeSet1,
    0,                                                          /*JWK10*/
  },
  {
    0x01,
    &ChipInfoHeader[TEXT_40x25],
    &CirrusSetBank,
    &CirrusGetBank,
    CirrusModeSet1,
    0,                                                          /*JWK10*/
  },
  {
    0x03,
    &ChipInfoHeader[TEXT_80x25],
    &CirrusSetBank,
    &CirrusGetBank,
    CirrusModeSet1,
    0,                                                          /*JWK10*/
  },
  {
    VESA_TEXT_132_25,
    &ChipInfoHeader[TEXT_132x25],
    &CirrusSetBank,
    &CirrusGetBank,
    CirrusModeSet1,
    0,                                                          /*JWK10*/
  },
  {
    VESA_TEXT_132_43,
    &ChipInfoHeader[TEXT_132x43],
    &CirrusSetBank,
    &CirrusGetBank,
    CirrusModeSet1,
    0,                                                          /*JWK10*/
  },
};

USHORT usSizeCirrusChipSet1 = sizeof(CirrusChipSet1)/sizeof(CHIPINFO);

/*
** Cirrus Logic 5426, 5428, 5429, 543X
*/

REGDATA CirrusModeSet2 [] =
{
  { PMICMD_OUTB,  MISCOUTPUTREG_WRITE, NONE,   0x00, 0x00, WRITEONLY_DATA, &MiscOutRegData },
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x20, 0x00, READWRITE_DATA, &SEQRegData[0x00]},
  { PMICMD_OUTW,  SEQ_INDEXPORT, NONE, NONE, 0x00, WRITEONLY_DATA, &bEndSEQReset[0] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x28, 0x00, READWRITE_DATA, &CRTRegData[0x00]},
  { PMICMD_BOUTB, ATC_INDEXPORT, ATC_DATAPORT, 0x15, 0x00, READWRITE_DATA, &ATCRegData[0x00]}, /*          */
  { PMICMD_BOUTB, GDC_INDEXPORT, GDC_DATAPORT, 0x16, 0x00, READWRITE_DATA, &GDCRegData[0x00]},
  { PMICMD_BOUTB, GDC_INDEXPORT, GDC_DATAPORT, 0x14, 0x20, READWRITE_DATA, &GDCRegData[0x10]},
  { PMICMD_NONE }
};

CHIPINFO CirrusChipSet2[] = {
  {
    VGAMODE,
    &ChipInfoHeader[GRAPHICS_640x480x16],
    &CirrusSetBank,
    &CirrusGetBank,
    CirrusModeSet2,
    0,                                                          /*JWK10*/
  },
  {
    VESA_640_480_256,
    &ChipInfoHeader[GRAPHICS_640x480x256],
    &CirrusSetBank,
    &CirrusGetBank,
    CirrusModeSet2,
    0,                                                          /*JWK10*/
  },
  {
    VESA_640_480_64K,
    &ChipInfoHeader[GRAPHICS_640x480x64K],
    &CirrusSetBank,
    &CirrusGetBank,
    CirrusModeSet2,
    0,                                                          /*JWK10*/
  },
  {
    VESA_640_480_16M,
    &ChipInfoHeader[CIRRUS_640x480x16M],
    &CirrusSetBank,
    &CirrusGetBank,
    CirrusModeSet2,
    0,                                                          /*JWK10*/
  },
  {
    VESA_800_600_16,
    &ChipInfoHeader[GRAPHICS_800x600x16],
    &CirrusSetBank,
    &CirrusGetBank,
    CirrusModeSet2,
    0,                                                          /*JWK10*/
  },
  {
    VESA_800_600_256,
    &ChipInfoHeader[GRAPHICS_800x600x256],
    &CirrusSetBank,
    &CirrusGetBank,
    CirrusModeSet2,
    0,                                                          /*JWK10*/
  },
  {
    VESA_800_600_64K,
    &ChipInfoHeader[GRAPHICS_800x600x64K],
    &CirrusSetBank,
    &CirrusGetBank,
    CirrusModeSet2,
    0,                                                          /*JWK10*/
  },
//           
//  VESA_800_600_16M,
//  &ChipInfoHeader[CIRRUS_800x600x16M],
//  &CirrusSetBank,
//  &CirrusGetBank,
//  CirrusModeSet2,
//  0,                                                          /*JWK10*/
//},
  {
    VESA_1024_768_16,
    &ChipInfoHeader[GRAPHICS_1024x768x16],
    &CirrusSetBank,
    &CirrusGetBank,
    CirrusModeSet2,
    0,                                                          /*JWK10*/
  },
  {
    VESA_1024_768_256,
    &ChipInfoHeader[GRAPHICS_1024x768x256],
    &CirrusSetBank,
    &CirrusGetBank,
    CirrusModeSet2,
    0,                                                          /*JWK10*/
  },
  {
    VESA_1024_768_64K,
    &ChipInfoHeader[GRAPHICS_1024x768x64K],
    &CirrusSetBank,
    &CirrusGetBank,
    CirrusModeSet2,
    0,                                                          /*JWK10*/
  },
//           
//  VESA_1024_768_16M,
//  &ChipInfoHeader[GRAPHICS_1024x768x16M],
//  &CirrusSetBank,
//  &CirrusGetBank,
//  CirrusModeSet2,
//  0,                                                          /*JWK10*/
//},
  {
    VESA_1280_1024_256,
    &ChipInfoHeader[GRAPHICS_1280x1024x256],
    &CirrusSetBank,
    &CirrusGetBank,
    CirrusModeSet2,
    0,                                                          /*JWK10*/
  },
  {
    VESA_1280_1024_64K,
    &ChipInfoHeader[GRAPHICS_1280x1024x64K_4KSL],            /*            */
    &CirrusSetBank,
    &CirrusGetBank,
    CirrusModeSet2,
    0,                                                          /*JWK10*/
  },
  {
    0x01,
    &ChipInfoHeader[TEXT_40x25],
    &CirrusSetBank,
    &CirrusGetBank,
    CirrusModeSet2,
    0,                                                          /*JWK10*/
  },
  {
    0x03,
    &ChipInfoHeader[TEXT_80x25],
    &CirrusSetBank,
    &CirrusGetBank,
    CirrusModeSet2,
    0,                                                          /*JWK10*/
  },
  {
    VESA_TEXT_132_25,
    &ChipInfoHeader[TEXT_132x25],
    &CirrusSetBank,
    &CirrusGetBank,
    CirrusModeSet2,
    0,                                                          /*JWK10*/
  },
  {
    VESA_TEXT_132_43,
    &ChipInfoHeader[TEXT_132x43],
    &CirrusSetBank,
    &CirrusGetBank,
    CirrusModeSet2,
    0,                                                          /*JWK10*/
  },
};

USHORT usSizeCirrusChipSet2 = sizeof(CirrusChipSet2)/sizeof(CHIPINFO);

