/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*****************************************************************************
 *
 * SOURCE FILE NAME = SVGAATI.C
 *
 * DESCRIPTIVE NAME = Chipdata for ATI Adapters
 *
 *
 * VERSION = V2.2
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * NOTES
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/*
**      Include files
*/

#define PMIDEF_INCL
#include "svga.h"

#define A8514_DSPCTRL       0x22E8      /* (W/O) */
#define A8514_HORZTOTAL     0x02E8      /* (W/O) */
#define A8514_HORZDSP       0x06E8      /* (W/O) */
#define A8514_HORZSSTART    0x0AE8      /* (W/O) */
#define A8514_HORZSWIDTH    0x0EE8      /* (W/O) */

#define ATI_R_HORZDSP       0xb2ee      /* (R/O) - Written elsewhere */
#define ATI_R_HORZSSTART    0xb6ee      /* (R/O) - Written elsewhere */
#define ATI_R_HORZSWIDTH    0xbaee      /* (R/O) - Written elsewhere */
#define ATI_R_VERTTOTAL     0xc2ee      /* (R/O) - Written elsewhere */
#define ATI_R_VERTDSP       0xc6ee      /* (R/O) - Written elsewhere */
#define ATI_R_VERTSSTART    0xcaee      /* (R/O) - Written elsewhere */
#define ATI_R_VERTSWIDTH    0xd2ee      /* (R/O) - Written elsewhere */
#define ATI_R_DESTY_AXSTP   0xdeee      /* (R/O) - Written elsewhere */
#define ATI_R_DESTX_DIASTP  0xdaee      /* (R/O) - Written elsewhere */
#define ATI_R_BGNDCOLOR     0xe2e8      /* (R/W) & Written elsewhere */
#define ATI_R_FGNDCOLOR     0xe6e8      /* (R/W) & Written elsewhere */

/*
**
**              Chipset Lock/Unlock Information
**
*/

REGDATA aRegDataATIMach64Unlock [] =                            /*          */
{
  /* Insure Dac is (internally to VSVGA) addressable at the usual place */
  { PMICMD_INW,   0x62ec, NONE,   NONE, 0x00,   NONE,           NULL   },
  { PMICMD_RMWWN, 0x62ec, 0x62ec, NONE, 0xdfff, WRITEONLY_DATA, "\x00\x20" }, /*          */
  { PMICMD_INW,   0x6aec, NONE,   NONE, 0x01,   NONE,           NULL   },     /*          */
  { PMICMD_RMWWN, 0x6aec, 0x6aec, NONE, 0xfffb, WRITEONLY_DATA, "\x04\x00" }, /*          */
  { PMICMD_NONE },
};

REGDATA aRegDataATIMach64Lock [] =                              /*          */
{
  { PMICMD_REGOP, 0x01,   NONE, 0x04, 0x01,   READWRITE_DATA, "\x00\x00\x00\x00" }, /*          */
  { PMICMD_REGOP, 0x00,   NONE, 0x04, 0x00,   READWRITE_DATA, "\x00\x00\x00\x00" }, /*          */
  { PMICMD_OUTW,  0x6aec, NONE, NONE, 0x01,   WRITEREG_DATA,  NULL   }, /*          */
  { PMICMD_OUTW,  0x62ec, NONE, NONE, 0x00,   WRITEREG_DATA,  NULL   }, /*          */
  { PMICMD_NONE },
};

/*
**
**              Chipset Cleanup Information
**
*/

REGDATA ATICleanup[] =
{                                    /* ATI Cleanups    */
  { PMICMD_RMWWN, 0x46e8,        0x46e8,        0x00, 0xffe3, WRITEONLY_DATA, b_9 }, /*          */
  { PMICMD_RMWWN, A8514_SUBSYSCTRL, A8514_SUBSYSCTRL, 0x00, 0x0000, WRITEONLY_DATA, "\x0f\x80" }, /*          */
  { PMICMD_RMWWN, A8514_SUBSYSCTRL, A8514_SUBSYSCTRL, 0x00, 0x0000, WRITEONLY_DATA, "\x0f\x40" }, /*          */
  { PMICMD_RMWWN, A8514_DSPCTRL, A8514_DSPCTRL, 0x00, 0x0000, WRITEONLY_DATA, "\x40" },
  { PMICMD_RMWWN, A8514_ADVCTRL, A8514_ADVCTRL, 0x00, 0x0000, WRITEONLY_DATA, b_2 },
  { PMICMD_RMWBI, ATI_INDEXPORT, ATI_DATAPORT,  0xb0,   0xdf, READWRITE_DATA, &ATIRegData[0xb0] },
  { PMICMD_RMWBI, ATI_INDEXPORT, ATI_DATAPORT,  0xb1,   0x84, WRITEONLY_DATA, b_0 }, /*          */
  { PMICMD_RMWBI, ATI_INDEXPORT, ATI_DATAPORT,  0xb2,   0x00, WRITEONLY_DATA, b_0 },
  { PMICMD_RMWBI, ATI_INDEXPORT, ATI_DATAPORT,  0xb3,   0xbf, READWRITE_DATA, &ATIRegData[0xb3] },
  { PMICMD_RMWBI, ATI_INDEXPORT, ATI_DATAPORT,  0xb6,   0xe7, READWRITE_DATA, &ATIRegData[0xb6] },
  { PMICMD_RMWBI, ATI_INDEXPORT, ATI_DATAPORT,  0xb8,   0x90, WRITEONLY_DATA, "\x40" },
  { PMICMD_RMWBI, ATI_INDEXPORT, ATI_DATAPORT,  0xb9,   0x7f, READWRITE_DATA, &ATIRegData[0xb9] },
  { PMICMD_RMWBI, ATI_INDEXPORT, ATI_DATAPORT,  0xbe,   0x00, READWRITE_DATA, &ATIRegData[0xbe] }, /*          */
  { PMICMD_RMWBN, MISCOUTPUTREG_READ, MISCOUTPUTREG_WRITE, 0x00, 0x00, READWRITE_DATA, &MiscOutRegData },
  /* Dummy I/O to add registers to trap list */                 /*          */
  { PMICMD_RMWBN, A8514_DACMASK,       A8514_DACMASK,       0x00, 0xff, WRITEONLY_DATA, &b_0 [0] }, /*          */
  { PMICMD_RMWBN, A8514_DACREADINDEX,  A8514_DACREADINDEX,  0x00, 0xff, WRITEONLY_DATA, &b_0 [0] }, /*          */
  { PMICMD_RMWBN, A8514_DACWRITEINDEX, A8514_DACWRITEINDEX, 0x00, 0xff, WRITEONLY_DATA, &b_0 [0] }, /*          */
  { PMICMD_RMWBN, A8514_DACDATA,       A8514_DACDATA,       0x00, 0xff, WRITEONLY_DATA, &b_0 [0] }, /*          */
  { PMICMD_NONE },
};

REGDATA ATIMach32Cleanup[] =                                    /*          */
{                                    /* ATI Mach8/32 Cleanups    */
  { PMICMD_RMWWN, 0x46e8,        0x46e8,        0x00, 0xffe3, WRITEONLY_DATA, b_9 }, /*          */
  { PMICMD_RMWWN, A8514_SUBSYSCTRL, A8514_SUBSYSCTRL, 0x00, 0x0000, WRITEONLY_DATA, "\x0f\x80" }, /*          */
  { PMICMD_RMWWN, A8514_SUBSYSCTRL, A8514_SUBSYSCTRL, 0x00, 0x0000, WRITEONLY_DATA, "\x0f\x40" }, /*          */
  { PMICMD_RMWWN, A8514_DSPCTRL, A8514_DSPCTRL, 0x00, 0x0000, WRITEONLY_DATA, "\x40" },
  { PMICMD_RMWWN, A8514_ADVCTRL, A8514_ADVCTRL, 0x00, 0x0000, WRITEONLY_DATA, b_2 },
  { PMICMD_RMWBI, ATI_INDEXPORT, ATI_DATAPORT,  0xb0,   0xdf, READWRITE_DATA, &ATIRegData[0xb0] },
  { PMICMD_RMWBI, ATI_INDEXPORT, ATI_DATAPORT,  0xb1,   0x84, WRITEONLY_DATA, b_0 }, /*          */
  { PMICMD_RMWBI, ATI_INDEXPORT, ATI_DATAPORT,  0xb2,   0x00, WRITEONLY_DATA, b_0 },
  { PMICMD_RMWBI, ATI_INDEXPORT, ATI_DATAPORT,  0xb3,   0xbf, READWRITE_DATA, &ATIRegData[0xb3] },
  { PMICMD_RMWBI, ATI_INDEXPORT, ATI_DATAPORT,  0xb6,   0xe7, READWRITE_DATA, &ATIRegData[0xb6] },
  { PMICMD_RMWBI, ATI_INDEXPORT, ATI_DATAPORT,  0xb8,   0x90, WRITEONLY_DATA, "\x40" },
  { PMICMD_RMWBI, ATI_INDEXPORT, ATI_DATAPORT,  0xb9,   0x7f, READWRITE_DATA, &ATIRegData[0xb9] },
  { PMICMD_RMWBI, ATI_INDEXPORT, ATI_DATAPORT,  0xbe,   0x00, READWRITE_DATA, &ATIRegData[0xbe] }, /*          */
  { PMICMD_RMWBN, MISCOUTPUTREG_READ, MISCOUTPUTREG_WRITE, 0x00, 0x00, READWRITE_DATA, &MiscOutRegData },

  { PMICMD_WAITW, A8514_STATUS,        0x02ff,              NONE, 100,    0x0000 } , /*          */
  { PMICMD_RMWWN, A8514_HORZTOTAL,     A8514_HORZTOTAL,     0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x00] },
  { PMICMD_RMWWN, 0x02ee,              0x02ee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x02] },
  { PMICMD_RMWWN, ATI_R_HORZDSP,       A8514_HORZDSP,       0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x04] },
  { PMICMD_RMWWN, 0x06ee,              0x06ee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x06] },
  { PMICMD_RMWWN, ATI_R_HORZSSTART,    A8514_HORZSSTART,    0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x08] },
  { PMICMD_RMWWN, 0x0aee,              0x0aee,              0x00, 0x0000, WRITEONLY_DATA, &b_0 [0]            }, /*          */
  { PMICMD_RMWWN, ATI_R_HORZSWIDTH,    A8514_HORZSWIDTH,    0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x0c] },
  { PMICMD_RMWWN, 0x0eee,              0x0eee,              0x00, 0x0000, WRITEONLY_DATA, &b_0 [0]            }, /*          */
  { PMICMD_WAITW, A8514_STATUS,        0x02ff,              NONE, 100,    0x0000 } , /*          */
  { PMICMD_RMWWN, ATI_R_VERTTOTAL,     A8514_VERTTOTAL,     0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x10] },
  { PMICMD_RMWWN, 0x12ee,              0x12ee,              0x00, 0x0000, WRITEONLY_DATA, &b_0 [0]            }, /*          */
  { PMICMD_RMWWN, ATI_R_VERTDSP,       A8514_VERTDSP,       0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x14] },
  { PMICMD_RMWWN, 0x16ee,              0x16ee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x16] },
  { PMICMD_RMWWN, ATI_R_VERTSSTART,    A8514_VERTSSTART,    0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x18] },
  { PMICMD_RMWWN, 0x1aee,              0x1aee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x1a] },
  { PMICMD_RMWWN, ATI_R_VERTSWIDTH,    A8514_VERTSWIDTH,    0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x1c] },
  { PMICMD_RMWWN, 0x1eee,              0x1eee,              0x00, 0x0000, WRITEONLY_DATA, &b_0 [0]            }, /*          */
  { PMICMD_WAITW, A8514_STATUS,        0x02ff,              NONE, 100,    0x0000 } , /*          */
  { PMICMD_RMWWN, A8514_DSPCTRL,       A8514_DSPCTRL,       0x00, 0x0000, WRITEONLY_DATA, "\x20" },
  { PMICMD_RMWWN, 0x26ee,              0x26ee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x26] },
  { PMICMD_RMWWN, 0x2aee,              0x2aee,              0x00, 0x0000, WRITEONLY_DATA, &b_0 [0]            }, /*          */
  { PMICMD_RMWWN, 0x2eee,              0x2eee,              0x00, 0x0000, WRITEONLY_DATA, &b_0 [0]            }, /*          */
  { PMICMD_WAITW, A8514_STATUS,        0x02ff,              NONE, 100,    0x0000 } , /*          */
  { PMICMD_RMWWN, 0x32ee,              0x32ee,              0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x32] }, /*@V3.0MNH02*/
  { PMICMD_RMWWN, 0x36ee,              0x36ee,              0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x36] },
  { PMICMD_RMWWN, 0x3aee,              0x3aee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x3a] },
  { PMICMD_RMWWN, 0x3eee,              0x3eee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x3e] },
  { PMICMD_WAITW, A8514_STATUS,        0x02ff,              NONE, 100,    0x0000 } , /*          */
  { PMICMD_RMWWN, A8514_SUBSYSCTRL,    A8514_SUBSYSCTRL,    0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x40] },
  { PMICMD_RMWWN, 0x42ee,              0x42ee,              0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x42] },
  { PMICMD_RMWWN, 0x46e8,              0x46e8,              0x00, 0xffe3, WRITEONLY_DATA, &b_9 [0]            }, /*          */
  { PMICMD_RMWWN, 0x46ee,              0x46ee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x46] },
  { PMICMD_RMWWN, A8514_ADVCTRL,       A8514_ADVCTRL,       0x00, 0x0000, WRITEONLY_DATA, &b_3 [0]            },
  { PMICMD_RMWWN, 0x4aee,              0x4aee,              0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x4a] }, /*@V3.0MNH02*/
  { PMICMD_WAITW, A8514_STATUS,        0x02ff,              NONE, 100,    0x0000 } , /*          */
  { PMICMD_RMWWN, 0x52ee,              0x52ee,              0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x52] },
  { PMICMD_RMWWN, 0x56ee,              0x56ee,              0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x56] },
  { PMICMD_RMWWN, 0x5aee,              0x5aee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x5a] },
  /* Leave aperature setting to BIOS at boot and PM driver */                                                    /*          */
  { PMICMD_RMWWN, 0x5eee,              0x5eee,              0x00, 0xffff, READWRITE_DATA, &MiscRegData [0x5e] }, /*          */
  { PMICMD_RMWWN, 0x62ee,              0x62ee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x62] },
  { PMICMD_RMWWN, 0x66ee,              0x66ee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x66] },
  { PMICMD_RMWWN, 0x6aee,              0x6aee,              0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x6a] },
  { PMICMD_RMWWN, 0x6eee,              0x6eee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x6e] },
  { PMICMD_WAITW, A8514_STATUS,        0x02ff,              NONE, 100,    0x0000 } , /*          */
  { PMICMD_RMWWN, 0x72ee,              0x72ee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x72] },
  { PMICMD_RMWWN, 0x76ee,              0x76ee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x76] },
  { PMICMD_RMWWN, 0x8eee,              0x7aee,              0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x7a] },
//  { PMICMD_RMWWN, 0x92ee,              0x7eee,              0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x7e] },          
  { PMICMD_RMWWN, A8514_CURRENTY,      A8514_CURRENTY,      0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x80] },
  { PMICMD_WAITW, A8514_STATUS,        0x02ff,              NONE, 100,    0x0000 } , /*          */
  { PMICMD_RMWWN, 0x82ee,              0x82ee,              0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x82] },
  { PMICMD_RMWWN, A8514_CURRENTX,      A8514_CURRENTX,      0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x84] },
  { PMICMD_RMWWN, ATI_R_DESTY_AXSTP,   A8514_DESTY_AXSTP,   0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x88] },
  { PMICMD_RMWWN, ATI_R_DESTX_DIASTP,  A8514_DESTX_DIASTP,  0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x8c] },
  { PMICMD_RMWWN, 0x8eee,              0x8eee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x8e] },
  { PMICMD_WAITW, A8514_STATUS,        0x02ff,              NONE, 100,    0x0000 } , /*          */
  { PMICMD_RMWWN, A8514_ERRORTERM,     A8514_ERRORTERM,     0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x90] },
  { PMICMD_RMWWN, A8514_MAJORAXISCNT,  A8514_MAJORAXISCNT,  0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x94] },
  { PMICMD_RMWWN, 0x96ee,              0x96ee,              0x00, 0x0000, WRITEONLY_DATA, &b_0 [0]            }, /*          */
  { PMICMD_RMWWN, A8514_COMMAND,       A8514_COMMAND,       0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x98] },
  { PMICMD_RMWWN, 0x9aee,              0x9aee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x9a] },
/*{ PMICMD_RMWWN, A8514_SHORTSTROKE,   A8514_SHORTSTROKE,   0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x9c] }, Write Once! */
/*  Reading from this locks the FIFO, so just write: */
/*{ PMICMD_RMWWN, ATI_R_BGNDCOLOR,     A8514_BGNDCOLOR,     0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0xa0] }, */
  { PMICMD_OUTW,  A8514_BGNDCOLOR,     NONE,                0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0xa0] },
  { PMICMD_WAITW, A8514_STATUS,        0x02ff,              NONE, 100,    0x0000 } , /*          */
  { PMICMD_RMWWN, 0xa2ee,              0xa2ee,              0x00, 0x0000, READWRITE_DATA, &MiscRegData [0xa2] },
/*  Reading from this locks the FIFO, so just write: */
/*{ PMICMD_RMWWN, ATI_R_FGNDCOLOR,     A8514_FGNDCOLOR,     0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0xa4] }, */
  { PMICMD_OUTW,  A8514_FGNDCOLOR,     NONE,                0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0xa4] },
  { PMICMD_RMWWN, 0xa6ee,              0xa6ee,              0x00, 0x0000, WRITEONLY_DATA, &b_0 [0]            }, /*          */
  { PMICMD_RMWWN, A8514_WRITEMASK,     A8514_WRITEMASK,     0x00, 0x0000, WRITEONLY_DATA, "\xff\xff"          }, /*          */
  { PMICMD_RMWWN, ATI_R_HORZDSP,       0xaaee,              0x00, 0x07ff, WRITEONLY_DATA, &b_0 [0]            }, /*          */
  { PMICMD_RMWWN, A8514_READMASK,      A8514_READMASK,      0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0xac] },
  /*!! Next line omitted to work around PM driver problem */                                                     /*          */
//{ PMICMD_RMWWN, ATI_R_VERTDSP,       0xaeee,              0x00, 0x07ff, WRITEONLY_DATA, &b_0 [0]            }, /*          */
  { PMICMD_WAITW, A8514_STATUS,        0x02ff,              NONE, 100,    0x0000 } , /*          */
  { PMICMD_RMWWN, A8514_COLORCOMPARE,  A8514_COLORCOMPARE,  0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0xb0] },
  { PMICMD_RMWWN, 0xb2ee,              0xb2ee,              0x00, 0x0000, WRITEONLY_DATA, &b_0 [0]            }, /*          */
  { PMICMD_RMWWN, A8514_BGNDMIX,       A8514_BGNDMIX,       0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0xb4] },
  { PMICMD_RMWWN, 0xb6ee,              0xb6ee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0xb6] },
  { PMICMD_RMWWN, A8514_FGNDMIX,       A8514_FGNDMIX,       0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0xb8] },
  { PMICMD_RMWWN, 0xbaee,              0xbaee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0xba] },
  { PMICMD_RMWWN, A8514_MULTIFUNCTION, A8514_MULTIFUNCTION, 0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0xbc] },
  { PMICMD_RMWWN, ATI_R_HORZDSP,       0xbeee,              0x00, 0x07ff, WRITEONLY_DATA, &b_0 [0]            }, /*          */
  { PMICMD_WAITW, A8514_STATUS,        0x02ff,              NONE, 100,    0x0000 } , /*          */
  { PMICMD_RMWWN, 0xc2ee,              0xc2ee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0xc2] },
/*{ PMICMD_RMWWN, 0xc6ee,              0xc6ee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0xc6] }, Write Once! */
/*{ PMICMD_RMWWN, 0xcaee,              0xcaee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0xca] }, Write Once! */
  { PMICMD_RMWWN, 0xd2ee,              0xd2ee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0xd2] },
  { PMICMD_RMWWN, 0xd6ee,              0xd6ee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0xd6] },
  { PMICMD_RMWWN, 0xdaee,              0xdaee,              0x00, 0x0000, WRITEONLY_DATA, &b_0 [0]            }, /*          */
  { PMICMD_RMWWN, 0xdeee,              0xdeee,              0x00, 0x0000, WRITEONLY_DATA, &b_0 [0]            }, /*          */
  { PMICMD_WAITW, A8514_STATUS,        0x02ff,              NONE, 100,    0x0000 } , /*          */
/*{ PMICMD_RMWWN, A8514_PIXELTRANSFER, A8514_PIXELTRANSFER, 0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0xe0] }, Write Once! */
  { PMICMD_RMWWN, 0xe2ee,              0xe2ee,              0x00, 0x0000, WRITEONLY_DATA, "\xff\x07"          }, /*          */
  { PMICMD_RMWWN, 0xe6ee,              0xe6ee,              0x00, 0x0000, WRITEONLY_DATA, "\xff\x07"          }, /*          */
  { PMICMD_RMWWN, 0xeeee,              0xeeee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0xee] },
/*{ PMICMD_RMWWN, 0xfeee,              0xfeee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0xfe] }, Write Once! */
  { PMICMD_WAITW, A8514_STATUS,        0x02ff,              NONE, 100,    0x0000 } , /*          */
  { PMICMD_RMWWN, A8514_MULTIFUNCTION, A8514_MULTIFUNCTION, 0x00, 0x0000, WRITEONLY_DATA, "\x00\x00"          }, /*          */
  { PMICMD_RMWWN, A8514_MULTIFUNCTION, A8514_MULTIFUNCTION, 0x00, 0x0000, WRITEONLY_DATA, "\x00\x10"          },
  { PMICMD_RMWWN, A8514_MULTIFUNCTION, A8514_MULTIFUNCTION, 0x00, 0x0000, WRITEONLY_DATA, "\x00\x20"          },
  { PMICMD_RMWWN, ATI_R_VERTDSP,       A8514_MULTIFUNCTION, 0x00, 0x07ff, WRITEONLY_DATA, "\x00\x30"          },
  { PMICMD_RMWWN, ATI_R_HORZDSP,       A8514_MULTIFUNCTION, 0x00, 0x07ff, WRITEONLY_DATA, "\x00\x40"          },
  { PMICMD_RMWWN, A8514_MULTIFUNCTION, A8514_MULTIFUNCTION, 0x00, 0x0000, WRITEONLY_DATA, "\x00\x50"          },
  { PMICMD_RMWWN, A8514_MULTIFUNCTION, A8514_MULTIFUNCTION, 0x00, 0x0000, WRITEONLY_DATA, "\x00\x80"          },
  { PMICMD_RMWWN, A8514_MULTIFUNCTION, A8514_MULTIFUNCTION, 0x00, 0x0000, WRITEONLY_DATA, "\x00\x90"          },
  { PMICMD_WAITW, A8514_STATUS,        0x02ff,              NONE, 100,    0x0000 } , /*          */
  { PMICMD_RMWWN, A8514_MULTIFUNCTION, A8514_MULTIFUNCTION, 0x00, 0x0000, WRITEONLY_DATA, "\x00\xa0"          },
  { PMICMD_WAITW, A8514_STATUS,        0x02ff,              NONE, 100,    0x0000 } , /*          */

  /* Dummy I/O to add registers to trap list */                 /*          */
  { PMICMD_RMWBN, A8514_DACMASK,       A8514_DACMASK,       0x00, 0xff, WRITEONLY_DATA, &b_0 [0] }, /*          */
  { PMICMD_RMWBN, A8514_DACREADINDEX,  A8514_DACREADINDEX,  0x00, 0xff, WRITEONLY_DATA, &b_0 [0] }, /*          */
  { PMICMD_RMWBN, A8514_DACWRITEINDEX, A8514_DACWRITEINDEX, 0x00, 0xff, WRITEONLY_DATA, &b_0 [0] }, /*          */
  { PMICMD_RMWBN, A8514_DACDATA,       A8514_DACDATA,       0x00, 0xff, WRITEONLY_DATA, &b_0 [0] }, /*          */
  { PMICMD_NONE },
};

REGDATA ATIMach64Cleanup[] =                                    /*          */
{                                    /* ATIMach64 Cleanups */
  { PMICMD_RMWBI, ATI_INDEXPORT, ATI_DATAPORT,  0xb0,   0xdf, READWRITE_DATA, &ATIRegData[0xb0] },
  { PMICMD_RMWBI, ATI_INDEXPORT, ATI_DATAPORT,  0xb1,   0x84, WRITEONLY_DATA, b_0 }, /*          */
  { PMICMD_RMWBI, ATI_INDEXPORT, ATI_DATAPORT,  0xb2,   0x00, WRITEONLY_DATA, b_0 },
  { PMICMD_RMWBI, ATI_INDEXPORT, ATI_DATAPORT,  0xb3,   0xbf, READWRITE_DATA, &ATIRegData[0xb3] },
  { PMICMD_RMWBI, ATI_INDEXPORT, ATI_DATAPORT,  0xb6,   0xe7, READWRITE_DATA, &ATIRegData[0xb6] },
  { PMICMD_RMWBI, ATI_INDEXPORT, ATI_DATAPORT,  0xb8,   0x90, WRITEONLY_DATA, "\x40" },
  { PMICMD_RMWBI, ATI_INDEXPORT, ATI_DATAPORT,  0xb9,   0x7f, READWRITE_DATA, &ATIRegData[0xb9] },
  { PMICMD_RMWBI, ATI_INDEXPORT, ATI_DATAPORT,  0xbe,   0x00, READWRITE_DATA, &ATIRegData[0xbe] }, /*          */
  { PMICMD_RMWBN, MISCOUTPUTREG_READ, MISCOUTPUTREG_WRITE, 0x00, 0x00, READWRITE_DATA, &MiscOutRegData },
  { PMICMD_OUTW,  0x02ec, 0x02ec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x00] },
  { PMICMD_OUTW,  0x02ee, 0x02ee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x01] },
  { PMICMD_OUTW,  0x06ec, 0x06ec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x02] },
  { PMICMD_OUTW,  0x06ee, 0x06ee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x03] },
  { PMICMD_OUTW,  0x0aec, 0x0aec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x04] },
  { PMICMD_OUTW,  0x0aee, 0x0aee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x05] },
  { PMICMD_OUTW,  0x0eec, 0x0eec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x06] },
  { PMICMD_OUTW,  0x0eee, 0x0eee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x07] },
  { PMICMD_OUTW,  0x12ec, 0x12ec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x08] },
  { PMICMD_OUTW,  0x12ee, 0x12ee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x09] },
  { PMICMD_OUTW,  0x16ec, 0x16ec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x0a] },
  { PMICMD_OUTW,  0x16ee, 0x16ee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x0b] },
  { PMICMD_OUTW,  0x1aec, 0x1aec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x0c] },
  { PMICMD_OUTW,  0x1aee, 0x1aee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x0d] },
  { PMICMD_OUTW,  0x1eec, 0x1eec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x0e] },
  { PMICMD_OUTW,  0x1eee, 0x1eee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x0f] },
  { PMICMD_OUTW,  0x22ec, 0x22ec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x10] },
  { PMICMD_OUTW,  0x22ee, 0x22ee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x11] },
  { PMICMD_OUTW,  0x26ec, 0x26ec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x12] },
  { PMICMD_OUTW,  0x26ee, 0x26ee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x13] },
  { PMICMD_OUTW,  0x2aec, 0x2aec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x14] },
  { PMICMD_OUTW,  0x2aee, 0x2aee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x15] },
  { PMICMD_OUTW,  0x2eec, 0x2eec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x16] },
  { PMICMD_OUTW,  0x2eee, 0x2eee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x17] },
  { PMICMD_OUTW,  0x32ec, 0x32ec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x18] },
  { PMICMD_OUTW,  0x32ee, 0x32ee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x19] },
  { PMICMD_OUTW,  0x36ec, 0x36ec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x1a] },
  { PMICMD_OUTW,  0x36ee, 0x36ee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x1b] },
  { PMICMD_OUTW,  0x3aec, 0x3aec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x1c] },
  { PMICMD_OUTW,  0x3aee, 0x3aee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x1d] },
  { PMICMD_OUTW,  0x3eec, 0x3eec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x1e] },
  { PMICMD_OUTW,  0x3eee, 0x3eee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x1f] },
  { PMICMD_OUTW,  0x42ec, 0x42ec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x20] },
  { PMICMD_OUTW,  0x42ee, 0x42ee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x21] },
  { PMICMD_OUTW,  0x46ec, 0x46ec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x22] },
  { PMICMD_OUTW,  0x46ee, 0x46ee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x23] },
  { PMICMD_OUTW,  0x4aec, 0x4aec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x24] },
  { PMICMD_OUTW,  0x4aee, 0x4aee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x25] },
  { PMICMD_OUTW,  0x4eec, 0x4eec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x26] },
  { PMICMD_OUTW,  0x4eee, 0x4eee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x27] },
  { PMICMD_OUTW,  0x52ec, 0x52ec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x28] },
  { PMICMD_OUTW,  0x52ee, 0x52ee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x29] },
  { PMICMD_OUTW,  0x56ec, 0x56ec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x2a] },
  { PMICMD_OUTW,  0x56ee, 0x56ee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x2b] },
  { PMICMD_OUTW,  0x5aec, 0x5aec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x2c] },
  { PMICMD_OUTW,  0x5aee, 0x5aee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x2d] },
//DAC Ports need special handling as byte ports:                /*          */
//{ PMICMD_OUTW,  0x5eec, 0x5eec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x2e] },
//{ PMICMD_OUTW,  0x5eee, 0x5eee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x2f] },
  /* Dummy I/O to add registers to trap list */                 /*          */
  { PMICMD_RMWBN, 0x5eec, 0x5eec, 0x00, 0xff,   WRITEONLY_DATA, &b_0 [0] }, /*          */
  { PMICMD_RMWBN, 0x5eed, 0x5eed, 0x00, 0xff,   WRITEONLY_DATA, &b_0 [0] }, /*          */
  { PMICMD_RMWBN, 0x5eee, 0x5eee, 0x00, 0xff,   WRITEONLY_DATA, &b_0 [0] }, /*          */
  { PMICMD_RMWBN, 0x5eef, 0x5eef, 0x00, 0xff,   WRITEONLY_DATA, &b_0 [0] }, /*          */
  /* Leave VGA DAC address enable alone since it is a "lock"!     */                     /*          */
  { PMICMD_RMWWN, 0x62ec, 0x62ec, 0x00, 0x2000, READWRITE_DATA, &MiscRegData [2*0x30] }, /*          */
  { PMICMD_OUTW,  0x62ee, 0x62ee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x31] },
  { PMICMD_OUTW,  0x66ec, 0x66ec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x32] },
  { PMICMD_OUTW,  0x66ee, 0x66ee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x33] },
  /* Leave aperature alone since it may change from boot to boot! */                     /*          */
  /* Leave VGA aperature enable alone since it is a "lock"!       */                     /*          */
  { PMICMD_RMWWN, 0x6aec, 0x6aec, 0x00, 0x3ff4, READWRITE_DATA, &MiscRegData [2*0x34] }, /*          */
  { PMICMD_OUTW,  0x6aee, 0x6aee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x35] },
  { PMICMD_OUTW,  0x6eec, 0x6eec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x36] },
  { PMICMD_OUTW,  0x6eee, 0x6eee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x37] },
  { PMICMD_OUTW,  0x72ec, 0x72ec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x38] },
  { PMICMD_OUTW,  0x72ee, 0x72ee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x39] },
  { PMICMD_OUTW,  0x76ec, 0x76ec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x3a] },
  { PMICMD_OUTW,  0x76ee, 0x76ee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x3b] },
  { PMICMD_OUTW,  0x7aec, 0x7aec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x3c] },
  { PMICMD_OUTW,  0x7aee, 0x7aee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x3d] },
  { PMICMD_OUTW,  0x7eec, 0x7eec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x3e] },
  { PMICMD_OUTW,  0x7eee, 0x7eee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x3f] },
  { PMICMD_NONE },
};

/*
**
**              Chipset Setbank Information
**
**              Set/Get Banks are based on svgabank.asm in screendd
**              of Picard.           
**
**              Registers are unlocked already and always set/get
**              write bank only.
**
*/

REGDATA ATIMach32SetBankCmd[] =                                 /*          */
/************************************************************
Always set bank in single bank mode.
-------------------------------------------------------------
ATI
  r0 = 0;                     ;Initialize bank register param.
  inb(r1, 0x1ce);
  r1 |= 0x80;                 ;Keep index bits.
  outb(0x1ce, 0xbe);          ;change to single bank mode
  inb(r2, 0x1cf);
  r2 &= 0xf7;
  outb(0x1ce, 0xbe);
  outb(0x1cf, r2);
  outb(0x1ce, 0xb2);
  inb(r2, 0x1cf);
  r2 &= 0xe1;                 ;isolate bank select bit (4-1)
  r0 &= 0x0f;                 ;prevent bank overrun
  r0 <= 0x01;
  r0 |= r2;
  outb(0x1ce, 0xb2);
  outb(0x1cf, r0);            ;Set new bank
  outb(0x1ce, r1);            ;Pop index
***************************************************************/
{
  { PMICMD_REGOP, 0x00,          NONE, 0x01, 0x00, WRITEONLY_DATA, &b_0[0] },/*          */
  { PMICMD_REGOP, 0x00,          NONE, 0x01, 0x00, REGISTER_SHL,   &b_1[0] },/*          */
  { PMICMD_REGOP, 0x00,          NONE, 0x01, 0x00, REGISTER_AND,   "\x1e" }, /*          */
  { PMICMD_INB,   ATI_INDEXPORT, NONE, NONE, 0x01, NONE,           NULL },
  { PMICMD_REGOP, 0x01,          NONE, 0x01, 0x01, REGISTER_OR,    "\x80" }, /*          */
  { PMICMD_OUTB,  ATI_INDEXPORT, NONE, NONE, 0x00, WRITEONLY_DATA, "\xbe" },
  { PMICMD_INB,   ATI_DATAPORT,  NONE, NONE, 0x02, NONE,           NULL },
  { PMICMD_REGOP, 0x02,          NONE, 0x01, 0x02, REGISTER_AND,   "\xf7" }, /*          */
  { PMICMD_OUTB,  ATI_INDEXPORT, NONE, NONE, 0x00, WRITEONLY_DATA, "\xbe" },
  { PMICMD_OUTB,  ATI_DATAPORT,  NONE, NONE, 0x02, WRITEREG_DATA,  NULL },   /*          */
  { PMICMD_OUTB,  ATI_INDEXPORT, NONE, NONE, 0x00, WRITEONLY_DATA, "\xb2" },
  { PMICMD_INB,   ATI_DATAPORT,  NONE, NONE, 0x02, NONE,           NULL },
  { PMICMD_REGOP, 0x02,          NONE, 0x01, 0x02, REGISTER_AND,   "\xe1" }, /*          */
  { PMICMD_REGOP, 0x02,          NONE, 0x01, 0x00, REGISTER_OPEQUAL | REGISTER_OPERAND | REGISTER_OR, NULL }, /*          */
  { PMICMD_OUTB,  ATI_INDEXPORT, NONE, NONE, 0x00, WRITEONLY_DATA, "\xb2" },
  { PMICMD_OUTB,  ATI_DATAPORT,  NONE, NONE, 0x00, WRITEREG_DATA,  NULL },   /*          */
  { PMICMD_OUTB,  ATI_INDEXPORT, NONE, NONE, 0x01, WRITEREG_DATA,  NULL },   /*          */
  { PMICMD_NONE },
};

REGDATA ATIMach64SetBankCmd[] =                                 /*          */
/**************************************************************

  r0 = 0;                     ;Initialize bank register param.
  outw(0x56ec, r0);           ;
  r0 &= 0xff;                 ;
  r0 >>= 1;                   ;

***************************************************************/
{                                                               /*          */
  { PMICMD_REGOP, 0x00,          NONE, 0x01, 0x00, WRITEONLY_DATA, &b_0[0] },/*          */
  { PMICMD_REGOP, 0x00,          NONE, 0x01, 0x00, REGISTER_SHL,   &b_1[0] },/*          */
  { PMICMD_OUTW,  0x56ec,        NONE, NONE, 0x00, WRITEREG_DATA,  NULL },   /*          */
  { PMICMD_OUTW,  0x5aec,        NONE, NONE, 0x00, WRITEREG_DATA,  NULL },   /*          */
  { PMICMD_REGOP, 0x00,          NONE, 0x01, 0x00, REGISTER_OR,    "\x01" }, /*          */
  { PMICMD_OUTW,  0x56ee,        NONE, NONE, 0x00, WRITEREG_DATA,  NULL },   /*          */
  { PMICMD_OUTW,  0x5aee,        NONE, NONE, 0x00, WRITEREG_DATA,  NULL },   /*          */
  { PMICMD_REGOP, 0x00,          NONE, 0x01, 0x00, REGISTER_AND,   "\x1e" }, /*          */
  { PMICMD_INB,   ATI_INDEXPORT, NONE, NONE, 0x01, NONE,           NULL },
  { PMICMD_REGOP, 0x01,          NONE, 0x01, 0x01, REGISTER_OR,    "\x80" }, /*          */
  { PMICMD_OUTB,  ATI_INDEXPORT, NONE, NONE, 0x00, WRITEONLY_DATA, "\xbe" },
  { PMICMD_INB,   ATI_DATAPORT,  NONE, NONE, 0x02, NONE,           NULL },
  { PMICMD_REGOP, 0x02,          NONE, 0x01, 0x02, REGISTER_AND,   "\xf7" }, /*          */
  { PMICMD_OUTB,  ATI_INDEXPORT, NONE, NONE, 0x00, WRITEONLY_DATA, "\xbe" },
  { PMICMD_OUTB,  ATI_DATAPORT,  NONE, NONE, 0x02, WRITEREG_DATA,  NULL },   /*          */
  { PMICMD_OUTB,  ATI_INDEXPORT, NONE, NONE, 0x00, WRITEONLY_DATA, "\xb2" },
  { PMICMD_INB,   ATI_DATAPORT,  NONE, NONE, 0x02, NONE,           NULL },
  { PMICMD_REGOP, 0x02,          NONE, 0x01, 0x02, REGISTER_AND,   "\xe1" }, /*          */
  { PMICMD_REGOP, 0x02,          NONE, 0x01, 0x00, REGISTER_OPEQUAL | REGISTER_OPERAND | REGISTER_OR, NULL }, /*          */
  { PMICMD_OUTB,  ATI_INDEXPORT, NONE, NONE, 0x00, WRITEONLY_DATA, "\xb2" },
  { PMICMD_OUTB,  ATI_DATAPORT,  NONE, NONE, 0x00, WRITEREG_DATA,  NULL },   /*          */
  { PMICMD_OUTB,  ATI_INDEXPORT, NONE, NONE, 0x01, WRITEREG_DATA,  NULL },   /*          */
  /* This code is only for single bank mode. */                 /*          */
  { PMICMD_NONE },                                              /*          */
};                                                              /*          */


/*
**
**              Chipset Getbank Information            
**
*/

REGDATA ATIMach32GetBankCmd[] =                                 /*          */
/**************************************************************

  r0 = 0x00;                  ;fGetWriteBank
  inb(r1, 0x1ce);             ;Save index
  r1 |= 0x80;                 ;Keep index bits.
  outb(0x1ce, 0xbe);          ;Get bank mode
  inb(r2, 0x1cf);
  r2 &= 0x08;                 ;Get dual page mode
  r2 >>= 0x03;                ;Shift dual page mode to TRUE.
  r0 ^= 0x01;                 ;fGetWriteBank becomes fGetReadBank
  r2 &= r0;                   ;fGetReadBank & Dual Page
  r2 <<= 0x02;                ;Implies extra shift of 4.
  r2 |= 0x01;                 ;Otherwise shift only 1.
  outb(0x1ce, 0xb2);          ;Getbank
  inb(r0, 0x1cf);
  r0 >>= r2;                  ;Shift bank.
  r0 &= 0x0f;
  outb(0x1ce, r1);            ;Restore index

***************************************************************/
{
  /* This code is only for single bank mode. */
  { PMICMD_INB,   ATI_INDEXPORT, NONE, NONE, 0x01, NONE,           NULL },
  { PMICMD_REGOP, 0x01,          NONE, 0x01, 0x01, REGISTER_OR,    "\x80" }, /*          */
  { PMICMD_OUTB,  ATI_INDEXPORT, NONE, NONE, 0x00, WRITEONLY_DATA, "\xbe" },
  { PMICMD_INB,   ATI_DATAPORT,  NONE, NONE, 0x02, NONE,           NULL },
  { PMICMD_REGOP, 0x02,          NONE, 0x01, 0x02, REGISTER_AND,   "\xf7" }, /*          */
  { PMICMD_OUTB,  ATI_INDEXPORT, NONE, NONE, 0x00, WRITEONLY_DATA, "\xbe" },
  { PMICMD_OUTB,  ATI_DATAPORT,  NONE, NONE, 0x02, WRITEREG_DATA,  NULL },   /*          */
  { PMICMD_OUTB,  ATI_INDEXPORT, NONE, NONE, 0x00, WRITEONLY_DATA, "\xb2" },
  { PMICMD_INB,   ATI_DATAPORT,  NONE, NONE, 0x00, NONE,           NULL },
  { PMICMD_REGOP, 0x00,          NONE, 0x01, 0x00, REGISTER_SHR,   &b_1[0] },/*          */
  /*
   * if Dual page and read_bank, r0 >>= 0x04
   */
  { PMICMD_REGOP, 0x00,          NONE, 0x01, 0x00, REGISTER_AND,   &b_F[0] },/*          */
  { PMICMD_OUTB,  ATI_INDEXPORT, NONE, NONE, 0x01, WRITEREG_DATA,  NULL },   /*          */
  { PMICMD_NONE },
};

REGDATA ATIMach64GetBankCmd[] =                                 /*          */
/**************************************************************

  r0 = 0x00;                  ;fGetWriteBank
  inw(r0, 0x56ec);            ;
  r0 &= 0xff;                 ;
  r0 >>= 1;                   ;

***************************************************************/
{                                                               /*          */
  /* This code is only for single bank mode. */                 /*          */
  { PMICMD_INW,   0x56ec,        NONE, NONE, 0x00, NONE,         NULL },    /*          */
  { PMICMD_REGOP, 0x00,          NONE, 0x04, 0x00, REGISTER_AND, "\xff\x00\x00\x00" }, /*          */
  { PMICMD_REGOP, 0x00,          NONE, 0x01, 0x00, REGISTER_SHR, &b_1[0] }, /*          */
  { PMICMD_NONE },                                              /*          */
};                                                              /*          */

BANKROUTINE ATIMach32SetBank =                                  /*          */
{                                                               /*          */
  "SetBankLinear",                                              /*          */
  ATIMach32SetBankCmd                                           /*          */
};                                                              /*          */
BANKROUTINE ATIMach32GetBank =                                  /*          */
{                                                               /*          */
  "GetBankLinear",                                              /*          */
  ATIMach32GetBankCmd                                           /*          */
};                                                              /*          */
BANKROUTINE ATIMach64SetBank =                                  /*          */
{                                                               /*          */
  "SetBankLinear",                                              /*          */
  ATIMach64SetBankCmd                                           /*          */
};                                                              /*          */
BANKROUTINE ATIMach64GetBank =                                  /*          */
{                                                               /*          */
  "GetBankLinear",                                              /*          */
  ATIMach64GetBankCmd                                           /*          */
};                                                              /*          */

REGDATA aRegDataATIMach32DacRS2Clear [] =                       /*          */
{
  { PMICMD_RMWBI, ATI_INDEXPORT,  ATI_DATAPORT, 0xa0, 0xdf, WRITEONLY_DATA, b_0 },
  { PMICMD_NONE }
};

REGDATA aRegDataATIMach32DacRS2Set [] =                         /*          */
{
  { PMICMD_RMWBI, ATI_INDEXPORT,  ATI_DATAPORT, 0xa0, 0xdf, WRITEONLY_DATA, "\x20" },
  { PMICMD_NONE }
};

REGDATA aRegDataATIMach32DacRS3Clear [] =                       /*          */
{
  { PMICMD_RMWBI, ATI_INDEXPORT,  ATI_DATAPORT, 0xa0, 0xbf, WRITEONLY_DATA, b_0 },
  { PMICMD_NONE }
};

REGDATA aRegDataATIMach32DacRS3Set [] =                         /*          */
{
  { PMICMD_RMWBI, ATI_INDEXPORT,  ATI_DATAPORT, 0xa0, 0xbf, WRITEONLY_DATA, "\x40" },
  { PMICMD_NONE }
};

REGDATA aRegDataATIMach64DacRS2Clear [] =                       /*          */
{
  { PMICMD_RMWBI, ATI_INDEXPORT,  ATI_DATAPORT, 0xa0, 0xdf, WRITEONLY_DATA, b_0 },
  { PMICMD_RMWWN, 0x62ec,         0x62ec,   0x0000, 0xfffe, WRITEONLY_DATA, b_0 },
  { PMICMD_NONE }
};

REGDATA aRegDataATIMach64DacRS2Set [] =                         /*          */
{
  { PMICMD_RMWBI, ATI_INDEXPORT,  ATI_DATAPORT, 0xa0, 0xdf, WRITEONLY_DATA, "\x20" },
  { PMICMD_RMWWN, 0x62ec,         0x62ec,   0x0000, 0xfffe, WRITEONLY_DATA, b_1 },
  { PMICMD_NONE }
};

REGDATA aRegDataATIMach64DacRS3Clear [] =                       /*          */
{
  { PMICMD_RMWBI, ATI_INDEXPORT,  ATI_DATAPORT, 0xa0, 0xbf, WRITEONLY_DATA, b_0 },
  { PMICMD_RMWWN, 0x62ec,         0x62ec,   0x0000, 0xfffd, WRITEONLY_DATA, b_0 },
  { PMICMD_NONE }
};

REGDATA aRegDataATIMach64DacRS3Set [] =                         /*          */
{
  { PMICMD_RMWBI, ATI_INDEXPORT,  ATI_DATAPORT, 0xa0, 0xbf, WRITEONLY_DATA, "\x40" },
  { PMICMD_RMWWN, 0x62ec,         0x62ec,   0x0000, 0xfffd, WRITEONLY_DATA, b_2 },
  { PMICMD_NONE }
};

REFRESHMODE ATIMach32_GenRefresh_Table[] =
{
  {640,480,60,{60,NO_REFRESH}},
  {800,600,60,{76,72,60,NO_REFRESH}},
  {1024,768,43,{76,72,70,60,43,NO_REFRESH}},
  {1280,1024,46,{74,70,60,46,NO_REFRESH}},
  {0}
};

/*
**
**              Chipset Mode Information
**
*/

/*
** Generate entry to set Miscellaneous Output register on ATI.
** Must only be done after all extended registers are setup,
** so we put it after synch reset entry.
*/

/*
** ATI 18800
*/

REGDATA ATIModeSet1 [] =
{
  { PMICMD_OUTW,  SEQ_INDEXPORT, NONE,         NONE, 0x00, WRITEONLY_DATA, b_0 },
  { PMICMD_BOUTB, ATI_INDEXPORT, ATI_DATAPORT, 0x03, 0xB0, READWRITE_DATA, &ATIRegData[0xB0] },
  { PMICMD_BOUTB, ATI_INDEXPORT, ATI_DATAPORT, 0x01, 0xBE, READWRITE_DATA, &ATIRegData[0xBE] },
  { PMICMD_BOUTB, ATI_INDEXPORT, ATI_DATAPORT, 0x02, 0xB5, READWRITE_DATA, &ATIRegData[0xB5] },
  { PMICMD_BOUTB, ATI_INDEXPORT, ATI_DATAPORT, 0x01, 0xB8, READWRITE_DATA, &ATIRegData[0xB8] },
  { PMICMD_BOUTB, ATI_INDEXPORT, ATI_DATAPORT, 0x01, 0xB3, READWRITE_DATA, &ATIRegData[0xB3] },
  { PMICMD_BOUTB, ATI_INDEXPORT, ATI_DATAPORT, 0x01, 0xB9, READWRITE_DATA, &ATIRegData[0xB9] },
  { PMICMD_BOUTB, ATI_INDEXPORT, ATI_DATAPORT, 0x02, 0xA6, READWRITE_DATA, &ATIRegData[0xA6] },
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x05, 0x00, READWRITE_DATA, &SEQRegData[0x00] },
  { PMICMD_OUTW,  SEQ_INDEXPORT, NONE,         NONE, 0x00, WRITEONLY_DATA, &bEndSEQReset[0] },
  { PMICMD_OUTB,  MISCOUTPUTREG_WRITE, NONE,   NONE, 0x00, WRITEONLY_DATA, &MiscOutRegData }, /*          */
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x19, 0x00, READWRITE_DATA, &CRTRegData[0x00] },
  { PMICMD_BOUTB, ATC_INDEXPORT, ATC_DATAPORT, 0x15, 0x00, READWRITE_DATA, &ATCRegData[0x00] }, /*          */
  { PMICMD_BOUTB, GDC_INDEXPORT, GDC_DATAPORT, 0x09, 0x00, READWRITE_DATA, &GDCRegData[0x00] },
  { PMICMD_NONE }                                                                               /*          */
};

CHIPINFO ATIChipSet1[] = {
  {
    VGAMODE,
    &ChipInfoHeader[GRAPHICS_640x480x16],
    &ATIMach32SetBank,                                          /*          */
    &ATIMach32GetBank,                                          /*          */
    ATIModeSet1,
    0,                                                          /*JWK10*/
  },
  {
    0x62,
    &ChipInfoHeader[GRAPHICS_640x480x256],
    &ATIMach32SetBank,                                          /*          */
    &ATIMach32GetBank,                                          /*          */
    ATIModeSet1,
    0,                                                          /*JWK10*/
  },
  {
    0x54,
    &ChipInfoHeader[GRAPHICS_800x600x16],
    &ATIMach32SetBank,                                          /*          */
    &ATIMach32GetBank,                                          /*          */
    ATIModeSet1,
    0,                                                          /*JWK10*/
  },
  {
    0x63,
    &ChipInfoHeader[GRAPHICS_800x600x256],
    &ATIMach32SetBank,                                          /*          */
    &ATIMach32GetBank,                                          /*          */
    ATIModeSet1,
    0,                                                          /*JWK10*/
  },
  {
    0x55,
    &ChipInfoHeader[GRAPHICS_1024x768x16],
    &ATIMach32SetBank,                                          /*          */
    &ATIMach32GetBank,                                          /*          */
    ATIModeSet1,
    0,                                                          /*JWK10*/
  },
  {
    0x64,
    &ChipInfoHeader[GRAPHICS_1024x768x256],
    &ATIMach32SetBank,                                          /*          */
    &ATIMach32GetBank,                                          /*          */
    ATIModeSet1,
    0,                                                          /*JWK10*/
  },
  {
    0x01,
    &ChipInfoHeader[TEXT_40x25],
    &ATIMach32SetBank,                                          /*          */
    &ATIMach32GetBank,                                          /*          */
    ATIModeSet1,
    0,                                                          /*JWK10*/
  },
  {
    0x03,
    &ChipInfoHeader[TEXT_80x25],
    &ATIMach32SetBank,                                          /*          */
    &ATIMach32GetBank,                                          /*          */
    ATIModeSet1,
    0,                                                          /*JWK10*/
  },
  {
    0x23,
    &ChipInfoHeader[TEXT_132x25],
    &ATIMach32SetBank,                                          /*          */
    &ATIMach32GetBank,                                          /*          */
    ATIModeSet1,
    0,                                                          /*JWK10*/
  },
  {
    0x33,
    &ChipInfoHeader[TEXT_132x44],
    &ATIMach32SetBank,                                          /*          */
    &ATIMach32GetBank,                                          /*          */
    ATIModeSet1,
    0,                                                          /*JWK10*/
  },
};

USHORT usSizeATIChipSet1 = sizeof(ATIChipSet1)/sizeof(CHIPINFO);

/*
** ATI 28800
*/

REGDATA ATIModeSet2 [] =
{
  { PMICMD_OUTW,  SEQ_INDEXPORT, NONE,         NONE, 0x00, WRITEONLY_DATA, b_0 },
  { PMICMD_BOUTB, ATI_INDEXPORT, ATI_DATAPORT, 0x03, 0xB0, READWRITE_DATA, &ATIRegData[0xB0] },
  { PMICMD_BOUTB, ATI_INDEXPORT, ATI_DATAPORT, 0x01, 0xBE, READWRITE_DATA, &ATIRegData[0xBE] },
  { PMICMD_BOUTB, ATI_INDEXPORT, ATI_DATAPORT, 0x02, 0xB5, READWRITE_DATA, &ATIRegData[0xB5] },
  { PMICMD_BOUTB, ATI_INDEXPORT, ATI_DATAPORT, 0x01, 0xB8, READWRITE_DATA, &ATIRegData[0xB8] },
  { PMICMD_BOUTB, ATI_INDEXPORT, ATI_DATAPORT, 0x01, 0xB3, READWRITE_DATA, &ATIRegData[0xB3] },
  { PMICMD_BOUTB, ATI_INDEXPORT, ATI_DATAPORT, 0x01, 0xB9, READWRITE_DATA, &ATIRegData[0xB9] },
  { PMICMD_BOUTB, ATI_INDEXPORT, ATI_DATAPORT, 0x02, 0xA6, READWRITE_DATA, &ATIRegData[0xA6] },
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x05, 0x00, READWRITE_DATA, &SEQRegData[0x00] },
  { PMICMD_OUTW,  SEQ_INDEXPORT, NONE,         NONE, 0x00, WRITEONLY_DATA, &bEndSEQReset[0] },
  { PMICMD_OUTB,  MISCOUTPUTREG_WRITE, NONE,   NONE, 0x00, WRITEONLY_DATA, &MiscOutRegData }, /*          */
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x19, 0x00, READWRITE_DATA, &CRTRegData[0x00] },
  { PMICMD_BOUTB, ATC_INDEXPORT, ATC_DATAPORT, 0x15, 0x00, READWRITE_DATA, &ATCRegData[0x00] }, /*          */
  { PMICMD_BOUTB, GDC_INDEXPORT, GDC_DATAPORT, 0x09, 0x00, READWRITE_DATA, &GDCRegData[0x00] },
  { PMICMD_NONE }
};

CHIPINFO ATIChipSet2[] = {
  {
    VGAMODE,
    &ChipInfoHeader[GRAPHICS_640x480x16],
    &ATIMach32SetBank,                                          /*          */
    &ATIMach32GetBank,                                          /*          */
    ATIModeSet2,
    0,                                                          /*JWK10*/
  },
  {
    0x62,
    &ChipInfoHeader[GRAPHICS_640x480x256],
    &ATIMach32SetBank,                                          /*          */
    &ATIMach32GetBank,                                          /*          */
    ATIModeSet2,
    0,                                                          /*JWK10*/
  },
  {
    0x54,
    &ChipInfoHeader[GRAPHICS_800x600x16],
    &ATIMach32SetBank,                                          /*          */
    &ATIMach32GetBank,                                          /*          */
    ATIModeSet2,
    0,                                                          /*JWK10*/
  },
  {
    0x63,
    &ChipInfoHeader[GRAPHICS_800x600x256],
    &ATIMach32SetBank,                                          /*          */
    &ATIMach32GetBank,                                          /*          */
    ATIModeSet2,
    0,                                                          /*JWK10*/
  },
  {
    0x55,
    &ChipInfoHeader[GRAPHICS_1024x768x16],
    &ATIMach32SetBank,                                          /*          */
    &ATIMach32GetBank,                                          /*          */
    ATIModeSet2,
    0,                                                          /*JWK10*/
  },
  {
    0x64,
    &ChipInfoHeader[GRAPHICS_1024x768x256],
    &ATIMach32SetBank,                                          /*          */
    &ATIMach32GetBank,                                          /*          */
    ATIModeSet2,
    0,                                                          /*JWK10*/
  },
  {
    0x01,
    &ChipInfoHeader[TEXT_40x25],
    &ATIMach32SetBank,                                          /*          */
    &ATIMach32GetBank,                                          /*          */
    ATIModeSet2,
    0,                                                          /*JWK10*/
  },
  {
    0x03,
    &ChipInfoHeader[TEXT_80x25],
    &ATIMach32SetBank,                                          /*          */
    &ATIMach32GetBank,                                          /*          */
    ATIModeSet2,
    0,                                                          /*JWK10*/
  },
  {
    0x23,
    &ChipInfoHeader[TEXT_132x25],
    &ATIMach32SetBank,                                          /*          */
    &ATIMach32GetBank,                                          /*          */
    ATIModeSet2,
    0,                                                          /*JWK10*/
  },
  {
    0x33,
    &ChipInfoHeader[TEXT_132x44],
    &ATIMach32SetBank,                                          /*          */
    &ATIMach32GetBank,                                          /*          */
    ATIModeSet2,
    0,                                                          /*JWK10*/
  },
};

USHORT usSizeATIChipSet2 = sizeof(ATIChipSet2)/sizeof(CHIPINFO);

/*
** ATI 38800/68800 Mach8/Mach32
*/                                                              /*          */

REGDATA ATIMach32ModeSet [] =
{
  { PMICMD_WAITW, A8514_STATUS,     0x02ff,           NONE, 100,    0x0000 } , /*          */
  { PMICMD_RMWWN, A8514_SUBSYSCTRL, A8514_SUBSYSCTRL, 0x00, 0x0000, WRITEONLY_DATA, "\x0f\x80" },
  { PMICMD_RMWWN, A8514_SUBSYSCTRL, A8514_SUBSYSCTRL, 0x00, 0x0000, WRITEONLY_DATA, "\x0f\x40" }, /*          */
  { PMICMD_RMWWN, A8514_DSPCTRL,    A8514_DSPCTRL,    0x00, 0x0000, WRITEONLY_DATA, "\x40" },
  { PMICMD_RMWWN, A8514_ADVCTRL,    A8514_ADVCTRL,    0x00, 0x0000, WRITEONLY_DATA, b_3 },
  { PMICMD_OUTW,  SEQ_INDEXPORT,    NONE,             NONE, 0x00,   WRITEONLY_DATA, b_0 },
  { PMICMD_BOUTB, ATI_INDEXPORT,    ATI_DATAPORT,     0x02, 0xA6,   READWRITE_DATA, &ATIRegData[0xA6] },
  { PMICMD_BOUTB, ATI_INDEXPORT,    ATI_DATAPORT,     0x03, 0xB0,   READWRITE_DATA, &ATIRegData[0xB0] },
  { PMICMD_BOUTB, ATI_INDEXPORT,    ATI_DATAPORT,     0x01, 0xB3,   READWRITE_DATA, &ATIRegData[0xB3] },
  { PMICMD_BOUTB, ATI_INDEXPORT,    ATI_DATAPORT,     0x02, 0xB5,   READWRITE_DATA, &ATIRegData[0xB5] },
  { PMICMD_BOUTB, ATI_INDEXPORT,    ATI_DATAPORT,     0x01, 0xB8,   READWRITE_DATA, &ATIRegData[0xB8] },
  { PMICMD_BOUTB, ATI_INDEXPORT,    ATI_DATAPORT,     0x01, 0xB9,   READWRITE_DATA, &ATIRegData[0xB9] },
  { PMICMD_BOUTB, ATI_INDEXPORT,    ATI_DATAPORT,     0x02, 0xBD,   READWRITE_DATA, &ATIRegData[0xBD] },
  { PMICMD_BOUTB, SEQ_INDEXPORT,    SEQ_DATAPORT,     0x05, 0x00,   READWRITE_DATA, &SEQRegData[0x00] },
  { PMICMD_OUTW,  SEQ_INDEXPORT,    NONE,             NONE, 0x00,   WRITEONLY_DATA, &bEndSEQReset[0] },
  { PMICMD_OUTB,  MISCOUTPUTREG_WRITE, NONE,          NONE, 0x00,   WRITEONLY_DATA, &MiscOutRegData }, /*          */
  { PMICMD_BOUTB, CRT_INDEXPORT,    CRT_DATAPORT,     0x19, 0x00,   READWRITE_DATA, &CRTRegData[0x00] },
  { PMICMD_BOUTB, ATC_INDEXPORT,    ATC_DATAPORT,     0x15, 0x00,   READWRITE_DATA, &ATCRegData[0x00] }, /*          */
  { PMICMD_BOUTB, GDC_INDEXPORT,    GDC_DATAPORT,     0x09, 0x00,   READWRITE_DATA, &GDCRegData[0x00] },
  { PMICMD_RMWWN, A8514_DSPCTRL,    A8514_DSPCTRL,    0x00, 0x0000, WRITEONLY_DATA, "\x20" },

  { PMICMD_WAITW, A8514_STATUS,        0x02ff,              NONE, 100,    0x0000 } , /*          */
  { PMICMD_RMWWN, A8514_HORZTOTAL,     A8514_HORZTOTAL,     0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x00] },
  { PMICMD_RMWWN, 0x02ee,              0x02ee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x02] },
  { PMICMD_RMWWN, ATI_R_HORZDSP,       A8514_HORZDSP,       0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x04] },
  { PMICMD_RMWWN, 0x06ee,              0x06ee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x06] },
  { PMICMD_RMWWN, ATI_R_HORZSSTART,    A8514_HORZSSTART,    0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x08] },
  { PMICMD_RMWWN, 0x0aee,              0x0aee,              0x00, 0x0000, WRITEONLY_DATA, &b_0 [0]            }, /*          */
  { PMICMD_RMWWN, ATI_R_HORZSWIDTH,    A8514_HORZSWIDTH,    0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x0c] },
  { PMICMD_RMWWN, 0x0eee,              0x0eee,              0x00, 0x0000, WRITEONLY_DATA, &b_0 [0]            }, /*          */
  { PMICMD_WAITW, A8514_STATUS,        0x02ff,              NONE, 100,    0x0000 } , /*          */
  { PMICMD_RMWWN, ATI_R_VERTTOTAL,     A8514_VERTTOTAL,     0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x10] },
  { PMICMD_RMWWN, 0x12ee,              0x12ee,              0x00, 0x0000, WRITEONLY_DATA, &b_0 [0]            }, /*          */
  { PMICMD_RMWWN, ATI_R_VERTDSP,       A8514_VERTDSP,       0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x14] },
  { PMICMD_RMWWN, 0x16ee,              0x16ee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x16] },
  { PMICMD_RMWWN, ATI_R_VERTSSTART,    A8514_VERTSSTART,    0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x18] },
  { PMICMD_RMWWN, 0x1aee,              0x1aee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x1a] },
  { PMICMD_RMWWN, ATI_R_VERTSWIDTH,    A8514_VERTSWIDTH,    0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x1c] },
  { PMICMD_RMWWN, 0x1eee,              0x1eee,              0x00, 0x0000, WRITEONLY_DATA, &b_0 [0]            }, /*          */
  { PMICMD_WAITW, A8514_STATUS,        0x02ff,              NONE, 100,    0x0000 } , /*          */
  { PMICMD_RMWWN, A8514_DSPCTRL,       A8514_DSPCTRL,       0x00, 0x0000, WRITEONLY_DATA, "\x20" },
  { PMICMD_RMWWN, 0x26ee,              0x26ee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x26] },
  { PMICMD_RMWWN, 0x2aee,              0x2aee,              0x00, 0x0000, WRITEONLY_DATA, &b_0 [0]            }, /*          */
  { PMICMD_RMWWN, 0x2eee,              0x2eee,              0x00, 0x0000, WRITEONLY_DATA, &b_0 [0]            }, /*          */
  { PMICMD_WAITW, A8514_STATUS,        0x02ff,              NONE, 100,    0x0000 } , /*          */
  { PMICMD_RMWWN, 0x32ee,              0x32ee,              0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x32] }, /*@V3.0MNH02*/
  { PMICMD_RMWWN, 0x36ee,              0x36ee,              0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x36] },
  { PMICMD_RMWWN, 0x3aee,              0x3aee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x3a] },
  { PMICMD_RMWWN, 0x3eee,              0x3eee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x3e] },
  { PMICMD_WAITW, A8514_STATUS,        0x02ff,              NONE, 100,    0x0000 } , /*          */
  { PMICMD_RMWWN, A8514_SUBSYSCTRL,    A8514_SUBSYSCTRL,    0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x40] },
  { PMICMD_RMWWN, 0x42ee,              0x42ee,              0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x42] },
  { PMICMD_RMWWN, 0x46e8,              0x46e8,              0x00, 0xffe3, WRITEONLY_DATA, &b_9 [0]            }, /*          */
  { PMICMD_RMWWN, 0x46ee,              0x46ee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x46] },
  { PMICMD_RMWWN, A8514_ADVCTRL,       A8514_ADVCTRL,       0x00, 0x0000, WRITEONLY_DATA, &b_3 [0]            },
  { PMICMD_RMWWN, 0x4aee,              0x4aee,              0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x4a] }, /*@V3.0MNH02*/
  { PMICMD_WAITW, A8514_STATUS,        0x02ff,              NONE, 100,    0x0000 } , /*          */
  { PMICMD_RMWWN, 0x52ee,              0x52ee,              0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x52] },
  { PMICMD_RMWWN, 0x56ee,              0x56ee,              0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x56] },
  { PMICMD_RMWWN, 0x5aee,              0x5aee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x5a] },
  /* Leave aperature setting to BIOS at boot and PM driver */                                                    /*          */
  { PMICMD_RMWWN, 0x5eee,              0x5eee,              0x00, 0xffff, READWRITE_DATA, &MiscRegData [0x5e] }, /*          */
  { PMICMD_RMWWN, 0x62ee,              0x62ee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x62] },
  { PMICMD_RMWWN, 0x66ee,              0x66ee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x66] },
  { PMICMD_RMWWN, 0x6aee,              0x6aee,              0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x6a] },
  { PMICMD_RMWWN, 0x6eee,              0x6eee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x6e] },
  { PMICMD_WAITW, A8514_STATUS,        0x02ff,              NONE, 100,    0x0000 } , /*          */
  { PMICMD_RMWWN, 0x72ee,              0x72ee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x72] },
  { PMICMD_RMWWN, 0x76ee,              0x76ee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x76] },
  { PMICMD_RMWWN, 0x8eee,              0x7aee,              0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x7a] },
//  { PMICMD_RMWWN, 0x92ee,              0x7eee,              0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x7e] },          
  { PMICMD_RMWWN, A8514_CURRENTY,      A8514_CURRENTY,      0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x80] },
  { PMICMD_WAITW, A8514_STATUS,        0x02ff,              NONE, 100,    0x0000 } , /*          */
  { PMICMD_RMWWN, 0x82ee,              0x82ee,              0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x82] },
  { PMICMD_RMWWN, A8514_CURRENTX,      A8514_CURRENTX,      0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x84] },
  { PMICMD_RMWWN, ATI_R_DESTY_AXSTP,   A8514_DESTY_AXSTP,   0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x88] },
  { PMICMD_RMWWN, ATI_R_DESTX_DIASTP,  A8514_DESTX_DIASTP,  0x00, 0x0000, READWRITE_DATA, &MiscRegData [0x8c] },
  { PMICMD_RMWWN, 0x8eee,              0x8eee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x8e] },
  { PMICMD_WAITW, A8514_STATUS,        0x02ff,              NONE, 100,    0x0000 } , /*          */
  { PMICMD_RMWWN, A8514_ERRORTERM,     A8514_ERRORTERM,     0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x90] },
  { PMICMD_RMWWN, A8514_MAJORAXISCNT,  A8514_MAJORAXISCNT,  0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x94] },
  { PMICMD_RMWWN, 0x96ee,              0x96ee,              0x00, 0x0000, WRITEONLY_DATA, &b_0 [0]            }, /*          */
  { PMICMD_RMWWN, A8514_COMMAND,       A8514_COMMAND,       0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x98] },
  { PMICMD_RMWWN, 0x9aee,              0x9aee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x9a] },
/*{ PMICMD_RMWWN, A8514_SHORTSTROKE,   A8514_SHORTSTROKE,   0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0x9c] }, Write Once! */
/*  Reading from this locks the FIFO, so just write: */
/*{ PMICMD_RMWWN, ATI_R_BGNDCOLOR,     A8514_BGNDCOLOR,     0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0xa0] }, */
  { PMICMD_OUTW,  A8514_BGNDCOLOR,     NONE,                0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0xa0] },
  { PMICMD_WAITW, A8514_STATUS,        0x02ff,              NONE, 100,    0x0000 } , /*          */
  { PMICMD_RMWWN, 0xa2ee,              0xa2ee,              0x00, 0x0000, READWRITE_DATA, &MiscRegData [0xa2] },
/*  Reading from this locks the FIFO, so just write: */
/*{ PMICMD_RMWWN, ATI_R_FGNDCOLOR,     A8514_FGNDCOLOR,     0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0xa4] }, */
  { PMICMD_OUTW,  A8514_FGNDCOLOR,     NONE,                0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0xa4] },
  { PMICMD_RMWWN, 0xa6ee,              0xa6ee,              0x00, 0x0000, WRITEONLY_DATA, &b_0 [0]            }, /*          */
  { PMICMD_RMWWN, A8514_WRITEMASK,     A8514_WRITEMASK,     0x00, 0x0000, WRITEONLY_DATA, "\xff\xff"          }, /*          */
  { PMICMD_RMWWN, ATI_R_HORZDSP,       0xaaee,              0x00, 0x07ff, WRITEONLY_DATA, &b_0 [0]            }, /*          */
  { PMICMD_RMWWN, A8514_READMASK,      A8514_READMASK,      0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0xac] },
  /*!! Next line omitted to work around PM driver problem */                                                     /*          */
//{ PMICMD_RMWWN, ATI_R_VERTDSP,       0xaeee,              0x00, 0x07ff, WRITEONLY_DATA, &b_0 [0]            }, /*          */
  { PMICMD_WAITW, A8514_STATUS,        0x02ff,              NONE, 100,    0x0000 } , /*          */
  { PMICMD_RMWWN, A8514_COLORCOMPARE,  A8514_COLORCOMPARE,  0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0xb0] },
  { PMICMD_RMWWN, 0xb2ee,              0xb2ee,              0x00, 0x0000, WRITEONLY_DATA, &b_0 [0]            }, /*          */
  { PMICMD_RMWWN, A8514_BGNDMIX,       A8514_BGNDMIX,       0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0xb4] },
  { PMICMD_RMWWN, 0xb6ee,              0xb6ee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0xb6] },
  { PMICMD_RMWWN, A8514_FGNDMIX,       A8514_FGNDMIX,       0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0xb8] },
  { PMICMD_RMWWN, 0xbaee,              0xbaee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0xba] },
  { PMICMD_RMWWN, A8514_MULTIFUNCTION, A8514_MULTIFUNCTION, 0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0xbc] },
  { PMICMD_RMWWN, ATI_R_HORZDSP,       0xbeee,              0x00, 0x07ff, WRITEONLY_DATA, &b_0 [0]            }, /*          */
  { PMICMD_WAITW, A8514_STATUS,        0x02ff,              NONE, 100,    0x0000 } , /*          */
  { PMICMD_RMWWN, 0xc2ee,              0xc2ee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0xc2] },
/*{ PMICMD_RMWWN, 0xc6ee,              0xc6ee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0xc6] }, Write Once! */
/*{ PMICMD_RMWWN, 0xcaee,              0xcaee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0xca] }, Write Once! */
  { PMICMD_RMWWN, 0xd2ee,              0xd2ee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0xd2] },
  { PMICMD_RMWWN, 0xd6ee,              0xd6ee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0xd6] },
  { PMICMD_RMWWN, 0xdaee,              0xdaee,              0x00, 0x0000, WRITEONLY_DATA, &b_0 [0]            }, /*          */
  { PMICMD_RMWWN, 0xdeee,              0xdeee,              0x00, 0x0000, WRITEONLY_DATA, &b_0 [0]            }, /*          */
  { PMICMD_WAITW, A8514_STATUS,        0x02ff,              NONE, 100,    0x0000 } , /*          */
/*{ PMICMD_RMWWN, A8514_PIXELTRANSFER, A8514_PIXELTRANSFER, 0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0xe0] }, Write Once! */
  { PMICMD_RMWWN, 0xe2ee,              0xe2ee,              0x00, 0x0000, WRITEONLY_DATA, "\xff\x07"          }, /*          */
  { PMICMD_RMWWN, 0xe6ee,              0xe6ee,              0x00, 0x0000, WRITEONLY_DATA, "\xff\x07"          }, /*          */
  { PMICMD_RMWWN, 0xeeee,              0xeeee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0xee] },
/*{ PMICMD_RMWWN, 0xfeee,              0xfeee,              0x00, 0x0000, WRITEONLY_DATA, &MiscRegData [0xfe] }, Write Once! */
  { PMICMD_WAITW, A8514_STATUS,        0x02ff,              NONE, 100,    0x0000 } , /*          */
  { PMICMD_RMWWN, A8514_MULTIFUNCTION, A8514_MULTIFUNCTION, 0x00, 0x0000, WRITEONLY_DATA, "\x00\x00"          }, /*          */
  { PMICMD_RMWWN, A8514_MULTIFUNCTION, A8514_MULTIFUNCTION, 0x00, 0x0000, WRITEONLY_DATA, "\x00\x10"          },
  { PMICMD_RMWWN, A8514_MULTIFUNCTION, A8514_MULTIFUNCTION, 0x00, 0x0000, WRITEONLY_DATA, "\x00\x20"          },
  { PMICMD_RMWWN, ATI_R_VERTDSP,       A8514_MULTIFUNCTION, 0x00, 0x07ff, WRITEONLY_DATA, "\x00\x30"          },
  { PMICMD_RMWWN, ATI_R_HORZDSP,       A8514_MULTIFUNCTION, 0x00, 0x07ff, WRITEONLY_DATA, "\x00\x40"          },
  { PMICMD_RMWWN, A8514_MULTIFUNCTION, A8514_MULTIFUNCTION, 0x00, 0x0000, WRITEONLY_DATA, "\x00\x50"          },
  { PMICMD_RMWWN, A8514_MULTIFUNCTION, A8514_MULTIFUNCTION, 0x00, 0x0000, WRITEONLY_DATA, "\x00\x80"          },
  { PMICMD_RMWWN, A8514_MULTIFUNCTION, A8514_MULTIFUNCTION, 0x00, 0x0000, WRITEONLY_DATA, "\x00\x90"          },
  { PMICMD_WAITW, A8514_STATUS,        0x02ff,              NONE, 100,    0x0000 } , /*          */
  { PMICMD_RMWWN, A8514_MULTIFUNCTION, A8514_MULTIFUNCTION, 0x00, 0x0000, WRITEONLY_DATA, "\x00\xa0"          },
  { PMICMD_WAITW, A8514_STATUS,        0x02ff,              NONE, 100,    0x0000 } , /*          */
  { PMICMD_NONE }
};

CHIPINFO ATIChipSet3[] = {
  {
    0x01,
    &ChipInfoHeader[TEXT_40x25],
    &ATIMach32SetBank,                                          /*          */
    &ATIMach32GetBank,                                          /*          */
    ATIMach32ModeSet,                                           /*          */
    0,                                                          /*JWK10*/
  },
  {
    0x03,
    &ChipInfoHeader[TEXT_80x25],
    &ATIMach32SetBank,                                          /*          */
    &ATIMach32GetBank,                                          /*          */
    ATIMach32ModeSet,                                           /*          */
    0,                                                          /*JWK10*/
  },
  {
    VGAMODE,
    &ChipInfoHeader[GRAPHICS_640x480x16],
    &ATIMach32SetBank,                                          /*          */
    &ATIMach32GetBank,                                          /*          */
    ATIMach32ModeSet,
    0,                                                          /*JWK10*/
  },
  {
    0x62,
    &ChipInfoHeader[GRAPHICS_640x480x256],
    &ATIMach32SetBank,                                          /*          */
    &ATIMach32GetBank,                                          /*          */
    ATIMach32ModeSet,
    0,                                                          /*JWK10*/
  },
  {                                                             /*          */
    VESA_640_480_32K,
    &ChipInfoHeader[GRAPHICS_640x480x32K],
    &ATIMach32SetBank,                                          /*          */
    &ATIMach32GetBank,                                          /*          */
    ATIMach32ModeSet,
    0,                                                          /*JWK10*/
  },
  {                                                             /*          */
    VESA_640_480_64K,
    &ChipInfoHeader[GRAPHICS_640x480x64K],
    &ATIMach32SetBank,                                          /*          */
    &ATIMach32GetBank,                                          /*          */
    ATIMach32ModeSet,
    0,                                                          /*JWK10*/
  },
  {                                                             /*          */
    VESA_640_480_16M,
    &ChipInfoHeader[GRAPHICS_640x480x16M],
    &ATIMach32SetBank,                                          /*          */
    &ATIMach32GetBank,                                          /*          */
    ATIMach32ModeSet,
    0,                                                          /*JWK10*/
  },
  {
    0x54,
    &ChipInfoHeader[GRAPHICS_800x600x16],
    &ATIMach32SetBank,                                          /*          */
    &ATIMach32GetBank,                                          /*          */
    ATIMach32ModeSet,
    0,                                                          /*JWK10*/
  },
  {
    0x63,
    &ChipInfoHeader[GRAPHICS_800x600x256],
    &ATIMach32SetBank,                                          /*          */
    &ATIMach32GetBank,                                          /*          */
    ATIMach32ModeSet,
    0,                                                          /*JWK10*/
  },
//{                                                             /*          */
//  VESA_OLD_800_600_256,                                       /*          */
//  &ChipInfoHeader[GRAPHICS_800x600x256],                      /*          */
//  &ATIMach32SetBank,                                          /*          */
//  &ATIMach32GetBank,                                          /*          */
//  ATIMach32ModeSet,                                           /*          */
//},                                                            /*          */
  {                                                             /*          */
    VESA_800_600_32K,
    &ChipInfoHeader[GRAPHICS_800x600x32K],
    &ATIMach32SetBank,                                          /*          */
    &ATIMach32GetBank,                                          /*          */
    ATIMach32ModeSet,
    0,                                                          /*JWK10*/
  },
  {                                                             /*          */
    VESA_800_600_64K,
    &ChipInfoHeader[GRAPHICS_800x600x64K],
    &ATIMach32SetBank,                                          /*          */
    &ATIMach32GetBank,                                          /*          */
    ATIMach32ModeSet,
    0,                                                          /*JWK10*/
  },
  {                                                             /*          */
    VESA_800_600_16M,
    &ChipInfoHeader[GRAPHICS_800x600x16M],
    &ATIMach32SetBank,                                          /*          */
    &ATIMach32GetBank,                                          /*          */
    ATIMach32ModeSet,
    0,                                                          /*JWK10*/
  },
  {
    0x55,
    &ChipInfoHeader[GRAPHICS_1024x768x16],
    &ATIMach32SetBank,                                          /*          */
    &ATIMach32GetBank,                                          /*          */
    ATIMach32ModeSet,
    0,                                                          /*JWK10*/
  },
  {
    0x64,
    &ChipInfoHeader[GRAPHICS_1024x768x256],
    &ATIMach32SetBank,                                          /*          */
    &ATIMach32GetBank,                                          /*          */
    ATIMach32ModeSet,
    0,                                                          /*JWK10*/
  },
  {                                                             /*          */
    VESA_1024_768_64K,
    &ChipInfoHeader[GRAPHICS_1024x768x64K],
    &ATIMach32SetBank,                                          /*          */
    &ATIMach32GetBank,                                          /*          */
    ATIMach32ModeSet,
    0,                                                          /*JWK10*/
  },
  /* Not supported by ATI graphics engine */                    /*          */
//{                                                             /*          */
//  VESA_1024_768_16M,                                          /*          */
//  &ChipInfoHeader[GRAPHICS_1024x768x16M],                     /*          */
//  &ATIMach32SetBank,                                          /*          */
//  &ATIMach32GetBank,                                          /*          */
//  ATIMach32ModeSet,                                           /*          */
//  0,                                                          /*          */
//},                                                            /*          */
  {
    VESA_1280_1024_16,
    &ChipInfoHeader[GRAPHICS_1280x1024x16],
    &ATIMach32SetBank,                                          /*          */
    &ATIMach32GetBank,                                          /*          */
    ATIMach32ModeSet,
    0,                                                          /*JWK10*/
  },
  {
    VESA_1280_1024_256,
    &ChipInfoHeader[GRAPHICS_1280x1024x256],
    &ATIMach32SetBank,                                          /*          */
    &ATIMach32GetBank,                                          /*          */
    ATIMach32ModeSet,
    0,                                                          /*JWK10*/
  },
  /* Not supported by ATI graphics engine */                    /*          */
//{                                                             /*          */
//  VESA_1280_1024_64K,                                         /*          */
//  &ChipInfoHeader[GRAPHICS_1280x1024x64K],                    /*          */
//  &ATIMach32SetBank,                                          /*          */
//  &ATIMach32GetBank,                                          /*          */
//  ATIMach32ModeSet,                                           /*          */
//  0,                                                          /*          */
//},                                                            /*          */
  /* Not supported by ATI graphics engine */                    /*          */
//{                                                             /*          */
//  VESA_1280_1024_16M,                                         /*          */
//  &ChipInfoHeader[GRAPHICS_1280x1024x16M],                    /*          */
//  &ATIMach32SetBank,                                          /*          */
//  &ATIMach32GetBank,                                          /*          */
//  ATIMach32ModeSet,                                           /*          */
//  0,                                                          /*          */
//},                                                            /*          */
  {
    0x23,
    &ChipInfoHeader[TEXT_132x25],
    &ATIMach32SetBank,                                          /*          */
    &ATIMach32GetBank,                                          /*          */
    ATIMach32ModeSet,                                           /*          */
    0,                                                          /*JWK10*/
  },
  {
    0x33,
    &ChipInfoHeader[TEXT_132x44],
    &ATIMach32SetBank,                                          /*          */
    &ATIMach32GetBank,                                          /*          */
    ATIMach32ModeSet,                                           /*          */
    0,                                                          /*JWK10*/
  },
};

USHORT usSizeATIChipSet3 = sizeof(ATIChipSet3)/sizeof(CHIPINFO);

/*
** ATI 88800 Mach64
*/                                                              /*          */

REGDATA ATIMach64ModeSet [] =                                   /*          */
{
  { PMICMD_OUTW,  SEQ_INDEXPORT,    NONE,             NONE, 0x00,   WRITEONLY_DATA, b_0 },
  { PMICMD_BOUTB, ATI_INDEXPORT,    ATI_DATAPORT,     0x02, 0xA6,   READWRITE_DATA, &ATIRegData[0xA6] },
  { PMICMD_BOUTB, ATI_INDEXPORT,    ATI_DATAPORT,     0x03, 0xB0,   READWRITE_DATA, &ATIRegData[0xB0] },
  { PMICMD_BOUTB, ATI_INDEXPORT,    ATI_DATAPORT,     0x01, 0xB3,   READWRITE_DATA, &ATIRegData[0xB3] },
  { PMICMD_BOUTB, ATI_INDEXPORT,    ATI_DATAPORT,     0x02, 0xB5,   READWRITE_DATA, &ATIRegData[0xB5] },
  { PMICMD_BOUTB, ATI_INDEXPORT,    ATI_DATAPORT,     0x01, 0xB8,   READWRITE_DATA, &ATIRegData[0xB8] },
  { PMICMD_BOUTB, ATI_INDEXPORT,    ATI_DATAPORT,     0x01, 0xB9,   READWRITE_DATA, &ATIRegData[0xB9] },
  { PMICMD_BOUTB, ATI_INDEXPORT,    ATI_DATAPORT,     0x02, 0xBD,   READWRITE_DATA, &ATIRegData[0xBD] },
  { PMICMD_BOUTB, SEQ_INDEXPORT,    SEQ_DATAPORT,     0x05, 0x00,   READWRITE_DATA, &SEQRegData[0x00] },
  { PMICMD_OUTW,  SEQ_INDEXPORT,    NONE,             NONE, 0x00,   WRITEONLY_DATA, &bEndSEQReset[0] },
  { PMICMD_OUTB,  MISCOUTPUTREG_WRITE, NONE,          NONE, 0x00,   WRITEONLY_DATA, &MiscOutRegData },
  { PMICMD_BOUTB, CRT_INDEXPORT,    CRT_DATAPORT,     0x19, 0x00,   READWRITE_DATA, &CRTRegData[0x00] },
  { PMICMD_BOUTB, ATC_INDEXPORT,    ATC_DATAPORT,     0x15, 0x00,   READWRITE_DATA, &ATCRegData[0x00] }, /*          */
  { PMICMD_BOUTB, GDC_INDEXPORT,    GDC_DATAPORT,     0x09, 0x00,   READWRITE_DATA, &GDCRegData[0x00] },
//{ PMICMD_RMWWN, A8514_DSPCTRL,    A8514_DSPCTRL,    0x00, 0x0000, WRITEONLY_DATA, "\x20" }, /*          */

  { PMICMD_OUTW,  0x02ec, 0x02ec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x00] },
  { PMICMD_OUTW,  0x02ee, 0x02ee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x01] },
  { PMICMD_OUTW,  0x06ec, 0x06ec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x02] },
  { PMICMD_OUTW,  0x06ee, 0x06ee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x03] },
  { PMICMD_OUTW,  0x0aec, 0x0aec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x04] },
  { PMICMD_OUTW,  0x0aee, 0x0aee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x05] },
  { PMICMD_OUTW,  0x0eec, 0x0eec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x06] },
  { PMICMD_OUTW,  0x0eee, 0x0eee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x07] },
  { PMICMD_OUTW,  0x12ec, 0x12ec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x08] },
  { PMICMD_OUTW,  0x12ee, 0x12ee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x09] },
  { PMICMD_OUTW,  0x16ec, 0x16ec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x0a] },
  { PMICMD_OUTW,  0x16ee, 0x16ee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x0b] },
  { PMICMD_OUTW,  0x1aec, 0x1aec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x0c] },
  { PMICMD_OUTW,  0x1aee, 0x1aee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x0d] },
  { PMICMD_OUTW,  0x1eec, 0x1eec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x0e] },
  { PMICMD_OUTW,  0x1eee, 0x1eee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x0f] },
  { PMICMD_OUTW,  0x22ec, 0x22ec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x10] },
  { PMICMD_OUTW,  0x22ee, 0x22ee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x11] },
  { PMICMD_OUTW,  0x26ec, 0x26ec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x12] },
  { PMICMD_OUTW,  0x26ee, 0x26ee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x13] },
  { PMICMD_OUTW,  0x2aec, 0x2aec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x14] },
  { PMICMD_OUTW,  0x2aee, 0x2aee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x15] },
  { PMICMD_OUTW,  0x2eec, 0x2eec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x16] },
  { PMICMD_OUTW,  0x2eee, 0x2eee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x17] },
  { PMICMD_OUTW,  0x32ec, 0x32ec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x18] },
  { PMICMD_OUTW,  0x32ee, 0x32ee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x19] },
  { PMICMD_OUTW,  0x36ec, 0x36ec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x1a] },
  { PMICMD_OUTW,  0x36ee, 0x36ee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x1b] },
  { PMICMD_OUTW,  0x3aec, 0x3aec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x1c] },
  { PMICMD_OUTW,  0x3aee, 0x3aee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x1d] },
  { PMICMD_OUTW,  0x3eec, 0x3eec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x1e] },
  { PMICMD_OUTW,  0x3eee, 0x3eee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x1f] },
  { PMICMD_OUTW,  0x42ec, 0x42ec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x20] },
  { PMICMD_OUTW,  0x42ee, 0x42ee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x21] },
  { PMICMD_OUTW,  0x46ec, 0x46ec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x22] },
  { PMICMD_OUTW,  0x46ee, 0x46ee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x23] },
  { PMICMD_OUTW,  0x4aec, 0x4aec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x24] },
  { PMICMD_OUTW,  0x4aee, 0x4aee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x25] },
  { PMICMD_OUTW,  0x4eec, 0x4eec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x26] },
  { PMICMD_OUTW,  0x4eee, 0x4eee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x27] },
  { PMICMD_OUTW,  0x52ec, 0x52ec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x28] },
  { PMICMD_OUTW,  0x52ee, 0x52ee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x29] },
  { PMICMD_OUTW,  0x56ec, 0x56ec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x2a] },
  { PMICMD_OUTW,  0x56ee, 0x56ee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x2b] },
  { PMICMD_OUTW,  0x5aec, 0x5aec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x2c] },
  { PMICMD_OUTW,  0x5aee, 0x5aee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x2d] },
//DAC Ports need special handling:
//{ PMICMD_OUTW,  0x5eec, 0x5eec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x2e] },
//{ PMICMD_OUTW,  0x5eee, 0x5eee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x2f] },
  { PMICMD_OUTW,  0x62ec, 0x62ec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x30] },
  { PMICMD_OUTW,  0x62ee, 0x62ee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x31] },
  { PMICMD_OUTW,  0x66ec, 0x66ec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x32] },
  { PMICMD_OUTW,  0x66ee, 0x66ee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x33] },
  { PMICMD_OUTW,  0x6aec, 0x6aec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x34] },
  { PMICMD_OUTW,  0x6aee, 0x6aee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x35] },
  { PMICMD_OUTW,  0x6eec, 0x6eec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x36] },
  { PMICMD_OUTW,  0x6eee, 0x6eee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x37] },
  { PMICMD_OUTW,  0x72ec, 0x72ec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x38] },
  { PMICMD_OUTW,  0x72ee, 0x72ee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x39] },
  { PMICMD_OUTW,  0x76ec, 0x76ec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x3a] },
  { PMICMD_OUTW,  0x76ee, 0x76ee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x3b] },
  { PMICMD_OUTW,  0x7aec, 0x7aec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x3c] },
  { PMICMD_OUTW,  0x7aee, 0x7aee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x3d] },
  { PMICMD_OUTW,  0x7eec, 0x7eec, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x3e] },
  { PMICMD_OUTW,  0x7eee, 0x7eee, 0x00, 0x0000, READWRITE_DATA, &MiscRegData [2*0x3f] },
  { PMICMD_NONE }
};

CHIPINFO ATIChipSet4[] = {                                      /*          */
  {
    0x01,
    &ChipInfoHeader[TEXT_40x25],
    &ATIMach64SetBank,                                          /*          */
    &ATIMach64GetBank,                                          /*          */
    ATIMach64ModeSet,
    0,                                                          /*JWK10*/
  },
  {
    0x03,
    &ChipInfoHeader[TEXT_80x25],
    &ATIMach64SetBank,                                          /*          */
    &ATIMach64GetBank,                                          /*          */
    ATIMach64ModeSet,
    0,                                                          /*JWK10*/
  },
  {
    VGAMODE,
    &ChipInfoHeader[GRAPHICS_640x480x16],
    &ATIMach64SetBank,                                          /*          */
    &ATIMach64GetBank,                                          /*          */
    ATIMach64ModeSet,
    0,                                                          /*JWK10*/
  },
  {
    0x62,
    &ChipInfoHeader[GRAPHICS_640x480x256],
    &ATIMach64SetBank,                                          /*          */
    &ATIMach64GetBank,                                          /*          */
    ATIMach64ModeSet,
    0,                                                          /*JWK10*/
  },
  {
    VESA_640_480_32K,
    &ChipInfoHeader[GRAPHICS_640x480x32K],
    &ATIMach64SetBank,                                          /*          */
    &ATIMach64GetBank,                                          /*          */
    ATIMach64ModeSet,
    0,                                                          /*JWK10*/
  },
  {
    VESA_640_480_64K,
    &ChipInfoHeader[GRAPHICS_640x480x64K],
    &ATIMach64SetBank,                                          /*          */
    &ATIMach64GetBank,                                          /*          */
    ATIMach64ModeSet,
    0,                                                          /*JWK10*/
  },
  {
    VESA_640_480_16M,
    &ChipInfoHeader[GRAPHICS_640x480x16M],
    &ATIMach64SetBank,                                          /*          */
    &ATIMach64GetBank,                                          /*          */
    ATIMach64ModeSet,
    0,                                                          /*JWK10*/
  },
  {
    0x54,
    &ChipInfoHeader[GRAPHICS_800x600x16],
    &ATIMach64SetBank,                                          /*          */
    &ATIMach64GetBank,                                          /*          */
    ATIMach64ModeSet,
    0,                                                          /*JWK10*/
  },
  {
    0x63,
    &ChipInfoHeader[GRAPHICS_800x600x256],
    &ATIMach64SetBank,                                          /*          */
    &ATIMach64GetBank,                                          /*          */
    ATIMach64ModeSet,
    0,                                                          /*JWK10*/
  },
  {
    VESA_800_600_32K,
    &ChipInfoHeader[GRAPHICS_800x600x32K],
    &ATIMach64SetBank,                                          /*          */
    &ATIMach64GetBank,                                          /*          */
    ATIMach64ModeSet,
    0,                                                          /*JWK10*/
  },
  {
    VESA_800_600_64K,
    &ChipInfoHeader[GRAPHICS_800x600x64K],
    &ATIMach64SetBank,                                          /*          */
    &ATIMach64GetBank,                                          /*          */
    ATIMach64ModeSet,
    0,                                                          /*JWK10*/
  },
  {
    VESA_800_600_16M,
    &ChipInfoHeader[GRAPHICS_800x600x16M],
    &ATIMach64SetBank,                                          /*          */
    &ATIMach64GetBank,                                          /*          */
    ATIMach64ModeSet,
    0,                                                          /*JWK10*/
  },
  {
    VESA_OLD_800_600_256,
    &ChipInfoHeader[GRAPHICS_800x600x256],
    &ATIMach64SetBank,                                          /*          */
    &ATIMach64GetBank,                                          /*          */
    ATIMach64ModeSet,
    0,                                                          /*JWK10*/
  },
  {
    0x55,
    &ChipInfoHeader[GRAPHICS_1024x768x16],
    &ATIMach64SetBank,                                          /*          */
    &ATIMach64GetBank,                                          /*          */
    ATIMach64ModeSet,
    0,                                                          /*JWK10*/
  },
  {
    0x64,
    &ChipInfoHeader[GRAPHICS_1024x768x256],
    &ATIMach64SetBank,                                          /*          */
    &ATIMach64GetBank,                                          /*          */
    ATIMach64ModeSet,
    0,                                                          /*JWK10*/
  },
  {
    VESA_1024_768_64K,
    &ChipInfoHeader[GRAPHICS_1024x768x64K],
    &ATIMach64SetBank,                                          /*          */
    &ATIMach64GetBank,                                          /*          */
    ATIMach64ModeSet,
    0,                                                          /*JWK10*/
  },
  {
    VESA_1024_768_16M,
    &ChipInfoHeader[GRAPHICS_1024x768x16M],
    &ATIMach64SetBank,                                          /*          */
    &ATIMach64GetBank,                                          /*          */
    ATIMach64ModeSet,
    0,                                                          /*JWK10*/
  },
  {
    VESA_1280_1024_16,
    &ChipInfoHeader[GRAPHICS_1280x1024x16],
    &ATIMach64SetBank,                                          /*          */
    &ATIMach64GetBank,                                          /*          */
    ATIMach64ModeSet,
    0,                                                          /*JWK10*/
  },
  {
    VESA_1280_1024_256,
    &ChipInfoHeader[GRAPHICS_1280x1024x256],
    &ATIMach64SetBank,                                          /*          */
    &ATIMach64GetBank,                                          /*          */
    ATIMach64ModeSet,
    0,                                                          /*JWK10*/
  },
  {
    VESA_1280_1024_64K,
    &ChipInfoHeader[GRAPHICS_1280x1024x64K],
    &ATIMach64SetBank,                                          /*          */
    &ATIMach64GetBank,                                          /*          */
    ATIMach64ModeSet,
    0,                                                          /*JWK10*/
  },
  /* Not supported by ATI graphics engine */                    /*          */
//{                                                             /*          */
//  VESA_1280_1024_16M,                                         /*          */
//  &ChipInfoHeader[GRAPHICS_1280x1024x16M],                    /*          */
//  &ATIMach32SetBank,                                          /*          */
//  &ATIMach32GetBank,                                          /*          */
//  ATIMach32ModeSet,                                           /*          */
//  0,                                                          /*          */
//},                                                            /*          */
  {
    0x23,
    &ChipInfoHeader[TEXT_132x25],
    &ATIMach64SetBank,                                          /*          */
    &ATIMach64GetBank,                                          /*          */
    ATIMach64ModeSet,
    0,                                                          /*JWK10*/
  },
  {
    0x33,
    &ChipInfoHeader[TEXT_132x44],
    &ATIMach64SetBank,                                          /*          */
    &ATIMach64GetBank,                                          /*          */
    ATIMach64ModeSet,
    0,                                                          /*JWK10*/
  },
};

USHORT usSizeATIChipSet4 = sizeof(ATIChipSet4)/sizeof(CHIPINFO);

INT aiATIMach32DacIndex [8] =
{
  ATI68830_DAC,              /* 00 */
  SC15025_DAC,               /* 01 */ /* SC11483/SC11486/SC11488 */
  TLC34075_DAC,              /* 02 */ /* OR ATI34075/ATI68875 */
  BT481_DAC,                 /* 03 */ /* OR BT482 */
  HICOLOR_DAC,  /*has test!*//* 04 */ /* ATT20C491 */           /*          */
  HICOLOR_DAC,               /* 05 */                           /*          */
  HICOLOR_DAC,               /* 06 */                           /*          */
  HICOLOR_DAC,               /* 07 */                           /*          */
};

INT aiATIMach64DacIndex [8] =
{
  HICOLOR_DAC,               /* 00 */ /* Reserved */            /*          */
  HICOLOR_DAC,               /* 01 */ /* Reserved */            /*          */
  TLC34075_DAC,              /* 02 */ /* OR ATI30475/ATI68875 */
  BT476_DAC,                 /* 03 */ /* OR BT478 */
  BT481_DAC,                 /* 04 */ /* OR BT482 */
  ATI68860_DAC,              /* 05 */ /* OR ATI68880 */
  HICOLOR_DAC,  /*has test!*//* 06 */ /* STG1700 */             /*          */
  /* Not as specified in the documentation! */                  /*          */
//HICOLOR_DAC,  /*has test!*//* 07 */ /* SC15021 */             /*          */
  HICOLOR_DAC,  /*has test!*//* 07 */ /* STG1702 */             /*          */
};

/*****************************************************************************
 *
 * FUNCTION NAME = ATIVGAAdjustedPort()
 *
 * DESCRIPTION   = Adjusts standard port addresses as necessary
 *                 For ATI,
 *                 DAC addresses are adjusted from 03c6:03c9 to 02ea:02ed
 *
 * INPUT         = usStandardPort
 * OUTPUT        = usAdjustedPort
 *
 * RETURN-ERROR  = NONE
 * RETURN-NORMAL = NONE
 *
 ****************************************************************************/

USHORT ATIVGAAdjustedPort(                                      /*          */
  USHORT usStandardPort )
{
  return( usStandardPort );
}

/*****************************************************************************
 *
 * FUNCTION NAME = ATIMach32AdjustedPort()
 *
 * DESCRIPTION   = Adjusts standard port addresses as necessary
 *                 For ATI,
 *                 DAC addresses are adjusted from 03c6:03c9 to 02ea:02ed
 *
 * INPUT         = usStandardPort
 * OUTPUT        = usAdjustedPort
 *
 * RETURN-ERROR  = NONE
 * RETURN-NORMAL = NONE
 *
 ****************************************************************************/

USHORT ATIMach32AdjustedPort(                                   /*          */
  USHORT usStandardPort )
{
  return( ((usStandardPort >= 0x03c6)
           && (usStandardPort <= 0x03c9))
          ? usStandardPort - (0x03c6 - 0x02ea)
          : usStandardPort );
}

/*****************************************************************************
 *
 * FUNCTION NAME = ATIMach64AdjustedPort()
 *
 * DESCRIPTION   = Adjusts standard port addresses as necessary
 *                 For ATI,
 *                 DAC addresses are adjusted from 03c6:03c9 to 5eec:5eef
 *
 * INPUT         = usStandardPort
 * OUTPUT        = usAdjustedPort
 *
 * RETURN-ERROR  = NONE
 * RETURN-NORMAL = NONE
 *
 ****************************************************************************/

USHORT ATIMach64AdjustedPort(                                   /*          */
  USHORT usStandardPort )
{
  return( ((usStandardPort >= 0x03c6)
           && (usStandardPort <= 0x03c9))
          ? (usStandardPort & 0x0003) | 0x5eec
          : usStandardPort );
}

/*****************************************************************************
 *
 * FUNCTION NAME = ATIDacGetType()
 *
 * DESCRIPTION   = Identifies DAC and returns one of the following:
 *                    0  Unsupported DAC
 *                    1  Generic 44 pin DAC
 *                    2  Brooktree 485
 *                    3  Brooktree 485 (used by Viper)
 *                    4  Sierra
 *                    5  AT&T
 *                    6  Music
 *
 * INPUT         = NONE
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = 0-5 Supported DAC
 *
 ****************************************************************************/

INT ATIDacGetType( VOID )                                       /*          */
{
  INT iDacIndex;
  /* Programming examples not consistent with reference! */

  iDacIndex = SVGADacGetType();                                 /*          */
//if( iDacIndex <= HICOLOR_DAC )                                /*          */
    switch( sSVGA.ChipType )
    {
      case ATI_68800_CHIP:
        /* check CONFIG_STATUS_1 */
        iDacIndex =
          aiATIMach32DacIndex
            [(InpwDelay( 0x12ee ) >> 0x09) & 0x07];             /*          */
        break;
      case ATI_88800_CHIP:
        /* check CONFIG_STAT0 */
        iDacIndex =
          aiATIMach64DacIndex
            [(InpwDelay( 0x72ec ) >> 0x09) & 0x07];             /*          */
        break;
      case ATI_18800_CHIP:
      case ATI_28800_CHIP:
      case ATI_38800_CHIP:
      default:
        iDacIndex = DEFAULT_DAC;                                /*          */
        break;
    }
  if( iDacIndex <= HICOLOR_DAC )                                /*          */
    iDacIndex = SVGADacGetType();                               /*          */
  return( iDacIndex );
}

/*****************************************************************************/

SADAPTERINFO sATIAdapterInfo;           /* Forward */           /*          */
SADAPTERINFO sATIMach32AdapterInfo;     /* Forward */           /*          */
SADAPTERINFO sATIMach64AdapterInfo;     /* Forward */           /*          */

/*****************************************************************************
 *
 * FUNCTION NAME = ATIEditTables()
 *
 * DESCRIPTION   = Edits sATIAdapterInfo depending upon chiptype
 *
 * INPUT         = NONE
 * OUTPUT        = NONE
 *
 ****************************************************************************/

VOID ATIEditTables( VOID )                                      /*          */
{
  switch( sSVGA.ChipType )
  {
    case ATI_18800_CHIP:
    case ATI_28800_CHIP:
      psCurAdapterInfo = &sATIAdapterInfo;
      break;
    case ATI_38800_CHIP:
    case ATI_68800_CHIP:
      psCurAdapterInfo = &sATIMach32AdapterInfo;
      break;
    case ATI_88800_CHIP:
      psCurAdapterInfo = &sATIMach64AdapterInfo;
      break;
    default:
      break;
  }
}

/*****************************************************************************/

SADAPTERINFO sATIAdapterInfo =                                  /*          */
{                                                               /*          */
  ATIEditTables,                                                /*          */
  ATIVGAAdjustedPort,                                           /*          */
  aRegDataNone,                                                 /*          */
  aRegDataNone,                                                 /*          */
  aRegDataNone,                                                 /*          */
  aRegDataNone,                                                 /*          */
  ATIDacGetType,
};                                                              /*          */

SADAPTERINFO sATIMach32AdapterInfo = /* Mach8/32 */             /*          */
{                                                               /*          */
  ATIEditTables,                                                /*          */
  ATIMach32AdjustedPort,                                        /*          */
  aRegDataATIMach32DacRS2Clear,                                 /*          */
  aRegDataATIMach32DacRS2Set,                                   /*          */
  aRegDataATIMach32DacRS3Clear,                                 /*          */
  aRegDataATIMach32DacRS3Set,                                   /*          */
  ATIDacGetType,
};                                                              /*          */

SADAPTERINFO sATIMach64AdapterInfo = /* Mach64 */               /*          */
{                                                               /*          */
  ATIEditTables,                                                /*          */
  ATIMach64AdjustedPort,                                        /*          */
  aRegDataATIMach64DacRS2Clear,                                 /*          */
  aRegDataATIMach64DacRS2Set,                                   /*          */
  aRegDataATIMach64DacRS3Clear,                                 /*          */
  aRegDataATIMach64DacRS3Set,                                   /*          */
  ATIDacGetType,
};                                                              /*          */

