/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/****************************************************************************
 *
 * SOURCE FILE NAME = SVGA.H
 *
 * DESCRIPTIVE NAME = Include file for svga.c
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 *     Definition statements and structures.
 *
 *      Note: The structures set up to produce PMI-file data should
 *            be organised in ascending order of resolution.
 *
 * FUNCTIONS
 *
 * NOTES
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define  COPY_NOTICEA   "Version 2.15 "                         /*          */
#define  COPY_NOTICEB   "(C)Copyright IBM Corp. 1992 Licensed Material "
#define  COPY_NOTICEC   "-- Program Property of IBM"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <fcntl.h>
#include <conio.h>
#include <stdarg.h>

#define INCL_NOBASEAPI
#define INCL_NOPMAPI
#include <os2.h>
#define INCL_NONE                                               /*          */
#define INCL_VIDEOHW                                            /*          */
#include <vvd.h>                                                /*          */
#include <svgadefs.h>

/*
**              Constants
*/

/*
**    PMI VERSION NUMBERS:
**
**    2.10      Version as supported by OS2.10 GA
**              Lock/Unlock have outb only
**              Cleanup has RMWB/RMWW only
**              No WAIT in use
**              RMWW was really an unindexed byte modify
**    2.11      Version as supported by OS2.11 GA
**              No known differences from 2.10
**    2.12      Word wide waits instead of byte wide waits
**    2.13      Locks & unlocks were in outb pairs where
**              lock was reverse of unlock for push & pop
**    2.14      Getbank/SetBank added
**              Lock/Unlock and Cleanup can have any commands.
**              RMWB=>RMWBI
**              RMWW=>RMWBN
**              RMWW?=>RMWWN
**              Unlock section includes reads for push
**              Lock section includes register assigns ignored for pop
**    2.15      Hardware section added
**              #includecode added
**              [MonitorModeInfo] added
**    Future:
**    2.16      Format of trapreg section changed
**    V3        Version as supported by OS2 V3 GA
*/
#define VERSION                 "2.15"                          /*          */

#define FILE_HEADER             "OS/2 V3 SVGA PMI-File Generator"
#define CONFIG_HEADER           "OS/2 V3 Current video configuration file"

#define LOCK_HEADER1  "This section locks adapter and chip"     /*          */
#define LOCK_HEADER2  "AS MUCH as BIOS does and NOT MORE!"      /*          */
#define LOCK_HEADER3  "In other words, it restores the NORMAL lock state."

#define BANNER                  "\nSVGA: PMI File Generator (v%s)\n"
#define USAGE                   "Usage: SVGA <ON | OFF | STATUS | MONITOR> <DOS | INIT | GENERIC>\n"

#define STATUS_TEXT             "AdapterType: %s, ChipType: %s, TotalMemory: %ld\n"
/*                                                            ^^^^^^^^^^^^^^*/
                                                                /*          */
#define SUPPORTED_MODES         "\nPossible Supported Modes:\n"

#define MAX_REGISTER_NAME       25                              /*          */
#define MAX_MEMORY_REGISTERS    40                              /*          */
//#define IO_NOT_MEMORYMAPPED   0x00000000                      /*          */
//#define IO_MEMORYMAPPED       0xFFFFFFFF                      /*          */
#define VIPER_MMIO_ADDRESS      0x80000000                      /*          */
#define WINDOW_2MB              0x200000                        /*          */

#define PMI_CREATE              "ON"
#define PMI_DELETE              "OFF"
#define PMI_STATUS              "STATUS"
#define PMI_DOS                 "DOS"
#define PMI_MONITOR             "MONITOR"
#define PMI_INIT                "INIT"
#define PMI_GENERIC             "GENERIC"
#define PMI_INSTALL             "INSTALL"                       /*          */
#define PMI_DEBUG               "DEBUG"                         /*          */
#define PMI_REFRESH             "REFRESH"                       /*@V3.0YEE02*/

#define GENERIC_ADAPTER         "Generic VGA"
#define GENERIC_CHIPSET         "Generic VGA"

#define PARM_BAD                0
#define PARM_NONE               1
#define PARM_CREATE             2
#define PARM_DELETE             3
#define PARM_STATUS             4
#define PARM_DOS                5
#define PARM_INIT               6
#define PARM_GENERIC            7
#define PARM_INSTALL            8                               /*          */
#define PARM_DEBUG              9                               /*          */
#define PARM_REFRESH            10                              /*@V3.0YEE02*/

#define ERROR_MSG_HEADER        "Error: %s\n"
#define ERROR_MSG_UNSUPPORTED   "unsupported adapter or chipset"        /* 1 */
#define ERROR_MSG_NEEDVESA      "requires VESA-compliant BIOS"          /* 2 */
#define ERROR_MSG_FULLSCREEN    "must be run in a DOS full screen session"/*3*/
#define ERROR_MSG_DELETE        "unable to delete file"                 /* 4 */
#define ERROR_MSG_PARM          "bad parameter"                         /* 5 */
#define ERROR_MSG_MEMORY        "failed to allocate memory"             /* 6 */
#define ERROR_MSG_ADAP_NOT_CONFIGURED "Run configuration utility first" /* 7 */

#define ERROR_NUM_UNSUPPORTED   1
#define ERROR_NUM_NEEDVESA      2
#define ERROR_NUM_FULLSCREEN    3
#define ERROR_NUM_DELETE        4
#define ERROR_NUM_PARM          5
#define ERROR_NUM_MEMORY        6
#define ERROR_ADAPTER_NOT_CONFIGURED 7

#define COMMENT_MSG_SETMISCOUTPUT  "Set Miscellaneous Output Register"
#define COMMENT_MSG_SETSEQUENCER   "Set Sequencer Registers"
#define COMMENT_MSG_LOCKREGS       "Lock Extended Registers"
#define COMMENT_MSG_UNLOCKREGS     "Unlock Extended Registers"
#define COMMENT_MSG_SETEXTSEQ      "Set Extended Sequencer Registers"
#define COMMENT_MSG_SETCRT         "Set CRT Registers"
#define COMMENT_MSG_SETATC         "Set Attribute Registers"
#define COMMENT_MSG_SETGDC         "Set GDC Registers"
#define COMMENT_MSG_SETPOS         "Set POS Registers"
#define COMMENT_MSG_SETENHANCED    "Set Enhanced Command Registers"
#define COMMENT_MSG_HICOLOR        "Set DAC Registers"          /*          */
#define COMMENT_MSG_SETMEMORYREGS  "Set Memory Mapped Registers"/*          */
#define COMMENT_MSG_CLOCK_CHIP     "Set Programmable Clock Chip"
#define COMMENT_MSG_SETOTHER       "Set Other Registers"        /*          */

#define COMMENT_SETMISCOUTPUT   0
#define COMMENT_SETSEQUENCER    1
#define COMMENT_LOCKREGS        2
#define COMMENT_UNLOCKREGS      3
#define COMMENT_SETEXTSEQ       4
#define COMMENT_SETCRT          5
#define COMMENT_SETATC          6
#define COMMENT_SETGDC          7
#define COMMENT_SETPOS          8
#define COMMENT_SETENHANCED     9
#define COMMENT_HICOLOR         10
#define COMMENT_SETMEMORYREGS   11
#define COMMENT_CLOCK_CHIP      12
#define COMMENT_SETOTHER        13                              /*          */

#define MAX_PARMLEN             80      /* max length of above parms */
#define PMI_FNAME               "c:\\os2\\svgadata.pmi"
#define VIDEOCFG_FNAME          "c:\\os2\\video.cfg"            /*          */

#define VBIOS                   0x10    /* video bios interrupt number       */
#define LBIOS                   0x15    /* query Lacuna Bios                 */
#define TEXTMODE                3       /* colour text mode                  */
#define VGAMODE                 0x12    /* 640x480x16                        */
#define GRAPHICS_MODEATTR       0x10
#define MAX_PORTS               100
#define MAX_MODES               30


#define TRUE                    1
#define FALSE                   0

#define WD90C2X_SHADOW_LOCKED   TRUE                            /*          */

#define INTERLACED              0
#define NONINTERLACED           1

#define NONE                    0
#define MAX_CLOCK_REGDATA       40                              /*          */

#define  CRT_INDEXPORT          0x3d4
#define  CRT_DATAPORT           0x3d5
#define  MONO_INDEXPORT         0x3b4                           /*          */
#define  MONO_DATAPORT          0x3b5                           /*          */
#define  GDC_INDEXPORT          0x3ce
#define  GDC_DATAPORT           0x3cf
#define  SEQ_INDEXPORT          0x3c4
#define  SEQ_DATAPORT           0x3c5
#define  ATC_INDEXPORT          0x3c0
#define  ATC_DATAPORT           0x3c1
#define  DAC_PIXELMPORT         0x3c6
#define  DAC_READPORT           0x3c7                           /*          */
#define  DAC_WRITEPORT          0x3c8                           /*          */
#define  DAC_DATAPORT           0x3c9
#define  INPSTATUSREG1          0x3da
#define  MISCOUTPUTREG_READ     0x3cc
#define  MISCOUTPUTREG_WRITE    0x3c2
#define  ATI_INDEXPORT          0x1ce
#define  ATI_DATAPORT           0x1cf
#define  WD_INDEXPORT           0x23c0                          /*          */
#define  WD_DATAPORT            0x23c2                          /*          */
#define  WD_BITBLTPORT          0x23c4                          /*          */
#define  WD_HBLT0PORT           0x23c4                          /*          */
#define  WD_HBLT1PORT           0x23c6                          /*          */
#define  WD_K1PORT              0x23c8                          /*          */
#define  WD_K2PORT              0x23ca                          /*          */
#define  WD_ETPORT              0x23cc                          /*          */
#define  WD_ENGINEPORT          0x23ce                          /*          */
#define  WD_BUSPORT             0x2de0                          /*          */
#define  WD_MEMPORT             0x2de2                          /*          */
#define  WD_BUSPORT2            0x2df0                          /*          */
#define  WD_MEMPORT2            0x2df2                          /*          */
#define  XGAOPMODE_WRITE        0x2100
#define  XGAVRAMWIN_WRITE       0x2101
#define  XGAINTENABLE_WRITE     0x2104
#define  XGAINTSTATUS_WRITE     0x2105
#define  XGABANKSEL_WRITE       0x2108
#define  XGAMEMMODE_WRITE       0x2109
#define  XGAINDEX_WRITE         0x2109
#define  XGADATA_WRITE0         0x210A
#define  XGADATA_WRITE1         0x210B
#define  XGADATA_WRITE2         0x210C
#define  XGADATA_WRITE3         0x210D
#define  XGADATA_WRITE4         0x210E
#define  XGADATA_WRITE5         0x210F
#define  VIPER_COMREG0          0x43C6
#define  VIPER_COMREG1          0x83C8
#define  VIPER_COMREG2          0x83C9
#define  VIPER_COMREG3          0x83C6

#define  MC_SETUPREG            0x96
#define  MC_POS3REG             0x103
#define  ORCHID_PSEUDO          0x3dd

#define  S3_SUBSYS_STAT         0x42e8
#define  S3_SUBSYS_CNTL         0x42e8
#define  S3_ADVFUNC_CNTL        0x4ae8
#define  S3_CUR_Y               0x82e8
#define  S3_CUR_X               0x86e8
#define  S3_DESTY_AXSTP         0x8ae8
#define  S3_DESTX_DIASTP        0x8ee8
#define  S3_ERR_TERM            0x92e8
#define  S3_MAX_AXIS_PCNT       0x96e8
#define  S3_GP_STAT             0x9ae8
#define  S3_CMD                 0x9ae8
#define  S3_SHORT_STROKE        0x9ee8
#define  S3_BKGN_COLOR          0xa2e8
#define  S3_FRGD_COLOR          0xa6e8
#define  S3_WRT_MASK            0xaae8
#define  S3_RD_MASK             0xaee8
#define  S3_COLOR_CMP           0xb2e8
#define  S3_BKGD_MIX            0xb6e8
#define  S3_FRGD_MIX            0xbae8
#define  S3_RD_REG_DT           0xbee8
#define  S3_MULTIFUNCTION       0xbee8
#define  S3_PIX_TRANS           0xe2e8
#define  S3_PIX_TRANS_EXT       0xe2ea

#define CALL_NONE                0x00           //          
#define CALL_MONITOR_TIMINGS     0x01           //predefined pfnPMISetMonitorTimings
#define CALL_SET_MODE            0x02           //predefined pfnPMISetMode
#define CALL_IDENTIFY            0x04           //predefined pfnPMIIdentifyAdapter
#define CALL_NON_STANDARD        0x08           //free name: name pointer in pData (regdata)
#define LINEAR_APERTURE_DECLARED 0x10           //other attributes of the adapter

#define MON_INDEX_640           0               //moved from svga.c            
#define MON_INDEX_800           1
#define MON_INDEX_1024          2
#define MON_INDEX_1280          3
#define MON_INDEX_1600          4               /*@V3.0YEE01*/
/*
** MonitorModeInfo vertical refresh values
*/
#undef MAX_MONITOR_MODES
#define MAX_MONITOR_MODES       10              //upto 10 refreshes per mode           
#define MAX_REFRESH_MODES       10              //upto 10 modes of interest in the refresh table
#define MAX_REFRESHTABLE_ENTRIES  40            //upto 40 possible refresh selections @V3.0YEE02
#define NO_REFRESH      (BYTE) -1               //0 is a valid refresh for non-CRT
#define REFRESH_DISABLED (BYTE) -2              //JWK18 is a valid refresh but has been disabled
#define TSENG_MAX_REFRESH_RATE  4               //JWK10
#define TSENG_RESOLUTION_DISABLED 5             //JWK10
#define TSENG_REFRESH_ANY        6              //JWK26
#define TSENG_REFRESH_UNKNOWN  (BYTE) -3        //JWK26
#define TSENG_REFRESH_UNLIMITED (BYTE)-3        //JWK26
#define TSENG_CHECK_DISABLED 2                  //JWK26
#define TSENG_CHECK_LIMITS   3                  //JWK26
#define TSENG_FIND_CLOSEST   4                  //JWK26
typedef struct _REFRESHMODE
{
  USHORT        usXResolution;
  USHORT        usYResolution;
  BYTE          DefaultVRefresh;         /* used to format the VIDEO.CFG */
  BYTE          VerticalRefresh[MAX_MONITOR_MODES];     /*            */
}REFRESHMODE;

typedef struct _REFRESHTABLE                            /* @V3.0YEE02 */
{
  USHORT        usXRes;
  char          usVertRefresh;
  BYTE          CR5B;
  BYTE          CR52;
}REFRESHTABLE;
/*
** Format for byte IO Port commands:
** (command,indexport,dataport,startindex,numentries,flags,ptrdata)
** Format for word IO port commands:
** (command,indexport,[dataport|0],0,value,flags,ptrdata)
** Commands:
**   PMICMD_INB
**   PMICMD_OUTB
**   PMICMD_INW
**   PMICMD_OUTW
**   PMICMD_BINB
**   PMICMD_BOUTB
** Format for read-modify-write Port commands:
** (command,indexport,dataport,index,andmask,ormask,0)
** Commands:
**   PMICMD_RMWBI
**   PMICMD_RMWBN
**   PMICMD_RMWWN
** Format for register command:
** (command,0,0,0,register_index,flag,ptrdata)
**   PMICMD_REGOP
** wait command: Format is
** (command,port,mask,count,value,0)
**   PMICMD_WAIT
** waitw command: Format is
** (command,port,mask,0,value,0)
**   PMICMD_WAITW
** Format for memory commands:
** (command,source,destination,flag,ptrdata)
** Commands:
**  PMICMD_READB
**  PMICMD_READW
**  PMICMD_READDW
**  PMICMD_WRITEB
**  PMICMD_WRITEW
**  PMICMD_WRITEDW
**             *See note on initialization below _REGDATA declaration.
** Format for if,while command:
** (command,tokleftoperand,tokoperator,tokrightoperand,0)
**  PMICMD_IF
**  PMICMD_WHILE
** Format for endwhile command:
**  (command,0,0,0,0)
**  PMICMD_ENDWHILE
*/

/*
**      REGDATA Flags
*/

#define  READWRITE_DATA         0x0001  /* read this data from registers   */
#define  WRITEONLY_DATA         0x0002  /* write to file, don't read regs  */
#define  DONTWRITE_DATA         0x0004  /* don't generate register assigns */
#define  WRITEREG_DATA          0x0008  /* write register data             */
#define  EXECUTE_CMD            0x1000  /* execute this command as part of SetupHardware */
#define  RS2                    0x2000  /* set RS2 before this command */
#define  RS3                    0x4000  /* set RS3 before this command */

/*
 * <register command> ::=
 * R = REG OP IMM    (note that negate can be used only on REG here)
 * R OP= Right_OP
 * Right_OP ::= { REG , IMM , ~IMM }
 * REG ::= { Rx , ~Rx}
 * IMM ::= byte_immediate or long_immediate (specified in Data, size in RegSize)
 * OP ::= [ &, |,^,<<,>>]
 *
 * NONE            |NONE            |NONE         denotes (rx =       imm)
 * NONE            |NONE            |REGISTER_OPS denotes (rx = ry OP imm)
 * NONE            |REGISTER_OPERAND|NONE         denotes (rx =       ry )
 * NONE            |REGISTER_OPERAND|REGISTER_OPS denotes (rx = ry OP imm) (redundant!)
 * REGISTER_OPEQUAL|NONE            |NONE         denotes (invalid)
 * REGISTER_OPEQUAL|NONE            |REGISTER_OPS denotes (rx = rx OP imm) == (rx OP= imm) (redundant!)
 * REGISTER_OPEQUAL|REGISTER_OPERAND|NONE         denotes (invalid)
 * REGISTER_OPEQUAL|REGISTER_OPERAND|REGISTER_OPS denotes (rx = rx OP ry ) == (rx OP= ry )
 *
 * REGISTER_ALL is the category of all binary operations.
 * REGISTER_NEGATE complements right operand.
 */
#define  REGISTER_OPFLAG        0xFFF2  /* mask for register operations    */
#define  REGISTER_OPERAND       0x0010  /* register operand */
#define  REGISTER_NEGATE        0x0020  /* negate register refers to left operand only */
#define  REGISTER_OR            0x0040  /*   OR                            */
#define  REGISTER_XOR           0x0080  /*   XOR                           */
#define  REGISTER_AND           0x0100  /*   AND                           */
#define  REGISTER_SHL           0x0200  /*   shift left                    */
#define  REGISTER_SHR           0x0400  /*   shift right                   */
#define  REGISTER_OPEQUAL       0x0800  /* operation on same register */
#define  REGISTER_ALL    (REGISTER_AND|REGISTER_OR|REGISTER_XOR| \
                          REGISTER_SHL|REGISTER_SHR)

/*
**      REGDATA Source and Destination Type Flags
** Note: these repeat the range of REGISTER_ operations which are not
** allowed in MMIO commands. Register operations have to be achieved
** thru PMICMD_REGOP class of commands.
** READWRITE_DATA, MMIO_READWRITE_ALL appy to the adapters for which the
** mmio mapped hardware can be read, despite the 1MB physical range limit
** in real mode. For the registers which can be hardcoded (not
** configuration specific, specify the values in the chipinfo section using
** MMIO_SRC_IMMEDIATE only.
*/
#define SIZE_FIELD 0x000F         /* MMIO.MemFlags bit positions must be preserved */
#define BYTE_REG   0x0008         /* keep this order */
#define WORD_REG   0x0004
#define DWORD_REG  0x0002
#define IOPORT     0x0010
#define MULTIPORT  0x0020
#define WRITE_REG  0x0040
#define READ_REG   0x0080

#define  MMIO_SRC_MASK         0x0F00
#define  MMIO_SRC_IMMEDIATE    0x0100  /* source is immediate data   */
#define  MMIO_SRC_REGISTER     0x0200  /* source is a registar  */
#define  MMIO_SRC_VARIABLE     0x0400  /* source is a variable  */
#define  MMIO_DST_MASK         0xF000
#define  MMIO_DST_IMMEDIATE    0x1000  /* destination is immediate data   */
#define  MMIO_DST_REGISTER     0x2000  /* destination is a register  */
#define  MMIO_DST_VARIABLE     0x4000  /* destination is a variable  */
                                       /* next two applicable only for MMIO_DST_VARIABLE| */
                                       /* MMIO_SRC_IMMEDIATE with WRITE commands */
#define  MMIO_READWRITE_ALL    0x0004  /* read hardware for all declared registers */
//#define  MMIO_READCONF_ALL     0x0008  /* dump all registers found in the configuration file */
#define  MMIO_RUNTIME_DATA     0x0008  /* pData is set for each mode at run time, no hardware reading *//*          */

#define SET_DAC         1        /* real hardware state of the DAC */
#define RESET_DAC       0        /* pseudo mode (256)              */
/*
**      External Clock Programming Information
**
** These are the indices into the ICDesign1
*/
#define S3SDACClk         1      /* S3Vision with SDAC                */

#define MODE_NOT_SUPPORTED 0     /* if Int10Mode set to this, mode not supported. */
                                 /* used on adapters where mode support determined
                                    from a configuration file, rather than from BIOS
                                    mode set! Used to preprocess the chipinfo*/
/*
** VESA Mode Numbers.
*/

#define VESA_OLD_800_600_256    0x06a
#define VESA_640_480_256        0x101
#define VESA_800_600_16         0x102
#define VESA_800_600_256        0x103
#define VESA_1024_768_16        0x104
#define VESA_1024_768_256       0x105
#define VESA_1280_1024_16       0x106
#define VESA_1280_1024_256      0x107
#define VESA_108                0x108
#define VESA_TEXT_132_25        0x109
#define VESA_TEXT_132_43        0x10a
#define VESA_10B                0x10b
#define VESA_10C                0x10c
#define VESA_10D                0x10d
#define VESA_10E                0x10e
#define VESA_10F                0x10f
#define VESA_640_480_32K        0x110
#define VESA_640_480_64K        0x111
#define VESA_640_480_16M        0x112
#define VESA_800_600_32K        0x113
#define VESA_800_600_64K        0x114
#define VESA_800_600_16M        0x115
#define VESA_1024_768_32K       0x116
#define VESA_1024_768_64K       0x117
#define VESA_1024_768_16M       0x118
#define VESA_1280_1024_64K      0x11a
#define VESA_1280_1024_16M      0x11b                           /*          */
#define VESA_1600_1200_256      0x120
#define S3_1152_864_256         0x207
#define S3_640_480_24bpp        0x212                           /*          */
#define BTS3_800_600_64K        0x214
#define BTS3_640_480_16M        0x220

/*
** these indices point into the register entry in the Declaration
** table for the memory registers. Make sure that order matches.
** Used in PMICMD_WRITEx and PMICMD_READx commands, whenever a VARIABLE
** flag specified and an individual variable command is used.
** MMIO_READWRITE_ALL allows a complete dump of all of the declared
** registers, in which case the register index (dst) is not used.
*/

#define WEITEK_MMIO_INDEX_SYSCONFIG 0
#define WEITEK_MMIO_INDEX_INTERRUPT_EN 1
#define WEITEK_MMIO_INDEX_X0Y0      2
#define WEITEK_MMIO_INDEX_X1Y1      3
#define WEITEK_MMIO_INDEX_X2Y2      4
#define WEITEK_MMIO_INDEX_X3Y3      5
#define WEITEK_MMIO_INDEX_CINDEX    6
#define WEITEK_MMIO_INDEX_W_OFF     7
#define WEITEK_MMIO_INDEX_FGROUND   8
#define WEITEK_MMIO_INDEX_BGROUND   9
#define WEITEK_MMIO_INDEX_PMASK     10
#define WEITEK_MMIO_INDEX_DRAW_MODE 11
#define WEITEK_MMIO_INDEX_PAT_ORX   12
#define WEITEK_MMIO_INDEX_PAT_ORY   13
#define WEITEK_MMIO_INDEX_RASTER    14
#define WEITEK_MMIO_INDEX_PIXEL8    15
#define WEITEK_MMIO_INDEX_W_MIN     16
#define WEITEK_MMIO_INDEX_W_MAX     17
#define WEITEK_MMIO_INDEX_PAT1      18
#define WEITEK_MMIO_INDEX_PAT2      19
#define WEITEK_MMIO_INDEX_PAT3      20
#define WEITEK_MMIO_INDEX_PAT4      21
#define WEITEK_MMIO_INDEX_PAT5      22
#define WEITEK_MMIO_INDEX_PAT6      23
#define WEITEK_MMIO_INDEX_PAT7      24
#define WEITEK_MMIO_INDEX_PAT8      25
#define WEITEK_MMIO_INDEX_HRZT      26
#define WEITEK_MMIO_INDEX_HRZSR     27
#define WEITEK_MMIO_INDEX_HRZBR     28
#define WEITEK_MMIO_INDEX_HRZBF     29
#define WEITEK_MMIO_INDEX_PREHRZC   30
#define WEITEK_MMIO_INDEX_VRTT      31
#define WEITEK_MMIO_INDEX_VRTSR     32
#define WEITEK_MMIO_INDEX_VRTBR     33
#define WEITEK_MMIO_INDEX_VRTBF     34
#define WEITEK_MMIO_INDEX_PREVRTC   35
#define WEITEK_MMIO_INDEX_SRTCTL    36
#define WEITEK_MMIO_INDEX_MEMCONFIG 37
#define WEITEK_MMIO_INDEX_RFPERIOD  38
#define WEITEK_MMIO_INDEX_RFCOUNT   39
#define WEITEK_MMIO_INDEX_RLMAX     40
#define WEITEK_LINEAR_APERTURE_INDEX 41                         /*          */

#define VIPER_VGAENABLE      0x80 /* seq 12 maps P9000 in/out *//*          */
#define VIPER_MMIO_ADDR_BITS 0x03                               /*          */
#define VIPER_VGADISABLE     0x10                               /*          */

/*
** To extract offset or segment/selector from any FAR (16:16) pointer
*/

#define SEGMENTOF(p)    SELECTOROF(p)
#define UPBYTE(p)       ((BYTE)(p>>8))

#pragma  intrinsic(memset)

/*
**      Type Definitions
*/

typedef struct _SVESAVGAINFOBLOCK                               /*          */
{
  char          VESASignature[4];       /* 'VESA' if valid                   */
  USHORT        VESAVersion;            /* VESA Version number               */
  char far      *OEMStringPtr;          /* Pointer to OEM string             */
  ULONG         Capabilities;           /* Capabilities of video env         */
  USHORT far    *VideoModePtr;          /* Pointer to supported modes        */
  USHORT        TotalMemory;            /* No of 64k memory blocks           */
  char Reserved[242];                   /* Pad out to 256 bytes              */
} SVESAVGAINFOBLOCK,far *PSVESAVGAINFOBLOCK;                    /*          */

typedef struct _SEDIDINFOBLOCK                                   /*@V3.0YEE01*/
{
  char          Header[8];              /* header                            */
  char          ProductID[10];          /* Vendor/Product Identification     */
  char          Version[2];             /* Version/Revision                  */
  char          DisplayParms[15];       /* Display Parameters/Features       */
  UCHAR         EstablishedTimings[19]; /* Established/Standard Timings      */
  UCHAR         DetailedTimings[72];    /* Detailed Timing Descriptions      */
  char          Flag[1];                /* Extension Flag                    */
  char          Checksum[1];            /* Checksum                          */
} SEDIDINFOBLOCK,far *PSEDIDINFOBLOCK;

typedef struct _PORTS
{
  ULONG PortAddress;
  USHORT PortFlag;            /* size, port or mmio */
  BYTE  PortMask[32];         /* bit mask of indices */
}PORTS;                       /* trap register structure */
/*
** Take care when initializing the PMICMD_ regdata. Union fields can be
** initialized only following the format of its first definition (in this
** case _PORTIO. This means that PMICMD_READx and PMICMD_WRITEx which are
** using _MMIO format have to be initialized in (lowerword source, upperword
** source, lowerword destination, upperword destination) pairs rather than
** (doubleword source, doubleword destination).                 
*/
typedef struct _REGDATA                 /*            */
{
  USHORT        Command;
  union _FIELDS
  {
    struct _BPORTIO
    {
     USHORT    IndexPort;
     USHORT    DataPort;
     USHORT    NumEntries;
     USHORT    StartIndex;
     USHORT    Flags;                     /*            */
    }PortIO;               /* used by PORT IO PMICMDs */
    struct _WPORTIO
    {
     USHORT    Port;
     USHORT    DATAPort;   /* if data port is used, it is assumed that */
     USHORT    Noop2;      /* Value represents the index */
     USHORT    Value;      /* destination for PMICMD_INW, source for PMICMD_OUTW */
     USHORT    WFlags;                 /*            */
    }WPortIO;              /* used by PMICMD_INB/W and PMICMD_OUTW */
    struct _RMW
    {
     USHORT    IndPort;
     USHORT    DPort;
     USHORT    Index;
     USHORT    ANDMask;
     USHORT    ORMask;
    }RMW;                  /* used by PMICMD_RMWx only */
    struct _REGOP
    {
     USHORT    SrcRegIndex;/* for REGISTER_OPERAND operations */
     USHORT    Unused2;
     USHORT    RegSize;    /* number of bytes 1-4 */
     USHORT    DstRegIndex;
     USHORT    Operation;
    }RegOp;                /* used by REG PMICMDs */
    struct _WAIT
    {
     USHORT    IPort;
     USHORT    Mask;
     USHORT    Count;
     USHORT    TimeOut;
     USHORT        WValue;     /* set or clear            */
    }Wait;                 /* used by PMICMD_WAIT/WAITW */
    struct _MMIO
    {
     ULONG     Destination;
     ULONG     Source;
     USHORT    MemFlags;                /*            */
    }MMIO;                 /* used by memory bound PMICMDs */
    struct _CALL                                                /*          */
    {
     USHORT    Function;   /* function type : if CALL_NON_STANDARD function */
     ULONG     Unused6;    /* function name specified in Data pointer in RegData */
     ULONG     Unused7;
    }CALL;
    struct _WHILE
    {
     USHORT    Unused4;
     USHORT    EndValue;
     USHORT    Unused5;
     USHORT    LoopIndex;
     USHORT    LoopFlags;                /*            */
    }WHILE;               /* used by loop PMICMDs */
  }R;
  PBYTE     Data;
} REGDATA, *PREGDATA;

typedef struct _CHIPHEADER
{
  USHORT        usVESAModeNumber;
  USHORT        usBytesPerScanLine;
  USHORT        usXResolution;
  USHORT        usYResolution;
  USHORT        usXCharSize;
  USHORT        usYCharSize;
  USHORT        usTextRows;
  ULONG         ulPageLength;
  ULONG         ulSaveSize;
//ULONG         ulMemoryIOAddress;                /*          *//*          */
  ULONG         ulBufferAddress;
  ULONG         ulApertureSize;
  BYTE          bModeAttributes;
  BYTE          bBitsPerPixel;
  BYTE          bNumberOfPlanes;
} CHIPHEADER, *PCHIPHEADER;

typedef struct _BANKROUTINE                                     /*          */
{
   CHAR        szBankRoutineName[28];
   PREGDATA    pBankRoutine;
} BANKROUTINE, *PBANKROUTINE;

typedef struct _SSVGADACINFO                                    /*          */
{
  PCHAR        pszDacName;
  PCHAR        pszDacManufacturer;                              /*          */
  USHORT       usDacParamCount;
  PREGDATA     pRegDataDacIPFClear;                             /*          */
  PREGDATA     pRegDataDacIPFSet;                               /*          */
  PREGDATA     pRegDataDacProgram;
} SSVGADACINFO, *PSSVGADACINFO;

typedef struct _CHIPINFO
{
  USHORT        Int10Mode;
  PCHIPHEADER   pChipHdr;
  PBANKROUTINE  pSetBank;              //this should not be here/*          */
  PBANKROUTINE  pGetBank;              //leaving it to minimize regression
  PREGDATA      pRegData;
  USHORT        Refresh;               /* JWK10 */
} CHIPINFO, *PCHIPINFO;

typedef struct  _VARIABLES              /*            */
{
  CHAR          RegisterName[MAX_REGISTER_NAME];
  ULONG         RegisterOffset;
} VARIABLE_DEC, *PVARIABLE_DEC;

//typedef struct _MMIOINFO                /*            */      /*          */
//{
//  ULONG         ulMMIOBase;            /* Base address */
//  PVARIABLE_DEC pDecSection;           /* Pointer to the declaration section */
//}MMIO_INFO;

typedef struct _OURADAPTERINFO          //match to ADAPTERINFO in svgadefs.h
{                                                               /*          */
  CHAR        szOEMString[MAX_OEM_STRING];    /* adapter info from Hardware section */
  CHAR        szDACString[MAX_DAC_STRING];    /* DAC info from Hardware section */
  CHAR        szRevision[MAX_VERSION];        /*                           */
  ULONG       ulTotalMemory;
  ULONG       ulMMIOBaseAddress;
  ULONG       ulPIOBaseAddress;
  USHORT      usLinearAperture;         /*            should be setup as an index into declarations */
  BYTE        usBusType;
  BYTE        usEndian;
  USHORT      usSizeDeclarations;
  CHAR        DLLName[20];
  CHAR        MonitorName[MAX_MONITOR_LEN];
  USHORT      FormatSectionFlag;
  PVARIABLE_DEC pDecSection;    /* Pointer to the declaration section */
  REFRESHMODE *RefreshTable;    /* table of upto MAX_REFRESH_MODE entries */
  REFRESHTABLE *RefreshDynamic; /* table of upto MAX_REFRESHTABLE_ENTRIES entries @V3.0YEE03*/
}OURADAPTERINFO;

typedef struct _P9000DATA                                       /*          */
{
  ULONG SysConfig;
  ULONG Clip;
}P9000_DATA;

typedef enum _CHIPHDRLIST
{
  GRAPHICS_640x480x16,
  GRAPHICS_640x480x256,
  GRAPHICS_640x480x32K,
  GRAPHICS_640x480x64K,
  GRAPHICS_640x480x16M,
  CIRRUS_640x480x16M,
  GRAPHICS_640x480x32bpp,                                       /*          */
  GRAPHICS_800x600x16,
  GRAPHICS_800x600x256,
  GRAPHICS_800x600x32K,
  GRAPHICS_800x600x64K,
  GRAPHICS_800x600x64K_2KSL,                                    /*          */
  GRAPHICS_800x600x16M,
  CIRRUS_800x600x16M,
  GRAPHICS_800x600x32bpp,                                       /*          */
  GRAPHICS_1024x768x16,
  GRAPHICS_768x1024x16,
  GRAPHICS_1024x768x256,
  GRAPHICS_1024x768x32K,
  GRAPHICS_1024x768x64K,
  GRAPHICS_1024x768x16M,
  GRAPHICS_1024x768x32bpp,                                      /*          */
  GRAPHICS_1152x864x256,
  GRAPHICS_1280x1024x16,
  GRAPHICS_1280x1024x256,
  GRAPHICS_1280x1024x64K,
  GRAPHICS_1280x1024x64K_4KSL,                                  /*          */
  GRAPHICS_1280x1024x16M,                                       /*          */
  GRAPHICS_1600x1200x256,
  TEXT_40x25,
  TEXT_80x25,
  TEXT_132x25,
  TEXT_132x43,
  TEXT_132x44,
} CHIPHDRLIST;

typedef VOID FNSVGAEDITTABLES( VOID );                          /*          */
typedef USHORT USFNSVGAADJUSTEDPORT( USHORT );                  /*          */
typedef INT IFNSVGADACGETTYPE( VOID );                          /*          */

typedef FNSVGAEDITTABLES *PFNSVGAEDITTABLES;                    /*          */
typedef USFNSVGAADJUSTEDPORT *PUSFNSVGAADJUSTEDPORT;            /*          */
typedef IFNSVGADACGETTYPE *PIFNSVGADACGETTYPE;                  /*          */

typedef struct _sAdapterInfo                                    /*          */
{                                                               /*          */
  PFNSVGAEDITTABLES pfnSVGAEditTables;                          /*          */
  PUSFNSVGAADJUSTEDPORT pusfnSVGAAdjustedPort;                  /*          */
  PREGDATA pRegDataSVGADacRS2Clear;                             /*          */
  PREGDATA pRegDataSVGADacRS2Set;                               /*          */
  PREGDATA pRegDataSVGADacRS3Clear;                             /*          */
  PREGDATA pRegDataSVGADacRS3Set;                               /*          */
  PIFNSVGADACGETTYPE pifnSVGADacGetType;                        /*          */
} SADAPTERINFO;                                                 /*          */
typedef SADAPTERINFO *PSADAPTERINFO;                            /*          */


/*
** Externals (in CHIPDATA)
*/

extern BYTE MiscOutRegData;
extern BYTE MiscOutRegMask;
extern BYTE CRTRegData[256];
extern BYTE ATCRegData[256];
extern BYTE GDCRegData[256];
extern BYTE SEQRegData[256];
extern BYTE ATIRegData[256];
extern BYTE MiscRegData[256];
extern BYTE MMIOData[256];
extern BYTE IMARegData[256];
extern BYTE CRTCBRegData[256];

extern BYTE bEndSEQReset[8];
extern BYTE b_0[4];
extern BYTE b_1[4];
extern BYTE b_2[4];
extern BYTE b_3[4];
extern BYTE b_4[4];
extern BYTE b_5[4];
extern BYTE b_6[4];
extern BYTE b_7[4];
extern BYTE b_8[4];
extern BYTE b_9[4];
extern BYTE b_A[4];
extern BYTE b_B[4];
extern BYTE b_C[4];
extern BYTE b_D[4];
extern BYTE b_E[4];
extern BYTE b_F[4];

extern CHIPHEADER ChipInfoHeader[];

extern REGDATA  aRegDataATIMach64Lock [];                       /*          */
extern REGDATA  aRegDataATIMach64Unlock [];                     /*          */
extern REGDATA  HeadlandLockData[];
extern REGDATA  HeadlandUnLockData[];
extern REGDATA  ParadiseLockData1[];
extern REGDATA  ParadiseUnLockData1[];
extern REGDATA  ParadiseLockData2[];
extern REGDATA  ParadiseUnLockData2[];
extern REGDATA  ParadiseLockData3[];
extern REGDATA  ParadiseUnLockData3[];
extern REGDATA  ParadiseLockData4[];
extern REGDATA  ParadiseUnLockData4[];
extern REGDATA  CirrusLockData[];
extern REGDATA  CirrusUnLockData[];
extern REGDATA  S3LockData[];
extern REGDATA  S3UnLockData[];
extern REGDATA  Weitek5x86LockData[];
extern REGDATA  Weitek5x86UnLockData[];

extern REGDATA  ATICleanup[];                                   /*          */
extern REGDATA  ATIMach32Cleanup[];                             /*          */
extern REGDATA  ATIMach64Cleanup[];                             /*          */
extern REGDATA  CirrusCleanData[];
extern REGDATA  IBMCleanData[];
extern REGDATA  S3CleanData[];
extern REGDATA  Video7CleanData[];
extern REGDATA  WDCleanData1[];
extern REGDATA  WDCleanData2[];
extern REGDATA  WDCleanData3[];

extern REGDATA aRegDataNone [];                                 /*          */
extern REGDATA aRegDataDacHiColorIPFClear [];                   /*          */
extern REGDATA aRegDataDacHiColorIPFSet [];                     /*          */
extern REGDATA aRegDataDacMusicBugIPFSet [];                    /*          */

extern REGDATA aRegDataATIDacRS2Clear [];                       /*          */
extern REGDATA aRegDataATIDacRS2Set [];                         /*          */
extern REGDATA aRegDataATIDacRS3Clear [];                       /*          */
extern REGDATA aRegDataATIDacRS3Set [];                         /*          */
extern REGDATA aRegDataS3DacRS2Clear [];                        /*          */
extern REGDATA aRegDataS3DacRS2Set [];                          /*          */
extern REGDATA aRegDataS3DacRS3Clear [];                        /*          */
extern REGDATA aRegDataS3DacRS3Set [];                          /*          */
extern REGDATA aRegDataS3DacRS4Clear [];                        /*@V3.0YEE04*/
extern REGDATA aRegDataS3DacRS4Set [];                          /*@V3.0YEE04*/
extern REGDATA aRegDataS3DacSetCR55 [];                         /*@V3.0YEE04*/
extern REGDATA aRegDataS3DacResetCR55 [];                       /*@V3.0YEE04*/

extern REGDATA aRegDataDacDefault [];                           /*          */
extern REGDATA aRegDataDacHiColor [];                           /*          */
extern REGDATA aRegDataDacBT485 [];                             /*          */
extern REGDATA aRegDataDacViper [];                             /*          */
extern REGDATA aRegDataDacSierra [];                            /*          */
extern REGDATA aRegDataDacSGSThomson [];                        /*          */
extern REGDATA aRegDataDacSGSThomson1703 [];                    /*@V3.0YEE07*/
extern REGDATA aRegDataDacTLC34075 [];                          /*          */
extern REGDATA aRegDataDacMusicBug [];                          /*          */

extern CHAR szATT [];                                           /*          */
extern CHAR szBrooktree [];                                     /*          */
extern CHAR szChrontel [];                                      /*          */
extern CHAR szMusic [];                                         /*          */
extern CHAR szWinbond [];                                       /*          */
extern CHAR szTI [];                                            /*@V3.0YEE04*/

extern SSVGADACINFO asSVGADacInfo [MAX_DAC];                    /*          */

/*             */

extern REGDATA  IBMSetBankCmd[];
extern REGDATA  IBMGetBankCmd[];

extern PCHIPINFO VGAChipSet;
extern PREGDATA  VGASetBank;
extern PREGDATA  VGALock;
extern PREGDATA  VGAUnLock;
extern PREGDATA  VGACleanup;
extern REGDATA   VGARegData[];

extern CHIPINFO HeadlandChipSet1[];
extern CHIPINFO HeadlandChipSet2[];
extern CHIPINFO HeadlandChipSet3[];
extern CHIPINFO TridentChipSet1[];
extern CHIPINFO TridentChipSet2[];
extern CHIPINFO ATIChipSet1[];
extern CHIPINFO ATIChipSet2[];
extern CHIPINFO ATIChipSet3[];
extern CHIPINFO ATIChipSet4[];                                  /*          */
extern CHIPINFO IBMChipSet1[];
extern CHIPINFO CirrusChipSet1[];
extern CHIPINFO CirrusChipSet2[];
extern CHIPINFO ParadiseChipSet1[];
extern CHIPINFO ParadiseChipSet2[];
extern CHIPINFO ParadiseChipSet3[];
extern CHIPINFO ParadiseChipSet4[];
extern CHIPINFO ParadiseChipSet5[];
extern CHIPINFO ParadiseChipSet6[];
extern CHIPINFO S3ChipSet1[];
extern CHIPINFO S3ChipSet2[];
extern CHIPINFO WeitekChipSet1[];

extern USHORT   usSizeHeadlandChipSet1;
extern USHORT   usSizeHeadlandChipSet2;
extern USHORT   usSizeHeadlandChipSet3;
extern USHORT   usSizeTridentChipSet1;
extern USHORT   usSizeTridentChipSet2;
extern USHORT   usSizeATIChipSet1;
extern USHORT   usSizeATIChipSet2;
extern USHORT   usSizeATIChipSet3;
extern USHORT   usSizeATIChipSet4;                              /*          */
extern USHORT   usSizeIBMChipSet1;
extern USHORT   usSizeCirrusChipSet1;
extern USHORT   usSizeCirrusChipSet2;
extern USHORT   usSizeParadiseChipSet1;
extern USHORT   usSizeParadiseChipSet2;
extern USHORT   usSizeParadiseChipSet3;
extern USHORT   usSizeParadiseChipSet4;
extern USHORT   usSizeParadiseChipSet5;
extern USHORT   usSizeParadiseChipSet6;
extern USHORT   usSizeS3ChipSet1;
extern USHORT   usSizeS3ChipSet2;
extern USHORT   usSizeWeitekChipSet1;

extern USHORT   usSizeChipInfoHeader;
extern USHORT   usNumModes;
extern REGDATA ICDesign1[][MAX_CLOCK_REGDATA];
extern USHORT   far *pusSupportedModes;

//extern INT      ProcessVIPERConf(FILE *,MMIO_INFO *);         /*          */
//extern FILE *   OpenVIPERFile(VOID);                          /*          */
//extern VOID     ProcessSupportedVIPERModes(PCHIPINFO, FILE *, MMIO_INFO *);

extern CHAR     GetBootDrive(VOID);
extern VARIABLE_DEC WeitekDeclarations[];
extern USHORT   usSizeWeitekDeclaration;
extern P9000_DATA Viper;                                        /*          */

//extern ULONG WSpeed;                                          /*          */
//extern ULONG Vclk[MAX_MODES];                                 /*          */
//extern BYTE SEQ12_ORMask[MAX_MODES];                          /*          */

extern REFRESHMODE Default_Refresh_Table[MAX_REFRESH_MODES];
extern REFRESHMODE Entry_Refresh_Table[MAX_REFRESH_MODES];      /* JWK26 */
extern REFRESHMODE Diamond_Viper_Refresh_Table[MAX_REFRESH_MODES];
extern REFRESHMODE Diamond_24_Refresh_Table[MAX_REFRESH_MODES];
extern REFRESHMODE S3_928GenRefresh_Table[MAX_REFRESH_MODES];   /*            */
extern REFRESHMODE S3_805GenRefresh_Table[MAX_REFRESH_MODES];   /*            */
extern REFRESHMODE S3_N9_Refresh_Table[MAX_REFRESH_MODES];
extern REFRESHMODE ATIMach32_GenRefresh_Table[MAX_REFRESH_MODES];
extern REFRESHMODE STB_Refresh_Table[MAX_REFRESH_MODES];
extern REFRESHMODE Tseng_Refresh_TableET4000[MAX_REFRESH_MODES];            /*JWK10*/
extern REFRESHMODE Tseng_Refresh_TableW32[MAX_REFRESH_MODES];            /*JWK10*/
extern REFRESHMODE Tseng_Refresh_TableW32x[MAX_REFRESH_MODES];            /*JWK10*/
extern REFRESHMODE S3_ICD2061_Refresh_Table[MAX_REFRESH_MODES];  /*          */
extern REFRESHMODE S3_N9x64_Refresh_Table[MAX_REFRESH_MODES];    /*@V3.0YEE03*/
extern REFRESHMODE S3_SDAC_Refresh_Table[MAX_REFRESH_MODES];     /*          */
extern REFRESHMODE Cirrus543x_Refresh_Table[MAX_REFRESH_MODES];  /*          */
extern REFRESHMODE S3_Lacuna_Refresh_Table[MAX_REFRESH_MODES];   /*          */
extern REFRESHMODE S3_964DIAMOND_Refresh_Table[MAX_REFRESH_MODES]; /*          */
extern REFRESHMODE S3_964ORCHID_Refresh_Table[MAX_REFRESH_MODES];/*          */

extern REFRESHTABLE S3SDACRefresh[MAX_REFRESHTABLE_ENTRIES];     /*@V3.0YEE02*/
extern REFRESHTABLE S3N9x64Refresh[MAX_REFRESHTABLE_ENTRIES];    /*@V3.0YEE03*/
extern REFRESHTABLE S3ICD2061Refresh[MAX_REFRESHTABLE_ENTRIES];  /*@V3.0YEE03*/
extern REFRESHTABLE S3964DIAMONDRefresh[MAX_REFRESHTABLE_ENTRIES];/*@V3.0YEE04*/
extern REFRESHTABLE S3964ORCHIDRefresh[MAX_REFRESHTABLE_ENTRIES];/*@V3.0YEE05*/
extern REFRESHTABLE S3DELLRefresh[MAX_REFRESHTABLE_ENTRIES];     /*@V3.0YEE09*/

#define Mach5    1                                               /*          */
#define DELL     2                                               /*@V3.0YEE09*/

typedef struct  _S3_MODETABLE                                    /*          */
{                                                                /*          */
        USHORT   VesaMode;                                       /*          */
        BYTE     NativeMode;                                     /*          */
} S3_MODETABLE;                                                  /*          */

extern S3_MODETABLE S3ModeTable[];                               /*          */
extern USHORT NUM_S3ENTRIES;                                     /*          */

/*
** From SVGATSNG.C:
*/
#define TSENG_MONITOR_UNKNOWN  0
#define TSENG_MONITOR_60HZ     1  /* offset into GenericTsengMonitorTable[] */    /*JWK10*/
#define TSENG_MONITOR_72HZ     2
#define TSENG_MONITOR_35K      3
#define TSENG_MONITOR_38K      4
#define TSENG_MONITOR_48K      5
#define TSENG_MONITOR_45MI     6
#define TSENG_MONITOR_65M      7
#define TSENG_MONITOR_70M      8
#define TSENG_MONITOR_72M      9
#define TSENG_MONITOR_45HI     10
#define TSENG_MONITOR_60H      11
#define TSENG_MONITOR_70H      12
#define TSENG_MONITOR_75H      13
#define TSENG_MONITOR_90H      14
#define TSENG_MONITOR_CUSTOM   15
#define TSENG_MONITOR_AUTO     16
#define TSENG_MONITOR_DEFAULT  17

typedef struct _TSENGRESPONSEDATA {
        CHAR *      response;
        BYTE        ORMask88[4];
        BYTE        ORMask89[4];
        BYTE        ORMaskCRTC[4];                 /*JWK05*/
        BYTE        ANDMask88[4];
        BYTE        ANDMask89[4];
        BYTE        ANDMaskCRTC[4];                /*JWK05*/
        BYTE        TsengFrequency[4];             /*JWK10*/
        BYTE        frequency[4];
} TSENGRESPONSEDATA;


#define  TSENG_SETBANK          0x3cd
#define  TSENG_SETBANK_W32      0x3cb
#define  TSENG_BASE_INDEX       0x210A         /* for W32 crtcb and mmu */
#define  TSENG_BASE_DATA        0x210B         /* for W32 crtcb and mmu */
#define  TSENG_INDEX_CRTCB_COLOR_DEPTH 0xEE    /* for W32 crtcb and mmu */


/*
 *    for TSENGW32 DIAMOND and CONFIGURATOR  JWK10 JWK08
 *
 */

typedef struct _TSENG_MONITORS        /*JWK10*/
{
  CHAR name[10];
  BYTE VRefr[4]; //index 0 640x480, 1 800x600, 2 1024x768, 3 1280x1024
}TSENG_MONITORS, *PTSENG_MONITORS;

extern TSENG_MONITORS  DiaMonTableW32[];                      /* JWK10 */


#define  DIA_MISCOUT  0x3c2         //localbus ic designs bits         /* JWK08*//* JWK08*/
#define  DIA_MISCIN   0x3cc         //VGA                              /* JWK08*/
#define  DIA_MISCD    0x8           //ic designs data bit              /* JWK08*/
#define  DIA_MISCC    0x4           //clock bit                        /* JWK08*/
                                                                       /* JWK08*/
#define DIA_NUM_MONITORS    16                                         /* JWK08*/
#define DIA_NUM_MODES       55                                         /* JWK08*/
                                                                       /* JWK08*/
typedef struct  _DIA_MODESTRUCT                                        /* JWK08*/
{                                                                      /* JWK08*/
        USHORT     nHorzRes;                                           /* JWK08*/
        USHORT     nVertRes;                                           /* JWK08*/
        USHORT     nRef;                                               /* JWK08*/
        USHORT     nBPP;                                               /* JWK08*/
        USHORT     nClock;                                             /* JWK08*/
} DIA_MODESTRUCT;                                                      /* JWK08*/
                                                                       /* JWK08*/
extern REFRESHMODE Diamond_W32_Refresh_Table[];                        /*JWK10*/
extern DIA_MODESTRUCT      DIA_ModeStruct[DIA_NUM_MODES];              /* JWK08*/
USHORT IsDiamondW32(void);                                             /*JWK08*/
USHORT DIA_WriteClockStream(FILE *file, int nHorz, int nVert, int nBPP); /*JWK08*/
VOID   DIA_WriteIC(FILE *file,ULONG data);                               /*JWK08*/

USHORT ThinkpadMaxLCDRes(VOID);                                 /*@V3.0YEE08*/
VOID   ThinkpadModeFixup(PCHIPHEADER pChipHdr);                 /*@V3.0YEE08*/
VOID   IsThinkpad(VOID);                                        /*@V3.0YEE08*/
VOID   ThinkpadCleanup(VOID);                                   /*@V3.0YEE08*/
VOID   OutpDelay(USHORT usPort, BYTE bData);                    /*@V3.0YEE08*/
BYTE   InpDelay(USHORT usPort);                                 /*@V3.0YEE08*/

/* Defined in SVGA.C: */                                        /*          */
INT SVGADacGetType( VOID );                                     /*          */
USHORT InpwDelay( USHORT usPort );                              /*          */

extern PSADAPTERINFO psCurAdapterInfo;                          /*          */
extern OEMSVGAINFO sSVGA;

extern BOOL    fTsengInt3;
extern VARIABLE_DEC TSENGDeclarations[];
extern USHORT usSizeTSENGDeclaration;
extern USHORT  TSENGInstance;
extern USHORT  TSENGBaseIOData;
extern USHORT  TSENGBaseIOIndex;
extern ULONG   TSENGVGABase;
extern ULONG   TSENGVGARange;
extern ULONG   TSENGMMUApertureSize;
extern ULONG   TSENGMMUBase;
extern ULONG   TSENGMMURange;
extern ULONG   TSENGMMRBase;
extern ULONG   TSENGMMRRange;
extern ULONG   TSENGEMRBase;
extern ULONG   TSENGEMRRange;
extern USHORT  TSENGBIOSMonitorSupport;
extern USHORT  TSENGDiamondW32;                          /*JWK10*/
extern PTSENG_MONITORS pMonitorTable;                    /*JWK10*/
extern USHORT usSizeMonitorTable;                        /*JWK10*/
extern TSENG_MONITORS TsengMonitorTableET4000[];         /*JWK10*/
extern USHORT usSizeTsengMonitorTableET4000;             /*JWK10*/
extern TSENG_MONITORS TsengMonitorTableW32[];            /*JWK10*/
extern USHORT usSizeTsengMonitorTableW32;                /*JWK10*/
extern TSENG_MONITORS TsengMonitorTableW32x[];           /*JWK10*/
extern USHORT usSizeTsengMonitorTableW32x;               /*JWK10*/
extern TSENG_MONITORS DiaMonTableW32[];                  /*JWK10*/
extern USHORT usSizeDiaMonTableW32;                      /*JWK10*/
extern CHAR   * TsengMessage[];
extern USHORT usSizeTsengMessage;
extern CHAR   * TsengMessageDiamondW32[];                /*JWK10*/
extern USHORT usSizeTsengMessageDiamondW32;              /*JWK10*/
extern CHAR   * TsengMonitorChoices[];
extern CHAR   * TsengRefreshChoices[];
extern USHORT TSENGMonitorRefresh[5];
extern USHORT TSENGMaxMonitorRefresh[5];                 /*JWK22*/
extern USHORT TSENGRefreshFlags[5][5][10];               /*JWK26 [resolution][colordepth][refreshrate]*/
extern TSENGRESPONSEDATA TSENGresponsedata[];
extern USHORT usSizeTSENGresponsedata;
extern CHAR MonitorBuffer[128];                          /*JWK26*/
extern CHAR *pszMonitorBuffer;                           /*JWK26*/

extern REGDATA  TsengLockData[];
extern REGDATA  TsengUnLockData[];
extern REGDATA  TsengLockDataW32[];                                     /*jwk04*/
extern REGDATA  TsengUnLockDataW32[];                                   /*jwk04*/
extern REGDATA  TsengET4000CleanData[];
extern REGDATA  TsengET4000W32CleanData[];
extern REGDATA  TsengSetBank_ET3000Cmd[];
extern REGDATA  TsengSetBank_ET4000Cmd[];
extern REGDATA  TsengSetBank_ET4000W32xCmd[];
extern REGDATA  TsengGetBank_ET3000Cmd[];
extern REGDATA  TsengGetBank_ET4000Cmd[];
extern REGDATA  TsengGetBank_ET4000W32xCmd[];
extern BANKROUTINE  TsengSetBank_ET3000;
extern BANKROUTINE  TsengSetBank_ET4000;
extern BANKROUTINE  TsengSetBank_ET4000W32x;
extern BANKROUTINE  TsengGetBank_ET3000;
extern BANKROUTINE  TsengGetBank_ET4000;
extern BANKROUTINE  TsengGetBank_ET4000W32x;
extern CHIPINFO TsengChipSetET3000[];                   /*JWK10*/
extern CHIPINFO TsengChipSetET4000[];                   /*JWK10*/
extern CHIPINFO TsengChipSetW32[];                      /*JWK10*/
extern CHIPINFO TsengChipSetW32i[];                     /*JWK10*/
extern CHIPINFO TsengChipSetW32p[];                     /*JWK10*//*JWK05*/
extern USHORT   usSizeTsengChipSetET3000;               /*JWK10*/
extern USHORT   usSizeTsengChipSetET4000;               /*JWK10*/
extern USHORT   usSizeTsengChipSetW32;                  /*JWK10*/
extern USHORT   usSizeTsengChipSetW32i;                 /*JWK10*/
extern USHORT   usSizeTsengChipSetW32p;                 /*JWK10*//*JWK05*/

VOID GetTSENGBaseMMIO(VOID);
VOID GetTSENGBaseIO(VOID);

#define SPECIALCASE "Special Case Mode Assist"                  /*          */

extern OURADAPTERINFO sAdapter;
extern OEMINFO sOEM;
extern DACINFO sDACINFO;
extern PSZ pszAdapter;
extern PSZ pszChipset;

extern BOOL fDebug;                                      /*JWK18*/
extern BOOL fInstall;                                    /*JWK18*/
extern UCHAR DosParm;                                    /*JWK18*/
extern UCHAR SetDefaultMonitor;                          /*JWK26*/
extern UCHAR DisplayMonitorTable;                        /*JWK26*/
extern USHORT TSENGDiamondW32EntryMonitorData;           /*JWK26*/

extern ULONG aulRelockInfo [MAX_LOCKUNLOCKCMD];
extern ULONG aulScratchRegs [0x100];
extern PORTS PortList[MAX_PORTS];
extern USHORT PortCount;
extern VOID LockPushState(        INT Adapter,  INT Chip,  PULONG pulRelockInfo );
extern VOID LockPopState(         INT Adapter,  INT Chip,  PULONG pulRelockInfo );
extern VOID _far GetXGAInstance (VOID);
extern CHAR * manufacturer [MANUFACTURER_MAX+1];
extern PCHIPINFO SetupChipInfo(INT Adapter, INT Chip, BOOL fGeneric);
extern VOID FixInstance(INT Adapter,INT Chip,PCHIPINFO ChipInfo);

extern CHIPNAMES ppszUnknownChipNames [1];                      /*JWK10*/
extern ADAPTERS Adapters [SVGA_LASTADAPTER + 0x01];             /*JWK10*/
extern PCHIPNAMES ChipsetName [SVGA_LASTADAPTER + 0x01];        /*JWK10*/
extern CHIPNAMES ppszVideo7ChipNames [MAX_VIDEO7_CHIP];         /*JWK10*/
extern CHIPNAMES ppszTridentChipNames [MAX_TRIDENT_CHIP];       /*JWK10*/
extern CHIPNAMES ppszTsengChipNames [MAX_TSENG_CHIP];           /*JWK10*/
extern CHIPNAMES ppszWDChipNames [MAX_WESTERNDIG_CHIP];         /*JWK10*/
extern CHIPNAMES ppszATIChipNames [MAX_ATI_CHIP];               /*JWK10*/
extern CHIPNAMES ppszIBMChipNames [MAX_IBM_CHIP];               /*JWK10*/
extern CHIPNAMES ppszS3ChipNames [MAX_S3_CHIP];                 /*JWK10*/
extern CHIPNAMES ppszCirrusChipNames [MAX_CIRRUS_CHIP];         /*JWK10*/
extern CHIPNAMES ppszWeitekChipNames [MAX_WEITEK_CHIP];         /*JWK10*/

extern SADAPTERINFO sVGAAdapterInfo;     /* 00 = UNKNOWN_ADAPTER    */ /*          */
extern SADAPTERINFO sVideo7AdapterInfo;  /* 01 = VIDEO7_ADAPTER     */ /*          */
extern SADAPTERINFO sTridentAdapterInfo; /* 02 = TRIDENT_ADAPTER    */ /*          */
extern SADAPTERINFO sTsengAdapterInfo;   /* 03 = TSENG_ADAPTER      */ /*          */
extern SADAPTERINFO sWDAdapterInfo;      /* 04 = WESTERNDIG_ADAPTER */ /*          */
extern SADAPTERINFO sATIAdapterInfo;     /* 05 = ATI_ADAPTER        */ /*          */
extern SADAPTERINFO sIBMAdapterInfo;     /* 06 = IBM_ADAPTER        */ /*          */
extern SADAPTERINFO sCirrusAdapterInfo;  /* 07 = CIRRUS_ADAPTER     */ /*          */
extern SADAPTERINFO sS3AdapterInfo;      /* 08 = S3_ADAPTER         */ /*          */
extern SADAPTERINFO sWeitekAdapterInfo;  /* 10 = WEITEK_ADAPTER     */ /*          */

/* Defined in SVGA.C: */                                        /*          */
INT SVGADacGetType( VOID );                                     /*          */
USHORT InpwDelay( USHORT usPort );                              /*          */

PSADAPTERINFO psCurAdapterInfo;                                 /*          */

