/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*****************************************************************************
 *
 * SOURCE FILE NAME = CHIPDATA.C
 *
 * DESCRIPTIVE NAME = Chipdata
 *
 *
 * VERSION = V2.2
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * NOTES
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/*
**      Include files
*/

#define PMIDEF_INCL
#include "svga.h"

/*
** Arrays for register snapshot contents.
*/

BYTE MiscOutRegData   = { 0 } ;
BYTE MiscOutRegMask   = { 0 } ;
BYTE CRTRegData[256]  = { 0 } ;
BYTE ATCRegData[256]  = { 0 } ;
BYTE GDCRegData[256]  = { 0 } ;
BYTE SEQRegData[256]  = { 0 } ;
BYTE ATIRegData[256]  = { 0 } ;
BYTE MiscRegData[256] = { 0 } ;
BYTE MMIOData[256]    = { 0 } ; /* has to be big enough to hold all MMIO reg data */
BYTE IMARegData[256]   = { 0 } ;
BYTE CRTCBRegData[256] = { 0 } ;

/*
 * Use these to reduce data size (use in REGDATA structs)
 */

BYTE bEndSEQReset [8] = {0x00, 0x03, 0x00};
/*
** When initializing Data field, reduce number of "\x" definitions by
** specifying the proper data array. For example, specify b_0 instead of
** "\x00". This also accomodates ULONG's for PMICMD_REGOP assignments.
*/
BYTE b_0[4]     = {0x00, 0x00, 0x00, 0x00};
BYTE b_1[4]     = {0x01, 0x00, 0x00, 0x00};
BYTE b_2[4]     = {0x02, 0x00, 0x00, 0x00};
BYTE b_3[4]     = {0x03, 0x00, 0x00, 0x00};
BYTE b_4[4]     = {0x04, 0x00, 0x00, 0x00};
BYTE b_5[4]     = {0x05, 0x00, 0x00, 0x00};
BYTE b_6[4]     = {0x06, 0x00, 0x00, 0x00};
BYTE b_7[4]     = {0x07, 0x00, 0x00, 0x00};
BYTE b_8[4]     = {0x08, 0x00, 0x00, 0x00};
BYTE b_9[4]     = {0x09, 0x00, 0x00, 0x00};
BYTE b_A[4]     = {0x0A, 0x00, 0x00, 0x00};
BYTE b_B[4]     = {0x0B, 0x00, 0x00, 0x00};
BYTE b_C[4]     = {0x0C, 0x00, 0x00, 0x00};
BYTE b_D[4]     = {0x0D, 0x00, 0x00, 0x00};
BYTE b_E[4]     = {0x0E, 0x00, 0x00, 0x00};
BYTE b_F[4]     = {0x0F, 0x00, 0x00, 0x00};

USHORT pnMaxAdapterChip[SVGA_LASTADAPTER] =                     /*          */
{
  MAX_VIDEO7_CHIP,
  MAX_TRIDENT_CHIP,
  MAX_TSENG_CHIP,
  MAX_WESTERNDIG_CHIP,
  MAX_ATI_CHIP,
  MAX_IBM_CHIP,
  MAX_CIRRUS_CHIP,
  MAX_S3_CHIP,
  MAX_CHIPS_CHIP,
  MAX_WEITEK_CHIP
};

P9000_DATA Viper = {0,0};                                       /*          */

VARIABLE_DEC WeitekDeclarations[] =
{
   "sysconfig",0x100004,
   "interrupt_en",0x10000c,
   "x0y0",0x181018,     /* parameter engine */
   "x1y1",0x181028,
   "x2y2",0x181048,
   "x3y3",0x181068,
   "cindex", 0x18018c,
   "w_off.xy",0x1801a0,
   "fground",0x180200,           /* drawing engine */
   "bground",0x180204,
   "pmask",0x180208,
   "draw_mode",0x18020c,
   "pat_originx",0x180210,
   "pat_originy",0x180214,
   "raster",0x180218,
   "pixel8_reg",0x18021c,
   "w_min",0x180220,
   "w_max",0x180224,
   "pattern0",0x180280,
   "pattern2",0x180284,
   "pattern4",0x180288,
   "pattern6",0x18028c,
   "pattern8",0x180290,
   "patternA",0x180294,
   "patternC",0x180298,
   "patternE",0x18029c,
   "hrzt",0x100108,        /* video control registers */
   "hrzsr",0x10010c,
   "hrzbr",0x100110,
   "hrzbf",0x100114,
   "prehrzc",0x100118,
   "vrtt",0x100120,
   "vrtsr",0x100124,
   "vrtbr",0x100128,
   "vrtbf",0x10012c,
   "prevrtc",0x100130,
   "srtctl",0x100138,
   "memconfig",0x100184,   /* VRAM control registers */
   "rfperiod",0x100188,
   "rfcount",0x10018c,
   "rlmax",0x100190,
   "linearwindow",WINDOW_2MB,                                   /*          */
};

USHORT usSizeWeitekDeclaration = sizeof(WeitekDeclarations)/sizeof(VARIABLE_DEC);
/*
**
**              Chipset Mode Header Information
**
*/

CHIPHEADER ChipInfoHeader[] =
{
  {                                     /* 640x480x16           */
    0,                                  /* No VESA mode number  */
    80,                                 /* BytesPerScanLine     */
    640,                                /* XResolution          */
    480,                                /* YResolution          */
    0,                                  /* XCharSize            */
    0,                                  /* YCharSize            */
    30,                                 /* TextRows             */
    38400,                              /* PageLength           */
    153600,                             /* SaveSize             */
    0x000a0000,                         /* BufferAddress        */
    0x00010000,                         /* ApertureSize         */
    0x18,                               /* ModeAttributes       */
    4,                                  /* BitsPerPixel         */
    4,                                  /* NumberOfPlanes       */
  },
  {                                     /* 640x480x256          */
    VESA_640_480_256,                   /* VESA mode number     */
    80,                                 /* BytesPerScanLine     */
    640,                                /* XResolution          */
    480,                                /* YResolution          */
    0,                                  /* XCharSize            */
    0,                                  /* YCharSize            */
    30,                                 /* TextRows             */
    307200,                             /* PageLength           */
    307200,                             /* SaveSize             */
    0x000a0000,                         /* BufferAddress        */
    0x00010000,                         /* ApertureSize         */
    0x18,                               /* ModeAttributes       */
    8,                                  /* BitsPerPixel         */
    1,                                  /* NumberOfPlanes       */
  },
  {                                     /* 640x480x32k          */
    VESA_640_480_32K,                   /* VESA mode number     */
    80,                                 /* BytesPerScanLine     */
    640,                                /* XResolution          */
    480,                                /* YResolution          */
    0,                                  /* XCharSize            */
    0,                                  /* YCharSize            */
    30,                                 /* TextRows             */
    614400,                             /* PageLength           */
    614400,                             /* SaveSize             */
    0x000a0000,                         /* BufferAddress        */
    0x00010000,                         /* ApertureSize         */
    0x18,                               /* ModeAttributes       */
    15,                                 /* BitsPerPixel         */
    1,                                  /* NumberOfPlanes       */
  },
  {                                     /* 640x480x64k          */
    VESA_640_480_64K,                   /* VESA mode number     */
    80,  /*jwk */                       /* BytesPerScanLine     */
    640,                                /* XResolution          */
    480,                                /* YResolution          */
    0,                                  /* XCharSize            */
    0,                                  /* YCharSize            */
    30,                                 /* TextRows             */
    614400,                             /* PageLength 640*2*480 */
    614400,                             /* SaveSize             */
    0x000a0000,                         /* BufferAddress        */
    0x00010000,                         /* ApertureSize         */
    0x18,                               /* ModeAttributes       */
    16,                                 /* BitsPerPixel         */
    1,                                  /* NumberOfPlanes       */
  },
  {                                     /* 640x480x16M          */
    VESA_640_480_16M,                   /* VESA mode number     */
    80,  /*jwk */                       /* BytesPerScanLine     */
    640,                                /* XResolution          */
    480,                                /* YResolution          */
    0,                                  /* XCharSize            */
    0,                                  /* YCharSize            */
    30,                                 /* TextRows             */
    921600,                             /* PageLength 640*3*480 */
    921600,                             /* SaveSize             */
    0x000a0000,                         /* BufferAddress        */
    0x00010000,                         /* ApertureSize         */
    0x18,                               /* ModeAttributes       */
    24,                                 /* BitsPerPixel         */
    1,                                  /* NumberOfPlanes       */
  },
  {                                     /* 640x480x16M  CIRRUS  */
    VESA_640_480_16M,                   /* VESA mode number     */
    2048,                               /* BytesPerScanLine  2K */
    640,                                /* XResolution          */
    480,                                /* YResolution          */
    0,                                  /* XCharSize            */
    0,                                  /* YCharSize            */
    30,                                 /* TextRows             */
    983040,                             /* PageLength  2K*480   */
    983040,                             /* SaveSize             */
    0x000a0000,                         /* BufferAddress        */
    0x00010000,                         /* ApertureSize         */
    0x18,                               /* ModeAttributes       */
    24,                                 /* BitsPerPixel         */
    1,                                  /* NumberOfPlanes       */
  },
  {                                     /* 640x480x32bpp                  */
    VESA_640_480_16M,                   /* VESA mode number     */
    256,                                /* BytesPerScanLine     */
    640,                                /* XResolution          */
    480,                                /* YResolution          */
    0,                                  /* XCharSize            */
    0,                                  /* YCharSize            */
    30,                                 /* TextRows             */
    1228800,                            /* PageLength 640*4*480 */
    1228800,                            /* SaveSize             */
    0x000a0000,                         /* BufferAddress        */
    0x00010000,                         /* ApertureSize         */
    0x18,                               /* ModeAttributes       */
    32,                                 /* BitsPerPixel         */
    1,                                  /* NumberOfPlanes       */
  },
  {                                     /* 800x600x16           */
    VESA_800_600_16,                    /* VESA mode number     */
    100,                                /* BytesPerScanLine     */
    800,                                /* XResolution          */
    600,                                /* YResolution          */
    0,                                  /* XCharSize            */
    0,                                  /* YCharSize            */
    37,                                 /* TextRows             */
    60000,                              /* PageLength           */
    240000,                             /* SaveSize             */
    0x000a0000,                         /* BufferAddress        */
    0x00010000,                         /* ApertureSize         */
    0x18,                               /* ModeAttributes       */
    4,                                  /* BitsPerPixel         */
    4,                                  /* NumberOfPlanes       */
  },
  {                                     /* 800x600x256          */
    VESA_800_600_256,                   /* VESA mode number     */
    100,                                /* BytesPerScanLine     */
    800,                                /* XResolution          */
    600,                                /* YResolution          */
    0,                                  /* XCharSize            */
    0,                                  /* YCharSize            */
    37,                                 /* TextRows             */
    480000,                             /* PageLength           */
    480000,                             /* SaveSize             */
    0x000a0000,                         /* BufferAddress        */
    0x00010000,                         /* ApertureSize         */
    0x18,                               /* ModeAttributes       */
    8,                                  /* BitsPerPixel         */
    1,                                  /* NumberOfPlanes       */
  },
  {                                     /* 800x600x32k          */
    VESA_800_600_32K,                   /* VESA mode number     */
    100,                                /* BytesPerScanLine     */
    800,                                /* XResolution          */
    600,                                /* YResolution          */
    0,                                  /* XCharSize            */
    0,                                  /* YCharSize            */
    37,                                 /* TextRows             */
    960000,                             /* PageLength 800*2*600 */
    960000,                             /* SaveSize             */
    0x000a0000,                         /* BufferAddress        */
    0x00010000,                         /* ApertureSize         */
    0x18,                               /* ModeAttributes       */
    15,                                 /* BitsPerPixel         */
    1,                                  /* NumberOfPlanes       */
  },
  {                                     /* 800x600x64k          */
    VESA_800_600_64K,                   /* VESA mode number     */
    100,  /* jwk */                     /* BytesPerScanLine     */
    800,                                /* XResolution          */
    600,                                /* YResolution          */
    0,                                  /* XCharSize            */
    0,                                  /* YCharSize            */
    37,                                 /* TextRows             */
    960000,                             /* PageLength 800*2*600 */
    960000,                             /* SaveSize             */
    0x000a0000,                         /* BufferAddress        */
    0x00010000,                         /* ApertureSize         */
    0x18,                               /* ModeAttributes       */
    16,                                 /* BitsPerPixel         */
    1,                                  /* NumberOfPlanes       */
  },
  {                                     /* 800x600x64k_2KSL               */
    VESA_800_600_64K,                   /* VESA mode number     */
    2048,                               /* BytesPerScanLine 2K  */
    800,                                /* XResolution          */
    600,                                /* YResolution          */
    0,                                  /* XCharSize            */
    0,                                  /* YCharSize            */
    37,                                 /* TextRows             */
    2097152,                            /* PageLength needs 2M  */
    2097152,                            /* SaveSize             */
    0x000a0000,                         /* BufferAddress        */
    0x00010000,                         /* ApertureSize         */
    0x18,                               /* ModeAttributes       */
    16,                                 /* BitsPerPixel         */
    1,                                  /* NumberOfPlanes       */
  },
  {                                     /* 800x600x16M          */
    VESA_800_600_16M,                   /* VESA mode number     */
    100,  /* jwk */                     /* BytesPerScanLine     */
    800,                                /* XResolution          */
    600,                                /* YResolution          */
    0,                                  /* XCharSize            */
    0,                                  /* YCharSize            */
    37,                                 /* TextRows             */
    1440000,                            /* PageLength 800*3*600 */
    1440000,                            /* SaveSize             */
    0x000a0000,                         /* BufferAddress        */
    0x00010000,                         /* ApertureSize         */
    0x18,                               /* ModeAttributes       */
    24,                                 /* BitsPerPixel         */
    1,                                  /* NumberOfPlanes       */
  },
  {                                     /* 800x600x16M CIRRUS   */
    VESA_800_600_16M,                   /* VESA mode number     */
    4096,                               /* BytesPerScanLine 4K  */
    800,                                /* XResolution          */
    600,                                /* YResolution          */
    0,                                  /* XCharSize            */
    0,                                  /* YCharSize            */
    37,                                 /* TextRows             */
    2457600,                            /* PageLength 4K*600    */
    2457600,                            /* SaveSize             */
    0x000a0000,                         /* BufferAddress        */
    0x00010000,                         /* ApertureSize         */
    0x18,                               /* ModeAttributes       */
    24,                                 /* BitsPerPixel         */
    1,                                  /* NumberOfPlanes       */
  },
  {                                     /* 800x600x32bpp                  */
    VESA_800_600_16M,                   /* VESA mode number     */
    4096,                               /* BytesPerScanLine 4K  */
    800,                                /* XResolution          */
    600,                                /* YResolution          */
    0,                                  /* XCharSize            */
    0,                                  /* YCharSize            */
    37,                                 /* TextRows             */
    4194304,                            /* PageLength needs 4M            */
    4194304,                            /* SaveSize             */
    0x000a0000,                         /* BufferAddress        */
    0x00010000,                         /* ApertureSize         */
    0x18,                               /* ModeAttributes       */
    32,                                 /* BitsPerPixel         */
    1,                                  /* NumberOfPlanes       */
  },
  {                                     /* 1024x768x16          */
    VESA_1024_768_16,                   /* VESA mode number     */
    128,                                /* BytesPerScanLine     */
    1024,                               /* XResolution          */
    768,                                /* YResolution          */
    0,                                  /* XCharSize            */
    0,                                  /* YCharSize            */
    48,                                 /* TextRows             */
    98304,                              /* PageLength           */
    393216,                             /* SaveSize             */
    0x000a0000,                         /* BufferAddress        */
    0x00010000,                         /* ApertureSize         */
    0x18,                               /* ModeAttributes       */
    4,                                  /* BitsPerPixel         */
    4,                                  /* NumberOfPlanes       */
  },
  {                                     /* 768x1024x16          */
    0,                                  /* No VESA mode number  */
    96,                                 /* BytesPerScanLine     */
    768,                                /* XResolution          */
    1024,                               /* YResolution          */
    0,                                  /* XCharSize            */
    0,                                  /* YCharSize            */
    64,                                 /* TextRows             */
    98304,                              /* PageLength           */
    393216,                             /* SaveSize             */
    0x000a0000,                         /* BufferAddress        */
    0x00010000,                         /* ApertureSize         */
    0x18,                               /* ModeAttributes       */
    4,                                  /* BitsPerPixel         */
    4,                                  /* NumberOfPlanes       */
  },
  {                                     /* 1024x768x256         */
    VESA_1024_768_256,                  /* VESA mode number     */
    128,                                /* BytesPerScanLine     */
    1024,                               /* XResolution          */
    768,                                /* YResolution          */
    0,                                  /* XCharSize            */
    0,                                  /* YCharSize            */
    48,                                 /* TextRows             */
    786432,                             /* PageLength           */
    786432,                             /* SaveSize             */
    0x000a0000,                         /* BufferAddress        */
    0x00010000,                         /* ApertureSize         */
    0x18,                               /* ModeAttributes       */
    8,                                  /* BitsPerPixel         */
    1,                                  /* NumberOfPlanes       */
  },
  {                                     /* 1024x768x32k         */
    VESA_1024_768_32K,                  /* VESA mode number     */
    128,                                /* BytesPerScanLine     */
    1024,                               /* XResolution          */
    768,                                /* YResolution          */
    0,                                  /* XCharSize            */
    0,                                  /* YCharSize            */
    48,                                 /* TextRows             */
    1572864,                            /* PageLength           */
    1572864,                            /* SaveSize             */
    0x000a0000,                         /* BufferAddress        */
    0x00010000,                         /* ApertureSize         */
    0x18,                               /* ModeAttributes       */
    15,                                 /* BitsPerPixel         */
    1,                                  /* NumberOfPlanes       */
  },
  {                                     /* 1024x768x64k         */
    VESA_1024_768_64K,                  /* VESA mode number     */
    128,  /*jwk*/                       /* BytesPerScanLine     */
    1024,                               /* XResolution          */
    768,                                /* YResolution          */
    0,                                  /* XCharSize            */
    0,                                  /* YCharSize            */
    48,                                 /* TextRows             */
    2097152,                            /* PageLength           */
    2097152,                            /* SaveSize             */
    0x000a0000,                         /* BufferAddress        */
    0x00010000,                         /* ApertureSize         */
    0x18,                               /* ModeAttributes       */
    16,                                 /* BitsPerPixel         */
    1,                                  /* NumberOfPlanes       */
  },
  {                                     /* 1024x768x16m         */
    VESA_1024_768_16M,                  /* VESA mode number     */
    128, /*jwk */                       /* BytesPerScanLine     */
    1024,                               /* XResolution          */
    768,                                /* YResolution          */
    0,                                  /* XCharSize            */
    0,                                  /* YCharSize            */
    48,                                 /* TextRows             */
    2359296,                            /* PageLength 1024*3*768*/
    2359296,                            /* SaveSize             */
    0x000a0000,                         /* BufferAddress        */
    0x00010000,                         /* ApertureSize         */
    0x18,                               /* ModeAttributes       */
    24,                                 /* BitsPerPixel         */
    1,                                  /* NumberOfPlanes       */
  },
  {                                     /* 1024x768x32bpp                 */
    VESA_1024_768_16M,                  /* VESA mode number     */
    4096,                               /* BytesPerScanLine 4K  */
    1024,                               /* XResolution          */
    768,                                /* YResolution          */
    0,                                  /* XCharSize            */
    0,                                  /* YCharSize            */
    48,                                 /* TextRows             */
    4194304,                            /* PageLength needs 4M            */
    4194304,                            /* SaveSize             */
    0x000a0000,                         /* BufferAddress        */
    0x00010000,                         /* ApertureSize         */
    0x18,                               /* ModeAttributes       */
    32,                                 /* BitsPerPixel         */
    1,                                  /* NumberOfPlanes       */
  },
  {                                     /* 1152x864x256         */
    S3_1152_864_256,                    /* S3 mode number       */
    2048,                               /* BytesPerScanLine 2K  */
    1152,                               /* XResolution          */
    864,                                /* YResolution          */
    0,                                  /* XCharSize            */
    0,                                  /* YCharSize            */
    54,                                 /* TextRows             */
    2097152,                            /* PageLength needs 2MB              */
    2097152,                            /* SaveSize             */
    0x000a0000,                         /* BufferAddress        */
    0x00010000,                         /* ApertureSize         */
    0x18,                               /* ModeAttributes       */
    8,                                  /* BitsPerPixel         */
    1,                                  /* NumberOfPlanes       */
  },
  {                                     /* 1280x1024x16         */
    VESA_1280_1024_16,                  /* VESA mode number     */
    160,                                /* BytesPerScanLine     */
    1280,                               /* XResolution          */
    1024,                               /* YResolution          */
    0,                                  /* XCharSize            */
    0,                                  /* YCharSize            */
    64,                                 /* TextRows             */
    163840,                             /* PageLength           */
    655360,                             /* SaveSize             */
    0x000a0000,                         /* BufferAddress        */
    0x00010000,                         /* ApertureSize         */
    0x18,                               /* ModeAttributes       */
    4,                                  /* BitsPerPixel         */
    4,                                  /* NumberOfPlanes       */
  },
  {                                     /* 1280x1024x256        */
    VESA_1280_1024_256,                 /* VESA mode number     */
    2048,                               /* BytesPerScanLine 2K  */
    1280,                               /* XResolution          */
    1024,                               /* YResolution          */
    0,                                  /* XCharSize            */
    0,                                  /* YCharSize            */
    64,                                 /* TextRows             */
    2097152,                            /* PageLength       2M  */
    2097152,                            /* SaveSize             */
    0x000a0000,                         /* BufferAddress        */
    0x00010000,                         /* ApertureSize         */
    0x18,                               /* ModeAttributes       */
    8,                                  /* BitsPerPixel         */
    1,                                  /* NumberOfPlanes       */
  },
  {                                     /* 1280x1024x64K        */
    VESA_1280_1024_64K,                 /* VESA mode number     */
    160, /* jwk */                      /* BytesPerScanLine     */
    1280,                               /* XResolution          */
    1024,                               /* YResolution          */
    0,                                  /* XCharSize            */
    0,                                  /* YCharSize            */
    64,                                 /* TextRows             */
    2621440,                            /* PageLength1280*2*1024*/
    2621440,                            /* SaveSize             */
    0x000a0000,                         /* BufferAddress        */
    0x00010000,                         /* ApertureSize         */
    0x18,                               /* ModeAttributes       */
    16,                                 /* BitsPerPixel         */
    1,                                  /* NumberOfPlanes       */
  },
  {                                     /* 1280x1024x64K_4KSL             */
    VESA_1280_1024_64K,                 /* VESA mode number     */
    4096,                               /* BytesPerScanLine 4K  */
    1280,                               /* XResolution          */
    1024,                               /* YResolution          */
    0,                                  /* XCharSize            */
    0,                                  /* YCharSize            */
    64,                                 /* TextRows             */
    4194304,                            /* PageLength 4K*1024   */
    4194304,                            /* SaveSize             */
    0x000a0000,                         /* BufferAddress        */
    0x00010000,                         /* ApertureSize         */
    0x18,                               /* ModeAttributes       */
    16,                                 /* BitsPerPixel         */
    1,                                  /* NumberOfPlanes       */
  },
  {                                     /* 1280x1024x16M        */ /*          */
    VESA_1280_1024_16M,                 /* VESA mode number     */ /*          */
    160,                                /* BytesPerScanLine     */ /*          */
    1280,                               /* XResolution          */ /*          */
    1024,                               /* YResolution          */ /*          */
    0,                                  /* XCharSize            */ /*          */
    0,                                  /* YCharSize            */ /*          */
    64,                                 /* TextRows             */ /*          */
    3932160,                            /* PageLength1280*3*1024*/ /*          */
    3932160,                            /* SaveSize             */ /*          */
    0x000a0000,                         /* BufferAddress        */ /*          */
    0x00010000,                         /* ApertureSize         */ /*          */
    0x18,                               /* ModeAttributes       */ /*          */
    24,                                 /* BitsPerPixel         */ /*          */
    1,                                  /* NumberOfPlanes       */ /*          */
  },                                                               /*          */
  {                                     /* 1600x1200x256        */
    VESA_1600_1200_256,                 /* VESA mode number 4K  */
    4096,                               /* BytesPerScanLine     */
    1600,                               /* XResolution          */
    1200,                               /* YResolution          */
    0,                                  /* XCharSize            */
    0,                                  /* YCharSize            */
    75,                                 /* TextRows             */
    4194304,                            /* PageLength needs 4MB              */
    4194304,                            /* SaveSize             */
    0x000a0000,                         /* BufferAddress        */
    0x00010000,                         /* ApertureSize         */
    0x18,                               /* ModeAttributes       */
    8,                                  /* BitsPerPixel         */
    1,                                  /* NumberOfPlanes       */
  },
  {                                     /* 40x25 Text           */
    0,                                  /* No VESA mode number  */
    40,                                 /* BytesPerScanLine     */
    360,                                /* XResolution          */
    400,                                /* YResolution          */
    9,                                  /* XCharSize            */
    16,                                 /* YCharSize            */
    25,                                 /* TextRows             */
    4000,                               /* PageLength           */
    4000,                               /* SaveSize             */
    0x000b8000,                         /* BufferAddress        */
    0x00008000,                         /* ApertureSize         */
    0x08,                               /* ModeAttributes       */
    4,                                  /* BitsPerPixel         */
    1,                                  /* NumberOfPlanes       */
  },
  {                                     /* 80x25 Text           */
    0,                                  /* No VESA mode number  */
    80,                                 /* BytesPerScanLine     */
    720,                                /* XResolution          */
    400,                                /* YResolution          */
    9,                                  /* XCharSize            */
    16,                                 /* YCharSize            */
    25,                                 /* TextRows             */
    4000,                               /* PageLength           */
    4000,                               /* SaveSize             */
    0x000b8000,                         /* BufferAddress        */
    0x00008000,                         /* ApertureSize         */
    0x08,                               /* ModeAttributes       */
    4,                                  /* BitsPerPixel         */
    1,                                  /* NumberOfPlanes       */
  },
  {                                     /* 132x25 Text          */
    VESA_TEXT_132_25,                   /* VESA mode number     */
    132,                                /* BytesPerScanLine     */
    1056,                               /* XResolution          */
    400,                                /* YResolution          */
    8,                                  /* XCharSize            */
    16,                                 /* YCharSize            */
    25,                                 /* TextRows             */
    6600,                               /* PageLength           */
    6600,                               /* SaveSize             */
    0x000b8000,                         /* BufferAddress        */
    0x00008000,                         /* ApertureSize         */
    0x08,                               /* ModeAttributes       */
    4,                                  /* BitsPerPixel         */
    1,                                  /* NumberOfPlanes       */
  },
  {                                     /* 132x43 Text          */
    VESA_TEXT_132_43,                   /* VESA mode number     */
    132,                                /* BytesPerScanLine     */
    1056,                               /* XResolution          */
    350,                                /* YResolution          */
    8,                                  /* XCharSize            */
    8,                                  /* YCharSize            */
    43,                                 /* TextRows             */
    11352,                              /* PageLength           */
    11352,                              /* SaveSize             */
    0x000b8000,                         /* BufferAddress        */
    0x00008000,                         /* ApertureSize         */
    0x08,                               /* ModeAttributes       */
    4,                                  /* BitsPerPixel         */
    1,                                  /* NumberOfPlanes       */
  },
  {                                     /* 132x44 Text          */
    0,                                  /* No VESA mode number  */
    132,                                /* BytesPerScanLine     */
    1056,                               /* XResolution          */
    400,                                /* YResolution          */
    8,                                  /* XCharSize            */
    8,                                  /* YCharSize            */
    44,                                 /* TextRows             */
    11616,                              /* PageLength           */
    11616,                              /* SaveSize             */
    0x000b8000,                         /* BufferAddress        */
    0x00008000,                         /* ApertureSize         */
    0x08,                               /* ModeAttributes       */
    4,                                  /* BitsPerPixel         */
    1,                                  /* NumberOfPlanes       */
  },
};

USHORT usSizeChipInfoHeader = sizeof(ChipInfoHeader)/sizeof(CHIPHEADER);

/*
**              Chipset Lock/Unlock Information
**
**    Please note that in order to push and pop locking states,             
**    VVIDEO now requires:                                                  
**    1) During unlocks, you read into "registers" what you wrote.          
**       These values represent a "push" of the current locks.              
**       If the lock does not read the same as you write it,                
**       then you must massage the value read during unlocks                
**    2) During locks, write what the BIOS left locked,                     
**       NOT what really locks the registers.                               
**       SVGA.EXE takes care of this detail for you.                        
**    3) During locks, start by assigning registers "read"                  
**       by unlock code.                                                    
**       These assignments may then be ignored to "pop" locks.              
**    4) During locks, relock registers in the reverse order                
**       from the unlocking.  Some locks depend on others!                  
**
*/

/*
**      Headland/Video7 Lock/Unlock
**      Reads xxxxxxx0:xxxxxxx1
**      Writes ae:ea (other values ignored)
**
**      [Lock]
**      r2   =   0x0000003f;
**      r1   =   0x000000ae;
**      inb(r0, 0x3c4);
**      outb(0x3c4, 0xe3);
**      outb(0x3c5, r2);
**      outb(0x3c4, 0x06);
**      outb(0x3c5, r1);
**      outb(0x3c4, r0);
*/

REGDATA HeadlandLockData[] =
{
  { PMICMD_REGOP, NONE,          NONE, 0x01, 0x02, READWRITE_DATA, "\x3f" }, /*          */
  { PMICMD_REGOP, NONE,          NONE, 0x01, 0x01, READWRITE_DATA, "\xae" }, /*          */
  { PMICMD_INB,   SEQ_INDEXPORT, NONE, NONE, 0x00, NONE,           NULL   },
  { PMICMD_OUTB,  SEQ_INDEXPORT, NONE, NONE, 0x00, WRITEONLY_DATA, "\xe3" }, /*          */
  { PMICMD_OUTB,  SEQ_DATAPORT,  NONE, NONE, 0x02, WRITEREG_DATA,  NULL   }, /*          */
  { PMICMD_OUTB,  SEQ_INDEXPORT, NONE, NONE, 0x00, WRITEONLY_DATA, b_6    },
  { PMICMD_OUTB,  SEQ_DATAPORT,  NONE, NONE, 0x01, WRITEREG_DATA,  NULL   },
  { PMICMD_OUTB,  SEQ_INDEXPORT, NONE, NONE, 0x00, WRITEREG_DATA,  NULL   },
  { PMICMD_NONE },
};

/*
**      Headland/Video7 Lock/Unlock
**      Reads xxxxxxx0:xxxxxxx1
**      Writes ae:ea (other values ignored)
**
**      Since it reads differently from writes,
**      we must do some magic to convert read values into write values.
**      It's magic because shadowed write values must remain intact.
**
**      [UnLock]
**      inb(r0, 0x3c4);
**      outb(0x3c4, 0x06);
**      inb(r1, 0x3c5);
**      r2   =   r1;
**      r1   &=  0x00000001;
**      r1   <<= 0x00000006;
**      r2   &=  0x00000040;
**      r2   |=  r1;
**      r1   =   0x000000ae;
**      r1   ^=  r2;
**      r2   >>= 0x00000004;
**      r1   ^=  r2;
**      outb(0x3c5, 0xea);
**      outb(0x3c4, 0xe3);
**      inb(r2, 0x3c5);
**      outb(0x3c5, 0x00);
**      outb(0x3c4, r0);
*/

REGDATA HeadlandUnLockData[] =
{
  { PMICMD_INB,   SEQ_INDEXPORT, NONE, NONE, 0x00, NONE,           NULL   },
  { PMICMD_OUTB,  SEQ_INDEXPORT, NONE, NONE, 0x00, WRITEONLY_DATA, b_6    },
  { PMICMD_INB,   SEQ_DATAPORT,  NONE, NONE, 0x01, NONE,           NULL   }, /*          */
  { PMICMD_REGOP, 0x01,          NONE, 0x01, 0x02, REGISTER_OPERAND, NULL }, /*          */
  { PMICMD_REGOP, 0x01,          NONE, 0x01, 0x01, REGISTER_OPEQUAL | REGISTER_AND, &b_1 [0] }, /*          */
  { PMICMD_REGOP, 0x01,          NONE, 0x01, 0x01, REGISTER_OPEQUAL | REGISTER_SHL, &b_6 [0] }, /*          */
  { PMICMD_REGOP, 0x02,          NONE, 0x01, 0x02, REGISTER_OPEQUAL | REGISTER_AND, "\x40" }, /*          */
  { PMICMD_REGOP, 0x01,          NONE, 0x01, 0x02, REGISTER_OPEQUAL | REGISTER_OPERAND | REGISTER_OR, NULL }, /*          */
  { PMICMD_REGOP, NONE,          NONE, 0x01, 0x01, WRITEONLY_DATA, "\xae" }, /*          */
  { PMICMD_REGOP, 0x02,          NONE, 0x01, 0x01, REGISTER_OPEQUAL | REGISTER_OPERAND | REGISTER_XOR, NULL }, /*          */
  { PMICMD_REGOP, 0x02,          NONE, 0x01, 0x02, REGISTER_OPEQUAL | REGISTER_SHR, "\x04" }, /*          */
  { PMICMD_REGOP, 0x02,          NONE, 0x01, 0x01, REGISTER_OPEQUAL | REGISTER_OPERAND | REGISTER_XOR, NULL }, /*          */
  { PMICMD_OUTB,  SEQ_DATAPORT,  NONE, NONE, 0x00, WRITEONLY_DATA, "\xea" },
  { PMICMD_OUTB,  SEQ_INDEXPORT, NONE, NONE, 0x00, WRITEONLY_DATA, "\xe3" }, /*          */
  { PMICMD_INB,   SEQ_DATAPORT,  NONE, NONE, 0x02, NONE,           NULL   }, /*          */
  { PMICMD_OUTB,  SEQ_DATAPORT,  NONE, NONE, 0x00, WRITEONLY_DATA, &b_0 [0] }, /*          */
  { PMICMD_OUTB,  SEQ_INDEXPORT, NONE, NONE, 0x00, WRITEREG_DATA,  NULL   },
  { PMICMD_NONE },
};

/*                                                  
** WEITEK P9000 can be implemented with a WEITEK VGA 5x86 chip. This
** chip controls the P9000 environment thru its extended registers.
** It also provides bank access to the VRAM.
**
**  Lock
**  R0 = inb (0x3c4)
**  outb(0x3c4, 0x11)
**  R1 = inb(0x3c5)
**  R1 |= 0x20
**  outb(0x3c5, R1)  lock the video select reg
**  outb(0x3c4, R0)  restore the index
**
*/
REGDATA Weitek5x86LockData[] =
{
  { PMICMD_REGOP, NONE,          NONE, 0x01, 2, READWRITE_DATA, "\x20" }, /*          */
  { PMICMD_INB,   SEQ_INDEXPORT, NONE, NONE, 0, NONE,           NULL   },
  { PMICMD_OUTB,  SEQ_INDEXPORT, NONE, NONE, 0, WRITEONLY_DATA, "\x11" },
  { PMICMD_INB,   SEQ_DATAPORT,  NONE, NONE, 1, NONE,           NULL   },
  { PMICMD_REGOP, 0x01,          NONE, 0x01, 2, REGISTER_OPEQUAL | REGISTER_OPERAND | REGISTER_OR, NULL }, /*          */
  { PMICMD_OUTB,  SEQ_DATAPORT,  NONE, NONE, 1, WRITEREG_DATA,  NULL   },
  { PMICMD_OUTB,  SEQ_INDEXPORT, NONE, NONE, 0, WRITEREG_DATA,  NULL   },
  { PMICMD_NONE },
};

/*
**    Unlock procedure
**  R0 = inb (0x3c4)
**  outb(0x3c4,0x11)
**  R1 = inb(0x3c5)
**  outb(0x3c5, R1)
**  outb(0x3c5, R1)
**  R1 = inb(0x3c5)
**  R1 &= 0xDF
**  outb(0x3c5, R1)  unlock the video select reg
**  outb(0x3c4, R0)  restore the index
**
*/
REGDATA Weitek5x86UnLockData[] =
{
  { PMICMD_INB,   SEQ_INDEXPORT, NONE, NONE, 0, NONE,           NULL   },
  { PMICMD_OUTB,  SEQ_INDEXPORT, NONE, NONE, 0, WRITEONLY_DATA, "\x11" },
  { PMICMD_INB,   SEQ_DATAPORT,  NONE, NONE, 1, NONE,           NULL   },
  { PMICMD_OUTB,  SEQ_DATAPORT,  NONE, NONE, 1, WRITEREG_DATA,  NULL   },
  { PMICMD_OUTB,  SEQ_DATAPORT,  NONE, NONE, 1, WRITEREG_DATA,  NULL   },
  { PMICMD_INB,   SEQ_DATAPORT,  NONE, NONE, 1, NONE,           NULL   },
  { PMICMD_REGOP, 0x01,          NONE, 0x01, 2, REGISTER_OPERAND | REGISTER_AND, "\x20" }, /*          */
  { PMICMD_REGOP, NONE,          NONE, 0x01, 1, REGISTER_OPEQUAL | REGISTER_AND, "\xDF" },
  { PMICMD_OUTB,  SEQ_DATAPORT,  NONE, NONE, 1, WRITEREG_DATA,  NULL   },
  { PMICMD_OUTB,  SEQ_INDEXPORT, NONE, NONE, 0, WRITEREG_DATA,  NULL   },
  { PMICMD_NONE },
};
/*
**
**              Chipset Cleanup Information
**
**    If an adapter has no cleanup information, no space is allocated for
**    it. ADAPTER_CLEANUP_INDEX needs to be defined for all those that
**    do have cleanup section. These indices are used rather than ADAPTER
**    ID's to facilitate different cleanup routines for different chipsets
**    and not to depend on the adapter ID values.
*/
REGDATA Video7CleanData[] =
{                                    /* Video7 Cleanups       */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x00, 0x00, WRITEONLY_DATA, b_1 },
  { PMICMD_RMWBN, MISCOUTPUTREG_READ, MISCOUTPUTREG_WRITE, 0, 0, READWRITE_DATA, &MiscOutRegData },
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0xe0, 0x00, READWRITE_DATA, &SEQRegData[0xe0] },
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0xfd, 0x00, READWRITE_DATA, &SEQRegData[0xfd] },
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0xa4, 0x00, READWRITE_DATA, &SEQRegData[0xa4] },
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0xf6, 0x00, READWRITE_DATA, &SEQRegData[0xf6] },
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0xfc, 0x00, READWRITE_DATA, &SEQRegData[0xfc] },
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0xf8, 0x00, READWRITE_DATA, &SEQRegData[0xf8] },
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0xff, 0x00, READWRITE_DATA, &SEQRegData[0xff] },
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x00, 0x00, WRITEONLY_DATA, b_3 },
  { PMICMD_NONE },
};
REGDATA IBMCleanData[] =
{                                    /* IBM Cleanups       */
  { PMICMD_RMWBN, XGAOPMODE_WRITE,  XGAOPMODE_WRITE,  0x00, 0x01, WRITEONLY_DATA, b_1 },
  { PMICMD_RMWBN, XGABANKSEL_WRITE, XGABANKSEL_WRITE, 0x00, 0x00, WRITEONLY_DATA, b_0 },
  { PMICMD_NONE },
};

/*
**              Clock chip Programming Information
** Assumes that R0 contains the actual 24bit data!
*/
REGDATA ICDesign1[][MAX_CLOCK_REGDATA] =
{
  {                                                             /* Diamond VIPER */
    { PMICMD_INB,   MISCOUTPUTREG_READ , NONE, NONE, 1, NONE, NULL },
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x01, REGISTER_OPEQUAL|REGISTER_AND, "\xF3" },
    { PMICMD_REGOP, 0x01, NONE, 0x01, 0x02, REGISTER_OPERAND|REGISTER_OR, b_8 },
    { PMICMD_REGOP, 0x01, NONE, 0x01, 0x03, REGISTER_OPERAND|REGISTER_OR, b_4 },
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x10, WRITEONLY_DATA, b_0 },
    { PMICMD_WHILE, NONE, 0x5, NONE, 0x10, NONE, NULL },
    { PMICMD_OUTB, MISCOUTPUTREG_WRITE, NONE, NONE, 0x02, WRITEREG_DATA },
    { PMICMD_OUTB, MISCOUTPUTREG_WRITE, NONE, NONE, 0x02, WRITEREG_DATA },
    { PMICMD_OUTB, MISCOUTPUTREG_WRITE, NONE, NONE, 0x03, WRITEREG_DATA },
    { PMICMD_ENDWHILE, NONE, NONE, NONE, NONE, NONE, NULL },
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x10, WRITEONLY_DATA, b_0 },
    { PMICMD_WHILE, NONE, 0x2, NONE, 0x10, NONE, NULL },
    { PMICMD_OUTB, MISCOUTPUTREG_WRITE, NONE, NONE, 0x01, WRITEREG_DATA },
    { PMICMD_OUTB, MISCOUTPUTREG_WRITE, NONE, NONE, 0x03, WRITEREG_DATA },
    { PMICMD_ENDWHILE, NONE, NONE, NONE, NONE, NONE, NULL },
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x10, WRITEONLY_DATA, b_0 },
    { PMICMD_WHILE, NONE, 0x18, NONE, 0x10, NONE, NULL },
    { PMICMD_REGOP, 0x00, NONE, 0x01, 0x04, REGISTER_OPERAND|REGISTER_SHL, b_3 },
    { PMICMD_REGOP, 0x04, NONE, 0x01, 0x05, REGISTER_OPERAND|REGISTER_NEGATE|REGISTER_AND, b_8 },
    { PMICMD_REGOP, 0x05, NONE, 0x01, 0x06, REGISTER_OPERAND|REGISTER_OR, b_4 },
    { PMICMD_REGOP, 0x01, NONE, 0x01, 0x05, REGISTER_OPEQUAL|REGISTER_OPERAND|REGISTER_OR, NONE},
    { PMICMD_REGOP, 0x01, NONE, 0x01, 0x06, REGISTER_OPEQUAL|REGISTER_OPERAND|REGISTER_OR, NONE},
    { PMICMD_OUTB, MISCOUTPUTREG_WRITE, NONE, NONE, 0x06, WRITEREG_DATA },
    { PMICMD_OUTB, MISCOUTPUTREG_WRITE, NONE, NONE, 0x05, WRITEREG_DATA },
    { PMICMD_REGOP, 0x04, NONE, 0x01, 0x05, REGISTER_OPERAND|REGISTER_AND, b_8 },
    { PMICMD_REGOP, 0x05, NONE, 0x01, 0x06, REGISTER_OPERAND|REGISTER_OR, b_4 },
    { PMICMD_REGOP, 0x01, NONE, 0x01, 0x05, REGISTER_OPEQUAL|REGISTER_OPERAND|REGISTER_OR, NONE },
    { PMICMD_REGOP, 0x01, NONE, 0x01, 0x06, REGISTER_OPEQUAL|REGISTER_OPERAND|REGISTER_OR, NONE },
    { PMICMD_OUTB, MISCOUTPUTREG_WRITE, NONE, NONE, 0x05, WRITEREG_DATA },
    { PMICMD_OUTB, MISCOUTPUTREG_WRITE, NONE, NONE, 0x06, WRITEREG_DATA },
    { PMICMD_REGOP, NONE, NONE, 0x04, 0x00, REGISTER_OPEQUAL|REGISTER_SHR, b_1 },
    { PMICMD_ENDWHILE, NONE, NONE, NONE, NONE, NONE, NULL },
    { PMICMD_NONE },
  },
  {                                     /* S3Vision SDAC            start*/
/*
**  Set the external clock now.  Set both since don't know which one in use.
**  r0,r1 sets DCLK
**  r2,r3 sets MCLK
**
**  inb  (r4,0x3c8)
**  in  r4,3d4    * save CRTC register
**  rmwbi (0x3d4,0x3d5,0x55,0xfc,0x01)
**  out 3c8,0x2   * set PLL write index for DCLK
**  out 3c9,r0    * set M and N
**  out 3c9,r1    * set N
**  out 3c8,0xa   * set PLL write index for MCLK
**  out 3c9,r2    * set M and N
**  out 3c9,r3    * set N
**  rmwbi (0x3d4,0x3d5,0x55,0xfc,0x01)
**  out 3d4,r4    * restore CRTC register
**  inb  (r4,0x3c8)
*/
    { PMICMD_INB,   DAC_WRITEPORT, NONE, NONE, 0x04, NONE, NULL } ,
    { PMICMD_INB,   CRT_INDEXPORT, NONE, NONE, 4, NONE, NULL },
    { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x55, 0xFC, WRITEONLY_DATA, b_1 },
    { PMICMD_OUTB,  DAC_WRITEPORT, NONE, NONE, 0x01, WRITEONLY_DATA, "\x02"},
    { PMICMD_OUTB,  DAC_DATAPORT,  NONE, NONE, 0x00, WRITEREG_DATA,  NULL},
    { PMICMD_OUTB,  DAC_DATAPORT,  NONE, NONE, 0x01, WRITEREG_DATA,  NULL},
    { PMICMD_OUTB,  DAC_WRITEPORT, NONE, NONE, 0x01, WRITEONLY_DATA, "\x0a"},
    { PMICMD_OUTB,  DAC_DATAPORT,  NONE, NONE, 0x02, WRITEREG_DATA,  NULL},
    { PMICMD_OUTB,  DAC_DATAPORT,  NONE, NONE, 0x03, WRITEREG_DATA,  NULL},
    { PMICMD_RMWBI, CRT_INDEXPORT, CRT_DATAPORT, 0x55, 0xFC, WRITEONLY_DATA, b_0 },
    { PMICMD_OUTB,  CRT_INDEXPORT, NONE, NONE, 0x04, WRITEREG_DATA,  NULL},
    { PMICMD_INB,   DAC_WRITEPORT, NONE, NONE, 0x04, NONE, NULL } ,
    { PMICMD_NONE },
  },
  { 0 }
};
/*
**              Hi-color DAC Programming Information
*/

REGDATA aRegDataNone [] =
{
  { PMICMD_NONE }
};

REGDATA aRegDataS3DacRS2Clear [] =
{
  { PMICMD_RMWBI, CRT_INDEXPORT,  CRT_DATAPORT, 0x55, 0xfe, WRITEONLY_DATA, b_0 },
  { PMICMD_NONE }
};

REGDATA aRegDataS3DacRS2Set [] =
{
  { PMICMD_RMWBI, CRT_INDEXPORT,  CRT_DATAPORT, 0x55, 0xfe, WRITEONLY_DATA, b_1 },
  { PMICMD_NONE }
};

REGDATA aRegDataS3DacRS3Clear [] =
{
  { PMICMD_RMWBI, CRT_INDEXPORT,  CRT_DATAPORT, 0x55, 0xfd, WRITEONLY_DATA, b_0 },
  { PMICMD_NONE }
};

REGDATA aRegDataS3DacRS3Set [] =
{
  { PMICMD_RMWBI, CRT_INDEXPORT,  CRT_DATAPORT, 0x55, 0xfd, WRITEONLY_DATA, b_2 },
  { PMICMD_NONE }
};

REGDATA aRegDataS3DacRS4Clear [] =                            /* @V3.0YEE04 */
{
  { PMICMD_RMWBI, CRT_INDEXPORT,  CRT_DATAPORT, 0x5C, 0xdf, WRITEONLY_DATA, "\x20 "},
  { PMICMD_NONE }
};

REGDATA aRegDataS3DacRS4Set [] =                              /* @V3.0YEE04 */
{
  { PMICMD_RMWBI, CRT_INDEXPORT,  CRT_DATAPORT, 0x5C, 0xdf, WRITEONLY_DATA, b_0 },
  { PMICMD_NONE }
};

REGDATA aRegDataS3DacSetCR55 [] =                             /* @V3.0YEE04 */
{
  { PMICMD_RMWBI, CRT_INDEXPORT,  CRT_DATAPORT, 0x55, 0xfc, WRITEONLY_DATA, b_1 },
  { PMICMD_NONE }
};

REGDATA aRegDataS3DacResetCR55 [] =                           /* @V3.0YEE04 */
{
  { PMICMD_RMWBI, CRT_INDEXPORT,  CRT_DATAPORT, 0x55, 0xfc, WRITEONLY_DATA, b_0 },
  { PMICMD_NONE }
};

REGDATA aRegDataDacDefault [] =                                 /*          */
{                                       /* Generic 256-COLOR DAC */
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, 0x00, WRITEONLY_DATA, "\xff "},
  { PMICMD_NONE },
};


REGDATA aRegDataDacHiColorIPFClear [] =
{
  { PMICMD_INB,   DAC_READPORT,   NONE, NONE, 0xff,    NONE, NULL } ,
  { PMICMD_INB,   DAC_WRITEPORT,  NONE, NONE, 0xff,    NONE, NULL } ,
  { PMICMD_NONE }
};

REGDATA aRegDataDacHiColorIPFSet [] =
{
  { PMICMD_INB,   DAC_READPORT,   NONE, NONE, 0xff,    NONE, NULL } ,
  { PMICMD_INB,   DAC_WRITEPORT,  NONE, NONE, 0xff,    NONE, NULL } ,
  { PMICMD_INB,   DAC_PIXELMPORT, NONE, NONE, 0xff,    NONE, NULL } ,
  { PMICMD_INB,   DAC_PIXELMPORT, NONE, NONE, 0xff,    NONE, NULL } ,
  { PMICMD_INB,   DAC_PIXELMPORT, NONE, NONE, 0xff,    NONE, NULL } ,
  { PMICMD_INB,   DAC_PIXELMPORT, NONE, NONE, 0xff,    NONE, NULL } ,
  { PMICMD_NONE }
};

REGDATA aRegDataDacHiColor [] =                                 /*          */
{                                       /* Generic Hi-COLOR DAC */
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, 0x00, WRITEREG_DATA | RS2, NULL},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\xff "},
  { PMICMD_NONE },
};
                                                                /*          */
REGDATA aRegDataDacBT485 [] =
{                                       /* Brooktree BT485 DAC */
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, 0x00, WRITEREG_DATA | RS2, NULL},
  { PMICMD_REGOP, 0x00,           NONE, 0x01, 0x04, REGISTER_OPERAND | REGISTER_OR, "\x80" }, /*          */
  { PMICMD_OUTB,  DAC_WRITEPORT,  NONE, NONE, 0x01, WRITEREG_DATA | RS3, NULL},
  { PMICMD_REGOP, 0x02,           NONE, 0x01, 0x02, REGISTER_OPEQUAL | REGISTER_AND, "\xfc" }, /*          */
  { PMICMD_OUTB,  DAC_DATAPORT,   NONE, NONE, 0x02, WRITEREG_DATA | RS3, NULL},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, 0x04, WRITEREG_DATA | RS2 | EXECUTE_CMD, NULL},
  { PMICMD_OUTB,  DAC_WRITEPORT,  NONE, NONE, NONE, WRITEONLY_DATA, "\x01" },
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, 0x03, WRITEREG_DATA | RS3, NULL},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\xff "},
  { PMICMD_NONE },
};
                                                                /*          */
REGDATA aRegDataDacViper [] =
{                                       /* Viper Brooktree BT485 DAC */
  { PMICMD_OUTB,  VIPER_COMREG0, NONE, NONE, 0, WRITEONLY_DATA, "\x80"}, /*          */
  { PMICMD_OUTB,  VIPER_COMREG3, NONE, NONE, 0, WRITEREG_DATA, NULL},
  { PMICMD_OUTB,  VIPER_COMREG2, NONE, NONE, 0, WRITEONLY_DATA, "\x32"},
  { PMICMD_OUTB,  VIPER_COMREG1, NONE, NONE, 1, WRITEREG_DATA, NULL},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\xff"},
  { PMICMD_NONE },
};

/*     Assumes that R0-R3 contains the actual DAC values!
**
**  inb  (r4,0x3c8)           reset index
**  do 4 times
**    inb  (r4,0x3c6)         get to cmd reg
**  enddo;
**  outb (0x3c6,0x10 | r0)    set cmd reg to enable magic index access
**  do 5 times
**    inb  (r4,0x3c6)         get to lindex LO
**  enddo;
**  outb (0x3c6,0x03)         set index LO to 3
**  outb (0x3c6,0x00)         set index HI to 0
**  outb (0x3c6,r1)           set primary pixel mode   (index 3 auto incr)
**  outb (0x3c6,r2)           set secondary pixel mode (index 4 auto incr)
**  outb (0x3c6,r3)           set pipeline timing control register
**  inb  (r4,0x3c8)
**  outb (0x3c6,0xff)                   ** lock DAC access **
*/

REGDATA aRegDataDacSGSThomson [] =                              /*          */
{                                       /* SGS Thomson DAC */
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, 0x00, WRITEREG_DATA | RS2, NULL},
  { PMICMD_REGOP, 0x00,           NONE, 0x01, 0x00, REGISTER_OPERAND | REGISTER_AND, "\xef" },
  { PMICMD_REGOP, 0x00,           NONE, 0x01, 0x04, REGISTER_OPERAND | REGISTER_OR, "\x10" },
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, 0x04, WRITEREG_DATA | RS2 | EXECUTE_CMD, NULL},
  /* Deliberately set via IPF method */                         /*          */
  /* So that next bytes can be addressed implicitly */          /*          */
  { PMICMD_INB,   DAC_READPORT,   NONE, NONE, 0xff, NONE, NULL } , /*          */
  { PMICMD_INB,   DAC_WRITEPORT,  NONE, NONE, 0xff, NONE, NULL } , /*          */
  { PMICMD_INB,   DAC_PIXELMPORT, NONE, NONE, 0xff, NONE, NULL } , /*          */
  { PMICMD_INB,   DAC_PIXELMPORT, NONE, NONE, 0xff, NONE, NULL } , /*          */
  { PMICMD_INB,   DAC_PIXELMPORT, NONE, NONE, 0xff, NONE, NULL } , /*          */
  { PMICMD_INB,   DAC_PIXELMPORT, NONE, NONE, 0xff, NONE, NULL } , /*          */
  { PMICMD_INB,   DAC_PIXELMPORT, NONE, NONE, 0xff, NONE, NULL } , /*          */
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\x03"},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\x00"},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, 0x01, WRITEREG_DATA, NULL},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, 0x02, WRITEREG_DATA, NULL},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, 0x03, WRITEREG_DATA, NULL},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, 0x00, WRITEREG_DATA | RS2 | EXECUTE_CMD, NULL},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\xff "},
  { PMICMD_NONE },
};

/*     Assumes that R0-R5 contains the actual DAC values!
**
**  inb  (r255,0x3c8)           reset index
**  do 4 times
**    inb  (r255,0x3c6)         get to cmd reg
**  enddo;
**  outb (0x3c6,0x10 | r0)    set cmd reg to enable magic index access
**  do 5 times
**    inb  (r255,0x3c6)         get to lindex LO
**  enddo;
**  outb (0x3c6,0x03)         set index LO to 3
**  outb (0x3c6,0x00)         set index HI to 0
**  outb (0x3c6,r1)           set primary pixel mode   (index 3 auto incr)
**  outb (0x3c6,r2)           set secondary pixel mode (index 4 auto incr)
**  outb (0x3c6,r3)           set pipeline timing control register

*** now set vclock
**  inb  (r255,0x3c8)           reset index
**  do 4 times
**    inb  (r255,0x3c6)         get to cmd reg
**  enddo;
**  outb (0x3c6,0x10 | r0)    set cmd reg to enable magic index access
**  do 5 times
**    inb  (r255,0x3c6)         get to lindex LO
**  enddo;
**  outb (0x3c6,0x24)         set index LO to 24h
**  outb (0x3c6,0x00)         set index HI to 0
**  outb (0x3c6,r4)           set primary pixel mode   (index 24h auto incr)
**  outb (0x3c6,r5)           set secondary pixel mode (index 25h auto incr)

**  inb  (r255,0x3c8)
**  outb (0x3c6,0xff)                   ** lock DAC access **
*/

REGDATA aRegDataDacSGSThomson1703 [] =                          /*@V3.0YEE07*/
{                                       /* SGS Thomson DAC */
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, 0x00, WRITEREG_DATA | RS2, NULL},
  { PMICMD_REGOP, 0x00,           NONE, 0x01, 0x00, REGISTER_OPERAND | REGISTER_AND, "\xef" },
  { PMICMD_REGOP, 0x00,           NONE, 0x01, 0x06, REGISTER_OPERAND | REGISTER_OR, "\x10" },
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, 0x06, WRITEREG_DATA | RS2 | EXECUTE_CMD, NULL},
  /* Deliberately set via IPF method */
  /* So that next bytes can be addressed implicitly */
  { PMICMD_INB,   DAC_READPORT,   NONE, NONE, 0xff, NONE, NULL } ,
  { PMICMD_INB,   DAC_WRITEPORT,  NONE, NONE, 0xff, NONE, NULL } ,
  { PMICMD_INB,   DAC_PIXELMPORT, NONE, NONE, 0xff, NONE, NULL } ,
  { PMICMD_INB,   DAC_PIXELMPORT, NONE, NONE, 0xff, NONE, NULL } ,
  { PMICMD_INB,   DAC_PIXELMPORT, NONE, NONE, 0xff, NONE, NULL } ,
  { PMICMD_INB,   DAC_PIXELMPORT, NONE, NONE, 0xff, NONE, NULL } ,
  { PMICMD_INB,   DAC_PIXELMPORT, NONE, NONE, 0xff, NONE, NULL } ,
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\x03"},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\x00"},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, 0x01, WRITEREG_DATA, NULL},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, 0x02, WRITEREG_DATA, NULL},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, 0x03, WRITEREG_DATA, NULL},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, 0x00, WRITEREG_DATA | RS2, NULL},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, 0x06, WRITEREG_DATA | RS2 | EXECUTE_CMD, NULL},
  /* Deliberately set via IPF method */
  /* So that next bytes can be addressed implicitly */
  { PMICMD_INB,   DAC_READPORT,   NONE, NONE, 0xff, NONE, NULL } ,
  { PMICMD_INB,   DAC_WRITEPORT,  NONE, NONE, 0xff, NONE, NULL } ,
  { PMICMD_INB,   DAC_PIXELMPORT, NONE, NONE, 0xff, NONE, NULL } ,
  { PMICMD_INB,   DAC_PIXELMPORT, NONE, NONE, 0xff, NONE, NULL } ,
  { PMICMD_INB,   DAC_PIXELMPORT, NONE, NONE, 0xff, NONE, NULL } ,
  { PMICMD_INB,   DAC_PIXELMPORT, NONE, NONE, 0xff, NONE, NULL } ,
  { PMICMD_INB,   DAC_PIXELMPORT, NONE, NONE, 0xff, NONE, NULL } ,
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\x24"},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\x00"},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, 0x04, WRITEREG_DATA, NULL},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, 0x05, WRITEREG_DATA, NULL},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, 0x00, WRITEREG_DATA | RS2 | EXECUTE_CMD, NULL},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\xff "},
  { PMICMD_NONE },
};

/* Music Requires 5 INB 3C6's instead of 4! */                  /*          */
REGDATA aRegDataDacMusicBugIPFSet [] =
{
  { PMICMD_INB,   DAC_READPORT,   NONE, NONE, 0xff,    NONE, NULL } ,
  { PMICMD_INB,   DAC_WRITEPORT,  NONE, NONE, 0xff,    NONE, NULL } ,
  { PMICMD_INB,   DAC_PIXELMPORT, NONE, NONE, 0xff,    NONE, NULL } ,
  { PMICMD_INB,   DAC_PIXELMPORT, NONE, NONE, 0xff,    NONE, NULL } ,
  { PMICMD_INB,   DAC_PIXELMPORT, NONE, NONE, 0xff,    NONE, NULL } ,
  { PMICMD_INB,   DAC_PIXELMPORT, NONE, NONE, 0xff,    NONE, NULL } ,
  { PMICMD_INB,   DAC_PIXELMPORT, NONE, NONE, 0xff,    NONE, NULL } ,
  { PMICMD_NONE }
};

REGDATA aRegDataDacTLC34075 [] =                                /*          */
{                                       /* TLC34075/ATI68875 DAC */
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, 0x00, WRITEREG_DATA | RS3, NULL},
  { PMICMD_OUTB,  DAC_READPORT,   NONE, NONE, 0x01, WRITEREG_DATA | RS3, NULL},
  { PMICMD_OUTB,  DAC_WRITEPORT,  NONE, NONE, 0x02, WRITEREG_DATA | RS3, NULL},
  { PMICMD_OUTB,  DAC_DATAPORT,   NONE, NONE, 0x03, WRITEREG_DATA | RS3, NULL},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\xff "},
  { PMICMD_NONE },
};

REGDATA aRegDataDacS3SDAC [] =                                  /*          */
{                                       /* S3SDAC */
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, 0x00, WRITEREG_DATA | RS2, NULL},
  { PMICMD_OUTB,  DAC_WRITEPORT,  NONE, NONE, NONE, WRITEONLY_DATA | RS2, "\x02"},
  { PMICMD_OUTB,  DAC_DATAPORT,   NONE, NONE, 0x01, WRITEREG_DATA | RS2, NULL},
  { PMICMD_OUTB,  DAC_DATAPORT,   NONE, NONE, 0x02, WRITEREG_DATA | RS2, NULL},
  { PMICMD_OUTB,  DAC_WRITEPORT,  NONE, NONE, NONE, WRITEONLY_DATA | RS2, "\x0a"},
  { PMICMD_OUTB,  DAC_DATAPORT,   NONE, NONE, 0x03, WRITEREG_DATA | RS2, NULL},
  { PMICMD_OUTB,  DAC_DATAPORT,   NONE, NONE, 0x04, WRITEREG_DATA | RS2, NULL},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\xff "},
  { PMICMD_NONE },
};

REGDATA aRegDataDacTI3025 [] =                                   /*@V3.0YEE04*/
{                                       /* TI Viewpoint 3025 DAC */
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, 0x00, WRITEREG_DATA | RS2, NULL},
  { PMICMD_REGOP, 0x00,           NONE, 0x01, 0x20, REGISTER_OPERAND | REGISTER_OR, "\x80" }, /*          */
  { PMICMD_OUTB,  DAC_WRITEPORT,  NONE, NONE, 0x01, WRITEREG_DATA | RS3, NULL},
  { PMICMD_REGOP, 0x02,           NONE, 0x01, 0x02, REGISTER_OPEQUAL | REGISTER_AND, "\xfc" }, /*          */
  { PMICMD_OUTB,  DAC_DATAPORT,   NONE, NONE, 0x02, WRITEREG_DATA | RS3, NULL},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, 0x20, WRITEREG_DATA | RS2 | EXECUTE_CMD, NULL},
  { PMICMD_OUTB,  DAC_WRITEPORT,  NONE, NONE, NONE, WRITEONLY_DATA, "\x01" },
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, 0x03, WRITEREG_DATA | RS3, NULL},
  { PMICMD_RMWBI, CRT_INDEXPORT,  CRT_DATAPORT, 0x55, 0xfc, WRITEONLY_DATA, "\x01 "},
  { PMICMD_RMWBI, CRT_INDEXPORT,  CRT_DATAPORT, 0x5C, 0xdf, WRITEONLY_DATA, "\x00 "},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\x0E"}, /* True Color Control */
  { PMICMD_OUTB,  DAC_READPORT,   NONE, NONE, 0x04, WRITEREG_DATA, NULL},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\x0F"}, /* VGA Switch Control */
  { PMICMD_OUTB,  DAC_READPORT,   NONE, NONE, 0x05, WRITEREG_DATA, NULL},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\x18"}, /* Multiplexer Control1 */
  { PMICMD_OUTB,  DAC_READPORT,   NONE, NONE, 0x06, WRITEREG_DATA, NULL},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\x19"}, /* Multiplexer Control2 */
  { PMICMD_OUTB,  DAC_READPORT,   NONE, NONE, 0x07, WRITEREG_DATA, NULL},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\x1A"}, /* Input Clock Selection */
  { PMICMD_OUTB,  DAC_READPORT,   NONE, NONE, 0x08, WRITEREG_DATA, NULL},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\x1B"}, /* Output Clock Selection */
  { PMICMD_OUTB,  DAC_READPORT,   NONE, NONE, 0x09, WRITEREG_DATA, NULL},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\x1C"}, /* Palette Page */
  { PMICMD_OUTB,  DAC_READPORT,   NONE, NONE, 0x0a, WRITEREG_DATA, NULL},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\x1D"}, /* General Control */
  { PMICMD_OUTB,  DAC_READPORT,   NONE, NONE, 0x0b, WRITEREG_DATA, NULL},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\x1E"}, /* Miscellaneous Control */
  { PMICMD_OUTB,  DAC_READPORT,   NONE, NONE, 0x0c, WRITEREG_DATA, NULL},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\x29"}, /* Auxillary Control */
  { PMICMD_OUTB,  DAC_READPORT,   NONE, NONE, 0x0d, WRITEREG_DATA, NULL},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\x2A"}, /* General Purpose I/O Control */
  { PMICMD_OUTB,  DAC_READPORT,   NONE, NONE, 0x0e, WRITEREG_DATA, NULL},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\x2B"}, /* General Purpose I/O Data */
  { PMICMD_OUTB,  DAC_READPORT,   NONE, NONE, 0x0f, WRITEREG_DATA, NULL},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\x2C"}, /*Pixel clock*/
  { PMICMD_OUTB,  DAC_READPORT,   NONE, NONE, NONE, WRITEONLY_DATA, "\x00 "},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\x2D"},
  { PMICMD_OUTB,  DAC_READPORT,   NONE, NONE, 0x10, WRITEREG_DATA, NULL},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\x2C"},
  { PMICMD_OUTB,  DAC_READPORT,   NONE, NONE, NONE, WRITEONLY_DATA, "\x01 "},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\x2D"},
  { PMICMD_OUTB,  DAC_READPORT,   NONE, NONE, 0x11, WRITEREG_DATA, NULL},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\x2C"},
  { PMICMD_OUTB,  DAC_READPORT,   NONE, NONE, NONE, WRITEONLY_DATA, "\x02 "},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\x2D"},
  { PMICMD_OUTB,  DAC_READPORT,   NONE, NONE, 0x12, WRITEREG_DATA, NULL},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\x2C"}, /* MCLK */
  { PMICMD_OUTB,  DAC_READPORT,   NONE, NONE, NONE, WRITEONLY_DATA, "\x00 "},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\x2E"},
  { PMICMD_OUTB,  DAC_READPORT,   NONE, NONE, 0x13, WRITEREG_DATA, NULL},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\x2C"},
  { PMICMD_OUTB,  DAC_READPORT,   NONE, NONE, NONE, WRITEONLY_DATA, "\x01 "},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\x2E"},
  { PMICMD_OUTB,  DAC_READPORT,   NONE, NONE, 0x14, WRITEREG_DATA, NULL},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\x2C"},
  { PMICMD_OUTB,  DAC_READPORT,   NONE, NONE, NONE, WRITEONLY_DATA, "\x02 "},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\x2E"},
  { PMICMD_OUTB,  DAC_READPORT,   NONE, NONE, 0x15, WRITEREG_DATA, NULL},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\x2C"}, /* Loop Clock */
  { PMICMD_OUTB,  DAC_READPORT,   NONE, NONE, NONE, WRITEONLY_DATA, "\x00 "},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\x2F"},
  { PMICMD_OUTB,  DAC_READPORT,   NONE, NONE, 0x16, WRITEREG_DATA, NULL},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\x2C"},
  { PMICMD_OUTB,  DAC_READPORT,   NONE, NONE, NONE, WRITEONLY_DATA, "\x01 "},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\x2F"},
  { PMICMD_OUTB,  DAC_READPORT,   NONE, NONE, 0x17, WRITEREG_DATA, NULL},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\x2C"},
  { PMICMD_OUTB,  DAC_READPORT,   NONE, NONE, NONE, WRITEONLY_DATA, "\x02 "},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\x2F"},
  { PMICMD_OUTB,  DAC_READPORT,   NONE, NONE, 0x18, WRITEREG_DATA, NULL},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\x39"}, /*MCLK/DCLK control*/
  { PMICMD_OUTB,  DAC_READPORT,   NONE, NONE, 0x19, WRITEREG_DATA, NULL},
  { PMICMD_RMWBI, CRT_INDEXPORT,  CRT_DATAPORT, 0x5C, 0xdf, WRITEONLY_DATA, "\x20 "},
  { PMICMD_RMWBI, CRT_INDEXPORT,  CRT_DATAPORT, 0x55, 0xfc, WRITEONLY_DATA, "\x00 "},
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\xff "},
  { PMICMD_NONE },
};

REGDATA aRegDataDacATT498 [] =                                  /*@V3.0YEE09*/
{                                       /* ATT 498/499/409 */
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\x01" },
  { PMICMD_OUTB,  DAC_WRITEPORT,  NONE, NONE, NONE, WRITEONLY_DATA, "\x48" }, /*DCLK position*/
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, 0x00, WRITEREG_DATA, NULL}, /*M parameter*/
  { PMICMD_OUTB,  DAC_WRITEPORT,  NONE, NONE, NONE, WRITEONLY_DATA, "\x49" },
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, 0x01, WRITEREG_DATA, NULL}, /*N/P parameter*/
  { PMICMD_OUTB,  DAC_WRITEPORT,  NONE, NONE, NONE, WRITEONLY_DATA, "\x4a" },
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, 0x02, WRITEREG_DATA, NULL}, /*LF/IBIAS parameter*/
  { PMICMD_OUTB,  DAC_WRITEPORT,  NONE, NONE, NONE, WRITEONLY_DATA, "\x6C" }, /*MCLK position*/
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, 0x03, WRITEREG_DATA, NULL}, /*M parameter*/
  { PMICMD_OUTB,  DAC_WRITEPORT,  NONE, NONE, NONE, WRITEONLY_DATA, "\x6D" },
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, 0x04, WRITEREG_DATA, NULL}, /*N/P parameter*/
  { PMICMD_OUTB,  DAC_WRITEPORT,  NONE, NONE, NONE, WRITEONLY_DATA, "\x6E" },
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, 0x05, WRITEREG_DATA, NULL}, /*LF/IBIAS Larameter*/
  { PMICMD_OUTB,  DAC_WRITEPORT,  NONE, NONE, NONE, WRITEONLY_DATA, "\x06" },/* CLock Control */
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, 0x06, WRITEREG_DATA, NULL},
  { PMICMD_OUTB,  DAC_WRITEPORT,  NONE, NONE, NONE, WRITEONLY_DATA, "\x01" },
  { PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\x00" },
//{ PMICMD_OUTB,  DAC_PIXELMPORT, NONE, NONE, NONE, WRITEONLY_DATA, "\xff "},
  { PMICMD_NONE },
};

CHAR szATI [] =        "ATI Technologies, Inc.";                /*          */
CHAR szATT [] =        "AT&T Microelectronics Inc.";            /*          */
CHAR szBrooktree [] =  "Brooktree Corporation";                 /*          */
CHAR szChrontel [] =   "Chrontel Corporation";                  /*          */
CHAR szCirrus [] =     "Cirrus Logic Inc.";                     /*          */
CHAR szICS [] =        "Integrated Circuit Systems, Inc.";      /*          */
CHAR szInmos [] =      "Inmos Corporation";                     /*          */
CHAR szGeneric [] =    "Generic";                               /*          */
CHAR szMusic [] =      "Music Semiconductors, Inc.";            /*          */
CHAR szSGSThomson [] = "SGS-Thomson Microelectronics";          /*          */
CHAR szSierra [] =     "Sierra Semiconductor Co.";              /*          */
CHAR szS3 [] =         "S3 Incorporated";                       /*          */
CHAR szTI [] =         "Texas Instruments, Inc.";               /*          */
CHAR szWD [] =         "Western Digital Imaging";               /*          */
CHAR szWinbond [] =    "Winbond Electronics North America Corp."; /*          */

SSVGADACINFO asSVGADacInfo [MAX_DAC] =                          /*          */
{
  {
    VGADAC_NAME,
    szGeneric,                                                  /*          */
    0,
    aRegDataNone,                                               /*          */
    aRegDataNone,                                               /*          */
    aRegDataDacDefault,
  },  /* 00 */
  {
    HICOLOR_NAME,
    szGeneric,                                                  /*          */
    1,
    aRegDataDacHiColorIPFClear,                                 /*          */
    aRegDataDacHiColorIPFSet,                                   /*          */
    aRegDataDacHiColor,
  },  /* 01 */
  {
    BT485_NAME,
    szBrooktree,                                                /*          */
    4,
    aRegDataNone,                                               /*          */
    aRegDataNone,                                               /*          */
    aRegDataDacBT485,
  },  /* 02 */
  {
    BT485_NAME,
    szBrooktree,                                                /*          */
    4,
    aRegDataNone,                                               /*          */
    aRegDataNone,                                               /*          */
    aRegDataDacViper,
  },  /* 03 */
  {                                                             /*          */
    SC15025_NAME,                                               /*          */
    szSierra,                                                   /*          */
    1,                                                          /*          */
    aRegDataDacHiColorIPFClear,                                 /*          */
    aRegDataDacHiColorIPFSet,                                   /*          */
    aRegDataDacHiColor,                                         /*          */
  },  /* 04 */                                                  /*          */
  {
    ATT490_NAME,
    szATT,                                                      /*          */
    1,
    aRegDataDacHiColorIPFClear,                                 /*          */
    aRegDataDacHiColorIPFSet,                                   /*          */
    aRegDataDacHiColor,
  },  /* 05 */
  {
    MU9C1880_NAME,
    szMusic,                                                    /*          */
    1,
    aRegDataDacHiColorIPFClear,                                 /*          */
    aRegDataDacHiColorIPFSet,                                   /*          */
    aRegDataDacHiColor,
  },  /* 06 */
  {                                                             /*          */
    TRUECOLOR_NAME,                                             /*          */
    szGeneric,                                                  /*          */
    1,                                                          /*          */
    aRegDataDacHiColorIPFClear,                                 /*          */
    aRegDataDacHiColorIPFSet,                                   /*          */
    aRegDataDacHiColor,                                         /*          */
  },  /* 07 */                                                  /*          */
  {
    IMSG173_NAME,
    szInmos,                                                    /*          */
    1,
    aRegDataDacHiColorIPFClear,                                 /*          */
    aRegDataDacHiColorIPFSet,                                   /*          */
    aRegDataDacHiColor,
  },  /* 08 */
  {
    CH8398_NAME,
    szChrontel,                                                 /*          */
    1,
    aRegDataDacHiColorIPFClear,                                 /*          */
    aRegDataDacHiColorIPFSet,                                   /*          */
    aRegDataDacHiColor,
  },  /* 09 */
  {                                                             /*          */
    CIRRUS_NAME,                                                /*          */
    szCirrus,                                                   /*          */
    1,                                                          /*          */
    aRegDataDacHiColorIPFClear,                                 /*          */
    aRegDataDacHiColorIPFSet,                                   /*          */
    aRegDataDacHiColor,                                         /*          */
  },  /* 10 */                                                  /*          */
  {
    ICS5341_NAME,
    szICS,                                                      /*          */
    5,                                                          /*@V3.0YEE09*/
    aRegDataNone,                                               /*@V3.0YEE09*/
    aRegDataNone,                                               /*@V3.0YEE09*/
    aRegDataDacS3SDAC,                                          /*@V3.0YEE09*/
  },  /* 11 */
  {                                                             /*          */
    SGS1702_NAME,                                               /*          */
    szSGSThomson,                                               /*          */
    4,                                                          /*          */
    aRegDataDacHiColorIPFClear,                                 /*          */
    aRegDataDacHiColorIPFSet,                                   /*          */
    aRegDataDacSGSThomson,                                      /*          */
  },  /* 12 */                                                  /*          */
  {                                                             /*          */
    SGS1703_NAME,                                               /*          */
    szSGSThomson,                                               /*          */
    6,                                                          /*          */
    aRegDataDacHiColorIPFClear,                                 /*          */
    aRegDataDacHiColorIPFSet,                                   /*          */
    aRegDataDacSGSThomson1703,                      /*@V3.0YEE07            */
  },  /* 13 */                                                  /*          */
  {
    MU9C4910_NAME,
    szMusic,                                                    /*          */
    1,
    aRegDataDacHiColorIPFClear,                                 /*          */
    aRegDataDacHiColorIPFSet,                                   /*          */
    aRegDataDacHiColor,
  },  /* 14 */
  {                                                             /*          */
    ATI68830_NAME,                                              /*          */
    szATI,                                                      /*          */
    4,                                                          /*          */
    aRegDataNone,                                               /*          */
    aRegDataNone,                                               /*          */
    aRegDataDacTLC34075,                                        /*          */
  },  /* 15 */                                                  /*          */
  {                                                             /*          */
    S3SDAC_NAME,                                                /*          */
    szS3,                                                       /*          */
    5,                                                          /*          */
    aRegDataNone,                                               /*          */
    aRegDataNone,                                               /*          */
    aRegDataDacS3SDAC,                                          /*          */
  },  /* 16 */                                                  /*          */
  {                                                             /*          */
    ATT498_NAME,                                                /*          */
    szATT,                                                      /*          */
    7,                                                          /*@V3.0YEE09*/
    aRegDataDacHiColorIPFClear,                                 /*          */
    aRegDataDacHiColorIPFSet,                                   /*          */
    aRegDataDacATT498,                                          /*@V3.0YEE09*/
  },  /* 17 */                                                  /*          */
  {                                                             /*          */
    SGS1700_NAME,                                               /*          */
    szSGSThomson,                                               /*          */
    4,                                                          /*          */
    aRegDataDacHiColorIPFClear,                                 /*          */
    aRegDataDacHiColorIPFSet,                                   /*          */
    aRegDataDacSGSThomson,                                      /*          */
  },  /* 18 */                                                  /*          */
  {                                                             /*          */
    TLC34075_NAME,                                              /*          */
    szTI,                                                       /*          */
    4,                                                          /*          */
    aRegDataNone,                                               /*          */
    aRegDataNone,                                               /*          */
    aRegDataDacTLC34075,                                        /*          */
  },  /* 19 */                                                  /*          */
  {                                                             /*          */
    BT476_NAME,                                                 /*          */
    szBrooktree,                                                /*          */
    1,                                                          /*          */
    aRegDataDacHiColorIPFClear,                                 /*          */
    aRegDataDacHiColorIPFSet,                                   /*          */
    aRegDataDacHiColor,                                         /*          */
  },  /* 20 */                                                  /*          */
  {                                                             /*          */
    BT481_NAME,                                                 /*          */
    szBrooktree,                                                /*          */
    1,                                                          /*          */
    aRegDataDacHiColorIPFClear,                                 /*          */
    aRegDataDacHiColorIPFSet,                                   /*          */
    aRegDataDacHiColor,                                         /*          */
  },  /* 21 */                                                  /*          */
  {                                                             /*          */
    ATI68860_NAME,                                              /*          */
    szATI,                                                      /*          */
    4,                                                          /*          */
    aRegDataNone,                                               /*          */
    aRegDataNone,                                               /*          */
    aRegDataDacTLC34075,                                        /*          */
  },  /* 22 */                                                  /*          */
  {                                                             /*          */
//  Due to localized     fix for r207beta2                      /*          */
//  This is a temporary use of the actual name string:          /*          */
//  MU9CBUG_NAME,                                               /*          */
    "MU9CBUG",                                                  /*          */
    szMusic,                                                    /*          */
    1,                                                          /*          */
    aRegDataDacHiColorIPFClear,                                 /*          */
    aRegDataDacMusicBugIPFSet,                                  /*          */
    aRegDataDacHiColor,                                         /*          */
  },  /* 23 */                                                  /*          */
  {                                                             /*          */
    CH8391_NAME,                                                /*          */
    szChrontel,                                                 /*          */
    1,                                                          /*          */
    aRegDataDacHiColorIPFClear,                                 /*          */
    aRegDataDacHiColorIPFSet,                                   /*          */
    aRegDataDacHiColor,                                         /*          */
  },  /* 24 */                                                  /*          */
  {                                                             /*          */
    W82C490_NAME,                                               /*          */
    szWinbond,                                                  /*          */
    1,                                                          /*          */
    aRegDataDacHiColorIPFClear,                                 /*          */
    aRegDataDacHiColorIPFSet,                                   /*          */
    aRegDataDacHiColor,                                         /*          */
  },  /* 25 */                                                  /*          */
  {                                                             /*          */
    ATT491_NAME,                                                /*          */
    szATT,                                                      /*          */
    1,                                                          /*          */
    aRegDataDacHiColorIPFClear,                                 /*          */
    aRegDataDacHiColorIPFSet,                                   /*          */
    aRegDataDacHiColor,                                         /*          */
  },  /* 26 */                                                  /*          */
  {                                                             /*          */
    ATT492_NAME,                                                /*          */
    szATT,                                                      /*          */
    1,                                                          /*          */
    aRegDataDacHiColorIPFClear,                                 /*          */
    aRegDataDacHiColorIPFSet,                                   /*          */
    aRegDataDacHiColor,                                         /*          */
  },  /* 27 */                                                  /*          */
  {                                                             /*          */
    ATT493_NAME,                                                /*          */
    szATT,                                                      /*          */
    1,                                                          /*          */
    aRegDataDacHiColorIPFClear,                                 /*          */
    aRegDataDacHiColorIPFSet,                                   /*          */
    aRegDataDacHiColor,                                         /*          */
  },  /* 28 */                                                  /*          */
  {                                                             /*          */
    ATT497_NAME,                                                /*          */
    szATT,                                                      /*          */
    1,                                                          /*          */
    aRegDataDacHiColorIPFClear,                                 /*          */
    aRegDataDacHiColorIPFSet,                                   /*          */
    aRegDataDacHiColor,                                         /*          */
  },  /* 29 */                                                  /*          */
  {                                                             /*          */
    WD90C24_NAME,                                               /*          */
    szWD,                                                       /*          */
    0,                                                          /*          */
    aRegDataNone,                                               /*          */
    aRegDataNone,                                               /*          */
    aRegDataDacDefault,                 /* 3c4.26! */           /*          */
  },  /* 30 */                                                  /*          */
  {                                                             /*          */
    MU9C9910_NAME,                                              /*          */
    szMusic,                                                    /*          */
    1,                                                          /*          */
    aRegDataDacHiColorIPFClear,                                 /*          */
    aRegDataDacHiColorIPFSet,                                   /*          */
    aRegDataDacHiColor,                                         /*          */
  },  /* 31 */                                                  /*          */
  {                                                             /*          */
    ATT409_NAME,                                                /*          */
    szATT,                                                      /*          */
    7,                                                          /*@V3.0YEE09*/
    aRegDataDacHiColorIPFClear,                                 /*          */
    aRegDataDacHiColorIPFSet,                                   /*          */
    aRegDataDacATT498,                                          /*@V3.0YEE09*/
  },  /* 32 */                                                  /*          */
  {                                                             /*@V3.0YEE04*/
    TI3025_NAME,
    szTI,
    26,
    aRegDataNone,
    aRegDataNone,
    aRegDataDacTI3025,
  },  /* 33 */
};

/*
**
**              Chipset Setbank Information
**
**              Set/Get Banks are based on svgabank.asm in screendd
**              of Picard.           
**
**              Registers are unlocked already and always set/get
**              write bank only.
**
*/

REGDATA IBMSetBankCmd[] =
/*****************************************    Picard 2/8/94
-----------------------------------------------------
IBM
  r0 = 0;
  ;
  ; add XGAInstance to the port address, outb(8+XGAInstance, r0);
  ; Handled in svga.c.
  ;
  outb(8, r0);
***************************************************************/
{
    { PMICMD_REGOP, NONE,   NONE, 0x01, 0x00, WRITEONLY_DATA, b_0 },
    { PMICMD_OUTB,  0x2108, NONE, NONE, 0x00, WRITEREG_DATA       }, /*          */
    { PMICMD_NONE },
};

REGDATA HeadlandSetBank1Cmd[] =   /* HT205 */
/***************************************** Borg 2/8/94
Only for HT209
---------------------------------------------------------
Video 7

  r0 = 0;
  inb (r1, 0x3c4);      ; save SEQ index

  outb(0x3c4, 0xe0);    ; Misc. Control
  inb(r2, 0x3c5);
  r2 &= 0x7f;
  outb(0x3c5, r2);      ; Set Single Bank Mode
  r0 <= 0x04;
  if (TEXT_MODE)
     r0 |= 0x20;
  outb (0x3c4, 0xe8);
  outb (0x3c5, r0);
  outb (0x3c4, 0xe9);
  outb (0x3c5, r0);
  outb (0x3c4, r1);      ; restore SEQ index

***************************************************************/
{
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x00, WRITEONLY_DATA, b_0 },
    { PMICMD_NONE },
};

REGDATA HeadlandSetBank2Cmd[] =   /* HT208 */
{
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x00, WRITEONLY_DATA, b_0 },
    { PMICMD_NONE },
};

REGDATA HeadlandSetBank3Cmd[] =   /* HT209 */
{
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x00, WRITEONLY_DATA, b_0 },
    { PMICMD_INB, SEQ_INDEXPORT, NONE, NONE, 1, NONE, NULL },
    { PMICMD_OUTB, SEQ_INDEXPORT, NONE, NONE, 0, WRITEONLY_DATA, "\xE0" },
    { PMICMD_INB, SEQ_DATAPORT, NONE, NONE, 2, NONE, NULL },
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x02, REGISTER_OPEQUAL|REGISTER_AND, "\x7F" },
    { PMICMD_OUTB, SEQ_DATAPORT, NONE, NONE, 2, WRITEREG_DATA },
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x00, REGISTER_OPEQUAL|REGISTER_SHL, b_4 },
    { PMICMD_OUTB, SEQ_INDEXPORT, NONE, NONE, 0, WRITEONLY_DATA, "\xE8" },
    { PMICMD_OUTB, SEQ_DATAPORT, NONE, NONE, 0, WRITEREG_DATA },
    { PMICMD_OUTB, SEQ_INDEXPORT, NONE, NONE, 0, WRITEONLY_DATA, "\xE9" },
    { PMICMD_OUTB, SEQ_DATAPORT, NONE, NONE, 0, WRITEREG_DATA },
    { PMICMD_OUTB, SEQ_INDEXPORT, NONE, NONE, 1, WRITEREG_DATA },
    { PMICMD_NONE },
};

REGDATA TridentSetBankCmd[] =
/**************************************************************
Set bank in new def. registers. doesn't restore to old def. Borg 2/8/94
-----------------------------------------------------
  r0 = 0;
  inb (r1, 0x3c4);           ; save SEQ index
  inb (r2, 0x3ce);           ; save GDC index

  outW(0x3c4, 0x000b);       ; set it old definition
  inb(r3, 0x3c5);            ; toggle it to new definition

  inb(r3, 0x3cc);            ; get Misc Output
  r3 |= 0x20;                ; enable CPU access video RAM
  outb(0x3c2, r3);

  outw (0x3ce, 0x0506);      ; save memory addressing mode to 64K and
                             ; in graphics mode
  outb(0x3c4, 0x0e);
  r0 ^= 0x02;
  outb(0x3c5, r0);           ; set bank

  outb (0x3c4, r1);          ; restore SEQ index
  outb (0x3ce, r2);          ; restore GDC index


The way to input from 3c5, for example, to toggle the state.

R0 = regindex
R1 = DO it = 1 (Not = 0)
R2 = R0 + !R1 (if R1 == 1, R2 will be different from R0)
outb(3c4, r2)
inb(r3, 3c5)




Trident
  ;
  ; Will process only graphics mode
  ;
  r0 = 0;
  inb(r1, 0x3ce);             save GDC index
  outw(0x3ce, 0x0506);
  inb(r2, 0x3c4);             save SEQ index

; GETTRIDENTREGDEF
  outb(0x3c4, 0x0e);          Mode Ctrl Reg 1 index
  inb(r3, 0x3c5);             get Mode Ctrl Reg 1
  outb(0x3c5, r3);            set Mode Ctrl Reg 1 again
  inb(r4, 0x3c5);             get Mode Ctrl Reg 1 again
  outb(0x3c5, r4);            set Mode Ctrl Reg 1 again guarantee same
  r4 = r4 != r3;

  outb(0x3c4, 0x0b);          Hardware version index
  inb(r3, 0x3c5);             read & ignore Hardware version/set new reg defs

  inb(r3, 0x3cc);             get Misc Output
  r3 |= 0x20;                 select low page memory
  outb(0x3c2, r3);
  outb(0x3c4, 0x0e);
  r0 = r0 ^ 0x02;
  outb(0x3c5, r0);            set bank
;
  outb(0x3c4, 0x0b);
  outb(0x3c5, 0x01);          change mode to old def.

******************************************************
 Tricky way to set the old definition.

  R4 = !R1
  R0 = 0B
  R2 = 0B + R4
  outb(3c4, R2)
  inb(R3, 3C5)
  outb(3c5, R3)
  **************
  if R4 is 1, which means not to do it, R2 will 0C. 0C is the
  configuration port register. It won't hurt to read it and write it back.

  ;
  ; If old def.,
  ;      outb(0x3c4, 0x0b);
  ;      outb(0x3c5, 0x01);
  ;
  outb(0x3c4, r2);            restore index
  outb(0x3ce, r1);            restore index

***************************************************************/
{
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x00, WRITEONLY_DATA, b_0 },
    { PMICMD_INB, SEQ_INDEXPORT, NONE, NONE, 1, NONE, NULL },
    { PMICMD_INB, GDC_INDEXPORT, NONE, NONE, 2, NONE, NULL },
    { PMICMD_OUTW, SEQ_INDEXPORT, NONE, NONE, 0, WRITEONLY_DATA, b_B },
    { PMICMD_INB, SEQ_DATAPORT, NONE, NONE, 3, NONE, NULL },
    { PMICMD_INB, MISCOUTPUTREG_READ, NONE, NONE, 3, NONE, NULL },
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x03, REGISTER_OPEQUAL|REGISTER_OR, "\x20" },
    { PMICMD_OUTB, MISCOUTPUTREG_WRITE, NONE, NONE, 3, WRITEREG_DATA },
    { PMICMD_OUTB, GDC_INDEXPORT, NONE, NONE, 0, WRITEONLY_DATA, "\x06" },
    { PMICMD_OUTB, GDC_DATAPORT, NONE, NONE, 0, WRITEONLY_DATA, "\x05" },
    { PMICMD_OUTB, SEQ_INDEXPORT, NONE, NONE, 0, WRITEONLY_DATA, b_E },
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x00, REGISTER_OPEQUAL|REGISTER_XOR, b_2 },
    { PMICMD_OUTB, SEQ_DATAPORT, NONE, NONE, 0, WRITEREG_DATA },
    { PMICMD_OUTB, SEQ_INDEXPORT, NONE, NONE, 1, WRITEREG_DATA },
    { PMICMD_OUTB, GDC_INDEXPORT, NONE, NONE, 2, WRITEREG_DATA },
    { PMICMD_NONE },
};

/*
**
**              Chipset Getbank Information            
**
*/

REGDATA IBMGetBankCmd[] =
/*********************************************** 2/28/94 Picard
----------------------------------------
IBM
    ;
    ; mov r1, XGAInstance
    ;
    r1 += 8;
    inw(r0, r1);
***************************************************************/
{
    { PMICMD_INB,   0x2108, NONE, NONE, 0, NONE, NULL },  /*          */
    { PMICMD_NONE },
};

REGDATA HeadlandGetBank1Cmd[] =      /* HT205 */
/******************************************* Borg 2/8/94
Only for HT209 in single bank mode
----------------------------------------------------------
Video 7
  inb(r1, 0x3c4);    save index
  outb(0x3c4, 0xe8);
  inb(r0,0x3c5);     write bank/single bank
  r0 >= 0x04;
  outb(0x3c4, r1);



***************************************************************/
{
    { PMICMD_NONE },
};

REGDATA HeadlandGetBank2Cmd[] =      /* HT208 */
{
    { PMICMD_NONE },
};

REGDATA HeadlandGetBank3Cmd[] =      /* HT209 */
{
    { PMICMD_INB, SEQ_INDEXPORT, NONE, NONE, 1, NONE, NULL },
    { PMICMD_OUTB, SEQ_INDEXPORT, NONE, NONE, 0, WRITEONLY_DATA, "\xE8" },
    { PMICMD_INB, SEQ_DATAPORT, NONE, NONE, 0, NONE, NULL },
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x00, REGISTER_OPEQUAL|REGISTER_SHR, b_4 },
    { PMICMD_OUTB, SEQ_INDEXPORT, NONE, NONE, 1, WRITEREG_DATA },
    { PMICMD_NONE },
};

REGDATA TridentGetBankCmd[] =
/************************************************ Borg 2/8/94
Change to New defintion, didn't change it back.
--------------------------------------------------------
Trident

      inb(r1, 0x3c4);     save index
      outw(0x3c4, 0x000b); change to old def.
      inb(r2, 0x3c5);    change to new def.
      outb(0x3c4, 0x0e);
      inb(r0, 0x3c5);
      ;
      ; if old def., restore it back.
      ;
      r0 &= 0x0f;
      outb(0x3c4, r1);

***************************************************************/
{
    { PMICMD_INB, SEQ_INDEXPORT, NONE, NONE, 1, NONE, NULL },
    { PMICMD_OUTW, SEQ_INDEXPORT, NONE, NONE, 0, WRITEONLY_DATA, b_B },
    { PMICMD_INB, SEQ_DATAPORT, NONE, NONE, 2, NONE, NULL },
    { PMICMD_OUTB, SEQ_INDEXPORT, NONE, NONE, 0, WRITEONLY_DATA, b_E },
    { PMICMD_INB, SEQ_DATAPORT, NONE, NONE, 0, NONE, NULL },
    { PMICMD_REGOP, NONE, NONE, 0x01, 0x00, REGISTER_OPEQUAL|REGISTER_AND, b_F },
    { PMICMD_OUTB, SEQ_INDEXPORT, NONE, NONE, 1, WRITEREG_DATA },
    { PMICMD_NONE },
};

/*
**      Standard VGA Chipset - for GENERIC use only.
*/


BANKROUTINE IBMSetBank = {"SetBankLinear", IBMSetBankCmd},
             IBMGetBank = {"GetBankLinear", IBMGetBankCmd},
             HeadlandSetBank1 = {"SetBankLinear", HeadlandSetBank1Cmd},
             HeadlandGetBank1 = {"GetBankLinear", HeadlandGetBank1Cmd},
             HeadlandSetBank2 = {"SetBankLinear", HeadlandSetBank2Cmd},
             HeadlandGetBank2 = {"GetBankLinear", HeadlandGetBank2Cmd},
             HeadlandSetBank3 = {"SetBankLinear", HeadlandSetBank3Cmd},
             HeadlandGetBank3 = {"GetBankLinear", HeadlandGetBank3Cmd},
             TridentSetBank = {"SetBankLinear", TridentSetBankCmd},
             TridentGetBank = {"GetBankLinear", TridentGetBankCmd};



PCHIPINFO VGAChipSet = NULL;
PREGDATA  VGASetBank = NULL;
PREGDATA  VGALock    = NULL;
PREGDATA  VGAUnLock  = NULL;
PREGDATA  VGACleanup = NULL;

REGDATA VGARegData[] =
{
  { PMICMD_OUTB,  MISCOUTPUTREG_WRITE, NONE,   0x00, 0x00, WRITEONLY_DATA, &MiscOutRegData }, /*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x05, 0x00, READWRITE_DATA, &SEQRegData[0x00] },
  { PMICMD_OUTW,  SEQ_INDEXPORT, NONE,         NONE, 0x00, WRITEONLY_DATA, &bEndSEQReset[0] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x19, 0x00, READWRITE_DATA, &CRTRegData[0x00] },
  { PMICMD_BOUTB, ATC_INDEXPORT, ATC_DATAPORT, 0x15, 0x00, READWRITE_DATA, &ATCRegData[0x00] }, /*          */
  { PMICMD_BOUTB, GDC_INDEXPORT, GDC_DATAPORT, 0x09, 0x00, READWRITE_DATA, &GDCRegData[0x00] },
  { PMICMD_OUTB,  MISCOUTPUTREG_WRITE, NONE,   0x00, 0x00, WRITEONLY_DATA, &MiscOutRegData }, /*          */
  { PMICMD_NONE },
};

/*
**
**              Chipset Mode Information
**
*/

/*
** HT205
*/

REGDATA HeadlandModeSet1 [] =
{
  { PMICMD_OUTB,  MISCOUTPUTREG_WRITE, NONE,   0x00, 0x00, WRITEONLY_DATA, &MiscOutRegData }, /*          */
  { PMICMD_OUTW,  SEQ_INDEXPORT, NONE, NONE, 0x00, WRITEONLY_DATA, b_0 },
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x04, 0x00, READWRITE_DATA, &SEQRegData[0x00] },
  /* Indicate all regs so the trap register list is complete! *//*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x01, 0x94, READWRITE_DATA, &SEQRegData[0x94] }, /*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x0a, 0x9c, READWRITE_DATA, &SEQRegData[0x9c] }, /*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x01, 0xb3, READWRITE_DATA, &SEQRegData[0xb3] }, /*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x01, 0xc0, READWRITE_DATA, &SEQRegData[0xc0] }, /*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x02, 0xc8, READWRITE_DATA, &SEQRegData[0xc8] }, /*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x03, 0xe0, READWRITE_DATA, &SEQRegData[0xe0] }, /*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x08, 0xe8, READWRITE_DATA, &SEQRegData[0xe8] }, /*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x0d, 0xf3, READWRITE_DATA, &SEQRegData[0xf3] }, /*          */
  /* Not just these regs needed for the video mode itself! */   /*          */
//{ PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x01, 0xA4, READWRITE_DATA, &SEQRegData[0xA4] },
//{ PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x01, 0xF6, READWRITE_DATA, &SEQRegData[0xF6] },
//{ PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x01, 0xF8, READWRITE_DATA, &SEQRegData[0xF8] },
//{ PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x01, 0xFC, READWRITE_DATA, &SEQRegData[0xFC] },
//{ PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x01, 0xFD, READWRITE_DATA, &SEQRegData[0xFD] },
//{ PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x01, 0xFF, READWRITE_DATA, &SEQRegData[0xFF] },
  { PMICMD_OUTW,  SEQ_INDEXPORT, NONE, NONE, 0x00, WRITEONLY_DATA, &bEndSEQReset[0] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x19, 0x00, READWRITE_DATA, &CRTRegData[0x00] },
  { PMICMD_BOUTB, ATC_INDEXPORT, ATC_DATAPORT, 0x15, 0x00, READWRITE_DATA, &ATCRegData[0x00] }, /*          */
  { PMICMD_BOUTB, GDC_INDEXPORT, GDC_DATAPORT, 0x09, 0x00, READWRITE_DATA, &GDCRegData[0x00] },
  { PMICMD_NONE }
};

CHIPINFO HeadlandChipSet1[] = {

  {
    VGAMODE,
    &ChipInfoHeader[GRAPHICS_640x480x16],
    &HeadlandSetBank1,
    &HeadlandGetBank1,
    HeadlandModeSet1,
    0,                                                         /*JWK10*/
  },

  {
    0x67,
    &ChipInfoHeader[GRAPHICS_640x480x256],
    &HeadlandSetBank1,
    &HeadlandGetBank1,
    HeadlandModeSet1,
    0,                                                         /*JWK10*/
  },

  {
    0x62,
    &ChipInfoHeader[GRAPHICS_800x600x16],
    &HeadlandSetBank1,
    &HeadlandGetBank1,
    HeadlandModeSet1,
    0,                                                         /*JWK10*/
  },

  {
    0x01,
    &ChipInfoHeader[TEXT_40x25],
    &HeadlandSetBank1,
    &HeadlandGetBank1,
    HeadlandModeSet1,
    0,                                                         /*JWK10*/
  },

  {
    0x03,
    &ChipInfoHeader[TEXT_80x25],
    &HeadlandSetBank1,
    &HeadlandGetBank1,
    HeadlandModeSet1,
    0,                                                         /*JWK10*/
  },

  {
    0x41,
    &ChipInfoHeader[TEXT_132x25],
    &HeadlandSetBank1,
    &HeadlandGetBank1,
    HeadlandModeSet1,
    0,                                                         /*JWK10*/
  },

  {
    0x42,
    &ChipInfoHeader[TEXT_132x43],
    &HeadlandSetBank1,
    &HeadlandGetBank1,
    HeadlandModeSet1,
    0,                                                         /*JWK10*/
  },
};

USHORT usSizeHeadlandChipSet1 = sizeof(HeadlandChipSet1)/sizeof(CHIPINFO);

/*
** HT208
*/

/*!! Does this have to be different from HeadlandModeSet1? */   /*          */
REGDATA HeadlandModeSet2 [] =
{
  { PMICMD_OUTB,  MISCOUTPUTREG_WRITE, NONE,   0x00, 0x00, WRITEONLY_DATA, &MiscOutRegData }, /*          */
  { PMICMD_OUTW,  SEQ_INDEXPORT, NONE, NONE, 0x00, WRITEONLY_DATA, b_0 },
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x05, 0x00, READWRITE_DATA, &SEQRegData[0x00] },
  /* Indicate all regs so the trap register list is complete! *//*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x01, 0x94, READWRITE_DATA, &SEQRegData[0x94] }, /*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x0a, 0x9c, READWRITE_DATA, &SEQRegData[0x9c] }, /*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x01, 0xb3, READWRITE_DATA, &SEQRegData[0xb3] }, /*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x01, 0xc0, READWRITE_DATA, &SEQRegData[0xc0] }, /*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x02, 0xc8, READWRITE_DATA, &SEQRegData[0xc8] }, /*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x03, 0xe0, READWRITE_DATA, &SEQRegData[0xe0] }, /*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x08, 0xe8, READWRITE_DATA, &SEQRegData[0xe8] }, /*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x0d, 0xf3, READWRITE_DATA, &SEQRegData[0xf3] }, /*          */
  /* Not just these regs needed for the video mode itself! */   /*          */
//{ PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x01, 0xA4, READWRITE_DATA, &SEQRegData[0xA4] },
//{ PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x01, 0xE0, READWRITE_DATA, &SEQRegData[0xE0] },
//{ PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x01, 0xF6, READWRITE_DATA, &SEQRegData[0xF6] },
//{ PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x01, 0xF8, READWRITE_DATA, &SEQRegData[0xF8] },
//{ PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x01, 0xFC, READWRITE_DATA, &SEQRegData[0xFC] },
//{ PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x01, 0xFD, READWRITE_DATA, &SEQRegData[0xFD] },
//{ PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x01, 0xFF, READWRITE_DATA, &SEQRegData[0xFF] },
  { PMICMD_OUTW,  SEQ_INDEXPORT, NONE, NONE, 0x00, WRITEONLY_DATA, &bEndSEQReset[0] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x19, 0x00, READWRITE_DATA, &CRTRegData[0x00] },
  { PMICMD_BOUTB, ATC_INDEXPORT, ATC_DATAPORT, 0x15, 0x00, READWRITE_DATA, &ATCRegData[0x00] }, /*          */
  { PMICMD_BOUTB, GDC_INDEXPORT, GDC_DATAPORT, 0x09, 0x00, READWRITE_DATA, &GDCRegData[0x00] },
  { PMICMD_NONE }
};

CHIPINFO HeadlandChipSet2[] = {

  {
    VGAMODE,
    &ChipInfoHeader[GRAPHICS_640x480x16],
    &HeadlandSetBank2,
    &HeadlandGetBank2,
    HeadlandModeSet2,
    0,                                                         /*JWK10*/
  },

  {
    0x67,
    &ChipInfoHeader[GRAPHICS_640x480x256],
    &HeadlandSetBank2,
    &HeadlandGetBank2,
    HeadlandModeSet2,
    0,                                                         /*JWK10*/
  },

  {
    0x62,
    &ChipInfoHeader[GRAPHICS_800x600x16],
    &HeadlandSetBank2,
    &HeadlandGetBank2,
    HeadlandModeSet2,
    0,                                                         /*JWK10*/
  },

  {
    0x69,
    &ChipInfoHeader[GRAPHICS_800x600x256],
    &HeadlandSetBank2,
    &HeadlandGetBank2,
    HeadlandModeSet2,
    0,                                                         /*JWK10*/
  },

  {
    0x65,
    &ChipInfoHeader[GRAPHICS_1024x768x16],
    &HeadlandSetBank2,
    &HeadlandGetBank2,
    HeadlandModeSet2,
    0,                                                         /*JWK10*/
  },

  {
    0x01,
    &ChipInfoHeader[TEXT_40x25],
    &HeadlandSetBank2,
    &HeadlandGetBank2,
    HeadlandModeSet2,
    0,                                                         /*JWK10*/
  },

  {
    0x03,
    &ChipInfoHeader[TEXT_80x25],
    &HeadlandSetBank2,
    &HeadlandGetBank2,
    HeadlandModeSet2,
    0,                                                         /*JWK10*/
  },

  {
    0x41,
    &ChipInfoHeader[TEXT_132x25],
    &HeadlandSetBank2,
    &HeadlandGetBank2,
    HeadlandModeSet2,
    0,                                                         /*JWK10*/
  },

  {
    0x42,
    &ChipInfoHeader[TEXT_132x43],
    &HeadlandSetBank2,
    &HeadlandGetBank2,
    HeadlandModeSet2,
    0,                                                         /*JWK10*/
  },

};

USHORT usSizeHeadlandChipSet2 = sizeof(HeadlandChipSet2)/sizeof(CHIPINFO);

/*
** HT209
*/

CHIPINFO HeadlandChipSet3[] = {

  {
    VGAMODE,
    &ChipInfoHeader[GRAPHICS_640x480x16],
    &HeadlandSetBank3,
    &HeadlandGetBank3,
    HeadlandModeSet2,
    0,                                                         /*JWK10*/
  },

  {
    0x67,
    &ChipInfoHeader[GRAPHICS_640x480x256],
    &HeadlandSetBank3,
    &HeadlandGetBank3,
    HeadlandModeSet2,
    0,                                                         /*JWK10*/
  },

  {
    0x62,
    &ChipInfoHeader[GRAPHICS_800x600x16],
    &HeadlandSetBank3,
    &HeadlandGetBank3,
    HeadlandModeSet2,
    0,                                                         /*JWK10*/
  },

  {
    0x69,
    &ChipInfoHeader[GRAPHICS_800x600x256],
    &HeadlandSetBank3,
    &HeadlandGetBank3,
    HeadlandModeSet2,
    0,                                                         /*JWK10*/
  },

  {
    0x65,
    &ChipInfoHeader[GRAPHICS_1024x768x16],
    &HeadlandSetBank3,
    &HeadlandGetBank3,
    HeadlandModeSet2,
    0,                                                         /*JWK10*/
  },

  {
    0x6a,
    &ChipInfoHeader[GRAPHICS_1024x768x256],
    &HeadlandSetBank3,
    &HeadlandGetBank3,
    HeadlandModeSet2,
    0,                                                         /*JWK10*/
  },

  {
    0x01,
    &ChipInfoHeader[TEXT_40x25],
    &HeadlandSetBank3,
    &HeadlandGetBank3,
    HeadlandModeSet2,
    0,                                                         /*JWK10*/
  },

  {
    0x03,
    &ChipInfoHeader[TEXT_80x25],
    &HeadlandSetBank3,
    &HeadlandGetBank3,
    HeadlandModeSet2,
    0,                                                         /*JWK10*/
  },

  {
    0x41,
    &ChipInfoHeader[TEXT_132x25],
    &HeadlandSetBank3,
    &HeadlandGetBank3,
    HeadlandModeSet2,
    0,                                                         /*JWK10*/
  },

  {
    0x42,
    &ChipInfoHeader[TEXT_132x43],
    &HeadlandSetBank3,
    &HeadlandGetBank3,
    HeadlandModeSet2,
    0,                                                         /*JWK10*/
  },
};

USHORT usSizeHeadlandChipSet3 = sizeof(HeadlandChipSet3)/sizeof(CHIPINFO);

/*
** Trident 8800
*/

CHIPINFO TridentChipSet1[] =
{
  {0},
};

USHORT usSizeTridentChipSet1 = sizeof(TridentChipSet1)/sizeof(CHIPINFO);

/*
** Trident 8900
*/

REGDATA TridentModeSet2 [] =
{
  { PMICMD_OUTB,  MISCOUTPUTREG_WRITE, NONE,   0x00, 0x00, WRITEONLY_DATA, &MiscOutRegData }, /*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x05, 0x00, READWRITE_DATA, &SEQRegData[0x00] },
  { PMICMD_OUTW,  SEQ_INDEXPORT, NONE,         NONE, 0x00, WRITEONLY_DATA | EXECUTE_CMD, "\x0b\x01" }, /*          */
//{ PMICMD_OUTW,  SEQ_INDEXPORT, NONE,         NONE, 0x00, WRITEONLY_DATA, "\x0d\x20" }, /*          */
//{ PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x01, 0x0d, READWRITE_DATA, &SEQRegData[0x0d]}, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x0d, 0x00, READWRITE_DATA, &SEQRegData[0x0d] }, /*          */
  { PMICMD_OUTB,  SEQ_INDEXPORT, NONE,         NONE, 0x00, WRITEONLY_DATA | EXECUTE_CMD, b_B }, /*          */
  { PMICMD_INB,   SEQ_DATAPORT,  NONE,         NONE, 0x00, EXECUTE_CMD, NULL }, /*          */
  { PMICMD_REGOP, NONE,          NONE,         0x01, 0x0e, WRITEONLY_DATA, b_0 },
  { PMICMD_REGOP, NONE,          NONE,         0x01, 0x0e, REGISTER_OPEQUAL | REGISTER_OR, "\x80" },
  { PMICMD_REGOP, NONE,          NONE,         0x01, 0x0e, REGISTER_OPEQUAL | REGISTER_XOR, b_2 },
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x01, 0x0e, DONTWRITE_DATA },
//                                                                                              /*          */
//Cannot use the following because we don't want saves to read these regs!                      /*          */
//We just want it to set them!                                                                  /*          */
//{ PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x02, 0x0c, READWRITE_DATA, &SEQRegData[0x0c] }, /*          */
//
//{ PMICMD_OUTW,  SEQ_INDEXPORT, SEQ_DATAPORT, 0x01, 0x0c, READWRITE_DATA, &SEQRegData[0x0c] }, /*          */
//{ PMICMD_OUTW,  SEQ_INDEXPORT, SEQ_DATAPORT, 0x01, 0x0d, READWRITE_DATA, &SEQRegData[0x0d] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x0c, 0x00, READWRITE_DATA, &SEQRegData[0x0c] },
//{ PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x0d, 0x00, WRITEONLY_DATA, &SEQRegData[0x0d] }, /*          */
  { PMICMD_RMWBI, SEQ_INDEXPORT, SEQ_DATAPORT, 0x0d, 0x00, READWRITE_DATA, &SEQRegData[0xff] }, /*          */
//
  { PMICMD_OUTW,  SEQ_INDEXPORT, NONE,         NONE, 0x00, WRITEONLY_DATA, &bEndSEQReset[0] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x19, 0x00, READWRITE_DATA, &CRTRegData[0x00] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x01, 0x1e, READWRITE_DATA, &CRTRegData[0x1e] },
  { PMICMD_BOUTB, ATC_INDEXPORT, ATC_DATAPORT, 0x15, 0x00, READWRITE_DATA, &ATCRegData[0x00] }, /*          */
  { PMICMD_BOUTB, GDC_INDEXPORT, GDC_DATAPORT, 0x09, 0x00, READWRITE_DATA, &GDCRegData[0x00] },
  { PMICMD_NONE }
};

CHIPINFO TridentChipSet2[] = {
  {
    VGAMODE,
    &ChipInfoHeader[GRAPHICS_640x480x16],
    &TridentSetBank,
    &TridentGetBank,
    TridentModeSet2,
    0,                                                         /*JWK10*/
  },
  {
    0x5D,
    &ChipInfoHeader[GRAPHICS_640x480x256],
    &TridentSetBank,
    &TridentGetBank,
    TridentModeSet2,
    0,                                                         /*JWK10*/
  },
  {
    0x5B,
    &ChipInfoHeader[GRAPHICS_800x600x16],
    &TridentSetBank,
    &TridentGetBank,
    TridentModeSet2,
    0,                                                         /*JWK10*/
  },
  {
    0x5E,
    &ChipInfoHeader[GRAPHICS_800x600x256],
    &TridentSetBank,
    &TridentGetBank,
    TridentModeSet2,
    0,                                                         /*JWK10*/
  },
  {
    0x5F,
    &ChipInfoHeader[GRAPHICS_1024x768x16],
    &TridentSetBank,
    &TridentGetBank,
    TridentModeSet2,
    0,                                                         /*JWK10*/
  },
  {
    0x62,
    &ChipInfoHeader[GRAPHICS_1024x768x256],
    &TridentSetBank,
    &TridentGetBank,
    TridentModeSet2,
    0,                                                         /*JWK10*/
  },
  {
    0x01,
    &ChipInfoHeader[TEXT_40x25],
    &TridentSetBank,
    &TridentGetBank,
    TridentModeSet2,
    0,                                                         /*JWK10*/
  },
  {
    0x03,
    &ChipInfoHeader[TEXT_80x25],
    &TridentSetBank,
    &TridentGetBank,
    TridentModeSet2,
    0,                                                         /*JWK10*/
  },
  {
    0x53,
    &ChipInfoHeader[TEXT_132x25],
    &TridentSetBank,
    &TridentGetBank,
    TridentModeSet2,
    0,                                                         /*JWK10*/
  },
  {
    0x55,
    &ChipInfoHeader[TEXT_132x43],
    &TridentSetBank,
    &TridentGetBank,
    TridentModeSet2,
    0,                                                         /*JWK10*/
  },
  {
    0x61,
    &ChipInfoHeader[GRAPHICS_768x1024x16],
    &TridentSetBank,
    &TridentGetBank,
    TridentModeSet2,
    0,                                                         /*JWK10*/
  },
};

USHORT usSizeTridentChipSet2 = sizeof(TridentChipSet2)/sizeof(CHIPINFO);

/*
** IBM
*/

REGDATA IBMModeSet1a [] =
{
  { PMICMD_OUTB,  MISCOUTPUTREG_WRITE, NONE,   0x00, 0x00, WRITEONLY_DATA, &MiscOutRegData }, /*          */
  { PMICMD_BOUTB, XGAOPMODE_WRITE,  XGAOPMODE_WRITE,  0x01, 0x00, WRITEONLY_DATA, "\x15" },
  { PMICMD_BOUTB, XGAVRAMWIN_WRITE, XGAVRAMWIN_WRITE, 0x01, 0x00, WRITEONLY_DATA, b_1 },
  { PMICMD_BOUTB, XGABANKSEL_WRITE, XGABANKSEL_WRITE, 0x01, 0x00, WRITEONLY_DATA, b_0 },
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x05, 0x00, READWRITE_DATA, &SEQRegData[0x00] },
  { PMICMD_OUTW,  SEQ_INDEXPORT, NONE, NONE, 0x00, WRITEONLY_DATA, &bEndSEQReset[0] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x19, 0x00, READWRITE_DATA, &CRTRegData[0x00] },
  { PMICMD_BOUTB, ATC_INDEXPORT, ATC_DATAPORT, 0x15, 0x00, READWRITE_DATA, &ATCRegData[0x00] }, /*          */
  { PMICMD_BOUTB, GDC_INDEXPORT, GDC_DATAPORT, 0x09, 0x00, READWRITE_DATA, &GDCRegData[0x00] },
  { PMICMD_NONE }
};

REGDATA IBMModeSet1b [] =
{
  { PMICMD_OUTB,  MISCOUTPUTREG_WRITE, NONE,   0x00, 0x00, WRITEONLY_DATA, &MiscOutRegData }, /*          */
  { PMICMD_BOUTB, XGAOPMODE_WRITE,  XGAOPMODE_WRITE,  0x01, 0x00, WRITEONLY_DATA, "\x11" },
  { PMICMD_BOUTB, XGAVRAMWIN_WRITE, XGAVRAMWIN_WRITE, 0x01, 0x00, WRITEONLY_DATA, b_1 },
  { PMICMD_BOUTB, XGABANKSEL_WRITE, XGABANKSEL_WRITE, 0x01, 0x00, WRITEONLY_DATA, b_0 },
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x05, 0x00, READWRITE_DATA, &SEQRegData[0x00] },
  { PMICMD_OUTW,  SEQ_INDEXPORT, NONE, NONE, 0x00, WRITEONLY_DATA, &bEndSEQReset[0] },
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x19, 0x00, READWRITE_DATA, &CRTRegData[0x00] },
  { PMICMD_BOUTB, ATC_INDEXPORT, ATC_DATAPORT, 0x15, 0x00, READWRITE_DATA, &ATCRegData[0x00] }, /*          */
  { PMICMD_BOUTB, GDC_INDEXPORT, GDC_DATAPORT, 0x09, 0x00, READWRITE_DATA, &GDCRegData[0x00] },
  { PMICMD_OUTB,  MISCOUTPUTREG_WRITE, NONE,   0x00, 0x00, WRITEONLY_DATA, &MiscOutRegData }, /*          */
  { PMICMD_NONE }
};

CHIPINFO IBMChipSet1[] =
{
  {
    VESA_640_480_256,
    &ChipInfoHeader[GRAPHICS_640x480x256],
    &IBMSetBank,
    &IBMGetBank,
    IBMModeSet1a,
    0,                                                         /*JWK10*/
  },
  {
    VESA_800_600_16,
    &ChipInfoHeader[GRAPHICS_800x600x16],
    &IBMSetBank,
    &IBMGetBank,
    IBMModeSet1a,
    0,                                                         /*JWK10*/
  },
  {
    VESA_800_600_256,
    &ChipInfoHeader[GRAPHICS_800x600x256],
    &IBMSetBank,
    &IBMGetBank,
    IBMModeSet1a,
    0,                                                         /*JWK10*/
  },
  {
    VESA_1024_768_16,
    &ChipInfoHeader[GRAPHICS_1024x768x16],
    &IBMSetBank,
    &IBMGetBank,
    IBMModeSet1a,
    0,                                                         /*JWK10*/
  },
  {
    VESA_1024_768_256,
    &ChipInfoHeader[GRAPHICS_1024x768x256],
    &IBMSetBank,
    &IBMGetBank,
    IBMModeSet1a,
    0,                                                         /*JWK10*/
  },
  {
    VESA_TEXT_132_25,
    &ChipInfoHeader[TEXT_132x25],
    &IBMSetBank,
    &IBMGetBank,
    IBMModeSet1b,
    0,                                                         /*JWK10*/
  },
  {
//    VESA_TEXT_132_25,                         
//    &ChipInfoHeader[TEXT_132x25],             
    VESA_TEXT_132_43,               //          
    &ChipInfoHeader[TEXT_132x43],   //          
    &IBMSetBank,
    &IBMGetBank,
    IBMModeSet1b,
    0,                                                         /*JWK10*/
  },
};

USHORT usSizeIBMChipSet1 = sizeof(IBMChipSet1)/sizeof(CHIPINFO);

/*
** Weitek P9000
*/

REGDATA WeitekModeSet1a [] =
{
  { PMICMD_OUTB,  MISCOUTPUTREG_WRITE, NONE,   0x00, 0x00, WRITEONLY_DATA, &MiscOutRegData }, /*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x06, 0x00, READWRITE_DATA, &SEQRegData[0x00] },
  { PMICMD_OUTW,  SEQ_INDEXPORT, NONE,         NONE, 0x00, WRITEONLY_DATA, &bEndSEQReset[0] },
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x01, 0x12, READWRITE_DATA, &SEQRegData[0x12] }, /*          */
  { PMICMD_BOUTB, CRT_INDEXPORT, CRT_DATAPORT, 0x1E, 0x00, READWRITE_DATA, &CRTRegData[0x00] },
  { PMICMD_BOUTB, ATC_INDEXPORT, ATC_DATAPORT, 0x15, 0x00, READWRITE_DATA, &ATCRegData[0x00] }, /*          */
  { PMICMD_BOUTB, GDC_INDEXPORT, GDC_DATAPORT, 0x10, 0x00, READWRITE_DATA, &GDCRegData[0x00] },
  { PMICMD_NONE }
};

REGDATA WeitekModeSet1b [] =                                    /*          */
{
  { PMICMD_OUTB,  MISCOUTPUTREG_WRITE, NONE,   0x00, 0x00, WRITEONLY_DATA, &MiscOutRegData }, /*          */
  { PMICMD_BOUTB, SEQ_INDEXPORT, SEQ_DATAPORT, 0x01, 0x12, READWRITE_DATA, &SEQRegData[0x12] },
  { PMICMD_WRITEDW,WEITEK_MMIO_INDEX_INTERRUPT_EN,0,0x0080,0x0000,MMIO_SRC_IMMEDIATE|MMIO_DST_VARIABLE,NULL},
  { PMICMD_WRITEDW,WEITEK_MMIO_INDEX_PREHRZC     ,0,0x0000,0x0000,MMIO_SRC_IMMEDIATE|MMIO_DST_VARIABLE,NULL},
  { PMICMD_WRITEDW,WEITEK_MMIO_INDEX_PREVRTC     ,0,0x0000,0x0000,MMIO_SRC_IMMEDIATE|MMIO_DST_VARIABLE,NULL},
  { PMICMD_WRITEDW,WEITEK_MMIO_INDEX_MEMCONFIG   ,0,0x0002,0x0000,MMIO_SRC_IMMEDIATE|MMIO_DST_VARIABLE,NULL},
  { PMICMD_WRITEDW,WEITEK_MMIO_INDEX_RFPERIOD    ,0,0x0186,0x0000,MMIO_SRC_IMMEDIATE|MMIO_DST_VARIABLE,NULL},
  { PMICMD_WRITEDW,WEITEK_MMIO_INDEX_RLMAX       ,0,0x00fa,0x0000,MMIO_SRC_IMMEDIATE|MMIO_DST_VARIABLE,NULL},
  { PMICMD_WRITEDW,WEITEK_MMIO_INDEX_PMASK       ,0,0x00ff,0x0000,MMIO_SRC_IMMEDIATE|MMIO_DST_VARIABLE,NULL},
  { PMICMD_WRITEDW,WEITEK_MMIO_INDEX_DRAW_MODE   ,0,0x000a,0x0000,MMIO_SRC_IMMEDIATE|MMIO_DST_VARIABLE,NULL},
  { PMICMD_WRITEDW,WEITEK_MMIO_INDEX_W_OFF       ,0,0x0000,0x0000,MMIO_SRC_IMMEDIATE|MMIO_DST_VARIABLE,NULL},
  { PMICMD_WRITEDW,WEITEK_MMIO_INDEX_PAT_ORX     ,0,0x0000,0x0000,MMIO_SRC_IMMEDIATE|MMIO_DST_VARIABLE,NULL},
  { PMICMD_WRITEDW,WEITEK_MMIO_INDEX_PAT_ORY     ,0,0x0000,0x0000,MMIO_SRC_IMMEDIATE|MMIO_DST_VARIABLE,NULL},
  { PMICMD_WRITEDW,WEITEK_MMIO_INDEX_SYSCONFIG   ,0,0x0000,0x0000,MMIO_SRC_IMMEDIATE|MMIO_DST_VARIABLE|MMIO_RUNTIME_DATA,(PBYTE)&Viper.SysConfig},
  { PMICMD_WRITEDW,WEITEK_MMIO_INDEX_W_MIN       ,0,0x0000,0x0000,MMIO_SRC_IMMEDIATE|MMIO_DST_VARIABLE,NULL},
  { PMICMD_WRITEDW,WEITEK_MMIO_INDEX_W_MAX       ,0,0x0000,0x0000,MMIO_SRC_IMMEDIATE|MMIO_DST_VARIABLE|MMIO_RUNTIME_DATA,(PBYTE)&Viper.Clip},
  { PMICMD_CALL, CALL_MONITOR_TIMINGS            ,0,0x0000,0x0000,0x0000,NULL},
  { PMICMD_WRITEDW,WEITEK_MMIO_INDEX_HRZT        ,0,31,0x0000,MMIO_SRC_REGISTER|MMIO_DST_VARIABLE,NULL},
  { PMICMD_WRITEDW,WEITEK_MMIO_INDEX_HRZSR       ,0,32,0x0000,MMIO_SRC_REGISTER|MMIO_DST_VARIABLE,NULL},
  { PMICMD_WRITEDW,WEITEK_MMIO_INDEX_VRTT        ,0,33,0x0000,MMIO_SRC_REGISTER|MMIO_DST_VARIABLE,NULL},
  { PMICMD_WRITEDW,WEITEK_MMIO_INDEX_VRTSR       ,0,34,0x0000,MMIO_SRC_REGISTER|MMIO_DST_VARIABLE,NULL},
  { PMICMD_WRITEDW,WEITEK_MMIO_INDEX_HRZBR       ,0,35,0x0000,MMIO_SRC_REGISTER|MMIO_DST_VARIABLE,NULL},
  { PMICMD_WRITEDW,WEITEK_MMIO_INDEX_HRZBF       ,0,36,0x0000,MMIO_SRC_REGISTER|MMIO_DST_VARIABLE,NULL},
  { PMICMD_WRITEDW,WEITEK_MMIO_INDEX_VRTBR       ,0,37,0x0000,MMIO_SRC_REGISTER|MMIO_DST_VARIABLE,NULL},
  { PMICMD_WRITEDW,WEITEK_MMIO_INDEX_VRTBF       ,0,38,0x0000,MMIO_SRC_REGISTER|MMIO_DST_VARIABLE,NULL},
  { PMICMD_WRITEDW,WEITEK_MMIO_INDEX_SRTCTL      ,0,0x01e5,0x0000,MMIO_SRC_IMMEDIATE|MMIO_DST_VARIABLE,NULL},
  { PMICMD_NONE }
};

CHIPINFO WeitekChipSet1[] =
{
  {
    VGAMODE,
    &ChipInfoHeader[GRAPHICS_640x480x16],
    NULL,
    NULL,
    WeitekModeSet1a,
    0,                                                         /*JWK10*/
  },
  {
    VESA_640_480_256,
    &ChipInfoHeader[GRAPHICS_640x480x256],
    NULL,
    NULL,
    WeitekModeSet1b,
    0,                                                         /*JWK10*/
  },
  {
    VESA_640_480_64K,
    &ChipInfoHeader[GRAPHICS_640x480x64K],
    NULL,
    NULL,
    WeitekModeSet1b,
    0,                                                         /*JWK10*/
  },
  {
    VESA_800_600_16,
    &ChipInfoHeader[GRAPHICS_800x600x16],
    NULL,
    NULL,
    WeitekModeSet1b,
    0,                                                         /*JWK10*/
  },
  {
    VESA_800_600_256,
    &ChipInfoHeader[GRAPHICS_800x600x256],
    NULL,
    NULL,
    WeitekModeSet1b,
    0,                                                         /*JWK10*/
  },
  {
    VESA_800_600_64K,
    &ChipInfoHeader[GRAPHICS_800x600x64K],
    NULL,
    NULL,
    WeitekModeSet1b,
    0,                                                         /*JWK10*/
  },
  {
    VESA_1024_768_16,
    &ChipInfoHeader[GRAPHICS_1024x768x16],
    NULL,
    NULL,
    WeitekModeSet1b,
    0,                                                         /*JWK10*/
  },
  {
    VESA_1024_768_256,
    &ChipInfoHeader[GRAPHICS_1024x768x256],
    NULL,
    NULL,
    WeitekModeSet1b,
    0,                                                         /*JWK10*/
  },
  {
    VESA_1024_768_64K,
    &ChipInfoHeader[GRAPHICS_1024x768x64K],
    NULL,
    NULL,
    WeitekModeSet1b,
    0,                                                         /*JWK10*/
  },
  {
    VESA_1280_1024_256,
    &ChipInfoHeader[GRAPHICS_1280x1024x256],
    NULL,
    NULL,
    WeitekModeSet1b,
    0,                                                         /*JWK10*/
  },
  {
    0x01,
    &ChipInfoHeader[TEXT_40x25],
    NULL,
    NULL,
    WeitekModeSet1a,
    0,                                                         /*JWK10*/
  },
  {
    0x03,
    &ChipInfoHeader[TEXT_80x25],
    NULL,
    NULL,
    WeitekModeSet1a,
    0,                                                         /*JWK10*/
  },
  {
    0x55,
    &ChipInfoHeader[TEXT_132x25],
    NULL,
    NULL,
    WeitekModeSet1a,
    0,                                                         /*JWK10*/
  },
  {
    0x54,
    &ChipInfoHeader[TEXT_132x43],
    NULL,
    NULL,
    WeitekModeSet1a,
    0,                                                         /*JWK10*/
  },
};

USHORT usSizeWeitekChipSet1 = sizeof(WeitekChipSet1)/sizeof(CHIPINFO);

/*
** Refresh tables, per chip/adapter/clock_implementation. End table with 0.
** End refresh list with NO_REFRESH. Default refresh can be changed at run-tim
** if a monitor is detected while running the svga on. Default refresh values are
** recorded into the VIDEO.CFG file which contains the default monitor name and
** default mode settings. Note that we can use name "OTHER" and still set default
** refresh settings if no monitor detection exists. Thus, if user never configures
** the monitor, some monitor settings exist. If a particular monitor is detected
** (via DDC) default refresh values are changed to that of the DDC packet.
** If monitor detection is customized (such as Speedstar), monitor capabilities
** or the possible monitor are built into the svga.exe. Note that monitor.dif contains
** a lot of monitors, but is not of much use here since we have limited monitor
** detection capabilites and therefore can not map easily into that file.
*/
REFRESHMODE Default_Refresh_Table[] =
{
  {640,480,60,{NO_REFRESH}},
  {800,600,56,{NO_REFRESH}},
  {1024,768,43,{NO_REFRESH}},
  {0}
};


/* JWK26 for restoring refresh rates to what they were on entry.
**       Every adapter, if setting refresh rates, should determine
**       the entry refresh rates, store these values in the default field,
**       and restore them on exit.
*/

REFRESHMODE Entry_Refresh_Table[] =
{
  {640,480,NO_REFRESH,{NO_REFRESH}},
  {800,600,NO_REFRESH,{NO_REFRESH}},
  {1024,768,NO_REFRESH,{NO_REFRESH}},
  {1280,1024,NO_REFRESH,{NO_REFRESH}},
  {1152,864,NO_REFRESH,{NO_REFRESH}},
  {1600,1200,NO_REFRESH,{NO_REFRESH}},
  {0}
};




REFRESHMODE STB_Refresh_Table[] =
{
  {640,480,60,{76,60,NO_REFRESH}},
  {800,600,60,{76,72,70,60,NO_REFRESH}},
  {1024,768,43,{74,70,64,43,NO_REFRESH}},
  {1280,1024,60,{60,NO_REFRESH}},
  {0}
};

REFRESHMODE S3_N9_Refresh_Table[] =
{
  {640,480,60,{76,72,70,60,NO_REFRESH}},
  {800,600,56,{76,72,70,56,NO_REFRESH}},
  {1024,768,60,{76,72,70,60,NO_REFRESH}},
  {1280,1024,60,{76,72,70,60,NO_REFRESH}},
  {0}
};
REFRESHMODE S3_N9x64_Refresh_Table[] =                         /*@V3.0YEE03*/
{
  {640,480,60,{75,72,60,NO_REFRESH}},
  {800,600,56,{75,72,60,56,NO_REFRESH}},
  {1024,768,60,{75,70,60,43,NO_REFRESH}},                      /*          */
  {1280,1024,60,{75,72,60,45,NO_REFRESH}},                     /*          */
  {1600,1200,60,{60,NO_REFRESH}},
  {0}
};
REFRESHMODE S3_ICD2061_Refresh_Table[] =                       /*@V3.0YEE03*/
{
  {640,480,60,{90,75,60,NO_REFRESH}},
  {800,600,56,{95,75,60,56,NO_REFRESH}},
  {1024,768,43,{75,60,43,NO_REFRESH}},
  {1280,1024,44,{75,72,60,44,NO_REFRESH}},
  {1600,1200,60,{72,60,NO_REFRESH}},
  {0}
};
REFRESHMODE S3_964DIAMOND_Refresh_Table[] =                    /*@V3.0YEE04*/
{
  {640,480,60,{100,90,75,72,60,NO_REFRESH}},
  {800,600,56,{100,90,75,72,60,56,NO_REFRESH}},
  {1024,768,60,{100,80,75,72,60,NO_REFRESH}},
  {1280,1024,60,{75,72,60,NO_REFRESH}},
  {1600,1200,60,{60,NO_REFRESH}},
  {0}
};
REFRESHMODE S3_964ORCHID_Refresh_Table[] =                     /*@V3.0YEE06*/
{
  {640,480,60,{120,110,90,75,72,60,NO_REFRESH}},
  {800,600,56,{90,75,72,60,56,NO_REFRESH}},
  {1024,768,43,{85,75,70,60,43,NO_REFRESH}},
  {1280,1024,45,{60,45,NO_REFRESH}},
  {0}
};
REFRESHMODE S3_SDAC_Refresh_Table[] =                          /*          */
{
  {640,480,60,{85,75,72,60,NO_REFRESH}},
  {800,600,56,{85,75,72,60,56,NO_REFRESH}},
  {1024,768,43,{75,72,70,60,43,NO_REFRESH}},
  {1280,1024,45,{75,72,60,45,NO_REFRESH}},
  {1600,1200,49,{49,NO_REFRESH}},
  {0}
};
/*
** There is no generic default refresh setting for S3,
** since there is no standard way of recording the monitor
** selection. We will signify this by creating a video.cfg
** file which has 0xff values for the vertical refresh.
** Thus, until the user configures the monitor in the system
** icon's screen page, ibmgpmi will not do anything.
** For adapters which have external clocks (they can not be
** treated as generic) ibmgpmi picks a default.           
*/
REFRESHMODE S3_928GenRefresh_Table[] =          /*            */
{
  {640,480,0xff,{72,60,NO_REFRESH}},
  {800,600,0xff,{72,60,56,NO_REFRESH}},
  {1024,768,0xff,{72,70,60,43,NO_REFRESH}},
  {1280,1024,0xff,{60,46,NO_REFRESH}},
  {0}
};
REFRESHMODE S3_805GenRefresh_Table[] =          /*            */
{
  {640,480,0xff,{72,60,NO_REFRESH}},
  {800,600,0xff,{72,60,56,NO_REFRESH}},
  {1024,768,0xff,{72,70,60,43,NO_REFRESH}},
  {1280,1024,0xff,{46,NO_REFRESH}},             /*            */
  {0}
};
REFRESHMODE Diamond_24_Refresh_Table[] =
{
  {640,480,60,{72,60,NO_REFRESH}},
  {800,600,56,{72,60,56,NO_REFRESH}},
  {1024,768,43,{72,70,60,43,NO_REFRESH}},
  {0}
};
REFRESHMODE Diamond_Viper_Refresh_Table[] =
{
  {640,480,60,{72,60,NO_REFRESH}},
  {800,600,56,{72,56,NO_REFRESH}},
  {1024,768,60,{76,72,70,60,NO_REFRESH}},
  {1280,1024,60,{74,60,NO_REFRESH}},
  {0}
};


REFRESHMODE Tseng_Refresh_TableET4000[] =      /*JWK10*/
{
  {640,480,72,{72,60,NO_REFRESH}},
  {800,600,72,{72,60,56,NO_REFRESH}},
  {1024,768,43,{70,60,43,NO_REFRESH}},
  {0}
};

REFRESHMODE Tseng_Refresh_TableW32[] =          /*JWK10*/
{
  {640,480,72,{72,60,NO_REFRESH}},
  {800,600,72,{72,60,56,NO_REFRESH}},
  {1024,768,43,{75,70,60,43,NO_REFRESH}},
  {1280,1024,43,{43,NO_REFRESH}},
  {0}
};

REFRESHMODE Tseng_Refresh_TableW32x[] =         /*JWK10*/
{
  {640,480,72,{90,75,72,60,NO_REFRESH}},
  {800,600,72,{90,75,72,60,56,NO_REFRESH}},
  {1024,768,43,{75,70,60,43,NO_REFRESH}},
  {1280,1024,43,{75,70,60,43,NO_REFRESH}},
  {0}
};

REFRESHMODE Cirrus543x_Refresh_Table[] =                       /*          */
{
  {640,480,60,{75,72,60,NO_REFRESH}},
  {800,600,56,{75,72,60,56,NO_REFRESH}},
  {1024,768,60,{75,72,70,60,43,NO_REFRESH}},
  {1280,1024,60,{75,72,60,43,NO_REFRESH}},
  {0}
};
REFRESHMODE S3_Lacuna_Refresh_Table[] =                        /*          */
{
  {640,480,60,{75,72,60,NO_REFRESH}},
  {800,600,60,{75,72,60,NO_REFRESH}},
  {1024,768,44,{80,75,72,70,60,44,NO_REFRESH}},
  {1280,1024,53,{60,53,NO_REFRESH}},
  {0}
};

REFRESHTABLE S3SDACRefresh[ ]=            /* @V3.0YEE02 */
{
  /*         |<-----CR5B------>|<----CR52------->|
  **   Bits: |7 6 5| 4 3 2| 1 0 7| 6 5 4| 3 2 1 0|
  **         |x x x| x x x| x x x| x x x| x x x x|
  **                                    
  **                                    
  **                                      unused
  **                               640x480 resolutions
  **                         800x600 resolutions
  **                   1024x768 resolutions
  **             1280x1024 and 1600x1200 resolutions
   XRES VF CR5B CR52    */
  {640, 85, 0x00, 0x40},
  {640, 75, 0x00, 0x20},
  {640, 72, 0x00, 0x10},
  {640, 60, 0x00, 0x00},
  {640, -1, 0x00, 0x00},
  {800, 85, 0x02, 0x00},
  {800, 75, 0x01, 0x80},
  {800, 72, 0x01, 0x00},
  {800, 60, 0x00, 0x80},
  {800, 56, 0x00, 0x00},
  {800, -1, 0x00, 0x00},
  {1024, 75, 0x14, 0x00},
  {1024, 72, 0x10, 0x00},
  {1024, 70, 0x0c, 0x00},
  {1024, 60, 0x08, 0x00},
  {1024, 43, 0x00, 0x00},
  {1024, -1, 0x00, 0x00},
  {1280, 75, 0xe0, 0x00},
  {1280, 72, 0xc0, 0x00},
  {1280, 60, 0xa0, 0x00},
  {1280, 45, 0x00, 0x00},
  {1280, -1, 0x00, 0x00},
  {1600, 49, 0x00, 0x00},
  {1600, -1, 0x00, 0x00},
  {0}
};
REFRESHTABLE S3N9x64Refresh[ ]=             /* @V3.0YEE03 */
{
  /*         |<-----CR5B------>|<----CR52------->|
  **   Bits: |7 6 5| 4 3 2| 1 0 7| 6 5 4| 3 2 1 0|
  **         |x x x| x x x| x x|x| x x x| x x x x|
  **                        |           
  **                                    
  **                                      unused
  **                               640x480 resolutions
  **                         800x600 resolutions
  **                   1024x768 resolutions
  **             1280x1024 and 1600x1200 resolutions
   XRES VF CR5B CR52    */
  {640, 75, 0x00, 0x20},
  {640, 72, 0x00, 0x10},
  {640, 60, 0x00, 0x00},
  {640, -1, 0x00, 0x00},
  {800, 75, 0x01, 0x80},
  {800, 72, 0x01, 0x00},
  {800, 60, 0x00, 0x80},
  {800, 56, 0x00, 0x00},
  {800, -1, 0x00, 0x00},
  {1024, 75, 0x10, 0x00},
  {1024, 70, 0x0c, 0x00},
  {1024, 60, 0x08, 0x00},
  {1024, 43, 0x00, 0x00},
  {1024, -1, 0x00, 0x00},
  {1280, 75, 0xc0, 0x00},
  {1280, 72, 0xa0, 0x00},
  {1280, 60, 0x80, 0x00},
  {1280, 45, 0x40, 0x00},
  {1280, -1, 0x00, 0x00},
  {1600, 49, 0x00, 0x00},
  {1600, -1, 0x00, 0x00},
  {0}
};
REFRESHTABLE S3DELLRefresh[ ]=              /* @V3.0YEE08 */
{
  /*         |<-----CR5B------>|<----CR52------->|
  **   Bits: |7 6 5| 4 3 2| 1 0 7| 6 5 4| 3 2 1 0|
  **         |x x x| x x x| x x|x| x x x| x x x x|
  **                        |           
  **                                    
  **                                      unused
  **                               640x480 resolutions
  **                         800x600 resolutions
  **                   1024x768 resolutions
  **             1280x1024 and 1600x1200 resolutions
   XRES VF CR5B CR52    */
  {640, 75, 0x00, 0x20},
  {640, 72, 0x00, 0x10},
  {640, 60, 0x00, 0x00},
  {640, -1, 0x00, 0x00},
  {800, 75, 0x01, 0x80},
  {800, 72, 0x01, 0x00},
  {800, 60, 0x00, 0x80},
  {800, 56, 0x00, 0x00},
  {800, -1, 0x00, 0x00},
  {1024, 75, 0x0c, 0x00},
  {1024, 70, 0x08, 0x00},
  {1024, 60, 0x04, 0x00},
  {1024, 43, 0x00, 0x00},
  {1024, -1, 0x00, 0x00},
  {1280, 75, 0x60, 0x00},
  {1280, 72, 0x40, 0x00},
  {1280, 60, 0x20, 0x00},
  {1280, 45, 0x00, 0x00},
  {1280, -1, 0x00, 0x00},
  {1600, 49, 0x00, 0x00},
  {1600, -1, 0x00, 0x00},
  {0}
};
REFRESHTABLE S3ICD2061Refresh[ ]=            /* @V3.0YEE03 */
{
  /*   original S3 BIOS uses CR52 only.  Actix kept this and did not
  **   change to the new style.
  **   Assumes that miromagic also stayed with this original approach
  **   since #9 refresh did not help, and was exhibiting same font
  **   problem as actix when trying to set an NI refresh rate based
  **   on an interlace PMI file.
   XRES VF CR5B CR52    */
  {640, 90, 0x00, 0x02},
  {640, 75, 0x00, 0x01},
  {640, 60, 0x00, 0x00},
  {640, -1, 0x00, 0x00},
  {800, 95, 0x00, 0x03},
  {800, 75, 0x00, 0x02},
  {800, 60, 0x00, 0x01},
  {800, 56, 0x00, 0x00},
  {800, -1, 0x00, 0x00},
  {1024, 75, 0x00, 0x04},
  {1024, 60, 0x00, 0x02},
  {1024, 43, 0x00, 0x00},
  {1024, -1, 0x00, 0x00},
  {1280, 75, 0x00, 0x06},
  {1280, 72, 0x00, 0x05},
  {1280, 60, 0x00, 0x04},
  {1280, 44, 0x00, 0x00},
  {1280, -1, 0x00, 0x00},
  {1600, 72, 0x00, 0x06},
  {1600, 60, 0x00, 0x05},
  {1600, 49, 0x00, 0x00},
  {1600, -1, 0x00, 0x00},
  {0}
};
REFRESHTABLE S3964DIAMONDRefresh[ ]=            /* @V3.0YEE04 */
{
  /*   Diamond only uses CR5B to indicate refresh rate
   XRES VF CR5B CR52    */
  {640,100, 0x0d, 0x00},
  {640, 90, 0x04, 0x00},
  {640, 75, 0x02, 0x00},
  {640, 72, 0x00, 0x00},
  {640, 60, 0x08, 0x00},
  {640, -1, 0x00, 0x00},
  {800,100, 0x0d, 0x00},
  {800, 90, 0x04, 0x00},
  {800, 75, 0x02, 0x00},
  {800, 72, 0x07, 0x00},
  {800, 60, 0x00, 0x00},
  {800, 56, 0x08, 0x00},
  {800, -1, 0x00, 0x00},
  {1024,100, 0x0e, 0x00},
  {1024, 80, 0x0d, 0x00},
  {1024, 75, 0x02, 0x00},
  {1024, 72, 0x0b, 0x00},
  {1024, 60, 0x09, 0x00},
  {1024, 43, 0x00, 0x00},
  {1024, -1, 0x00, 0x00},
  {1280, 75, 0x02, 0x00},
  {1280, 72, 0x04, 0x00},
  {1280, 60, 0x07, 0x00},
  {1280, 43, 0x00, 0x00},
  {1280, -1, 0x00, 0x00},
  {1600, 60, 0x00, 0x00},
  {1600, -1, 0x00, 0x00},
  {0}
};
REFRESHTABLE S3964ORCHIDRefresh[ ]=             /* @V3.0YEE05 */
{
  /*         |<-----CR5B------>|<----CR52------->|
  **   Bits: |7 6|5 4| 3 2 1| 0 7 6| 5 4 3| 2 1 0|
  **         |x x|x x| x x x| x x x| x x x| x x x|
  **                                     
  **                                     
  **                                      640x480 resolution
  **                               800x600 resolution
  **                          1024x768 resolution
  **                    1280x1024 resolution
  **               1152x864 resolution
  **            1600x1200 resolution
   XRES VF CR5B CR52    */
  {640,120, 0x00, 0x05},
  {640,110, 0x00, 0x04},
  {640, 90, 0x00, 0x03},
  {640, 75, 0x00, 0x02},
  {640, 72, 0x00, 0x01},
  {640, 60, 0x00, 0x00},
  {640, -1, 0x00, 0x00},
  {800, 90, 0x00, 0x20},
  {800, 75, 0x00, 0x18},
  {800, 72, 0x00, 0x10},
  {800, 60, 0x00, 0x08},
  {800, 56, 0x00, 0x00},
  {800, -1, 0x00, 0x00},
  {1024, 85, 0x01, 0x00},
  {1024, 75, 0x00, 0xC0},
  {1024, 70, 0x00, 0x80},
  {1024, 60, 0x00, 0x40},
  {1024, 43, 0x00, 0x00},
  {1024, -1, 0x00, 0x00},
  {1280, 60, 0x02, 0x00},
  {1280, 45, 0x00, 0x00},
  {1280, -1, 0x00, 0x00},
  {0}
};
