/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*****************************************************************************
 *
 * SOURCE FILE NAME = SVGATYPE.H
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * NOTES
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#include <svgadefs.h>           /*            */

/*
** Constants
*/

#define SVGA_DATAFNAME          "c:\\os2\\svgadata.pmi"  /* mode data file              */

//c-begin
#define SVGA_PARTSAVESIZE       (1024L*8L)      /* partial buffer size (BY) */
//c-end

#define PVB_FONT_SIZE           (256*32)      /* space reqd for font in PVB */
#define PVB_FONT_ADDRESS        ((PBYTE)0xA0000L) /* font resides here      */
#define PVB_TEXT_SIZE           (0x4000)          /* max text buffer size            */
#define PVB_TEXT_ADDRESS        ((PBYTE)0xB8000L) /* text resides here                */

#define SAVE                    0
#define RESTORE                 1

#define SAVEREST_HARDWARE       0x02
#define SAVEREST_FULLPVB        0x04
#define SAVEREST_PARTPVB        0x08
#define SAVEREST_VDM            0x10
#define VALID_SAVEREST_FLAG     ( SAVEREST_HARDWARE | SAVEREST_FULLPVB |\
                                  SAVEREST_PARTPVB  | SAVEREST_VDM )

#define MIN_PVB_BOTTOM          0xA0000L
#define MAX_PVB_TOP             0xBFFFFL

/*
**      Environment Flags
*/

#define ENVFLAG_DEFAULT         0x0000
#define ENVFLAG_SVGAMODE        0x0001

#define ENVFLAG_HARDWARE        0x0001
#define ENVFLAG_NO_VALIDATION   0x0004       /* Tell chained BVH to blindly */
                                             /* accept this data.           */

/*
**      Parms to AccessRegister
*/

#define SET                     0
#define GET                     1
#define SETWORD                 2


#define ATI                                 /* include ATI register support */
#define ATIADDRESSPORT          0x01CE
#define ATIDATAPORT             0x01CF

#define ATTADDRESSPORT          0x03C0
#define ATTDATAWRITEPORT        0x03C0
#define ATTDATAREADPORT         0x03C1

#define CRTADDRESSPORT          0x03B4
#define CRTDATAPORT             0x03B5

#define SEQADDRESSPORT          0x03C4
#define SEQDATAPORT             0x03C5

#define GRAPHADDRESSPORT        0x03CE
#define GRAPHDATAPORT           0x03CF

#define MISCOUTPUTREGREAD       0x03CC
#define MISCOUTPUTREGWRITE      0x03C2
#define FEATURECONTROLREAD      0x03CA
#define FEATURECONTROLWRITE     0x03BA
#define VIDEOENABLEREG          0x03C3
#define DACADDRPORTWRITE        0x03C8
#define DACADDRPORTREAD         0x03C7
#define CRTCOLORADDRPORT        0x03D4
#define CRTCTLPORT1             0x03B8

#define COLORADJUSTMENT         0x20

#define VERTSYNCEND_REG         0x11          /* vert retrace end reg index */

#define GET                     1
#define SET                     0

#define WRITEFUNCTION           4

#define NO_SIZE                 0L
#define NO_ATTRIBUTES           0
#define RESERVED_LONG           0L

#define RETURN_ERROR            (USHORT)0x2000  /* OpenMode bit mask        */
#define READ_WRITE              (USHORT)0x0002
#define DENY_NONE               (USHORT)0x0040
#define NO_INHERIT              (USHORT)0x0080
#define OPEN_IF_EXISTS          0x0001          /* OpenFlag bit mask */

#define MAX_MODE_CMDS           30              /* Max # CMDs to set a mode */

#ifdef ATI
#define MAX_ATI_INDEX           10
#define MAX_ATI_DATA            32
#endif

/*
** Minimum structure lengths for VDH functions
*/

#define MINSLEN_SAVERESTOREENV   4
#define MINSLEN_CURSOR_POS       8
#define MINSLEN_CURSOR_TYPE     16
#define MINSLEN_VAR_BLINK        6
#define MINSLEN_VAR_OVERSCAN     8
#define MINSLEN_VAR_UNDERSCORE  10
#define MINSLEN_VAR_VIDEOENABLE 12
#define MINSLEN_VAR_DISPLAYMASK 16
#define MINSLEN_VAR_CODEPAGE    18
#define MINSLEN_VAR_SCROLLRECT  26
#define MINSLEN_VAR_SCREENDIM   30


#define COLOURCLUT16_LENGTH     64
#define COLOURCLUT256_LENGTH    256
#define MONOCLUT16_LENGTH       64
#define MONOCLUT256_LENGTH      256


#define WORDS                   1
#define BYTES                   0

#define NONE                    0x00
#define VGA_ENV_REG             0x0F    /* Environment Status Reg Index     */
#define VGA_LOCK                0x00    /* Value to lock VGA extended regs  */
#define VGA_UNLOCK              0x05    /* Value to unlock VGA extended reg */


#define MODE_FLAG_NOT_MONO      0x0001  /* xxxxxxxb b = 0 Mono-compatible,  */
                                        /* b = 1 Other                      */
#define MODE_FLAG_GRAPHICS      0x0002  /* xxxxxxbx b = 0 Text mode,        */
                                        /* b = 1 Graphics                   */
#define MODE_FLAG_NO_CLR_BRST   0x0004  /* xxxxxbxx b = 1 Color burst       */
                                        /* disabled                         */
#define MODE_FLAG_NATIVE        0x0008  /* xxxxbxxx b = 1 Native ( advanced */
                                        /* function ) mode                  */
#define IGNORE_CLR_BRST         0x0001  /* Disable color burst doesn't make */
                                        /* sense for this mode              */
#define NOT_PLASMA              0x0008  /* This mode does not work on VGA   */
                                        /* with PDP monitor                 */


#define TERMINATE_CMD           0
#define ATTRIBUTES_CMD          1
#define SEQUENCERS_CMD          2
#define CRTCTLREGS_CMD          3
#define GRAPHICS_CMD            4
#define REGOUTPUT_CMD           5
#define REGINPUT_CMD            6
#define ATIREGS_CMD             7


#define BU_READCELLSTR          2
#define BU_WRITECELLSTR         7
#define BU_PVB_SEL_BIT          0x0001
#define BU_LVB_SEL_BIT          0x0002
#define BU_MAX_INDEX            12
#define BU_PARM_LENGTH          26

#define BLINK_BIT               0x08


#define LCD_GRAYSCALE_ADDR      0x09    /* Gray scale address reg           */
#define LCD_GRAYSCALE_DATA      0x0A    /* Gray scale data reg              */

#define ALL_CHIPSETS            0


#define CHIP_FLAG_NONINTERLACED 0x0001


#define ATTRIB_WORLDFORMAT      0x70
#define ATTRIB_DEFAULTFORMAT    0x00
#define ATTRIB_WORLDCOUNT       0x03
#define ATTRIB_DEFAULTCOUNT     0x03


/* Interpreter changes            */

/*
** Additions to implement true PMI-file interpreter. File is parsed
** and a list of structures created containing the sequence of commands
** for any given section.
**
** Note: The linked list and all the data pointers must be contained
**       in the same data segment, all pointers are NEAR.
*/

/*
** Do not disturb the order as ExecTable in svgaiopl.asm depends on it.            
*/
#define PMICMD_NONE    0
#define PMICMD_INB     1
#define PMICMD_OUTB    2
#define PMICMD_INW     3
#define PMICMD_OUTW    4
#define PMICMD_BINB    5
#define PMICMD_BOUTB   6
#define PMICMD_RMWB    7
#define PMICMD_RMWE    8                                        /*          */
#define PMICMD_RMWW    9                                        /*          */
#define PMICMD_REGOP  10                                        /*          */
#define PMICMD_WAIT   11                                        /*          */
#define PMICMD_MAX    PMICMD_WAIT     /* equals last entry for range checks */

#define PMIFLAG_NONE       0x0000               /* Note: these are bits fields        */
#define PMIFLAG_NOOP       0x0001               /* turn this command into a no-op     */
#define PMIFLAG_ATC        0x0002               /* port is ATC, needs special case    */
#define PMIFLAG_REGISTER   0x0004               /* OUT data is register not immediate */
#define PMIFLAG_UPDATELIST 0x0008               /* must update list-data after command*/

#define PMI_REGOP_ASSIGN        0               /* Rxxx  = <value> */
#define PMI_REGOP_AND           1               /* Rxxx &= <value> */
#define PMI_REGOP_OR            2               /* Rxxx |= <value> */
#define PMI_REGOP_XOR           3               /* Rxxx ^= <value> */
#define PMI_REGOP_SHL           4               /* Rxxx <= <value> */
#define PMI_REGOP_SHR           5               /* Rxxx >= <value> */
#define PMI_REGOP_MAX           5               /* must equal last */

#define PMI_WAIT_CLEAR          0               /* Wait for CLEAR condition */
#define PMI_WAIT_SET            1               /* Wait for SET condition   */


/*
** This masm stuff used because H2INC32 needs a lot more than we do.
** Note: Structure *must* be kept in sync with the 'C' version below.
*/

//masm-begin
//HWCOMMAND     STRUC
//      usCommand       dw      ?               ;Type of IO command PMICMD_*
//      usFlags         dw      ?               ;Flag word
//      usIndexPort     dw      ?               ;Index port address
//      usDataPort      dw      ?               ;Data port - 0 if non-indexed
//      usStartReg      dw      ?               ;Start indexed-register
//      usNumRegs       dw      ?               ;Number of registers
//      usANDMask       dw      ?               ;AND mask for RMW command
//      usORMask        dw      ?               ;OR mask   "   "     "
//      usData          dw      ?               ;Immediate data for OUTB/OUTW
//      pNextCmd        dw      ?               ;Next command, NULL if none
//      pPrevCmd        dw      ?               ;Previous cmd, NULL if none
//HWCOMMAND     ENDS
//masm-end

//c-begin

typedef struct _HWCOMMAND {
            USHORT      usCommand;              /* Type of IO command PMICMD_*  */
            USHORT      usFlags;                /* Flags eg. Auto-increment.    */
            USHORT      usIndexPort;            /* Index port address           */
            USHORT      usDataPort;             /* Data port - 0 if non-indexed */
            USHORT      usStartReg;             /* Start indexed-register       */
            USHORT      usNumRegs;              /* Number of registers          */
            USHORT      usANDMask;              /* AND mask for RMW commands    */
            USHORT      usORMask;               /* OR   "    "   "     "        */
            USHORT      usData;                 /* Immediate data for OUTB/OUTW */
            struct _HWCOMMAND NEAR * pNextCmd;  /* Next command, NULL if none   */
            struct _HWCOMMAND NEAR * pPrevCmd;  /* Previous cmd, NULL if none   */
} HWCOMMAND, FAR * FPHWCOMMAND, NEAR * NPHWCOMMAND;

/*
** Function prototypes, external data
*/

VOID   PASCAL FAR  ExecCommands(FPHWCOMMAND);
USHORT PASCAL NEAR SVGAFreeMem(VOID FAR * *);
USHORT PASCAL NEAR SVGAGetMem(VOID FAR *, USHORT);
VOID   PASCAL NEAR SVGACopyCmdList(FPHWCOMMAND, FPHWCOMMAND *);
FPHWCOMMAND PASCAL NEAR SVGASearchList(FPHWCOMMAND, register USHORT);
VOID   PASCAL NEAR SVGAXlatCmdList(FPHWCOMMAND, USHORT);
VOID  APIENTRY FAR SVGASetBank(USHORT);

/*
** End additions.
*/

/* End Interpreter changes            */

/*
** Type definitions
*/

typedef USHORT (APIENTRY FAR ENTRYPOINT)(VOID FAR *, VOID FAR *, ULONG);
typedef USHORT (APIENTRY FAR * FAR * ENTRYPOINTTABLE)(VOID FAR *, VOID FAR *, ULONG);
typedef unsigned char BYTE;
typedef unsigned char _far * PBYTE;

/*
** Structure Definitions for DevEnable
*/

typedef struct _DEVPARM1
        {
            ULONG       EngineVersion;
            ULONG       TableSize;
        } DEVPARM1, FAR * PDEVPARM1;

typedef struct _DEVPARM2
        {
            ULONG               FAR * Flags;
            ENTRYPOINTTABLE     CallVectorTable;
        } DEVPARM2, FAR * PDEVPARM2;

/*
**      WARNING: this structure is also defined in IDHEQU.INC, be sure
**               to update both structures when changing this one
*/

typedef struct _VIDEOHARDWARE
        {                              /* hardware configuration info       */
            USHORT      fVideoType;    /* video adapter(s) and monitor(s)   */
            USHORT      display;       /* display type  not used by BVHINIT */
            ULONG       memory;        /* memory configuration              */
            USHORT      Reg_132;       /* VGA-E 132 col not used by BVHINIT */
            UCHAR       popupMode;     /* popup mode    not used by BVHINIT */
        } VIDEOHARDWARE;

typedef union _FARADDRESS
        {
        VOID FAR * FullAddress;
            struct
            {
                USHORT  Offset;
                USHORT  Selector;
            } Part;
        } FARADDRESS;

typedef struct _REGDATA
        {
            PBYTE       DataArea;
            USHORT      FirstEntry;
            USHORT      NumEntries;
        } REGDATA, FAR * PREGDATA;

typedef struct _REGADDRESS
        {
            USHORT      AddressPort;
            USHORT      DataPort;
            USHORT      ColorAdjust;
            USHORT      Flags;
        } REGADDRESS, FAR * PREGADDRESS;

typedef struct
        {
            USHORT      Length;
            USHORT      Flags;
            USHORT      Row;
            USHORT      Column;
            USHORT      TopScanLine;
            USHORT      BottomScanLine;
            USHORT      Width;
            USHORT      Attribute;
        } VDH_CURSOR, FAR * PVDH_CURSOR;

typedef struct _VDH_BUFUP
        {
            USHORT      Length;
            USHORT      Flags;
            UCHAR far * AppDataAddr;
            UCHAR far * AppCellAddr;
            USHORT      Index;
            USHORT      StartRow;
            USHORT      StartCol;
            USHORT      SecondRow;
            USHORT      SecondCol;
            USHORT      RepeatFactor;
            USHORT      LogicalBufSel;
        } VDH_BUFUP, FAR * PVDH_BUFUP;

#undef VIOPHYSBUF
#undef PVIOPHYSBUF
struct _VDHVIOPHYSBUF
        {         /* viopb */
        PBYTE   pBuf;
        ULONG   cb;
        SEL     asel[4];        /* Definitely no greater than 4 selectors */
        };
#define VIOPHYSBUF struct _VDHVIOPHYSBUF
#define PVIOPHYSBUF VIOPHYSBUF FAR *

typedef struct
        {                   /* alternate VIOPHYSBUF structure used */
            USHORT      cb;          /* if 0 length passed in primary       */
            SEL         asel[2];     /* VIOPHYSBUF structure                */
        } ALT_VIOPHYSBUF;

typedef struct
        {
            USHORT      Length;
            USHORT      Flags;
            USHORT      LDTSelector;
        } VDH_FREEPVB, FAR * PVDH_FREEPVB;

typedef struct
        {   USHORT      Length;
            USHORT      Flags;
            PVIOPHYSBUF PVBDataPTR;
        } VDH_GETPVB, FAR * PVDH_GETPVB;

typedef struct
        {
            USHORT      Length;
            USHORT      Flags;
            PBYTE       FontBuffer;
            USHORT      FontLength;
            USHORT      PelColumns;
            USHORT      PelRows;
        } VDH_FONT, FAR * PVDH_FONT;

typedef struct _VDHSAVEREST
        {
            USHORT      Length;
            USHORT      Flags;
            USHORT      PVBHugeSEL;
        } VDHSAVEREST, FAR * PVDHSAVEREST;

typedef struct _MEMORYMAPS
        {
            ULONG       PageLength;     /* Length of each page              */
            ULONG       TotalSize;      /* Total size of all pages combined */
            USHORT      BitPlanes;      /* bit planes used, 0 for 256       */
                                        /* colours (linear modes)           */
            FARADDRESS  Start;
        } MEMORYMAPS, FAR * PMEMORYMAPS;/*                                     */

typedef struct _CLUTDATA
        {
            BYTE        Red;
            BYTE        Green;
            BYTE        Blue;
        } CLUTDATA, FAR * PCLUTDATA;

typedef struct _VIDEOMODE
        {               /* VioGetMode structure                             */
            USHORT      cb;
            BYTE        fbType;
            BYTE        color;
            USHORT      col;
            USHORT      row;
            USHORT      hres;
            USHORT      vres;
            BYTE        fmt_ID;
            BYTE        attrib;         /* VioGetMode structure ends        */
            USHORT      AdapterType;    /* SVGA extensions                  */
            USHORT      ChipVersion;    /*   "      "                       */
            ULONG       SVGAFlags;      /*   "      "                       */
            FPHWCOMMAND pHWSetModeData; /* ptr to setmode linked list            */
            FPHWCOMMAND pHWSetBank;     /* ptr to setbank linked list            */
            BYTE        MemMap;         /* Index in memory map table        */
            BYTE        Flags;
            BYTE        XCharSize;      /* char cell width                  */
            BYTE        YCharSize;      /* char cell height                 */
        } VIDEOMODE, FAR * PVIDEOMODE;

typedef struct _VDHMODEINFO
        {           /* VioMode structure                                    */
            USHORT      cb;
            BYTE        fbType;
            BYTE        color;
            USHORT      col;
            USHORT      row;
            USHORT      hres;
            USHORT      vres;
            UCHAR       fmt_ID;
            UCHAR       attrib;
            UCHAR       FAR * BufferAddress;
            ULONG       BufferLength;
            ULONG       FullBufferSize;
            ULONG       PartialBufferSize;
            UCHAR       FAR * ExtDataArea;
        } VDHMODEINFO, FAR * PVDHMODEINFO;

typedef struct _VDH_MODE
        {
            USHORT       Length;
            USHORT       Flags;
            PVDHMODEINFO pVDHModeInfo;
        } VDH_MODE, FAR * PVDH_MODE;

typedef struct _VDHCONFIGINFO
        {
            USHORT      cb;
            USHORT      adapter;
            USHORT      display;
            ULONG       cbMemory;
            USHORT      Configuration;
            USHORT      DeviceDriver;
            USHORT      Flags;
            ULONG       HWBufferSize;
            ULONG       FullSaveSize;
            ULONG       PartSaveSize;
            USHORT      EMAdaptersOFF;
            USHORT      EMDisplaysOFF;
            USHORT      LEMAdapterdata;
            USHORT      EMAdapters;
            USHORT      LEMDisplaydata;
            USHORT      EMDisplays;
        } VDHCONFIGINFO, FAR * PVDHCONFIGINFO;

typedef struct _VDHCONFIG
        {
            USHORT              Length;
            USHORT              Flags;
            PVDHCONFIGINFO      ConfigDataPTR;
        } VDHCONFIG, FAR * PVDHCONFIG;

typedef struct _ENVIRONMENT
        {
            USHORT      ModeDataOffset;
            USHORT      ModeIndex;
            USHORT      AdapterType;
            USHORT      ChipVersion;
            VDHMODEINFO ModeData;
            CLUTDATA    LookupTable[256];
            USHORT      EnvFlags;
            USHORT      VideoEnable;
            FPHWCOMMAND pCmdData;               /*            */
            FPHWCOMMAND pSetBankData;           /*            */
            USHORT      PelRows;                /*            */
            USHORT      VGAEnvironment;         /* VGA data starts here     */
        } ENVIRONMENT, FAR * PENVIRONMENT;

/*
**   Macros
*/

#define SEG(fp)                 (*((USHORT *)&(fp) + 1))
#define OFFSET(fp)              (USHORT)(&(fp))
#define MAKEFARPTR(sel,off)     ((PBYTE)((((ULONG)(sel))<<16)+(ULONG)(off)))

/*
** Data Definitions
*/

#define INT3()                  _asm{int 3}

#define MaxConfigs              16

#define FnFillLogicalDevBlock   1L
#define FnFillInitDevBlock      3L

#define FnTextBufferUpdate      256L
#define FnInitializeEnvironment 257L
#define FnSaveEnvironment       258L
#define FnRestoreEnvironment    259L
#define FnReturnConfigInfo      260L
#define FnGetDBCSDisplayInfo    261L
#define FnGetColorLookupTable   262L
#define FnSetColorLookupTable   263L
#define FnGetCursorInfo         264L
#define FnSetCursorInfo         265L
#define FnGetFont               266L
#define FnSetFont               267L
#define FnGetMode               268L
#define FnSetMode               269L
#define FnGetPaletteRegisters   270L
#define FnSetPaletteRegisters   271L
#define FnGetPhysBuf            272L
#define FnFreePhysBuf           273L
#define FnGetVariableInfo       274L
#define FnSetVariableInfo       275L
#define FnExtendedVioCall       276L
#define FnPrintScreen           277L
#define FnWriteTTY              278L
#define FnGetLVBInfo            279L

#define MaxFn                   (FnGetLVBInfo-FnTextBufferUpdate+1)

#define ChainedBufferUpdate     (*ChainedEntryPoint[0])
#define ChainedInitEnv          (*ChainedEntryPoint[1])
#define ChainedSaveEnv          (*ChainedEntryPoint[2])
#define ChainedRestoreEnv       (*ChainedEntryPoint[3])
#define ChainedRetConfigInfo    (*ChainedEntryPoint[4])
#define ChainedGetDBCSInfo      (*ChainedEntryPoint[5])
#define ChainedGetColorLookup   (*ChainedEntryPoint[6])
#define ChainedSetColorLookup   (*ChainedEntryPoint[7])
#define ChainedGetCursorInfo    (*ChainedEntryPoint[8])
#define ChainedSetCursorInfo    (*ChainedEntryPoint[9])
#define ChainedGetCurrentFont   (*ChainedEntryPoint[10])
#define ChainedSetCurrentFont   (*ChainedEntryPoint[11])
#define ChainedGetMode          (*ChainedEntryPoint[12])
#define ChainedSetMode          (*ChainedEntryPoint[13])
#define ChainedGetPaletteReg    (*ChainedEntryPoint[14])
#define ChainedSetPaletteReg    (*ChainedEntryPoint[15])
#define ChainedGetPhysBuf       (*ChainedEntryPoint[16])
#define ChainedFreePhysBuf      (*ChainedEntryPoint[17])
#define ChainedGetVarInfo       (*ChainedEntryPoint[18])
#define ChainedSetVarInfo       (*ChainedEntryPoint[19])
#define ChainedExtVioCall       (*ChainedEntryPoint[20])
#define ChainedPrintScreen      (*ChainedEntryPoint[21])
#define ChainedWriteTTY         (*ChainedEntryPoint[22])
#define ChainedGetLVBInfo       (*ChainedEntryPoint[23])

#define FnChainedBufUpdate      0
#define FnChainedRetConfigInfo  4

#if DEBUG

typedef struct _DEBUGDATA
      {

        BYTE    inuse;
        CHAR    * name;
      } DEBUGDATA, FAR * PDEBUGDATA;

void pascal far DPRINTF(char far *);
#endif

//c-end

