/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = SVGADATA.C
 *
 * DESCRIPTIVE NAME = Global data
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION Global data
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS: GetAdapterConfig
 *
 * DEPENDENCIES:  vdhvga
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define  INCL_BASE                     /* ALL of OS/2 Base                  */
#define  INCL_OS2STD                   /* Needed for NULL definition in OS2STD.H */
#include <os2.h>
#include "svgatype.h"

#if      DEBUG
  #define  STATIC                      /* nothing                           */
#else
  #define  STATIC        static
#endif

/*
** Function Definitions for Functions Chained by this BVH
**
** All of these routines use the same set of parameters:
**
**   char far * = Environment Block (ENVB) pointer (device specific)
**   char far * = Parameter Block pointer (function specific)
**   ULONG      = Function number
**
*/

ENTRYPOINT DevEnable;
ENTRYPOINT InitEnv;
ENTRYPOINT SaveEnv;
ENTRYPOINT RestoreEnv;
ENTRYPOINT RetConfigInfo;
ENTRYPOINT GetMode;
ENTRYPOINT SetMode;
ENTRYPOINT TerminateEnv;                /*            */

/*
** Function Definition for the Chain Router
**
** This is the generic routine which passes control to routines which
** are not specifically chained by this BVH.  It uses the same
** parameters as all of the other routines:
**
**   char far * = Environment Block (ENVB) pointer (device specific)
**   char far * = Parameter Block pointer (entry point specific)
**   ULONG      = Function number
**
*/

ENTRYPOINT ChainRouter;

/*
** Global variables - data shared by more than one BVH routine
*/

int _acrtused = 0;
BOOL InitDone = FALSE;
BOOL PMILoaded = FALSE;
BOOL VGAPresent = FALSE;
USHORT OEMFlags = 0x0000;
HFILE hScreenDD = NULL;                /* Handle to screen device driver */

OEMSVGAINFO SVGAHardware =
{
  0,                                   /* adapter type */
  0,                                   /* chip type */
  1024L*1024L                          /* installed memory */
};

OEMINFO OEMHardware =                  /*            */
{
  10,                                  /* Length            */
  0,                                   /* Manufacturer */
  0L,                                  /* Manufacturer data */
};

USHORT SVGAMonitorType = 0xffff;       /*            */

USHORT HugeShift = 0;
SEL GlobalInfoSeg = NULL;	       /*            */
ULONG PartialSaveSize = 0;

FPHWCOMMAND pHWLockData  = NULL; /* pointer to reg lock linked list            */
FPHWCOMMAND pHWUnLockData= NULL; /* pointer to unlock linked list              */
FPHWCOMMAND pHWCurrSetBank= NULL;/* pointer to current setbank list            */
FPHWCOMMAND pHWCleanData  = NULL;/* pointer to cleanup linked list             */

/*
** Table of Default BVH entry points
*/

ENTRYPOINT FAR *ChainedEntryPoint[MaxFn] = { 0 } ;

/*
**
** Table of BVH entry points supported
**
*/

ENTRYPOINT FAR *SVGAEntryPoint[MaxFn] =
{
  & ChainRouter,                       /* (256) Text Buffer Update          */
  & InitEnv,                           /* (257) Initialise Environment      */
  & SaveEnv,                           /* (258) Save Environment            */
  & RestoreEnv,                        /* (259) Restore Environment         */
  & RetConfigInfo,                     /* (260) Return Config Info          */
  & ChainRouter,                       /* (261) Get DBCS Display Info       */
  & ChainRouter,                       /* (262) Get Colour Lookup Table     */
  & ChainRouter,                       /* (263) Set Colour Lookup Table     */
  & ChainRouter,                       /* (264) Get Cursor Info             */
  & ChainRouter,                       /* (265) Set Cursor Info             */
  & ChainRouter,                       /* (266) Get Font                    */
  & ChainRouter,                       /* (267) Set Font                    */
  & GetMode,                           /* (268) Get Mode                    */
  & SetMode,                           /* (269) Set Mode                    */
  & ChainRouter,                       /* (270) Get Palette Registers       */
  & ChainRouter,                       /* (271) Set Palette Registers       */
  & ChainRouter,                       /* (272) Get Phys Buff               */
  & ChainRouter,                       /* (273) Free Phys Buff              */
  & ChainRouter,                       /* (274) Get Variable Info           */
  & ChainRouter,                       /* (275) Set Variable Info           */
  & TerminateEnv,                      /* (276) Terminate Environment       */
  & ChainRouter,                       /* (277) Print Screen                */
  & ChainRouter,                       /* (278) Write TTY                   */
  & ChainRouter,                       /* (279) Get LVB Info                */
} ;

#if      DEBUG
ENTRYPOINT DebugRouter;
DEBUGDATA DebugFn[] =
{
  { 0, "BufferUpdate\\n" } ,
  { 0, "InitializeEnvironment\\n" } ,
  { 0, "SaveEnvironment\\n" } ,
  { 0, "RestoreEnvironment\\n" } ,
  { 0, "ReturnConfigInfo\\n" } ,
  { 0, "GetDBCSDisplayInfo\\n" } ,
  { 0, "GetColorLookupTable\\n" } ,
  { 0, "SetColorLookupTable\\n" } ,
  { 0, "GetCursorInfo\\n" } ,
  { 0, "SetCursorInfo\\n" } ,
  { 0, "GetFont\\n" } ,
  { 0, "SetFont\\n" } ,
  { 0, "GetMode\\n" } ,
  { 0, "SetMode\\n" } ,
  { 0, "GetPaletteRegisters\\n" } ,
  { 0, "SetPaletteRegisters\\n" } ,
  { 0, "GetPhysBuf\\n" } ,
  { 0, "FreePhysBuf\\n" } ,
  { 0, "GetVariableInfo\\n" } ,
  { 0, "SetVariableInfo\\n" } ,
  { 0, "ExtendedVioCall\\n" } ,
  { 0, "PrintScreen\\n" } ,
  { 0, "WriteTTY\\n" } ,
  { 0, "GetLVBInfo\\n" } ,

};

#endif                                 /* DEBUG */

/*
**
**                      Video Mode Tables
**
*/

PVIDEOMODE pModes = NULL;
PMEMORYMAPS pMemoryMaps = NULL;
USHORT usMaxVideoModes = 0;

/*
**
**                      Colour Lookup Tables
**
*/

CLUTDATA ColourCLUT16[COLOURCLUT16_LENGTH] =
{
  { 0x00, 0x00, 0x00 } ,
  { 0x00, 0x00, 0x2A } ,
  { 0x00, 0x2A, 0x00 } ,
  { 0x00, 0x2A, 0x2A } ,
  { 0x2A, 0x00, 0x00 } ,
  { 0x2A, 0x00, 0x2A } ,
  { 0x2A, 0x2A, 0x00 } ,
  { 0x2A, 0x2A, 0x2A } ,
  { 0x00, 0x00, 0x15 } ,
  { 0x00, 0x00, 0x3F } ,
  { 0x00, 0x2A, 0x15 } ,
  { 0x00, 0x2A, 0x3F } ,
  { 0x2A, 0x00, 0x15 } ,
  { 0x2A, 0x00, 0x3F } ,
  { 0x2A, 0x2A, 0x15 } ,
  { 0x2A, 0x2A, 0x3F } ,
  { 0x00, 0x15, 0x00 } ,
  { 0x00, 0x15, 0x2A } ,
  { 0x00, 0x3F, 0x00 } ,
  { 0x00, 0x3F, 0x2A } ,
  { 0x2A, 0x15, 0x00 } ,
  { 0x2A, 0x15, 0x2A } ,
  { 0x2A, 0x3F, 0x00 } ,
  { 0x2A, 0x3F, 0x2A } ,
  { 0x00, 0x15, 0x15 } ,
  { 0x00, 0x15, 0x3F } ,
  { 0x00, 0x3F, 0x15 } ,
  { 0x00, 0x3F, 0x3F } ,
  { 0x2A, 0x15, 0x15 } ,
  { 0x2A, 0x15, 0x3F } ,
  { 0x2A, 0x3F, 0x15 } ,
  { 0x2A, 0x3F, 0x3F } ,
  { 0x15, 0x00, 0x00 } ,
  { 0x15, 0x00, 0x2A } ,
  { 0x15, 0x2A, 0x00 } ,
  { 0x15, 0x2A, 0x2A } ,
  { 0x3F, 0x00, 0x00 } ,
  { 0x3F, 0x00, 0x2A } ,
  { 0x3F, 0x2A, 0x00 } ,
  { 0x3F, 0x2A, 0x2A } ,
  { 0x15, 0x00, 0x15 } ,
  { 0x15, 0x00, 0x3F } ,
  { 0x15, 0x2A, 0x15 } ,
  { 0x15, 0x2A, 0x3F } ,
  { 0x3F, 0x00, 0x15 } ,
  { 0x3F, 0x00, 0x3F } ,
  { 0x3F, 0x2A, 0x15 } ,
  { 0x3F, 0x2A, 0x3F } ,
  { 0x15, 0x15, 0x00 } ,
  { 0x15, 0x15, 0x2A } ,
  { 0x15, 0x3F, 0x00 } ,
  { 0x15, 0x3F, 0x2A } ,
  { 0x3F, 0x15, 0x00 } ,
  { 0x3F, 0x15, 0x2A } ,
  { 0x3F, 0x3F, 0x00 } ,
  { 0x3F, 0x3F, 0x2A } ,
  { 0x15, 0x15, 0x15 } ,
  { 0x15, 0x15, 0x3F } ,
  { 0x15, 0x3F, 0x15 } ,
  { 0x15, 0x3F, 0x3F } ,
  { 0x3F, 0x15, 0x15 } ,
  { 0x3F, 0x15, 0x3F } ,
  { 0x3F, 0x3F, 0x15 } ,
  { 0x3F, 0x3F, 0x3F } ,

};

CLUTDATA MonoCLUT16[MONOCLUT16_LENGTH] =
{
  { 0x00, 0x00, 0x00 } ,
  { 0x05, 0x05, 0x05 } ,
  { 0x11, 0x11, 0x11 } ,
  { 0x1C, 0x1C, 0x1C } ,
  { 0x08, 0x08, 0x08 } ,
  { 0x0B, 0x0B, 0x0B } ,
  { 0x25, 0x25, 0x25 } ,
  { 0x28, 0x28, 0x28 } ,
  { 0x02, 0x02, 0x02 } ,
  { 0x07, 0x07, 0x07 } ,
  { 0x1B, 0x1B, 0x1B } ,
  { 0x20, 0x20, 0x20 } ,
  { 0x0F, 0x0F, 0x0F } ,
  { 0x14, 0x14, 0x14 } ,
  { 0x28, 0x28, 0x28 } ,
  { 0x2C, 0x2C, 0x2C } ,
  { 0x0C, 0x0C, 0x0C } ,
  { 0x11, 0x11, 0x11 } ,
  { 0x25, 0x25, 0x25 } ,
  { 0x2A, 0x2A, 0x2A } ,
  { 0x14, 0x14, 0x14 } ,
  { 0x1E, 0x1E, 0x1E } ,
  { 0x32, 0x32, 0x32 } ,
  { 0x36, 0x36, 0x36 } ,
  { 0x0F, 0x0F, 0x0F } ,
  { 0x13, 0x13, 0x13 } ,
  { 0x27, 0x27, 0x27 } ,
  { 0x2C, 0x2C, 0x2C } ,
  { 0x1B, 0x1B, 0x1B } ,
  { 0x20, 0x20, 0x20 } ,
  { 0x34, 0x34, 0x34 } ,
  { 0x39, 0x39, 0x39 } ,
  { 0x06, 0x06, 0x06 } ,
  { 0x0B, 0x0B, 0x0B } ,
  { 0x1F, 0x1F, 0x1F } ,
  { 0x24, 0x24, 0x24 } ,
  { 0x13, 0x13, 0x13 } ,
  { 0x18, 0x18, 0x18 } ,
  { 0x2C, 0x2C, 0x2C } ,
  { 0x30, 0x30, 0x30 } ,
  { 0x09, 0x09, 0x09 } ,
  { 0x0D, 0x0D, 0x0D } ,
  { 0x21, 0x21, 0x21 } ,
  { 0x26, 0x26, 0x26 } ,
  { 0x15, 0x15, 0x15 } ,
  { 0x1A, 0x1A, 0x1A } ,
  { 0x2E, 0x2E, 0x2E } ,
  { 0x33, 0x33, 0x33 } ,
  { 0x13, 0x13, 0x13 } ,
  { 0x17, 0x17, 0x17 } ,
  { 0x2B, 0x2B, 0x2B } ,
  { 0x30, 0x30, 0x30 } ,
  { 0x1F, 0x1F, 0x1F } ,
  { 0x24, 0x24, 0x24 } ,
  { 0x38, 0x38, 0x38 } ,
  { 0x3D, 0x3D, 0x3D } ,
  { 0x0E, 0x0E, 0x0E } ,
  { 0x18, 0x18, 0x18 } ,
  { 0x2D, 0x2D, 0x2D } ,
  { 0x32, 0x32, 0x32 } ,
  { 0x20, 0x20, 0x20 } ,
  { 0x24, 0x24, 0x24 } ,
  { 0x38, 0x38, 0x38 } ,
  { 0x3F, 0x3F, 0x3F } ,

};

CLUTDATA ColourCLUT256[COLOURCLUT256_LENGTH] =
{

  { 0x00, 0x00, 0x00 } ,
  { 0x00, 0x00, 0x2A } ,
  { 0x00, 0x2A, 0x00 } ,
  { 0x00, 0x2A, 0x2A } ,
  { 0x2A, 0x00, 0x00 } ,
  { 0x2A, 0x00, 0x2A } ,
  { 0x2A, 0x15, 0x00 } ,
  { 0x2A, 0x2A, 0x2A } ,
  { 0x15, 0x15, 0x15 } ,
  { 0x15, 0x15, 0x3F } ,
  { 0x15, 0x3F, 0x15 } ,
  { 0x15, 0x3F, 0x3F } ,
  { 0x3F, 0x15, 0x15 } ,
  { 0x3F, 0x15, 0x3F } ,
  { 0x3F, 0x3F, 0x15 } ,
  { 0x3F, 0x3F, 0x3F } ,
  { 0x00, 0x00, 0x00 } ,
  { 0x05, 0x05, 0x05 } ,
  { 0x08, 0x08, 0x08 } ,
  { 0x0B, 0x0B, 0x0B } ,
  { 0x0E, 0x0E, 0x0E } ,
  { 0x11, 0x11, 0x11 } ,
  { 0x14, 0x14, 0x14 } ,
  { 0x18, 0x18, 0x18 } ,
  { 0x1C, 0x1C, 0x1C } ,
  { 0x20, 0x20, 0x20 } ,
  { 0x24, 0x24, 0x24 } ,
  { 0x28, 0x28, 0x28 } ,
  { 0x2D, 0x2D, 0x2D } ,
  { 0x32, 0x32, 0x32 } ,
  { 0x38, 0x38, 0x38 } ,
  { 0x3F, 0x3F, 0x3F } ,
  { 0x00, 0x00, 0x3F } ,
  { 0x10, 0x00, 0x3F } ,
  { 0x1F, 0x00, 0x3F } ,
  { 0x2F, 0x00, 0x3F } ,
  { 0x3F, 0x00, 0x3F } ,
  { 0x3F, 0x00, 0x2F } ,
  { 0x3F, 0x00, 0x1F } ,
  { 0x3F, 0x00, 0x10 } ,
  { 0x3F, 0x00, 0x00 } ,
  { 0x3F, 0x10, 0x00 } ,
  { 0x3F, 0x1F, 0x00 } ,
  { 0x3F, 0x2F, 0x00 } ,
  { 0x3F, 0x3F, 0x00 } ,
  { 0x2F, 0x3F, 0x00 } ,
  { 0x1F, 0x3F, 0x00 } ,
  { 0x10, 0x3F, 0x00 } ,
  { 0x00, 0x3F, 0x00 } ,
  { 0x00, 0x3F, 0x10 } ,
  { 0x00, 0x3F, 0x1F } ,
  { 0x00, 0x3F, 0x2F } ,
  { 0x00, 0x3F, 0x3F } ,
  { 0x00, 0x2F, 0x3F } ,
  { 0x00, 0x1F, 0x3F } ,
  { 0x00, 0x10, 0x3F } ,
  { 0x1F, 0x1F, 0x3F } ,
  { 0x27, 0x1F, 0x3F } ,
  { 0x2F, 0x1F, 0x3F } ,
  { 0x37, 0x1F, 0x3F } ,
  { 0x3F, 0x1F, 0x3F } ,
  { 0x3F, 0x1F, 0x37 } ,
  { 0x3F, 0x1F, 0x2F } ,
  { 0x3F, 0x1F, 0x27 } ,
  { 0x3F, 0x1F, 0x1F } ,
  { 0x3F, 0x27, 0x1F } ,
  { 0x3F, 0x2F, 0x1F } ,
  { 0x3F, 0x37, 0x1F } ,
  { 0x3F, 0x3F, 0x1F } ,
  { 0x37, 0x3F, 0x1F } ,
  { 0x2F, 0x3F, 0x1F } ,
  { 0x27, 0x3F, 0x1F } ,
  { 0x1F, 0x3F, 0x1F } ,
  { 0x1F, 0x3F, 0x27 } ,
  { 0x1F, 0x3F, 0x2F } ,
  { 0x1F, 0x3F, 0x37 } ,
  { 0x1F, 0x3F, 0x3F } ,
  { 0x1F, 0x37, 0x3F } ,
  { 0x1F, 0x2F, 0x3F } ,
  { 0x1F, 0x27, 0x3F } ,
  { 0x2D, 0x2D, 0x3F } ,
  { 0x31, 0x2D, 0x3F } ,
  { 0x36, 0x2D, 0x3F } ,
  { 0x3A, 0x2D, 0x3F } ,
  { 0x3F, 0x2D, 0x3F } ,
  { 0x3F, 0x2D, 0x3A } ,
  { 0x3F, 0x2D, 0x36 } ,
  { 0x3F, 0x2D, 0x31 } ,
  { 0x3F, 0x2D, 0x2D } ,
  { 0x3F, 0x31, 0x2D } ,
  { 0x3F, 0x36, 0x2D } ,
  { 0x3F, 0x3A, 0x2D } ,
  { 0x3F, 0x3F, 0x2D } ,
  { 0x3A, 0x3F, 0x2D } ,
  { 0x36, 0x3F, 0x2D } ,
  { 0x31, 0x3F, 0x2D } ,
  { 0x2D, 0x3F, 0x2D } ,
  { 0x2D, 0x3F, 0x31 } ,
  { 0x2D, 0x3F, 0x36 } ,
  { 0x2D, 0x3F, 0x3A } ,
  { 0x2D, 0x3F, 0x3F } ,
  { 0x2D, 0x3A, 0x3F } ,
  { 0x2D, 0x36, 0x3F } ,
  { 0x2D, 0x31, 0x3F } ,
  { 0x00, 0x00, 0x1C } ,
  { 0x07, 0x00, 0x1C } ,
  { 0x0E, 0x00, 0x1C } ,
  { 0x15, 0x00, 0x1C } ,
  { 0x1C, 0x00, 0x1C } ,
  { 0x1C, 0x00, 0x15 } ,
  { 0x1C, 0x00, 0x0E } ,
  { 0x1C, 0x00, 0x07 } ,
  { 0x1C, 0x00, 0x00 } ,
  { 0x1C, 0x07, 0x00 } ,
  { 0x1C, 0x0E, 0x00 } ,
  { 0x1C, 0x15, 0x00 } ,
  { 0x1C, 0x1C, 0x00 } ,
  { 0x15, 0x1C, 0x00 } ,
  { 0x0E, 0x1C, 0x00 } ,
  { 0x07, 0x1C, 0x00 } ,
  { 0x00, 0x1C, 0x00 } ,
  { 0x00, 0x1C, 0x07 } ,
  { 0x00, 0x1C, 0x0E } ,
  { 0x00, 0x1C, 0x15 } ,
  { 0x00, 0x1C, 0x1C } ,
  { 0x00, 0x15, 0x1C } ,
  { 0x00, 0x0E, 0x1C } ,
  { 0x00, 0x07, 0x1C } ,
  { 0x0E, 0x0E, 0x1C } ,
  { 0x11, 0x0E, 0x1C } ,
  { 0x15, 0x0E, 0x1C } ,
  { 0x18, 0x0E, 0x1C } ,
  { 0x1C, 0x0E, 0x1C } ,
  { 0x1C, 0x0E, 0x18 } ,
  { 0x1C, 0x0E, 0x15 } ,
  { 0x1C, 0x0E, 0x11 } ,
  { 0x1C, 0x0E, 0x0E } ,
  { 0x1C, 0x11, 0x0E } ,
  { 0x1C, 0x15, 0x0E } ,
  { 0x1C, 0x08, 0x0E } ,
  { 0x1C, 0x1C, 0x0E } ,
  { 0x18, 0x1C, 0x0E } ,
  { 0x15, 0x1C, 0x0E } ,
  { 0x11, 0x1C, 0x0E } ,
  { 0x0E, 0x1C, 0x0E } ,
  { 0x0E, 0x1C, 0x11 } ,
  { 0x0E, 0x1C, 0x15 } ,
  { 0x0E, 0x1C, 0x18 } ,
  { 0x0E, 0x1C, 0x1C } ,
  { 0x0E, 0x18, 0x1C } ,
  { 0x0E, 0x15, 0x1C } ,
  { 0x0E, 0x11, 0x1C } ,
  { 0x14, 0x14, 0x1C } ,
  { 0x16, 0x14, 0x1C } ,
  { 0x18, 0x14, 0x1C } ,
  { 0x1A, 0x14, 0x1C } ,
  { 0x1C, 0x14, 0x1C } ,
  { 0x1C, 0x14, 0x1A } ,
  { 0x1C, 0x14, 0x18 } ,
  { 0x1C, 0x14, 0x16 } ,
  { 0x1C, 0x14, 0x14 } ,
  { 0x1C, 0x16, 0x14 } ,
  { 0x1C, 0x18, 0x14 } ,
  { 0x1C, 0x1A, 0x14 } ,
  { 0x1C, 0x1C, 0x14 } ,
  { 0x1A, 0x1C, 0x14 } ,
  { 0x18, 0x1C, 0x14 } ,
  { 0x16, 0x1C, 0x14 } ,
  { 0x14, 0x1C, 0x14 } ,
  { 0x14, 0x1C, 0x16 } ,
  { 0x14, 0x1C, 0x18 } ,
  { 0x14, 0x1C, 0x1A } ,
  { 0x14, 0x1C, 0x1C } ,
  { 0x14, 0x1A, 0x1C } ,
  { 0x14, 0x18, 0x1C } ,
  { 0x14, 0x16, 0x1C } ,
  { 0x00, 0x00, 0x10 } ,
  { 0x04, 0x00, 0x10 } ,
  { 0x08, 0x00, 0x10 } ,
  { 0x0C, 0x00, 0x10 } ,
  { 0x10, 0x00, 0x10 } ,
  { 0x10, 0x00, 0x0C } ,
  { 0x10, 0x00, 0x08 } ,
  { 0x10, 0x00, 0x04 } ,
  { 0x10, 0x00, 0x00 } ,
  { 0x10, 0x04, 0x00 } ,
  { 0x10, 0x08, 0x00 } ,
  { 0x10, 0x0C, 0x00 } ,
  { 0x10, 0x10, 0x00 } ,
  { 0x0C, 0x10, 0x00 } ,
  { 0x08, 0x10, 0x00 } ,
  { 0x04, 0x10, 0x00 } ,
  { 0x00, 0x10, 0x00 } ,
  { 0x00, 0x10, 0x04 } ,
  { 0x00, 0x10, 0x08 } ,
  { 0x00, 0x10, 0x0C } ,
  { 0x00, 0x10, 0x10 } ,
  { 0x00, 0x0C, 0x10 } ,
  { 0x00, 0x08, 0x10 } ,
  { 0x00, 0x04, 0x10 } ,
  { 0x08, 0x08, 0x10 } ,
  { 0x0A, 0x08, 0x10 } ,
  { 0x0C, 0x08, 0x10 } ,
  { 0x0E, 0x08, 0x10 } ,
  { 0x10, 0x08, 0x10 } ,
  { 0x10, 0x08, 0x0E } ,
  { 0x10, 0x08, 0x0C } ,
  { 0x10, 0x08, 0x0A } ,
  { 0x10, 0x08, 0x08 } ,
  { 0x10, 0x0A, 0x08 } ,
  { 0x10, 0x0C, 0x08 } ,
  { 0x10, 0x0E, 0x08 } ,
  { 0x10, 0x10, 0x08 } ,
  { 0x0E, 0x10, 0x08 } ,
  { 0x0C, 0x10, 0x08 } ,
  { 0x0A, 0x10, 0x08 } ,
  { 0x08, 0x10, 0x08 } ,
  { 0x08, 0x10, 0x0A } ,
  { 0x08, 0x10, 0x0C } ,
  { 0x08, 0x10, 0x0E } ,
  { 0x08, 0x10, 0x10 } ,
  { 0x08, 0x0E, 0x10 } ,
  { 0x08, 0x0C, 0x10 } ,
  { 0x08, 0x0A, 0x10 } ,
  { 0x0B, 0x0B, 0x10 } ,
  { 0x0C, 0x0B, 0x10 } ,
  { 0x0D, 0x0B, 0x10 } ,
  { 0x0F, 0x0B, 0x10 } ,
  { 0x10, 0x0B, 0x10 } ,
  { 0x10, 0x0B, 0x0F } ,
  { 0x10, 0x0B, 0x0D } ,
  { 0x10, 0x0B, 0x0C } ,
  { 0x10, 0x0B, 0x0B } ,
  { 0x10, 0x0C, 0x0B } ,
  { 0x10, 0x0D, 0x0B } ,
  { 0x10, 0x0F, 0x0B } ,
  { 0x10, 0x10, 0x0B } ,
  { 0x0F, 0x10, 0x0B } ,
  { 0x0D, 0x10, 0x0B } ,
  { 0x0C, 0x10, 0x0B } ,
  { 0x0B, 0x10, 0x0B } ,
  { 0x0B, 0x10, 0x0C } ,
  { 0x0B, 0x10, 0x0D } ,
  { 0x0B, 0x10, 0x0F } ,
  { 0x0B, 0x10, 0x10 } ,
  { 0x0B, 0x0F, 0x10 } ,
  { 0x0B, 0x0D, 0x10 } ,
  { 0x0B, 0x0C, 0x10 } ,
  { 0x15, 0x15, 0x15 } ,
  { 0x15, 0x15, 0x3F } ,
  { 0x15, 0x3F, 0x15 } ,
  { 0x15, 0x3F, 0x3F } ,
  { 0x3F, 0x15, 0x15 } ,
  { 0x3F, 0x15, 0x3F } ,
  { 0x3F, 0x3F, 0x15 } ,
  { 0x3F, 0x3F, 0x3F } ,

} ;

CLUTDATA MonoCLUT256[MONOCLUT256_LENGTH] =
{

  { 0x00, 0x00, 0x00 } ,
  { 0x05, 0x05, 0x05 } ,
  { 0x11, 0x11, 0x11 } ,
  { 0x1C, 0x1C, 0x1C } ,
  { 0x08, 0x08, 0x08 } ,
  { 0x0B, 0x0B, 0x0B } ,
  { 0x14, 0x14, 0x14 } ,
  { 0x28, 0x28, 0x28 } ,
  { 0x0E, 0x0E, 0x0E } ,
  { 0x18, 0x18, 0x18 } ,
  { 0x2D, 0x2D, 0x2D } ,
  { 0x32, 0x32, 0x32 } ,
  { 0x20, 0x20, 0x20 } ,
  { 0x24, 0x24, 0x24 } ,
  { 0x38, 0x38, 0x38 } ,
  { 0x3F, 0x3F, 0x3F } ,
  { 0x00, 0x00, 0x00 } ,
  { 0x05, 0x05, 0x05 } ,
  { 0x08, 0x08, 0x08 } ,
  { 0x0B, 0x0B, 0x0B } ,
  { 0x0E, 0x0E, 0x0E } ,
  { 0x11, 0x11, 0x11 } ,
  { 0x14, 0x14, 0x14 } ,
  { 0x18, 0x18, 0x18 } ,
  { 0x1C, 0x1C, 0x1C } ,
  { 0x20, 0x20, 0x20 } ,
  { 0x24, 0x24, 0x24 } ,
  { 0x28, 0x28, 0x28 } ,
  { 0x2D, 0x2D, 0x2D } ,
  { 0x32, 0x32, 0x32 } ,
  { 0x38, 0x38, 0x38 } ,
  { 0x3F, 0x3F, 0x3F } ,
  { 0x07, 0x07, 0x07 } ,
  { 0x0C, 0x0C, 0x0C } ,
  { 0x10, 0x10, 0x10 } ,
  { 0x15, 0x15, 0x15 } ,
  { 0x1A, 0x1A, 0x1A } ,
  { 0x18, 0x18, 0x18 } ,
  { 0x16, 0x16, 0x16 } ,
  { 0x15, 0x15, 0x15 } ,
  { 0x13, 0x13, 0x13 } ,
  { 0x1C, 0x1C, 0x1C } ,
  { 0x25, 0x25, 0x25 } ,
  { 0x2F, 0x2F, 0x2F } ,
  { 0x38, 0x38, 0x38 } ,
  { 0x33, 0x33, 0x33 } ,
  { 0x2E, 0x2E, 0x2E } ,
  { 0x2A, 0x2A, 0x2A } ,
  { 0x25, 0x25, 0x25 } ,
  { 0x27, 0x27, 0x27 } ,
  { 0x29, 0x29, 0x29 } ,
  { 0x2A, 0x2A, 0x2A } ,
  { 0x2C, 0x2C, 0x2C } ,
  { 0x23, 0x23, 0x23 } ,
  { 0x19, 0x19, 0x19 } ,
  { 0x10, 0x10, 0x10 } ,
  { 0x23, 0x23, 0x23 } ,
  { 0x25, 0x25, 0x25 } ,
  { 0x27, 0x27, 0x27 } ,
  { 0x2A, 0x2A, 0x2A } ,
  { 0x2C, 0x2C, 0x2C } ,
  { 0x2B, 0x2B, 0x2B } ,
  { 0x2A, 0x2A, 0x2A } ,
  { 0x29, 0x29, 0x29 } ,
  { 0x29, 0x29, 0x29 } ,
  { 0x2D, 0x2D, 0x2D } ,
  { 0x32, 0x32, 0x32 } ,
  { 0x37, 0x37, 0x37 } ,
  { 0x3B, 0x3B, 0x3B } ,
  { 0x39, 0x39, 0x39 } ,
  { 0x37, 0x37, 0x37 } ,
  { 0x34, 0x34, 0x34 } ,
  { 0x32, 0x32, 0x32 } ,
  { 0x33, 0x33, 0x33 } ,
  { 0x34, 0x34, 0x34 } ,
  { 0x35, 0x35, 0x35 } ,
  { 0x35, 0x35, 0x35 } ,
  { 0x31, 0x31, 0x31 } ,
  { 0x2C, 0x2C, 0x2C } ,
  { 0x27, 0x27, 0x27 } ,
  { 0x2F, 0x2F, 0x2F } ,
  { 0x30, 0x30, 0x30 } ,
  { 0x32, 0x32, 0x32 } ,
  { 0x33, 0x33, 0x33 } ,
  { 0x34, 0x34, 0x34 } ,
  { 0x34, 0x34, 0x34 } ,
  { 0x33, 0x33, 0x33 } ,
  { 0x33, 0x33, 0x33 } ,
  { 0x32, 0x32, 0x32 } ,
  { 0x35, 0x35, 0x35 } ,
  { 0x38, 0x38, 0x38 } ,
  { 0x3A, 0x3A, 0x3A } ,
  { 0x3D, 0x3D, 0x3D } ,
  { 0x3C, 0x3C, 0x3C } ,
  { 0x3A, 0x3A, 0x3A } ,
  { 0x39, 0x39, 0x39 } ,
  { 0x38, 0x38, 0x38 } ,
  { 0x38, 0x38, 0x38 } ,
  { 0x39, 0x39, 0x39 } ,
  { 0x39, 0x39, 0x39 } ,
  { 0x3A, 0x3A, 0x3A } ,
  { 0x37, 0x37, 0x37 } ,
  { 0x34, 0x34, 0x34 } ,
  { 0x31, 0x31, 0x31 } ,
  { 0x03, 0x03, 0x03 } ,
  { 0x05, 0x05, 0x05 } ,
  { 0x07, 0x07, 0x07 } ,
  { 0x09, 0x09, 0x09 } ,
  { 0x0B, 0x0B, 0x0B } ,
  { 0x0B, 0x0B, 0x0B } ,
  { 0x0A, 0x0A, 0x0A } ,
  { 0x09, 0x09, 0x09 } ,
  { 0x08, 0x08, 0x08 } ,
  { 0x0D, 0x0D, 0x0D } ,
  { 0x11, 0x11, 0x11 } ,
  { 0x15, 0x15, 0x15 } ,
  { 0x19, 0x19, 0x19 } ,
  { 0x17, 0x17, 0x17 } ,
  { 0x15, 0x15, 0x15 } ,
  { 0x13, 0x13, 0x13 } ,
  { 0x11, 0x11, 0x11 } ,
  { 0x11, 0x11, 0x11 } ,
  { 0x12, 0x12, 0x12 } ,
  { 0x13, 0x13, 0x13 } ,
  { 0x14, 0x14, 0x14 } ,
  { 0x0F, 0x0F, 0x0F } ,
  { 0x0B, 0x0B, 0x0B } ,
  { 0x07, 0x07, 0x07 } ,
  { 0x10, 0x10, 0x10 } ,
  { 0x10, 0x10, 0x10 } ,
  { 0x12, 0x12, 0x12 } ,
  { 0x13, 0x13, 0x13 } ,
  { 0x14, 0x14, 0x14 } ,
  { 0x13, 0x13, 0x13 } ,
  { 0x13, 0x13, 0x13 } ,
  { 0x13, 0x13, 0x13 } ,
  { 0x12, 0x12, 0x12 } ,
  { 0x14, 0x14, 0x14 } ,
  { 0x16, 0x16, 0x16 } ,
  { 0x18, 0x18, 0x18 } ,
  { 0x1A, 0x1A, 0x1A } ,
  { 0x19, 0x19, 0x19 } ,
  { 0x18, 0x18, 0x18 } ,
  { 0x17, 0x17, 0x17 } ,
  { 0x16, 0x16, 0x16 } ,
  { 0x17, 0x17, 0x17 } ,
  { 0x17, 0x17, 0x17 } ,
  { 0x17, 0x17, 0x17 } ,
  { 0x18, 0x18, 0x18 } ,
  { 0x15, 0x15, 0x15 } ,
  { 0x14, 0x14, 0x14 } ,
  { 0x11, 0x11, 0x11 } ,
  { 0x15, 0x15, 0x15 } ,
  { 0x15, 0x15, 0x15 } ,
  { 0x16, 0x16, 0x16 } ,
  { 0x17, 0x17, 0x17 } ,
  { 0x17, 0x17, 0x17 } ,
  { 0x17, 0x17, 0x17 } ,
  { 0x17, 0x17, 0x17 } ,
  { 0x17, 0x17, 0x17 } ,
  { 0x16, 0x16, 0x16 } ,
  { 0x18, 0x18, 0x18 } ,
  { 0x19, 0x19, 0x19 } ,
  { 0x1A, 0x1A, 0x1A } ,
  { 0x1B, 0x1B, 0x1B } ,
  { 0x1B, 0x1B, 0x1B } ,
  { 0x1A, 0x1A, 0x1A } ,
  { 0x19, 0x19, 0x19 } ,
  { 0x19, 0x19, 0x19 } ,
  { 0x19, 0x19, 0x19 } ,
  { 0x19, 0x19, 0x19 } ,
  { 0x19, 0x19, 0x19 } ,
  { 0x1A, 0x1A, 0x1A } ,
  { 0x18, 0x18, 0x18 } ,
  { 0x17, 0x17, 0x17 } ,
  { 0x16, 0x16, 0x16 } ,
  { 0x02, 0x02, 0x02 } ,
  { 0x03, 0x03, 0x03 } ,
  { 0x04, 0x04, 0x04 } ,
  { 0x05, 0x05, 0x05 } ,
  { 0x07, 0x07, 0x07 } ,
  { 0x06, 0x06, 0x06 } ,
  { 0x06, 0x06, 0x06 } ,
  { 0x05, 0x05, 0x05 } ,
  { 0x05, 0x05, 0x05 } ,
  { 0x07, 0x07, 0x07 } ,
  { 0x0A, 0x0A, 0x0A } ,
  { 0x0C, 0x0C, 0x0C } ,
  { 0x0E, 0x0E, 0x0E } ,
  { 0x0D, 0x0D, 0x0D } ,
  { 0x0C, 0x0C, 0x0C } ,
  { 0x0B, 0x0B, 0x0B } ,
  { 0x09, 0x09, 0x09 } ,
  { 0x0A, 0x0A, 0x0A } ,
  { 0x0A, 0x0A, 0x0A } ,
  { 0x0B, 0x0B, 0x0B } ,
  { 0x0B, 0x0B, 0x0B } ,
  { 0x09, 0x09, 0x09 } ,
  { 0x06, 0x06, 0x06 } ,
  { 0x04, 0x04, 0x04 } ,
  { 0x09, 0x09, 0x09 } ,
  { 0x09, 0x09, 0x09 } ,
  { 0x0A, 0x0A, 0x0A } ,
  { 0x0B, 0x0B, 0x0B } ,
  { 0x0B, 0x0B, 0x0B } ,
  { 0x0B, 0x0B, 0x0B } ,
  { 0x0B, 0x0B, 0x0B } ,
  { 0x0B, 0x0B, 0x0B } ,
  { 0x0A, 0x0A, 0x0A } ,
  { 0x0C, 0x0C, 0x0C } ,
  { 0x0D, 0x0D, 0x0D } ,
  { 0x0E, 0x0E, 0x0E } ,
  { 0x0F, 0x0F, 0x0F } ,
  { 0x0F, 0x0F, 0x0F } ,
  { 0x0E, 0x0E, 0x0E } ,
  { 0x0D, 0x0D, 0x0D } ,
  { 0x0D, 0x0D, 0x0D } ,
  { 0x0D, 0x0D, 0x0D } ,
  { 0x0D, 0x0D, 0x0D } ,
  { 0x0D, 0x0D, 0x0D } ,
  { 0x0E, 0x0E, 0x0E } ,
  { 0x0C, 0x0C, 0x0C } ,
  { 0x0B, 0x0B, 0x0B } ,
  { 0x0A, 0x0A, 0x0A } ,
  { 0x0C, 0x0C, 0x0C } ,
  { 0x0C, 0x0C, 0x0C } ,
  { 0x0C, 0x0C, 0x0C } ,
  { 0x0D, 0x0D, 0x0D } ,
  { 0x0D, 0x0D, 0x0D } ,
  { 0x0D, 0x0D, 0x0D } ,
  { 0x0D, 0x0D, 0x0D } ,
  { 0x0D, 0x0D, 0x0D } ,
  { 0x0C, 0x0C, 0x0C } ,
  { 0x0D, 0x0D, 0x0D } ,
  { 0x0E, 0x0E, 0x0E } ,
  { 0x0F, 0x0F, 0x0F } ,
  { 0x0F, 0x0F, 0x0F } ,
  { 0x0F, 0x0F, 0x0F } ,
  { 0x0F, 0x0F, 0x0F } ,
  { 0x0E, 0x0E, 0x0E } ,
  { 0x0E, 0x0E, 0x0E } ,
  { 0x0E, 0x0E, 0x0E } ,
  { 0x0E, 0x0E, 0x0E } ,
  { 0x0E, 0x0E, 0x0E } ,
  { 0x0E, 0x0E, 0x0E } ,
  { 0x0E, 0x0E, 0x0E } ,
  { 0x0D, 0x0D, 0x0D } ,
  { 0x0C, 0x0C, 0x0C } ,
  { 0x15, 0x15, 0x15 } ,
  { 0x1A, 0x1A, 0x1A } ,
  { 0x2E, 0x2E, 0x2E } ,
  { 0x32, 0x32, 0x32 } ,
  { 0x22, 0x22, 0x22 } ,
  { 0x26, 0x26, 0x26 } ,
  { 0x3A, 0x3A, 0x3A } ,
  { 0x3F, 0x3F, 0x3F } ,

} ;
