/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = svgaconf.c
 *
 * DESCRIPTIVE NAME = Configuration routines
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION Super VGA specific routines to determine
 *             the adapter configuration.
 *
 * FUNCTIONS
 *
 * ENTRY POINTS: GetAdapterConfig
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define  INCL_BASE                     /* ALL of OS/2 Base                  */
#define  INCL_DOSDEVICES               /* Device specific, ring 2 support   */
#define  INCL_OS2STD                   /* Needed for NULL definition in     */
                                       /* OS2STD.H                          */
#include <os2.h>
#include <memory.h>
#include "svgatype.h"

/*
**       Externals
*/

extern OEMSVGAINFO SVGAHardware;            /* installed SVGA hardware      */
extern OEMINFO OEMHardware;                 /*            */
extern ULONG PartialSaveSize;

/****************************************************************************
 *
 * SUBROUTINE NAME: videoIoctl
 *
 * DESCRIPTIVE NAME: perform requested IOCTL request
 *
 * FUNCTION:  Issue generic IOCTL, use strong error checking
 *
 *  ENTRY POINT: videoIoctl
 *    LINKAGE:   CALL NEAR
 *
 *  INPUT: data - data from IOCTL request
 *         parm - parameter to IOCTL request
 *         function - function requested
 *
 *  EXIT:  error code from DosOpen or DosDevIoctl
 *
 *  EFFECTS: determined by request
 *
 *  INTERNAL REFERENCES:
 *
 *    ROUTINES: DosOpen, DosDevIoctl
 *
 *  EXTERNAL REFERENCES:
 ****************************************************************************/

int PASCAL near videoIoctl(VOID *data,VOID *parm,USHORT function)
{
  unsigned hScreenDD;                    /* handle of SCREENDD$ device driver   */
  unsigned OpenAction;                 /* action taken to open device       */
  unsigned rc;                         /* function return code              */


  if (!(rc = DosOpen(SCREENDD_NAME, (PHFILE)&hScreenDD, (PUSHORT)&OpenAction,
     NO_SIZE, NO_ATTRIBUTES, OPEN_IF_EXISTS, NO_INHERIT+DENY_NONE+READ_WRITE,
     RESERVED_LONG)))
  {
    rc = DosDevIOCtl(data,
                     parm,
                     function,
                     SCREENDD_CATEGORY,
                     (HFILE)hScreenDD);
    DosClose(hScreenDD);
  }
  return (rc);
}

/****************************************************************************
 *
 * FUNCTION NAME = GetAdapterConfig
 *
 * DESCRIPTION   = Determine the adapter type from SCREEN$
 *
 * INPUT         = NONE
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

USHORT PASCAL NEAR GetAdapterConfig(VOID)
{
  USHORT rc = 0;                       /* default no error                  */

  if (!(rc = videoIoctl(&SVGAHardware, NULL, SCREENDD_SVGA_ID)))
  {

    PartialSaveSize = 80L*25L*2;
    if (SVGAHardware.AdapterType)      /* if we have SVGA installed         */
    {
      rc = videoIoctl(&OEMHardware, NULL, SCREENDD_SVGA_OEM);   /*          */
    }
    else
    {
      SVGAHardware.AdapterType = DEFAULT_ADAPTER;
    }

  }
  return (rc);
}

/****************************************************************************
 *
 * FUNCTION NAME = SetAdapterMemory
 *
 * DESCRIPTION   = Update SCREEN$ with amount of video memory
 *
 * INPUT         = NONE
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL = NONE
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

USHORT PASCAL NEAR SetAdapterMemory(VOID)
{
  return videoIoctl(NULL,&SVGAHardware.Memory,  0x0a); //          
}

