/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*****************************************************************************
 *
 * SOURCE FILE NAME = bvhtype.h
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * NOTES
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define  INCL_DOSDEVIOCTL
#define  INCL_BASE                     /* ALL of OS/2 Base                  */
#include <os2.h>

#define INCL_16                 /*            */

/*
 * enable BVHVGA chaining @TSU00
 */
#define CHAIN_VGA


//c-begin
#include <svgadefs.h>
//c-end

/*
**    REALTO32BITADDR - seg:offet -> 32 bit address conversion
**             input:   a double word containing a segment:offset pair
**            output:   32 bit address
**
*/

#define MODE_NONE               0xFFFF
//c-begin
#define REALTO32BITADDR(a) ((((ULONG)HIUSHORT(a))<<4L) + ((ULONG)LOUSHORT(a)))
#define SVGA_PARTSAVESIZE       (1024L*8L)              /* partial buffer size */
#define VGA_PARTSAVESIZE        (80L*25L*2L)+256L*16L   /* partial buffer size */

//c-end

#define PVB_FONT_SIZE           (256*32)      /* space reqd for font in PVB */
#define PVB_FONT_ADDRESS        ((PBYTE)0xA0000L) /* font resides here      */
#define PVB_TEXT_SIZE           (0x4000)          /* max text buffer size */
#define PVB_TEXT_ADDRESS        ((PBYTE)0xB8000L) /* text resides here    */

#define SAVE                    0
#define RESTORE                 1
#define PALETTE_REGS            0x10
#define SAVEREST_HARDWARE       0x02
#define SAVEREST_FULLPVB        0x04
#define SAVEREST_PARTPVB        0x08
#define SAVEREST_VDM            0x10
#define VALID_SAVEREST_FLAG     ( SAVEREST_HARDWARE | SAVEREST_FULLPVB |\
                                  SAVEREST_PARTPVB  | SAVEREST_VDM )

#define MIN_PVB_BOTTOM          0xA0000L
#define MAX_PVB_TOP             0xC0000L     /*            */

/*
**      Environment Flags
*/

#define ENVFLAG_DEFAULT         0x0000
#define ENVFLAG_HARDWARE        0x0001
#define UPDATE_HARDWARE         ENVFLAG_HARDWARE
#define ENVFLAG_DOUBLESCANMODE  0x0002
#define ENVFLAG_BKGNDPALETTE    0x0004

#ifdef CHAIN_VGA          /* @TSU00 */
/*
 * mode is set by videopmi
 */
//#define ENVFLAG_PMIMODE         0x0008   //          
#define ENVFLAG_VGAMODE         0x0008     //          
#define ENVFLAG_BEFOREPMI       0x0010     //          
#endif

/*
**      Parms to AccessRegister
*/

#define SET                     0
#define GET                     1
#define SETWORD                 2


#define ATTADDRESSPORT          0x03C0
#define ATTDATAWRITEPORT        0x03C0
#define ATTDATAREADPORT         0x03C1

#define CRTMONOADDRPORT         0x03B4
#define CRTMONODATAPORT         0x03B5

#define ATT_MODE_CTRL           0x10
#define ATT_OVERSCAN_CLR        0x11


#define CRTCOLORADDRPORT        0x03D4
#define CRTCOLORDATAPORT        0x03D5

#define CRT_CURSOR_LOW_LOC      0x0F
#define CRT_CURSOR_HIGH_LOC     0x0E
#define CRT_CURSOR_START        0x0A
#define CRT_CURSOR_END          0x0B
#define CRT_UNDERSCORE          0x14

#define SEQADDRESSPORT          0x03C4
#define SEQDATAPORT             0x03C5

#define SEQ_RESET               0x00

#define GRAPHADDRESSPORT        0x03CE
#define GRAPHDATAPORT           0x03CF

#define MISCOUTPUTREGREAD       0x03CC
#define MISCOUTPUTREGWRITE      0x03C2
#define FEATURECONTROLREAD      0x03CA
#define FEATURECONTROLWRITE     0x03BA
#define VIDEOENABLEREG          0x03C3
#define DACADDRPORTWRITE        0x03C8
#define DACADDRPORTREAD         0x03C7
#define CRTCOLORADDRPORT        0x03D4
#define CRTCTLPORT1             0x03B8

#define COLORADJUSTMENT         0x20

/*
* Used in accesshardware()
*/
#define IS_ATT_CTRL_REG         1
#define IS_SEQ_REG              2

#define VERTSYNCEND_REG         0x11          /* vert retrace end reg index */

#define GET                     1
#define SET                     0
#define NO_MATCH                0xFFFF
#define UNSUPPORTED_FUNCTION    0
#define WRITEFUNCTION           4

#define NO_SIZE                 0L
#define NO_ATTRIBUTES           0
#define RESERVED_LONG           0L

#define RETURN_ERROR            (USHORT)0x2000  /* OpenMode bit mask        */
#define READ_AND_WRITE          (USHORT)0x0002
#define DENY_NONE               (USHORT)0x0040
#define NO_INHERIT              (USHORT)0x0080
#define OPEN_IF_EXISTS          0x0001          /* OpenFlag bit mask */

#define INIT_ERROR 1
/*
** Minimum structure lengths for VDH functions
*/

#define MINSLEN_SAVERESTOREENV   4
#define MINSLEN_CURSOR_POS       8
#define MINSLEN_CURSOR_TYPE     16
#define MINSLEN_VAR_BLINK        6
#define MINSLEN_VAR_OVERSCAN     8
#define MINSLEN_VAR_UNDERSCORE  10
#define MINSLEN_VAR_VIDEOENABLE 12
#define MINSLEN_VAR_DISPLAYMASK 16
#define MINSLEN_VAR_CODEPAGE    18
#define MINSLEN_VAR_SCROLLRECT  26
#define MINSLEN_VAR_SCREENDIM   30
#define MINSLEN_LVB_SIZE        14
#define MINSLEN_LVB_ATTRBUFSIZE 16
#define MINSLEN_LVB_ATTRBUFADDR 20

#define Config_Return_Length          2         /* RetConfigInfo */
#define MinDLen_Config_Adapter        4
#define MinDLen_Config_Display        6
#define MinDLen_Config_Memory         10
#define MinDLen_Config_ConfigNum      12
#define MinDLen_Config_Version        14
#define MinDLen_Config_Flag           16
#define MinDLen_Config_HWBufLen       20
#define MinDLen_Config_FullSaveSz     24
#define MinDLen_Config_PartSaveSz     28
#define MinDLen_Config_LEMAdapterdata 34
#define MinDLen_Config_EMAdapter      36
#define MinDLen_Config_LEMDisplaydata 38
#define MinDLen_Config_EMDisplay      40

#define WorldFormat             0x70    /* world attribute format       */
#define DefaultFormat           0x00    /* default attribute format     */
#define WorldAttrCount          0x03    /* world attribute count        */
#define DefaultAttrCount        0x01    /* default attribute count      */
#define WorldAttrMult           0x02    /* world attr save size multiplier */

#define CURSOR_TYPE      4
#define CURSOR_POSITION  2
#define VALID_CURSOR_FLAG (UPDATE_HARDWARE+CURSOR_TYPE+CURSOR_POSITION)

#define COLOURCLUT16_LENGTH     64
#define COLOURCLUT256_LENGTH    256
#define MONOCLUT16_LENGTH       64
#define MONOCLUT256_LENGTH      256


#define WORDS                   1
#define BYTES                   0

#define NONE                    0x00

#define BU_READCELLSTR          2
#define BU_WRITECELLSTR         7
#define BU_PVB_SEL_BIT          0x0001
#define BU_LVB_SEL_BIT          0x0002
#define BU_MAX_INDEX            12
#define BU_PARM_LENGTH          26

#define BLINK_BIT               0x08


#define LCD_GRAYSCALE_ADDR      0x09    /* Gray scale address reg           */
#define LCD_GRAYSCALE_DATA      0x0A    /* Gray scale data reg              */

#define MAX_FONT_SIZE   32
#define GET_ROM_FONT     2

#define Size8  0x0800
#define Size14 0x0E00
#define Size16 0x1000


#define NoBaseFont  0    /* ROM font index */
#define ROMFont8x8  0
#define ROMFont8x14 1
#define ROMFont9x14 2
#define ROMFont8x16 3
#define ROMFont9x16 4
#define ROM_FONTS   4

#define ROM_FONT    0
#define BIOSFONTSFOUND          0  /* return value from GetBiosFonts() */
#define NOBIOSFONTS             1  /* return value from GetBiosFonts() */
#define MAX_CODEPAGES 2
#define USER_FONT_SELECTABLE     (short)-1
#define USER_FONT_NOT_SELECTABLE (short)-2

#define VARIABLE_BLINK       0x02
#define VARIABLE_OVERSCAN    0x04
#define VARIABLE_UNDERSCORE  0x08
#define VARIABLE_VIDEOENABLE 0x10
#define VARIABLE_DISPLAYMASK 0x20
#define VARIABLE_CODEPAGE    0x40
#define VARIABLE_FORCECP     0x80                               /*      @P1 */
#define VARIABLE_SCROLLRECT  0x100                              /*      @P1 */
#define VARIABLE_SCREENDIM   0x200
#define VALID_VARIABLE_FLAG ( UPDATE_HARDWARE      + VARIABLE_BLINK      +\
                              VARIABLE_OVERSCAN    + VARIABLE_UNDERSCORE +\
                              VARIABLE_VIDEOENABLE + VARIABLE_DISPLAYMASK +\
                              VARIABLE_CODEPAGE    + VARIABLE_FORCECP    +\
                              VARIABLE_SCROLLRECT  + VARIABLE_SCREENDIM )

//c-begin
#ifdef EGA_BIT
#undef EGA_BIT
#endif
/* return values from getAdapterConfig() */
#define MPA_BIT           1      /* bit 0, MPA adapter with MONO monitor */
#define CGA_BIT           2      /* bit 1, CGA adapter with COLOR monitor */
#define EGM_BIT           4      /* bit 2, EGA adapter with MONO monitor  */
#define EGC_BIT           8      /* bit 3, EGA adapter with COLOR monitor */
#define EGA_BIT           0x10   /* bit 4, EGA adapter with ENHANCED COLOR monitor */
#define VGP_BIT           0x20   /* bit 5, VGA plasma display */
#define VGM_BIT           0x40   /* bit 6, VGA adapter with MONO monitor */
#define VGC_BIT           0x80   /* bit 7, VGA adapter with COLOR monitor  */
#define A8514M_BIT        0x100  /* bit 8, 8514A with 8507 monitor */
#define A8514C_BIT        0x200  /* bit 9, 8514A with 8512/3 monitor */
#define A8514A_BIT        0x400  /* bit 10, 8514A with 8514 monitor */
#define A8514_15_BIT      0x800  /* bit 11, 8514A with 8515 monitor */
#define A8514_03_BIT      0x1000 /* bit 12, 8514A with Monochrome 8503 monitor */
#define NODISPLAY_BIT     0x2000 /* bit 13, no display present on VGA system */
#define XGA_BIT           0x4000 /* bit 14, XGA adapter                 @T72 */
#define MONO_DISPLAYS     VGM_BIT + A8514M_BIT + A8514_03_BIT         /*@T73f*/
/*
**  Display types
*/

#define  PlasmaDisplay  0x0A    /*   VDHVGA               */
#define  Mono8503       0x03    /*   VDHVGA, VDH8514A     */
#define  Color8512_8513 0x04    /*   VDHVGA, VDH8514A     */
#define  Color8514      0x09    /*   VDH8514A             */
#define  EnColor5154    0x02    /*   VDHEGA               */
#define  Color5153      0x01    /*   VDHCGA, VDHEGA       */
#define  Mono5151       0x00    /*   VDHMPA, VDHEGA       */
#define  NoDisplay      -1      /*   VDHVGA with VDH8514A */
#define  Mono8507_8604  0x0B    /*   VDH8514A        */
#define  Color8515      0x0C    /*   VDH8514A        */
/*
**  Emulated Display types
*/

#define  EmDisp_8514A   0x1A18
#define  EmDisp_8514L   0x0018
#define  EmDisp_VGA     0x0418
#define  EmDisp_EGA     0x0004
#define  EmDisp_CGA     0x0002
#define  EmDisp_MPA     0x0001

/*
**  Emulated Adapter types
*/

#define EMULATE_TYPE_MPA    0x01
#define EMULATE_TYPE_CGA    0x02
#define EMULATE_TYPE_EGA    0x04
#define EMULATE_TYPE_VGA    0x08
#define EMULATE_TYPE_8514A  0x80
#define VDHERROR_NO_ADAPTER 0

/*
 * OEMHLP DevIoctl calls
 */
INT PASCAL NEAR OEMHLPIoctl(UCHAR *, UCHAR *, USHORT);

#define OEMHLP_CATEGORY      0x80  /* category number of OEMHLP.SYS IOCtl */
#define OEMHLPDD_NAME   "OEMHLP$"  /* name of OEMHLP device driver        */

#define OEMHLP_FUNCTION_VIDEO   2  /* OEMHLP video type ioctl */
#define OEMHLP_FUNCTION_FONTS   3  /* OEMHLP.SYS returns font information */
#define OEMHLP_FUNCTION_MISC    6  /* OEMHLP.SYS get Misc. State info */
#define OEMHLP_FUNCTION_ADAPTER 7  /* OEMHLP.SYS get adapter type */
#define MPA_DEVICE              1  /* bit information returned from */
#define CGA_DEVICE              2  /* OEMHLP_FUNCTION_ADAPTER call  */
#define EGA_DEVICE              4  /* to OEMHLP$                    */
#define VGA_DEVICE              8

/*
**  Adapter types
*/

#define TYPE_VGA                3

#define GETADAPTER_TYPE         6  /* parameter to DosDevIoctl */
#define VGA_MONO                7  /* return value of INT 10 function 1a */
#define VGA_COLOR               8  /* return value of INT 10 function 1a */
#define VGA_NODISPLAY           0  /* return value of INT 10 function 1a */

/*
** Type definitions
*/
typedef USHORT (APIENTRY FAR ENTRYPOINT)(VOID FAR *, VOID FAR *, ULONG);
typedef USHORT (APIENTRY FAR * FAR * ENTRYPOINTTABLE)(VOID FAR *, VOID FAR *, ULONG);
typedef unsigned char BYTE;
typedef unsigned char _far * PBYTE;

/*
** Structure Definitions for DevEnable
*/

typedef struct _DEVPARM1
        {
            ULONG       EngineVersion;
            ULONG       TableSize;
        } DEVPARM1, FAR * PDEVPARM1;

typedef struct _DEVPARM2
        {
            ULONG               FAR * Flags;
            ENTRYPOINTTABLE     CallVectorTable;
        } DEVPARM2, FAR * PDEVPARM2;

/*
**      WARNING: this structure is also defined in IDHEQU.INC, be sure
**               to update both structures when changing this one
*/
typedef struct _REGDATA
        {
            PBYTE       DataArea;
            USHORT      FirstEntry;
            USHORT      NumEntries;
        } REGDATA, FAR * PREGDATA;

typedef struct
        {
          USHORT Left;
          USHORT Top;
          USHORT Right;
          USHORT Bottom;
        } SCRLRECT;

typedef struct _REGADDRESS
        {
            USHORT      AddressPort;
            USHORT      DataPort;
            USHORT      ColorAdjust;
            USHORT      Flags;
        } REGADDRESS, FAR * PREGADDRESS;
typedef struct
        {
            USHORT      Length;
            USHORT      Flags;
            USHORT      Row;                    /* order of the fields important */
            USHORT      Column;                 /* see AccessCursorPos and AccessCursorType */
            USHORT      TopScanLine;
            USHORT      BottomScanLine;
            USHORT      Width;
            USHORT      Attribute;
        } VDH_CURSOR, FAR * PVDH_CURSOR;
typedef struct
        {
          USHORT Length;
          USHORT Flags;
          USHORT CellTableLen;
          USHORT CellTableOFF;
        } VDH_DBCS, FAR *PVDH_DBCS;

typedef struct
        {
            USHORT      TopScanLine;
            USHORT      BottomScanLine;
            USHORT      Attribute;
            USHORT      Position;               /* linear position in the video buffer, not x*y */
        } CURSOR;
typedef struct
        {
          UCHAR Red;
          UCHAR Green;
          UCHAR Blue;
        } CLUT_DATA, FAR * PCLUT_DATA;

typedef struct
        {
          USHORT far *DataArea;
          USHORT FirstEntry;
          USHORT NumEntries;
        } DATA2;

typedef struct
        {
          USHORT     Length;
          USHORT     Flags;
          DATA2      PaletteBuffer;
        } VDH_PALETTE, FAR *PVDH_PALETTE;

typedef struct
        {
          USHORT Length;
          USHORT Flags;
          USHORT Blink;
          USHORT Overscan;
          USHORT Underscore;
          USHORT VideoEnable;
          ULONG  DisplayMask;
          USHORT CodePageID;
          USHORT ScrlLeft;
          USHORT ScrlTop;
          USHORT ScrlRight;
          USHORT ScrlBottom;
          USHORT ScreenRows;
          USHORT ScreenCols;
        } VDH_VARIABLE, FAR *PVDH_VARIABLE;

typedef struct
        {
          USHORT   Length;
          USHORT   Flags;
          PCLUT_DATA LookupTable;    /* 0x00 - 0xFF */
          USHORT   FirstEntry;
          USHORT   NumEntries;
        } VDH_CLUT, FAR *PVDH_CLUT;

typedef struct _VDH_BUFUP
        {
            USHORT      Length;
            USHORT      Flags;
            UCHAR far * AppDataAddr;
            UCHAR far * AppCellAddr;
            USHORT      Index;
            USHORT      StartRow;
            USHORT      StartCol;
            USHORT      SecondRow;
            USHORT      SecondCol;
            USHORT      RepeatFactor;
            USHORT      LogicalBufSel;
        } VDH_BUFUP, FAR * PVDH_BUFUP;

typedef struct
        {
          USHORT     Length;
          USHORT     Flags;
          UCHAR      FormatId;
          UCHAR      AttrCount;
          USHORT     LVBWidth;
          USHORT     LVBHeight;
          ULONG      LVBSize;
          USHORT     AttrBufSize;
          UCHAR far *AttrBufAddr;
        } VDH_LVB, FAR * PVDH_LVB;

#undef VIOPHYSBUF
#undef PVIOPHYSBUF
struct _VDHVIOPHYSBUF {    /* viopb */
        PBYTE    pBuf;
        ULONG    cb;
        SEL      asel[16]; /* Definitely no greater than 16 selectors */
        };
#define VIOPHYSBUF struct _VDHVIOPHYSBUF
#define PVIOPHYSBUF VIOPHYSBUF FAR *

typedef struct
        {                   /* alternate VIOPHYSBUF structure used */
          USHORT      cb;          /* if 0 length passed in primary       */
          SEL         asel[2];     /* VIOPHYSBUF structure                */
        } ALT_VIOPHYSBUF, FAR * PALT_VIOPHYSBUF;

typedef struct
        {
            USHORT      Length;
            USHORT      Flags;
            USHORT      LDTSelector;
        } VDH_FREEPVB, FAR * PVDH_FREEPVB;

typedef struct
        {   USHORT      Length;
            USHORT      Flags;
            PVIOPHYSBUF PVBDataPTR;
        } VDH_GETPVB, FAR * PVDH_GETPVB;
/*
** Font support
*/
typedef struct
        {
            USHORT      Length;
            USHORT      Flags;
            PBYTE       FontBuffer;
            USHORT      FontLength;
            USHORT      PelColumns;
            USHORT      PelRows;
        } VDH_FONT, FAR * PVDH_FONT;

typedef struct
        {
           USHORT  ffh_length;     /* Length of Header             */
           USHORT  ffh_flags;      /* CodePage File flags          */
           USHORT  ffh_ptroffset;  /* Offset of first font pointer */
           USHORT  ffh_numfonts;   /* Number of fonts in the file  */
        } FONTFILEHDR;

typedef struct
        {
           USHORT  fh_length;      /* Length of Font Entry         */
           USHORT  fh_hdrlen;      /* Length of Header             */
           USHORT  fh_cpid;        /* CodePage File flags          */
           USHORT  fh_type;        /* Font Type                    */
           USHORT  fh_flags;       /* Font Flags                   */
           UCHAR   fh_cellcols;    /* Columns in character cell    */
           UCHAR   fh_cellrows;    /* Rows in character cell       */
           UCHAR   fh_basecols;    /* Columns in base cell         */
           UCHAR   fh_baserows;    /* Rows in base cell            */
           USHORT  fh_dataoffset;  /* Font data offset from header */
           USHORT  fh_datalen;     /* Length of the font data      */
           USHORT  fh_numpoints;   /* Number of code points        */
           USHORT  fh_lowpoint;    /* Lowest code point            */
           USHORT  fh_highpoint;   /* Highest code point           */
        } FONTHDR;

struct part
{
  USHORT Offset;
  USHORT Selector;
};

typedef union _FARADDRESS
        {
        UCHAR FAR * FullAddress;
        struct part  Part;
        } FARADDRESS;

typedef union
        {
          struct  part p;
          PFONTDATA ptr;
        } cp_addr;

typedef struct
        {
          PFONTDATA FontPTR;
          PFONTDATA BaseFontPTR;
          USHORT    CodePageID;
          UCHAR     BaseRows;
          UCHAR     BaseColumns;
        } ROMCP_TABLE;

typedef struct
        {
          USHORT     PVBLen;    /* Length = height * 256 = 0x(height)00 */
          USHORT     Partner;   /* Table index to base font        */
          cp_addr    PVB;       /* Physical starting address, FONTDATA format*/
        } FONTBUFFER;
typedef union
        {
          struct part p;
          ROMCP_TABLE *ptr;
        } rcp_addr;

typedef struct _VDHSAVEREST
        {
          USHORT      Length;
          USHORT      Flags;
          USHORT      PVBHugeSEL;
        } VDHSAVEREST, FAR * PVDHSAVEREST;

typedef struct _CLUT
        {
          ULONG ulRGBCount;             /* No of aRGB entries that follow   */
          ULONG ulRGBStart;             /* Start index for RGB triplets     */
          SVGARGB aRGB[COLOURCLUT256_LENGTH];
        } CLUT, FAR * PCLUT;

typedef struct _CHARATTRIBS
        {
          USHORT Blink;
          USHORT Overscan;
          USHORT Underscore;
          BYTE   XCharSize;     /* char cell width                  */
          BYTE   YCharSize;     /* char cell height                 */
        } CHARATTRIBS;
/*
** VIDEOPMI.DLL has a table of VIDEOMODEINFO modes. Our internal mode
** table of type VIDEOMODE has to have few additional fields.
** VIDEOMODE is a superset of the VDHMODEINFO used by VIO.
*/
typedef struct _VIDEOMODE
        {                              /* VioGetMode structure starts      */
            USHORT      cb;
            BYTE        fbType;
            BYTE        color;
            USHORT      col;
            USHORT      row;
            USHORT      hres;
            USHORT      vres;
            BYTE        fmt_ID;        /* DBCS support */
            BYTE        attrib;
            UCHAR       FAR * BufferAddress;
            ULONG       BufferLength;
            ULONG       ulTotalSize;   /* total bytes of VRAM to save      */
                                       /* VioGetMode structure ends        */
            ULONG       ulPageLength;  /* no of bytes to save a plane      */
            MODEID      miModeId;      /* used to make setmode request     */
            BYTE        XCharSize;     /* char cell width                  */
            BYTE        YCharSize;     /* char cell height                 */
            /*
            **            adding display entries.
            */
            BYTE    bVrtRefresh;
            BYTE    bHrtRefresh;
            BYTE    bVrtPolPos;
            BYTE    bHrtPolPos;
            USHORT  usScrnTop;
            USHORT  usScrnBottom;
            USHORT  usScrnLeft;
            USHORT  usScrnRight;

        } VIDEOMODE, FAR * PVIDEOMODE;

/*
** Do not modify this structure. BufferUpdate function from BVHVGA is
** expecting the scrolling rectangle to follow the mode data in the
** environment buffer and has hardcoded BVHVGA structure offsets!
*/
typedef struct _VDHMODEINFO
        {           /* VioMode structure                                    */
            USHORT      cb;
            BYTE        fbType;
            BYTE        color;
            USHORT      col;
            USHORT      row;
            USHORT      hres;
            USHORT      vres;
            UCHAR       fmt_ID;
            UCHAR       attrib;
            UCHAR       FAR * BufferAddress;
            ULONG       BufferLength;
            ULONG       FullBufferSize;
            ULONG       PartialBufferSize;
            UCHAR       FAR * ExtDataArea;
        } VDHMODEINFO, FAR * PVDHMODEINFO;

typedef struct _VDH_MODE
        {
            USHORT       Length;
            USHORT       Flags;
            PVDHMODEINFO pVDHModeInfo;
        } VDH_MODE, FAR * PVDH_MODE;

typedef struct _VDHCONFIGINFO
        {
            USHORT      cb;
            USHORT      adapter;
            USHORT      display;
            ULONG       cbMemory;
            USHORT      Configuration;
            USHORT      DeviceDriver;
            USHORT      Flags;
            ULONG       HWBufferSize;
            ULONG       FullSaveSize;
            ULONG       PartSaveSize;
            USHORT      EMAdaptersOFF;
            USHORT      EMDisplaysOFF;
            USHORT      LEMAdapterdata;
            USHORT      EMAdapters;
            USHORT      LEMDisplaydata;
            USHORT      EMDisplays;
        } VDHCONFIGINFO, FAR * PVDHCONFIGINFO;

typedef struct _VDHCONFIG
        {
            USHORT              Length;
            USHORT              Flags;
            PVDHCONFIGINFO      ConfigDataPTR;
        } VDHCONFIG, FAR * PVDHCONFIG;
/*
** Environment contains one structure of unknown size, HardwareState.
** The size is known once the VIDEOPMI is loaded, so RetConfigInfo will
** return the overall Environment size, adjusted for the HardwareState.
** WARNING: ModeDataOFF and ScrollRect must be where they are due to the
** buffer update code which is imported from bvhvga without modifications.
** Dependency disctated by vdhstruc.inc and xgabufup.asm.
*/
typedef struct _ENVIRONMENT
{
  USHORT      ModeDataOFF;            /* used by the scrolling funcs */
  USHORT      ModeIndex;              /* current mode index (bgnd or fgnd) */
                                      /* WARNING: keep these two together */
  VDHMODEINFO ModeData;               /* current mode parameters */
  SCRLRECT    ScrollRect;             /* Scrollable rectangle of text screen */
  USHORT      VideoEnable;            /* state of the video enable */
  PFONTDATA   pFontData;              /* current font data pointer */
  USHORT      EnvFlags;               /* flags */
  // The above are the same as the environment for bvhvga.dll

  CLUT        LookupTable;            /* current CLUT */
  BYTE        bPaletteData[PALETTE_REGS]; /* current palette registers */
  CURSOR      Cursor;                 /* current cursor */
  CHARATTRIBS CharAttrib;             /* current character attributes */
  USHORT      CodePageID;             /* xxx - SELECTABLE, 0 NOT_SELECTABLE */
  SHORT       UserFont;               /* -1  - SELECTABLE, -2 NOT_SELECTABLE */
  USHORT      NumUSERFonts;
  SEL         USERFontSel;            /* USER fonts selector, FONTDATA format */
  USHORT      AttrBufSize;            /* Byte in an attribute for cur mode   */
  UCHAR       AttrBuf[4];             /* default attribute for current mode  */
  USHORT      CurrentCFGIndex;        /*            Index into current cfg table */
  BYTE        bHardwareStateData[1];  /* hardware state starts here */
} ENVIRONMENT, FAR * PENVIRONMENT;
/*
**   Macros
*/

#define SEG(fp)                 (*((USHORT *)&(fp) + 1))
#define OFFSET(fp)              (USHORT)(&(fp))
#define MAKEFARPTR(sel,off)     ((PBYTE)((((ULONG)(sel))<<16)+(ULONG)(off)))

/*
** Data Definitions
*/

#define INT3()                  _asm{int 3}

#define MaxConfigs              16

#define FnFillLogicalDevBlock   1L
#define FnFillInitDevBlock      3L

#define FnTextBufferUpdate      256L
#define FnInitializeEnvironment 257L
#define FnSaveEnvironment       258L
#define FnRestoreEnvironment    259L
#define FnReturnConfigInfo      260L
#define FnGetDBCSDisplayInfo    261L
#define FnGetColorLookupTable   262L
#define FnSetColorLookupTable   263L
#define FnGetCursorInfo         264L
#define FnSetCursorInfo         265L
#define FnGetFont               266L
#define FnSetFont               267L
#define FnGetMode               268L
#define FnSetMode               269L
#define FnGetPaletteRegisters   270L
#define FnSetPaletteRegisters   271L
#define FnGetPhysBuf            272L
#define FnFreePhysBuf           273L
#define FnGetVariableInfo       274L
#define FnSetVariableInfo       275L
#define FnExtendedVioCall       276L
#define FnPrintScreen           277L
#define FnWriteTTY              278L
#define FnGetLVBInfo            279L

#define MaxFn                   (FnGetLVBInfo-FnTextBufferUpdate+1)

#define ChainedBufferUpdate     (*ChainedEntryPoint[0])
#define ChainedInitEnv          (*ChainedEntryPoint[1])
#define ChainedSaveEnv          (*ChainedEntryPoint[2])
#define ChainedRestoreEnv       (*ChainedEntryPoint[3])
#define ChainedRetConfigInfo    (*ChainedEntryPoint[4])
#define ChainedGetDBCSInfo      (*ChainedEntryPoint[5])
#define ChainedGetColorLookup   (*ChainedEntryPoint[6])
#define ChainedSetColorLookup   (*ChainedEntryPoint[7])
#define ChainedGetCursorInfo    (*ChainedEntryPoint[8])
#define ChainedSetCursorInfo    (*ChainedEntryPoint[9])
#define ChainedGetCurrentFont   (*ChainedEntryPoint[10])
#define ChainedSetCurrentFont   (*ChainedEntryPoint[11])
#define ChainedGetMode          (*ChainedEntryPoint[12])
#define ChainedSetMode          (*ChainedEntryPoint[13])
#define ChainedGetPaletteReg    (*ChainedEntryPoint[14])
#define ChainedSetPaletteReg    (*ChainedEntryPoint[15])
#define ChainedGetPhysBuf       (*ChainedEntryPoint[16])
#define ChainedFreePhysBuf      (*ChainedEntryPoint[17])
#define ChainedGetVarInfo       (*ChainedEntryPoint[18])
#define ChainedSetVarInfo       (*ChainedEntryPoint[19])
#define ChainedExtVioCall       (*ChainedEntryPoint[20])
#define ChainedPrintScreen      (*ChainedEntryPoint[21])
#define ChainedWriteTTY         (*ChainedEntryPoint[22])
#define ChainedGetLVBInfo       (*ChainedEntryPoint[23])

#define FnChainedBufUpdate      0
#define FnChainedRetConfigInfo  4

#if DEBUG

typedef struct _DEBUGDATA
      {

        BYTE    inuse;
        CHAR    * name;
      } DEBUGDATA, FAR * PDEBUGDATA;

void pascal far DPRINTF(char far *);
#endif

#define CFG_INDEX_SET   0x1000  //          
#define CFG_INDEX_MASK  0x0FFF  //          
/*
** Global data prototypes
*/
extern SEL     selBVHTable;                  /* global mode table selector */
extern ULONG ulMaxListSize;                   /* maximum size of the hardware command list */
extern VIDEO_ADAPTER Adapter;                 /* Adapter instance */
extern PFNVIDEOPMIREQUEST pfnPMIRequest;/* PMI request entry point into VIDEOPMI */
extern ULONG ulTotalVideoModes;               /* Total number of video modes */

#ifdef  CHAIN_VGA  /*  @TSU00  */
extern ULONG ulEnvLength;                     /* @TSU Environment length */
extern ENTRYPOINT FAR  ChainRouter;
extern BOOL fPMINotTried;
#endif

extern BOOL f32bModLoaded;
extern BOOL fNoVideopmi;     /* @TSU00 */
extern ULONG ulTotalMemory;       /* @TSU00 */
extern OEMSVGAINFO BVHHardware;
extern BOOL InitDone;
extern USHORT HugeShift;
extern SEL GlobalInfoSeg;
extern ENTRYPOINT FAR *ChainedEntryPoint[];
extern ENTRYPOINT FAR *BVHEntryPoint[];
extern ENTRYPOINT DebugRouter;
extern OEMINFO OEMHardware;
extern PVIDEOMODE pModes;
extern ULONG PartialSaveSize;
extern CLUT ColourCLUT16;
extern CLUT ColourCLUT256;
extern CLUT MonoCLUT16;
extern CLUT MonoCLUT256;
extern USHORT ROMCP_NUM;               /* number of fonts in table          */
extern rcp_addr RomCP_tbl;             /* table for CP and ROM font info    */
extern cp_addr CodePage;               /* buffer for codepage fonts         */
extern UCHAR CodePageSupport;          /* flag for codepage support         */
extern FONTBUFFER Fonts[];
extern UCHAR DefaultAttribute[];
extern USHORT CurrentDisplay;
extern BOOL   fCurrentCfg;   /* set to TRUE if there is monitor cfg data */
extern MONITORINFO CurrentMonitor;
#if      DEBUG
extern DEBUGDATA DebugFn[];
#endif
/*
** Internal handler function prototypes
*/
/*
** bvhmain.c
*/
/*
** Function Definitions for Functions Chained by this BVH
*/
extern ENTRYPOINT DevEnable;
extern ENTRYPOINT InitEnv;
extern ENTRYPOINT SaveEnv;
extern ENTRYPOINT RestoreEnv;
extern ENTRYPOINT RetConfigInfo;
extern ENTRYPOINT GetMode;
extern ENTRYPOINT SetMode;
extern ENTRYPOINT GetFont;
extern ENTRYPOINT SetFont;
extern ENTRYPOINT GetPaletteReg;
extern ENTRYPOINT SetPaletteReg;
extern ENTRYPOINT GetColorLookup;
extern ENTRYPOINT SetColorLookup;
extern ENTRYPOINT TerminateEnv;
extern ENTRYPOINT BufferUpdate;
extern ENTRYPOINT GetPhysBuf;
extern ENTRYPOINT FreePhysBuf;
extern ENTRYPOINT GetLVBInfo;
extern ENTRYPOINT SetCursorInfo;
extern ENTRYPOINT GetCursorInfo;
extern ENTRYPOINT GetVariableInfo;
extern ENTRYPOINT SetVariableInfo;
extern ENTRYPOINT GetDBCSInfo;
/*
** bvhsubs.c
*/
APIRET LoadBVHHandler(PFNVIDEOPMIREQUEST *);
APIRET InitializeBVH(PULONG,PULONG,SEL *);
APIRET SetAccessToPMI(VOID);
USHORT APIENTRY FAR BVHAccessFont(USHORT,PFONTDATA);
VOID  APIENTRY FAR BVHAccessCLUT(USHORT,PCLUT);
VOID  APIENTRY FAR BVHAccessPalette(USHORT,PPALETTEDATA);
VOID  APIENTRY FAR BVHSaveRestoreState(USHORT,PENVIRONMENT,PVDHSAVEREST);
VOID  APIENTRY FAR BVHSetBank(USHORT,ULONG);
USHORT NEAR PhysToUVirt(FARADDRESS,FARADDRESS FAR *,USHORT);
VOID NEAR FreePhysToUVirt(USHORT);
USHORT PASCAL NEAR BVHGetMem(VOID FAR *, USHORT );
USHORT PASCAL NEAR BVHFreeMem(VOID FAR **);
INT PASCAL NEAR SCREENDDIoctl(VOID *,VOID *,USHORT );
PENVIRONMENT VGA_ENV(PENVIRONMENT);   //          


  UCHAR *data,*parm;
  unsigned function;
USHORT PASCAL NEAR GetAdapterConfig(VOID);

/*
** bvhiopl.asm
*/
BYTE    EXPENTRY HWInpByte(USHORT);
USHORT  EXPENTRY HWInpWord(USHORT);
VOID    EXPENTRY HWOutpByte(USHORT, BYTE);
VOID    EXPENTRY HWOutpWord(USHORT, USHORT);
VOID PASCAL FAR SetDiamondClk(USHORT,USHORT,USHORT);
VOID PASCAL FAR SetNumber9Clk(USHORT);
USHORT FAR WDPanelOn( VOID );                    /*          */
VOID FAR WDSetPanelClk( VOID );                  /*          */
USHORT FAR ThinkPadHighestRes(VOID);             //          

/*
** bvhaccs.c
*/
VOID PASCAL NEAR MAKE32P(USHORT,USHORT,ULONG FAR *);
VOID PASCAL NEAR AccessRegister(PREGADDRESS,USHORT,PVOID);
VOID PASCAL NEAR AccessHardware(PREGADDRESS,USHORT,USHORT,USHORT,PREGDATA);
VOID PASCAL NEAR AccessCursorPos(  USHORT, USHORT, USHORT, PVDH_CURSOR);
VOID PASCAL NEAR AccessCursorType( USHORT, USHORT, PVDH_CURSOR);
VOID PASCAL NEAR AccessBlink(      USHORT, USHORT, USHORT FAR *);
VOID PASCAL NEAR AccessOverscan(   USHORT, USHORT, USHORT FAR *);
VOID PASCAL NEAR AccessUnderscore( USHORT, USHORT, USHORT FAR *);
VOID PASCAL NEAR AccessVideoEnable(USHORT,USHORT,USHORT FAR *);
USHORT PASCAL NEAR HardwareColor(VOID);

/*
** bvhmode.c
*/
USHORT NEAR SetBVHMode(PENVIRONMENT,PVDHMODEINFO,USHORT);
USHORT NEAR GetBVHMode(PENVIRONMENT,PVDHMODEINFO,USHORT);
VOID NEAR SetupTridentRegisters(VOID);
VOID NEAR FixBVHRegisters(PENVIRONMENT);
USHORT PASCAL NEAR SetHWMode(PENVIRONMENT,USHORT,USHORT);
VOID PASCAL NEAR SetEnvMode(PENVIRONMENT,USHORT,PVDHMODEINFO,USHORT);
USHORT NEAR AdjustModeLen(USHORT *);

/*
** bvhfont.c
*/
USHORT FindFont(PENVIRONMENT,PVDH_FONT);
USHORT PASCAL NEAR SetHWFont(PENVIRONMENT);
USHORT PASCAL NEAR SearchFont(PENVIRONMENT,PVIDEOMODE,PVDHMODEINFO);
USHORT PASCAL NEAR GetCodePage(VOID);
USHORT PASCAL NEAR GetBIOSFonts(VOID);
USHORT PASCAL NEAR GetROMFonts(VOID);
USHORT PASCAL NEAR GetAccessToFonts(VOID);
USHORT PASCAL NEAR CopyGlobalFontTable(FONTBUFFER *);
VOID PASCAL NEAR SetupEnvCodePage(PENVIRONMENT);
USHORT FindCPFont(PENVIRONMENT,USHORT,USHORT,USHORT);
//c-end
