/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = bvhdata.c
 *
 * DESCRIPTIVE NAME = Global data
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION Global data
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS: GetAdapterConfig
 *
 * DEPENDENCIES:  vdhvga
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define  INCL_OS2STD                   /* Needed for NULL definition in OS2STD.H */
#include "bvhtype.h"

#if      DEBUG
  #define  STATIC                      /* nothing                           */
#else
  #define  STATIC        static
#endif

/*
** Global variables - data shared by more than one BVH routine
*/


BOOL f32bModLoaded = FALSE, fNoVideopmi = TRUE;
BOOL fPMINotTried = TRUE;  //          
/*
 * only AdpterType field is used in SetDiamondClk @TSU00
 */
OEMSVGAINFO BVHHardware =
{
  0,                                   /* adapter type */
  0,                                   /* chip type */
  1024L*1024L                          /* installed memory */
};
int _acrtused = 0;
BOOL InitDone = FALSE;
UCHAR DefaultAttribute[] = {0x07,0x0,0x0};/* default attribute used by WrtTTY  */
PVIDEOMODE pModes = NULL;
VIDEO_ADAPTER Adapter;                 /* Adapter Instance               */
ULONG ulMaxListSize = 0;  /* Maximum size required for hardware command list */
PFNVIDEOPMIREQUEST pfnPMIRequest;     /* PMI request entry point into VIDEOPMI */
SEL     selBVHTable;                  /* mode table selector */
USHORT CurrentDisplay = NoDisplay;
ULONG ulTotalVideoModes = 0;           /* Total number of video modes */
MONITORINFO    CurrentMonitor = {"",{0}};
BOOL   fCurrentCfg = FALSE;   /* flag TRUE if there is monitor cfg data */
#ifdef  CHAIN_VGA   /* @TSU00 */
// ULONG ulEnvLength;    /* @TSU Environment length */            
ULONG ulEnvLength = sizeof(ENVIRONMENT); /* Environment length              */
#endif
/*
 * total video memory installed, obtained from PMI file.
 */
ULONG ulTotalMemory = 1024L*1024L;       /* installed memory */

OEMINFO OEMHardware =
{
  10,                                  /* Length  */
  0,                                   /* Manufacturer */
  0L,                                  /* Manufacturer data */
};

USHORT SVGAMonitorType = 0xffff;

USHORT HugeShift = 0;
SEL GlobalInfoSeg = NULL;

/*
** Font support
*/
USHORT ROMCP_NUM;                       /* number of fonts in table          */
rcp_addr RomCP_tbl;                     /* table for CP and ROM font info    */
cp_addr CodePage;                       /* buffer for codepage fonts         */
UCHAR CodePageSupport;                  /* flag for codepage support         */
FONTBUFFER Fonts[] =                    /* ROM fonts */
{
 { Size8,  NoBaseFont ,NULL  },          /* 8x8 ROM */
 { Size14, NoBaseFont ,NULL  },          /* 8x14 ROM */
 { Size14, ROMFont8x14,NULL  },         /* 9x14 ROM */
 { Size16, NoBaseFont ,NULL  },          /* 8x16 ROM */
 { Size16, ROMFont8x16,NULL  }          /* 9x16 ROM */
};

#ifdef CHAIN_VGA    /* @TSU00 */
/*
** Table of Default BVH entry points
*/
ENTRYPOINT FAR *ChainedEntryPoint[MaxFn] = {0}, ChainRouter;
#endif

/*
**
** Table of BVH entry points supported
**
*/

ENTRYPOINT FAR *BVHEntryPoint[MaxFn] =
{
#ifdef CHAIN_VGA    /* @TSU00 */
  & ChainRouter,                       /* (256) Text Buffer Update          */
#else
  & BufferUpdate,                      /* (256) Text Buffer Update          */
#endif
  & InitEnv,                           /* (257) Initialise Environment      */
  & SaveEnv,                           /* (258) Save Environment            */
  & RestoreEnv,                        /* (259) Restore Environment         */
  & RetConfigInfo,                     /* (260) Return Config Info          */
  & GetDBCSInfo,                       /* (261) Get DBCS Display Info       */
  & GetColorLookup,                    /* (262) Get Colour Lookup Table     */
  & SetColorLookup,                    /* (263) Set Colour Lookup Table     */
  & GetCursorInfo,                     /* (264) Get Cursor Info             */
  & SetCursorInfo,                     /* (265) Set Cursor Info             */
  & GetFont,                           /* (266) Get Font                    */
  & SetFont,                           /* (267) Set Font                    */
  & GetMode,                           /* (268) Get Mode                    */
  & SetMode,                           /* (269) Set Mode                    */
  & GetPaletteReg,                     /* (270) Get Palette Registers       */
  & SetPaletteReg,                     /* (271) Set Palette Registers       */
  & GetPhysBuf,                        /* (272) Get Phys Buff               */
  & FreePhysBuf,                       /* (273) Free Phys Buff              */
  & GetVariableInfo,                   /* (274) Get Variable Info           */
  & SetVariableInfo,                   /* (275) Set Variable Info           */
  & TerminateEnv,                      /* (276) Terminate Environment       */
#ifdef CHAIN_VGA    /* @TSU00 */
  & ChainRouter,                       /* (277) Print Screen                */
  & ChainRouter,                       /* (278) Write TTY                   */
#else
  UNSUPPORTED_FUNCTION,                /* (277) Print Screen                */
  UNSUPPORTED_FUNCTION,                /* (278) Write TTY                   */
#endif
  & GetLVBInfo,                        /* (279) Get LVB Info                */
} ;

#if      DEBUG
ENTRYPOINT DebugRouter;
DEBUGDATA DebugFn[] =
{
  { 0, "BufferUpdate\\n" } ,
  { 0, "InitializeEnvironment\\n" } ,
  { 0, "SaveEnvironment\\n" } ,
  { 0, "RestoreEnvironment\\n" } ,
  { 0, "ReturnConfigInfo\\n" } ,
  { 0, "GetDBCSDisplayInfo\\n" } ,
  { 0, "GetColorLookupTable\\n" } ,
  { 0, "SetColorLookupTable\\n" } ,
  { 0, "GetCursorInfo\\n" } ,
  { 0, "SetCursorInfo\\n" } ,
  { 0, "GetFont\\n" } ,
  { 0, "SetFont\\n" } ,
  { 0, "GetMode\\n" } ,
  { 0, "SetMode\\n" } ,
  { 0, "GetPaletteRegisters\\n" } ,
  { 0, "SetPaletteRegisters\\n" } ,
  { 0, "GetPhysBuf\\n" } ,
  { 0, "FreePhysBuf\\n" } ,
  { 0, "GetVariableInfo\\n" } ,
  { 0, "SetVariableInfo\\n" } ,
  { 0, "ExtendedVioCall\\n" } ,
  { 0, "PrintScreen\\n" } ,
  { 0, "WriteTTY\\n" } ,
  { 0, "GetLVBInfo\\n" } ,

};

#endif                                 /* DEBUG */

/*
**
**                      Colour Lookup Tables
**
*/

CLUT ColourCLUT16 =
{
  COLOURCLUT16_LENGTH,0,
  {
  { 0x00, 0x00, 0x00 } ,
  { 0x00, 0x00, 0x2A } ,
  { 0x00, 0x2A, 0x00 } ,
  { 0x00, 0x2A, 0x2A } ,
  { 0x2A, 0x00, 0x00 } ,
  { 0x2A, 0x00, 0x2A } ,
  { 0x2A, 0x2A, 0x00 } ,
  { 0x2A, 0x2A, 0x2A } ,
  { 0x00, 0x00, 0x15 } ,
  { 0x00, 0x00, 0x3F } ,
  { 0x00, 0x2A, 0x15 } ,
  { 0x00, 0x2A, 0x3F } ,
  { 0x2A, 0x00, 0x15 } ,
  { 0x2A, 0x00, 0x3F } ,
  { 0x2A, 0x2A, 0x15 } ,
  { 0x2A, 0x2A, 0x3F } ,
  { 0x00, 0x15, 0x00 } ,
  { 0x00, 0x15, 0x2A } ,
  { 0x00, 0x3F, 0x00 } ,
  { 0x00, 0x3F, 0x2A } ,
  { 0x2A, 0x15, 0x00 } ,
  { 0x2A, 0x15, 0x2A } ,
  { 0x2A, 0x3F, 0x00 } ,
  { 0x2A, 0x3F, 0x2A } ,
  { 0x00, 0x15, 0x15 } ,
  { 0x00, 0x15, 0x3F } ,
  { 0x00, 0x3F, 0x15 } ,
  { 0x00, 0x3F, 0x3F } ,
  { 0x2A, 0x15, 0x15 } ,
  { 0x2A, 0x15, 0x3F } ,
  { 0x2A, 0x3F, 0x15 } ,
  { 0x2A, 0x3F, 0x3F } ,
  { 0x15, 0x00, 0x00 } ,
  { 0x15, 0x00, 0x2A } ,
  { 0x15, 0x2A, 0x00 } ,
  { 0x15, 0x2A, 0x2A } ,
  { 0x3F, 0x00, 0x00 } ,
  { 0x3F, 0x00, 0x2A } ,
  { 0x3F, 0x2A, 0x00 } ,
  { 0x3F, 0x2A, 0x2A } ,
  { 0x15, 0x00, 0x15 } ,
  { 0x15, 0x00, 0x3F } ,
  { 0x15, 0x2A, 0x15 } ,
  { 0x15, 0x2A, 0x3F } ,
  { 0x3F, 0x00, 0x15 } ,
  { 0x3F, 0x00, 0x3F } ,
  { 0x3F, 0x2A, 0x15 } ,
  { 0x3F, 0x2A, 0x3F } ,
  { 0x15, 0x15, 0x00 } ,
  { 0x15, 0x15, 0x2A } ,
  { 0x15, 0x3F, 0x00 } ,
  { 0x15, 0x3F, 0x2A } ,
  { 0x3F, 0x15, 0x00 } ,
  { 0x3F, 0x15, 0x2A } ,
  { 0x3F, 0x3F, 0x00 } ,
  { 0x3F, 0x3F, 0x2A } ,
  { 0x15, 0x15, 0x15 } ,
  { 0x15, 0x15, 0x3F } ,
  { 0x15, 0x3F, 0x15 } ,
  { 0x15, 0x3F, 0x3F } ,
  { 0x3F, 0x15, 0x15 } ,
  { 0x3F, 0x15, 0x3F } ,
  { 0x3F, 0x3F, 0x15 } ,
  { 0x3F, 0x3F, 0x3F } ,
  }
};

CLUT MonoCLUT16 =
{
  MONOCLUT16_LENGTH,0,
  {
  { 0x00, 0x00, 0x00 } ,
  { 0x05, 0x05, 0x05 } ,
  { 0x11, 0x11, 0x11 } ,
  { 0x1C, 0x1C, 0x1C } ,
  { 0x08, 0x08, 0x08 } ,
  { 0x0B, 0x0B, 0x0B } ,
  { 0x25, 0x25, 0x25 } ,
  { 0x28, 0x28, 0x28 } ,
  { 0x02, 0x02, 0x02 } ,
  { 0x07, 0x07, 0x07 } ,
  { 0x1B, 0x1B, 0x1B } ,
  { 0x20, 0x20, 0x20 } ,
  { 0x0F, 0x0F, 0x0F } ,
  { 0x14, 0x14, 0x14 } ,
  { 0x28, 0x28, 0x28 } ,
  { 0x2C, 0x2C, 0x2C } ,
  { 0x0C, 0x0C, 0x0C } ,
  { 0x11, 0x11, 0x11 } ,
  { 0x25, 0x25, 0x25 } ,
  { 0x2A, 0x2A, 0x2A } ,
  { 0x14, 0x14, 0x14 } ,
  { 0x1E, 0x1E, 0x1E } ,
  { 0x32, 0x32, 0x32 } ,
  { 0x36, 0x36, 0x36 } ,
  { 0x0F, 0x0F, 0x0F } ,
  { 0x13, 0x13, 0x13 } ,
  { 0x27, 0x27, 0x27 } ,
  { 0x2C, 0x2C, 0x2C } ,
  { 0x1B, 0x1B, 0x1B } ,
  { 0x20, 0x20, 0x20 } ,
  { 0x34, 0x34, 0x34 } ,
  { 0x39, 0x39, 0x39 } ,
  { 0x06, 0x06, 0x06 } ,
  { 0x0B, 0x0B, 0x0B } ,
  { 0x1F, 0x1F, 0x1F } ,
  { 0x24, 0x24, 0x24 } ,
  { 0x13, 0x13, 0x13 } ,
  { 0x18, 0x18, 0x18 } ,
  { 0x2C, 0x2C, 0x2C } ,
  { 0x30, 0x30, 0x30 } ,
  { 0x09, 0x09, 0x09 } ,
  { 0x0D, 0x0D, 0x0D } ,
  { 0x21, 0x21, 0x21 } ,
  { 0x26, 0x26, 0x26 } ,
  { 0x15, 0x15, 0x15 } ,
  { 0x1A, 0x1A, 0x1A } ,
  { 0x2E, 0x2E, 0x2E } ,
  { 0x33, 0x33, 0x33 } ,
  { 0x13, 0x13, 0x13 } ,
  { 0x17, 0x17, 0x17 } ,
  { 0x2B, 0x2B, 0x2B } ,
  { 0x30, 0x30, 0x30 } ,
  { 0x1F, 0x1F, 0x1F } ,
  { 0x24, 0x24, 0x24 } ,
  { 0x38, 0x38, 0x38 } ,
  { 0x3D, 0x3D, 0x3D } ,
  { 0x0E, 0x0E, 0x0E } ,
  { 0x18, 0x18, 0x18 } ,
  { 0x2D, 0x2D, 0x2D } ,
  { 0x32, 0x32, 0x32 } ,
  { 0x20, 0x20, 0x20 } ,
  { 0x24, 0x24, 0x24 } ,
  { 0x38, 0x38, 0x38 } ,
  { 0x3F, 0x3F, 0x3F } ,
  }
};

CLUT ColourCLUT256 =
{
 COLOURCLUT256_LENGTH,0,
 {
  { 0x00, 0x00, 0x00 } ,
  { 0x00, 0x00, 0x2A } ,
  { 0x00, 0x2A, 0x00 } ,
  { 0x00, 0x2A, 0x2A } ,
  { 0x2A, 0x00, 0x00 } ,
  { 0x2A, 0x00, 0x2A } ,
  { 0x2A, 0x15, 0x00 } ,
  { 0x2A, 0x2A, 0x2A } ,
  { 0x15, 0x15, 0x15 } ,
  { 0x15, 0x15, 0x3F } ,
  { 0x15, 0x3F, 0x15 } ,
  { 0x15, 0x3F, 0x3F } ,
  { 0x3F, 0x15, 0x15 } ,
  { 0x3F, 0x15, 0x3F } ,
  { 0x3F, 0x3F, 0x15 } ,
  { 0x3F, 0x3F, 0x3F } ,
  { 0x00, 0x00, 0x00 } ,
  { 0x05, 0x05, 0x05 } ,
  { 0x08, 0x08, 0x08 } ,
  { 0x0B, 0x0B, 0x0B } ,
  { 0x0E, 0x0E, 0x0E } ,
  { 0x11, 0x11, 0x11 } ,
  { 0x14, 0x14, 0x14 } ,
  { 0x18, 0x18, 0x18 } ,
  { 0x1C, 0x1C, 0x1C } ,
  { 0x20, 0x20, 0x20 } ,
  { 0x24, 0x24, 0x24 } ,
  { 0x28, 0x28, 0x28 } ,
  { 0x2D, 0x2D, 0x2D } ,
  { 0x32, 0x32, 0x32 } ,
  { 0x38, 0x38, 0x38 } ,
  { 0x3F, 0x3F, 0x3F } ,
  { 0x00, 0x00, 0x3F } ,
  { 0x10, 0x00, 0x3F } ,
  { 0x1F, 0x00, 0x3F } ,
  { 0x2F, 0x00, 0x3F } ,
  { 0x3F, 0x00, 0x3F } ,
  { 0x3F, 0x00, 0x2F } ,
  { 0x3F, 0x00, 0x1F } ,
  { 0x3F, 0x00, 0x10 } ,
  { 0x3F, 0x00, 0x00 } ,
  { 0x3F, 0x10, 0x00 } ,
  { 0x3F, 0x1F, 0x00 } ,
  { 0x3F, 0x2F, 0x00 } ,
  { 0x3F, 0x3F, 0x00 } ,
  { 0x2F, 0x3F, 0x00 } ,
  { 0x1F, 0x3F, 0x00 } ,
  { 0x10, 0x3F, 0x00 } ,
  { 0x00, 0x3F, 0x00 } ,
  { 0x00, 0x3F, 0x10 } ,
  { 0x00, 0x3F, 0x1F } ,
  { 0x00, 0x3F, 0x2F } ,
  { 0x00, 0x3F, 0x3F } ,
  { 0x00, 0x2F, 0x3F } ,
  { 0x00, 0x1F, 0x3F } ,
  { 0x00, 0x10, 0x3F } ,
  { 0x1F, 0x1F, 0x3F } ,
  { 0x27, 0x1F, 0x3F } ,
  { 0x2F, 0x1F, 0x3F } ,
  { 0x37, 0x1F, 0x3F } ,
  { 0x3F, 0x1F, 0x3F } ,
  { 0x3F, 0x1F, 0x37 } ,
  { 0x3F, 0x1F, 0x2F } ,
  { 0x3F, 0x1F, 0x27 } ,
  { 0x3F, 0x1F, 0x1F } ,
  { 0x3F, 0x27, 0x1F } ,
  { 0x3F, 0x2F, 0x1F } ,
  { 0x3F, 0x37, 0x1F } ,
  { 0x3F, 0x3F, 0x1F } ,
  { 0x37, 0x3F, 0x1F } ,
  { 0x2F, 0x3F, 0x1F } ,
  { 0x27, 0x3F, 0x1F } ,
  { 0x1F, 0x3F, 0x1F } ,
  { 0x1F, 0x3F, 0x27 } ,
  { 0x1F, 0x3F, 0x2F } ,
  { 0x1F, 0x3F, 0x37 } ,
  { 0x1F, 0x3F, 0x3F } ,
  { 0x1F, 0x37, 0x3F } ,
  { 0x1F, 0x2F, 0x3F } ,
  { 0x1F, 0x27, 0x3F } ,
  { 0x2D, 0x2D, 0x3F } ,
  { 0x31, 0x2D, 0x3F } ,
  { 0x36, 0x2D, 0x3F } ,
  { 0x3A, 0x2D, 0x3F } ,
  { 0x3F, 0x2D, 0x3F } ,
  { 0x3F, 0x2D, 0x3A } ,
  { 0x3F, 0x2D, 0x36 } ,
  { 0x3F, 0x2D, 0x31 } ,
  { 0x3F, 0x2D, 0x2D } ,
  { 0x3F, 0x31, 0x2D } ,
  { 0x3F, 0x36, 0x2D } ,
  { 0x3F, 0x3A, 0x2D } ,
  { 0x3F, 0x3F, 0x2D } ,
  { 0x3A, 0x3F, 0x2D } ,
  { 0x36, 0x3F, 0x2D } ,
  { 0x31, 0x3F, 0x2D } ,
  { 0x2D, 0x3F, 0x2D } ,
  { 0x2D, 0x3F, 0x31 } ,
  { 0x2D, 0x3F, 0x36 } ,
  { 0x2D, 0x3F, 0x3A } ,
  { 0x2D, 0x3F, 0x3F } ,
  { 0x2D, 0x3A, 0x3F } ,
  { 0x2D, 0x36, 0x3F } ,
  { 0x2D, 0x31, 0x3F } ,
  { 0x00, 0x00, 0x1C } ,
  { 0x07, 0x00, 0x1C } ,
  { 0x0E, 0x00, 0x1C } ,
  { 0x15, 0x00, 0x1C } ,
  { 0x1C, 0x00, 0x1C } ,
  { 0x1C, 0x00, 0x15 } ,
  { 0x1C, 0x00, 0x0E } ,
  { 0x1C, 0x00, 0x07 } ,
  { 0x1C, 0x00, 0x00 } ,
  { 0x1C, 0x07, 0x00 } ,
  { 0x1C, 0x0E, 0x00 } ,
  { 0x1C, 0x15, 0x00 } ,
  { 0x1C, 0x1C, 0x00 } ,
  { 0x15, 0x1C, 0x00 } ,
  { 0x0E, 0x1C, 0x00 } ,
  { 0x07, 0x1C, 0x00 } ,
  { 0x00, 0x1C, 0x00 } ,
  { 0x00, 0x1C, 0x07 } ,
  { 0x00, 0x1C, 0x0E } ,
  { 0x00, 0x1C, 0x15 } ,
  { 0x00, 0x1C, 0x1C } ,
  { 0x00, 0x15, 0x1C } ,
  { 0x00, 0x0E, 0x1C } ,
  { 0x00, 0x07, 0x1C } ,
  { 0x0E, 0x0E, 0x1C } ,
  { 0x11, 0x0E, 0x1C } ,
  { 0x15, 0x0E, 0x1C } ,
  { 0x18, 0x0E, 0x1C } ,
  { 0x1C, 0x0E, 0x1C } ,
  { 0x1C, 0x0E, 0x18 } ,
  { 0x1C, 0x0E, 0x15 } ,
  { 0x1C, 0x0E, 0x11 } ,
  { 0x1C, 0x0E, 0x0E } ,
  { 0x1C, 0x11, 0x0E } ,
  { 0x1C, 0x15, 0x0E } ,
  { 0x1C, 0x08, 0x0E } ,
  { 0x1C, 0x1C, 0x0E } ,
  { 0x18, 0x1C, 0x0E } ,
  { 0x15, 0x1C, 0x0E } ,
  { 0x11, 0x1C, 0x0E } ,
  { 0x0E, 0x1C, 0x0E } ,
  { 0x0E, 0x1C, 0x11 } ,
  { 0x0E, 0x1C, 0x15 } ,
  { 0x0E, 0x1C, 0x18 } ,
  { 0x0E, 0x1C, 0x1C } ,
  { 0x0E, 0x18, 0x1C } ,
  { 0x0E, 0x15, 0x1C } ,
  { 0x0E, 0x11, 0x1C } ,
  { 0x14, 0x14, 0x1C } ,
  { 0x16, 0x14, 0x1C } ,
  { 0x18, 0x14, 0x1C } ,
  { 0x1A, 0x14, 0x1C } ,
  { 0x1C, 0x14, 0x1C } ,
  { 0x1C, 0x14, 0x1A } ,
  { 0x1C, 0x14, 0x18 } ,
  { 0x1C, 0x14, 0x16 } ,
  { 0x1C, 0x14, 0x14 } ,
  { 0x1C, 0x16, 0x14 } ,
  { 0x1C, 0x18, 0x14 } ,
  { 0x1C, 0x1A, 0x14 } ,
  { 0x1C, 0x1C, 0x14 } ,
  { 0x1A, 0x1C, 0x14 } ,
  { 0x18, 0x1C, 0x14 } ,
  { 0x16, 0x1C, 0x14 } ,
  { 0x14, 0x1C, 0x14 } ,
  { 0x14, 0x1C, 0x16 } ,
  { 0x14, 0x1C, 0x18 } ,
  { 0x14, 0x1C, 0x1A } ,
  { 0x14, 0x1C, 0x1C } ,
  { 0x14, 0x1A, 0x1C } ,
  { 0x14, 0x18, 0x1C } ,
  { 0x14, 0x16, 0x1C } ,
  { 0x00, 0x00, 0x10 } ,
  { 0x04, 0x00, 0x10 } ,
  { 0x08, 0x00, 0x10 } ,
  { 0x0C, 0x00, 0x10 } ,
  { 0x10, 0x00, 0x10 } ,
  { 0x10, 0x00, 0x0C } ,
  { 0x10, 0x00, 0x08 } ,
  { 0x10, 0x00, 0x04 } ,
  { 0x10, 0x00, 0x00 } ,
  { 0x10, 0x04, 0x00 } ,
  { 0x10, 0x08, 0x00 } ,
  { 0x10, 0x0C, 0x00 } ,
  { 0x10, 0x10, 0x00 } ,
  { 0x0C, 0x10, 0x00 } ,
  { 0x08, 0x10, 0x00 } ,
  { 0x04, 0x10, 0x00 } ,
  { 0x00, 0x10, 0x00 } ,
  { 0x00, 0x10, 0x04 } ,
  { 0x00, 0x10, 0x08 } ,
  { 0x00, 0x10, 0x0C } ,
  { 0x00, 0x10, 0x10 } ,
  { 0x00, 0x0C, 0x10 } ,
  { 0x00, 0x08, 0x10 } ,
  { 0x00, 0x04, 0x10 } ,
  { 0x08, 0x08, 0x10 } ,
  { 0x0A, 0x08, 0x10 } ,
  { 0x0C, 0x08, 0x10 } ,
  { 0x0E, 0x08, 0x10 } ,
  { 0x10, 0x08, 0x10 } ,
  { 0x10, 0x08, 0x0E } ,
  { 0x10, 0x08, 0x0C } ,
  { 0x10, 0x08, 0x0A } ,
  { 0x10, 0x08, 0x08 } ,
  { 0x10, 0x0A, 0x08 } ,
  { 0x10, 0x0C, 0x08 } ,
  { 0x10, 0x0E, 0x08 } ,
  { 0x10, 0x10, 0x08 } ,
  { 0x0E, 0x10, 0x08 } ,
  { 0x0C, 0x10, 0x08 } ,
  { 0x0A, 0x10, 0x08 } ,
  { 0x08, 0x10, 0x08 } ,
  { 0x08, 0x10, 0x0A } ,
  { 0x08, 0x10, 0x0C } ,
  { 0x08, 0x10, 0x0E } ,
  { 0x08, 0x10, 0x10 } ,
  { 0x08, 0x0E, 0x10 } ,
  { 0x08, 0x0C, 0x10 } ,
  { 0x08, 0x0A, 0x10 } ,
  { 0x0B, 0x0B, 0x10 } ,
  { 0x0C, 0x0B, 0x10 } ,
  { 0x0D, 0x0B, 0x10 } ,
  { 0x0F, 0x0B, 0x10 } ,
  { 0x10, 0x0B, 0x10 } ,
  { 0x10, 0x0B, 0x0F } ,
  { 0x10, 0x0B, 0x0D } ,
  { 0x10, 0x0B, 0x0C } ,
  { 0x10, 0x0B, 0x0B } ,
  { 0x10, 0x0C, 0x0B } ,
  { 0x10, 0x0D, 0x0B } ,
  { 0x10, 0x0F, 0x0B } ,
  { 0x10, 0x10, 0x0B } ,
  { 0x0F, 0x10, 0x0B } ,
  { 0x0D, 0x10, 0x0B } ,
  { 0x0C, 0x10, 0x0B } ,
  { 0x0B, 0x10, 0x0B } ,
  { 0x0B, 0x10, 0x0C } ,
  { 0x0B, 0x10, 0x0D } ,
  { 0x0B, 0x10, 0x0F } ,
  { 0x0B, 0x10, 0x10 } ,
  { 0x0B, 0x0F, 0x10 } ,
  { 0x0B, 0x0D, 0x10 } ,
  { 0x0B, 0x0C, 0x10 } ,
  { 0x15, 0x15, 0x15 } ,
  { 0x15, 0x15, 0x3F } ,
  { 0x15, 0x3F, 0x15 } ,
  { 0x15, 0x3F, 0x3F } ,
  { 0x3F, 0x15, 0x15 } ,
  { 0x3F, 0x15, 0x3F } ,
  { 0x3F, 0x3F, 0x15 } ,
  { 0x3F, 0x3F, 0x3F } ,
  }
} ;

CLUT MonoCLUT256 =
{
  MONOCLUT256_LENGTH,0,
  {
  { 0x00, 0x00, 0x00 } ,
  { 0x05, 0x05, 0x05 } ,
  { 0x11, 0x11, 0x11 } ,
  { 0x1C, 0x1C, 0x1C } ,
  { 0x08, 0x08, 0x08 } ,
  { 0x0B, 0x0B, 0x0B } ,
  { 0x14, 0x14, 0x14 } ,
  { 0x28, 0x28, 0x28 } ,
  { 0x0E, 0x0E, 0x0E } ,
  { 0x18, 0x18, 0x18 } ,
  { 0x2D, 0x2D, 0x2D } ,
  { 0x32, 0x32, 0x32 } ,
  { 0x20, 0x20, 0x20 } ,
  { 0x24, 0x24, 0x24 } ,
  { 0x38, 0x38, 0x38 } ,
  { 0x3F, 0x3F, 0x3F } ,
  { 0x00, 0x00, 0x00 } ,
  { 0x05, 0x05, 0x05 } ,
  { 0x08, 0x08, 0x08 } ,
  { 0x0B, 0x0B, 0x0B } ,
  { 0x0E, 0x0E, 0x0E } ,
  { 0x11, 0x11, 0x11 } ,
  { 0x14, 0x14, 0x14 } ,
  { 0x18, 0x18, 0x18 } ,
  { 0x1C, 0x1C, 0x1C } ,
  { 0x20, 0x20, 0x20 } ,
  { 0x24, 0x24, 0x24 } ,
  { 0x28, 0x28, 0x28 } ,
  { 0x2D, 0x2D, 0x2D } ,
  { 0x32, 0x32, 0x32 } ,
  { 0x38, 0x38, 0x38 } ,
  { 0x3F, 0x3F, 0x3F } ,
  { 0x07, 0x07, 0x07 } ,
  { 0x0C, 0x0C, 0x0C } ,
  { 0x10, 0x10, 0x10 } ,
  { 0x15, 0x15, 0x15 } ,
  { 0x1A, 0x1A, 0x1A } ,
  { 0x18, 0x18, 0x18 } ,
  { 0x16, 0x16, 0x16 } ,
  { 0x15, 0x15, 0x15 } ,
  { 0x13, 0x13, 0x13 } ,
  { 0x1C, 0x1C, 0x1C } ,
  { 0x25, 0x25, 0x25 } ,
  { 0x2F, 0x2F, 0x2F } ,
  { 0x38, 0x38, 0x38 } ,
  { 0x33, 0x33, 0x33 } ,
  { 0x2E, 0x2E, 0x2E } ,
  { 0x2A, 0x2A, 0x2A } ,
  { 0x25, 0x25, 0x25 } ,
  { 0x27, 0x27, 0x27 } ,
  { 0x29, 0x29, 0x29 } ,
  { 0x2A, 0x2A, 0x2A } ,
  { 0x2C, 0x2C, 0x2C } ,
  { 0x23, 0x23, 0x23 } ,
  { 0x19, 0x19, 0x19 } ,
  { 0x10, 0x10, 0x10 } ,
  { 0x23, 0x23, 0x23 } ,
  { 0x25, 0x25, 0x25 } ,
  { 0x27, 0x27, 0x27 } ,
  { 0x2A, 0x2A, 0x2A } ,
  { 0x2C, 0x2C, 0x2C } ,
  { 0x2B, 0x2B, 0x2B } ,
  { 0x2A, 0x2A, 0x2A } ,
  { 0x29, 0x29, 0x29 } ,
  { 0x29, 0x29, 0x29 } ,
  { 0x2D, 0x2D, 0x2D } ,
  { 0x32, 0x32, 0x32 } ,
  { 0x37, 0x37, 0x37 } ,
  { 0x3B, 0x3B, 0x3B } ,
  { 0x39, 0x39, 0x39 } ,
  { 0x37, 0x37, 0x37 } ,
  { 0x34, 0x34, 0x34 } ,
  { 0x32, 0x32, 0x32 } ,
  { 0x33, 0x33, 0x33 } ,
  { 0x34, 0x34, 0x34 } ,
  { 0x35, 0x35, 0x35 } ,
  { 0x35, 0x35, 0x35 } ,
  { 0x31, 0x31, 0x31 } ,
  { 0x2C, 0x2C, 0x2C } ,
  { 0x27, 0x27, 0x27 } ,
  { 0x2F, 0x2F, 0x2F } ,
  { 0x30, 0x30, 0x30 } ,
  { 0x32, 0x32, 0x32 } ,
  { 0x33, 0x33, 0x33 } ,
  { 0x34, 0x34, 0x34 } ,
  { 0x34, 0x34, 0x34 } ,
  { 0x33, 0x33, 0x33 } ,
  { 0x33, 0x33, 0x33 } ,
  { 0x32, 0x32, 0x32 } ,
  { 0x35, 0x35, 0x35 } ,
  { 0x38, 0x38, 0x38 } ,
  { 0x3A, 0x3A, 0x3A } ,
  { 0x3D, 0x3D, 0x3D } ,
  { 0x3C, 0x3C, 0x3C } ,
  { 0x3A, 0x3A, 0x3A } ,
  { 0x39, 0x39, 0x39 } ,
  { 0x38, 0x38, 0x38 } ,
  { 0x38, 0x38, 0x38 } ,
  { 0x39, 0x39, 0x39 } ,
  { 0x39, 0x39, 0x39 } ,
  { 0x3A, 0x3A, 0x3A } ,
  { 0x37, 0x37, 0x37 } ,
  { 0x34, 0x34, 0x34 } ,
  { 0x31, 0x31, 0x31 } ,
  { 0x03, 0x03, 0x03 } ,
  { 0x05, 0x05, 0x05 } ,
  { 0x07, 0x07, 0x07 } ,
  { 0x09, 0x09, 0x09 } ,
  { 0x0B, 0x0B, 0x0B } ,
  { 0x0B, 0x0B, 0x0B } ,
  { 0x0A, 0x0A, 0x0A } ,
  { 0x09, 0x09, 0x09 } ,
  { 0x08, 0x08, 0x08 } ,
  { 0x0D, 0x0D, 0x0D } ,
  { 0x11, 0x11, 0x11 } ,
  { 0x15, 0x15, 0x15 } ,
  { 0x19, 0x19, 0x19 } ,
  { 0x17, 0x17, 0x17 } ,
  { 0x15, 0x15, 0x15 } ,
  { 0x13, 0x13, 0x13 } ,
  { 0x11, 0x11, 0x11 } ,
  { 0x11, 0x11, 0x11 } ,
  { 0x12, 0x12, 0x12 } ,
  { 0x13, 0x13, 0x13 } ,
  { 0x14, 0x14, 0x14 } ,
  { 0x0F, 0x0F, 0x0F } ,
  { 0x0B, 0x0B, 0x0B } ,
  { 0x07, 0x07, 0x07 } ,
  { 0x10, 0x10, 0x10 } ,
  { 0x10, 0x10, 0x10 } ,
  { 0x12, 0x12, 0x12 } ,
  { 0x13, 0x13, 0x13 } ,
  { 0x14, 0x14, 0x14 } ,
  { 0x13, 0x13, 0x13 } ,
  { 0x13, 0x13, 0x13 } ,
  { 0x13, 0x13, 0x13 } ,
  { 0x12, 0x12, 0x12 } ,
  { 0x14, 0x14, 0x14 } ,
  { 0x16, 0x16, 0x16 } ,
  { 0x18, 0x18, 0x18 } ,
  { 0x1A, 0x1A, 0x1A } ,
  { 0x19, 0x19, 0x19 } ,
  { 0x18, 0x18, 0x18 } ,
  { 0x17, 0x17, 0x17 } ,
  { 0x16, 0x16, 0x16 } ,
  { 0x17, 0x17, 0x17 } ,
  { 0x17, 0x17, 0x17 } ,
  { 0x17, 0x17, 0x17 } ,
  { 0x18, 0x18, 0x18 } ,
  { 0x15, 0x15, 0x15 } ,
  { 0x14, 0x14, 0x14 } ,
  { 0x11, 0x11, 0x11 } ,
  { 0x15, 0x15, 0x15 } ,
  { 0x15, 0x15, 0x15 } ,
  { 0x16, 0x16, 0x16 } ,
  { 0x17, 0x17, 0x17 } ,
  { 0x17, 0x17, 0x17 } ,
  { 0x17, 0x17, 0x17 } ,
  { 0x17, 0x17, 0x17 } ,
  { 0x17, 0x17, 0x17 } ,
  { 0x16, 0x16, 0x16 } ,
  { 0x18, 0x18, 0x18 } ,
  { 0x19, 0x19, 0x19 } ,
  { 0x1A, 0x1A, 0x1A } ,
  { 0x1B, 0x1B, 0x1B } ,
  { 0x1B, 0x1B, 0x1B } ,
  { 0x1A, 0x1A, 0x1A } ,
  { 0x19, 0x19, 0x19 } ,
  { 0x19, 0x19, 0x19 } ,
  { 0x19, 0x19, 0x19 } ,
  { 0x19, 0x19, 0x19 } ,
  { 0x19, 0x19, 0x19 } ,
  { 0x1A, 0x1A, 0x1A } ,
  { 0x18, 0x18, 0x18 } ,
  { 0x17, 0x17, 0x17 } ,
  { 0x16, 0x16, 0x16 } ,
  { 0x02, 0x02, 0x02 } ,
  { 0x03, 0x03, 0x03 } ,
  { 0x04, 0x04, 0x04 } ,
  { 0x05, 0x05, 0x05 } ,
  { 0x07, 0x07, 0x07 } ,
  { 0x06, 0x06, 0x06 } ,
  { 0x06, 0x06, 0x06 } ,
  { 0x05, 0x05, 0x05 } ,
  { 0x05, 0x05, 0x05 } ,
  { 0x07, 0x07, 0x07 } ,
  { 0x0A, 0x0A, 0x0A } ,
  { 0x0C, 0x0C, 0x0C } ,
  { 0x0E, 0x0E, 0x0E } ,
  { 0x0D, 0x0D, 0x0D } ,
  { 0x0C, 0x0C, 0x0C } ,
  { 0x0B, 0x0B, 0x0B } ,
  { 0x09, 0x09, 0x09 } ,
  { 0x0A, 0x0A, 0x0A } ,
  { 0x0A, 0x0A, 0x0A } ,
  { 0x0B, 0x0B, 0x0B } ,
  { 0x0B, 0x0B, 0x0B } ,
  { 0x09, 0x09, 0x09 } ,
  { 0x06, 0x06, 0x06 } ,
  { 0x04, 0x04, 0x04 } ,
  { 0x09, 0x09, 0x09 } ,
  { 0x09, 0x09, 0x09 } ,
  { 0x0A, 0x0A, 0x0A } ,
  { 0x0B, 0x0B, 0x0B } ,
  { 0x0B, 0x0B, 0x0B } ,
  { 0x0B, 0x0B, 0x0B } ,
  { 0x0B, 0x0B, 0x0B } ,
  { 0x0B, 0x0B, 0x0B } ,
  { 0x0A, 0x0A, 0x0A } ,
  { 0x0C, 0x0C, 0x0C } ,
  { 0x0D, 0x0D, 0x0D } ,
  { 0x0E, 0x0E, 0x0E } ,
  { 0x0F, 0x0F, 0x0F } ,
  { 0x0F, 0x0F, 0x0F } ,
  { 0x0E, 0x0E, 0x0E } ,
  { 0x0D, 0x0D, 0x0D } ,
  { 0x0D, 0x0D, 0x0D } ,
  { 0x0D, 0x0D, 0x0D } ,
  { 0x0D, 0x0D, 0x0D } ,
  { 0x0D, 0x0D, 0x0D } ,
  { 0x0E, 0x0E, 0x0E } ,
  { 0x0C, 0x0C, 0x0C } ,
  { 0x0B, 0x0B, 0x0B } ,
  { 0x0A, 0x0A, 0x0A } ,
  { 0x0C, 0x0C, 0x0C } ,
  { 0x0C, 0x0C, 0x0C } ,
  { 0x0C, 0x0C, 0x0C } ,
  { 0x0D, 0x0D, 0x0D } ,
  { 0x0D, 0x0D, 0x0D } ,
  { 0x0D, 0x0D, 0x0D } ,
  { 0x0D, 0x0D, 0x0D } ,
  { 0x0D, 0x0D, 0x0D } ,
  { 0x0C, 0x0C, 0x0C } ,
  { 0x0D, 0x0D, 0x0D } ,
  { 0x0E, 0x0E, 0x0E } ,
  { 0x0F, 0x0F, 0x0F } ,
  { 0x0F, 0x0F, 0x0F } ,
  { 0x0F, 0x0F, 0x0F } ,
  { 0x0F, 0x0F, 0x0F } ,
  { 0x0E, 0x0E, 0x0E } ,
  { 0x0E, 0x0E, 0x0E } ,
  { 0x0E, 0x0E, 0x0E } ,
  { 0x0E, 0x0E, 0x0E } ,
  { 0x0E, 0x0E, 0x0E } ,
  { 0x0E, 0x0E, 0x0E } ,
  { 0x0E, 0x0E, 0x0E } ,
  { 0x0D, 0x0D, 0x0D } ,
  { 0x0C, 0x0C, 0x0C } ,
  { 0x15, 0x15, 0x15 } ,
  { 0x1A, 0x1A, 0x1A } ,
  { 0x2E, 0x2E, 0x2E } ,
  { 0x32, 0x32, 0x32 } ,
  { 0x22, 0x22, 0x22 } ,
  { 0x26, 0x26, 0x26 } ,
  { 0x3A, 0x3A, 0x3A } ,
  { 0x3F, 0x3F, 0x3F } ,
  }
} ;
