;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;**************************************************************************
;*
;* SOURCE FILE NAME = UTLASM.ASM
;*
;* DESCRIPTIVE NAME = Utilities module
;*
;*
;* VERSION = V2.0
;*
;* DATE
;*
;* DESCRIPTION : Low level helper routines for the utilities module.
;*
;*
;* FUNCTIONS  :         utl_memcopy
;*                      szIsEqual
;*                      int3
;*                      FractionToDecimal
;*                      LongShiftRight
;*                      ValidateSelector
;*
;* NOTES
;*
;*
;* STRUCTURES
;*
;* EXTERNAL REFERENCES :
;*
;*
;* EXTERNAL FUNCTIONS
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @VR.MPPPXX  XXXXX  XXXXXXX
;*
;*   03/01/87                     01-Mar-87 [stevewo]  Created.
;*
;*   11/30/89                     Thu Nov 30, 1989  14:08:00
;*                                Imported from pmwin.
;*                                Simplified to no longer do DosGetSeg.
;*                                -by-     Kent Settle     [kentse]
;*                                ValidateSelector.
;*
;*    12/16/93                    RECODED ALL THE PROCEDURES FOR FLAT
;*                                MODEL.
;*                                REMOVED ValidateSelector AS IT IS
;*                                NO LONGER NEEDED.
;*                                INCLUDED 32CMACRO.INC
;*                                ALL FUNCTIONS USE SYSTEM LINKAGE
;*                                Kranthi Ravi
;*
;***********************************************************************/

.386p
subttl          Macros and Equates
page +
;*
;*Include the 32CMACRO here:
;*
.xlist
include         32CMACRO.INC
?PLM = CC_SYSCALL
;*

subttl          Code Area
page +
SEGM53    SEGMENT DWORD USE32 PUBLIC 'CODE'
    ASSUME      CS:FLAT, SS:FLAT, ES:FLAT, DS:FLAT

;***************************************************************************
;*
;* FUNCTION NAME = utl_memcopy
;*
;*
;* DESCRIPTION   = Copies an array of bytes.
;*
;* ENTRY         = NONE
;*
;* OUTPUT        = NONE
;*
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;*
;* REGISTERS DESTROYED = NONE
;*
;*
;* REGISTERS PRESERVED = NONE
;*
;**************************************************************************

 cProc utl_memcopy,<PUBLIC>, <esi,edi>
        parmD   pbDst      ;* Far ptr to the destination area
        parmD   pbSrc      ;* Far ptr to the source area
        parmW   nb         ;* The number of bytes to copy
cBegin
        mov     esi,pbSrc
        mov     edi,pbDst
        movzx   ecx,nb
        rep     movsb
cEnd


;***************************************************************************
;*
;* FUNCTION NAME = LongShiftRight
;*
;*
;* DESCRIPTION   =
;*
;*
;* ENTRY         = NONE
;*
;* OUTPUT        = NONE
;*
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;*
;* REGISTERS DESTROYED = NONE
;*
;*
;* REGISTERS PRESERVED = NONE
;*
;**************************************************************************

cProc   LongShiftRight,<PUBLIC>
        parmD   lvalue
        parmD   ShiftCount
cBegin
       mov      eax, lvalue
       mov      ecx, ShiftCount
       shr      eax, cl
cEnd


SEGM53    ENDS


SEGM25    SEGMENT DWORD USE32 PUBLIC 'CODE'
    ASSUME      CS:FLAT, SS:FLAT, ES:FLAT, DS:FLAT

;***************************************************************************
;*
;* FUNCTION NAME = szIsEqual
;*
;*
;* DESCRIPTION   = Compares two strings and returns TRUE if they
;*                 are equal.
;*
;* ENTRY         = NONE
;*
;* OUTPUT        = NONE
;*
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;*
;* REGISTERS DESTROYED = NONE
;*
;*
;* REGISTERS PRESERVED = NONE
;*
;**************************************************************************

cProc   szIsEqual,<PUBLIC>, <esi,edi,ebx>
        parmD   sz1       ;* Far ptr to the first string
        parmD   sz2       ;* Far ptr to the second string
cBegin
        xor     eax,eax      ;* assume strings not equal
        mov     edi,sz1     ;* point to the first string
        mov     ebx,sz2     ;*  "
iseq00: mov     cl,byte ptr[edi]
        cmp     cl,byte ptr[ebx]
        jne     iseq10                 ;* strings not equal! - so leave

        inc     edi
        inc     ebx
        or      cl,cl                  ;* reached NULL string terminator?
        jnz     iseq00                 ;* No, go loop again

        mov     eax,1                   ;* Good, lets indicate strings same
iseq10:
cEnd


SEGM25    ENDS


SEGM12    SEGMENT DWORD USE32 PUBLIC 'CODE'
    ASSUME      CS:FLAT, SS:FLAT, ES:FLAT, DS:FLAT

;*
;* public routine
;*


;***************************************************************************
;*
;* FUNCTION NAME = int3
;*
;*
;* DESCRIPTION   =
;*
;*
;* ENTRY         = NONE
;*
;* OUTPUT        = NONE
;*
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;*
;* REGISTERS DESTROYED = NONE
;*
;*
;* REGISTERS PRESERVED = NONE
;*
;**************************************************************************

cProc   Int3,<PUBLIC>
cBegin
        int   3
cEnd


SEGM12    ENDS


SEGM21    SEGMENT DWORD USE32 PUBLIC 'CODE'
    ASSUME      CS:FLAT, SS:FLAT, ES:FLAT, DS:FLAT

;***************************************************************************
;*
;* FUNCTION NAME = FractionToDecimal
;*
;*
;* DESCRIPTION   =
;*
;*
;* ENTRY         = NONE
;*
;* OUTPUT        = NONE
;*
;*
;* RETURN-NORMAL = NONE
;*
;* RETURN-ERROR  = NONE
;*
;*
;* REGISTERS DESTROYED = NONE
;*
;*
;* REGISTERS PRESERVED = NONE
;*
;**************************************************************************

cProc   FractionToDecimal,<PUBLIC>,<esi,edi,ebx>
        parmD   lpBuf       ;* Far ptr to the buffer
        parmW   iFraction   ;* The fractional part of a fixed point number
cBegin
        mov     ebx,lpBuf
        mov     ax,iFraction
;*
;* Multiply the fraction by 10 repetitively so that the next digit
;* appears in the upper 16 bits of the product.
;*
        mov     si,10
        mov     ecx,5           ;* five is the magic size of the buffer.

ten_loop:
        mul     si              ;* multiply fraction by 10.
        add     dl,'0'          ;* Convert numeric value to ASCII
        mov     [ebx],dl        ;* Store this digit
        inc     ebx             ;* Move on to the next digit
        loop    ten_loop

        dec     ebx
;*
;* Count the number of signifigant digits in the fraction
;*
        mov     ax,5
        cmp     dl,'0'
        jnz     ConvertComplete
        dec     ebx
        dec     ax
        cmp     byte ptr[ebx],'0'
        jnz     ConvertComplete
        dec     ebx
        dec     ax
        cmp     byte ptr[ebx],'0'
        jnz     ConvertComplete
        dec     ebx
        dec     ax
        cmp     byte ptr[ebx],'0'
        jnz     ConvertComplete
        dec     ebx
        dec     ax
        cmp     byte ptr[ebx],'0'
        jnz     ConvertComplete
        dec     ax

ConvertComplete:
cEnd


SEGM21    ENDS

end
