;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = STUB.ASM
;*
;* DESCRIPTIVE NAME = Contains basic math routines.
;*
;*
;* VERSION      V1.00
;*
;* DATE         04/94
;*
;* DESCRIPTION  MATH ROUTINES FOR PRINTER DRIVER
;*
;*
;* FUNCTIONS    doimul
;*              dodiv
;*
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;*****************************************************************************/

        .386p
        .xlist
INCL_GPIPRIMITIVES      equ     1
INCL_DDIBUNDLES         equ     1
INCL_DDIMISC            equ     1

        include 32cmacro.inc
?PLM = CC_SYSCALL
        .list


LONG    struc
lo      dw      ?
hi      dw      ?
LONG    ends


UQUAD   struc
uq0     dw      ?
uq1     dw      ?
uq2     dw      ?
uq3     dw      ?
UQUAD   ends


QUAD      struc
q0               dw      ?       ;*; lowest-order word
q1               dw      ?       ;*; low DWord
q2               dw      ?
q3               dw      ?
QUAD      ends

QUAD_0_12_3      struc
q12q0            dw      ?       ;*; low DWord
q12              dd      ?
q12q3            dw      ?
QUAD_0_12_3      ends

QUAD_01_23      struc
q01              dd      ?       ;*; low DWord
q23              dd      ?
QUAD_01_23      ends


FLATSEGDEF

.DATA


PSCRIPT_75 SEGMENT DWORD USE32 PUBLIC 'CODE'
           ASSUME CS:FLAT, DS:FLAT, ES:FLAT, SS:FLAT

;******************************************************************************
;*
;* FUNCTION doimul
;*
;* DESCRIPTION Multiplies 2 longs puting result in passed quad
;*
;* RETURNS result of x * y
;*
;******************************************************************************
cProc doimul,<PUBLIC>,<EBX>
        parmDP  pQuad   ;Ponter to quad
        parmD   x       ;First long
        parmD   y       ;Second long
cBegin
        mov     EAX,x   ;Move first long into eax
        imul    y       ;Multiply by second, results in EDX:EAX

        mov     EBX,pQuad   ;Set up addressing to quad
        mov     [EBX].q01,eax   ;Put EAX into low part
        mov     [EBX].q23,edx   ;Put EDX into high part
                                ;eax has result
cEnd

;******************************************************************************
;*
;* FUNCTION dodiv
;*
;* DESCRIPTION Divides a quad by long
;*
;* RETURNS result of q / l
;*
;******************************************************************************

cProc dodiv,<PUBLIC>,<EBX>
        parmDP  pQuad   ;Pointer to quad
        parmD   Denom   ;Denominator
cBegin
        mov     EAX,pQuad       ;Set up addressing
        mov     EDX,[EAX].q23   ;Put high part of quad in edx
        mov     EAX,[EAX].q01   ;Put low part of quad in eax
        mov     EBX,Denom       ;Put denominator in ebx

        div     EBX             ;Divide edx:eax by denominator
                                ;eax has result
cEnd

PSCRIPT_75 ENDS

END
