/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PPD2BIN.H
 *
 * DESCRIPTIVE NAME = Header file for PPD2BIN.H
 *
 *
 * VERSION = V2.0
 *
 * DATE      08/12/91
 *
 * DESCRIPTION Header file for PPD Formatter
 *
 *
 * FUNCTIONS
 *
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define  PPB_DIR        "ppd\\"
#define  RC_FILE_NAME   "PPBS.RC"
#define  DIRECTORY_NAME "directry.ppb"
#define  NAME_LEN       32

enum symbtype
{
  password,           /* Password */
  throughput,         /* Throughput */
  freevm,             /* FreeVM */
  productname,        /* Product */
  shortnickname,      /* ShortNickName */
  printername,        /* NickName */
  setresolution,      /* SetResolution */
  defaultres,         /* DefaultResolution */
  screenfreq,         /* ScreenFreq */
  defaultpsize,       /* DefaultPageSize */
  defaultfont,        /* DefaultFont */
  pagenamelist,       /* PageSize */
  pagesizelist,       /* PaperDimension */
  imageablearea,      /* ImageableArea */
  inputbinlist,       /* InputSlot */
  outputbinlist,      /* OutputBin */
  fontnamelist,       /* Font*/
  colordevice,        /* ColorDevice */
  filesystem,         /* FileSystem */
  exitserver,         /* ExitServer */
  reset,              /* Reset*/
  variablepaper,      /* VariablePaperSize */
  screenangle,        /* ScreenAngle */
  defpageregion,      /* DefaultPageRegion */
  pageregion,         /* PageRegion */
  defpapertray,       /* DefaultPaperTray */
  defimagearea,       /* DefaultImageableArea */
  defpaperdim,        /* DefaultPaperDimension */
  defoutputbin,       /* DefaultOutputBin */
  definputslot,       /* DefaultInputSlot */
  defmanualfeed,      /* DefaultManualFeed */
  manualfeed,         /* ManualFeed */
  defoutputorder,     /* DefaultOutputOrder */
  outputorder,        /* OutputOrder */
  transfernor,        /* Transfer Normalized */
  transferinv,        /* Transfer Normalized.Inverse */
  initstring,         /* InitPostScriptMode */
  termstring,         /* TermPostScriptMode */                 /*            */
  defaultduplex,      /* DefaultDuplex */                      /*            */
  duplex,             /* Duplex */                             /*            */
  SetJobResolution,   /* SetJobResolution */
  LanguageLevel,      /* LanguageLevel */                      /*            */
  JCLBegin,           /* JCLBegin */                          /* @V3.0101290 */
  JCLToPSInterpreter, /* JCLToPSInterpreter */                /* @V3.0101290 */
  JCLEnd,             /* JCLEnd */                            /* @V3.0101290 */
  Resolution,         /* Resolution */
  JCLResolution,      /* JCLResolution */                     // @V3.0115171
  maximum
} ;

typedef enum symbtype Symbtype;

char *szSearch[maximum] =
{
  "*Password",
  "*Throughput",
  "*FreeVM",
  "*Product",
  "*ShortNickName",
  "*NickName",
  "*SetResolution",
  "*DefaultResolution",
  "*ScreenFreq",
  "*DefaultPageSize",
  "*DefaultFont",
  "*PageSize",
  "*PaperDimension",
  "*ImageableArea",
  "*InputSlot",
  "*OutputBin",
  "*Font",
  "*ColorDevice",
  "*FileSystem",
  "*ExitServer",
  "*Reset",
  "*VariablePaperSize",
  "*ScreenAngle",
  "*DefaultPageRegion",
  "*PageRegion",
  "*DefaultPaperTray",
  "*DefaultImageableArea",
  "*DefaultPaperDimension",
  "*DefaultOutputBin",
  "*DefaultInputSlot",
  "*DefaultManualFeed",
  "*ManualFeed",
  "*DefaultOutputOrder",
  "*OutputOrder",
  "*Transfer Normalized",
  "*Transfer Normalized.Inverse",
  "*InitPostScriptMode",                                      /*            */
  "*TermPostScriptMode",                                      /*            */
  "*DefaultDuplex",                                           /*            */
  "*Duplex",                                                  /*            */
  "*SetJobResolution",
  "*LanguageLevel",                                           /*            */
  "*JCLBegin",                                               /* @V3.0101290 */
  "*JCLToPSInterpreter",                                     /* @V3.0101290 */
  "*JCLEnd",                                                 /* @V3.0101290 */
  "*Resolution",
  "*JCLResolution",                                          // @V3.0115171
} ;

/*
**           
** Add 'err_maxPPDs' to verify that the number of PPD's in the
** list does not exceed the maximum limit of the compiler.
*/
enum errtype
{
  err_ver,
  err_usage,
  err_option,
  err_arg,
  err_cantopen,
  err_cantcreate,
  err_badoutput,
  err_eof,
  err_eofin,
  err_badnum,
  err_badreal,
  err_expected,
  err_missingsemi,
  err_expectedname,
  err_output,
  err_overflow,
  err_seek,
  err_output1,
  err_output2,
  err_maxPPDs,
  err_max
} ;

typedef enum errtype ErrType;

/*
**           
** Added the string:
**   "number of PPDs exceed maximum limit"
** to verify that the number of PPD's in the
** list does not exceed the maximum limit of the compiler.
*/
char *szErrmsgs[err_max] =
{
  "Microsoft (R) Ppd File Compiler  Version 1.00\nCopyright (c) Microsoft Corp 1988.  All rights reserved.\n",
  "Usage: ppd2bin -i <ppd file list> -o <outputfile> -g <genericfile>",
  "unknown option",
  "unknown argument",
  "cannot open",
  "cannot create",
  "cannot write to input file",
  "unexpected eof",
  "unexpected eof in",
  "invalid number",
  "invalid real number",
  "expected",
  "missing semicolon",
  "expected name field",
  "error in writing to output file",
  "output buffer overflow",
  "error in seek ",
  "error in items output",
  "error in signature output",
  "number of PPDs exceed maximum limit"
} ;
