;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = XFORM.INC
;*
;* DESCRIPTIVE NAME =
;*
;*
;* VERSION	V2.0
;*
;* DATE
;*
;* DESCRIPTION
;*
;* FUNCTIONS
;*
;* NOTES	NONE
;*
;* STRUCTURES	NONE
;*
;* EXTERNAL REFERENCES
;*
;*		NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*		NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG	   APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*
;*****************************************************************************/


XFORM_IDENTIFIER	equ	'FX'

;/*
;* define the mx_flags which aren't defined in PMDDI.H
;*/

temp = MATRIX_SIMPLE + MATRIX_UNITS + MATRIX_XY_EXCHANGE + MATRIX_X_NEGATE
temp = temp + MATRIX_Y_NEGATE + MATRIX_TRANSLATION
MATRIX_NOTIFY_FLAGS	equ	temp	; all of the above
MATRIX_SINGULAR 	equ	   40h
MATRIX_LRU		equ	00080h	 ; Least Recently Used cache entry
MATRIX_CACHE_SOURCE	equ	00F00h
MATRIX_CACHE_DEST	equ	0F000h

.errnz MATRIX_NOTIFY_FLAGS and (MATRIX_LRU+MATRIX_CACHE_SOURCE+MATRIX_CACHE_DEST+MATRIX_SINGULAR)


;/*
;* define the matrix usType for NotifyTransformChange
;*/

MATRIX_FIXED		equ	1	; type is FIXED

;/*
;* define the roundoff that is added to the translation
;*/

MATRIX_ROUNDOFF 	equ	8000h

;/*
;**  Define our internal matrix structure.  This is an XFORM with more precision
;**  and some flags.  We don't use SIZE XFORM when defining it because we want
;**  it to initialize to an identity matrix.
;*/

MATRIX		struc
mx_xform	dd	10000h		; xform_fxM11
		dd	0		; xform_fxM12
		dd	0		; xform_fxM21
		dd	10000h		; xform_fxM22
		dd	0		; xform_lM41
		dd	0		; xform_lM42
mx_usfracM41	dw	MATRIX_ROUNDOFF ; fraction for M41
mx_usfracM42	dw	MATRIX_ROUNDOFF ; fraction for M42
mx_flags	dw	MATRIX_SIMPLE+MATRIX_UNITS ; accelerators
mx_unused	dw	0
MATRIX		ends

.errnz (mx_usfracM41 - mx_xform) - (SIZE XFORM)

;/*
;**  Define the XFORMBLOCK.  This is ALL the transform data associated with a
;**  DC.  We have the four steps of the transform stored as well as the whole
;**  pipeline, xb_mx15, the whole pipeline reversed, xb_mx51, and two cache
;**  entries.  The cache entries are used to hold frequently requested
;**  transformations for Convert, and also as scatch areas for matrix
;**  calculations.
;*/

XFORMBLOCK	struc
xb_ident	dw	?
xb_size 	dw	?
xb_mx12 	db	SIZE MATRIX dup(?) ; Model Transform
xb_mx23 	db	SIZE MATRIX dup(?) ; Window/Viewport Transform
xb_mx34 	db	SIZE MATRIX dup(?) ; Global Viewing Transform
xb_mx45 	db	SIZE MATRIX dup(?) ; Device Transform
xb_mx15 	db	SIZE MATRIX dup(?) ; Model -> Device
xb_mx51 	db	SIZE MATRIX dup(?) ; Device -> Model
xb_mxCache1	db	SIZE MATRIX dup(?)
xb_mxCache2	db	SIZE MATRIX dup(?)
XFORMBLOCK	ends

.errnz (xb_size - generic_size)

;/*
;** XFORMSAVE macros
;*/

XSAVE_IDENTIFIER	equ	'SX'

XSAVE_dc_page_units		equ	0001h
XSAVE_dc_sizlPage		equ	0002h
XSAVE_dc_sizlUnits		equ	0004h
XSAVE_dc_rclViewingLimits	equ	0008h
XSAVE_dc_rclGraphicsField	equ	0010h
XSAVE_dc_rclPageViewport	equ	0020h

XSAVE_xb_mx12			equ	0080h
XSAVE_xb_mx23			equ	0100h
XSAVE_xb_mx34			equ	0200h
XSAVE_xb_mx45			equ	0400h
XSAVE_xb_mx15			equ	0800h
XSAVE_xb_mx51			equ	1000h
XSAVE_xb_mxCache1		equ	2000h
XSAVE_xb_mxCache2		equ	4000h

XSAVE_xb_guys			equ	7F80h

addsize macro	x,flags,foo
if flags and XSAVE_&foo
	x = x + SIZE foo
endif
	endm

SaveSize macro	x,flags
	x = 6			; IDENTIFIER,flags,hdc
	addsize x,flags,dc_page_units
	addsize x,flags,dc_sizlPage
	addsize x,flags,dc_sizlUnits
	addsize x,flags,dc_rclViewingLimits
	addsize x,flags,dc_rclGraphicsField
	addsize x,flags,dc_rclPageViewport
if flags and XSAVE_xb_guys
	x = x + SIZE dc_xform_block
endif
	addsize x,flags,xb_mx12
	addsize x,flags,xb_mx23
	addsize x,flags,xb_mx34
	addsize x,flags,xb_mx45
	addsize x,flags,xb_mx15
	addsize x,flags,xb_mx51
	addsize x,flags,xb_mxCache1
	addsize x,flags,xb_mxCache2
	endm
