/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME =
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : Soft (downloadable) font constants and definitions.
 *
 *
 * FUNCTIONS
 *
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/


/*
**      Constants
*/
#define ALL_AFM     (PSZ)"*.AFM"
#define ALL_PFB     (PSZ)"*.PFB"
#define ALL_PFM     (PSZ)"*.PFM"
#define BLOCKSIZE   (4096)  /* for file I/O buffering * */
#define BUF_SIZE    64
#define CR          0x0D    /* ASCII carriage return */
#define DEFAULT_FONT_SOURCE (PSZ)"A:\\"         /*  default drive\directory */
#define FILE_NAME_SIZE  15                      /*  \Name0008.ext..         */
#define FONT_DIR_APP    (PSZ)"PM_PSCRIPT"       /* General PostScript       */
#define FONT_DIR_KEY    (PSZ)"InstalledFontDir" /* Where the fonts are      */
#define FONT_NAME       (PSZ)"/FontName"        /*  PostScript keyword      */
#define FULL_NAME       (PSZ)"/FullName"        /*  PostScript keyword      */
/*
**  Should be defined in OS2, but they aren't.
*/
#define HARDERROR_DISABLE   0
#define HARDERROR_ENABLE    1
#define INSTALLED_DIR       (PSZ)"C:\\PSFONTS"
#define INSTALLED_DIR_END   (PSZ)"C:\\PSFONTS\\"
#define LF          0x0A                        /* ASCII line feed */
#define MXS         (256)
#define NPCHAR      NPBYTE
#define PATH_SIZE   128

#define OPEN_READ_FLAGS     OPEN_ACCESS_READONLY        \
                          | OPEN_SHARE_DENYNONE         \
                          | OPEN_FLAGS_FAIL_ON_ERROR    \
                          | OPEN_FLAGS_SEQUENTIAL

#define OPEN_WRITE_FLAGS    OPEN_ACCESS_READWRITE       \
                          | OPEN_SHARE_DENYNONE         \
                          | OPEN_FLAGS_FAIL_ON_ERROR    \
                          | OPEN_FLAGS_SEQUENTIAL

/*
** The PFB file format is a sequence of segments, each of which has a
** header part and a data part. The header format, defined in the
** struct HEADER below, consists of a one byte sanity check number
** (128) then a one byte segment type and finally a four byte length
** field for the data following data. The length field is stored in
** the file with the least significant byte first.
**
** The segment types are:
** 1.) The data is a sequence of ASCII characters.
** 2.) The data is a sequence of binary characters to be converted
**     to a sequence of pairs of hexadecimal digits.
** 3.) The last segment in the file. This segment has no length or
**     data fields.
**
** The segment types are defined explicitly rather than as an
** enumerated type because the values for each type are defined by the
** file format rather than the compiler manipulating them.
*/

#define CHECK_BYTE      128         /* first byte of file segment */
#define ASCII_TYPE      1           /* segment type identifier    */
#define BINARY_TYPE     2
#define EOF_TYPE        3

/*
**       Structures
*/
/*
** The names in the structure follow Adobe practice; the "Full Name" is
** the normal title of the font (eg, "Stone Informal Bold Italic"), while
** the "Font Name" is a PostScript object, all one word beginning with
** '/' ("/StoneInformal-BoldItalic").  We use the "Full Name" exclusively
** from here 'upward' to the user and application: ie, we display it in the
** installation dialog and the app uses it to select a font.  However, the
** PS printer recognizes only the "Font Name" for selecting a font, so the
** 'Font Name' is used exclusively 'downward' from here to the printer.
*/
typedef struct
{
    CHAR    szFilePF[24];          /* PFB or PFA file name, with extensions */
    CHAR    szFullName[BUF_SIZE];  /* for display, probably has spaces      */
} SFTFNT;

typedef SFTFNT FAR *PSFTFNT;

typedef struct         /* Adobe-defined .PFB file segment header */
{
  BYTE  bCheck;        /* segment ID */
  BYTE  bType;         /* segment type */
  ULONG ulLength;      /* length of segment.  Not valid for EOF type. */
} BHEAD;

typedef BHEAD FAR *PBHEAD;
