/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PRDTYPET.H
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : Printer Device Driver types
 *
 * FUNCTIONS
 *
 * NOTES       : Reference - Device Driver Interface Specification
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/



/*
** Basic global Device Driver types.                                  
*/

/*
**  These typedefs should go away one day
*/
typedef unsigned char  Byte;           /*  8-bit unsigned byte        */
typedef  SHORT         Word;           /* 16-bit unsigned word        */
typedef char          *Ptr;            /* 16-bit pointer              */
typedef ULONG          Dword;          /* 32-bit unsigned word        */
typedef char          *Dptr;           /* 32-bit pointer              */
typedef unsigned int   Boolean;        /* used for True/False flags   */
typedef Word (       *Fptr)();         /* 32-bit pointer to function  */


#define FALSE           0
#define TRUE            1

#define FAILURE         0           /* Return code for function failure */
#define SUCCESS         1           /* Return code for function success */

typedef char  *PB;                  /* A far ptr to a byte */

typedef unsigned char UBYTE;        /*  8-bit unsigned byte */

typedef ULONG  (  *LPFNL)();        /* Ptr to function returning long */
typedef short (  *LPFNS)();        /* Ptr to function returning word */

#if DEBUG
  extern VOID PerformRip(PSZ pszErrorText);
  #define RIP(        Text)     PerformRip((PSZ) Text)
  #define RIPIF(Test, Text)     if (Test) RIP(Text);
  /*
  **           
  ** ASSERT may be defined elsewhere.  Define if it doesn't exist.
  */
  #ifndef ASSERT
    #define ASSERT(Test)          if (!(Test)) RIP("ASSERT Failed");
  #endif
#else
  #define RIP(Text)
  #define RIPIF(Test, Text)
  /*
  **           
  ** ASSERT may be defined elsewhere.  Define if it doesn't exist.
  */
  #ifndef ASSERT
    #define ASSERT(Test)
  #endif
#endif

/*
**  this structure can go away when its no longer used                
*/
typedef struct
    {
        ULONG X;
        ULONG Y;
    } WcsPoint;


/*
**  this structure can go away when its no longer used                
*/
typedef struct
    {
        short X;
        short Y;
    } DevPoint;


/*
/*  A rectangle should be a rectangle, not two points                 
/*  this type can go away when its no longer used
*/
typedef WcsPoint WcsRect[2];


/*
** A rectangle should be a rectangle, not two points                  
** this type can go away when its no longer used
*/
typedef DevPoint DevRect[2];



/*
** DDState enumerates the global state of the Device Driver.
*/

enum DDState
    {
        prd_Reset,                    /* not initialised             */
        prd_Ready,                    /* initialised and running     */
        prd_Error                     /* error and terminating       */
    };

/*
** Type definitions for Bitmaps; these are only definitions required
** by all components or by global data structures.
*/

typedef PB lpBitmap;



/*
** Type definition that describes the dimensions and orientation of the
** output media that we are drawing on.
*/
typedef struct
    {
    int    iRes;            /* The canvas resolution in dots per inch */
    int    nBitPlanes;      /* The number of color planes 1=BW, 3=color */
    int    nBitsPerPel;     /* Number of bits per pel */
    int    nGrayShades;     /* The number of distinct colors */
    RECTL  rcl;             /* Rectangle for the area that can be drawn on */
    RECTL  rclpt;           /* Area rectanlge in points*/
    RECTL  rclPaper;        /* Rectangle for the size of the physical paper */
    }CANVAS,  *PCANVAS;



typedef LHANDLE HHEAP;
