/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
#ifndef prdttypt_h_
  #define prdttypt_h_

/**************************************************************************
 *
 * SOURCE FILE NAME = PRDTTYPT.H
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION = V2.0
 *
 * DATE        : 06/01/88
 *
 * DESCRIPTION : Type declarations for text routines.
 *
 *               This header file is included in all C source modules in
 *               order to define the font handles and organization of the
 *               font and remap resources.
 *
 * FUNCTIONS
 *
 * NOTES
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/
/*
** Font Handles
**
** The first macro below is used for converting a small non-negative integer
** into a 32-bit handle that has its high bit set.  We use these macros in
** two ways:
**    (1) When an app queries fonts, we must give each font a unique lMatch
**        value that has the high bit set.  We simply use this macro to
**        convert the index of the font in the printer's list of all fonts
**        to a 32-bit handle.  (The engine requires that all device fonts
**        have the high bit in the handle set.)
**    (2) When an app creates a logical font, the engine asks us for a 32-
**        handle by which to refer to the logical font.  We use this macro
**        to convert the index of the logical font in our font info table
**        into a 32-bit handle.
** The reverse macro is also present so that we may convert a 32-bit handle
** back into the appropriate index.
*/

#define PS_FONTOFFSET  -100
#define OffsetToCookie(x)       (-(x) + PS_FONTOFFSET)
#define CookieToOffset(x)       (-((x) - PS_FONTOFFSET))


/*
** Font Resources
**
** A font resource consists of a header, global section, character metrics,
** kerning table, strings, and OS/2 font metrics structure.  Definitions of
** the first three sections appear below.  Both the kerning table and OS/2
** font metrics structure are defined by the OS/2 base, so the definition
** isn't repeated here.  The strings section is not defined, because it is
** not presently used by the driver; it is only present to hold a copyright
** notice.
*/

/*
** Font Resource Header
**
** The top of the font resource contains a header which holds offsets to
** the various parts of the resource.  Because the character metrics list,
** kerning table, and strings section are not necessarily the same size in
** every resource, this offset scheme is required in order for the driver
** to be able to find the various sections of the resource properly.
*/

typedef struct _FONTHEADER {
        SHORT  usVersion;              /* AFM file version             */
        SHORT  usGlobalOffset;         /* Offset to global font info   */
        SHORT  usCharMetricsOffset;    /* Offset to character metrics  */
        SHORT  usKerningDataOffset;    /* Offset to kerning table      */
        SHORT  usStringsOffset;        /* Offset to strings section    */
                                        /*   -- copyrights, etc.        */
        SHORT  usMetricsOffset;        /* Offset to font metrics struc */
        SHORT  usSectionsSize;         /* Size of above 5 sections     */
        } FONTHEADER, *PFONTHEADER;


/*
** Font Global Info
**
** This section contains parameters global to the font.
*/

typedef struct _FONTGLOBAL {
        SHORT  fVariablePitch;         /*fFixed or proportional spacing*/
        SHORT  sFontBBox[4];            /* Size of bounding box         */
        SHORT  usCapHeight;             /* Height of capital letters    */
                                        /*   -- 1000 x 1000 units       */
        } FONTGLOBAL, *PFONTGLOBAL;


/*
** Character Metrics
**
** The character metrics structure maintains information on the individual
** characters that make up the font.  Specifically, a display code and a
** width exist for each char.  The display code is the numeric value 1-255
** to output in a PostScript ()show command in order to display the desired
** character.  A value of zero here indicates that the character does not
** exist in the standard PostScript font, and that the driver must define a
** new font in the PostScript printer before the character can be displayed.
** The width is the width of the character's bounding box in Adobe style
** units (based on the 1000 x 1000 unit box).
*/

typedef struct _CHARDATA {
    BYTE  bPscriptCode ;                    /* used in show command */
    SHORT sWidthX ;                         /* width of character */
} CHARDATA, *PCHARDATA;


/*
** Font Resource Definition
**
** The structure below defines the font resource.  The structure only lists
** the header and global sections because the other sections are not always
** a fixed size.  The header contains offsets to the other sections of the
** resource, so that the driver will be able to locate them.
*/

typedef struct _FONTDEF {
        FONTHEADER      Header;
        FONTGLOBAL      Global;
        } FONTDEF, *PFONTDEF;          /* fdf


/*
** Font Remapping Code Resource
**
** The font remapping code resource contains a block of text strings that
** are downloaded to the PostScript printer when a font remap definition is
** called for.  This text was made a resource in order to keep driver memory
** consumption down.
*/

typedef struct _FONTREMAPCODE {
    SHORT    sOffsetRoutine ;           /* Offset to PostScript text    */
    SHORT    sNumGlyphNames ;           /* Number of glyph names here   */
    SHORT    sOffsetpGlyph ;            /* Offset to pointer to first   */
                                        /* glyph name. Others follow    */
    } FONTREMAPCODE,  *PFONTREMAPCODE ;         /* pfrc */

#endif
