/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "src/prntdd/pscript/inc/prdqcone.h, postscript, osdd, 13.355 90/08/21";*/

/**********************************************************************/
/*                                                                    */
/*   File            = PRDQCONE                                       */
/*                                                                    */
/*   Description     = Printer Device Driver query and escape         */
/*                     constants                                      */
/*                                                                    */
/*   Function        =                                                */
/*                                                                    */
/*   Reference       = Device Driver Interface Specification          */
/*                                                                    */
/*                                                                    */
/**********************************************************************/

/**********************************************************************/
/* Error codes                                                        */
/**********************************************************************/
#define PRDQERR           1700
#define OUT_DATA_SHORT    PRDQERR+0    /* not enough room in OutData  */

#define OPEN_DOCUMENT     PRDQERR+10   /* document already open       */
#define NO_DOCUMENT_NAME  PRDQERR+11   /* no name for document        */
#define NO_OPEN_DOCUMENT  PRDQERR+12   /* no document open            */
#define BAD_ESC_DOSWRITE  PRDQERR+13   /* error writing esc journal   */
                                       /* data                        */

/**********************************************************************/
/* Conversion between metric and imperial coordinate systems          */
/**********************************************************************/
#define METER_TO_INCH_NOM       3937
#define METER_TO_INCH_DENOM     100

#define INCH_TO_MILLI_NOM       254
#define INCH_TO_MILLI_DENOM     10

/**********************************************************************/
/* Escape codes.                                                      */
/**********************************************************************/
/* KH SEA4
************* defined in PMDEV.H *******************
#define QUERY_ESC_SUPPORT       1
#define START_DOC               2
#define END_DOC                 3
#define NEW_FRAME               4
#define NEXT_BAND               5
#define ABORT_DOC               6
#define DRAFT_MODE              7
#define FLUSH_OUTPUT            9
#define RAW_DATA                10
#define JOURNAL_DATA            32600
KH SEA4 */

/**********************************************************************/
/* Number of forms supported.                                         */
/**********************************************************************/
#define NUMBER_OF_FORMS         1

/**********************************************************************/
/* String Length of arguments to DevQueryDeviceNames                  */
/**********************************************************************/
#define ARG_DEVICE_NAME_LENGTH    32
#define ARG_DEVICE_DESC_LENGTH    64
#define ARG_DATA_TYPE_LENGTH      16
