/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
#ifndef prdptypt_h_
  #define prdptypt_h_

/****************************************************************************
 *
 * SOURCE FILE NAME = PRDPTYPT.H
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION = V2.0
 *
 * DATE        : --/--/--
 *
 * DESCRIPTION : Physical device instance data.
 *
 * FUNCTIONS
 *
 * NOTES       : Reference - Winthorn Functional Specification
 *                         - Device Driver Interface Specification
 *                         - Printer Device Driver Design Specification
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/#pragma pack(1)

/*            */
#ifndef INCL_GENPLIB_THREAD
  #define  INCL_GENPLIB_THREAD
  #include <genplib.h>
#endif


/*
**  change flags to use something smaller than BOOL                   
*/
#include "ppdialog.h"

#ifndef prdttypt_h_
  #include "prdttypt.h"
#endif
#pragma pack(1)

/*
** MACROS to use on flags
*/
#define SETFLAG( flag, bit )   ((flag) |= (ULONG)(bit))
#define CLEARFLAG( flag, bit ) ((flag) &= ~((ULONG)(bit)))
#define CHECKFLAG( flag, bit ) ((flag) & (ULONG)(bit))

/*
** The size of the text buffer that holds strings being prepared for
** a PostScript show() command.
*/

#define SHOW_BUFFER_SIZE  768L

/*
** The output channel descriptor.
*/
typedef struct _CN
    {
    ULONG fh;               /* The output file handle */
    BOOL  fChannelOpen;     /* TRUE if output channel has been opened. */
    BOOL  fChannelIsValid;  /* TRUE if the output channel is valid */
    BOOL  fChannelError ;   /* TRUE if error occurred writing to channel */
    BOOL  fUsed;            /* TRUE if no data has been written to channel */
    int   nbBuf;            /* The number of bytes in the buffer */
    char  abPrintf[200];    /* Temporary buffer for printf */
/*  char  abBuf[1024];      +* The output buffer */
#define ABBUF_SIZE 4096
    PCHAR abBuf;            /* Pointer to The output buffer */
    }CN,  *PCN;



#define     MAX_LOGADDRESS  256L
#define     SIZEOF_PSCRIPT  10L
#define     SIZEOF_PM_Q_RAW 11L
#define     MAX_COMMENT     80L
#define     MAX_QPROCNAME   32L
#define     MAX_QPROCPARM   128L
#define     MAX_SPOOLERPARM 50L
#define     MAX_NETWORKPARM 256L
#define     MAX_ESC_STR_LEN 256L                

/*
** this structure is included in the device structure.  it will
** hold the strings pointed to by the DEVOPENSTRUC.
*/
typedef struct _DV_DOP
    {
    CHAR        LogAddress[MAX_LOGADDRESS];
    CHAR        DriverName[SIZEOF_PSCRIPT];
    LDRIVDATA   DriveData;
    CHAR        DataType[SIZEOF_PM_Q_RAW];
    CHAR        Comment[MAX_COMMENT];
    CHAR        QueueProcName[MAX_QPROCNAME];
    CHAR        QueueProcParams[MAX_QPROCPARM];
    CHAR        SpoolerParams[MAX_SPOOLERPARM];
    CHAR        NetworkParams[MAX_NETWORKPARM];
} DV_DOP,  *PDV_DOP;


/*
** PostScript Fonts structure.  Should contain all we need to know
** about each font currently in the printer, whether hardware or
** downloaded.
*/

#define MAX_FONTS   255

/*
**  The names in the structure follow Adobe practice; the "Full Name" is
**  the normal title of the font (eg, "Stone Informal Bold Italic"), while
**  the "Font Name" is a PostScript object, all one word which must be sent
**  to the printer preceded by '/' ("/StoneInformal-BoldItalic").  We use the
**  Full Name exclusively from here 'upward' to the user and application: ie,
**  we display it in the installation dialog and the app uses it to select
**  a font.  However, the PS printer recognizes only the "Font Name" for
**  selecting a font, so the 'Font Name' is used exclusively 'downward' from
**  here to the printer.
*/

typedef _Packed struct _FNT
{
    PSZ     pszFullName ;       /* for display and user selection          */
    PSZ     pszFontName ;       /* command for printer                     */
    SHORT   usResource ;        /* resource # or 0 for soft font           */
    BOOL    bLoaded ;           /* if soft, already loaded?                */
    PSZ     pszOFM ;            /* file name, with path; 0L for hw font    */
    PSZ     pszPFB ;            /* file name, with path; 0L for hw font    */
} FNT, *PFNT;

typedef FNT  AFNT[];
typedef AFNT *PAFNT;

/*            */
typedef _Packed struct _CACHEDFONT
{
  LONG     lIndex;
  LONG     lUsageCount;
  PFONTDEF pFontDef;
} CACHEDFONT, * PCACHEDFONT;

#define NUMCACHEDFONTS 4

/*
**           
** These are the global structures need for the global font memory
*/

typedef struct _GLOBALFONT
{
  LONG lCount;        /* How many ofm files            */
  PSZ  pszFontFiles;  /* List of all font files in ini */
  PFNT pFNTList;      /* Global list of FNT structs    */

} GLOBALFONT, *PGLOBALFONT;

typedef struct _GLOBALDATA
{
  ULONG      cInstances;
  HMTX       hSem;
  HMCB       hMCB;
  GLOBALFONT FontData;
  LONG       BootDrive;

} GLOBALDATA, *PGLOBALDATA;


/*
** The DV (device) structure is allocated in the Fill_PDevice_Routine.
** One such DV structure will be allocated for each DC.  While a DC
** may have several DDC structures (due to saved DCs), there will
** always only be one DV for the DC.  Therefore, we want to put in
** the DV only those pieces of information about the DC for which we
** don't want to make duplicate copies when a DC is saved.
*/

typedef struct _DV
    {
    DEVOPENSTRUC dop;                 /* Device information struc        */
    CHAR         szSegName[MAX_FNAMESIZE];/* Info segment name               */
    /*
    **  name of the paper selected for various trays
    */
    SOURCE       sourcePaper;
    CHAR         szDefFont[32];       /* Name of printer's default font  */
    PB           szzFontsList ;       /* List of fonts printer offers    */
    PAFNT        paFonts ;            /* Ptr to array of PS Font strucs */
    SHORT        cFonts ;             /* Count of fonts */
    /*
    **  a structure to contain various print effect parameters
    */
    EFFECTS      effOutput ;
    /*
    **  Job properties set under job property dialog box
    */
    JOBPROP      jobProperties ;
    CN           cn;                  /* The output channel              */
    CANVAS       canvas;              /* The current media state         */
    BOOL         fDocStarted ;        /* 1 = Document has been started   */
    BOOL         fQMStartDocIssued ;  /* 1 = SplQMStartDoc issued        */
    CHAR         szDocName[256] ;     /* Name of document in progress    */
    /*
    **  A buffer for outputting strings
    */
    CHAR         chText[SHOW_BUFFER_SIZE] ;
    SHORT        shPageno ;           /*page sequence no for a multi page document*/
    SHORT        iCntCopies;          /*no of output copies to be produced*/
    /*
    **  type of destination : 0-System(LPT1 or COM1),1-Raw mode file,
    **                        2-Encapsulated postscript file
    */
    SHORT        iDestnType;
    CHAR         szDestnFile[MAX_FNAMESIZE]; /* Name of output file */
    /*
    **  name in ini where keywords for printer                        
    */
    CHAR         szKeyApp[MAX_KEYAPPSIZE];
    /*
    **  Supports PS printers                                          
    */
    CHAR         szInitString[MAX_ESC_STR_LEN];
    /*
    **  with multiple modes                                           
    */
    CHAR         szTermString[MAX_ESC_STR_LEN];
    /*
    **  to force PS mode when                                         
    */
    SHORT        usInitLength;
    /*
    **  using PS driver.                                              
    */
    SHORT        usTermLength;
    /*
    **  Job prop duplex mode                                          
    */
    SHORT        sDuplexMode;
    DV_DOP       dev_dop;
    /*
    **            This is numeric value the Spool data type
    */
    SHORT        usDataType;
    #define      PM_Q_STD        1
    #define      PM_Q_RAW        2

    BOOL         fInitStringSent;                        /*            */
    XFORM        xformPageState;                         /* DEF 51530  */
    /*           
    ** The total count of fonts that can be downloaded
    */
    LONG lFontCount;
    PVOID pDCHeap;            /* The base pointer for DC heap */
    SHORT sUseDLFonts;        /*            */

    /*
    ** ulGenFlags are a group of flags for BOOLEAN vars.
    ** Feel free to use them up.
    ** See top of file for handy macros
    */
    ULONG ulGenFlags;

      #define IS_DIRECT_PORT  0x00000001
      #define IS_OUR_BITMAP   0x00000002
    /***** use them up...
    * #define bit2     0x00000004
    * #define bit3     0x00000008
    * #define bit4     0x00000010
    * #define bit5     0x00000020
    *  .
    *  .
    * #define bit31    0x10000000
    ****************************/

    /*
    ** D74609 Three uses of usLanguageLevel
    ** (1) Read from ppd to set usLanguageLevel to 2 for Level 2 support for
    **     printer.  This is done in prde_fillpdb().  If the printer does not
    **     support level 2 this flag is set to 0.
    ** (2) If Level 2 is supported this flag which is stored in
    **     pddc->pdv->usLanguageLevel is set to 3 to turn on Ascii85Encode()
    **     from within FlushBuffer().
    ** (3) Again if Level 2 is supported this flag is set to 4 from within
    **     FlushBuffer() if the termination byte has been sent for
    **     RunLengthEncode().
    */
    USHORT       usLanguageLevel;
    PB           Compress85;  /* D74609 Buffer pointer for Ascii85Encode() */
    USHORT usPSLevel1;        /* D74609 True for L1 compat */
    BOOL   fAllocatedPatterns;/*            */

    /*            */
    HTHREAD hThread;          /* Second output thread handle for GENPLIB   */
    CACHEDFONT FontCache[ NUMCACHEDFONTS ];

    /* @V3.0GAMMA1
    ** The gamma correction table pointer
    */
    PBYTE pbGammaTable;

    /* @V3.1109317
    ** Scratch DC for bitmaps
    */
    HDC hdcScratch;

    } DV,  *PDV;

#endif
